(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22173,        789]
NotebookOptionsPosition[     12685,        469]
NotebookOutlinePosition[     18786,        665]
CellTagsIndexPosition[     18440,        648]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"System Administration for Network Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
         "System Administration for Single-User Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]\
}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"System Administration for Network Licenses\"\>", 
      2->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Launching ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " on Windows"
}], "Title",
 CellID->96713748],

Cell[CellGroupData[{

Cell[TextData[{
 "Launching ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Locally"
}], "Section",
 CellTags->{"locally", "i:1"},
 CellID->396316167],

Cell[TextData[{
 "To run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using a network license, both the client machine and the license server \
must be on the network, and ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " must be running. "
}], "Text",
 CellTags->"b:3.0",
 CellID->68966268],

Cell[CellGroupData[{

Cell[TextData[{
 "To launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "Subsection",
 CellTags->{"b:3.0", "i:3"},
 CellID->262519465],

Cell[TextData[{
 "From the ",
 StyleBox["Start", "MenuName"],
 " menu, choose ",
 StyleBox["Programs", "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuName"],
 StyleBox["Wolfram Mathematica", "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuName"],
 StyleBox["Mathematica 6", "MenuName"],
 "."
}], "Text",
 CellTags->"b:3.0",
 CellID->600388343],

Cell[TextData[{
 "Alternatively, you can open an Explorer window, go to the ",
 "Program Files\\Wolfram Research\\Mathematica\\6.0",
 " directory",
 ", and double-click the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " icon."
}], "Text",
 CellTags->"b:3.0",
 CellID->2704897]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "To launch only the ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "kernel:"
}], "Subsection",
 CellTags->{"i:4", "b:3.0"},
 CellID->7854150],

Cell[TextData[{
 "From the ",
 StyleBox["Start", "MenuName"],
 " menu, choose ",
 StyleBox["Programs", "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuName"],
 StyleBox["Wolfram Mathematica", "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuName"],
 StyleBox["Mathematica 6 Kernel", "MenuName"],
 "."
}], "Text",
 CellTags->"b:3.0",
 CellID->28520882],

Cell[TextData[{
 "Alternatively, you can open an Explorer window, go to the ",
 "Program Files\\Wolfram Research\\Mathematica\\6.0",
 " direc",
 StyleBox["tory",
  HyphenationOptions->{"HyphenationCharacter"->" "}],
 ", and double-click the MathKernel icon."
}], "Text",
 CellTags->"b:3.0",
 CellID->19021621]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "To launch the ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "kernel inside a command prompt window:"
}], "Subsection",
 CellTags->"b:3.0",
 CellID->181356881],

Cell[TextData[{
 "Open a command prompt window and change directory to the top-level ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " installation directory. Type ",
 StyleBox[".\\math", "InlineCode"],
 " and press ",
 StyleBox["Enter", "KeyEvent"],
 ". "
}], "Text",
 CellTags->"b:3.0",
 CellID->137159597]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Launching ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from a File Server"
}], "Section",
 CellTags->{"fs1", "i:2"},
 CellID->19989634],

Cell[TextData[{
 "You can also run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " directly from a file server, without installing files locally. To do this, \
install ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " on the file server and make the installation directory accessible to the \
client machines. Running ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from a file server differs from running a local copy in several ways. \
These differences and appropriate steps for working around them are listed",
 " ",
 "here."
}], "Text",
 CellTags->"b:5.0.1",
 CellID->368022348],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " fonts will not be available for use by other applications. It is therefore \
required that you manually install the fonts on your system. The fonts are \
found in ",
 "SystemFiles\\Fonts\\Windows",
 " in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " layout. To install these fonts so they can be used by all other Windows \
applications, open the Fonts control panel, choose ",
 StyleBox["Install New Font", "MenuName"],
 " under the ",
 StyleBox["File", "MenuName"],
 " menu, and specify the location of the fonts in the ",
 StyleBox["Add Fonts", "DialogElementName"],
 " dialog box that appears."
}], "BulletedText",
 CellTags->{"i:3", "b:5.0.1"},
 CellID->611837375],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["MathLink", "\[RegisteredTrademark]"], TraditionalForm]]],
 " libraries will not be available for use by other applications. Therefore, \
you need to copy the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " libraries to the appropriate locations on your system. For 32-bit Windows \
systems, the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " libraries consist of seven files: ml32i1.dll, ml32i2.dll, ml32i3.dll, \
mlmap32.mlp, mlshm32.mlp, mltcp32.mlp, and mltcpip32.mlp, which are located \
in SystemFiles\\Links\\MathLink\\DeveloperKit\\Windows\\SystemAdditions in \
the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " layout. Copy these files to the Windows\\System folder on Windows 98/Me, \
the WINNT\\System32 folder on Windows NT/2000, or the Windows\\System32 \
folder on Windows XP. For 64-bit Windows platforms, the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " libraries consist of twelve files: ml32i1.dll, ml32i2.dll, ml32i3.dll, \
mlmap32.mlp, mlshm32.mlp, mltcp32.mlp, and mltcpip32.mlp, which are located \
in SystemFiles\\Links\\MathLink\\DeveloperKit\\Windows\\SystemAdditions, and \
ml64i2.dll, ml64i3.dll, mlshm64.mlp, mltcp64.mlp, mltcpip64.mlp, which are \
located in \
SystemFiles\\Links\\MathLink\\DeveloperKit\\Windows-x86-64\\SystemAdditions. \
Copy the first seven files to the Windows\\Syswow64 folder and the other five \
files to the Windows\\System32 folder."
}], "BulletedText",
 CellTags->{"i:4", "b:5.0.1"},
 CellID->642006915],

Cell[TextData[{
 "The proper file associations will not be set up for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You can set these associations manually by using the ",
 StyleBox["Folder Options", "DialogElementName"],
 " dialog box under the ",
 StyleBox["Tools", "MenuName"],
 " menu of the Explorer window (under Windows NT/2000/XP). You will need to \
specify the MIME type as application/mathematica and the file extension as ",
 StyleBox[".nb", "InlineCode"],
 "."
}], "BulletedText",
 CellTags->{"i:5", "b:5.0.1"},
 CellID->445377139],

Cell[TextData[{
 "A ",
 StyleBox["Start", "MenuName"],
 " menu entry for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will not be created automatically. You can add this manually by editing \
the ",
 StyleBox["Start", "MenuName"],
 " menu settings in the dialog box that appears when you choose ",
 StyleBox["Settings \[FilledRightTriangle] Taskbar and Start Menu", 
  "MenuName"],
 " under the ",
 StyleBox["Start", "MenuName"],
 " menu."
}], "BulletedText",
 CellTags->{"i:6", "b:5.0.1"},
 CellID->783953]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Command-Line Options"
}], "Section",
 CellTags->{"i:14", "b:5.2", "net: 1"},
 CellID->17934518],

Cell[TextData[{
 "Following are several useful command-line options for the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. See ",
 ButtonBox["Launching ",
  BaseStyle->"Hyperlink",
  ButtonData->"locally"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->"locally"],
  FontSlant->"Italic"],
 ButtonBox[" on Windows: Locally",
  BaseStyle->"Hyperlink",
  ButtonData->"locally"],
 " for instructions on running the kernel."
}], "Text",
 CellTags->"b:5.2",
 CellID->572544563],

Cell[CellGroupData[{

Cell["Command-Line Options", "Subsection",
 CellTags->"b:5.2",
 CellID->84951584],

Cell[TextData[StyleBox["-lmverbose", "InlineCode"]], "IndentedText",
 CellTags->"b:5.2",
 CellID->25081235],

Cell[TextData[{
 "Prints diagnostic information to ",
 StyleBox["stderr", "InlineCode"],
 " on connecting to the license manager. This is useful for debugging",
 " ",
 "problems related to the license server."
}], "ItemizedTextParagraph",
 CellTags->"b:5.2",
 CellID->103626277],

Cell[TextData[StyleBox["-mathlink", "InlineCode"]], "IndentedText",
 CellTags->"b:5.2",
 CellID->295582807],

Cell[TextData[{
 "Specifies that the kernel should be run in ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " mode. See ",
 ButtonBox["www.wolfram.com/solutions/mathlink",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.wolfram.com/solutions/mathlink"], None}],
 " for additional information about ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "."
}], "ItemizedTextParagraph",
 CellTags->"b:5.2",
 CellID->42084700],

Cell[TextData[StyleBox["-noprompt", "InlineCode"]], "IndentedText",
 CellTags->"b:5.2",
 CellID->170354560],

Cell["\<\
Specifies that no banner or In/Out prompts should be printed. This mode is \
useful for running a sequence of commands from a batch file. \
\>", "ItemizedTextParagraph",
 CellTags->"b:5.2",
 CellID->382749677],

Cell[TextData[{
 StyleBox["-password ", "InlineCode"],
 StyleBox["str", "TI"]
}], "IndentedText",
 CellTags->"b:5.2",
 CellID->101924053],

Cell[TextData[{
 "Specifies a password to use instead of the password or passwords stored in \
the mathpass file. The password should have the form \"",
 StyleBox["!servername", "TI"],
 "\" or \"",
 StyleBox["machinename mathid licensenumber password", "TI"],
 "\"."
}], "ItemizedTextParagraph",
 CellTags->"b:5.2",
 CellID->43781355],

Cell[TextData[{
 StyleBox["-pwfile ", "InlineCode"],
 StyleBox["file", "TI"]
}], "IndentedText",
 CellTags->"b:5.2",
 CellID->100380140],

Cell["Specifies the name of a file that has a valid password.", \
"ItemizedTextParagraph",
 CellTags->"b:5.2",
 CellID->168437502],

Cell[TextData[StyleBox["-run", "InlineCode"]], "IndentedText",
 CellTags->"b:5.2",
 CellID->678930817],

Cell[CellGroupData[{

Cell["Takes a command to be run on startup as an argument.", \
"ItemizedTextParagraph",
 CellTags->"b:5.2",
 CellID->521451838],

Cell[TextData[{
 "The option ",
 StyleBox["-mathlink", "InlineCode"],
 " can also be used as a command-line option for the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end. "
}], "Text",
 CellTags->"b:5.2",
 CellID->32151979]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->388911513],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->13855348],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Launching Mathematica on Windows - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 18.5846468}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "To run Mathematica using a network license, both the client machine and \
the license server must be on the network, and MathLM must be running. From \
the Start menu, choose Programs > Wolfram Mathematica > Mathematica 6. \
Alternatively, you can open an Explorer window, go to the Program \
Files\\Wolfram Research\\Mathematica\\6.0 directory, and double-click the \
Mathematica icon.", "synonyms" -> {}, "title" -> 
    "Launching Mathematica on Windows", "type" -> "Tutorial", "uri" -> 
    "tutorial/LaunchingMathematicaOnWindows"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "locally"->{
  Cell[1716, 58, 157, 7, 70, "Section",
   CellTags->{"locally", "i:1"},
   CellID->396316167]},
 "i:1"->{
  Cell[1716, 58, 157, 7, 70, "Section",
   CellTags->{"locally", "i:1"},
   CellID->396316167]},
 "b:3.0"->{
  Cell[1876, 67, 376, 13, 70, "Text",
   CellTags->"b:3.0",
   CellID->68966268],
  Cell[2277, 84, 151, 7, 70, "Subsection",
   CellTags->{"b:3.0", "i:3"},
   CellID->262519465],
  Cell[2431, 93, 360, 12, 70, "Text",
   CellTags->"b:3.0",
   CellID->600388343],
  Cell[2794, 107, 284, 10, 70, "Text",
   CellTags->"b:3.0",
   CellID->2704897],
  Cell[3115, 122, 165, 7, 70, "Subsection",
   CellTags->{"i:4", "b:3.0"},
   CellID->7854150],
  Cell[3283, 131, 366, 12, 70, "Text",
   CellTags->"b:3.0",
   CellID->28520882],
  Cell[3652, 145, 309, 9, 70, "Text",
   CellTags->"b:3.0",
   CellID->19021621],
  Cell[3998, 159, 184, 7, 70, "Subsection",
   CellTags->"b:3.0",
   CellID->181356881],
  Cell[4185, 168, 313, 11, 70, "Text",
   CellTags->"b:3.0",
   CellID->137159597]},
 "i:3"->{
  Cell[2277, 84, 151, 7, 70, "Subsection",
   CellTags->{"b:3.0", "i:3"},
   CellID->262519465],
  Cell[5318, 214, 759, 21, 70, "BulletedText",
   CellTags->{"i:3", "b:5.0.1"},
   CellID->611837375]},
 "i:4"->{
  Cell[3115, 122, 165, 7, 70, "Subsection",
   CellTags->{"i:4", "b:3.0"},
   CellID->7854150],
  Cell[6080, 237, 1553, 34, 70, "BulletedText",
   CellTags->{"i:4", "b:5.0.1"},
   CellID->642006915]},
 "fs1"->{
  Cell[4547, 185, 163, 7, 70, "Section",
   CellTags->{"fs1", "i:2"},
   CellID->19989634]},
 "i:2"->{
  Cell[4547, 185, 163, 7, 70, "Section",
   CellTags->{"fs1", "i:2"},
   CellID->19989634]},
 "b:5.0.1"->{
  Cell[4713, 194, 602, 18, 70, "Text",
   CellTags->"b:5.0.1",
   CellID->368022348],
  Cell[5318, 214, 759, 21, 70, "BulletedText",
   CellTags->{"i:3", "b:5.0.1"},
   CellID->611837375],
  Cell[6080, 237, 1553, 34, 70, "BulletedText",
   CellTags->{"i:4", "b:5.0.1"},
   CellID->642006915],
  Cell[7636, 273, 554, 14, 70, "BulletedText",
   CellTags->{"i:5", "b:5.0.1"},
   CellID->445377139],
  Cell[8193, 289, 517, 17, 70, "BulletedText",
   CellTags->{"i:6", "b:5.0.1"},
   CellID->783953]},
 "i:5"->{
  Cell[7636, 273, 554, 14, 70, "BulletedText",
   CellTags->{"i:5", "b:5.0.1"},
   CellID->445377139]},
 "i:6"->{
  Cell[8193, 289, 517, 17, 70, "BulletedText",
   CellTags->{"i:6", "b:5.0.1"},
   CellID->783953]},
 "i:14"->{
  Cell[8747, 311, 163, 6, 70, "Section",
   CellTags->{"i:14", "b:5.2", "net: 1"},
   CellID->17934518]},
 "b:5.2"->{
  Cell[8747, 311, 163, 6, 70, "Section",
   CellTags->{"i:14", "b:5.2", "net: 1"},
   CellID->17934518],
  Cell[8913, 319, 516, 18, 70, "Text",
   CellTags->"b:5.2",
   CellID->572544563],
  Cell[9454, 341, 81, 2, 70, "Subsection",
   CellTags->"b:5.2",
   CellID->84951584],
  Cell[9538, 345, 107, 2, 70, "IndentedText",
   CellTags->"b:5.2",
   CellID->25081235],
  Cell[9648, 349, 278, 8, 70, "ItemizedTextParagraph",
   CellTags->"b:5.2",
   CellID->103626277],
  Cell[9929, 359, 107, 2, 70, "IndentedText",
   CellTags->"b:5.2",
   CellID->295582807],
  Cell[10039, 363, 436, 15, 70, "ItemizedTextParagraph",
   CellTags->"b:5.2",
   CellID->42084700],
  Cell[10478, 380, 107, 2, 70, "IndentedText",
   CellTags->"b:5.2",
   CellID->170354560],
  Cell[10588, 384, 219, 5, 70, "ItemizedTextParagraph",
   CellTags->"b:5.2",
   CellID->382749677],
  Cell[10810, 391, 137, 5, 70, "IndentedText",
   CellTags->"b:5.2",
   CellID->101924053],
  Cell[10950, 398, 334, 9, 70, "ItemizedTextParagraph",
   CellTags->"b:5.2",
   CellID->43781355],
  Cell[11287, 409, 136, 5, 70, "IndentedText",
   CellTags->"b:5.2",
   CellID->100380140],
  Cell[11426, 416, 130, 3, 70, "ItemizedTextParagraph",
   CellTags->"b:5.2",
   CellID->168437502],
  Cell[11559, 421, 102, 2, 70, "IndentedText",
   CellTags->"b:5.2",
   CellID->678930817],
  Cell[11686, 427, 127, 3, 70, "ItemizedTextParagraph",
   CellTags->"b:5.2",
   CellID->521451838],
  Cell[11816, 432, 241, 9, 70, "Text",
   CellTags->"b:5.2",
   CellID->32151979]},
 "net: 1"->{
  Cell[8747, 311, 163, 6, 70, "Section",
   CellTags->{"i:14", "b:5.2", "net: 1"},
   CellID->17934518]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"locally", 14297, 506},
 {"i:1", 14404, 510},
 {"b:3.0", 14513, 514},
 {"i:3", 15302, 542},
 {"i:4", 15513, 549},
 {"fs1", 15724, 556},
 {"i:2", 15827, 560},
 {"b:5.0.1", 15934, 564},
 {"i:5", 16441, 580},
 {"i:6", 16555, 584},
 {"i:14", 16667, 588},
 {"b:5.2", 16785, 592},
 {"net: 1", 18311, 641}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 940, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1565, 48, 126, 6, 70, "Title",
 CellID->96713748],
Cell[CellGroupData[{
Cell[1716, 58, 157, 7, 70, "Section",
 CellTags->{"locally", "i:1"},
 CellID->396316167],
Cell[1876, 67, 376, 13, 70, "Text",
 CellTags->"b:3.0",
 CellID->68966268],
Cell[CellGroupData[{
Cell[2277, 84, 151, 7, 70, "Subsection",
 CellTags->{"b:3.0", "i:3"},
 CellID->262519465],
Cell[2431, 93, 360, 12, 70, "Text",
 CellTags->"b:3.0",
 CellID->600388343],
Cell[2794, 107, 284, 10, 70, "Text",
 CellTags->"b:3.0",
 CellID->2704897]
}, Open  ]],
Cell[CellGroupData[{
Cell[3115, 122, 165, 7, 70, "Subsection",
 CellTags->{"i:4", "b:3.0"},
 CellID->7854150],
Cell[3283, 131, 366, 12, 70, "Text",
 CellTags->"b:3.0",
 CellID->28520882],
Cell[3652, 145, 309, 9, 70, "Text",
 CellTags->"b:3.0",
 CellID->19021621]
}, Open  ]],
Cell[CellGroupData[{
Cell[3998, 159, 184, 7, 70, "Subsection",
 CellTags->"b:3.0",
 CellID->181356881],
Cell[4185, 168, 313, 11, 70, "Text",
 CellTags->"b:3.0",
 CellID->137159597]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4547, 185, 163, 7, 70, "Section",
 CellTags->{"fs1", "i:2"},
 CellID->19989634],
Cell[4713, 194, 602, 18, 70, "Text",
 CellTags->"b:5.0.1",
 CellID->368022348],
Cell[5318, 214, 759, 21, 70, "BulletedText",
 CellTags->{"i:3", "b:5.0.1"},
 CellID->611837375],
Cell[6080, 237, 1553, 34, 70, "BulletedText",
 CellTags->{"i:4", "b:5.0.1"},
 CellID->642006915],
Cell[7636, 273, 554, 14, 70, "BulletedText",
 CellTags->{"i:5", "b:5.0.1"},
 CellID->445377139],
Cell[8193, 289, 517, 17, 70, "BulletedText",
 CellTags->{"i:6", "b:5.0.1"},
 CellID->783953]
}, Open  ]],
Cell[CellGroupData[{
Cell[8747, 311, 163, 6, 70, "Section",
 CellTags->{"i:14", "b:5.2", "net: 1"},
 CellID->17934518],
Cell[8913, 319, 516, 18, 70, "Text",
 CellTags->"b:5.2",
 CellID->572544563],
Cell[CellGroupData[{
Cell[9454, 341, 81, 2, 70, "Subsection",
 CellTags->"b:5.2",
 CellID->84951584],
Cell[9538, 345, 107, 2, 70, "IndentedText",
 CellTags->"b:5.2",
 CellID->25081235],
Cell[9648, 349, 278, 8, 70, "ItemizedTextParagraph",
 CellTags->"b:5.2",
 CellID->103626277],
Cell[9929, 359, 107, 2, 70, "IndentedText",
 CellTags->"b:5.2",
 CellID->295582807],
Cell[10039, 363, 436, 15, 70, "ItemizedTextParagraph",
 CellTags->"b:5.2",
 CellID->42084700],
Cell[10478, 380, 107, 2, 70, "IndentedText",
 CellTags->"b:5.2",
 CellID->170354560],
Cell[10588, 384, 219, 5, 70, "ItemizedTextParagraph",
 CellTags->"b:5.2",
 CellID->382749677],
Cell[10810, 391, 137, 5, 70, "IndentedText",
 CellTags->"b:5.2",
 CellID->101924053],
Cell[10950, 398, 334, 9, 70, "ItemizedTextParagraph",
 CellTags->"b:5.2",
 CellID->43781355],
Cell[11287, 409, 136, 5, 70, "IndentedText",
 CellTags->"b:5.2",
 CellID->100380140],
Cell[11426, 416, 130, 3, 70, "ItemizedTextParagraph",
 CellTags->"b:5.2",
 CellID->168437502],
Cell[11559, 421, 102, 2, 70, "IndentedText",
 CellTags->"b:5.2",
 CellID->678930817],
Cell[CellGroupData[{
Cell[11686, 427, 127, 3, 70, "ItemizedTextParagraph",
 CellTags->"b:5.2",
 CellID->521451838],
Cell[11816, 432, 241, 9, 70, "Text",
 CellTags->"b:5.2",
 CellID->32151979]
}, Open  ]],
Cell[CellGroupData[{
Cell[12094, 446, 72, 1, 70, "RelatedTutorialsSection",
 CellID->388911513],
Cell[12169, 449, 214, 5, 70, "RelatedTutorials",
 CellID->13855348],
Cell[12386, 456, 221, 5, 70, "RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[12658, 467, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

