(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    260637,       6324]
NotebookOptionsPosition[    240229,       5609]
NotebookOutlinePosition[    248692,       5875]
CellTagsIndexPosition[    248526,       5867]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"LayeredGraphPlot" :> 
         Documentation`HelpLookup["paclet:ref/LayeredGraphPlot"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"LayeredGraphPlot\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Hierarchical Drawing of Directed Graphs", "Title",
 CellTags->{"graphplot", "i:3", "b:0.1"},
 CellID->672278587],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 " attempts to draw the vertices of a graph in a series of layers, placing \
dominant vertices at the top, and vertices lower in the hierarchy \
progressively further down."
}], "Text",
 CellID->621106430],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LayeredGraphPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LayeredGraphPlot"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["i1", "TI"]], "->", 
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["j1", "TI"]]}], ",", 
       RowBox[{
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["i2", "TI"]], "->", 
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["j2", "TI"]]}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "generate a layered plot of the graph in which vertex ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["ik", "TI"]]], "InlineFormula"],
     " is connected to vertex ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["jk", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LayeredGraphPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LayeredGraphPlot"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["i1", "TI"]], "->", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["j1", "TI"]]}], ",", 
         SubscriptBox[
          StyleBox["lbl", "TI"], 
          StyleBox["1", "TR"]]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "associate labels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lbl", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " with edges in the graph"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LayeredGraphPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LayeredGraphPlot"], "[", 
     RowBox[{
      StyleBox["g", "TI"], ",", 
      StyleBox["pos", "TI"]}], "]"}], Cell[TextData[{
     "place the dominant vertices in the plot at position ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LayeredGraphPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LayeredGraphPlot"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "generate a layered plot of the graph represented by the adjacency \
matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"b:0.1",
 CellID->25485965],

Cell["Hierarchical graph drawing.", "Caption",
 CellTags->"b:0.1",
 CellID->164814425],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 " draws a graph so that the edges point predominantly downward. The second \
argument of ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 " specifies the position of the root. Possible values for this argument are \
",
 Cell[BoxData[
  ButtonBox["Right",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Right"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Top",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Top"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Bottom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bottom"]], "InlineFormula"],
 "."
}], "Text",
 CellID->872256052],

Cell["This plots a directed graph.", "MathCaption",
 CellID->185285925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", "\[Rule]", "3"}], ",", " ", 
     RowBox[{"5", "\[Rule]", "3"}], ",", " ", 
     RowBox[{"5", "\[Rule]", "4"}], ",", " ", 
     RowBox[{"6", "\[Rule]", "1"}], ",", " ", 
     RowBox[{"6", "\[Rule]", "2"}], ",", " ", 
     RowBox[{"6", "\[Rule]", "4"}], ",", " ", 
     RowBox[{"6", "\[Rule]", "5"}], ",", 
     RowBox[{"6", "\[Rule]", "3"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->188451088],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJx10w1ME3cUAPADKbBVIArCGCKDxJVAp7LNIAh7N4kMnWGLYFZlLBStGGBF
RpdQBwzc6gCdTNAwqisZCEMgA8rGBiPMQfhyMDcypMGhDSWErkNKvwT6td4Z
3gUTX17zz+967929/90Fp+ccFTgTBMF3/Kh1Y2hh4/r0cYLceNx93bc3/q/9
9Sk/oy/2e8bK1DXJOi5OgR2dfuVVrSjLht6lOP+K4rwVzc6ri3O6YEGv8akC
M+Ob71CJ3hwzIw3yXUXv4UT7pI08Rp+mw4RuoMsNaNW+y47Uo0Po0KH57K40
dhczzxvqKkc+Qvf+QoUGHUW1Uy2gqeo09jz6NTpUaHp7cpToca+LV0u+u4/2
zf7NkffQ/vk9e4E7gb6V8d+s8e7v6Cr6BgfQD9X3LO0J3cz+hY2VebKa8Hkm
31UMamrd1p8f0ZFAXYGxH319V7Qk6q9viTjG1naqgIUunOA4krGrTOgYyQX9
tXfg83vmNqGf7AdjurzQGf3R9uHc7cNO6C10MG5npTiSeb9rDYccacf5HsxQ
YUUHUu1yLegUuoEZLa2hYhX9J7U9kStow0CIQKk2oV3pBkbG9LwGtPFSaq9N
rEc/mU+Hpk+/uozm8RNFobe1EDrt3nc/sxuq/3G7kix1I6MT3hW87TMGfYWT
N1OD3MjukdxDRzynQKQ6sz+gwpXcXbl0/FqnEno8+pO/VLPICwEr+Wnl81Bh
UWo7d7HI9OKJki/Yi2BoG/Sq+MCF5KdBtCRABwucsx07xJvIJGFRk8jVBFmn
lJPpRc6ke2YjuzJ+DYoEvoUpQify8uCNfcHnzNCQT8pO+DmRb7rxckrKLJDU
OHIs/EeCfGm3ok0uskLpo+/rx98iSG5s4NoP+20gqZv3+kxmh1MRnMTSBzZ4
7ptwlme1DUbYphZuqh1qxricGLEVjo+Vedf9ZIfIiH8/9jhoAd+82c8XFu0w
e+fkcsna+vdOkOvfM6clrEi+bIeexmOHYwgjXG9tXhkdctRfM+drGvTwvktx
TvyndngYwdPlvaeDLHnzLCfADu0FWV2TPssw3BV2VCi1AU+TWR7cuwRntxB9
/lYr1Edlxx4+vQgZ/WEvh8VZ4cDctGRnqAZaRpvLa7Mt8Lqm62SnkxpiOcUa
sdgMnyQSU3rdPHjKrh8Yla9CYEykpFKggsdCGZu7eQWWZmL8eC8oYbWmNL5O
YoK5jJAXy3ynwTvohD48yAhHCs6MtxX8DQdtW7eOKvQQqqv+KmHoD6iI7KwT
y3Vwrrdm23jVIOjuRDfEti7DjrbWpOmBHvjw51v+24a0IPWI3Fvf3wT/Az1C
/3U=
    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.7}}], 
      ArrowBox[{1, 2}], 
      ArrowBox[{3, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25,
        26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 2}], ArrowBox[{3, 1}], 
      ArrowBox[{4, 5}], ArrowBox[{4, 6}], 
      ArrowBox[{4, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
        52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 1}], ArrowBox[{4, 3}], 
      ArrowBox[{4, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77,
        78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 
       95, 96, 97, 2}]}, {InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 1.}, {1., 0.}, {1., 2.}, {0., 3.}, {-2., 
     2.}, {-1., 2.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{237., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{241, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->600772132]
}, Open  ]],

Cell["", "Text",
 CellTags->"b:0.1",
 CellID->1531065410],

Cell["\<\
This is the same graph, with edges pointing from left to right.\
\>", "MathCaption",
 CellID->2038736600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", "\[Rule]", "3"}], ",", " ", 
     RowBox[{"5", "\[Rule]", "3"}], ",", " ", 
     RowBox[{"5", "\[Rule]", "4"}], ",", " ", 
     RowBox[{"6", "\[Rule]", "1"}], ",", " ", 
     RowBox[{"6", "\[Rule]", "2"}], ",", " ", 
     RowBox[{"6", "\[Rule]", "4"}], ",", " ", 
     RowBox[{"6", "\[Rule]", "5"}], ",", 
     RowBox[{"6", "\[Rule]", "3"}]}], "}"}], ",", "Left", ",", 
   RowBox[{"VertexLabeling", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1547345965],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{159, 212},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->112108469]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 " may produce slightly different output on different platforms, due to \
floating\[Hyphen]point differences."
}], "Text",
 CellTags->"b:0.1",
 CellID->379372821],

Cell[CellGroupData[{

Cell["Options for LayeredGraphPlot", "Section",
 CellTags->{"Options_for_GraphPlot", "b:0.1"},
 CellID->267311437],

Cell[TextData[{
 "In addition to options for ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", the following options are accepted for ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->66806916],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["DataRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DataRange"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the range of vertex coordinates to generate", "TableText"]},
   {
    ButtonBox["DirectedEdges",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DirectedEdges"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to show edges as directed arrows", "TableText"]},
   {
    ButtonBox["EdgeLabeling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EdgeLabeling"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to include labels given for edges", "TableText"]},
   {
    ButtonBox["EdgeRenderingFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EdgeRenderingFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function to give explicit graphics for edges", "TableText"]},
   {
    ButtonBox["MultiedgeStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MultiedgeStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to draw multiple edges between vertices", "TableText"]},
   {
    ButtonBox["PackingMethod",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PackingMethod"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "method to use for packing components", "TableText"]},
   {
    ButtonBox["PlotRangePadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRangePadding"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how much padding to put around the plot", "TableText"]},
   {
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style in which objects are drawn", "TableText"]},
   {
    ButtonBox["SelfLoopStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SelfLoopStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to draw edges linking a vertex to itself", "TableText"]},
   {
    ButtonBox["VertexCoordinateRules",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexCoordinateRules"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "rules for explicit vertex coordinates", "TableText"]},
   {
    ButtonBox["VertexLabeling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexLabeling"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to show vertex names as labels", "TableText"]},
   {
    ButtonBox["VertexRenderingFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexRenderingFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function to give explicit graphics for vertices", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.1",
 CellID->143533737],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 "."
}], "Caption",
 CellTags->"b:0.1",
 CellID->428527873],

Cell[CellGroupData[{

Cell["DirectedEdges", "Subsection",
 CellTags->"b:0.1",
 CellID->94783224],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["DirectedEdges",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectedEdges"]], "InlineFormula"],
 " specifies whether to draw edges as arrows. Possible values for this option \
are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". The default value for this option is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 "."
}], "Text",
 CellID->4330256],

Cell["\<\
This shows a graph with edges represented by lines instead of arrows.\
\>", "MathCaption",
 CellID->57501221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", "\[Rule]", "3"}], ",", 
     RowBox[{"5", "\[Rule]", "2"}], ",", 
     RowBox[{"5", "\[Rule]", "3"}], ",", 
     RowBox[{"5", "\[Rule]", "4"}], ",", 
     RowBox[{"6", "\[Rule]", "1"}], ",", 
     RowBox[{"6", "\[Rule]", "2"}], ",", 
     RowBox[{"6", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", " ", "False"}], ",", 
   RowBox[{"VertexLabeling", " ", "\[Rule]", " ", "True"}]}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->499064340],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 1.}, {2., 0.}, {1., 2.}, {1., 1.}, {0., 
    2.}, {-1., 1.}, {2., 1.}, {1.048359966512659, 1.951640033487341}, {
    1.1045509771617472`, 1.8954490228382528`}, {1.1685730319472645`, 
    1.8314269680527355`}, {1.240426130869211, 1.759573869130789}, {
    1.3201102739275867`, 1.6798897260724133`}, {1.4076254611223915`, 
    1.5923745388776085`}, {1.5029716924536256`, 1.4970283075463744`}, {
    1.6061489679212888`, 1.3938510320787112`}, {1.717157287525381, 
    1.282842712474619}, {1.776519338291659, 1.2185423901034025`}, {
    1.8288976183795516`, 1.1513492952006954`}, {1.8742921277890583`, 
    1.0812634277664972`}, {1.9127028665201793`, 1.0082847878008083`}, {
    1.9441298345729148`, 0.9324133753036284}, {1.9685730319472645`, 
    0.8536491902749577}, {1.9860324586432287`, 0.771992232714796}, {
    1.9965081146608072`, 0.6874425026231434}, {2., 0.6}, {2., 
    0.5135802469135802}, {2., 0.43209876543209874`}, {2., 
    0.3555555555555555}, {2., 0.2839506172839506}, {2., 
    0.21728395061728392`}, {2., 0.15555555555555553`}, {2., 
    0.09876543209876541}, {2., 0.04691358024691357}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {3, 4}, {3, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
        19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 2}, {3, 
        1}, {5, 6}, {5, 4}, {5, 1}}]}, {InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 1.}, {2., 0.}, {1., 2.}, {1., 1.}, {0., 
     2.}, {-1., 1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{232., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{236, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1519279838]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["EdgeLabeling", "Subsection",
 CellTags->"b:0.1",
 CellID->149979569],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["EdgeLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeLabeling"]], "InlineFormula"],
 " specifies whether and how to display labels given for the edges. Possible \
values for this option are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ". The default value for this option is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", which displays the supplied edge labels on the graph. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EdgeLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeLabeling"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the labels are shown as tooltips."
}], "Text",
 CellID->1357462998],

Cell["This displays the specified edge label.", "MathCaption",
 CellID->51376678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "\[Rule]", "6"}], ",", " ", "\"\<edge 3->6\>\""}], "}"}], 
     ",", 
     RowBox[{"4", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", " ", "True"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->317591580],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJx1lHtI01EUxzeXsjldL1uElL2w8tHLjBLbOdCsRUFhlBQl09JKpdQeVGY1
RUfaSy2CioL1cFJkKRTO0cvS1SrTSldmqSttqbWHy1xrtd+v/a70iw7nx+Vz
7zn3j/O939+ExG2xSV4cDifO/VErK/DPYoa/V2afCT7+vc/wP/WsPuZ82H/q
CXPU524UNsMvwolFs807Ul2Epxtywg05PwkLt6sWcvOdhB0JVMOPQb64nErC
ftGtp4PEA4RnTokKkOv6CSfT8Q10psNjs0ZnwrjIs6L93nYPF8OjZ6MKrBob
cJUSRcrai7Ap4oWhJt/qOa+A/sSXDstmC8jCw+KvS7WQtX6MeV+C2VP/ANpj
pBmP2r6A4yHk9VXqoTK5VR0b2uvpb4TUsa78k6puaI9Lbrj1sQn4KZeFxYs+
w9pJvHKxzQgrt+5X7/DpBAkoCu26bkiQQ1ReYAfU3xFD9F4LJB5sVCiFrbDA
mltTr+mD/MDvu+UFTWCay18ZebkfZhR/XXOy8jk0HrnQmxbtgCpdxpJlojoY
+LaqZFe2E6JkK5KWBmghPjNIGrvFBVPf8G+3pJTBVXpQfGT0WX6rUxnzmI+M
PqYSiTsFyOiTVTs9/pdWgIw+PLrBFxl9csOpQjd79PmzL0RGn809Hfb6QD9k
9Hn6hAo/ZPTp0awINqf6o2xOkeE21w7KrekZC1v9MVNvumG/YoPzXaHXaseL
0BiabvVNskJEcO7bPXNFeGbV5NOuMAtIQ3Y5141zs8yn7DnPDA22IaJ0gz8+
EIRJvF70QkvOjOGVG/2xPaD0e5DWPedmu3dwjR8eqchWOO6bYIMlrkdnE2Jd
R7mhqKsLNNwDDWkjfXEnz6V6HfwBFiuHxExbzcdjIkFB7NU28M35tMhV7YNT
+arAga9vwMsa0twt9UaB7sq68pGvYGaz3m4x8/BgVfy1Y8p6KJmlVw2764Vn
D68R53FqIZw77d3iCi7qRxzvyJ5cDT9iPpaequNg+h21s8+qJn5i+QdZ/kGW
f5DlH2T5B1n+QZZ/kOUfog/Dl+j2PsLGeUfdaSM8kQ4r4QThTbnw5uD/QUI/
rC+EtdVUdBOeT11n/ESY6pYLOwlH0GEkTI9nWxvhp0MLTyhKWwiL0+65s4nw
mN2aSAhrJFy2iXqYesL0szfVEH5vanJel1UNzi/kySGRtxp+A6w47cg=
    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.7}}], 
      ArrowBox[{1, 2}], 
      ArrowBox[{1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24,
        25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 3}], ArrowBox[{2, 3}], 
      ArrowBox[{4, 5}], 
      ArrowBox[{4, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
        51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 3}], ArrowBox[{5, 3}], 
      ArrowBox[{6, 5}], ArrowBox[{6, 2}], 
      {Arrowheads[{{0.5, 0.5, 
          GraphicsBox[{
            GrayLevel[0], 
            InsetBox[
             BoxData[
              FormBox[
               StyleBox["\"edge 3->6\"", StripOnInput -> False], 
               TraditionalForm]], {0, 0}, 
             ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
             GrayLevel[1]]}]}, {0.028937842778793417`, 0.8}}], 
       ArrowBox[{6, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 
        76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 3}]}}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {1., 1.}, {2., 0.}, {3., 2.}, {3., 
     1.}, {2., 2.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{271., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{275, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->770527606]
}, Open  ]],

Cell["\<\
This displays the labels as tooltips. Place the cursor over the edge between \
vertices 3 and 6 to see the tooltip.\
\>", "MathCaption",
 CellID->862272319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "\[Rule]", "6"}], ",", " ", "\"\<edge 3->6\>\""}], "}"}], 
     ",", 
     RowBox[{"4", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"EdgeLabeling", "\[Rule]", " ", "Automatic"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", " ", "True"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->228531803],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJx1lHtI01EUxzeXsjldL1uElL2w8tHLjBLbOdCsRUFhlBQl09JKpdQeVGY1
RUfaSy2CioL1cFJkKRTO0cvS1SrTSldmqSttqbWHy1xrtd+v/a70iw7nx+Vz
7zn3j/O939+ExG2xSV4cDifO/VErK/DPYoa/V2afCT7+vc/wP/WsPuZ82H/q
CXPU524UNsMvwolFs807Ul2Epxtywg05PwkLt6sWcvOdhB0JVMOPQb64nErC
ftGtp4PEA4RnTokKkOv6CSfT8Q10psNjs0ZnwrjIs6L93nYPF8OjZ6MKrBob
cJUSRcrai7Ap4oWhJt/qOa+A/sSXDstmC8jCw+KvS7WQtX6MeV+C2VP/ANpj
pBmP2r6A4yHk9VXqoTK5VR0b2uvpb4TUsa78k6puaI9Lbrj1sQn4KZeFxYs+
w9pJvHKxzQgrt+5X7/DpBAkoCu26bkiQQ1ReYAfU3xFD9F4LJB5sVCiFrbDA
mltTr+mD/MDvu+UFTWCay18ZebkfZhR/XXOy8jk0HrnQmxbtgCpdxpJlojoY
+LaqZFe2E6JkK5KWBmghPjNIGrvFBVPf8G+3pJTBVXpQfGT0WX6rUxnzmI+M
PqYSiTsFyOiTVTs9/pdWgIw+PLrBFxl9csOpQjd79PmzL0RGn809Hfb6QD9k
9Hn6hAo/ZPTp0awINqf6o2xOkeE21w7KrekZC1v9MVNvumG/YoPzXaHXaseL
0BiabvVNskJEcO7bPXNFeGbV5NOuMAtIQ3Y5141zs8yn7DnPDA22IaJ0gz8+
EIRJvF70QkvOjOGVG/2xPaD0e5DWPedmu3dwjR8eqchWOO6bYIMlrkdnE2Jd
R7mhqKsLNNwDDWkjfXEnz6V6HfwBFiuHxExbzcdjIkFB7NU28M35tMhV7YNT
+arAga9vwMsa0twt9UaB7sq68pGvYGaz3m4x8/BgVfy1Y8p6KJmlVw2764Vn
D68R53FqIZw77d3iCi7qRxzvyJ5cDT9iPpaequNg+h21s8+qJn5i+QdZ/kGW
f5DlH2T5B1n+QZZ/kOUfog/Dl+j2PsLGeUfdaSM8kQ4r4QThTbnw5uD/QUI/
rC+EtdVUdBOeT11n/ESY6pYLOwlH0GEkTI9nWxvhp0MLTyhKWwiL0+65s4nw
mN2aSAhrJFy2iXqYesL0szfVEH5vanJel1UNzi/kySGRtxp+A6w47cg=
    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.7}}], 
      ArrowBox[{1, 2}], 
      ArrowBox[{1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24,
        25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 3}], ArrowBox[{2, 3}], 
      ArrowBox[{4, 5}], 
      ArrowBox[{4, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
        51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 3}], ArrowBox[{5, 3}], 
      ArrowBox[{6, 5}], ArrowBox[{6, 2}], 
      TagBox[
       TooltipBox[
        ArrowBox[{6, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 
         76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 3}],
        "\"edge 3->6\""],
       Annotation[#, "edge 3->6", "Tooltip"]& ]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {1., 1.}, {2., 0.}, {3., 2.}, {3., 
     1.}, {2., 2.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{249., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{253, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1239534488]
}, Open  ]],

Cell[TextData[{
 "Alternatively, use",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["i", "TI"]], "->", 
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["j", "TI"]]}], ",", 
    StyleBox["lbl", "TI"]}], "]"}]], "InlineFormula"],
 " to specify a tooltip for an edge. Place the cursor over the edge between \
vertices 3 and 6, as well as the edge label on the edge between vertices 3 \
and 5, to see the tooltips."
}], "MathCaption",
 CellID->442920185],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "\[Rule]", "5"}], ",", 
       RowBox[{"Tooltip", "[", " ", 
        RowBox[{"\"\<edge 3->5\>\"", ",", "\"\<3->5\>\""}], "]"}]}], "}"}], 
     ",", 
     RowBox[{"Tooltip", "[", 
      RowBox[{
       RowBox[{"3", "\[Rule]", "6"}], ",", " ", "\"\<3->6\>\""}], "]"}], ",", 
     
     RowBox[{"4", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", " ", "True"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->403735836],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJx1lHtI01EUxzeXsjldL1uElL2w8tHLjBLbOdCsRUFhlBQl09JKpdQeVGY1
RUfaSy2CioL1cFJkKRTO0cvS1SrTSldmqSttqbWHy1xrtd+v/a70iw7nx+Vz
7zn3j/O939+ExG2xSV4cDifO/VErK/DPYoa/V2afCT7+vc/wP/WsPuZ82H/q
CXPU524UNsMvwolFs807Ul2Epxtywg05PwkLt6sWcvOdhB0JVMOPQb64nErC
ftGtp4PEA4RnTokKkOv6CSfT8Q10psNjs0ZnwrjIs6L93nYPF8OjZ6MKrBob
cJUSRcrai7Ap4oWhJt/qOa+A/sSXDstmC8jCw+KvS7WQtX6MeV+C2VP/ANpj
pBmP2r6A4yHk9VXqoTK5VR0b2uvpb4TUsa78k6puaI9Lbrj1sQn4KZeFxYs+
w9pJvHKxzQgrt+5X7/DpBAkoCu26bkiQQ1ReYAfU3xFD9F4LJB5sVCiFrbDA
mltTr+mD/MDvu+UFTWCay18ZebkfZhR/XXOy8jk0HrnQmxbtgCpdxpJlojoY
+LaqZFe2E6JkK5KWBmghPjNIGrvFBVPf8G+3pJTBVXpQfGT0WX6rUxnzmI+M
PqYSiTsFyOiTVTs9/pdWgIw+PLrBFxl9csOpQjd79PmzL0RGn809Hfb6QD9k
9Hn6hAo/ZPTp0awINqf6o2xOkeE21w7KrekZC1v9MVNvumG/YoPzXaHXaseL
0BiabvVNskJEcO7bPXNFeGbV5NOuMAtIQ3Y5141zs8yn7DnPDA22IaJ0gz8+
EIRJvF70QkvOjOGVG/2xPaD0e5DWPedmu3dwjR8eqchWOO6bYIMlrkdnE2Jd
R7mhqKsLNNwDDWkjfXEnz6V6HfwBFiuHxExbzcdjIkFB7NU28M35tMhV7YNT
+arAga9vwMsa0twt9UaB7sq68pGvYGaz3m4x8/BgVfy1Y8p6KJmlVw2764Vn
D68R53FqIZw77d3iCi7qRxzvyJ5cDT9iPpaequNg+h21s8+qJn5i+QdZ/kGW
f5DlH2T5B1n+QZZ/kOUfog/Dl+j2PsLGeUfdaSM8kQ4r4QThTbnw5uD/QUI/
rC+EtdVUdBOeT11n/ESY6pYLOwlH0GEkTI9nWxvhp0MLTyhKWwiL0+65s4nw
mN2aSAhrJFy2iXqYesL0szfVEH5vanJel1UNzi/kySGRtxp+A6w47cg=
    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.7}}], 
      ArrowBox[{1, 2}], 
      ArrowBox[{1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24,
        25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 3}], ArrowBox[{2, 3}], 
      ArrowBox[{4, 5}], 
      ArrowBox[{4, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
        51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 3}], ArrowBox[{5, 3}], 
      ArrowBox[{6, 5}], 
      {Arrowheads[{{0.5, 0.5, 
          GraphicsBox[{
            GrayLevel[0], 
            InsetBox[
             BoxData[
              FormBox[
               StyleBox[
                TagBox[
                 TooltipBox["\"edge 3->5\"", "\"3->5\""], 
                 Annotation[#, "3->5", "Tooltip"]& ], StripOnInput -> False], 
               TraditionalForm]], {0, 0}, 
             ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
             GrayLevel[1]]}]}, {0.028937842778793417`, 0.8}}], 
       ArrowBox[{6, 2}]}, 
      TagBox[
       TooltipBox[
        ArrowBox[{6, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 
         76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 3}],
        "\"3->6\""],
       Annotation[#, "3->6", "Tooltip"]& ]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {1., 1.}, {2., 0.}, {3., 2.}, {3., 
     1.}, {2., 2.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{258., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{262, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->698803506]
}, Open  ]],

Cell["", "Text",
 CellID->782609163]
}, Open  ]],

Cell[CellGroupData[{

Cell["EdgeRenderingFunction", "Subsection",
 CellTags->"b:0.1",
 CellID->229062904],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " specifies graphical representation of the graph edges. Possible values for \
this option are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", or a function that gives a proper combination of graphics primitives and \
directives. With the default setting of ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", a dark red line is drawn for each edge. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EdgeRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeRenderingFunction"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 ", edges are not drawn."
}], "Text",
 CellTags->"b:0.1",
 CellID->1564098284],

Cell["This draws vertices only.", "MathCaption",
 CellTags->"b:0.1",
 CellID->683565354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "10", "}"}], ",", 
     RowBox[{"{", "10", "}"}]}], "]"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", "None"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[7]:=",
 CellID->115400586],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmM9PE0EUx6dMwUNrxJsXDYn+G8Sbnrx4VrRBlMYfYGkUo9GYSEhMPJiQ
COFivAvEozGaePHSxESNofKjlKqgqULb3ZZ2bdY3s9vuzrDjjtiWgUjKbGfn
86Yz8953Z96eiMT7+y5H4tHeSNfxWGSwP9o71HVsIAa3cAAhlEAo0HEAwXcT
avQ/YZpwbU05QUpcXH1cyj6FD+okBS5lZ0z6hw5SapxS1crL3Py5UnaMUGNg
9e1Bbv4iaTrEUvlFuJtAnaSw6ldVojAUGBa6Da5tcO2QsgrSgviHOChh2yPs
3MH/+2lAP9j2Su0q550WRpGEBqCD4up9AuynFK+nP2vypPVLRtbQ3hn6RxQi
Ba5ob82qTpqiLkr/ciefuqJlhlGIFLiw2L+RfcZTxdXR8voTMq0QnRutv1aJ
qmlxjxQd5CIrKGVV03279IjYeFbTjtWJMp5duVf6/tDQZ0j0ziCsfb5VXnvF
Uxs/xrX0kCt6lwYNCPM6JbODTdKetMzN9eQp+KAQKXDuU0957Tlp6nJR4rGr
Qom86U37x0xj7XbT6NSKAP3ryPqsO36Tpyu5Nw4lo4QjtKf8wiVWCXPn6dZj
okcuCprs1bVGRes7kMLcTtDeRCvvXUclK5FyZNYDS9Ot8nJurpd7pp/dRO0D
+wkJbUzbKhvTlu9qmRGy34zAfpO6Xi2vkKawi9KWr238nHT2rkI6BiewTVRm
GFqdOdC6UhT7PPSjRbGjoh2WnpW30v2sgvbKydGt8mwhNVBYijmnpfx8n6G9
56lq+QX05USvoU/ZqglL6GSvaTLvA0Lc+4ApSoWtX6rnQiEuF5pmKTuvsubm
5FWqUGxE+dHtXETxWe32W4kyZzG9WSF+VqxCFPKpRESa9ew8zGXnUxIKsTL8
X8VZUKiTnRv6B7uPwy4ql+wBpTqKhVOdByXeDVWh/E4jjbQiagx6nEXEdO03
UD3m/axYhTSW3tqsW+hTZnfwprTMDSZuC+k4Q8lnI3Bm8z3D7YQ8g90j/Gjv
53ZzrETR2ci8Ymsj+7s1U8vz+YULTNxCnaFkFHCb9qRnRjkFnIHNgzR1uyjx
CXBnUezT2492nz2QtJV3DPtZecdwc6z8cxvxenhlbNvr3cJynH+3ah13XBTJ
w4/Ka0KYhzOjE+bhqkS7HMW+XWlOdO9WK0UVIczE3ZQ4E++W3kP+vUSB39pk
mjo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{204, 262},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[7]=",
 CellID->5215282]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EdgeRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeRenderingFunction"], "->", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 ", each edge is rendered with the graphics primitives and directives given \
by the function ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ". It can take three or more arguments in the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["g", "TI"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["i", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["j", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["i", "TI"]], ",", 
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["j", "TI"]]}], "}"}], ",", 
    SubscriptBox[
     StyleBox["lbl", "TI"], 
     StyleBox["ij", "TI"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["j", "TI"]]], "InlineFormula"],
 " are the coordinates of the beginning and ending points of the edge, ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["j", "TI"]]], "InlineFormula"],
 " are the beginning and ending vertices, and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["lbl", "TI"], 
   StyleBox["ij", "TI"]]], "InlineFormula"],
 " is any label specified for the edge or ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ". Explicit settings for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EdgeRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeRenderingFunction"], "->", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 " override settings for ",
 Cell[BoxData[
  ButtonBox["EdgeLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeLabeling"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DirectedEdges",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectedEdges"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->270347621],

Cell["\<\
This plots edges as gray arrows with ends set back from vertices by a \
distance of 0.3 (in the graphs's coordinate system).\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->22126029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "1"}], ",", 
     RowBox[{"11", "\[Rule]", "12"}], ",", 
     RowBox[{"12", "\[Rule]", "13"}], ",", 
     RowBox[{"13", "\[Rule]", "14"}], ",", 
     RowBox[{"14", "\[Rule]", "15"}], ",", 
     RowBox[{"15", "\[Rule]", "16"}], ",", 
     RowBox[{"16", "\[Rule]", "17"}], ",", 
     RowBox[{"17", "\[Rule]", "11"}], ",", 
     RowBox[{"1", "\[Rule]", "11"}], ",", 
     RowBox[{"2", "\[Rule]", "12"}], ",", 
     RowBox[{"3", "\[Rule]", "13"}], ",", 
     RowBox[{"4", "\[Rule]", "14"}], ",", 
     RowBox[{"5", "\[Rule]", "15"}], ",", 
     RowBox[{"6", "\[Rule]", "16"}], ",", 
     RowBox[{"7", "\[Rule]", "17"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", " ", 
        RowBox[{"Arrow", "[", 
         RowBox[{"#1", ",", "0.3"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[8]:=",
 CellID->445960829],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{
      {GrayLevel[0.5], 
       ArrowBox[{{0., 12.}, {0.36467963793781166`, 11.}}, 0.3]}, 
      {GrayLevel[0.5], ArrowBox[CompressedData["
1:eJxVlA1MU1cUxxHrZOOrtIW20E/avhLQDRmyKQ7PXBFBsIGMMJ1SECHCrKZE
N4YChRnCYBsq8mFBCZsoMkTdxqSAXqURYX4MkRQEFGgLrDJHNlaZxOneu1vS
7uS8vPzybs773f99eeKd+xLSnZ2cnBLIi7r/vwJAv3D5s/xl9Wj/JMu5akYO
xT9oBYeOXERnXQonRm7JoVfSnpOo7kC6A4rauy1yeCD7acj2bTeKDVCFaErl
IK0qTRU29aKronuN3bvkYNh5cqs86Gc0l6yzdYfLYSxyyUSx7300buoQZ3vK
QeuyI8ZqMqLylpDA/nEClM8mZzt+G0EvO5d4PmwhIPLrkhvK/ofo1KUYnkcx
AeOhXW+Wr5xAuc73Yg4kEzB2dnh3RdQkqmg9rmOEEcBt5haFhpnQ47ZK12k3
AmrCCwqyn5lQPmfw5JxJBknbX02NO2pGSqMy/o12kt3aiRt/m1HynAvR+IUM
ajaX9T+IsKDmtJd+8SkymL51IrnsfQu6c5sqKbT1fIPZFl3/Z3S9FMZLz2Pm
39TwbmqkkMa5jFmBSwob9l3DvOe6D9lSOFjeh/l4hLUiwioBj08HMHd1UiWB
50GjmM1vf0W2BBRNZsyuP6aQLQHfuBcOPv6gWPOKyu7jD9Jz7iq7jz/o61gq
u48/0Fh+KrsPyZ5ild1HDPovCZXdRwzSI0Equ48YFD7BKruPGDKa16nsPiJY
pgYHHxFo+QoHHxEMd0Y5+IjAfdNmBx8RCLq3YA7IG5DnDQjBNTAB8ye4hGAs
SMSMx/GEkGf4ALMPHiAAJ3oaZt0JqvgQsDUD8+MKaoN8uGrOxLyG2o6ZB9cv
qDF/XkIVD0KuaDAPF60kmwd0t48dfPzgw7pcBx8/YO0tcPDxg7WFhx18fOF7
fpWDDxfONEamERoLKkqpZHgCF2YTovcu9JDPr0U8yrVyoFDWoH2ROIVM+srn
Y5UcyOLH6cIF02hbrE69OpIDp9fGdbYKZ9DSnNhVhxfYEJzXYE7a9gsaXdcS
1dfCBo+paOZbd63IotNfpKWz4Z3sjTGxB2eR4Nj+PWEiNnle66PHDfP/+XjD
6r73ugqX29C5Oiofb6g+WnwsfNGGwi5R+bCgbKnLbbe6p2jDEJUPCxjC3t22
X5+iOx6vk/mwYIWlB7Mx6T6ZDxOGE2h4ffJ3OWQ+TGB/pMXzdgkEZD5MsK4I
x++z1hrIfBgQVxOKfZ4EZmZkZDDAOphSO5X6B1p+Zn5xxp0B1ZNXWATrd6Tb
EcPN6fCC84eqs95tm0NN8WoyYC9QGlmLzVlPUHDR9nmDvxcw++eHSjbNopA5
9oWCR3RYzAyljW6xotYa6nukA+20Mb8hbwY15pPL0+mwKn8kamxwCnk3MPmv
BdNB+9d6fF7//g/p8A9RTndC
        "], 0.3]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{0.36467963793781166`, 11.}, {1.36467963754302, 10.}}, 
        0.3]}, 
      {GrayLevel[0.5], ArrowBox[CompressedData["
1:eJxN1GtIU2Ecx/FhNtTZdLp5adNd3HJgiSnCCtLf5jL0hZZmFINQK5XogpXZ
hRGpYBpFohitTAlN7DYl0hcOskIlawhBNqiIml3OjKZkSXtR7fz34jx/njE+
sD3ne54zpq0+WnYgTCQSlQVf/LuovqeA2/UmX0SzDlM3Osivc04uBb4aMNPW
Ql5fJr55xG2AxHSSLLYNr7YNG9A+WEOuLjlhnLhiQKGnghz6ggH5MwXkvuWi
3uUiAxrsWeSmQdvPZzoDuCUl+Yu1NSz6jx6OdDHZ/ZIfPWRDixbev/iv9+rh
Eb0np0zXq6br9fBnviBbafSoyBknH3qSEFx6SKT3yV15XGcelwbZ4z6ya5yf
NNQUdpO9psvBlQZJ/yWyZLQyuNIgunnaIvTosDBynOnRod55mOnRoau7lunR
oby2iunR4YHWxvRoMTC5k+nRwlRewvRoUTezjenRwp2RzfRo0NmawfRoMOLX
Mz0aGPenMj0arMwnMj0aqI/JyEb7q3T7KzV6JRJyI40ap0bCybSdSo2hfX/N
vBNog1S4VT6y4xo/KfDvnif7OvkbTAHX/IG8ib8drwqunrfktgv8qFBz20P2
NG0ILhW4njmz0KOEteW1WehRonFPyKEeJZpT5pietXA43zE9yRgVf2B6knFo
7CPTkwTXk3mmJwkDhm9MTxKM3gWmJxHWgJ/pSUTg4DLTk4ji3D9MTwLcJVEW
oUeB6RWpRehRoHhHnEXokaPCJrcIPXJwCoVF6JFDfF7OPK943L0RxzyveHjq
YpjnFY/Ln0PXD/XEIefcb+Z8ZJgMX2TOR4aGdo45n1hYY73M+cRiY/c75nxi
sUUVOv/tgf7SQH8Mam/Nkv0/+JHCaXxOpu1MUiicT8mZtMEaOHJdZuH3HA2T
7xG57vunX7PKaPgCTnKgqiN78YQEw7V3yM385T1RuJg1QF5VOvaldWsUzlT0
kc9OZe7954qEfe46maP7i0TXw6tk+vhMBCa+d5LvZaVvlldGQNR0xSz8H0bg
P0grbW4=
        "], 0.3]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{1.36467963754302, 10.}, {2.364679637970994, 9.}}, 0.3]}, 
      {GrayLevel[0.5], ArrowBox[CompressedData["
1:eJxN1GtIU2Ecx/Hjpstlpea8telupdJFKynMyn6VQRJ4I4IQoozCICrT7IXZ
CwsqQiss1KIMtryjM0mnrtQ0LTMqI7ACXyhYk66WtUZZO//nzf/PM8YHdh6+
z+GcGbOPZh5QSJKU6fnI39L64fTO1zObJJrF2FLzlPw6vuCb+70ZP5XCyzNV
t448MyMyY4isyrL5ZNnMsJc+IWen5sf0XDaj3/GYLC4wI/ndIPn2j5SqHylm
rJ0aIBfXZH3vM5lxw/mIPJl8TjHvtwl5b/rJz4blMaG+rY88I19eZULs6Yfk
iMFc3WCuCbNxveRkGhO0w93kw70hnmXC2cwH5KtJzrIkpxGJfQ6yo0seIzZE
dpEnEko9y4iL+zvIfm17PcuItwdaWY8B2ytaWI8B/pPNrMeAuLQm1mNA7atG
1mNAYV4DOaZoJLpoRI/q2HrySRo9lvnUkWk7nR7qXzXkENogEj3SHfL1Snki
sGONlTxVJh8wAktuWsjr5ONM6JCaIHzhvDw6DKiER4tXeJYOJb4W1qOFdaOF
9WihrrawHi3ub7aynkWArob1hEMZUMt6wuEKr2M9YYhMrGc9YThxrIH1hGHW
0ch6QmHXN7GeUFgqmllPKLqjW1hPCL5XtrGeYIwttbOeYLw61cF6NHh5qZP1
aPBmfxfr0WDK1cV6guCd5mA9QYg56GA9QdiV5GA9C5FX18l6AjFt6GQ9gXCV
8Z4AnFV0sJ4AlB+2s54ArBppJ6e7rWluqz8y4oW/fJZnAVyXxPlpu4QFiPpw
jxxLG8xHVKt4nuNp/FDhJyyfLrpoLmZz75KPy8cZVGP3pLi/gTRq1OUIy2+/
T5YvPrlsrGcOosptrEeFnVttrEeFgr/NrMcHJY+a2fvlDfc14ZyP4zPPtd7Q
HxJ277uy+mu+En+ShM/It2NUgSuhwsq09slz2xQYmxbPS+FA7J5/Di+MvxB2
0v32QlWLMP18SILmmnDjyuhEzV4JKGxi/4cS/gPTV5u4
        "], 0.3]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{2.364679637970994, 9.}, {2.3646796376164048`, 8.}}, 0.3]}, 
      {GrayLevel[0.5], ArrowBox[CompressedData["
1:eJxNlHtMU2cYhyulLeXaY7lpW9qCSDUqDLaFLsD5Ca0ONsctLHHVsXGZ6JCl
zFEWZSAL3mKggcImbILzQlTMgHGXbDAMhXGR1BnKFKuQyCTKQApKGW5tj3+c
X74vJ88f35vnffOdT5r2RVKmA4PBSLJu25dhOCKbnHUAwx5/7L1ck7YQx8Td
sLwFy4wU47c+avRvZWJbEvt8zogUX4c0E+otjmCrGlmqRinIvy+cuF/viLQP
jsh6tFJsfbrFIzOEBdJ+QAp5RNx15z4W6syxteZYKbKNDqqRVDaK61WLff5S
3OpJ9rvB5uCx4qSD64oEWIpYutrOwciwLRJMqZ6ntB52guV96/FaCRr+qm/r
CeDijTtqoV4tQa16v8/wBBfqVIU1EnRK+PnjZc7oXvDO7vWWYHVmwDildIG/
552gAoMYmfpv5HOrLjAl5Gs0GjFe/Ppm9UqTK5rOifRqoRhNo7MWxyw3VM39
bi3gh8AcgcdIMg/LMnHJBakIrNjHeVVaHtRFpyoGTUIMFfeL5P08JAYp4ler
hdAIupmtZh4qRUkdbycLweXrZc5CApHpzaNHnYQ4fnDmbHgEgbiXGeV/dAlg
8hOFIIVA1/2DzIBDAgSEZa2XHiBQxuuVlngLsOfKQNg9NYHBikPP5n/biL4a
UpfzFYHqc7ZsQNVG2Hm2IupJRdQGcHUUy0unw0unfSFy2mnn06ds8cVYHsXG
4u3W5YtNDymWFRis8/GBryLazhp7fHDjJ4r1tnELffBolWLbdK0LcWwFzccL
PycpaD5e0FUqaD6eWBlV0Hw8YXqloPl4QhmopPnwsTVaSfPhQ5uipPnwoUlV
0nzWg/+hkuZDgJOopPkQ0MUpaT48dL+uT/nwUChX0nx4uLeD4gTLpXjLJQ8Y
/Cn+Z84Wd6R7UWwvF+6OUjbFO+wF3BA5RvUXZo8LHnRSbOsuqMAZP3xPca6t
HT0X+dkUE/ZY7/VbFNv+NpbKCScXY2g+HHRdiaH5sOEcH0PzYSP/aTTNh4WC
YztpPkwM794euNt6v5pY8qKi4w4oKVsYH8sg8KyiTVZoXIdryaUNLgkEZiav
bwsOXwe5jnnxRSiB2mnfs9o6BkITE2/q3Ah4XV7bdZFg4LszmqUpEw9aRUvX
qPd/5GfIS5y6ykNu277znYJXZF3untvln/MwVmsO54SukQrpWo55Ew/XGMfO
tO/9lxTf3KcreugO5UDL4HK6hRwwRE4Gl7sh9he3GUPFS/Lb0z92LH/sio7e
E1PvPVkmE0xHN9/d5QLtorj704wlMvhP4+ahWGcY3p340pNlJiVZLZ3GA1wU
9jZzM4aekwE17qa1OidU7m8oSGhfIOWHZ6reWeLAW9R/e2JgnvzkQdSj0gzO
6/dwnvwf+JIhnw==
        "], 0.3]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{2.3646796376164048`, 8.}, {3.3646796377600197`, 7.}}, 
        0.3]}, 
      {GrayLevel[0.5], ArrowBox[CompressedData["
1:eJxN1H9M1HUcx/HvfYEDMk8ODu/kDi7H9KiAZLQ40Py8GJUXyGSeO2hlegR3
35rr8gcGNoiAhYTeIiZTEO0HsrNgUS0l3RqgJxPICgKUBfEjfoZi/EihgO6+
H//4vPf+7vb84/vd4/Pd7bsx3bY7k+c4brfrcv9yXwhh/VM8OHGeAA7R/tI6
Pbzwsxb7ttFOq3l8W3+lFq9JaK+5tN+1WsQ0W8W+dnYiJX+jFn+/RztPvCEE
x6Nok8ny7ZPlIVgdsojtsevyWPGLITCepN1RIvNSzQbjw2jalWfcE4ySnkyx
p9y3bw9GcjbtWPuI3j6iQaeKdslx92igaswQ+3ZBhGs10Jpoh+V26nI71Rif
fUPsd8VR4x077daDGteqcTWM9voDza4NwpXbZsazASMfmBnPBhTvNDMeFWr1
ZsajAnnJzHhUMGaZGY8Sw04z41Hir5h0xqOErT2d8ayH8flMxhOI/Afs+wnE
x5UWxqNAwWYr41EgtcrKeBSQLVoZTwAcRGA8AdhkExhPAIqKBcbjj8qDAuOR
o8gqMB45ft8rMB4/fLZHYDx++C1JYDx+yEqgnbJUs2upZh0Kt9KeueceGVaj
aYuP08swGU47UnzAWjQpaUeLswY+Mtru0+lyH8P1ZXreQ+7jtPpiboy2XBxf
VNyk3eD1qmt9UH/Byni8oX/0/6YeKZ5LtDIeKRz+VsbjhcPxFsbjgYqnq16+
OcajfaDolEcej5YDcfUn+3iYHo7mlrZJsOD5gvGpGzy63jdNt6kkiJq/vPX8
RR4JWT2DzQKHI3EVlukiHoZv2i8NHlklTb0DXfI0HveNvo116hWi6CgrXBfK
I7cz0znu/I/YlF9njY5KcC98aKDs8L8kIvTb5WM/cbCI8w/pbem8UVrCIW9f
et3EyjxZdLzpr3udw47sSEn1p3Pkk+6jgzuTOLQ0tGUUJs2Szw1LW5ZTOMz4
xPRWrd4nT/LzHnobh7OS8YaOnBmi4zNeWb7A4cct3K9O6V1SbUiMSl7gkHD+
B1lo7RQp6a4t1e2VIDw54K0/UyfIXUeOcKJfguy4tSO+mjES2562Uv09D8W5
8tJrV4fJg2MxOYt5HhiKisFX4X+QTY2Bd87FekJtSozPT71DrhfMBdtHPdHt
2B8kfdhFuvt+2dHqeu/aPfMVOZpbxNRUb0qUS3Hqu4iLhmedxBD9UaKyTIqg
wb6e2bevkLpoS2gk7w3V5ltHnzntIPnN8UP2DO9H30OO+x/GukDl
        "], 0.3]}, 
      {GrayLevel[0.5], ArrowBox[CompressedData["
1:eJwtk3kw3AcAha37WHbXmTHL2svuIkPpOFLJ7xVDBBkbmVJK2Iwj7iFNhbQS
V1wbsiKJW2lEhVLpYFNBk07SSKtDdKLBjtSRLBHiKOJqmngzb968/75/PqYo
4Vi4ooKCAt71/Uri+OOzmv/fd6FDtn4hIMdHC86mmtePf0RHyRP13DO9Wvg0
+Y9W72g6QlmKnS0gQ2fX0+NlEx1u03HTloNk1P+SHsJbpoOge+u9SdSGws/x
qxquJhA+rMQ2Qwfmc4bk4nITpM2ciPOV6UD/WEqddMME3WdLy2ZvUdC/IOnK
CTVFfl/1P+FuVBz+NeLo2oApMg1Jxr0ZVLRMi4Y19Rm4eJPe5NhBhUzX2/d2
EAPXkt9IhmRUjHmx7i3eYKA9NX24cIuKhuJpwf0lBka6H8RHUmioWex3NWCa
QfPAwzCREQ2D1WVxekfM4LF0vuVrfRrkQyG6X5w2Q9H0slCqSsPLQmPbhRoz
iGUlzVFNVNi9DxOh9WmnKgqoGOherC0KZYIfyPQJiqHitd+AU42YiUnFbP9G
TypK1h9vh91h4nJVQ26GORU9TfJXT2eY+NgiZ0JOoiI+mqdG0mPhitCjp7uT
gnqHbO/xQyw02u6o90VREKKrdDc2moX6NZtvxw0pqH5bG9BaykKLdNXXf1R7
j4cNvqx/XPiNNjz4XtKMUDayhudoZabaGCY5VsSI2eitDJi36ibj796NkXkp
G8/saYna/mR8JipO0phh4686g/IDC1rwkm9G9tA4aJsIj/kpSwtdx52l5IMc
xCySplKNtFD9nTBiJZID1SG50qWbmtga+SThSwkHcI8SXn6lvsfDBVUndmFf
nDra8lSDIkO5sPqRwqiaVcOZi1zWTiEXEmu/CZNwNeRYFeeudXHhmmdvVzGm
iokU90t+U1ygR2pkIFRFZuxhO12KOXIHxsQF91SQoHb1KzsncxjfqSndsVHB
DU/roE6ROdbPK1rHVyqDa6cvqyowR4uTsmOUieIeDw+Wn3fVnI4lYZ6UInxy
goepih1nTocCTkXNbbbk89Cm9APj9cou8X2E2Pb+bR50DDNtniXtELe2gld1
R3l4Hn+umTyzRSRaBLtVKfBhoVNekn10k1hfyGeIOHzIl0en3Zo3CFefFzlh
7nyYmrnUH9ldI3xdklIrIvj4TfL746se/xLMPy3fUrL5YJfUOWz3LxEuBwNz
g/v4OLSiHmRvukA07h8MDlnjI61oKvA5T0741Ran6loIsL32NH6zfZJwLb0u
OxsgQFbQg/0a6eNEClmedyVDgGth5IaN8mFiWSXjnKhRgJPKyuLi5EdE+4WT
HZOPBPBbrXQejuskOtPFDvteCD54HtV694PvFvgPbRmt2g==
        "], 0.3]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{3.3646796377600197`, 7.}, {3.3646796376851427`, 6.}}, 
        0.3]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{-1.4281908988778014`*^-11, 13.}, {0., 12.}}, 0.3]}, 
      {GrayLevel[0.5], ArrowBox[CompressedData["
1:eJxNlG0022cYhzMr7al2OSWEiibkXe1FV0I/6N0NfV3XZs6oWuPMWKoSM2pD
6ak1bTGspOlaNUerXXSIlZR66eNlHTGOMqqhSJumRDpFkUSrnfx9+f/O7znP
c325z3V/edy+juNHWREIBP7ysdxYhIqmlYcHSPON4dueKZA0VMfZOM6FD9Pj
p8T8FsTVtaYaVFwounHVumRtF7p7/VdTgpwLpkqh2G5DPwq+HF1cncEFUt8b
v7SuIWRo9fzuZigXDo6qvu9weYwyqIaYUA8u8GsL6lhcHXKuKslrMnLAdi5c
fChXj/5MPDCqbuZAupQpjdg7hfaIjF9WSDjgkeTVenTfNGpOFt4nf8uBNZmb
eksEM6imp7auOYgDaquhpFDBLGLH6YhyBgeKtJHVOXtfInLozEA3gQNfbG48
s4Mxh85mDa/dMsyGV+on0wn6OZRoU1rZX82Giy8GZxiF80jzz54WZRYbmLGF
mcF+C6hzqOeTAQEbijZ09AtWm1DHeHnV+hYWkF5c/ZudYkJKT4XxHRkLPlLy
VOIxE6qbVr35I4YFs5FnHm3lmdH9j5fu2W5nwaFXuYSUU2b0dn7XZ272LIhK
Pejtf9eMAngV0ufPmEB+2p1y6j8zKjZyr4jqmSD2XtX7KXEREXkosjSHCcfi
5ngS+iKSzccafolgQrWkUhHosYi6uyxhwOkgJcbzu4vndhczgHi4AWPX9nhK
ezwD+G3NGAdgYcDnJ+9hHNviuFwGWOepMJb66wv89XQ4PtuFcWODJXQoKuvB
WOubu1w6nKzpxdj2dsRy6cCKHsD5uMOl6Ac4H3ewDhnE+biDkPcQ5+MOravV
OB93cOhQ43zcQPDjEM7HDUqchnE+bjAsH8b5uEECbwTnQ4Ow+hGcDw2q+aM4
HxqkE8ZwPjRobBvD+dBAdEWDMSetj53WR4W8rMcY/4CFCszcJxhj4yhU8Pxd
i7EjNmAThMnGMb58yRJX2KycwHiywLKgK/gU6zH2s6yjpcCJ4EmMM89ZQoGl
/hV+mPH+cilQRzPgfFxAwTPgfFxA42zA+bjAvvZJnM9GWN8/gfNxBkWd3Qcm
l0VEO37BjgjOsO7meTlxxozs7bePpuidgCmPov5cZkaJCbLXjy44gflWbr4o
0Ix2yApF3oFOcK5znVXNXyZ0InW/12kjGf6dGhMJ2CZEpyt2qsrJoKaueRAn
MiLfnKaqVVFkKPxKsk0nW0D1d5JjfWhkcJKHFKJr86hMrk05MuoINbe/mX1v
5CUabCs7cCvWEfx3hTXE+8wicZfeyvZdR1CG+y6MK6aRqPXaeWGJA3hPLAVq
86fQwPXB1507HWCIEv6Tq81zdCNJErBlgQSHQ7JL0+/okWZrhfC3chLUXswu
s6kYRxma/UeJx0gwNRKer9ToUE5yTJDEiwQEj7dHsoOfopX/kAT/A+zmmCU=

        "], 0.3]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{-0.6353203640317275, 4.}, {0.3646796360281144, 3.}}, 
        0.3]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{0.3646796360281144, 3.}, {1.3646796371101146`, 2.}}, 
        0.3]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{1.3646796371101146`, 2.}, {2.9241006467162123`, 1.}}, 
        0.3]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{2.9241006467162123`, 1.}, {2.924100646800241, 0.}}, 0.3]}, 
      {GrayLevel[0.5], ArrowBox[CompressedData["
1:eJxN039MzGEcB/CKdHffu9P14y5WiC0ZbvNbVj1vidEoCkOZH+sXyrmrO5yJ
MCppOGPStWP5OabpSHI44ox+SYhJlB8pHBdtouO+3+ef73uf7569tuf77P38
8QSvVcWneLi5ucH1setO68x3RcleLLmctcZuLHrghYxtE2Z17DhHDsfcNudO
FaCm4KRqReQNEpVkMKebBTgySTLF2F9DKnsfZc6CEJrzuQ/nVteR70NS38pe
CZHjq/ituPiU2O8ni5tzRQhYKlw+pquFXOl78CN/GoO8EsWelmNvSNj1woOT
/jBI6xlhObyinex1Xu1srBVDO7QmSHDyA9lfmhCvi5dgxynTiYreT+T5VYEu
7aYER5vPl1cldpH06GcJZSIpbpa3JQ1t/EJITFX3uAgpfkyNMj1LsJMkmznC
fbEUxRXpFm3Pd3K72jYvOE6Ku6Y5vZeiHWTdaMfgA0opHO039AZjD1kmmnww
2iFBqP5+TIjzJwlydHs16sXofKEcNXJ9Hxk59lBmW4gYMVvl1dkX/pDO0FUf
6l8z6DE5tV/tf4mqe4mqtITB+9hPCYUznKRSo2ViUxkE7W5cvKjgH7HeslS1
hjGoH7YyvFTlhsIGpX6BgsFE0tR2JtAdAacfzjc6Rag6ZTsSVeuOFLJ/Qp1d
hOR5EYnqHA9ckulCW7tEqKtlMxBPmrWclS27xrfs8sSaE9RFHdNdMwhJKdT2
b2wG4e5E6oV9ZXF9ZV4wDKAu90x0jQANL7I5y7gIobtMrQm0qQNtQuQVUDeN
3u4aEfTB2bw+Ylg8snl9JBj+MYvXRwrT4yxeHylmVmTx+gyGu5Ga+328N97m
UefnsfFGm446jDvQG/2p1F2GyM+GSBnOhFOncvHB3hBqeYbVNT4o6NdwZm+j
DvSF2Uq9mYsvBmZRh7LXa/LFFpmG18cPPkY1r48fmvzVvD5+uLZtE6+PP+7U
qzgXH2fjj8wg6tp8qWeAwx8Ruo2cB8RVftw3Ww7ly0zO5DN7gBxRc6hzlpWJ
w1vl2GzJ4HyvpHPhzmAF6iOpmWurXaPA3EcbOHPbixXoWEV9Ie1L+68GBUz/
1nOmrz0A/wGkN9GR
        "], 0.3]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{3.3646796376851427`, 6.}, {-0.6353203635601972, 5.}}, 
        0.3]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{-0.6353203635601972, 5.}, {-0.6353203640317275, 4.}}, 
        0.3]}}, GraphicsComplexBox[CompressedData["
1:eJxVmgk4Fd//x699516upWz32lu+bSpa551o0SrtKmlBfaMkKhXa9xJSX1La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      "], 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[PointBox[1],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[5],
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[6],
         "6"],
        Annotation[#, 6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[7],
         "7"],
        Annotation[#, 7, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[8],
         "11"],
        Annotation[#, 11, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[9],
         "12"],
        Annotation[#, 12, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[10],
         "13"],
        Annotation[#, 13, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[11],
         "14"],
        Annotation[#, 14, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[12],
         "15"],
        Annotation[#, 15, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[13],
         "16"],
        Annotation[#, 16, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[14],
         "17"],
        Annotation[#, 17, "Tooltip"]& ]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 12.}, {0.36467963793781166`, 11.}, {
     1.36467963754302, 10.}, {2.364679637970994, 9.}, {2.3646796376164048`, 
     8.}, {3.3646796377600197`, 7.}, {-1.4281908988778014`*^-11, 
     13.}, {-0.6353203640317275, 4.}, {0.3646796360281144, 3.}, {
     1.3646796371101146`, 2.}, {2.9241006467162123`, 1.}, {2.924100646800241, 
     0.}, {3.3646796376851427`, 6.}, {-0.6353203635601972, 5.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageMargins->{{0., 0.}, {0., 0.}},
  ImageSize->{126., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{130, 272},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[8]=",
 CellID->824377347]
}, Open  ]],

Cell[TextData[{
 "This displays edges and self-loops with black and red arrows, respectively. \
The function ",
 Cell[BoxData[
  ButtonBox["LineScaledCoordinate",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/LineScaledCoordinate"]], 
  "InlineFormula"],
 " from the ",
 ButtonBox["Graph Utilities Package",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/guide/GraphUtilitiesPackage"],
 " adds text at 70% along arrows",
 "."
}], "MathCaption",
 CellID->425797646],

Cell[BoxData[
 RowBox[{"<<", "GraphUtilities`"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->213900220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", " ", 
     RowBox[{"2", "\[Rule]", "3"}], ",", " ", 
     RowBox[{"3", "\[Rule]", "4"}], ",", " ", 
     RowBox[{"5", "\[Rule]", "1"}], ",", " ", 
     RowBox[{"5", "\[Rule]", "2"}], ",", " ", 
     RowBox[{"5", "\[Rule]", "3"}], ",", " ", 
     RowBox[{"5", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "3"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"First", "[", "#2", "]"}], "===", 
           RowBox[{"Last", "[", "#2", "]"}]}], ",", "Red", ",", "Black"}], 
         "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"#1", ",", ".1"}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", 
          RowBox[{"LineScaledCoordinate", "[", 
           RowBox[{"#1", ",", ".7"}], "]"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->300897750],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{243, 324},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->46665783]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MultiedgeStyle", "Subsection",
 CellTags->"b:0.1",
 CellID->82725606],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["MultiedgeStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MultiedgeStyle"]], "InlineFormula"],
 " specifies whether to draw multiple edges between two vertices. Possible \
values for ",
 Cell[BoxData[
  ButtonBox["MultiedgeStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MultiedgeStyle"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (the default), ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", or a positive real number. With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MultiedgeStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MultiedgeStyle"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", multiple edges are shown for a graph specified by a list of rules, but \
not shown if the graph is specified by an adjacency matrix. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MultiedgeStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MultiedgeStyle"], "->", 
   StyleBox["\[Delta]", "TR"]}]], "InlineFormula"],
 ", the multiedges are spread out to a scaled distance of ",
 Cell[BoxData[
  StyleBox["\[Delta]", "TR"]], "InlineFormula"],
 ". "
}], "Text",
 CellTags->"b:0.1",
 CellID->904561043],

Cell["\<\
By default, multiple edges are shown if a graph is given as a list of rules.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->239623524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", " ", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->82630293],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{138, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->266448109]
}, Open  ]],

Cell["\<\
But multiple edges are not shown for graphs specified by an adjacency matrix.\
\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->1229163597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "3", "0", "0", "0", "0"},
      {"1", "0", "1", "0", "0", "0"},
      {"0", "0", "0", "0", "1", "0"},
      {"0", "0", "0", "0", "1", "0"},
      {"1", "0", "0", "0", "0", "1"},
      {"0", "0", "0", "0", "0", "0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.28], {
          Offset[0.7]}, 
         Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], ")"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->127398837],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGDwA2IQjR18sIfQHA6ofAYH7DRMHp3GAA6oXIS6X1pnOvlY
V8D5919e+7PBYyecP9nuJRAdhvNXpr959PX8aThfsmKXqb3OJThfLOcgEF2D
88/yd09pXH4bzp+3sfu6ff4DON8YDB7D+dsSuIHoGZxv2ffYou/xCzh/z24Q
eA3ng503+R2cnwjSvg3hPyUw+ATng0yz6PsM5y/1/7XE/9cXOH/WTBD4ab9w
08pVzLNz7N0iV209/P8XlN9jfzKLpV0k6o99dcl/fiPxBfaK55bz9qz4C5Vf
Yx/QPMVT6/U/+77JIXelIrfZa7mmzv0uwOAAUX/AfvrHJQW5yxgcDr9ZeW7d
s6P27906530zZXSA6D9jb+wqpD55P6MDV/L/QAmpS/aJb+y5nJ2ZHI61T/x6
y+Sm/Q+DTXGz1ZgdlFzaLvqfv2/fcsLg18ufzA58Z94V7f7yyJ558+47entZ
HG4d9JZccfCpfdmHILasAlaHMuZbt3P9XtjfbfhWNluYzeHhhJm7eGa/srdI
WaZ3eBmbg0xW19aW5W/s22cl6T7UZHdQ619z5mrxO/uTytrFX+dg8tHVo5uH
bh+6e9Ddi+4fdP+ihwd6eKGHJ3p4o8cHenxhj09EfKOnB1h6SQODbzjTE3p6
Q0+P6OkVPT2jp3f0/ICeX9DzE3p+Q8+P6PkVPT+j53f08gC9vICVJwDBV6L3

    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.7}}], 
      ArrowBox[{1, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 
       24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
        42, 43, 2}], 
      ArrowBox[{2, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58,
        59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 
       76, 77, 78, 1}], ArrowBox[{2, 3}], ArrowBox[{3, 5}], ArrowBox[{4, 5}], 
      ArrowBox[{5, 1}], ArrowBox[{5, 6}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.}, {1., 3.}, {1., 2.}, {2., 2.}, {1., 
     1.}, {1., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{152., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{156, 228},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->113646454]
}, Open  ]],

Cell["This spreads multiple edges by the specified amount.", "MathCaption",
 CellTags->"b:0.1",
 CellID->585581490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", " ", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"MultiedgeStyle", "\[Rule]", "0.25"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->1115324],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{153, 204},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->1055638202]
}, Open  ]],

Cell[CellGroupData[{

Cell["PackingMethod", "Subsubsection",
 CellTags->"b:0.1",
 CellID->1079530539],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["PackingMethod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PackingMethod"]], "InlineFormula"],
 " specifies the method used for packing disconnected components. Possible \
values for the option are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (the default), ",
 Cell[BoxData["\"\<ClosestPacking\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<ClosestPackingCenter\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Layered\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<LayeredLeft\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<LayeredTop\>\""], "InlineFormula"],
 ", and ",
 Cell[BoxData["\"\<NestedGrid\>\""], "InlineFormula"],
 ". With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", 
   "\"\<ClosestPacking\>\""}]], "InlineFormula"],
 ", components are packed as close together as possible using a polyomino \
method [6], starting from the top left. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", 
   "\"\<ClosestPackingCenter\>\""}]], "InlineFormula"],
 ", components are packed starting from the center. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", "\"\<Layered\>\""}]], 
  "InlineFormula"],
 ", components are packed in layers starting from top left. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", "\"\<LayeredLeft\>\""}]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", "\"\<LayeredTop\>\""}]], 
  "InlineFormula"],
 ", components are packed in layers starting from the top/left respectively. \
With",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", "\"\<NestedGrid\>\""}]], 
  "InlineFormula"],
 ", components are arranged in a nested grid. The typical effective default \
setting is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", "\"\<Layered\>\""}]], 
  "InlineFormula"],
 ", and the packing starts with components of the largest bounding box area."
}], "Text",
 TextJustification->0.,
 CellID->1733232121],

Cell["\<\
This shows the packing of disconnected components by the default method.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->792188815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "\[Rule]", 
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"i", "^", "3"}], ",", "221"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "221"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->1585754271],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{173, 194},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->126691042]
}, Open  ]],

Cell[TextData[{
 "This shows the packing of disconnected components using the ",
 Cell[BoxData["\"\<ClosestPackingCenter\>\""], "InlineFormula"],
 " method",
 "."
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->134849000],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "\[Rule]", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"i", "^", "3"}], ",", "221"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "221"}], "}"}]}], "]"}], ",", 
   RowBox[{"PackingMethod", "\[Rule]", "\"\<ClosestPackingCenter\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->439127616],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{165, 168},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->576496207]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PlotRangePadding", "Subsection",
 CellTags->"b:0.1",
 CellID->155567426],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotRangePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRangePadding"]], "InlineFormula"],
 " is a common option for graphics functions inherited by ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1145219532]
}, Open  ]],

Cell[CellGroupData[{

Cell["PlotStyle", "Subsection",
 CellTags->"b:0.1",
 CellID->43937672],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " is a common option for graphics functions inherited by ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 ". The option ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " specifies the style in which objects are drawn."
}], "Text",
 CellTags->"b:0.1",
 CellID->680585317],

Cell["\<\
Draw edges with thicker arrows, and both edges and vertices labels in red.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->58817067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"6", "\[Rule]", "5"}], ",", 
     RowBox[{"7", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "4"}], ",", 
     RowBox[{"9", "\[Rule]", "8"}], ",", 
     RowBox[{"10", "\[Rule]", "8"}], ",", 
     RowBox[{"8", "\[Rule]", "3"}], ",", 
     RowBox[{"12", "\[Rule]", "11"}], ",", 
     RowBox[{"13", "\[Rule]", "11"}], ",", 
     RowBox[{"11", "\[Rule]", "1"}], ",", 
     RowBox[{"15", "\[Rule]", "14"}], ",", 
     RowBox[{"16", "\[Rule]", "14"}], ",", 
     RowBox[{"14", "\[Rule]", "2"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Arrowheads", "[", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.1", ",", "0.8"}], "}"}], "}"}], "]"}], ",", 
      RowBox[{"Thickness", "[", "0.02", "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[16]:=",
 CellID->793185],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{161, 201},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[16]=",
 CellID->331166597]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SelfLoopStyle", "Subsection",
 CellTags->"b:0.1",
 CellID->84930587],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["SelfLoopStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelfLoopStyle"]], "InlineFormula"],
 " specifies whether and how to draw loops for vertices that are linked to \
themselves. Possible values of the option are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (the default), ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", or a positive real number. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SelfLoopStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelfLoopStyle"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", self-loops are shown if the graph is specified by a list of rules, but \
not by an adjacency matrix. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SelfLoopStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelfLoopStyle"], "->", 
   StyleBox["\[Delta]", "TR"]}]], "InlineFormula"],
 ", the self-loops are drawn with a diameter of ",
 Cell[BoxData[
  StyleBox["\[Delta]", "TR"]], "InlineFormula"],
 " (relative to the average edge length). "
}], "Text",
 CellID->988897229],

Cell["\<\
By default, self-loops are displayed for a graph specified by a list of \
rules.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->1974872317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "\[Rule]", "2"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "3"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}], ",", 
     RowBox[{"5", "\[Rule]", "2"}], ",", 
     RowBox[{"6", "\[Rule]", "1"}], ",", 
     RowBox[{"6", "\[Rule]", "2"}], ",", 
     RowBox[{"6", "\[Rule]", "3"}], ",", 
     RowBox[{"6", "\[Rule]", "4"}], ",", 
     RowBox[{"6", "\[Rule]", "5"}], ",", 
     RowBox[{"1", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->591463435],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJx1lQ08lOkWwGcwMyJxlyglq7qxhSXfZTsP6eYjqkX5yMZEKaJQm5Zq6yJU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    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{3, 4}], 
      ArrowBox[{3, 1}], {
       ArrowBox[{4, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 
        26, 27, 28, 29, 30, 31, 32, 33, 34, 4}], 
       ArrowBox[{4, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 
        49, 50, 51, 52, 53, 54, 55, 56, 57, 4}]}, ArrowBox[{5, 4}], 
      ArrowBox[{5, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72,
        73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 2}], 
      ArrowBox[{6, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98,
        99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 4}], 
      ArrowBox[{6, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121,
        122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 
       136, 137, 138, 139, 140, 141, 142, 143, 144, 2}], 
      ArrowBox[{6, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156,
        157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 
       1}], ArrowBox[{6, 3}], ArrowBox[{6, 5}]}, {InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 1.}, {2., 0.}, {0., 2.}, {1., 1.}, {2., 
     2.}, {1., 3.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{203., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{207, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->821832375]
}, Open  ]],

Cell["\<\
Self-loops are not shown if the graph is specified by an adjacency matrix.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->1548899949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0"},
       {"1", "0", "0", "1", "0", "0"},
       {"0", "0", "0", "2", "0", "0"},
       {"0", "1", "0", "1", "0", "0"},
       {"1", "1", "1", "1", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[0.7]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->693886729],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJx1lQtQE2cQx/PgciBGqLwsio44LVQpxRaJ2LTfilgfIzitRKGYFjBRK474
wKm0QUcdaiFq1Kg81CAgFh0V1ClajF4UqVSliAIiYkkNImmoQkgQyIMmMfky
6HRnb+5+3+3e3d7u/25yStpXQgaNRhNZNut+pPUg+wG8dWrEuiPurfg3zrv+
z3oPNXL9zTjXN+Pfuk+Z7Lz4IRrG6yn7P+5JTzVjDm3Z8WHLDhNm903Fc+g/
GTEPJVsTDE4+sdjqmEdznxRM8h3EHBY0yzup9hXmlTbrx1xqS9dhVs3ca/E+
zIE202JOdq9Mcq901vW5WmrxF5jlV6ymwRxpvZyqC7M1O8m9E/MnNlNhtr2e
NCXmOg/xwe2/PMbsu/a6xZsxv7ulagYKuY/51Krup/r6O5iltgesxtyubjZW
zP/N+f6m3s0eQ5ShsV1rkor+7kYMPjsk/CgJMYbEXcoINfpum8az7X0SLkQ+
SL863IEiVhWce1XIAii5FzyTq0Srvf2JXSQLXqaVfVHU0oSGf1rjncMnIKX9
+/3j4SYyXBO30YpdoLlh8uwvc0qp5fJMvqaRCY3sAfHKI/eowG2Qu6CfAf5i
KmWerJ2KJRuzx7MYsJP/0C9vtIriS49/O1tCh1T3a9F3Dzyjamc10wc86RBd
7zVTkfyckpjS1yMxDTxPtfRuyuiihJcGl35kHEZ1eaM3Pn/URQlOPxbSH5iR
SFZ+2X9nFxXQKGHrC0xoQtX1Gvbm59TecN/YUXFGVK6JyleUP6Mu31kXNNs8
hOx9oQryrTaI7H2h7rXUaAo5A8jeF0pXHShUqvuRvS8UK7GCSKzQI3tfKJZs
nSVUh+x9ofS7+XJzRh+y94W6H5RpcS2y94WyhR/sRfa+UPHJsenBih5UvEd5
5ezhXpTbRu6PKyCBdDu9NntHH7qW2XSCP4mE0I3Lx0qr9ShdtfrT8RIWjPvj
1ZnbCQOoin0jbo+agGq2iBs214AkRmXPxVACpoNaUZ1lRrryGg/JNy4QVjHp
2A02HbqC1p+fmMGEqRwUN4vJhFSBsillKwNcZjwgFkwhYKvQNzNxHR1upcQe
9bxKQOkWkH3tR4fjzDOXFNEsWHKyljftVxrs8+tellDFgp9fnCupm0eDw7Ix
ma0BJGQVd3rslA2jC3leQdFpJLgdm0aMyTWjDsLAO3yOhPy7IUHcDBMK6bzp
1vCYBM70fzaz5xqROHJDlK6fhKe3V/RuHxrC3ymHnqU8H/RogISqk7yFXJoe
xSzlGQUqS/4hwxZNaR8KZSg4JRQJ7dPjtZuWaVFEAq9XuoeEClFqZZN3LxIk
+nzAiSEhXrMmZ7L8JbrsSmvfbWZBSeTazxau/BeFJ/t4HSpiQVRHa9Z7wRrU
LODVLI5gQbimcsVFuhoVein0cjkBP8bSHvZpO5FrfUyR4JELBHA5WQeEKiTi
1BO+LBd4+YTrFz9OiUyLoqc0RDGhY1Wgf7ZvK8rxODt4SMKARaLVdeWiRjRl
m1u2oJsOwdrcffN//xPVHklo4CbQ4Qd5vk+dtAZlCI/dn9hMg4nlZ5a0Vlch
Tlvj7lEraFDA5swouVGGv79x9daBJcHB5+dbJ9PJfra5ZWHOimwoos1xsqnC
mkBgzrQNrJNfz7cL5jyvgFFhHUzMr3Xk5NfzzsC8ccKtDRNu0TG/YzMnW9VE
JDr/Q4W6BRYfxvX99cRqJswB1sttMGK2yZEwYHbo2cEOPTvYoWdcn13PI+vV
YXboeWR9WswOPTvYoef/AN2UxGU=
    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{3, 1}], ArrowBox[{3, 4}], 
      ArrowBox[{5, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26,
        27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 2}], ArrowBox[{5, 4}], 
      ArrowBox[{6, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52,
        53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 1}], 
      ArrowBox[{6, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78,
        79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 
       96, 97, 98, 2}], ArrowBox[{6, 3}], 
      ArrowBox[{6, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 
       111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 
       4}], ArrowBox[{6, 5}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 1.}, {2., 0.}, {0., 2.}, {1., 1.}, {2., 
     2.}, {1., 3.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{188., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{192, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->1533564267]
}, Open  ]],

Cell["\<\
This shows self-loops with diameter equal to 0.3 times the average length of \
the edges.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->735821658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "\[Rule]", "2"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "3"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}], ",", 
     RowBox[{"5", "\[Rule]", "2"}], ",", 
     RowBox[{"6", "\[Rule]", "1"}], ",", 
     RowBox[{"6", "\[Rule]", "2"}], ",", 
     RowBox[{"6", "\[Rule]", "3"}], ",", 
     RowBox[{"6", "\[Rule]", "4"}], ",", 
     RowBox[{"6", "\[Rule]", "5"}], ",", 
     RowBox[{"1", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"SelfLoopStyle", "\[Rule]", "0.3"}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[19]:=",
 CellID->51804372],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{184, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[19]=",
 CellID->93836031]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["VertexCoordinateRules", "Subsection",
 CellTags->"b:0.1",
 CellID->405721262],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["VertexCoordinateRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexCoordinateRules"]], "InlineFormula"],
 " specifies the coordinates of the vertices. Possible values are ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", or a list of coordinates. Coordinates specified by a list of rules are \
not currently supported by ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->544211538],

Cell["This draws the Petersen graph using known coordinates.", "MathCaption",
 CellTags->"b:0.1",
 CellID->369012665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   TagBox[
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "3"}], ",", 
      RowBox[{"1", "\[Rule]", "4"}], ",", 
      RowBox[{"2", "\[Rule]", "4"}], ",", 
      RowBox[{"2", "\[Rule]", "5"}], ",", 
      RowBox[{"3", "\[Rule]", "5"}], ",", 
      RowBox[{"6", "\[Rule]", "7"}], ",", 
      RowBox[{"7", "\[Rule]", "8"}], ",", 
      RowBox[{"8", "\[Rule]", "9"}], ",", 
      RowBox[{"9", "\[Rule]", "10"}], ",", 
      RowBox[{"6", "\[Rule]", "10"}], ",", 
      RowBox[{"1", "\[Rule]", "6"}], ",", 
      RowBox[{"2", "\[Rule]", "7"}], ",", 
      RowBox[{"3", "\[Rule]", "8"}], ",", 
      RowBox[{"4", "\[Rule]", "9"}], ",", 
      RowBox[{"5", "\[Rule]", "10"}]}], "}"}],
    Short[#, 1000]& ], ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    TagBox[
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.30901699437494745`", ",", "0.9510565162951535`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.8090169943749476`"}], ",", 
         RowBox[{"-", "0.587785252292473`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.30901699437494723`", ",", 
         RowBox[{"-", "0.9510565162951536`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.8090169943749473`"}], ",", "0.5877852522924732`"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.6180339887498949`", ",", "1.902113032590307`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.6180339887498947`"}], ",", "1.1755705045849465`"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.6180339887498951`"}], ",", 
         RowBox[{"-", "1.175570504584946`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.6180339887498945`", ",", 
         RowBox[{"-", "1.9021130325903073`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", "0"}], "}"}]}], "}"}],
     Short[#, 1000]& ]}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[20]:=",
 CellID->533487069],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.30901699437494745`, 
    0.9510565162951535}, {-0.8090169943749476, -0.587785252292473}, {
    0.30901699437494723`, -0.9510565162951536}, {-0.8090169943749473, 
    0.5877852522924732}, {1., 0.}, {0.6180339887498949, 
    1.902113032590307}, {-1.6180339887498947`, 
    1.1755705045849465`}, {-1.6180339887498951`, -1.175570504584946}, {
    0.6180339887498945, -1.9021130325903073`}, {2., 0.}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.026125864888093667`, 0.8}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 3}], ArrowBox[{1, 6}], ArrowBox[{2, 5}], 
      ArrowBox[{2, 8}], ArrowBox[{3, 9}], ArrowBox[{4, 3}], ArrowBox[{4, 5}], 
      ArrowBox[{4, 7}], ArrowBox[{5, 10}], ArrowBox[{6, 7}], 
      ArrowBox[{6, 10}], ArrowBox[{7, 8}], ArrowBox[{8, 9}], 
      ArrowBox[{9, 10}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.30901699437494745`, 
     0.9510565162951535}, {-0.8090169943749476, -0.587785252292473}, {
     0.30901699437494723`, -0.9510565162951536}, {-0.8090169943749473, 
     0.5877852522924732}, {1., 0.}, {0.6180339887498949, 
     1.902113032590307}, {-1.6180339887498947`, 
     1.1755705045849465`}, {-1.6180339887498951`, -1.175570504584946}, {
     0.6180339887498945, -1.9021130325903073`}, {2., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageMargins->0.,
  ImageSize->{160., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{164, 168},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[20]=",
 CellID->2010307850]
}, Open  ]],

Cell["This draws with the default method.", "MathCaption",
 CellID->447953798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "3"}], ",", 
    RowBox[{"1", "\[Rule]", "4"}], ",", 
    RowBox[{"2", "\[Rule]", "4"}], ",", 
    RowBox[{"2", "\[Rule]", "5"}], ",", 
    RowBox[{"3", "\[Rule]", "5"}], ",", 
    RowBox[{"6", "\[Rule]", "7"}], ",", 
    RowBox[{"7", "\[Rule]", "8"}], ",", 
    RowBox[{"8", "\[Rule]", "9"}], ",", 
    RowBox[{"9", "\[Rule]", "10"}], ",", 
    RowBox[{"6", "\[Rule]", "10"}], ",", 
    RowBox[{"1", "\[Rule]", "6"}], ",", 
    RowBox[{"2", "\[Rule]", "7"}], ",", 
    RowBox[{"3", "\[Rule]", "8"}], ",", 
    RowBox[{"4", "\[Rule]", "9"}], ",", 
    RowBox[{"5", "\[Rule]", "10"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->2118172987],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJx1VA1UjGkUnqmZaWpq0o+/JUfYQn4iKZa9r002llhEjkWp6CQUsSEkKsnP
riTSspu2zXIU7WG1re/d7URSyF+JKIUyZb6ZfmSkdmZe7zdnvt295+08PfPd
77733ueZcVy5fn6IiUAgyNX+6dA47NHHfzCBXsj4ufQjZxnec2z8nAZ9TvP5
7wt4+Sz8qyWjz2k96f/cx9XD/81pHYpcP2Ccb8jTjCxLkotz4NfVzc/bb9uh
Z00Pu/J8roB/luWUmnQ7lPJ5k/YUgexSgPbYoTP6vJtQlNE4L9bRDvWPLnCH
UXdhh/4FW9Qn/C/teQigey3FFpVbJx/Z9ctjMJ17+WWity06eSG5EtbXgu7W
fmob5KaPekg/rgsb9CHPR1vyBbzWX2yDFt6uKlacegWTDtZ7HqzvhQg2QtJe
XfRCZ1tCN6yIb4KquNHaY+DzNFlzNVnWXL7yjS7kXD39x55y7r4x+gJWXD/l
Zbqw5PoN1Y09wJKbRxP4/Xg2SsbNu1t3fZUFtw8yrwW3r23XxizvKTTn9qlf
z+fm3L716aVSRPU45+o82T5AiggKMOnbGpE8Ab6ga9vdGpE6QtxX34cckXuE
OH5SxU8CLzkifZhgMqcVIn2a4O13nbXHCpE5TLHk5DrtaJaIzCnCx+wcLFwb
ZIjsQYTJXmSouWCeE7tGjIel+4Q/i7VAiesiIr1qxPjKi7YqzQNzdOqVy/lr
gyVY3dtzS/x4c+TmtPvJlokSfGuk7ZydR6Vo+sjNXd8MkmDfYbsXNgqlqKJV
JI+oEuNIk+RDOMoMPY4ba5MfLMaexSO6zZQSFFjZLnYqEuHT4St+vBohQUGq
xc0lrab4YqfL5oZ3YlQg3FkRbmeCn8YyoZfMxejLRJH3iEUCnOUVl2nvIkL2
oooDXd9+YMTToob2LDNFoga/85VJGka4JVWxKdMEBZxPU9TXvWWOKV5oojuF
yDnoqLdjbDtTeizka2mAEC0xmV94KLiVSYu1Vw59JEBvk0vnjj2kYroz1fdu
Bhm+30QfM44TfQyc6CPhONHHwIk+Yo4TfQyc6CPiONHHlONEHwPXv77dhOMb
Bl6PHHhdyHEbfRh4nnip9hjmOdU2U3t6uN+rpzW6+MBxB125yC6OL9UXeM9x
8n1+x/E7uvV4dHK8rWhISG1TB8cl+gLtBq6ft43j7fuXFXZvaeU4mU/NcX36
ERXH/QN9o4Zj7ncP8/TBPH0wTx/M0wfz9ME8fTBPH8zTB/P0wTx9ME8fzNMH
8/TBPH0wTx/M0wfz9MGr9NEBfTY+39PY0sMMcs+Q7xC3w5KyJLvMyz3MjVu9
96kLWqFE1nF21LIeZrXbvaqiBDUEj3P23fu0m3m78r5GFaqCUVMdNL991s1s
W9afjQlkYfDYqtyLUR+YOu/pkTdq38A0M//1u5K6mPxVNTnzXVrgYHGGp+PW
98wah+6E1EwFSMOyZYdnaBiCr2HBuh05UZIOhuBLCAyAyfED1AzB57Ay9u6u
RFkLQ7AGEgZ0Rgfse8kQfAhjDyuXpObXMgTvwJWSyJmz5ZUMwesw2WdeyFf2
ZQzBQhheLb36OOwKQ/AMpFt5uJ/+OwduDHXZ2J5hjQblnltQXVQAiekrR9eN
sEZbC4/3Lk8pBs/g7DFF2XI0XJ32nc+1W1AT27H5hJ0czY4JLc+NuQ+b2fmS
sAgr1LB6yCdJfarBNP+PJ2P+tETKmil9/fvVwp4SV03TOxlymOIRfzikHjpd
Ly4/4SRD23wFla1q7dzNYOHlZYH8U/x6w6NGcPO2dU5hzNHtPX6zFya8BuWM
pJMd7uaoboggxk2jgDRVVsTabCk6uNYv68mEFhjpHfLD215S9DDYr3juxDeQ
M610WOomM/S7VPBsf/cbsHl1TzLjvgS5L/FTpRxQQrB7nJfFaAmas8ivK7he
CadHPaiu20n9zYKxf1kw9i8Lxv5lwdi/LBj7lwVj/7Jg7F8WjP3LgrF/WaD+
pf0WZPvNmiJoBzqPR+r7aMXPrUDnfTbOX71xsRroPvJi1lx6YK8Cui9/Rdg+
x0Il0H2enhQ+ddaqFqD7/qKhOv7T4QqgekxQXArKFzYB1Ysi1ZMi1Zsi9QNF
6heK1E8Uqd8oUj9SpH6l+A+sKAWm
    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.023064257028112448`, 0.8}}], 
      ArrowBox[{1, 2}], 
      ArrowBox[{1, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
        34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 3}], ArrowBox[{1, 6}], 
      ArrowBox[{2, 5}], 
      ArrowBox[{2, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
        60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 8}], 
      ArrowBox[{3, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85,
        86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 9}], ArrowBox[{4, 3}], 
      ArrowBox[{4, 5}], ArrowBox[{4, 7}], 
      ArrowBox[{5, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 
       109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 
       123, 124, 125, 126, 127, 128, 129, 130, 131, 10}], ArrowBox[{6, 7}], 
      ArrowBox[{6, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
        144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 
       158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 
       172, 173, 174, 175, 10}], ArrowBox[{7, 8}], ArrowBox[{8, 9}], 
      ArrowBox[{9, 10}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 5.}, {-2., 4.}, {0., 3.}, {-1., 4.}, {-2., 
     3.}, {0., 4.}, {-1., 3.}, {-1., 2.}, {0., 1.}, {0., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{134.066085859655, Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{138, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->1532810880]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["VertexLabeling", "Subsection",
 CellTags->"b:0.1",
 CellID->156137816],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["VertexLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexLabeling"]], "InlineFormula"],
 " specifies whether to show vertex names as labels. Possible values for this \
option are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (the default) and ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexLabeling"], "->", "True"}]], 
  "InlineFormula"],
 " shows the labels. For graphs specified by an adjacency matrix, vertex \
labels are taken to be successive integers ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", ",", "2", ",", "\[Ellipsis]", ",", "n"}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is the size of the matrix. For graphs specified by a list of rules, labels \
are the expressions used in the rules. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexLabeling"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " displays each vertex as a point. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexLabeling"], "->", 
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"]}]], "InlineFormula"],
 " displays each vertex as a point, but gives its name in a tooltip. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexLabeling"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " displays each vertex as a point, giving its name in a tooltip if the \
number of vertices is not too large. You can also use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["k", "TI"]], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["lbl", "TI"]]}], "]"}]], "InlineFormula"],
 " anywhere in the list of rules to specify an alternative tooltip for a \
vertex ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 ". "
}], "Text",
 CellTags->"b:0.1",
 CellID->659301986],

Cell["\<\
This draws the graph with labels given as indices of the adjacency matrix.\
\>", "MathCaption",
 CellID->1601243868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "1", "0", "0", "0"},
      {"0", "0", "0", "0", "0"},
      {"1", "1", "0", "0", "0"},
      {"0", "1", "0", "0", "0"},
      {"0", "1", "0", "0", "0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.28], {
          Offset[0.7]}, 
         Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->111039013],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{162, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->589235889]
}, Open  ]],

Cell["This uses the labels specified in the list of rules.", "MathCaption",
 CellID->97622059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<A\>\"", "\[Rule]", "\"\<B\>\""}], ",", 
     RowBox[{"\"\<A\>\"", "\[Rule]", "\"\<a\>\""}], ",", 
     RowBox[{"\"\<B\>\"", "\[Rule]", "\"\<C\>\""}], ",", 
     RowBox[{"\"\<C\>\"", "\[Rule]", "\"\<A\>\""}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->1544203859],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.}, {-1., 1.}, {0., 1.}, {1., 0.}, {1., 
    1.}, {1., 0.04691358024691357}, {1., 0.09876543209876541}, {1., 
    0.15555555555555553`}, {1., 0.21728395061728392`}, {1., 
    0.2839506172839506}, {1., 0.3555555555555555}, {1., 
    0.43209876543209874`}, {1., 0.5135802469135802}, {1., 0.6}, {
    0.9965081146608071, 0.6874425026231434}, {0.9860324586432286, 
    0.771992232714796}, {0.9685730319472645, 0.8536491902749577}, {
    0.9441298345729148, 0.9324133753036284}, {0.9127028665201793, 
    1.0082847878008083`}, {0.8742921277890582, 1.0812634277664974`}, {
    0.8288976183795514, 1.1513492952006956`}, {0.7765193382916591, 
    1.2185423901034027`}, {0.717157287525381, 1.2828427124746191`}, {
    0.6061489679212887, 1.3938510320787114`}, {0.5029716924536255, 
    1.4970283075463746`}, {0.4076254611223915, 1.5923745388776085`}, {
    0.32011027392758673`, 1.6798897260724133`}, {0.24042613086921105`, 
    1.759573869130789}, {0.16857303194726453`, 1.8314269680527355`}, {
    0.10455097716174719`, 1.8954490228382528`}, {0.04835996651265902, 
    1.951640033487341}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03384563758389261, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 3}], ArrowBox[{2, 4}], 
      ArrowBox[{4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
        22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 1}]}, {InsetBox[
       FrameBox["\<\"A\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["\<\"B\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["\<\"a\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["\<\"C\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {-1., 1.}, {0., 1.}, {1., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{180., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->1379587565]
}, Open  ]],

Cell["\<\
This plots vertices as points, and displays vertex names in tooltips. Place \
the cursor above the vertices to see the labels.\
\>", "MathCaption",
 CellID->992105691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<A\>\"", "\[Rule]", "\"\<B\>\""}], ",", 
     RowBox[{"\"\<A\>\"", "\[Rule]", "\"\<a\>\""}], ",", 
     RowBox[{"\"\<B\>\"", "\[Rule]", "\"\<C\>\""}], ",", 
     RowBox[{"\"\<C\>\"", "\[Rule]", "\"\<A\>\""}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "Tooltip"}]}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->1314056000],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.}, {-1., 1.}, {0., 1.}, {1., 0.}, {1., 
    1.}, {1., 0.04691358024691357}, {1., 0.09876543209876541}, {1., 
    0.15555555555555553`}, {1., 0.21728395061728392`}, {1., 
    0.2839506172839506}, {1., 0.3555555555555555}, {1., 
    0.43209876543209874`}, {1., 0.5135802469135802}, {1., 0.6}, {
    0.9965081146608071, 0.6874425026231434}, {0.9860324586432286, 
    0.771992232714796}, {0.9685730319472645, 0.8536491902749577}, {
    0.9441298345729148, 0.9324133753036284}, {0.9127028665201793, 
    1.0082847878008083`}, {0.8742921277890582, 1.0812634277664974`}, {
    0.8288976183795514, 1.1513492952006956`}, {0.7765193382916591, 
    1.2185423901034027`}, {0.717157287525381, 1.2828427124746191`}, {
    0.6061489679212887, 1.3938510320787114`}, {0.5029716924536255, 
    1.4970283075463746`}, {0.4076254611223915, 1.5923745388776085`}, {
    0.32011027392758673`, 1.6798897260724133`}, {0.24042613086921105`, 
    1.759573869130789}, {0.16857303194726453`, 1.8314269680527355`}, {
    0.10455097716174719`, 1.8954490228382528`}, {0.04835996651265902, 
    1.951640033487341}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03384563758389261, 0.8}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 3}], ArrowBox[{2, 4}], 
      ArrowBox[{4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
        22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 1}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "\"A\""],
       Annotation[#, "A", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "\"B\""],
       Annotation[#, "B", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "\"a\""],
       Annotation[#, "a", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "\"C\""],
       Annotation[#, "C", "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {-1., 1.}, {0., 1.}, {1., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{169., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{173, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->1661294983]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["VertexRenderingFunction", "Subsection",
 CellTags->"b:0.1",
 CellID->283881111],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["VertexRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexRenderingFunction"]], "InlineFormula"],
 " specifies graphical representation of the graph edges. Possible values for \
this option are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", or a function that gives a proper combination of graphics primitives and \
directives. With the default setting of ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", vertices are displayed as points, with their names given in tooltips. "
}], "Text",
 CellID->1022272051],

Cell["\<\
By default, vertices are displayed as points and, for small graphs, labeled \
in tooltips. Point the cursor at a vertex to see the tooltip.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->844347480],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"5", "\[Rule]", "3"}], ",", 
     RowBox[{"5", "\[Rule]", "4"}], ",", 
     RowBox[{"6", "\[Rule]", "2"}], ",", 
     RowBox[{"6", "\[Rule]", "4"}], ",", 
     RowBox[{"7", "\[Rule]", "1"}], ",", 
     RowBox[{"7", "\[Rule]", "4"}], ",", 
     RowBox[{"7", "\[Rule]", "5"}], ",", 
     RowBox[{"7", "\[Rule]", "6"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->1183768490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", "g", "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->727769332],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 1.}, {0., 0.}, {1., 0.}, {2., 1.}, {2., 
    0.}, {1., 2.}, {-1., 1.}, {1., 1.}, {1., 1.9530864197530864`}, {1., 
    1.9012345679012346`}, {1., 1.8444444444444446`}, {1., 
    1.782716049382716}, {1., 1.7160493827160495`}, {1., 
    1.6444444444444444`}, {1., 1.567901234567901}, {1., 
    1.4864197530864196`}, {1., 1.4}, {1., 1.3111111111111111`}, {1., 
    1.222222222222222}, {1., 1.1333333333333333`}, {1., 
    1.0444444444444445`}, {1., 0.9555555555555555}, {1., 
    0.8666666666666667}, {1., 0.7777777777777778}, {1., 0.6888888888888889}, {
    1., 0.6}, {1., 0.5135802469135802}, {1., 0.43209876543209874`}, {1., 
    0.3555555555555555}, {1., 0.2839506172839506}, {1., 
    0.21728395061728392`}, {1., 0.15555555555555553`}, {1., 
    0.09876543209876541}, {1., 0.04691358024691357}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.8}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 3}], ArrowBox[{4, 5}], ArrowBox[{4, 3}], 
      ArrowBox[{6, 7}], 
      ArrowBox[{6, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 
       24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 3}], ArrowBox[{6, 1}], 
      ArrowBox[{6, 4}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 1.}, {0., 0.}, {1., 0.}, {2., 1.}, {2., 
     0.}, {1., 2.}, {-1., 1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{194., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{198, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->68826304]
}, Open  ]],

Cell["This draws the same graph, but without the vertices.", "MathCaption",
 CellTags->"b:0.1",
 CellID->1803124116],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->271336278],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 1.}, {0., 0.}, {1., 0.}, {2., 1.}, {2., 
    0.}, {1., 2.}, {-1., 1.}, {1., 1.}, {1., 1.9530864197530864`}, {1., 
    1.9012345679012346`}, {1., 1.8444444444444446`}, {1., 
    1.782716049382716}, {1., 1.7160493827160495`}, {1., 
    1.6444444444444444`}, {1., 1.567901234567901}, {1., 
    1.4864197530864196`}, {1., 1.4}, {1., 1.3111111111111111`}, {1., 
    1.222222222222222}, {1., 1.1333333333333333`}, {1., 
    1.0444444444444445`}, {1., 0.9555555555555555}, {1., 
    0.8666666666666667}, {1., 0.7777777777777778}, {1., 0.6888888888888889}, {
    1., 0.6}, {1., 0.5135802469135802}, {1., 0.43209876543209874`}, {1., 
    0.3555555555555555}, {1., 0.2839506172839506}, {1., 
    0.21728395061728392`}, {1., 0.15555555555555553`}, {1., 
    0.09876543209876541}, {1., 0.04691358024691357}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.8}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 3}], ArrowBox[{4, 5}], ArrowBox[{4, 3}], 
      ArrowBox[{6, 7}], 
      ArrowBox[{6, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 
       24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 3}], ArrowBox[{6, 1}], 
      ArrowBox[{6, 4}]}, 
     {RGBColor[0, 0, 0.7]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 1.}, {0., 0.}, {1., 0.}, {2., 1.}, {2., 
     0.}, {1., 2.}, {-1., 1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{194., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{198, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->390441064]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexRenderingFunction"], "->", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 ", each vertex is rendered with the graphics primitives given by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["g", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["r", "TI"], 
     StyleBox["i", "TI"]], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["i", "TI"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is the coordinate of the vertex and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is the label of the vertex. Explicit settings for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexRenderingFunction"], "->", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 " override settings for ",
 Cell[BoxData[
  ButtonBox["VertexLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexLabeling"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->639309593],

Cell["This shows vertices as yellow disks.", "MathCaption",
 CellTags->"b:0.1",
 CellID->703653719],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}], ",", 
     RowBox[{"8", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "9"}], ",", 
     RowBox[{"2", "\[Rule]", "9"}], ",", 
     RowBox[{"3", "\[Rule]", "10"}], ",", 
     RowBox[{"4", "\[Rule]", "10"}], ",", 
     RowBox[{"6", "\[Rule]", "11"}], ",", 
     RowBox[{"5", "\[Rule]", "11"}], ",", 
     RowBox[{"7", "\[Rule]", "12"}], ",", 
     RowBox[{"8", "\[Rule]", "12"}]}], "}"}], ",", "Left", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EdgeForm", "[", "Black", "]"}], ",", "Yellow", ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#1", ",", "0.2"}], "]"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[27]:=",
 CellID->1950334],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{472, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[27]=",
 CellID->154300761]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example Gallery", "Section",
 CellTags->"b:0.1",
 CellID->806578725],

Cell[CellGroupData[{

Cell["Flow Chart", "Subsection",
 CellTags->"b:0.1",
 CellID->2124904963],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 " helps visualize flow charts, for example for business, economic. or \
technical presentations."
}], "Text",
 CellTags->"b:0.1",
 CellID->363554723],

Cell["This shows a flow chart.", "MathCaption",
 CellTags->"b:0.1",
 CellID->1777602637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<total\>\"", "\[Rule]", "\"\<TotalDispatch\>\""}], ",", 
     RowBox[{"\"\<TotalList\>\"", "\[Rule]", "\"\<CheckThreading\>\""}], ",", 
     
     RowBox[{"\"\<TotalList\>\"", "\[Rule]", "\"\<TotalDispatch\>\""}], ",", 
     RowBox[{"\"\<TotalSparse\>\"", "\[Rule]", "\"\<TotalDispatch\>\""}], ",",
      
     RowBox[{"\"\<TotalSparse\>\"", "\[Rule]", "\"\<TotalDispatch\>\""}], ",",
      
     RowBox[{"\"\<TotalDispatch\>\"", "\[Rule]", "\"\<TotalDispatch\>\""}], 
     ",", 
     RowBox[{"\"\<TotalDispatch\>\"", "\[Rule]", "\"\<TotalList\>\""}], ",", 
     RowBox[{"\"\<TotalDispatch\>\"", "\[Rule]", "\"\<TotalPacked\>\""}], ",",
      
     RowBox[{"\"\<TotalDispatch\>\"", "\[Rule]", "\"\<TotalSparse\>\""}]}], 
    "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->676481098],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxd1AlMFFcYB/BhqSClrRCsCNJYBEQ5DIcoWOEbBBXBIlosSMRF2JWt4sEh
pqhpCyKLLoeKUqjAcrpAdGkQgdD6lEPAgF0KgoVlOQILK5bC7CLHXi34tNF/
Mnn5Zibz3pt8v2caevoAk0YQRPB/1+L4fpaTH9zA9RTCI7xff5h3z9+NbLs1
+bKmSiSzSrn0YEoJmxPjXNqda5Guv7PnR0wlDDCSHIj5h+iKRWNbjFAByRxH
NT2+Hnn7RU86BCjgfFMH3+BuE0rwOXmG9VwO621LiBx5C5K4F2u6BcgBiqyu
UhFtyGPr6i19wgX4ZGleATq2lAV41raYEbxeGbBP2UU8qB1Fif7M/bkpUuhO
8Na+cE+MCptWcqPXSmF5Zu+goGwM3XVeOFtQRcHPXLGQeW8cpUWK1T5+FBj7
sLMkNRK0N3aDZvo/02DEO8Ne/vQl2s/L7OTcmIaJg8Y6J4cmkHalvjd9+zTU
k+Y2u4Kz4XWda451kAq8thEJk7FcEB70q6kbV8K1HVs0KqEQcnvaGVGxSjgx
HGaszy6Gw6d3nYvWVMKy35Oy9u+7A8eTXZTDaQrYk0RvHM3gwTq3FvvRNQpI
9LBkhweWQnDkoajcO3LgZi2mFOwdF/N/3b70H2QQj9/PTy1JORooAw/8PeHj
rc+MR6Qg/+3NfDdjn9C+OCOFI3g9Bem1bI6Cgp/wekM2OPySkkyBE96PWRl/
t6chBTfxfnU860O7iqfh5m7/wCinO5Acs5HLj9cgE7bvnIqUVoCObUaLZFaD
1GY52EFcLXB5vlR4CI1s+NWZ0X2kHmbTGQ/rHtBIrdS4FZMGrbDJ2jaB9ZpG
tlP7rt9wF4BXtRex1kSTdPIzePLUvAt6MvRZEgtN0or78bFhdQ/kiFNidhpo
klUg8uHk9cH6uW4b61EaKSpP1L/WKQJ/cT9B5NJI46EiAa9mEBINV43FutNI
wrZ5o7psCNoqPc3pXRqk6RUHPcfNw+A2E7yXcViDrDbpHV/39TCoS+b+qB8g
yNDtkyPxsiE4QLrSZhgEaTMkJCc3DcFcw9NntSNqOPvp5flSrUEw/TwoRbRG
DcLyEF/nVf1g6Jba2fK9Cvwv99ip8v6Cbxyq/Ea1VJBdzSypevEc6vUY1Tat
SpAwP9tRTHXARZcmr64GJeiGlfoGebTBpQo9C7NZJXxnbZKx0b4Jfgi3zDoV
ooKpLOEJ96S/0YrnUef3rKAgiC8IFL94hebKm+vk2RQwDfjzA1++Qud6v3K8
aiYFkYkjwaJPoBo+R7+dJ4WCVN2VdRkv0Y/3r6dlWsmgOqYbrX4sQUYPgxSP
eTKgvnUKbhgZR49axlrNzWZArl7MGLq91Gcz8MZdN/amAGpdnuUNThe6UJ59
72iUAgLnjk9rF/6J6Nsm6JxBBUx3eLsdKRMg/+ZlV4K9lVB4kclh7WpHUalG
xH2+Em53irIOmbSiquQexWk9FeTTXUX9PY2oIoBlEx2hggDerT6fuEdoYe9k
FbdB9dYb0sX9h70hC9yf2BsKw/2LvaFi3N/YG8rE/Y+9oQHsA3tDRdgP9oUE
2NfbejP2h72hEOwTe0MW2C/2hiKwb+wN0bF/7A3l4/MBe0MifH5gb2gOny//
Aryezb0=
    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{2, 6}], 
      ArrowBox[{2, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
       22, 3}], 
      ArrowBox[{2, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37,
        38, 5}], 
      ArrowBox[{2, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53,
        54, 55, 56, 57, 58, 59, 60, 61, 2}], ArrowBox[{3, 4}], 
      ArrowBox[{3, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76,
        77, 2}], 
      ArrowBox[{5, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92,
        93, 2}], ArrowBox[{5, 2}]}, {InsetBox[
       FrameBox["\<\"total\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["\<\"TotalDispatch\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["\<\"TotalList\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["\<\"CheckThreading\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["\<\"TotalSparse\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["\<\"TotalPacked\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 3.}, {0., 2.}, {-1., 1.}, {-1., 0.}, {0., 
     1.}, {1., 1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{263.366666666667, Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{267, 365},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->1326404970]
}, Open  ]],

Cell["This shows a flow chart that flows from left to right.", "MathCaption",
 CellTags->"b:0.1",
 CellID->2051305448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<ratiotest\>\"", "\[Rule]", "\"\<ratiolimit\>\""}], ",", 
     RowBox[{"\"\<getdata\>\"", "\[Rule]", "\"\<dir_inf _bad\>\""}], ",", 
     RowBox[{"\"\<getdata\>\"", "\[Rule]", "\"\<evalderiv\>\""}], ",", 
     RowBox[{"\"\<NSPpreliminaries\>\"", "\[Rule]", "\"\<getdata\>\""}], ",", 
     
     RowBox[{"\"\<findsp\>\"", "\[Rule]", "\"\<termlimit\>\""}], ",", 
     RowBox[{"\"\<findsp\>\"", "\[Rule]", "\"\<ratiotest\>\""}], ",", 
     RowBox[{"\"\<findsp\>\"", "\[Rule]", "\"\<nSumW\>\""}], ",", 
     RowBox[{"\"\<findsp\>\"", "\[Rule]", "\"\<nSumEM\>\""}], ",", 
     RowBox[{"\"\<findsp\>\"", "\[Rule]", "\"\<nProductEM\>\""}], ",", 
     RowBox[{"\"\<findsp\>\"", "\[Rule]", "\"\<nProductW\>\""}], ",", 
     RowBox[{"\"\<nSumW\>\"", "\[Rule]", "\"\<nSumFinite\>\""}], ",", 
     RowBox[{"\"\<nSumW\>\"", "\[Rule]", "\"\<nSumWtail\>\""}], ",", 
     RowBox[{"\"\<nSumEM\>\"", "\[Rule]", "\"\<evalterm\>\""}], ",", 
     RowBox[{"\"\<nSumEM\>\"", "\[Rule]", "\"\<nSumFinite\>\""}], ",", 
     RowBox[{"\"\<nSumEM\>\"", "\[Rule]", "\"\<evalderiv\>\""}], ",", 
     RowBox[{"\"\<nProductEM\>\"", "\[Rule]", "\"\<nPFinite\>\""}], ",", 
     RowBox[{"\"\<nProductW\>\"", "\[Rule]", "\"\<nPFinite\>\""}], ",", 
     RowBox[{"\"\<nProductW\>\"", "\[Rule]", "\"\<nPWtail\>\""}], ",", 
     RowBox[{"\"\<oNSum\>\"", "\[Rule]", "\"\<CleanOptionList\>\""}], ",", 
     RowBox[{"\"\<oNSum\>\"", "\[Rule]", "\"\<multidim\>\""}], ",", 
     RowBox[{"\"\<oNSum\>\"", "\[Rule]", "\"\<NSPpreliminaries\>\""}], ",", 
     RowBox[{"\"\<oNSum\>\"", "\[Rule]", "\"\<findsp\>\""}], ",", 
     RowBox[{"\"\<nSumFinite\>\"", "\[Rule]", "\"\<evalterm\>\""}], ",", 
     RowBox[{"\"\<nSumWtail\>\"", "\[Rule]", "\"\<evalterm\>\""}], ",", 
     RowBox[{"\"\<nSumWtail\>\"", "\[Rule]", "\"\<epsalg\>\""}], ",", 
     RowBox[{"\"\<oNProduct\>\"", "\[Rule]", "\"\<CleanOptionList\>\""}], ",",
      
     RowBox[{"\"\<oNProduct\>\"", "\[Rule]", "\"\<multidim\>\""}], ",", 
     RowBox[{"\"\<oNProduct\>\"", "\[Rule]", "\"\<NSPpreliminaries\>\""}], 
     ",", 
     RowBox[{"\"\<oNProduct\>\"", "\[Rule]", "\"\<findsp\>\""}], ",", 
     RowBox[{"\"\<nPFinite\>\"", "\[Rule]", "\"\<evalterm\>\""}], ",", 
     RowBox[{"\"\<nPWtail\>\"", "\[Rule]", "\"\<evalterm\>\""}], ",", 
     RowBox[{"\"\<nPWtail\>\"", "\[Rule]", "\"\<epsalg\>\""}], ",", 
     RowBox[{"\"\<oSequenceLimit\>\"", "\[Rule]", "\"\<epsalg\>\""}]}], "}"}],
    ",", "Left", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", " ", "1"}], ",", 
   RowBox[{"PlotRangePadding", "\[Rule]", "0.02"}]}], "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->426596807],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{-2., -2.1437387455469636`*^-15}, {-1., \
-1.0718693727734818`*^-15}, {-1.9999999999999978`, -2.000000000000002}, \
{-0.9999999999999968, -3.000000000000001}, {-0.9999999999999979, \
-2.000000000000001}, {-3., -3.2156081183204455`*^-15}, {-3.000000000000001, 
    0.9999999999999968}, {-1.999999999999999, -1.0000000000000022`}, \
{-2.000000000000001, 0.9999999999999979}, {-2.000000000000002, 
    1.9999999999999978`}, {-2.0000000000000053`, 
    4.999999999999998}, {-2.0000000000000044`, 
    3.999999999999998}, {-1.0000000000000022`, 
    1.999999999999999}, {-1.000000000000001, 
    0.9999999999999989}, {-3.2156081183204455`*^-15, 
    3.}, {-1.0000000000000053`, 4.999999999999999}, {-1.0000000000000042`, 
    3.999999999999999}, {-3.999999999999999, -1.0000000000000042`}, \
{-2.999999999999998, -2.000000000000003}, {-2.999999999999999, \
-1.000000000000003}, {-1.0718693727734818`*^-15, 
    1.}, {-4., -4.287477491093927*^-15}, {-0.9999999999999989, \
-1.000000000000001}, {-1.000000000000003, 
    2.999999999999999}, {-1.9516400334873432`, 
    2.048359966512657}, {-1.8954490228382552`, 
    2.104550977161745}, {-1.8314269680527377`, 
    2.1685730319472625`}, {-1.7595738691307914`, 
    2.240426130869209}, {-1.6798897260724157`, 
    2.3201102739275847`}, {-1.592374538877611, 
    2.40762546112239}, {-1.497028307546377, 
    2.502971692453624}, {-1.393851032078714, 
    2.6061489679212873`}, {-1.2828427124746218`, 
    2.7171572875253798`}, {-1.2185423901034056`, 
    2.7765193382916578`}, {-1.1513492952006983`, 
    2.8288976183795502`}, {-1.0812634277665003`, 
    2.874292127789057}, {-1.0082847878008114`, 
    2.9127028665201786`}, {-0.9324133753036314, 
    2.944129834572914}, {-0.8536491902749608, 
    2.9685730319472636`}, {-0.7719922327147991, 
    2.986032458643228}, {-0.6874425026231465, 
    2.9965081146608066`}, {-0.6000000000000031, 
    2.9999999999999996`}, {-0.5135802469135834, 
    2.9999999999999996`}, {-0.4320987654321019, 
    2.9999999999999996`}, {-0.3555555555555587, 3.}, {-0.28395061728395377`, 
    3.}, {-0.2172839506172871, 3.}, {-0.15555555555555872`, 
    3.}, {-0.09876543209876862, 3.}, {-0.04691358024691678, 3.}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.018461318051575932`, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{3, 4}], ArrowBox[{3, 5}], ArrowBox[{6, 3}], 
      ArrowBox[{7, 8}], ArrowBox[{7, 1}], ArrowBox[{7, 9}], ArrowBox[{7, 10}],
       ArrowBox[{7, 11}], ArrowBox[{7, 12}], ArrowBox[{9, 13}], 
      ArrowBox[{9, 14}], 
      ArrowBox[{10, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
       39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 15}], 
      ArrowBox[{10, 13}], ArrowBox[{10, 5}], ArrowBox[{11, 16}], 
      ArrowBox[{12, 16}], ArrowBox[{12, 17}], ArrowBox[{13, 15}], 
      ArrowBox[{14, 15}], ArrowBox[{14, 21}], ArrowBox[{16, 15}], 
      ArrowBox[{17, 15}], ArrowBox[{17, 21}], ArrowBox[{18, 19}], 
      ArrowBox[{18, 20}], ArrowBox[{18, 6}], ArrowBox[{18, 7}], 
      ArrowBox[{22, 19}], ArrowBox[{22, 20}], ArrowBox[{22, 6}], 
      ArrowBox[{22, 7}], ArrowBox[{23, 21}]}, {InsetBox[
       FrameBox["\<\"ratiotest\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["\<\"ratiolimit\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["\<\"getdata\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["\<\"dir_inf _bad\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["\<\"evalderiv\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["\<\"NSPpreliminaries\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["\<\"findsp\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["\<\"termlimit\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["\<\"nSumW\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["\<\"nSumEM\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10], InsetBox[
       FrameBox["\<\"nProductEM\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 11], InsetBox[
       FrameBox["\<\"nProductW\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 12], InsetBox[
       FrameBox["\<\"nSumFinite\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 13], InsetBox[
       FrameBox["\<\"nSumWtail\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 14], InsetBox[
       FrameBox["\<\"evalterm\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 15], InsetBox[
       FrameBox["\<\"nPFinite\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 16], InsetBox[
       FrameBox["\<\"nPWtail\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 17], InsetBox[
       FrameBox["\<\"oNSum\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 18], InsetBox[
       FrameBox["\<\"CleanOptionList\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 19], InsetBox[
       FrameBox["\<\"multidim\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 20], InsetBox[
       FrameBox["\<\"epsalg\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 21], InsetBox[
       FrameBox["\<\"oNProduct\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 22], InsetBox[
       FrameBox["\<\"oSequenceLimit\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 23]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{-2., -2.1437387455469636`*^-15}, {-1., \
-1.0718693727734818`*^-15}, {-1.9999999999999978`, -2.000000000000002}, \
{-0.9999999999999968, -3.000000000000001}, {-0.9999999999999979, \
-2.000000000000001}, {-3., -3.2156081183204455`*^-15}, {-3.000000000000001, 
     0.9999999999999968}, {-1.999999999999999, -1.0000000000000022`}, \
{-2.000000000000001, 0.9999999999999979}, {-2.000000000000002, 
     1.9999999999999978`}, {-2.0000000000000053`, 
     4.999999999999998}, {-2.0000000000000044`, 
     3.999999999999998}, {-1.0000000000000022`, 
     1.999999999999999}, {-1.000000000000001, 
     0.9999999999999989}, {-3.2156081183204455`*^-15, 
     3.}, {-1.0000000000000053`, 4.999999999999999}, {-1.0000000000000042`, 
     3.999999999999999}, {-3.999999999999999, -1.0000000000000042`}, \
{-2.999999999999998, -2.000000000000003}, {-2.999999999999999, \
-1.000000000000003}, {-1.0718693727734818`*^-15, 
     1.}, {-4., -4.287477491093927*^-15}, {-0.9999999999999989, \
-1.000000000000001}}]& ],
  AspectRatio->1,
  FrameTicks->None,
  ImageSize->{480., Automatic},
  PlotRange->All,
  PlotRangePadding->0.02]], "Output",
 ImageSize->{484, 453},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->776088936]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Food Chains", "Subsection",
 CellTags->"b:0.1",
 CellID->437210322],

Cell[TextData[{
 "Food chains can be visualized with ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->333441302],

Cell["This shows a small food chain.", "MathCaption",
 CellTags->"b:0.1",
 CellID->763006443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<John\>\"", " ", "->", " ", "\"\<plants\>\""}], ",", " ", 
     "\n", "  ", 
     RowBox[{"\"\<lion\>\"", " ", "->", " ", "\"\<John\>\""}], ",", "  ", 
     RowBox[{"\"\<tiger\>\"", " ", "->", " ", "\"\<John\>\""}], ",", " ", 
     RowBox[{"\"\<tiger\>\"", "\[Rule]", "\"\<deer\>\""}], ",", 
     RowBox[{"\"\<lion\>\"", "\[Rule]", "\"\<deer\>\""}], ",", 
     RowBox[{"\"\<deer\>\"", "\[Rule]", "\"\<plants\>\""}], ",", "\n", "  ", 
     RowBox[{"\"\<mosquito\>\"", " ", "->", " ", "\"\<lion\>\""}], ",", " ", 
     RowBox[{"\"\<frog\>\"", " ", "->", " ", "\"\<mosquito\>\""}], ",", 
     RowBox[{"\"\<mosquito\>\"", "\[Rule]", "\"\<tiger\>\""}], ",", 
     RowBox[{"\"\<John\>\"", "\[Rule]", "\"\<cow\>\""}], ",", 
     RowBox[{"\"\<cow\>\"", "\[Rule]", "\"\<plants\>\""}], ",", 
     RowBox[{"\"\<mosquito\>\"", "\[Rule]", "\"\<deer\>\""}], ",", 
     RowBox[{"\"\<mosquito\>\"", "\[Rule]", "\"\<John\>\""}], ",", " ", 
     RowBox[{"\"\<snake\>\"", " ", "->", " ", "\"\<frog\>\""}], ",", " ", 
     RowBox[{"\"\<vulture\>\"", " ", "->", " ", "\"\<snake\>\""}]}], "}"}], 
   ",", " ", "Left", ",", "\n", " ", 
   RowBox[{"VertexLabeling", " ", "->", " ", "True"}]}], "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->699438697],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxVVAtQU0cUfQETCIGAFeOPVsxYUYuORRF1YlfHsUMtAxaJnwICVkDF+qWO
daB+gZGPv9CxOq1WqjVVhKgjFN26azMaKqAF+SlYYgJICN8EEEIIfW/fMtPe
ecmd8/buvfft2XtmbNkdHu/EMMwB9sd5apj78w0zQoqPMP8zV7KuGeiAThQb
RznrBjQH7qSYh140n5Xm8ya4TT4IB/g4JCTvexC/Ppnmt9N4H4IVLcwfzH/i
fMNewLF9NA8Q0n4sBI8CB3EuWErj1JduZ9WBURSvN9X6NxjglrMBPclJDhRl
1cqFkQY4v/7YvPpjI6h5ySmj+tkbKNmft0qQbkcjmuApkxe/gbY4bsMwUkda
teFn9dB2NYx7kG6vj+42boLuitcXp8uGEJc34tN/4AK/Zd6xpe+Qr2yO8+m7
jTCB2ADpP9a1AV4j2/vQPh/dXvval9DI1l1yykrq/3ChDsqJWZCStUBDDYyT
FMVKinpIvcq51fATk4p9utBSdtuu/VUQPuDMjG7euHHDDf4NufenjG1kPVT8
DHK7YyWtiC3nk3HxKVxIzEj6wR/pIDme3Xr06MWtobgaLazwzMo9er0BcZ9V
W4ihbOcj9qlFpM8DD+CUg/cDgX8V0srj9du77sHfEjsM/c/LEHlfqoEq0qAW
PWH73euihk2mWrsmuARlslkjj1+CtrnlJ6VCNSpqzVj91J4N8yk/Y/cngfLT
RXEA5WcMe1J+uil2UH56KB6l/Izh8ZSfXooDKT9jOInyY6EY/apco2D60Yr1
SvtWYzdQfD980HzNiuZsUvaqcrpB88cbLfs3WNAtV6Yp29EF7qUkFdV496Ky
rcrHYYu7QJx5R+YM2I1OfK282rioE+Qv3bl8TUInqpczKQttZrCm+VXah7PN
SHdCGRKR3g6Wm4u+uiswobUq5UTwsg0cD2XqrJZWlMx7MFMRlHYu3ogm8R70
v1ZM2jhZj9p5DzoT5VNPyl6hRt6D8JRtFYUp1Wg170GA5fyZ4CfP0Ae8B0fh
hYkVqscomffArzB/3SvtfSTjPcjzCAr85U81Osd74Bzt4b/oR08MHqrtfZbf
wY7DZq/GWZ540XtnDKkzy0BQ4sWCd5elODx7kyyNqQXbvacKM1ykOKhkc8Hp
jCYgyNjhnRntgVt0N6MKJ7SAkYdZjUyeOxa65k0b6m4HMTA12lwtwd9JxZnh
+T1g1uEV5z8bcMPxzo68l7P6QLhL9clpIjdcbCisP/v2HYhT/Ryz8rQY3ykw
S0LSh0D5slrBoJcYXxfGyBP+sgHVSPIekOWKc9+KffSaYVDckHJzksMFH4ro
GCxR2EFQTeedI9td8KYQUYl1px1MaNelH6oQ4QXPN0TlrLSDz6dK/IRzRVjw
Wm9Ivz8M9PHFKt/DQlz2zZUQfZ0NVJZzNg7nXOBsCCRx13/aOKytf2y+HDQI
Rsh9dMZt3ICYBkD6PO4CO2HblxphpKYfiMKK2ZvvhO0/7WJHrQ+kPpm/eRQK
sDk7Gjq+tYIOMkACXOqXWuWXagFfcOFPGZzLhef2ggIiMAwOjQtNno17QMRz
rrAnjprHz9XtYG4SPbG7mZ87fn6l2A/wc5m2tPIKs0qKl23j55YNYjd44Fg6
1ylVXGEPHEXnXniJK+yOx3vxunB+wvtuC5olGFHdCCB6IsHrqK5Ukr7dsA9p
pAXt4YRHJ8b7SJ9vkdd4zsR4PdWpQvZUhJGuuLRz276YNBMKJQLrgnUUdxET
4Qgan0OESIR30Xz+RB+EWEbrlVN+Qmg/iZSfYtrvEOXHTnXuGOVnFf1eZ8rP
anoehyg/DqpzJspPK9W5MMrP0Xb+vPMpP4v9eT7+Bave33A=
    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.019671594508975713`, 0.7}}], 
      ArrowBox[{1, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
        30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 2}], ArrowBox[{1, 8}], 
      ArrowBox[{3, 1}], ArrowBox[{3, 5}], ArrowBox[{4, 1}], ArrowBox[{4, 5}], 
      ArrowBox[{5, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55,
        56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 2}], ArrowBox[{6, 3}], 
      ArrowBox[{6, 4}], 
      ArrowBox[{6, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
        82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 5}], 
      ArrowBox[{6, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 
       106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 1}], 
      ArrowBox[{7, 6}], ArrowBox[{8, 2}], ArrowBox[{9, 7}], 
      ArrowBox[{10, 9}]}, {InsetBox[
       FrameBox["\<\"John\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["\<\"plants\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["\<\"lion\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["\<\"tiger\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["\<\"deer\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["\<\"mosquito\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["\<\"frog\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["\<\"cow\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["\<\"snake\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["\<\"vulture\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{-2., -2.1437387455469636`*^-15}, {0., 
     0.}, {-3., -3.2156081183204455`*^-15}, {-3.000000000000001, 
     0.9999999999999968}, {-2.000000000000001, 
     0.9999999999999979}, {-4., -4.287477491093927*^-15}, {-5., \
-5.359346863867409*^-15}, {-0.9999999999999989, -1.000000000000001}, {-6., \
-6.431216236640891*^-15}, {-7., -7.503085609414373*^-15}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{539., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{543, 214},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->1307705260]
}, Open  ]],

Cell["This shows another food chain.", "MathCaption",
 CellTags->"b:0.1",
 CellID->503437744],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LayeredGraphPlot", "[", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<Raccoon\>\"", "\[Rule]", "\"\<Bird\>\""}], ",", 
      RowBox[{"\"\<Raccoon\>\"", "\[Rule]", "\"\<Insect\>\""}], ",", 
      RowBox[{"\"\<Wildcat\>\"", "\[Rule]", "\"\<Bird\>\""}], ",", 
      RowBox[{"\"\<Wildcat\>\"", "\[Rule]", "\"\<Rodent\>\""}], ",", 
      RowBox[{"\"\<Fox\>\"", "\[Rule]", "\"\<Bird\>\""}], ",", 
      RowBox[{"\"\<Fox\>\"", "\[Rule]", "\"\<Garter snake\>\""}], ",", 
      RowBox[{"\"\<Fox\>\"", "\[Rule]", "\"\<Salamander\>\""}], ",", 
      RowBox[{"\"\<Fox\>\"", "\[Rule]", "\"\<Rabbit\>\""}], ",", 
      RowBox[{"\"\<Fox\>\"", "\[Rule]", "\"\<Rodent\>\""}], ",", 
      RowBox[{"\"\<Wolf\>\"", "\[Rule]", "\"\<Rabbit\>\""}], ",", 
      RowBox[{"\"\<Wolf\>\"", "\[Rule]", "\"\<Rodent\>\""}], ",", 
      RowBox[{"\"\<Wolf\>\"", "\[Rule]", "\"\<Skunk\>\""}], ",", 
      RowBox[{"\"\<Wolf\>\"", "\[Rule]", "\"\<Deer\>\""}], ",", 
      RowBox[{"\"\<Bear\>\"", "\[Rule]", "\"\<Deer\>\""}], ",", 
      RowBox[{"\"\<Bear\>\"", "\[Rule]", "\"\<Rodent\>\""}], ",", 
      RowBox[{"\"\<Bear\>\"", "\[Rule]", "\"\<Plant\>\""}], ",", 
      RowBox[{"\"\<Bird\>\"", "\[Rule]", "\"\<Plant\>\""}], ",", 
      RowBox[{"\"\<Garter snake\>\"", "\[Rule]", "\"\<Insect\>\""}], ",", 
      RowBox[{"\"\<Garter snake\>\"", "\[Rule]", "\"\<Toad\>\""}], ",", 
      RowBox[{"\"\<Salamander\>\"", "\[Rule]", "\"\<Insect\>\""}], ",", 
      RowBox[{"\"\<Rabbit\>\"", "\[Rule]", "\"\<Plant\>\""}], ",", 
      RowBox[{"\"\<Skunk\>\"", "\[Rule]", "\"\<Rodent\>\""}], ",", 
      RowBox[{"\"\<Skunk\>\"", "\[Rule]", "\"\<Insect\>\""}], ",", 
      RowBox[{"\"\<Deer\>\"", "\[Rule]", "\"\<Plant\>\""}], ",", 
      RowBox[{"\"\<Toad\>\"", "\[Rule]", "\"\<Insect\>\""}], ",", 
      RowBox[{"\"\<Insect\>\"", "\[Rule]", "\"\<Plant\>\""}]}], "}"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotRangePadding", "\[Rule]", "Automatic"}]}], "]"}], 
  "\n"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->657404965],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJx1lwdUU9kWhhMCIQmQRKkiLSYjQwTEgijjcLYiWMCOBbHR5okyKsIIiA7S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    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.01662309542902967, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 3}], ArrowBox[{2, 14}], 
      ArrowBox[{3, 14}], ArrowBox[{4, 2}], ArrowBox[{4, 5}], 
      ArrowBox[{6, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
        42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 
       59, 60, 61, 2}], ArrowBox[{6, 7}], 
      ArrowBox[{6, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76,
        77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 8}], 
      ArrowBox[{6, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
       102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 9}], 
      ArrowBox[{6, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125,
        126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 
       140, 141, 142, 143, 144, 145, 146, 147, 148, 5}], 
      ArrowBox[{7, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160,
        161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 
       3}], ArrowBox[{7, 15}], ArrowBox[{8, 3}], 
      ArrowBox[{9, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186,
        187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 
       14}], ArrowBox[{10, 9}], 
      ArrowBox[{10, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 
       212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 
       226, 5}], ArrowBox[{10, 11}], 
      ArrowBox[{10, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 
       238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 
       252, 12}], ArrowBox[{11, 5}], ArrowBox[{11, 3}], ArrowBox[{12, 14}], 
      ArrowBox[{13, 12}], ArrowBox[{13, 5}], 
      ArrowBox[{13, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 
       264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 
       278, 14}], ArrowBox[{15, 3}]}, {InsetBox[
       FrameBox["\<\"Raccoon\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["\<\"Bird\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["\<\"Insect\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["\<\"Wildcat\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["\<\"Rodent\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["\<\"Fox\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["\<\"Garter snake\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["\<\"Salamander\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["\<\"Rabbit\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["\<\"Wolf\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10], InsetBox[
       FrameBox["\<\"Skunk\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 11], InsetBox[
       FrameBox["\<\"Deer\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 12], InsetBox[
       FrameBox["\<\"Bear\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 13], InsetBox[
       FrameBox["\<\"Plant\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 14], InsetBox[
       FrameBox["\<\"Toad\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 15]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {1., 1.}, {4., 1.}, {1., 2.}, {6., 
     1.}, {3., 4.}, {3., 3.}, {2., 2.}, {10., 2.}, {8., 3.}, {7., 2.}, {7., 
     1.}, {5., 2.}, {5., 0.}, {3., 2.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{559., Automatic},
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{563, 214},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->826622652]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["History of Unix", "Subsection",
 CellTags->"b:0.1",
 CellID->1088709261],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 " is suitable for visualizing historical events."
}], "Text",
 CellTags->"b:0.1",
 CellID->2059755923],

Cell["This shows a history of Unix.", "MathCaption",
 CellTags->"b:0.1",
 CellID->121456149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<5th Edition\>\"", " ", "->", " ", "\"\<6th Edition\>\""}], 
     ",", " ", 
     RowBox[{"\"\<5th Edition\>\"", " ", "->", " ", "\"\<PWB 1.0\>\""}], ",", 
     " ", "\n", "  ", 
     RowBox[{"\"\<6th Edition\>\"", " ", "->", " ", "\"\<1 BSD\>\""}], ",", 
     " ", 
     RowBox[{"\"\<6th Edition\>\"", " ", "->", " ", "\"\<Interdata\>\""}], 
     ",", " ", "\n", "  ", 
     RowBox[{"\"\<6th Edition\>\"", " ", "->", " ", "\"\<LSX\>\""}], ",", " ",
      
     RowBox[{"\"\<6th Edition\>\"", " ", "->", " ", "\"\<Mini Unix\>\""}], 
     ",", " ", "\n", "  ", 
     RowBox[{"\"\<6th Edition\>\"", " ", "->", " ", "\"\<Wollongong\>\""}], 
     ",", " ", 
     RowBox[{"\"\<PWB 1.0\>\"", " ", "->", " ", "\"\<PWB 1.2\>\""}], ",", " ",
      "\n", "  ", 
     RowBox[{"\"\<PWB 1.0\>\"", " ", "->", " ", "\"\<USG 1.0\>\""}], ",", " ",
      
     RowBox[{"\"\<1 BSD\>\"", " ", "->", " ", "\"\<2 BSD\>\""}], ",", " ", 
     RowBox[{"\"\<Interdata\>\"", " ", "->", " ", "\"\<PWB 2.0\>\""}], ",", 
     " ", "\n", "  ", 
     RowBox[{"\"\<Interdata\>\"", " ", "->", " ", "\"\<Unix/TS 3.0\>\""}], 
     ",", " ", 
     RowBox[{"\"\<Interdata\>\"", " ", "->", " ", "\"\<7th Edition\>\""}], 
     ",", " ", "\n", "  ", 
     RowBox[{"\"\<PWB 1.2\>\"", " ", "->", " ", "\"\<PWB 2.0\>\""}], ",", " ",
      
     RowBox[{"\"\<USG 1.0\>\"", " ", "->", " ", "\"\<USG 2.0\>\""}], ",", " ",
      
     RowBox[{"\"\<USG 1.0\>\"", " ", "->", " ", "\"\<CB Unix 1\>\""}], ",", 
     " ", "\n", "  ", 
     RowBox[{"\"\<7th Edition\>\"", " ", "->", " ", "\"\<2 BSD\>\""}], ",", 
     " ", 
     RowBox[{"\"\<7th Edition\>\"", " ", "->", " ", "\"\<32V\>\""}], ",", " ",
      
     RowBox[{"\"\<7th Edition\>\"", " ", "->", " ", "\"\<Xenix\>\""}], ",", 
     " ", "\n", "  ", 
     RowBox[{"\"\<7th Edition\>\"", " ", "->", " ", "\"\<Ultrix-11\>\""}], 
     ",", " ", 
     RowBox[{"\"\<7th Edition\>\"", " ", "->", " ", "\"\<UniPlus+\>\""}], ",",
      " ", "\n", "  ", 
     RowBox[{"\"\<7th Edition\>\"", " ", "->", " ", "\"\<V7M\>\""}], ",", " ",
      
     RowBox[{"\"\<PWB 2.0\>\"", " ", "->", " ", "\"\<Unix/TS 3.0\>\""}], ",", 
     " ", 
     RowBox[{"\"\<USG 2.0\>\"", " ", "->", " ", "\"\<USG 3.0\>\""}], ",", " ",
      "\n", "  ", 
     RowBox[{"\"\<CB Unix 1\>\"", " ", "->", " ", "\"\<CB Unix 2\>\""}], ",", 
     " ", 
     RowBox[{"\"\<32V\>\"", " ", "->", " ", "\"\<3 BSD\>\""}], ",", " ", "\n",
      "  ", 
     RowBox[{"\"\<Unix/TS 1.0\>\"", " ", "->", " ", "\"\<Unix/TS 3.0\>\""}], 
     ",", " ", 
     RowBox[{"\"\<USG 3.0\>\"", " ", "->", " ", "\"\<Unix/TS 3.0\>\""}], ",", 
     " ", "\n", "  ", 
     RowBox[{"\"\<CB Unix 2\>\"", " ", "->", " ", "\"\<CB Unix 3\>\""}], ",", 
     " ", 
     RowBox[{"\"\<3 BSD\>\"", " ", "->", " ", "\"\<4 BSD\>\""}], ",", " ", 
     RowBox[{"\"\<V7M\>\"", " ", "->", " ", "\"\<Ultrix-11\>\""}], ",", " ", 
     "\n", "  ", 
     RowBox[{"\"\<Unix/TS 3.0\>\"", " ", "->", " ", "\"\<TS 4.0\>\""}], ",", 
     " ", 
     RowBox[{"\"\<CB Unix 3\>\"", " ", "->", " ", "\"\<Unix/TS++\>\""}], ",", 
     " ", "\n", "  ", 
     RowBox[{"\"\<CB Unix 3\>\"", " ", "->", " ", "\"\<PDP-11 Sys V\>\""}], 
     ",", " ", 
     RowBox[{"\"\<4 BSD\>\"", " ", "->", " ", "\"\<4.1 BSD\>\""}], ",", " ", 
     "\n", "  ", 
     RowBox[{"\"\<Unix/TS++\>\"", " ", "->", " ", "\"\<TS 4.0\>\""}], ",", 
     " ", 
     RowBox[{"\"\<4.1 BSD\>\"", " ", "->", " ", "\"\<8th Edition\>\""}], ",", 
     " ", 
     RowBox[{"\"\<4.1 BSD\>\"", " ", "->", " ", "\"\<4.2 BSD\>\""}], ",", 
     "\n", "   ", 
     RowBox[{"\"\<4.1 BSD\>\"", " ", "->", " ", "\"\<2.8 BSD\>\""}], ",", " ",
      
     RowBox[{"\"\<2 BSD\>\"", " ", "->", " ", "\"\<2.8 BSD\>\""}], ",", " ", 
     RowBox[{"\"\<TS 4.0\>\"", " ", "->", " ", "\"\<System V.0\>\""}], ",", 
     " ", "\n", "  ", 
     RowBox[{"\"\<4.2 BSD\>\"", " ", "->", " ", "\"\<4.3 BSD\>\""}], ",", " ",
      
     RowBox[{"\"\<4.2 BSD\>\"", " ", "->", " ", "\"\<Ultrix-32\>\""}], ",", 
     " ", 
     RowBox[{"\"\<2.8 BSD\>\"", " ", "->", " ", "\"\<2.9 BSD\>\""}], ",", " ",
      "\n", "  ", 
     RowBox[{"\"\<2.8 BSD\>\"", " ", "->", " ", "\"\<Ultrix-11\>\""}], ",", 
     " ", 
     RowBox[{"\"\<System V.0\>\"", " ", "->", " ", "\"\<System V.2\>\""}], 
     ",", " ", "\n", "  ", 
     RowBox[{"\"\<8th Edition\>\"", " ", "->", " ", "\"\<9th Edition\>\""}], 
     ",", " ", 
     RowBox[{"\"\<System V.2\>\"", " ", "->", " ", "\"\<System V.3\>\""}]}], 
    "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", " ", "True"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "0.7"}], ",", 
   RowBox[{"PlotRangePadding", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->991263046],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxVlwk4VVsbx4+ZYzrHGRxTpq6UJolItV6lNInSvVdpQDRoMDVqklJ0SzI1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    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.01662309542902967, 0.7}}], 
      ArrowBox[{1, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73,
        74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 2}], ArrowBox[{1, 3}], 
      ArrowBox[{2, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99,
        100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 4}], 
      ArrowBox[{2, 5}], ArrowBox[{2, 6}], ArrowBox[{2, 7}], ArrowBox[{2, 8}], 
      ArrowBox[{3, 9}], ArrowBox[{3, 10}], ArrowBox[{4, 11}], 
      ArrowBox[{5, 12}], 
      ArrowBox[{5, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122,
        123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 
       13}], ArrowBox[{5, 14}], 
      ArrowBox[{9, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
        149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 
       12}], ArrowBox[{10, 15}], ArrowBox[{10, 16}], 
      ArrowBox[{11, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 
       174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 
       188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 
       202, 203, 204, 205, 206, 34}], ArrowBox[{12, 13}], 
      ArrowBox[{13, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 
       218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 
       232, 28}], ArrowBox[{14, 11}], ArrowBox[{14, 17}], ArrowBox[{14, 18}], 
      ArrowBox[{14, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 
       244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 
       258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 
       272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 
       286, 287, 288, 289, 290, 291, 292, 293, 294, 19}], ArrowBox[{14, 20}], 
      ArrowBox[{14, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 
       306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 
       320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 
       334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 
       21}], ArrowBox[{15, 22}], ArrowBox[{16, 23}], ArrowBox[{17, 24}], 
      ArrowBox[{21, 19}], ArrowBox[{22, 13}], ArrowBox[{23, 26}], 
      ArrowBox[{24, 27}], ArrowBox[{25, 13}], ArrowBox[{26, 29}], 
      ArrowBox[{26, 30}], ArrowBox[{27, 31}], ArrowBox[{28, 35}], 
      ArrowBox[{29, 28}], ArrowBox[{31, 32}], ArrowBox[{31, 33}], 
      ArrowBox[{31, 34}], ArrowBox[{32, 40}], ArrowBox[{33, 36}], 
      ArrowBox[{33, 37}], ArrowBox[{34, 38}], ArrowBox[{34, 19}], 
      ArrowBox[{35, 39}], ArrowBox[{39, 41}]}, {InsetBox[
       FrameBox["\<\"5th Edition\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["\<\"6th Edition\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["\<\"PWB 1.0\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["\<\"1 BSD\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["\<\"Interdata\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["\<\"LSX\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["\<\"Mini Unix\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["\<\"Wollongong\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["\<\"PWB 1.2\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["\<\"USG 1.0\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10], InsetBox[
       FrameBox["\<\"2 BSD\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 11], InsetBox[
       FrameBox["\<\"PWB 2.0\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 12], InsetBox[
       FrameBox["\<\"Unix/TS 3.0\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 13], InsetBox[
       FrameBox["\<\"7th Edition\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 14], InsetBox[
       FrameBox["\<\"USG 2.0\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 15], InsetBox[
       FrameBox["\<\"CB Unix 1\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 16], InsetBox[
       FrameBox["\<\"32V\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 17], InsetBox[
       FrameBox["\<\"Xenix\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 18], InsetBox[
       FrameBox["\<\"Ultrix-11\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 19], InsetBox[
       FrameBox["\<\"UniPlus+\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 20], InsetBox[
       FrameBox["\<\"V7M\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 21], InsetBox[
       FrameBox["\<\"USG 3.0\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 22], InsetBox[
       FrameBox["\<\"CB Unix 2\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 23], InsetBox[
       FrameBox["\<\"3 BSD\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 24], InsetBox[
       FrameBox["\<\"Unix/TS 1.0\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 25], InsetBox[
       FrameBox["\<\"CB Unix 3\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 26], InsetBox[
       FrameBox["\<\"4 BSD\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 27], InsetBox[
       FrameBox["\<\"TS 4.0\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 28], InsetBox[
       FrameBox["\<\"Unix/TS++\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 29], InsetBox[
       FrameBox["\<\"PDP-11 Sys V\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 30], InsetBox[
       FrameBox["\<\"4.1 BSD\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 31], InsetBox[
       FrameBox["\<\"8th Edition\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 32], InsetBox[
       FrameBox["\<\"4.2 BSD\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 33], InsetBox[
       FrameBox["\<\"2.8 BSD\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 34], InsetBox[
       FrameBox["\<\"System V.0\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 35], InsetBox[
       FrameBox["\<\"4.3 BSD\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 36], InsetBox[
       FrameBox["\<\"Ultrix-32\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 37], InsetBox[
       FrameBox["\<\"2.9 BSD\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 38], InsetBox[
       FrameBox["\<\"System V.2\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 39], InsetBox[
       FrameBox["\<\"9th Edition\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 40], InsetBox[
       FrameBox["\<\"System V.3\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 41]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 10.}, {-2.1155030429306407`, 8.}, {
     1.2239238771341547`, 9.}, {-4.365790177744572, 6.}, {-0.5018286175537128,
      7.}, {-4.501828619960861, 7.}, {-3.501828620045444, 
     7.}, {-2.501828619634921, 7.}, {2.477331906931653, 8.}, {
     1.2239238767027132`, 8.}, {-5.501828616725504, 5.}, {
     0.49817138344837986`, 6.}, {0.4981713850399103, 
     5.}, {-2.5018286159084937`, 6.}, {0.8535491700790772, 7.}, {
     1.8535491675826563`, 7.}, {-0.5018286153480176, 5.}, {-4.501828617525774,
      5.}, {-2.5018286153749045`, 0.}, {-3.5018286162740537`, 
     5.}, {-2.501828615265566, 1.}, {1.4981713845602371`, 6.}, {
     2.498171384516553, 6.}, {-0.5018286139568318, 4.}, {-1.5018286172077353`,
      6.}, {2.4981713880771395`, 5.}, {-0.5018286137473922, 3.}, {
     2.120652867628877, 3.}, {2.498171388571393, 4.}, {1.4981713881933274`, 
     4.}, {-0.50182861406293, 2.}, {0.49817138468804956`, 
     1.}, {-0.5018286147815161, 1.}, {-3.5018286154622444`, 1.}, {
     2.1206528679618373`, 2.}, {-1.501828615749048, 0.}, {-0.5018286154889608,
      0.}, {-3.5018286153975, 0.}, {2.1206528671554565`, 1.}, {
     0.4981713847714673, 0.}, {2.1206528667863154`, 0.}}]& ],
  AspectRatio->0.7,
  FrameTicks->None,
  ImageSize->{628.355882071716, Automatic},
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{632, 436},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->1564431111]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Hierarchical Drawing of Directed Graphs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 19.6784248}", "context" -> "", 
    "keywords" -> {
     "digraph layout", "graph drawing", "graph embedding", "graph layout", 
      "graph visualization", "network layout", "network visualization"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "LayeredGraphPlot attempts to draw the vertices of a graph in a series of \
layers, placing dominant vertices at the top, and vertices lower in the \
hierarchy progressively further down. Hierarchical graph drawing. \
LayeredGraphPlot draws a graph so that the edges point predominantly \
downward. The second argument of LayeredGraphPlot specifies the position of \
the root. Possible values for this argument are Right, Left, Top, and \
Bottom.", "synonyms" -> {}, "title" -> 
    "Hierarchical Drawing of Directed Graphs", "type" -> "Tutorial", "uri" -> 
    "tutorial/LayeredGraphDrawing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "graphplot"->{
  Cell[1209, 42, 118, 2, 70, "Title",
   CellTags->{"graphplot", "i:3", "b:0.1"},
   CellID->672278587]},
 "i:3"->{
  Cell[1209, 42, 118, 2, 70, "Title",
   CellTags->{"graphplot", "i:3", "b:0.1"},
   CellID->672278587]},
 "b:0.1"->{
  Cell[1209, 42, 118, 2, 70, "Title",
   CellTags->{"graphplot", "i:3", "b:0.1"},
   CellID->672278587],
  Cell[1689, 57, 2664, 88, 70, "DefinitionBox",
   CellTags->"b:0.1",
   CellID->25485965],
  Cell[4356, 147, 86, 2, 70, "Caption",
   CellTags->"b:0.1",
   CellID->164814425],
  Cell[9489, 285, 57, 2, 70, "Text",
   CellTags->"b:0.1",
   CellID->1531065410],
  Cell[13640, 375, 313, 9, 70, "Text",
   CellTags->"b:0.1",
   CellID->379372821],
  Cell[13978, 388, 114, 2, 70, "Section",
   CellTags->{"Options_for_GraphPlot", "b:0.1"},
   CellID->267311437],
  Cell[14095, 392, 403, 14, 70, "Text",
   CellTags->"b:0.1",
   CellID->66806916],
  Cell[14501, 408, 3591, 105, 70, "DefinitionBox3Col",
   CellTags->"b:0.1",
   CellID->143533737],
  Cell[18095, 515, 227, 9, 70, "Caption",
   CellTags->"b:0.1",
   CellID->428527873],
  Cell[18347, 528, 74, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->94783224],
  Cell[22582, 648, 74, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->149979569],
  Cell[37993, 1056, 83, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->229062904],
  Cell[38079, 1060, 1136, 35, 70, "Text",
   CellTags->"b:0.1",
   CellID->1564098284],
  Cell[39218, 1097, 88, 2, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->683565354],
  Cell[39331, 1103, 386, 11, 47, "Input",
   CellTags->"b:0.1",
   CellID->115400586],
  Cell[39720, 1116, 1455, 29, 283, "Output",
   Evaluatable->False,
   CellTags->"b:0.1",
   CellID->5215282],
  Cell[41190, 1148, 2480, 88, 70, "Text",
   CellTags->"b:0.1",
   CellID->270347621],
  Cell[43673, 1238, 194, 5, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->22126029],
  Cell[43892, 1247, 1361, 37, 70, "Input",
   CellTags->"b:0.1",
   CellID->445960829],
  Cell[45256, 1286, 23686, 452, 70, "Output",
   CellTags->"b:0.1",
   CellID->824377347],
  Cell[78863, 1943, 75, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->82725606],
  Cell[78941, 1947, 1583, 50, 70, "Text",
   CellTags->"b:0.1",
   CellID->904561043],
  Cell[80527, 1999, 147, 4, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->239623524],
  Cell[85444, 2100, 151, 5, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->1229163597],
  Cell[89143, 2198, 115, 2, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->585581490],
  Cell[94374, 2304, 79, 2, 70, "Subsubsection",
   CellTags->"b:0.1",
   CellID->1079530539],
  Cell[97083, 2390, 143, 4, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->792188815],
  Cell[108564, 2597, 221, 7, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->134849000],
  Cell[119767, 2806, 78, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->155567426],
  Cell[120269, 2827, 70, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->43937672],
  Cell[120342, 2831, 575, 18, 70, "Text",
   CellTags->"b:0.1",
   CellID->680585317],
  Cell[120920, 2851, 144, 4, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->58817067],
  Cell[121089, 2859, 1197, 32, 65, "Input",
   CellTags->"b:0.1",
   CellID->793185],
  Cell[122289, 2893, 3869, 68, 222, "Output",
   Evaluatable->False,
   CellTags->"b:0.1",
   CellID->331166597],
  Cell[126207, 2967, 74, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->84930587],
  Cell[127714, 3017, 152, 5, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->1974872317],
  Cell[133759, 3150, 146, 4, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->1548899949],
  Cell[138901, 3271, 160, 5, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->735821658],
  Cell[139086, 3280, 788, 21, 65, "Input",
   CellTags->"b:0.1",
   CellID->51804372],
  Cell[139877, 3303, 4588, 80, 167, "Output",
   Evaluatable->False,
   CellTags->"b:0.1",
   CellID->93836031],
  Cell[144514, 3389, 83, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->405721262],
  Cell[144600, 3393, 655, 20, 70, "Text",
   CellTags->"b:0.1",
   CellID->544211538],
  Cell[145258, 3415, 117, 2, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->369012665],
  Cell[145400, 3421, 2183, 61, 70, "Input",
   CellTags->"b:0.1",
   CellID->533487069],
  Cell[147586, 3484, 2637, 75, 70, "Output",
   CellTags->"b:0.1",
   CellID->2010307850],
  Cell[156053, 3706, 76, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->156137816],
  Cell[156132, 3710, 2876, 94, 70, "Text",
   CellTags->"b:0.1",
   CellID->659301986],
  Cell[168552, 4036, 85, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->283881111],
  Cell[169513, 4067, 210, 5, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->844347480],
  Cell[172703, 4162, 116, 2, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->1803124116],
  Cell[174705, 4212, 1300, 45, 70, "Text",
   CellTags->"b:0.1",
   CellID->639309593],
  Cell[176008, 4259, 99, 2, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->703653719],
  Cell[176132, 4265, 1253, 34, 65, "Input",
   CellTags->"b:0.1",
   CellID->1950334],
  Cell[177388, 4301, 5724, 99, 213, "Output",
   Evaluatable->False,
   CellTags->"b:0.1",
   CellID->154300761],
  Cell[183173, 4407, 74, 2, 70, "Section",
   CellTags->"b:0.1",
   CellID->806578725],
  Cell[183272, 4413, 73, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->2124904963],
  Cell[183348, 4417, 301, 9, 70, "Text",
   CellTags->"b:0.1",
   CellID->363554723],
  Cell[183652, 4428, 88, 2, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->1777602637],
  Cell[188584, 4541, 118, 2, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->2051305448],
  Cell[199916, 4776, 73, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->437210322],
  Cell[199992, 4780, 247, 9, 70, "Text",
   CellTags->"b:0.1",
   CellID->333441302],
  Cell[200242, 4791, 93, 2, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->763006443],
  Cell[206894, 4930, 93, 2, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->503437744],
  Cell[218105, 5151, 78, 2, 70, "Subsection",
   CellTags->"b:0.1",
   CellID->1088709261],
  Cell[218186, 5155, 254, 8, 70, "Text",
   CellTags->"b:0.1",
   CellID->2059755923],
  Cell[218443, 5165, 92, 2, 70, "MathCaption",
   CellTags->"b:0.1",
   CellID->121456149]},
 "Options_for_GraphPlot"->{
  Cell[13978, 388, 114, 2, 70, "Section",
   CellTags->{"Options_for_GraphPlot", "b:0.1"},
   CellID->267311437]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"graphplot", 242053, 5649},
 {"i:3", 242169, 5653},
 {"b:0.1", 242287, 5657},
 {"Options_for_GraphPlot", 248388, 5860}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 584, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1209, 42, 118, 2, 70, "Title",
 CellTags->{"graphplot", "i:3", "b:0.1"},
 CellID->672278587],
Cell[1330, 46, 356, 9, 70, "Text",
 CellID->621106430],
Cell[1689, 57, 2664, 88, 70, "DefinitionBox",
 CellTags->"b:0.1",
 CellID->25485965],
Cell[4356, 147, 86, 2, 70, "Caption",
 CellTags->"b:0.1",
 CellID->164814425],
Cell[4445, 151, 970, 34, 70, "Text",
 CellID->872256052],
Cell[5418, 187, 71, 1, 70, "MathCaption",
 CellID->185285925],
Cell[CellGroupData[{
Cell[5514, 192, 571, 15, 47, "Input",
 CellID->188451088],
Cell[6088, 209, 3386, 73, 199, "Output",
 CellID->600772132]
}, Open  ]],
Cell[9489, 285, 57, 2, 70, "Text",
 CellTags->"b:0.1",
 CellID->1531065410],
Cell[9549, 289, 115, 3, 70, "MathCaption",
 CellID->2038736600],
Cell[CellGroupData[{
Cell[9689, 296, 585, 15, 47, "Input",
 CellID->1547345965],
Cell[10277, 313, 3348, 59, 233, "Output",
 Evaluatable->False,
 CellID->112108469]
}, Open  ]],
Cell[13640, 375, 313, 9, 70, "Text",
 CellTags->"b:0.1",
 CellID->379372821],
Cell[CellGroupData[{
Cell[13978, 388, 114, 2, 70, "Section",
 CellTags->{"Options_for_GraphPlot", "b:0.1"},
 CellID->267311437],
Cell[14095, 392, 403, 14, 70, "Text",
 CellTags->"b:0.1",
 CellID->66806916],
Cell[14501, 408, 3591, 105, 70, "DefinitionBox3Col",
 CellTags->"b:0.1",
 CellID->143533737],
Cell[18095, 515, 227, 9, 70, "Caption",
 CellTags->"b:0.1",
 CellID->428527873],
Cell[CellGroupData[{
Cell[18347, 528, 74, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->94783224],
Cell[18424, 532, 670, 24, 70, "Text",
 CellID->4330256],
Cell[19097, 558, 119, 3, 70, "MathCaption",
 CellID->57501221],
Cell[CellGroupData[{
Cell[19241, 565, 577, 16, 70, "Input",
 CellID->499064340],
Cell[19821, 583, 2712, 59, 176, "Output",
 CellID->1519279838]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22582, 648, 74, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->149979569],
Cell[22659, 652, 1162, 38, 70, "Text",
 CellID->1357462998],
Cell[23824, 692, 81, 1, 70, "MathCaption",
 CellID->51376678],
Cell[CellGroupData[{
Cell[23930, 697, 675, 19, 70, "Input",
 CellID->317591580],
Cell[24608, 718, 3629, 80, 165, "Output",
 CellID->770527606]
}, Open  ]],
Cell[28252, 801, 166, 4, 70, "MathCaption",
 CellID->862272319],
Cell[CellGroupData[{
Cell[28443, 809, 739, 20, 70, "Input",
 CellID->228531803],
Cell[29185, 831, 3347, 74, 70, "Output",
 CellID->1239534488]
}, Open  ]],
Cell[32547, 908, 630, 21, 70, "MathCaption",
 CellID->442920185],
Cell[CellGroupData[{
Cell[33202, 933, 842, 24, 70, "Input",
 CellID->403735836],
Cell[34047, 959, 3858, 88, 70, "Output",
 CellID->698803506]
}, Open  ]],
Cell[37920, 1050, 36, 1, 70, "Text",
 CellID->782609163]
}, Open  ]],
Cell[CellGroupData[{
Cell[37993, 1056, 83, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->229062904],
Cell[38079, 1060, 1136, 35, 70, "Text",
 CellTags->"b:0.1",
 CellID->1564098284],
Cell[39218, 1097, 88, 2, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->683565354],
Cell[CellGroupData[{
Cell[39331, 1103, 386, 11, 47, "Input",
 CellTags->"b:0.1",
 CellID->115400586],
Cell[39720, 1116, 1455, 29, 283, "Output",
 Evaluatable->False,
 CellTags->"b:0.1",
 CellID->5215282]
}, Open  ]],
Cell[41190, 1148, 2480, 88, 70, "Text",
 CellTags->"b:0.1",
 CellID->270347621],
Cell[43673, 1238, 194, 5, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->22126029],
Cell[CellGroupData[{
Cell[43892, 1247, 1361, 37, 70, "Input",
 CellTags->"b:0.1",
 CellID->445960829],
Cell[45256, 1286, 23686, 452, 70, "Output",
 CellTags->"b:0.1",
 CellID->824377347]
}, Open  ]],
Cell[68957, 1741, 493, 15, 70, "MathCaption",
 CellID->425797646],
Cell[69453, 1758, 102, 3, 70, "Input",
 CellID->213900220],
Cell[CellGroupData[{
Cell[69580, 1765, 1332, 36, 83, "Input",
 CellID->300897750],
Cell[70915, 1803, 7899, 134, 345, "Output",
 Evaluatable->False,
 CellID->46665783]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[78863, 1943, 75, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->82725606],
Cell[78941, 1947, 1583, 50, 70, "Text",
 CellTags->"b:0.1",
 CellID->904561043],
Cell[80527, 1999, 147, 4, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->239623524],
Cell[CellGroupData[{
Cell[80699, 2007, 593, 16, 47, "Input",
 CellID->82630293],
Cell[81295, 2025, 4134, 72, 218, "Output",
 Evaluatable->False,
 CellID->266448109]
}, Open  ]],
Cell[85444, 2100, 151, 5, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->1229163597],
Cell[CellGroupData[{
Cell[85620, 2109, 835, 23, 70, "Input",
 CellID->127398837],
Cell[86458, 2134, 2670, 61, 249, "Output",
 CellID->113646454]
}, Open  ]],
Cell[89143, 2198, 115, 2, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->585581490],
Cell[CellGroupData[{
Cell[89283, 2204, 648, 17, 47, "Input",
 CellID->1115324],
Cell[89934, 2223, 4403, 76, 225, "Output",
 Evaluatable->False,
 CellID->1055638202]
}, Open  ]],
Cell[CellGroupData[{
Cell[94374, 2304, 79, 2, 70, "Subsubsection",
 CellTags->"b:0.1",
 CellID->1079530539],
Cell[94456, 2308, 2624, 80, 70, "Text",
 CellID->1733232121],
Cell[97083, 2390, 143, 4, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->792188815],
Cell[CellGroupData[{
Cell[97251, 2398, 354, 11, 28, "Input",
 CellID->1585754271],
Cell[97608, 2411, 10941, 183, 215, "Output",
 Evaluatable->False,
 CellID->126691042]
}, Open  ]],
Cell[108564, 2597, 221, 7, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->134849000],
Cell[CellGroupData[{
Cell[108810, 2608, 456, 14, 47, "Input",
 CellID->439127616],
Cell[109269, 2624, 10437, 175, 189, "Output",
 Evaluatable->False,
 CellID->576496207]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[119767, 2806, 78, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->155567426],
Cell[119848, 2810, 384, 12, 70, "Text",
 CellID->1145219532]
}, Open  ]],
Cell[CellGroupData[{
Cell[120269, 2827, 70, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->43937672],
Cell[120342, 2831, 575, 18, 70, "Text",
 CellTags->"b:0.1",
 CellID->680585317],
Cell[120920, 2851, 144, 4, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->58817067],
Cell[CellGroupData[{
Cell[121089, 2859, 1197, 32, 65, "Input",
 CellTags->"b:0.1",
 CellID->793185],
Cell[122289, 2893, 3869, 68, 222, "Output",
 Evaluatable->False,
 CellTags->"b:0.1",
 CellID->331166597]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[126207, 2967, 74, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->84930587],
Cell[126284, 2971, 1427, 44, 70, "Text",
 CellID->988897229],
Cell[127714, 3017, 152, 5, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->1974872317],
Cell[CellGroupData[{
Cell[127891, 3026, 715, 19, 70, "Input",
 CellID->591463435],
Cell[128609, 3047, 5135, 100, 182, "Output",
 CellID->821832375]
}, Open  ]],
Cell[133759, 3150, 146, 4, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->1548899949],
Cell[CellGroupData[{
Cell[133930, 3158, 935, 26, 70, "Input",
 CellID->693886729],
Cell[134868, 3186, 4018, 82, 171, "Output",
 CellID->1533564267]
}, Open  ]],
Cell[138901, 3271, 160, 5, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->735821658],
Cell[CellGroupData[{
Cell[139086, 3280, 788, 21, 65, "Input",
 CellTags->"b:0.1",
 CellID->51804372],
Cell[139877, 3303, 4588, 80, 167, "Output",
 Evaluatable->False,
 CellTags->"b:0.1",
 CellID->93836031]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[144514, 3389, 83, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->405721262],
Cell[144600, 3393, 655, 20, 70, "Text",
 CellTags->"b:0.1",
 CellID->544211538],
Cell[145258, 3415, 117, 2, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->369012665],
Cell[CellGroupData[{
Cell[145400, 3421, 2183, 61, 70, "Input",
 CellTags->"b:0.1",
 CellID->533487069],
Cell[147586, 3484, 2637, 75, 70, "Output",
 CellTags->"b:0.1",
 CellID->2010307850]
}, Open  ]],
Cell[150238, 3562, 78, 1, 70, "MathCaption",
 CellID->447953798],
Cell[CellGroupData[{
Cell[150341, 3567, 759, 20, 70, "Input",
 CellID->2118172987],
Cell[151103, 3589, 4901, 111, 70, "Output",
 CellID->1532810880]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[156053, 3706, 76, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->156137816],
Cell[156132, 3710, 2876, 94, 70, "Text",
 CellTags->"b:0.1",
 CellID->659301986],
Cell[159011, 3806, 126, 3, 70, "MathCaption",
 CellID->1601243868],
Cell[CellGroupData[{
Cell[159162, 3813, 786, 22, 85, "Input",
 CellID->111039013],
Cell[159951, 3837, 2637, 47, 129, "Output",
 Evaluatable->False,
 CellID->589235889]
}, Open  ]],
Cell[162603, 3887, 94, 1, 70, "MathCaption",
 CellID->97622059],
Cell[CellGroupData[{
Cell[162722, 3892, 444, 11, 70, "Input",
 CellID->1544203859],
Cell[163169, 3905, 2434, 50, 201, "Output",
 CellID->1379587565]
}, Open  ]],
Cell[165618, 3958, 177, 4, 70, "MathCaption",
 CellID->992105691],
Cell[CellGroupData[{
Cell[165820, 3966, 447, 11, 70, "Input",
 CellID->1314056000],
Cell[166270, 3979, 2233, 51, 70, "Output",
 CellID->1661294983]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[168552, 4036, 85, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->283881111],
Cell[168640, 4040, 870, 25, 70, "Text",
 CellID->1022272051],
Cell[169513, 4067, 210, 5, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->844347480],
Cell[169726, 4074, 477, 14, 70, "Input",
 CellID->1183768490],
Cell[CellGroupData[{
Cell[170228, 4092, 113, 3, 70, "Input",
 CellID->727769332],
Cell[170344, 4097, 2344, 62, 70, "Output",
 CellID->68826304]
}, Open  ]],
Cell[172703, 4162, 116, 2, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->1803124116],
Cell[CellGroupData[{
Cell[172844, 4168, 191, 5, 70, "Input",
 CellID->271336278],
Cell[173038, 4175, 1652, 34, 151, "Output",
 CellID->390441064]
}, Open  ]],
Cell[174705, 4212, 1300, 45, 70, "Text",
 CellTags->"b:0.1",
 CellID->639309593],
Cell[176008, 4259, 99, 2, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->703653719],
Cell[CellGroupData[{
Cell[176132, 4265, 1253, 34, 65, "Input",
 CellTags->"b:0.1",
 CellID->1950334],
Cell[177388, 4301, 5724, 99, 213, "Output",
 Evaluatable->False,
 CellTags->"b:0.1",
 CellID->154300761]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[183173, 4407, 74, 2, 70, "Section",
 CellTags->"b:0.1",
 CellID->806578725],
Cell[CellGroupData[{
Cell[183272, 4413, 73, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->2124904963],
Cell[183348, 4417, 301, 9, 70, "Text",
 CellTags->"b:0.1",
 CellID->363554723],
Cell[183652, 4428, 88, 2, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->1777602637],
Cell[CellGroupData[{
Cell[183765, 4434, 957, 22, 70, "Input",
 CellID->676481098],
Cell[184725, 4458, 3844, 80, 386, "Output",
 CellID->1326404970]
}, Open  ]],
Cell[188584, 4541, 118, 2, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->2051305448],
Cell[CellGroupData[{
Cell[188727, 4547, 2753, 46, 70, "Input",
 CellID->426596807],
Cell[191483, 4595, 8384, 175, 474, "Output",
 CellID->776088936]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[199916, 4776, 73, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->437210322],
Cell[199992, 4780, 247, 9, 70, "Text",
 CellTags->"b:0.1",
 CellID->333441302],
Cell[200242, 4791, 93, 2, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->763006443],
Cell[CellGroupData[{
Cell[200360, 4797, 1337, 24, 70, "Input",
 CellID->699438697],
Cell[201700, 4823, 5179, 104, 235, "Output",
 CellID->1307705260]
}, Open  ]],
Cell[206894, 4930, 93, 2, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->503437744],
Cell[CellGroupData[{
Cell[207012, 4936, 2074, 36, 70, "Input",
 CellID->657404965],
Cell[209089, 4974, 8967, 171, 235, "Output",
 CellID->826622652]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[218105, 5151, 78, 2, 70, "Subsection",
 CellTags->"b:0.1",
 CellID->1088709261],
Cell[218186, 5155, 254, 8, 70, "Text",
 CellTags->"b:0.1",
 CellID->2059755923],
Cell[218443, 5165, 92, 2, 70, "MathCaption",
 CellTags->"b:0.1",
 CellID->121456149],
Cell[CellGroupData[{
Cell[218560, 5171, 4772, 102, 70, "Input",
 CellID->991263046],
Cell[223335, 5275, 16816, 326, 457, "Output",
 CellID->1564431111]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[240202, 5607, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

