(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40855,       1470]
NotebookOptionsPosition[     30971,       1136]
NotebookOutlinePosition[     34233,       1228]
CellTagsIndexPosition[     33999,       1216]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Linear Algebra in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/LinearAlgebraOverview"], 
          "Matrix and Tensor Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations"], 
          "Working with Sparse Arrays" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraSparseArrays"], 
          "Matrix Computations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraMatrixComputations"], "Matrix Types" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraMatrixTypes"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Linear Algebra in Mathematica\"\>", 
       2->"\<\"Matrix and Tensor Operations\"\>", 
       3->"\<\"Working with Sparse Arrays\"\>", 
       4->"\<\"Matrix Computations\"\>", 
       5->"\<\"Matrix Types\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Linear Systems" :> 
          Documentation`HelpLookup["paclet:guide/LinearSystems"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Matrices and Linear Algebra\"\>", 
       2->"\<\"Linear Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Introduction to Linear Algebra in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Title",
 CellID->509267359],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has a broad range of functions to support linear algebra operations and to \
integrate them into the system. It can work with vectors, matrices, and \
tensors that can contain machine-precision floating point numbers, ",
 "arbitrary-precision",
 " floating point numbers, complex floating point numbers, integers, rational \
numbers, and general symbolic quantities. Linear algebra operations are \
supported for matrices that contain all these different types of entry."
}], "Text",
 CellID->205540823],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports both dense and sparse matrices. Several tutorials will \
concentrate on dense matrices. Sparse matrices are documented under \"",
 ButtonBox["Working with Sparse Arrays\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraSparseArrays"],
 ". In general, all the operations that work on dense matrices work on sparse \
matrices in an equivalent way."
}], "Text",
 CellID->1370907785],

Cell[TextData[{
 "Matrices are represented in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with lists. They can be entered directly with the { } notation that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides for lists."
}], "Text",
 CellID->495093832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.5", ",", "1.6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.7", ",", "1.8"}], "}"}]}], "}"}]], "Input",
 CellID->1690385946],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.5`", ",", "1.6`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.7`", ",", "1.8`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->1255428259]
}, Open  ]],

Cell[TextData[{
 "They can be created programmatically with ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 "."
}], "Text",
 CellID->955917238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"i", "*", "j"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellID->775855859],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "4"], ",", 
     FractionBox["1", "6"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "3"], ",", 
     FractionBox["1", "6"], ",", 
     FractionBox["1", "9"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{246, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    SubscriptBox["m", 
     RowBox[{"i", ",", "j"}]], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellID->1311632030],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV9tOwkAU3F6goAJeeDCxKj/gb+iTXyCYNMQEHowG+f+625Zap7OXFjEQ
bdJmz9k5Z2e2Z7fbx2S9eHlN1st5MnlYJe+L5fxjcv+2kq7AE8KbCiFGl0K2
U9nK7jhNUxGoVnaJG7Bvwb7bMX6sHiIEL9qRfHSk6YOf+QZVbFj65aVAmFmP
9gka7WOwe8UogQPPYRVr5alHt+XJ4nQ8S6wTT45W3o6FZzZ2bfYQdQR2sKFe
jiUKBmrMU4b+YiYbXRMS2RnsoMiDs91nerR8RwxN+VLkD/BF2zfyPWNoypci
LfxM+rxUWy3fKi8iVR1Zxuo4xtVWUMvxME//X8WvqbDtnoY606yS8lmLYlrV
2ohaRYeNonuMMcmG++tfU4ZvtttImS3arIydfJrviUy/7ovp/k5OnKKqelX/
sFUUnhSGTgp8yIJ1wRVgVJS6KLBFHb4CVrnytyKrsW32ROX1C22+kZ3qxdPT
oBEaGeIZz21v25xg3GoZ1w1n7LJ/HibzXX5PY+q9pt6LVjO4XyOM289l7V8t
h+Wpr4gvJj6qcM8zbzFnFXtmebe2/mcnFra18gT2ecP+qSV//setmjOHlvA+
AeHTZGM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{348, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->215118836]
}, Open  ]],

Cell["You can extract size information.", "Text",
 CellID->180240598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "mat", "]"}]], "Input",
 CellID->1351788316],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "3"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->1276725399]
}, Open  ]],

Cell["It is also possible to test if something is a matrix.", "Text",
 CellID->267180169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", " ", "mat", "]"}]], "Input",
 CellID->108794506],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->1000678745]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 " helps to make the structure of the matrix clearer."
}], "Text",
 CellID->1463227558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "mat", "]"}]], "Input",
 CellID->1630325509],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["m", 
       RowBox[{"1", ",", "1"}]], 
      SubscriptBox["m", 
       RowBox[{"1", ",", "2"}]], 
      SubscriptBox["m", 
       RowBox[{"1", ",", "3"}]]},
     {
      SubscriptBox["m", 
       RowBox[{"2", ",", "1"}]], 
      SubscriptBox["m", 
       RowBox[{"2", ",", "2"}]], 
      SubscriptBox["m", 
       RowBox[{"2", ",", "3"}]]},
     {
      SubscriptBox["m", 
       RowBox[{"3", ",", "1"}]], 
      SubscriptBox["m", 
       RowBox[{"3", ",", "2"}]], 
      SubscriptBox["m", 
       RowBox[{"3", ",", "3"}]]}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{109, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->1136977690]
}, Open  ]],

Cell[TextData[{
 "Matrices are important in many areas of computation because they are an \
efficient way to represent linear systems of equations. Many computer \
applications can work with matrices because they can work efficiently with \
arrays of numbers. However, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can also work directly with the systems of linear equations the matrices \
represent. Here, a matrix is multiplied by a vector of the unknowns and a \
system of equations is formed."
}], "Text",
 CellID->874544824],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.5", ",", "1.6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.7", ",", "1.8"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"eqns", "=", 
  RowBox[{"Thread", "[", 
   RowBox[{
    RowBox[{"mat", ".", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "\[Equal]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "6"}], "}"}]}], "]"}]}]}], "Input",
 CellID->1096776900],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"1.5`", " ", "x"}], "+", 
     RowBox[{"1.6`", " ", "y"}]}], "\[Equal]", "2"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"1.7`", " ", "x"}], "+", 
     RowBox[{"1.8`", " ", "y"}]}], "\[Equal]", "6"}]}], "}"}]], "Output",
 ImageSize->{227, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->1677216099]
}, Open  ]],

Cell[TextData[{
 "These equations can be solved with the algebraic equation solver, ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1100625371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"eqns", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellID->1933958786],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "299.99999999999756`"}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", "279.99999999999767`"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->1880318957]
}, Open  ]],

Cell[TextData[{
 "Alternatively, the matrix representation of the equations can be solved \
directly with the ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " command."
}], "Text",
 CellID->151361047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{"mat", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellID->1304478881],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"299.99999999999756`", ",", 
   RowBox[{"-", "279.99999999999767`"}]}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->716000744]
}, Open  ]],

Cell["\<\
Conversion between matrices and the linear systems they represent is often \
useful in order to understand the underlying principles. Using one form or \
the other can also be a very useful way to set up particular problems.\
\>", "Text",
 CellID->1473630267],

Cell[CellGroupData[{

Cell["Tensors and Arrays", "Section",
 CellTags->{"t:190", "c:2"},
 CellID->374996618],

Cell["\<\
A matrix has two indices that label each entry. By convention the values of \
these indices label the row and column when the matrix is written in a \
tabular form. A generalization of matrices can have less than or more than \
two indices. Typically an object with no indices is called a scalar, and one \
with one index is called a vector. An object with more than two indices is \
called a tensor, although a scalar, vector, or matrix can also be called a \
tensor.\
\>", "Text",
 CellID->1851138428],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " works with tensors that have arbitrary numbers of indices with the same \
list structure that is used for matrices. The number of levels of lists \
represents the number of indices. For example, the following is a vector."
}], "Text",
 CellID->1487965307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vec", "=", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]], "Input",
 CellID->785845434],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->679780188]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "vec", "]"}]], "Input",
 CellID->452617676],

Cell[BoxData[
 RowBox[{"{", "3", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->758202858]
}, Open  ]],

Cell["\<\
The following is a tensor with 3 indices, with lengths 2, 3, and 4, \
respectively. The number of indices required to label a tensor can be called \
the rank of the tensor.\
\>", "Text",
 CellID->2094956755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tensor", "=", 
  RowBox[{"{", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5", ",", "6", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5", ",", "6", ",", "7"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "6", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "6", ",", "5"}], "}"}]}], "}"}]}], 
   "}"}]}]], "Input",
 CellID->1943788720],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6", ",", "7"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "6", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "6", ",", "5"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{556, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->1735778876]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "tensor", "]"}]], "Input",
 CellID->1817708084],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", "4"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->117405566]
}, Open  ]],

Cell[TextData[{
 "It should be noted that the notion of a tensor as used in physics has \
additional properties beyond the labelling of elements",
 " ",
 "in generalized matrices. This is discussed more in the description of \
tensors given in ",
 ButtonBox["MathWorld",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraAppendix#487357441"],
 ". In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " the term tensor is used to refer to generalized matrices."
}], "Text",
 CellID->1845359816],

Cell[TextData[{
 "Many of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions that operate on matrices are also generalized to work for \
vectors and tensors. This important principle will be demonstrated many times \
in this document, and is covered under \"",
 ButtonBox["Matrix and Tensor Operations",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#1023128168"],
 "\"."
}], "Text",
 CellID->1003597538]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Matrices as ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "Expressions"
}], "Section",
 CellTags->{"t:2", "c:3"},
 CellID->1127257628],

Cell[TextData[{
 "One important feature of matrices in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is that they are ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. This means that all of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " commands that operate on ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions work on matrices. The same principle applies to vectors and \
tensors. The fact that all objects in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " have a common expression structure greatly enhances the expressive nature \
of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programming. This principle, sometimes called the fundamental principle of \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", may seem abstract, uninteresting, or obvious to people who have a \
background in purely numerical programming, but users who have a background \
in object oriented programming will recognize the benefits of a common parent \
object. Some examples of this principle will be discussed in this section."
}], "Text",
 CellID->718219962],

Cell["\<\
As demonstrated above, a matrix can be entered with a list notation.\
\>", "Text",
 CellID->117321547],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellID->433252483],

Cell[TextData[{
 "One important way to understand ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions is through the function ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ". This shows the literal details of how the expression is arranged in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". In this case, the tree structure of the matrix is seen. There is an outer \
node, which is a ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 "; in ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "this is called having a head of ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". The outer node has two arguments, each of which has the head ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 "; each of these has three arguments that are integers."
}], "Text",
 CellID->1704918451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "mat", "]"}]], "Input",
 CellID->690104036],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"List", "[", 
    RowBox[{
     RowBox[{"List", "[", 
      RowBox[{"1", ",", "2", ",", "3"}], "]"}], ",", 
     RowBox[{"List", "[", 
      RowBox[{"4", ",", "5", ",", "6"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->19355605]
}, Open  ]],

Cell[TextData[{
 "The head of the matrix expression can be inspected with the function ",
 Cell[BoxData[
  ButtonBox["Head",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Head"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1039622538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "mat", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1009044174],

Cell[BoxData["List"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->327072059]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Length",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Length"]], "InlineFormula"],
 " returns the number of arguments of the matrix expression."
}], "Text",
 CellID->1689442940],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "mat", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->438711946],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1120316271]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " can be used to extract elements of an expression."
}], "Text",
 CellID->18949801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", "[", 
  RowBox[{"[", " ", 
   RowBox[{"2", ",", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->661725651],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1952692191]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " operations such as ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Head",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Head"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Length",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Length"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " will work for any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. This is very convenient because it means that a common set of \
programming constructs will work for programming in many different \
applications, and not only for linear algebra. The same techniques apply to \
many other areas in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", for example, graphics programming, document programming, and symbolic \
algebra programming. These operations are often called structural operations \
because they work on the structure of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. They can be contrasted with other operations that are \
specific to linear algebra. For example, the function ",
 Cell[BoxData[
  ButtonBox["MatrixQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixQ"]], "InlineFormula"],
 " is specific to matrix computation."
}], "Text",
 CellID->1052560683]
}, Open  ]],

Cell[CellGroupData[{

Cell["Expression Input and Output", "Section",
 CellTags->{"t:118", "c:4"},
 CellID->1564598842],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " contains commands for I/O on expressions. It also has many commands for \
I/O with specially formatted data. The commands that can work with formatted \
data are reviewed under \"",
 ButtonBox["Import and Export of Matrices",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#2053293398"],
 "\". In this section the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " commands for I/O on expressions are reviewed."
}], "Text",
 CellID->275479979],

Cell[TextData[{
 "The concept of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " is completely equivalent to that of serializable objects in Java or C#. \
The ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression is a complete specification of the expression. Saving the ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " into a file and reading it back again will recreate the expression."
}], "Text",
 CellID->17264121],

Cell[TextData[{
 "You can save a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression into a file with the command ",
 Cell[BoxData[
  ButtonBox["Put",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Put"]], "InlineFormula"],
 ", entered using ",
 StyleBox[">>", "MR"],
 " as a short-cut notation."
}], "Text",
 CellID->247789302],

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"mat", ">>", "file.1"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->624007181],

Cell[TextData[{
 "The contents of the file can be inspected with",
 " ",
 Cell[BoxData[
  ButtonBox["FilePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FilePrint"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1526042766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<file.1\>\"", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->803572041],

Cell["{{1, 2, 3}, {4, 5, 6}}", "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->406326104]
}, Open  ]],

Cell[TextData[{
 "The file can be read back into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with ",
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 ", entered using ",
 StyleBox["<<", "MR"],
 " as a short-cut notation."
}], "Text",
 CellID->1904452273],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "file.1"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2033077423],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->24690645]
}, Open  ]],

Cell["\<\
This restores the matrix from the file so that it can be used for further \
computation.\
\>", "Text",
 CellID->741372298],

Cell[TextData[{
 "Another way to do I/O on matrices in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is to use ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". This is an interprocess communication mechanism that is particularly \
useful for communicating between different ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sessions."
}], "Text",
 CellID->544092592],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Put",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Put"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 " to store matrices in files is most useful if you want to save work from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to be restored later. If you want to exchange matrices with other \
applications, data saved in general formats is more useful; this is described \
under \"",
 ButtonBox["Import and Export of Matrices",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#2053293398"],
 "\"."
}], "Text",
 CellID->578824818]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Design Principles of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Section",
 CellTags->{"t:170", "c:5"},
 CellID->207795216],

Cell[TextData[{
 "The support for linear algebra demonstrates a number of important ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " design principles."
}], "Text",
 CellID->605785290],

Cell["\<\
It provides a wide range of functionality for technical computation.\
\>", "BulletedText",
 CellID->213398603],

Cell["\<\
It provides machine-precision computation that meets or surpasses the speed \
of dedicated machine-precision numerical applications.\
\>", "BulletedText",
 CellID->292630131],

Cell["\<\
It provides arbitrary-precision computation that is efficient enough to solve \
important classes of problems.\
\>", "BulletedText",
 CellID->497060087],

Cell["\<\
It integrates machine-precision and arbitrary-precision computation.\
\>", "BulletedText",
 CellID->377495379],

Cell[CellGroupData[{

Cell[TextData[{
 "It integrates machine- and arbitrary-precision computation with symbolic \
computation so that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is suitable for many different solution techniques."
}], "BulletedText",
 CellID->898141615],

Cell[TextData[{
 "These design principles underpin much of the design of linear algebra \
functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->403568542]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->92472899],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "TutorialMoreAbout",
 CellID->4791866],

Cell[TextData[ButtonBox["Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LinearSystems"]], "TutorialMoreAbout",
 CellID->212289775]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->152812842],

Cell[TextData[{
 ButtonBox["Linear Algebra in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraOverview"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->315063104],

Cell[TextData[ButtonBox["Matrix and Tensor Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations"]], \
"RelatedTutorials",
 CellID->3571032],

Cell[TextData[ButtonBox["Working with Sparse Arrays",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LinearAlgebraSparseArrays"]], "RelatedTutorials",\

 CellID->560755906],

Cell[TextData[ButtonBox["Matrix Computations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations"]], "RelatedTutorials",
 CellID->335456077],

Cell[TextData[ButtonBox["Matrix Types",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LinearAlgebraMatrixTypes"]], "RelatedTutorials",\

 CellID->472696132]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Introduction to Linear Algebra in Mathematica - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 34.6163072}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica has a broad range of functions to support linear algebra \
operations and to integrate them into the system. It can work with vectors, \
matrices, and tensors that can contain machine-precision floating point \
numbers, arbitrary-precision floating point numbers, complex floating point \
numbers, integers, rational numbers, and general symbolic quantities. Linear \
algebra operations are supported for matrices that contain all these \
different types of entry. Mathematica supports both dense and sparse \
matrices. Several tutorials will concentrate on dense matrices. Sparse \
matrices are documented under \"Working with Sparse Arrays\". In general, all \
the operations that work on dense matrices work on sparse matrices in an \
equivalent way. Matrices are represented in Mathematica with lists. They can \
be entered directly with the { } notation that Mathematica provides for \
lists.", "synonyms" -> {}, "title" -> 
    "Introduction to Linear Algebra in Mathematica", "type" -> "Tutorial", 
    "uri" -> "tutorial/LinearAlgebraIntroduction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "t:190"->{
  Cell[12077, 426, 86, 2, 70, "Section",
   CellTags->{"t:190", "c:2"},
   CellID->374996618]},
 "c:2"->{
  Cell[12077, 426, 86, 2, 70, "Section",
   CellTags->{"t:190", "c:2"},
   CellID->374996618]},
 "t:2"->{
  Cell[16692, 588, 160, 7, 70, "Section",
   CellTags->{"t:2", "c:3"},
   CellID->1127257628]},
 "c:3"->{
  Cell[16692, 588, 160, 7, 70, "Section",
   CellTags->{"t:2", "c:3"},
   CellID->1127257628]},
 "t:118"->{
  Cell[23234, 831, 96, 2, 70, "Section",
   CellTags->{"t:118", "c:4"},
   CellID->1564598842]},
 "c:4"->{
  Cell[23234, 831, 96, 2, 70, "Section",
   CellTags->{"t:118", "c:4"},
   CellID->1564598842]},
 "t:170"->{
  Cell[27929, 1015, 153, 6, 70, "Section",
   CellTags->{"t:170", "c:5"},
   CellID->207795216]},
 "c:5"->{
  Cell[27929, 1015, 153, 6, 70, "Section",
   CellTags->{"t:170", "c:5"},
   CellID->207795216]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"t:190", 33128, 1181},
 {"c:2", 33234, 1185},
 {"t:2", 33340, 1189},
 {"c:3", 33446, 1193},
 {"t:118", 33554, 1197},
 {"c:4", 33661, 1201},
 {"t:170", 33770, 1205},
 {"c:5", 33878, 1209}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2081, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2706, 74, 135, 5, 70, "Title",
 CellID->509267359],
Cell[2844, 81, 571, 11, 70, "Text",
 CellID->205540823],
Cell[3418, 94, 475, 11, 70, "Text",
 CellID->1370907785],
Cell[3896, 107, 276, 9, 70, "Text",
 CellID->495093832],
Cell[CellGroupData[{
Cell[4197, 120, 199, 7, 28, "Input",
 CellID->1690385946],
Cell[4399, 129, 292, 10, 36, "Output",
 CellID->1255428259]
}, Open  ]],
Cell[4706, 142, 212, 8, 70, "Text",
 CellID->955917238],
Cell[CellGroupData[{
Cell[4943, 154, 284, 10, 28, "Input",
 CellID->775855859],
Cell[5230, 166, 540, 19, 51, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5807, 190, 290, 10, 28, "Input",
 CellID->1311632030],
Cell[6100, 202, 807, 17, 36, "Output",
 Evaluatable->False,
 CellID->215118836]
}, Open  ]],
Cell[6922, 222, 69, 1, 70, "Text",
 CellID->180240598],
Cell[CellGroupData[{
Cell[7016, 227, 86, 2, 70, "Input",
 CellID->1351788316],
Cell[7105, 231, 181, 6, 36, "Output",
 CellID->1276725399]
}, Open  ]],
Cell[7301, 240, 89, 1, 70, "Text",
 CellID->267180169],
Cell[CellGroupData[{
Cell[7415, 245, 87, 2, 70, "Input",
 CellID->108794506],
Cell[7505, 249, 139, 4, 36, "Output",
 CellID->1000678745]
}, Open  ]],
Cell[7659, 256, 226, 7, 70, "Text",
 CellID->1463227558],
Cell[CellGroupData[{
Cell[7910, 267, 86, 2, 70, "Input",
 CellID->1630325509],
Cell[7999, 271, 814, 30, 66, "Output",
 CellID->1136977690]
}, Open  ]],
Cell[8828, 304, 538, 11, 70, "Text",
 CellID->874544824],
Cell[CellGroupData[{
Cell[9391, 319, 486, 17, 70, "Input",
 CellID->1096776900],
Cell[9880, 338, 410, 14, 36, "Output",
 CellID->1677216099]
}, Open  ]],
Cell[10305, 355, 237, 8, 70, "Text",
 CellID->1100625371],
Cell[CellGroupData[{
Cell[10567, 367, 154, 5, 70, "Input",
 CellID->1933958786],
Cell[10724, 374, 325, 10, 36, "Output",
 CellID->1880318957]
}, Open  ]],
Cell[11064, 387, 282, 9, 70, "Text",
 CellID->151361047],
Cell[CellGroupData[{
Cell[11371, 400, 159, 5, 70, "Input",
 CellID->1304478881],
Cell[11533, 407, 235, 7, 36, "Output",
 CellID->716000744]
}, Open  ]],
Cell[11783, 417, 269, 5, 70, "Text",
 CellID->1473630267],
Cell[CellGroupData[{
Cell[12077, 426, 86, 2, 70, "Section",
 CellTags->{"t:190", "c:2"},
 CellID->374996618],
Cell[12166, 430, 513, 9, 70, "Text",
 CellID->1851138428],
Cell[12682, 441, 323, 7, 70, "Text",
 CellID->1487965307],
Cell[CellGroupData[{
Cell[13030, 452, 128, 4, 70, "Input",
 CellID->785845434],
Cell[13161, 458, 190, 6, 36, "Output",
 CellID->679780188]
}, Open  ]],
Cell[CellGroupData[{
Cell[13388, 469, 85, 2, 70, "Input",
 CellID->452617676],
Cell[13476, 473, 157, 5, 36, "Output",
 CellID->758202858]
}, Open  ]],
Cell[13648, 481, 217, 5, 70, "Text",
 CellID->2094956755],
Cell[CellGroupData[{
Cell[13890, 490, 703, 21, 70, "Input",
 CellID->1943788720],
Cell[14596, 513, 741, 23, 36, "Output",
 CellID->1735778876]
}, Open  ]],
Cell[CellGroupData[{
Cell[15374, 541, 89, 2, 70, "Input",
 CellID->1817708084],
Cell[15466, 545, 190, 6, 36, "Output",
 CellID->117405566]
}, Open  ]],
Cell[15671, 554, 511, 14, 70, "Text",
 CellID->1845359816],
Cell[16185, 570, 470, 13, 70, "Text",
 CellID->1003597538]
}, Open  ]],
Cell[CellGroupData[{
Cell[16692, 588, 160, 7, 70, "Section",
 CellTags->{"t:2", "c:3"},
 CellID->1127257628],
Cell[16855, 597, 1124, 30, 70, "Text",
 CellID->718219962],
Cell[17982, 629, 112, 3, 70, "Text",
 CellID->117321547],
Cell[18097, 634, 264, 9, 70, "Input",
 CellID->433252483],
Cell[18364, 645, 1075, 33, 70, "Text",
 CellID->1704918451],
Cell[CellGroupData[{
Cell[19464, 682, 83, 2, 70, "Input",
 CellID->690104036],
Cell[19550, 686, 488, 17, 50, "Output",
 CellID->19355605]
}, Open  ]],
Cell[20053, 706, 238, 8, 70, "Text",
 CellID->1039622538],
Cell[CellGroupData[{
Cell[20316, 718, 103, 3, 70, "Input",
 CellID->1009044174],
Cell[20422, 723, 161, 5, 36, "Output",
 CellID->327072059]
}, Open  ]],
Cell[20598, 731, 225, 7, 70, "Text",
 CellID->1689442940],
Cell[CellGroupData[{
Cell[20848, 742, 104, 3, 70, "Input",
 CellID->438711946],
Cell[20955, 747, 159, 5, 36, "Output",
 CellID->1120316271]
}, Open  ]],
Cell[21129, 755, 211, 7, 70, "Text",
 CellID->18949801],
Cell[CellGroupData[{
Cell[21365, 766, 151, 5, 70, "Input",
 CellID->661725651],
Cell[21519, 773, 159, 5, 36, "Output",
 CellID->1952692191]
}, Open  ]],
Cell[21693, 781, 1504, 45, 70, "Text",
 CellID->1052560683]
}, Open  ]],
Cell[CellGroupData[{
Cell[23234, 831, 96, 2, 70, "Section",
 CellTags->{"t:118", "c:4"},
 CellID->1564598842],
Cell[23333, 835, 562, 15, 70, "Text",
 CellID->275479979],
Cell[23898, 852, 775, 25, 70, "Text",
 CellID->17264121],
Cell[24676, 879, 344, 13, 70, "Text",
 CellID->247789302],
Cell[25023, 894, 330, 11, 70, "Input",
 CellID->624007181],
Cell[25356, 907, 231, 9, 70, "Text",
 CellID->1526042766],
Cell[CellGroupData[{
Cell[25612, 920, 118, 3, 70, "Input",
 CellID->803572041],
Cell[25733, 925, 103, 2, 70, "Print",
 CellID->406326104]
}, Open  ]],
Cell[25851, 930, 326, 13, 70, "Text",
 CellID->1904452273],
Cell[CellGroupData[{
Cell[26202, 947, 94, 3, 70, "Input",
 CellID->2033077423],
Cell[26299, 952, 321, 11, 36, "Output",
 CellID->24690645]
}, Open  ]],
Cell[26635, 966, 132, 4, 70, "Text",
 CellID->741372298],
Cell[26770, 972, 384, 13, 70, "Text",
 CellID->544092592],
Cell[27157, 987, 735, 23, 70, "Text",
 CellID->578824818]
}, Open  ]],
Cell[CellGroupData[{
Cell[27929, 1015, 153, 6, 70, "Section",
 CellTags->{"t:170", "c:5"},
 CellID->207795216],
Cell[28085, 1023, 190, 6, 70, "Text",
 CellID->605785290],
Cell[28278, 1031, 120, 3, 70, "BulletedText",
 CellID->213398603],
Cell[28401, 1036, 184, 4, 70, "BulletedText",
 CellID->292630131],
Cell[28588, 1042, 162, 4, 70, "BulletedText",
 CellID->497060087],
Cell[28753, 1048, 120, 3, 70, "BulletedText",
 CellID->377495379],
Cell[CellGroupData[{
Cell[28898, 1055, 260, 7, 70, "BulletedText",
 CellID->898141615],
Cell[29161, 1064, 191, 7, 70, "Text",
 CellID->403568542]
}, Open  ]],
Cell[CellGroupData[{
Cell[29389, 1076, 65, 1, 70, "TutorialMoreAboutSection",
 CellID->92472899],
Cell[29457, 1079, 169, 3, 70, "TutorialMoreAbout",
 CellID->4791866],
Cell[29629, 1084, 147, 3, 70, "TutorialMoreAbout",
 CellID->212289775]
}, Open  ]],
Cell[CellGroupData[{
Cell[29813, 1092, 72, 1, 70, "RelatedTutorialsSection",
 CellID->152812842],
Cell[29888, 1095, 304, 9, 70, "RelatedTutorials",
 CellID->315063104],
Cell[30195, 1106, 191, 5, 70, "RelatedTutorials",
 CellID->3571032],
Cell[30389, 1113, 175, 4, 70, "RelatedTutorials",
 CellID->560755906],
Cell[30567, 1119, 175, 4, 70, "RelatedTutorials",
 CellID->335456077],
Cell[30745, 1125, 160, 4, 70, "RelatedTutorials",
 CellID->472696132]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[30944, 1134, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

