(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     61228,       2174]
NotebookOptionsPosition[     46255,       1649]
NotebookOutlinePosition[     51520,       1816]
CellTagsIndexPosition[     50926,       1790]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Linear Algebra in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/LinearAlgebraOverview"], 
          "Matrix and Tensor Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations"], 
          "Working with Sparse Arrays" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraSparseArrays"], 
          "Matrix Computations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraMatrixComputations"], "Matrix Types" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraMatrixTypes"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Linear Algebra in Mathematica\"\>", 
       2->"\<\"Matrix and Tensor Operations\"\>", 
       3->"\<\"Working with Sparse Arrays\"\>", 
       4->"\<\"Matrix Computations\"\>", 
       5->"\<\"Matrix Types\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Linear Systems" :> 
          Documentation`HelpLookup["paclet:guide/LinearSystems"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Matrices and Linear Algebra\"\>", 
       2->"\<\"Linear Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Complex" :> Documentation`HelpLookup["paclet:ref/Complex"], 
          "I" :> Documentation`HelpLookup["paclet:ref/I"], "Integer" :> 
          Documentation`HelpLookup["paclet:ref/Integer"], "Rational" :> 
          Documentation`HelpLookup["paclet:ref/Rational"], "Real" :> 
          Documentation`HelpLookup["paclet:ref/Real"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Complex\"\>", 2->"\<\"I\"\>", 
       3->"\<\"Integer\"\>", 4->"\<\"Rational\"\>", 
       5->"\<\"Real\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Matrix Types", "Title",
 ShowCellBracket->True,
 CellTags->{"t:27", "c:120"},
 CellID->1880892864],

Cell[TextData[{
 "Matrices in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can be constructed from all the different types of object that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " holds. They can contain machine-precision real and complex floating point \
numbers, ",
 "arbitrary-precision",
 " real and complex floating point numbers, integers, rational numbers, and \
general symbolic quantities. This tutorial considers the different types of \
matrices that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports."
}], "Text",
 CellID->1207081408],

Cell[CellGroupData[{

Cell[TextData[{
 "Numbers in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Section",
 CellTags->{"t:232", "c:121"},
 CellID->139211047],

Cell[TextData[{
 "In order to understand the different types of matrices that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can work with, it will help to get an overview of the different types of \
numbers that are supported. This section will only give an overview of \
numbers in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", further information is found in \"",
 ButtonBox["Numbers\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NumbersOverview"],
 "."
}], "Text",
 CellID->1110375346],

Cell[BoxData[GridBox[{
   {
    RowBox[{"machine\[Hyphen]sized", 
     ButtonBox["Integer",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integer"]}], Cell[
    "integers represented by machine hardware ", "TableText"]},
   {
    ButtonBox["Integer",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integer"], Cell["\<\
arbitrary\[Hyphen]length exact integer \
\>", "TableText"]},
   {
    ButtonBox["Rational",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Rational"], Cell[TextData[{
     StyleBox["integer", "TI"],
     StyleBox["/", "MR"],
     StyleBox["integer", "TI"],
     " (fractions) in lowest terms "
    }], "TableText"]},
   {
    RowBox[{"machine\[Hyphen]sized", 
     ButtonBox["Real",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Real"]}], Cell[
    "approximate real number represented by machine hardware ", 
     "TableText"]},
   {
    ButtonBox["Real",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Real"], Cell[
    "approximate real number, with any specified precision ", "TableText"]},
   {
    ButtonBox["Complex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Complex"], Cell[TextData[{
     "complex number of the form ",
     StyleBox["number", "TI"],
     " ",
     StyleBox["+", "MR"],
     " ",
     StyleBox["number", "TI"],
     " ",
     ButtonBox["I",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/I"]
    }], "TableText"]},
   {
    RowBox[{"Algebraic", "Number"}], Cell[
    "root of an algebraic equation ", "TableText"]},
   {
    RowBox[{"Exact", "Numerical", "Expression"}], Cell[
    "composition of numbers and mathematical functions ", "TableText"]},
   {
    RowBox[{"Infinities", "and", "Exceptions"}], Cell[
    "various special numbers ", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.1.1",
 CellID->445547792],

Cell[TextData[{
 "Intrinsic types of numbers in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Caption",
 CellTags->"S3.1.1",
 CellID->46263055],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides an arithmetic system that unifies all these different types of \
number. For many purposes it is not necessary to know that there are two \
different types of integer because both types flow together. For example, the \
integer ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["2", "10"], TraditionalForm]]],
 " is represented by machine hardware. If this is raised to the tenth power, \
the result is represented by software."
}], "Text",
 CellID->154085171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"int1", "=", 
  SuperscriptBox["2", "10"]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1991674362],

Cell[BoxData["1024"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1243396345]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox["int1", "10"]], "Input",
 CellLabel->"In[2]:=",
 CellID->599001458],

Cell[BoxData["1267650600228229401496703205376"], "Output",
 ImageSize->{243, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14167470]
}, Open  ]],

Cell["\<\
Another example shows how a computation of the exponential of a \
machine-precision floating point number returns an arbitrary-precision \
number.\
\>", "Text",
 CellID->1889467120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"-", "6000."}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1433197651],

Cell[BoxData["1.71044289941289886086643`12.17643851980736*^-2606"], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1576335605]
}, Open  ]],

Cell[TextData[{
 "These examples demonstrate the general point that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " arithmetic traps overflows and underflows so that it can switch from \
machine to software numbers. Despite this it tries to use machine hardware \
functionality whenever possible, so that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " computations can be fast."
}], "Text",
 CellID->2114243843],

Cell[CellGroupData[{

Cell["Exact versus Approximate Numbers", "Subsection",
 CellTags->{"t:171", "c:122"},
 CellID->1831846039],

Cell[TextData[{
 "One important issue for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is that it makes a distinction between exact and approximate numbers. This \
is done to support the symbolic side of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". This example compares the computation of the ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " function for an integer and a real argument."
}], "Text",
 CellID->1510814081],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", " ", "5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->405617239],

Cell[BoxData[
 RowBox[{"Sin", "[", "5", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1095840295]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", "5.", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->968081393],

Cell[BoxData[
 RowBox[{"-", "0.9589242746631385`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1207862479]
}, Open  ]],

Cell[TextData[{
 "This demonstrates that mathematical functions, such as ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 ", maintain the nature of their input. If they get an exact argument, the \
result will be exact. If they get an approximate argument the result is \
approximate. This feature of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is essential to maintain the system as a symbolic system, but it stands in \
contrast to the operation of a purely numerical environment. For example, in \
many languages such as C or Java the equivalent computation would coerce the \
integer to a double and the result would be an approximate number."
}], "Text",
 CellID->381769462],

Cell["\<\
This distinction means that when you work with numbers you need to be more \
aware of their types than is the case in many other languages.\
\>", "Text",
 CellID->1865694245],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " to compute a numerical approximation for an exact number."
}], "Text",
 CellID->1314445868],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"exact", "=", 
   RowBox[{"Sin", "[", "5", "]"}]}], ";"}], "\n", 
 RowBox[{"inexact", "=", 
  RowBox[{"N", "[", "exact", "]"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->727426787],

Cell[BoxData[
 RowBox[{"-", "0.9589242746631385`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->237606738]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mixed Mode Arithmetic", "Subsection",
 CellTags->{"t:172", "c:123"},
 CellID->1284345793],

Cell[TextData[{
 "Another important issue concerns the operation of functions that take more \
than one argument. In this case ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " takes the lowest precision of the input. For example, the following mixed \
computations all return approximate results."
}], "Text",
 CellID->1641606954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"5", "+", "6.7"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1765662869],

Cell[BoxData["11.7`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1566805037]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", "5", "]"}], "/", "1.5"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->847777345],

Cell[BoxData[
 RowBox[{"-", "0.6392828497754256`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->39839570]
}, Open  ]],

Cell["\<\
The same principle applies if the input includes an exact integer represented \
by software.\
\>", "Text",
 CellID->1716238773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.5", " ", 
  SuperscriptBox["2", "100"]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1972194954],

Cell[BoxData["1.901475900342344`*^30"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->270500433]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Matrices in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Section",
 CellTags->{"t:111", "c:124"},
 CellID->77896732],

Cell[TextData[{
 "Matrices in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can contain many different types of elements. "
}], "Text",
 CellID->1392833701],

Cell["\<\
For example, here is a matrix where each element is a machine-precision \
approximate real number.\
\>", "Text",
 CellID->1784260407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1.5", ",", "2.7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3.1", ",", "4.3"}], "}"}]}], "}"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->603013741],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.5`", "2.7`"},
     {"3.1`", "4.3`"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{74, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->876614794]
}, Open  ]],

Cell["\<\
This matrix contains complex numbers with real and imaginary parts that are \
machine-precision approximate real numbers.\
\>", "Text",
 CellID->1527024338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1.5", "+", 
       RowBox[{"4.5", "I"}]}], ",", 
      RowBox[{"2.7", "+", 
       RowBox[{"4.", "I"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"3.1", "+", 
       RowBox[{"2.1", "I"}]}], ",", 
      RowBox[{"4.3", "+", 
       RowBox[{"5.1", "I"}]}]}], "}"}]}], "}"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->120983469],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"1.5`", "\[InvisibleSpace]", "+", 
       RowBox[{"4.5`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"2.7`", "\[InvisibleSpace]", "+", 
       RowBox[{"4.`", " ", "\[ImaginaryI]"}]}]},
     {
      RowBox[{"3.1`", "\[InvisibleSpace]", "+", 
       RowBox[{"2.1`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"4.3`", "\[InvisibleSpace]", "+", 
       RowBox[{"5.1`", " ", "\[ImaginaryI]"}]}]}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{164, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->1849633421]
}, Open  ]],

Cell["\<\
This matrix contains approximate numbers with 20 digits of precision.\
\>", "Text",
 CellID->1963116422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1.5`20", ",", "2.7`20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3.1`20", ",", "4.3`20"}], "}"}]}], "}"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->158952046],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.5`20.", "2.7`20."},
     {"3.1`20.", "4.3`20."}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{326, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->37380254]
}, Open  ]],

Cell["This matrix contains integers.", "Text",
 CellID->1184704054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2000144241],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2"},
     {"3", "4"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{46, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->1862731996]
}, Open  ]],

Cell["This matrix contains rational numbers.", "Text",
 CellID->920050806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Random", "[", 
      RowBox[{"Integer", ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "10"}], "}"}]}], "]"}]}], ",", 
    RowBox[{"{", "4", "}"}], ",", 
    RowBox[{"{", "4", "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1411638042],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["1", "5"], 
      FractionBox["1", "8"], 
      FractionBox["1", "7"], 
      FractionBox["1", "6"]},
     {
      FractionBox["1", "9"], 
      FractionBox["1", "9"], 
      FractionBox["1", "6"], 
      FractionBox["1", "4"]},
     {
      FractionBox["1", "6"], 
      FractionBox["1", "10"], 
      FractionBox["1", "4"], 
      FractionBox["1", "3"]},
     {
      FractionBox["1", "10"], 
      FractionBox["1", "7"], 
      FractionBox["1", "5"], 
      FractionBox["1", "8"]}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{100, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->1239838]
}, Open  ]],

Cell["\<\
This matrix contains complex numbers with real and imaginary parts that are \
integers.\
\>", "Text",
 CellID->1510604443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"4", "I"}]}], ",", 
      RowBox[{"2", "+", 
       RowBox[{"2", "I"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"3", "+", 
       RowBox[{"1", "I"}]}], ",", 
      RowBox[{"4", "+", 
       RowBox[{"11", "I"}]}]}], "}"}]}], "}"}], "//", "MatrixForm"}]], "Input",\

 CellLabel->"In[6]:=",
 CellID->1177198667],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"1", "+", 
       RowBox[{"4", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"2", "+", 
       RowBox[{"2", " ", "\[ImaginaryI]"}]}]},
     {
      RowBox[{"3", "+", "\[ImaginaryI]"}], 
      RowBox[{"4", "+", 
       RowBox[{"11", " ", "\[ImaginaryI]"}]}]}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{115, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->411156458]
}, Open  ]],

Cell["This matrix contains polynomials.", "Text",
 CellID->1851697207],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", " ", 
   RowBox[{
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"i", " ", 
       SuperscriptBox["x", "i"]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", 
        RowBox[{"2", "+", 
         RowBox[{"Mod", "[", 
          RowBox[{"m", ",", "n"}], "]"}]}]}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "4"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->141945725],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWz1QE0EUPnJJ+BkgKM4I/pHoOCKjGEClUiGIVBbIOI5lBGegcHQQZugo
KSlTMrZaUKakpKSkpKSkpIy395O7fNnlvVs2Pzhmhsu+3e+9ffv25+7jXd4X
N1a/fiturC0XswvrxR+ra8s/s+++rztVdodldfy2LGt+yHLKFafk/onPH+fP
K2IpJa7Jvb29SvBJOEoJ/7tTtNqBlYqLTjliEnA5Qi+p0JvS1OsDXNq5CDEF
uI+a9mdd3Pb2to+z3Vgl3eLx8XG5XK7WJkNrltUliZeVqsoeyI95VO8BaSnJ
tPTCmKV+zbF8MuZBwdVz1ubR0RHOQqlUilgL5lYYTUNvnX77Q8ClFLhpJq7P
b++WjE60f2bamXPrz8/Pt7a2wlHaQa030OrKxt5wRadhtIjH6AT46Zj4DNRT
UeDafevW7+zsOEMXxUQ1GonDw8P6NYJrS7rWYu412SkRd5fRNnB/BeshXYek
dxTdm7fKnIPLOb5q4+rupdPT04q/9qLn4CDYTUC7+BbNd6D+OlNvXFPvBgMn
vhc17b9yceFJH41WeFcYqsjOsV7oI89CFVioASkKV9IXli1vjM42827+ijEO
+xHBPvKK+oKifkBRv6Ko97wLT/kOqXdjoDUL8hLI90HekPYa2pf3+jiiJSI7
C/ISyDmQN0F+zeo17lhzIG9WdMYqLr/+Iwkknpvc5+aMph7uZdXz76SmfV09
rl+I6/JxGEd8zk8p7PWzZqn+rqj7vH7NmCXZCDl6z415YM6S7lhQD58V63kW
3i24jMJ7aqXWSbC6KEYxyMT1Vi5mCi+Zdrg4qr+gXYwzHdlNAaORPUOL9oFY
0eMylcGYeJx7Kqpcu3HxXD94PFrFqy43F/SJR/Ml+qyjbeAOV3Md+jSiezNh
g++x7H9RtQje/1ZsqXXeiaXL23o09Tg48Y38jmv/aYP9ivJAsfvwOcb27eFu
xOcOG9q7WLPF440jLFRGisL1NcOyxeOgvB6jkZO1o9wH+G5WJFXsdERRn1HU
q1irql5lR5yVwR026a+fpATXyRodMr48yMjwPoBMMcJ7EPOs730PyztkwXmJ
tYtYMcqID3IK0XpR5K0MKnZoFWOFMuJlsbTZ61ZcrgKvbS1Sl1XrZqMovWax
Xl3/uVkxrh8jrFkyx6rNZcFoS+3Hac2NXjdzF99n71Q0xae5GTrEmebBXD+o
DKDKfi5W1BqV8VPhm8t343rNzTvG84I3IybYtInsI22j1fzWxCj5+VEdD3kn
V7PzoajXKt57W9N/bl6W68cwa5ZM5mEnWCgzHHic1Rcv50v1NcSKZNxs74Si
nsuPVXZV2WLU560PKnNaAJniyYjHrDLib7G8pLLKBZCzIAesAfUw+xzgeF7F
jV0WZIzlDNGOMm/distVYLStRbZrlrrRfHeuwf5PsKL/L2WfW89V51seg0lX
b3d3169pj1yyKe66YMifKbe++n55TZRKpdLZ2Vk0Sq3OGTeKjS4o7F7WX28N
npyc7O/vi2L0Hb5yuey/N331ssDN5Y/0WWJybN7d4uDgQPImrrMd/Jls14zu
XZBNM8M3Dfb/ScU/tWveL8ffFNwUl6ZmaE1ywUWDfnmsJLyfhfFKOKeLqfxr
XB64FNO+GEXC2VnuPPv3xHC2RyXexOEwyP+WCf1R6N+OeOW9iC+KjyJaYmao
/CrF+1YI/THo3/MKY0HlUZEf4thXCP1nbq+i6P0+zer4C8cqvpg=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{426, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//MatrixForm=",
 CellID->325963989]
}, Open  ]],

Cell["\<\
These different types of matrices can be put into categories according to the \
types of technique used for computing with them.\
\>", "Text",
 CellID->1509419303],

Cell[BoxData[GridBox[{
   {
    RowBox[{"machine\[Hyphen]precision", 
     ButtonBox["Real",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Real"]}], Cell[
    "standard numerical techniques ", "TableText"]},
   {Cell[BoxData[
     RowBox[{"machine\[Hyphen]precision", " ", 
      ButtonBox["Complex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Complex"]}]]], Cell[BoxData[
    "  "], "TableText"]},
   {
    RowBox[{"arbitrary\[Hyphen]precision", 
     ButtonBox["Real",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Real"]}], Cell["\<\
arbitrary\[Hyphen]precision numerical techniques \
\>", "TableText"]},
   {Cell[BoxData[
     RowBox[{"arbitrary\[Hyphen]precision", " ", 
      ButtonBox["Complex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Complex"]}]]], Cell[BoxData[
    ""], "TableText"]},
   {
    ButtonBox["Integer",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integer"], Cell[
    "symbolic algebra techniques", "TableText"]},
   {Cell[BoxData[
     ButtonBox["Rational",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Rational"]]], Cell[BoxData[
    "  "], "TableText"]},
   {Cell[BoxData[
     RowBox[{"exact", 
      ButtonBox["Complex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Complex"]}]]], Cell[BoxData[
    ""], "TableText"]},
   {Cell[BoxData[
     StyleBox["Symbolic", "MR"]]], Cell[BoxData[""], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, True, False, True, {False}, False}, 
   "RowsIndexed" -> {}}},
 CellTags->"S3.1.1",
 CellID->585903510],

Cell[TextData[{
 "Different types of matrices in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Caption",
 CellTags->"S3.1.1",
 CellID->1067771075],

Cell["These three different categories will be briefly reviewed.", "Text",
 CellID->1655103193],

Cell[CellGroupData[{

Cell["Standard Numerical Techniques", "Subsubsection",
 CellTags->{"t:173", "c:125"},
 CellID->963685160],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", matrix computations involving machine-precision ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " and machine-precision approximate ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " numbers are carried out with standard numerical techniques. In many cases \
computations involve optimized libraries, many of which are described in the \
",
 ButtonBox["Software References",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraAppendix#2058470059"],
 "."
}], "Text",
 CellID->334818446],

Cell[TextData[{
 "An important goal for many of these computations is to match and surpass \
the performance of any software package that is dedicated to \
machine-precision numbers. This is in keeping with the design goals of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", as described under \"",
 ButtonBox["Design Principles of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraIntroduction#207795216"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraIntroduction#207795216"],
  FontSlant->"Italic"],
 "\". In the case of linear algebra computations, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " makes use of a considerable amount of sophisticated technology, some of \
which is described under \"",
 ButtonBox["Performance of Linear Algebra Computation",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraPerformance#195254286"],
 "\"."
}], "Text",
 CellID->886466782]
}, Open  ]],

Cell[CellGroupData[{

Cell["Arbitrary-Precision Numerical Techniques", "Subsubsection",
 CellTags->{"t:174", "c:126"},
 CellID->1753145835],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", matrix computations involving arbitrary-precision ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " and arbitrary-precision approximate ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " numbers are carried out with special numerical libraries. These libraries \
are adapted from standard libraries so they can work for arbitrary-precision \
computations."
}], "Text",
 CellID->1646412005],

Cell[TextData[{
 "More information can be found in the section \"",
 ButtonBox["Arbitrary-Precision Matrices",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixTypes#2139022291"],
 "\"."
}], "Text",
 CellID->919776440]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbolic Algebra Techniques", "Subsubsection",
 CellTags->{"t:175", "c:127"},
 CellID->1095335974],

Cell["\<\
Matrix computations involving exact numbers and general symbolic techniques \
are carried out with computer algebra techniques.\
\>", "Text",
 CellID->1081892934],

Cell["\<\
All computations provided for numerical matrices are also available for \
symbolic matrices. This meets the design goal of integrating symbolic and \
numerical computation.\
\>", "Text",
 CellID->630502589]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mixed Mode Matrices", "Subsection",
 CellTags->{"t:176", "c:128"},
 CellID->1172699025],

Cell["\<\
This section describes what happens if the input matrix contains a mixture of \
different types of entries.\
\>", "Text",
 CellID->2095084656],

Cell[TextData[{
 "If the matrix contains anything that is not a number (or something that \
cannot be converted into a number), the matrix will be treated as a symbolic \
matrix and the computation will proceed with symbolic techniques. In the \
following example, the presence of the ",
 StyleBox["x", "MR"],
 " makes the matrix symbolic and the result is a symbolic matrix."
}], "Text",
 CellID->1945937180],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", 
       RowBox[{"Sin", "[", "4", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "x"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Inverse", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1337724097],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["x", 
      RowBox[{
       RowBox[{"1.`", " ", "x"}], "-", 
       RowBox[{"Sin", "[", "4", "]"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"Sin", "[", "4", "]"}], 
       RowBox[{
        RowBox[{"1.`", " ", "x"}], "-", 
        RowBox[{"Sin", "[", "4", "]"}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"1.`", " ", "x"}], "-", 
        RowBox[{"Sin", "[", "4", "]"}]}]]}], ",", 
     FractionBox["1.`", 
      RowBox[{
       RowBox[{"1.`", " ", "x"}], "-", 
       RowBox[{"Sin", "[", "4", "]"}]}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{426, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1122597836]
}, Open  ]],

Cell["\<\
If the matrix only contains numbers (or things that can be converted into \
numbers), the computation will be done according to the lowest precision. \
Thus in the following example, the presence of the machine-precision \
approximate number, 1., means that the input matrix will be converted to \
machine-precision numbers and the computation done with machine-precision \
techniques.\
\>", "Text",
 CellID->1857990757],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", " ", 
       RowBox[{"Sin", "[", "4", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Inverse", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->690941872],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.7254781593545405`", ",", "0.2745218406454595`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.3627390796772702`"}], ",", "0.3627390796772702`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{312, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1215963375]
}, Open  ]],

Cell["\<\
In this example, the lowest precision is a number with 20 digits of \
precision. Thus, the input matrix will be converted to precision 20 numbers \
and the computation done with arbitrary-precision techniques.\
\>", "Text",
 CellID->1242058773],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`30", ",", " ", "1.`20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Inverse", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->1740748971],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2.`20.", ",", 
     RowBox[{"-", "1.`20."}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.`20."}], ",", "1.`20."}], "}"}]}], "}"}]], "Output",
 ImageSize->{345, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1598232516]
}, Open  ]],

Cell["\<\
The resulting matrix has entries with 20 digits of precision.\
\>", "Text",
 CellID->768439736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "%", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->199989894],

Cell[BoxData["20.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->418240903]
}, Open  ]],

Cell["\<\
Note that machine-precision counts as lower precision than any \
arbitrary-precision numbers. In this example, because there is a \
machine-precision number, the input matrix will be converted to \
machine-precision numbers and the computation done with machine-precision \
techniques.\
\>", "Text",
 CellID->660880090],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`5", ",", " ", "1.`20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.5", ",", "2"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Inverse", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[8]:=",
 CellID->626250346],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4.000000000000001`", ",", 
     RowBox[{"-", "2.0000000000000004`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3.000000000000001`"}], ",", "2.0000000000000004`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->572211275]
}, Open  ]],

Cell["The result is a machine-precision matrix.", "Text",
 CellID->723127659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "%", "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->996606440],

Cell[BoxData["MachinePrecision"], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->1739474127]
}, Open  ]],

Cell["\<\
It is important to be aware of these distinctions. For example, if the input \
matrix consists of integers, the computation will use symbolic algebra \
techniques and return an exact precision result. \
\>", "Text",
 CellID->1646765878],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Inverse", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[11]:=",
 CellID->424869010],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "5"]}], ",", 
     FractionBox["3", "10"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["2", "5"], ",", 
     RowBox[{"-", 
      FractionBox["1", "10"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{154, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->390324795]
}, Open  ]],

Cell[TextData[{
 "In some other computation systems an input matrix of integers would be \
converted to a floating point matrix. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not do this, so that it can support symbolic computation. However, it \
means that users need to be aware of the differences. This is because the \
time required for a symbolic technique can be quite different from a \
machine-precision technique; in many cases the symbolic computation will take \
much longer."
}], "Text",
 CellID->1773771627]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Complex Matrices", "Section",
 CellTags->"c:129",
 CellID->411747335],

Cell[TextData[{
 "Complex matrices in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are defined in a way that is completely consistent with other types of \
matrices such as those that involve real numbers. All the functions that work \
for real matrices work for complex matrices."
}], "Text",
 CellID->1045148711],

Cell[TextData[{
 "One special detail about complex matrices is that certain linear algebra \
computations that involve a transpose for real matrices involve a conjugate \
transpose for complex matrices. An example of this is the ",
 ButtonBox["Cholesky decomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#1567526616"],
 ". For a real symmetric positive definite matrix it is defined as shown \
below."
}], "Text",
 CellID->1545636964],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"11.", ",", "3."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.", ",", "5."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"matG", "=", 
   RowBox[{"CholeskyDecomposition", "[", "mat", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Transpose", "[", "matG", "]"}], ".", "matG"}], "//", 
  "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1558259836],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"11.`", "3.`"},
     {"3.`", "4.999999999999999`"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{67, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->1109988487]
}, Open  ]],

Cell["\<\
For a complex hermitian positive definite matrix the definition is shown as \
follows.\
\>", "Text",
 CellID->386059520],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"11.", ",", 
       RowBox[{"3.", "+", 
        RowBox[{"2.", "I"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3.", "-", 
        RowBox[{"2.", "I"}]}], ",", "5."}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"matG", "=", 
   RowBox[{"CholeskyDecomposition", "[", "mat", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Conjugate", "[", 
    RowBox[{"Transpose", "[", "matG", "]"}], "]"}], ".", "matG"}], "//", 
  "MatrixForm"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->954255053],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"11.`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"3.`", "\[InvisibleSpace]", "+", 
       RowBox[{"2.`", " ", "\[ImaginaryI]"}]}]},
     {
      RowBox[{"3.`", "\[InvisibleSpace]", "-", 
       RowBox[{"2.`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"5.`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{143, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->756799975]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Arbitrary-Precision Matrices", "Section",
 CellTags->{"t:113", "c:130"},
 CellID->2139022291],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " arbitrary-precision computations support a form of arithmetic known as \
significance arithmetic. The fundamental idea of significance arithmetic is \
that a number is seen as an approximation with an error specified by its \
precision. When a number is used in a computation the precision of the result \
may be different according to the properties of the function. For example, \
here is a number with 30 digits of precision."
}], "Text",
 CellID->1671394057],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"num", "=", 
  RowBox[{"N", "[", " ", 
   RowBox[{
    RowBox[{"Pi", "+", 
     SuperscriptBox["10", 
      RowBox[{"-", "20"}]]}], ",", " ", "30"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2033813239],

Cell[BoxData["3.141592653589793238472643383279502884197167382228`30."], \
"Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->801898574]
}, Open  ]],

Cell[TextData[{
 "Now compute the value of the ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " function for this number."
}], "Text",
 CellID->2049448293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", "num", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1587246218],

Cell[BoxData[
 RowBox[{"-", 
  "9.999999999999999999997982851`9.502850127305864*^-21"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->805322892]
}, Open  ]],

Cell["The result is seen to be less than 30 digits.", "Text",
 CellID->1619902450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2050284131],

Cell[BoxData["9.502850127305864`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->602789955]
}, Open  ]],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", linear algebra computations generally do not use significance arithmetic. \
They are carried out in what is known as fixed precision, where computations \
are done with fixed numbers of digits with no attempt to track the error in \
individual operations. Error tracking is done on an algorithmic level, \
issuing warnings, for example, when the solution of a linear system may not \
be correct."
}], "Text",
 CellID->1410410786],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Random", "[", " ", 
      RowBox[{"Real", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1000."}], ",", "1000"}], "}"}], ",", "20"}], "]"}], 
     ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "4", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"Inverse", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->849584716],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.00074348384452465124542786035517691584`20.", ",", 
     "0.00101092310228278694869106180332123609`20.", ",", 
     RowBox[{"-", "0.0003569278633413111307510028241010683`20."}], ",", 
     RowBox[{"-", "0.00028315988486426625218121736347647436`20."}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.00108087835086919601538423593936223789`20.", ",", 
     RowBox[{"-", "0.00049051761651720622274463938108842323`20."}], ",", 
     RowBox[{"-", "0.00015545435896779551558610906125759155`20."}], ",", 
     "0.00024702392618054152091025641633920501`20."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.00014933485249240477485689830191607087`20.", ",", 
     RowBox[{"-", "0.00113015852112318733938541067086268077`20."}], ",", 
     RowBox[{"-", "0.00122922349963704033632672011237586401`20."}], ",", 
     "0.00124188863662722030712872323500468857`20."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.00039839688498014642816536884222890164`20.", ",", 
     "0.00080167324054272698658828090499007796`20.", ",", 
     RowBox[{"-", "0.00006275020031800969977316547622324296`20."}], ",", 
     "0.00066463268540109502630966810134396791`20."}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{409, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->351552909]
}, Open  ]],

Cell["\<\
The inverse matrix that is computed consists entirely of numbers with \
precision of 20.\
\>", "Text",
 CellID->822228666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{"Map", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"#", " ", "\[Equal]", " ", "0"}], ",", " ", 
       RowBox[{"Accuracy", "[", "#", "]"}], ",", 
       RowBox[{"Precision", "[", "#", "]"}]}], "]"}], "&"}], ",", "%", ",", 
    " ", 
    RowBox[{"{", 
     RowBox[{"-", "1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->139921017],

Cell[BoxData["20.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->157939254]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->24371987],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "TutorialMoreAbout",
 CellID->4791866],

Cell[TextData[ButtonBox["Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LinearSystems"]], "TutorialMoreAbout",
 CellID->212289775]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->179478248],

Cell[TextData[{
 ButtonBox["Linear Algebra in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraOverview"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->315063104],

Cell[TextData[ButtonBox["Matrix and Tensor Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations"]], \
"RelatedTutorials",
 CellID->3571032],

Cell[TextData[ButtonBox["Working with Sparse Arrays",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LinearAlgebraSparseArrays"]], "RelatedTutorials",\

 CellID->560755906],

Cell[TextData[ButtonBox["Matrix Computations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations"]], "RelatedTutorials",
 CellID->335456077],

Cell[TextData[ButtonBox["Matrix Types",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LinearAlgebraMatrixTypes"]], "RelatedTutorials",\

 CellID->472696132]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Matrix Types - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 41.4446070}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Matrices in Mathematica can be constructed from all the different types \
of object that Mathematica holds. They can contain machine-precision real and \
complex floating point numbers, arbitrary-precision real and complex floating \
point numbers, integers, rational numbers, and general symbolic quantities. \
This tutorial considers the different types of matrices that Mathematica \
supports. In order to understand the different types of matrices that \
Mathematica can work with, it will help to get an overview of the different \
types of numbers that are supported. This section will only give an overview \
of numbers in Mathematica, further information is found in \"Numbers\". \
Intrinsic types of numbers in Mathematica.", "synonyms" -> {}, "title" -> 
    "Matrix Types", "type" -> "Tutorial", "uri" -> 
    "tutorial/LinearAlgebraMatrixTypes"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "t:27"->{
  Cell[3587, 93, 104, 3, 70, "Title",
   CellTags->{"t:27", "c:120"},
   CellID->1880892864]},
 "c:120"->{
  Cell[3587, 93, 104, 3, 70, "Title",
   CellTags->{"t:27", "c:120"},
   CellID->1880892864]},
 "t:232"->{
  Cell[4302, 119, 145, 6, 70, "Section",
   CellTags->{"t:232", "c:121"},
   CellID->139211047]},
 "c:121"->{
  Cell[4302, 119, 145, 6, 70, "Section",
   CellTags->{"t:232", "c:121"},
   CellID->139211047]},
 "S3.1.1"->{
  Cell[4970, 144, 1821, 60, 70, "DefinitionBox",
   CellTags->"S3.1.1",
   CellID->445547792],
  Cell[6794, 206, 159, 7, 70, "Caption",
   CellTags->"S3.1.1",
   CellID->46263055],
  Cell[23006, 820, 1657, 51, 70, "DefinitionBox",
   CellTags->"S3.1.1",
   CellID->585903510],
  Cell[24666, 873, 162, 7, 70, "Caption",
   CellTags->"S3.1.1",
   CellID->1067771075]},
 "t:171"->{
  Cell[9157, 299, 106, 2, 70, "Subsection",
   CellTags->{"t:171", "c:122"},
   CellID->1831846039]},
 "c:122"->{
  Cell[9157, 299, 106, 2, 70, "Subsection",
   CellTags->{"t:171", "c:122"},
   CellID->1831846039]},
 "t:172"->{
  Cell[12107, 409, 95, 2, 70, "Subsection",
   CellTags->{"t:172", "c:123"},
   CellID->1284345793]},
 "c:123"->{
  Cell[12107, 409, 95, 2, 70, "Subsection",
   CellTags->{"t:172", "c:123"},
   CellID->1284345793]},
 "t:111"->{
  Cell[13724, 481, 145, 6, 70, "Section",
   CellTags->{"t:111", "c:124"},
   CellID->77896732]},
 "c:124"->{
  Cell[13724, 481, 145, 6, 70, "Section",
   CellTags->{"t:111", "c:124"},
   CellID->77896732]},
 "t:173"->{
  Cell[24951, 887, 105, 2, 70, "Subsubsection",
   CellTags->{"t:173", "c:125"},
   CellID->963685160]},
 "c:125"->{
  Cell[24951, 887, 105, 2, 70, "Subsubsection",
   CellTags->{"t:173", "c:125"},
   CellID->963685160]},
 "t:174"->{
  Cell[26791, 944, 117, 2, 70, "Subsubsection",
   CellTags->{"t:174", "c:126"},
   CellID->1753145835]},
 "c:126"->{
  Cell[26791, 944, 117, 2, 70, "Subsubsection",
   CellTags->{"t:174", "c:126"},
   CellID->1753145835]},
 "t:175"->{
  Cell[27796, 980, 104, 2, 70, "Subsubsection",
   CellTags->{"t:175", "c:127"},
   CellID->1095335974]},
 "c:127"->{
  Cell[27796, 980, 104, 2, 70, "Subsubsection",
   CellTags->{"t:175", "c:127"},
   CellID->1095335974]},
 "t:176"->{
  Cell[28331, 1000, 93, 2, 70, "Subsection",
   CellTags->{"t:176", "c:128"},
   CellID->1172699025]},
 "c:128"->{
  Cell[28331, 1000, 93, 2, 70, "Subsection",
   CellTags->{"t:176", "c:128"},
   CellID->1172699025]},
 "c:129"->{
  Cell[36040, 1287, 75, 2, 70, "Section",
   CellTags->"c:129",
   CellID->411747335]},
 "t:113"->{
  Cell[39357, 1407, 99, 2, 70, "Section",
   CellTags->{"t:113", "c:130"},
   CellID->2139022291]},
 "c:130"->{
  Cell[39357, 1407, 99, 2, 70, "Section",
   CellTags->{"t:113", "c:130"},
   CellID->2139022291]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"t:27", 48165, 1690},
 {"c:120", 48272, 1694},
 {"t:232", 48379, 1698},
 {"c:121", 48489, 1702},
 {"S3.1.1", 48600, 1706},
 {"t:171", 48979, 1719},
 {"c:122", 49093, 1723},
 {"t:172", 49207, 1727},
 {"c:123", 49321, 1731},
 {"t:111", 49435, 1735},
 {"c:124", 49545, 1739},
 {"t:173", 49655, 1743},
 {"c:125", 49772, 1747},
 {"t:174", 49889, 1751},
 {"c:126", 50007, 1755},
 {"t:175", 50125, 1759},
 {"c:127", 50243, 1763},
 {"t:176", 50361, 1767},
 {"c:128", 50476, 1771},
 {"c:129", 50591, 1775},
 {"t:113", 50691, 1779},
 {"c:130", 50803, 1783}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2962, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3587, 93, 104, 3, 70, "Title",
 CellTags->{"t:27", "c:120"},
 CellID->1880892864],
Cell[3694, 98, 583, 17, 70, "Text",
 CellID->1207081408],
Cell[CellGroupData[{
Cell[4302, 119, 145, 6, 70, "Section",
 CellTags->{"t:232", "c:121"},
 CellID->139211047],
Cell[4450, 127, 517, 15, 70, "Text",
 CellID->1110375346],
Cell[4970, 144, 1821, 60, 70, "DefinitionBox",
 CellTags->"S3.1.1",
 CellID->445547792],
Cell[6794, 206, 159, 7, 70, "Caption",
 CellTags->"S3.1.1",
 CellID->46263055],
Cell[6956, 215, 534, 13, 70, "Text",
 CellID->154085171],
Cell[CellGroupData[{
Cell[7515, 232, 121, 4, 28, "Input",
 CellID->1991674362],
Cell[7639, 238, 162, 5, 36, "Output",
 CellID->1243396345]
}, Open  ]],
Cell[CellGroupData[{
Cell[7838, 248, 97, 3, 28, "Input",
 CellID->599001458],
Cell[7938, 253, 188, 5, 36, "Output",
 CellID->14167470]
}, Open  ]],
Cell[8141, 261, 191, 5, 70, "Text",
 CellID->1889467120],
Cell[CellGroupData[{
Cell[8357, 270, 122, 4, 70, "Input",
 CellID->1433197651],
Cell[8482, 276, 209, 5, 36, "Output",
 CellID->1576335605]
}, Open  ]],
Cell[8706, 284, 426, 11, 70, "Text",
 CellID->2114243843],
Cell[CellGroupData[{
Cell[9157, 299, 106, 2, 70, "Subsection",
 CellTags->{"t:171", "c:122"},
 CellID->1831846039],
Cell[9266, 303, 508, 15, 70, "Text",
 CellID->1510814081],
Cell[CellGroupData[{
Cell[9799, 322, 104, 3, 70, "Input",
 CellID->405617239],
Cell[9906, 327, 188, 6, 36, "Output",
 CellID->1095840295]
}, Open  ]],
Cell[CellGroupData[{
Cell[10131, 338, 100, 3, 70, "Input",
 CellID->968081393],
Cell[10234, 343, 194, 6, 36, "Output",
 CellID->1207862479]
}, Open  ]],
Cell[10443, 352, 754, 16, 70, "Text",
 CellID->381769462],
Cell[11200, 370, 184, 4, 70, "Text",
 CellID->1865694245],
Cell[11387, 376, 232, 8, 70, "Text",
 CellID->1314445868],
Cell[CellGroupData[{
Cell[11644, 388, 218, 7, 70, "Input",
 CellID->727426787],
Cell[11865, 397, 193, 6, 36, "Output",
 CellID->237606738]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12107, 409, 95, 2, 70, "Subsection",
 CellTags->{"t:172", "c:123"},
 CellID->1284345793],
Cell[12205, 413, 336, 8, 70, "Text",
 CellID->1641606954],
Cell[CellGroupData[{
Cell[12566, 425, 95, 3, 70, "Input",
 CellID->1765662869],
Cell[12664, 430, 163, 5, 36, "Output",
 CellID->1566805037]
}, Open  ]],
Cell[CellGroupData[{
Cell[12864, 440, 124, 4, 70, "Input",
 CellID->847777345],
Cell[12991, 446, 192, 6, 36, "Output",
 CellID->39839570]
}, Open  ]],
Cell[13198, 455, 137, 4, 70, "Text",
 CellID->1716238773],
Cell[CellGroupData[{
Cell[13360, 463, 121, 4, 70, "Input",
 CellID->1972194954],
Cell[13484, 469, 179, 5, 36, "Output",
 CellID->270500433]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13724, 481, 145, 6, 70, "Section",
 CellTags->{"t:111", "c:124"},
 CellID->77896732],
Cell[13872, 489, 165, 6, 70, "Text",
 CellID->1392833701],
Cell[14040, 497, 143, 4, 70, "Text",
 CellID->1784260407],
Cell[CellGroupData[{
Cell[14208, 505, 262, 10, 70, "Input",
 CellID->603013741],
Cell[14473, 517, 341, 12, 63, "Output",
 CellID->876614794]
}, Open  ]],
Cell[14829, 532, 166, 4, 70, "Text",
 CellID->1527024338],
Cell[CellGroupData[{
Cell[15020, 540, 469, 18, 70, "Input",
 CellID->120983469],
Cell[15492, 560, 706, 20, 63, "Output",
 CellID->1849633421]
}, Open  ]],
Cell[16213, 583, 114, 3, 70, "Text",
 CellID->1963116422],
Cell[CellGroupData[{
Cell[16352, 590, 274, 10, 70, "Input",
 CellID->158952046],
Cell[16629, 602, 353, 12, 63, "Output",
 CellID->37380254]
}, Open  ]],
Cell[16997, 617, 67, 1, 70, "Text",
 CellID->1184704054],
Cell[CellGroupData[{
Cell[17089, 622, 252, 9, 70, "Input",
 CellID->2000144241],
Cell[17344, 633, 330, 12, 63, "Output",
 CellID->1862731996]
}, Open  ]],
Cell[17689, 648, 74, 1, 70, "Text",
 CellID->920050806],
Cell[CellGroupData[{
Cell[17788, 653, 371, 12, 70, "Input",
 CellID->1411638042],
Cell[18162, 667, 804, 30, 128, "Output",
 CellID->1239838]
}, Open  ]],
Cell[18981, 700, 132, 4, 70, "Text",
 CellID->1510604443],
Cell[CellGroupData[{
Cell[19138, 708, 455, 18, 70, "Input",
 CellID->1177198667],
Cell[19596, 728, 571, 19, 63, "Output",
 CellID->411156458]
}, Open  ]],
Cell[20182, 750, 70, 1, 70, "Text",
 CellID->1851697207],
Cell[CellGroupData[{
Cell[20277, 755, 551, 18, 30, "Input",
 CellID->141945725],
Cell[20831, 775, 1984, 36, 104, "Output",
 Evaluatable->False,
 CellID->325963989]
}, Open  ]],
Cell[22830, 814, 173, 4, 70, "Text",
 CellID->1509419303],
Cell[23006, 820, 1657, 51, 70, "DefinitionBox",
 CellTags->"S3.1.1",
 CellID->585903510],
Cell[24666, 873, 162, 7, 70, "Caption",
 CellTags->"S3.1.1",
 CellID->1067771075],
Cell[24831, 882, 95, 1, 70, "Text",
 CellID->1655103193],
Cell[CellGroupData[{
Cell[24951, 887, 105, 2, 70, "Subsubsection",
 CellTags->{"t:173", "c:125"},
 CellID->963685160],
Cell[25059, 891, 715, 22, 70, "Text",
 CellID->334818446],
Cell[25777, 915, 977, 24, 70, "Text",
 CellID->886466782]
}, Open  ]],
Cell[CellGroupData[{
Cell[26791, 944, 117, 2, 70, "Subsubsection",
 CellTags->{"t:174", "c:126"},
 CellID->1753145835],
Cell[26911, 948, 605, 18, 70, "Text",
 CellID->1646412005],
Cell[27519, 968, 240, 7, 70, "Text",
 CellID->919776440]
}, Open  ]],
Cell[CellGroupData[{
Cell[27796, 980, 104, 2, 70, "Subsubsection",
 CellTags->{"t:175", "c:127"},
 CellID->1095335974],
Cell[27903, 984, 172, 4, 70, "Text",
 CellID->1081892934],
Cell[28078, 990, 216, 5, 70, "Text",
 CellID->630502589]
}, Open  ]],
Cell[CellGroupData[{
Cell[28331, 1000, 93, 2, 70, "Subsection",
 CellTags->{"t:176", "c:128"},
 CellID->1172699025],
Cell[28427, 1004, 152, 4, 70, "Text",
 CellID->2095084656],
Cell[28582, 1010, 409, 8, 70, "Text",
 CellID->1945937180],
Cell[CellGroupData[{
Cell[29016, 1022, 357, 12, 70, "Input",
 CellID->1337724097],
Cell[29376, 1036, 854, 30, 53, "Output",
 CellID->1122597836]
}, Open  ]],
Cell[30245, 1069, 430, 8, 70, "Text",
 CellID->1857990757],
Cell[CellGroupData[{
Cell[30700, 1081, 356, 12, 70, "Input",
 CellID->690941872],
Cell[31059, 1095, 401, 13, 36, "Output",
 CellID->1215963375]
}, Open  ]],
Cell[31475, 1111, 254, 5, 70, "Text",
 CellID->1242058773],
Cell[CellGroupData[{
Cell[31754, 1120, 329, 11, 70, "Input",
 CellID->1740748971],
Cell[32086, 1133, 365, 13, 54, "Output",
 CellID->1598232516]
}, Open  ]],
Cell[32466, 1149, 105, 3, 70, "Text",
 CellID->768439736],
Cell[CellGroupData[{
Cell[32596, 1156, 105, 3, 70, "Input",
 CellID->199989894],
Cell[32704, 1161, 161, 5, 36, "Output",
 CellID->418240903]
}, Open  ]],
Cell[32880, 1169, 329, 7, 70, "Text",
 CellID->660880090],
Cell[CellGroupData[{
Cell[33234, 1180, 329, 11, 70, "Input",
 CellID->626250346],
Cell[33566, 1193, 419, 14, 36, "Output",
 CellID->572211275]
}, Open  ]],
Cell[34000, 1210, 77, 1, 70, "Text",
 CellID->723127659],
Cell[CellGroupData[{
Cell[34102, 1215, 106, 3, 70, "Input",
 CellID->996606440],
Cell[34211, 1220, 176, 5, 36, "Output",
 CellID->1739474127]
}, Open  ]],
Cell[34402, 1228, 246, 5, 70, "Text",
 CellID->1646765878],
Cell[CellGroupData[{
Cell[34673, 1237, 321, 11, 70, "Input",
 CellID->424869010],
Cell[34997, 1250, 445, 17, 51, "Output",
 CellID->390324795]
}, Open  ]],
Cell[35457, 1270, 534, 11, 70, "Text",
 CellID->1773771627]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36040, 1287, 75, 2, 70, "Section",
 CellTags->"c:129",
 CellID->411747335],
Cell[36118, 1291, 324, 8, 70, "Text",
 CellID->1045148711],
Cell[36445, 1301, 482, 10, 70, "Text",
 CellID->1545636964],
Cell[CellGroupData[{
Cell[36952, 1315, 492, 17, 70, "Input",
 CellID->1558259836],
Cell[37447, 1334, 354, 12, 63, "Output",
 CellID->1109988487]
}, Open  ]],
Cell[37816, 1349, 130, 4, 70, "Text",
 CellID->386059520],
Cell[CellGroupData[{
Cell[37971, 1357, 635, 22, 70, "Input",
 CellID->954255053],
Cell[38609, 1381, 699, 20, 63, "Output",
 CellID->756799975]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[39357, 1407, 99, 2, 70, "Section",
 CellTags->{"t:113", "c:130"},
 CellID->2139022291],
Cell[39459, 1411, 530, 10, 70, "Text",
 CellID->1671394057],
Cell[CellGroupData[{
Cell[40014, 1425, 235, 8, 70, "Input",
 CellID->2033813239],
Cell[40252, 1435, 214, 6, 36, "Output",
 CellID->801898574]
}, Open  ]],
Cell[40481, 1444, 221, 8, 70, "Text",
 CellID->2049448293],
Cell[CellGroupData[{
Cell[40727, 1456, 102, 3, 70, "Input",
 CellID->1587246218],
Cell[40832, 1461, 230, 7, 36, "Output",
 CellID->805322892]
}, Open  ]],
Cell[41077, 1471, 82, 1, 70, "Text",
 CellID->1619902450],
Cell[CellGroupData[{
Cell[41184, 1476, 106, 3, 70, "Input",
 CellID->2050284131],
Cell[41293, 1481, 175, 5, 36, "Output",
 CellID->602789955]
}, Open  ]],
Cell[41483, 1489, 506, 11, 70, "Text",
 CellID->1410410786],
Cell[CellGroupData[{
Cell[42014, 1504, 457, 15, 70, "Input",
 CellID->849584716],
Cell[42474, 1521, 1382, 31, 156, "Output",
 CellID->351552909]
}, Open  ]],
Cell[43871, 1555, 132, 4, 70, "Text",
 CellID->822228666],
Cell[CellGroupData[{
Cell[44028, 1563, 444, 14, 70, "Input",
 CellID->139921017],
Cell[44475, 1579, 161, 5, 36, "Output",
 CellID->157939254]
}, Open  ]],
Cell[CellGroupData[{
Cell[44673, 1589, 65, 1, 70, "TutorialMoreAboutSection",
 CellID->24371987],
Cell[44741, 1592, 169, 3, 70, "TutorialMoreAbout",
 CellID->4791866],
Cell[44913, 1597, 147, 3, 70, "TutorialMoreAbout",
 CellID->212289775]
}, Open  ]],
Cell[CellGroupData[{
Cell[45097, 1605, 72, 1, 70, "RelatedTutorialsSection",
 CellID->179478248],
Cell[45172, 1608, 304, 9, 70, "RelatedTutorials",
 CellID->315063104],
Cell[45479, 1619, 191, 5, 70, "RelatedTutorials",
 CellID->3571032],
Cell[45673, 1626, 175, 4, 70, "RelatedTutorials",
 CellID->560755906],
Cell[45851, 1632, 175, 4, 70, "RelatedTutorials",
 CellID->335456077],
Cell[46029, 1638, 160, 4, 70, "RelatedTutorials",
 CellID->472696132]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[46228, 1647, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

