(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    331458,      11631]
NotebookOptionsPosition[    271551,       9456]
NotebookOutlinePosition[    283661,       9867]
CellTagsIndexPosition[    281982,       9799]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Linear Algebra in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/LinearAlgebraOverview"], 
          "Matrix and Tensor Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations"], 
          "Working with Sparse Arrays" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraSparseArrays"], 
          "Matrix Computations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraMatrixComputations"], "Matrix Types" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LinearAlgebraMatrixTypes"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Linear Algebra in Mathematica\"\>", 
       2->"\<\"Matrix and Tensor Operations\"\>", 
       3->"\<\"Working with Sparse Arrays\"\>", 
       4->"\<\"Matrix Computations\"\>", 
       5->"\<\"Matrix Types\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Linear Systems" :> 
          Documentation`HelpLookup["paclet:guide/LinearSystems"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Matrices and Linear Algebra\"\>", 
       2->"\<\"Linear Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"All" :> Documentation`HelpLookup["paclet:ref/All"], "Append" :> 
          Documentation`HelpLookup["paclet:ref/Append"], "ArrayDepth" :> 
          Documentation`HelpLookup["paclet:ref/ArrayDepth"], "ArrayQ" :> 
          Documentation`HelpLookup["paclet:ref/ArrayQ"], "ArrayRules" :> 
          Documentation`HelpLookup["paclet:ref/ArrayRules"], "Band" :> 
          Documentation`HelpLookup["paclet:ref/Band"], "DiagonalMatrix" :> 
          Documentation`HelpLookup["paclet:ref/DiagonalMatrix"], "Dimensions" :> 
          Documentation`HelpLookup["paclet:ref/Dimensions"], "Drop" :> 
          Documentation`HelpLookup["paclet:ref/Drop"], "False" :> 
          Documentation`HelpLookup["paclet:ref/False"], "Flatten" :> 
          Documentation`HelpLookup["paclet:ref/Flatten"], "IdentityMatrix" :> 
          Documentation`HelpLookup["paclet:ref/IdentityMatrix"], "Insert" :> 
          Documentation`HelpLookup["paclet:ref/Insert"], "Join" :> 
          Documentation`HelpLookup["paclet:ref/Join"], "List" :> 
          Documentation`HelpLookup["paclet:ref/List"], "MatrixForm" :> 
          Documentation`HelpLookup["paclet:ref/MatrixForm"], "MatrixQ" :> 
          Documentation`HelpLookup["paclet:ref/MatrixQ"], "Normal" :> 
          Documentation`HelpLookup["paclet:ref/Normal"], "Partition" :> 
          Documentation`HelpLookup["paclet:ref/Partition"], "Prepend" :> 
          Documentation`HelpLookup["paclet:ref/Prepend"], "SparseArray" :> 
          Documentation`HelpLookup["paclet:ref/SparseArray"], "Tr" :> 
          Documentation`HelpLookup["paclet:ref/Tr"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"], "VectorQ" :> 
          Documentation`HelpLookup["paclet:ref/VectorQ"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"All\"\>", 2->"\<\"Append\"\>", 
       3->"\<\"ArrayDepth\"\>", 4->"\<\"ArrayQ\"\>", 5->"\<\"ArrayRules\"\>", 
       6->"\<\"Band\"\>", 7->"\<\"DiagonalMatrix\"\>", 
       8->"\<\"Dimensions\"\>", 9->"\<\"Drop\"\>", 10->"\<\"False\"\>", 
       11->"\<\"Flatten\"\>", 12->"\<\"IdentityMatrix\"\>", 
       13->"\<\"Insert\"\>", 14->"\<\"Join\"\>", 15->"\<\"List\"\>", 
       16->"\<\"MatrixForm\"\>", 17->"\<\"MatrixQ\"\>", 18->"\<\"Normal\"\>", 
       19->"\<\"Partition\"\>", 20->"\<\"Prepend\"\>", 
       21->"\<\"SparseArray\"\>", 22->"\<\"Tr\"\>", 23->"\<\"True\"\>", 
       24->"\<\"VectorQ\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Working with Sparse Arrays", "Title",
 ShowCellBracket->True,
 CellTags->{"t:28", "c:37"},
 CellID->1619024906],

Cell[TextData[{
 "Sparse representations of matrices are useful because they do not store \
every element. If one particular value appears very frequently it can be very \
advantageous to use a sparse representation. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " offers a sparse representation for matrices, vectors, and tensors with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 "."
}], "Text",
 CellID->186304005],

Cell[TextData[{
 "This tutorial discusses how to create and work with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". If you are interested in carrying out linear algebra computations on \
sparse matrices, you should consult \"",
 ButtonBox["Matrix Computations",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#1927833614"],
 "\"."
}], "Text",
 CellID->180254709],

Cell[CellGroupData[{

Cell["Basic Operations", "Section",
 CellTags->{"t:121", "c:38"},
 CellID->1588951893],

Cell[TextData[{
 "The basic object for representing a sparse matrix in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1555315206],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "a ",
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"],
     " version of an ordinary list "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", "{", "{", 
     SubscriptBox[
      StyleBox["i", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["j", "TI"], "1"], "}", 
     StyleBox["->", "MR"], 
     SubscriptBox[
      StyleBox["v", "TI"], "1"], ",", "{", 
     SubscriptBox[
      StyleBox["i", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["j", "TI"], "2"], "}", 
     StyleBox["->", "MR"], 
     SubscriptBox[
      StyleBox["v", "TI"], "2"], ",", "\[Ellipsis]", "}", ",", "{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "an ",
     Cell[BoxData[
      RowBox[{
       StyleBox["m", "TI"], "\[Cross]", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " sparse array with element ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["k", "TI"]], ",", 
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["k", "TI"]]}], "}"}]], "InlineFormula"],
     " having value ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", "{", "{", 
     SubscriptBox[
      StyleBox["i", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["j", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["i", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["j", "TI"], "2"], "}", ",", "\[Ellipsis]", "}", 
     StyleBox["->", "MR"], "{", 
     SubscriptBox[
      StyleBox["v", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["v", "TI"], "2"], ",", "\[Ellipsis]", "}", ",", "{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]"}], Cell[
    "the same sparse array ", "TableText"]},
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", 
     StyleBox["data", "TI"], ",", "{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "}", ",", 
     StyleBox["def", "TI"], "]"}], Cell[TextData[{
     "an ",
     Cell[BoxData[
      RowBox[{"m", "\[Cross]", "n"}]], "InlineFormula"],
     " sparse array with default element ",
     StyleBox["def", "TI"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", 
     RowBox[{
      RowBox[{
       ButtonBox["Band",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Band"], "[", 
       StyleBox["b", "TI"], "]"}], "\[Rule]", 
      StyleBox["v", "TI"]}], ",", "{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "an ",
     Cell[BoxData[
      RowBox[{"m", "\[Cross]", "n"}]], "InlineFormula"],
     " banded sparse array",
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Normal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Normal"], "[", 
     StyleBox["array", "TI"], "]"}], Cell[TextData[{
     "the ordinary list corresponding to a ",
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ArrayRules",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArrayRules"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[
    "positions of nonzero elements ", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, True, {False}, False}, 
   "RowsIndexed" -> {}}},
 CellTags->"S3.7.12",
 CellID->1011715958],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object can be created by giving a list of those elements that are ",
 "nonzero",
 "."
}], "Text",
 CellID->134589160],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "4.1"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "5.2"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "3.1"}]}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->739731829],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->890017520]
}, Open  ]],

Cell[TextData[{
 "By default, a sparse matrix will print with a special output format. You \
can see the matrix that the sparse array represents by using ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1300857285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2124862535],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"4.1`", "0", "5.2`"},
     {"0", "0", "0"},
     {"0", "3.1`", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 2, 3}, {{1}, {3}, {2}}}, {4.1, 5.2, 3.1}}]]]], "Output",
 ImageSize->{103, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->2059059782]
}, Open  ]],

Cell["\<\
Operations on sparse matrices are all equivalent to the operations on dense \
matrices. For example, arithmetic is supported and a sparse array is the \
result.\
\>", "Text",
 CellID->2066268316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.5", " ", "sp"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->813531375],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2140922823]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1401380676],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"6.1499999999999995`", "0", "7.800000000000001`"},
     {"0", "0", "0"},
     {"0", "4.65`", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 2, 3}, {{1}, {3}, {2}}}, {6.15, 7.8, 4.65}}]]]], "Output",
 ImageSize->{117, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->1551864883]
}, Open  ]],

Cell["\<\
Listable operations also work on sparse arrays to thread over all elements.\
\>", "Text",
 CellID->1004195766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", "sp", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->444257389],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1980779951]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->677140663],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "0.8182771110644103`"}], "0", 
      RowBox[{"-", "0.8834546557201531`"}]},
     {"0", "0", "0"},
     {"0", "0.04158066243329049`", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 2, 3}, {{1}, {3}, {
      2}}}, {-0.81827711106441, -0.883454655720153, 
     0.0415806624332905}}]]]], "Output",
 ImageSize->{231, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->1187277588]
}, Open  ]],

Cell[TextData[{
 "All combinations of matrix multiplication using the function ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " are supported. This demonstrates the dot product of two sparse arrays."
}], "Text",
 CellID->156373592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", ".", "sp"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1798460463],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->892670116]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->785881670],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"16.81`", "16.12`", "21.32`"},
     {"0", "0", "0"},
     {"0", "0", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 3, 3, 3}, {{1}, {3}, {2}}}, {16.81, 21.32, 16.12}}]]]], "Output",
 ImageSize->{145, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//MatrixForm=",
 CellID->1288798640]
}, Open  ]],

Cell["\<\
This demonstrates the dot product of a sparse array with a dense vector.\
\>", "Text",
 CellID->1318678838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", ".", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1003993226],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"19.7`", ",", "0.`", ",", "6.2`"}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->1335134903]
}, Open  ]],

Cell["\<\
The dot product of a sparse array with a dense matrix is supported.\
\>", "Text",
 CellID->555687218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", ".", 
  RowBox[{"DiagonalMatrix", "[", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[10]:=",
 CellID->28692123],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4.1`", ",", "0.`", ",", "15.600000000000001`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "6.2`", ",", "0.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{304, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->1192174333]
}, Open  ]],

Cell["\<\
Sparse representations are useful because they do not store every element. If \
one particular value, typically this is zero, appears many times in the \
sparse array, it can be much more efficient if only elements that are \
different from this common value are stored. The default output format shows \
the number of non-default elements and the dimensions.\
\>", "Text",
 CellID->851588221],

Cell[CellGroupData[{

Cell[BoxData["sp"], "Input",
 CellLabel->"In[11]:=",
 CellID->1812206739],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->2145580619]
}, Open  ]],

Cell["\<\
If a single number is added to the sparse array, it is added to all elements \
and also to the default element, which was zero. Now that the default element \
is no longer zero but 1.5, it is shown in the output.\
\>", "Text",
 CellID->228063109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "+", "1.5"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->1945846715],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}], ",", "1.5`"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{199, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->1964762489]
}, Open  ]],

Cell[TextData[{
 "If the ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " command is applied to a sparse matrix, it works on all the elements. This \
builds an example 3\[Cross]3 sparse matrix."
}], "Text",
 CellID->2054596351],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "4"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "5"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "3"}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[13]:=",
 CellID->63827497],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"4", "0", "5"},
     {"0", "0", "0"},
     {"0", "3", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 2, 3}, {{1}, {3}, {2}}}, {4, 5, 3}}]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]//MatrixForm=",
 CellID->1154402226]
}, Open  ]],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " is applied to the sparse matrix, the result is a sparse matrix with \
elements (including the default element) that are all approximate machine \
numbers."
}], "Text",
 CellID->1670945384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", "sp", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->935417069],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"4.`", "0.`", "5.`"},
     {"0.`", "0.`", "0.`"},
     {"0.`", "3.`", "0.`"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0., {
    1, {{0, 2, 2, 3}, {{1}, {3}, {2}}}, {4., 5., 3.}}]]]], "Output",
 ImageSize->{82, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]//MatrixForm=",
 CellID->1974382643]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " with a precision argument is applied to the matrix. This generates a \
sparse matrix of approximate real numbers with 20 digits of precision. Note \
that ",
 StyleBox["N[0,20]", "MR"],
 " is still 0."
}], "Text",
 CellID->531767457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"sp", ",", "20"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->1736194632],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"4.`20.", "0", "5.`20."},
     {"0", "0", "0"},
     {"0", "3.`20.", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 2, 3}, {{1}, {3}, {2}}}, {
     4.`20., 5.`20., 3.`20.}}]]]], "Output",
 ImageSize->{481, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]//MatrixForm=",
 CellID->215384588]
}, Open  ]],

Cell[CellGroupData[{

Cell["SparseArray", "Subsection",
 CellTags->{"t:122", "c:39"},
 CellID->1458825321],

Cell[TextData[{
 "The main function for generating a sparse array is ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ". This can operate on a matrix to generate its sparse representation."
}], "Text",
 CellID->656372248],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"SparseArray", "[", " ", "mat", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->24877497],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1504264561]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1996984243],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "3"},
     {"0", "3", "0"},
     {"0", "0", "1"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 3, 4}, {{1}, {3}, {2}, {3}}}, {1, 3, 3, 1}}]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->292253138]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " can also take a list of rules showing the values for certain parts."
}], "Text",
 CellID->603389677],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "3."}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "2."}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "4."}]}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->752520205],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1075888252]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->641543624],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"3.`", "0", "0"},
     {"4.`", "0", "2.`"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {2, 3}, 0, {
    1, {{0, 1, 3}, {{1}, {3}, {1}}}, {3., 2., 4.}}]]]], "Output",
 ImageSize->{75, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->2055780628]
}, Open  ]],

Cell[TextData[{
 "An equivalent syntax for ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " groups the indices and element values into their own lists."
}], "Text",
 CellID->640618213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp1", "=", 
  RowBox[{"SparseArray", "[", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"3.", ",", "2.", ",", "4."}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1534783480],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1679864243]
}, Open  ]],

Cell[TextData[{
 "The results of the two forms of ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " are identical. "
}], "Text",
 CellID->510824992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "===", "sp1"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1943503485],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1236801525]
}, Open  ]],

Cell[TextData[{
 "A fuller discussion of the relative advantages of the two forms is given in \
the section \"",
 ButtonBox["Rule Inputs for SparseArray",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraSparseArrays#1126881263"],
 "\"."
}], "Text",
 CellID->1429011362],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " can also accept the dimensions of the matrix to be created. Here a 5x5 \
matrix is created even though the maximum explicit index was {2,3}."
}], "Text",
 CellID->2084336733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", "  ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "3."}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "2."}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "4."}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1694221667],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->1297881696]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1506262093],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"3.`", "0", "0", "0", "0"},
     {"4.`", "0", "2.`", "0", "0"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {5, 5}, 0, {
    1, {{0, 1, 3, 3, 3, 3}, {{1}, {3}, {1}}}, {3., 2., 4.}}]]]], "Output",
 ImageSize->{105, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]//MatrixForm=",
 CellID->1209766215]
}, Open  ]],

Cell["\<\
In this example the default value is set to 1; typically the default value is \
0.\
\>", "Text",
 CellID->165605709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", "  ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "3."}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "2."}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "4."}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5"}], "}"}], ",", "1."}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->196344651],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}], ",", "1.`"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->1429667565]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->228238672],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"3.`", "1.`", "1.`", "1.`", "1.`"},
     {"4.`", "1.`", "2.`", "1.`", "1.`"},
     {"1.`", "1.`", "1.`", "1.`", "1.`"},
     {"1.`", "1.`", "1.`", "1.`", "1.`"},
     {"1.`", "1.`", "1.`", "1.`", "1.`"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {5, 5}, 1., {
    1, {{0, 1, 3, 3, 3, 3}, {{1}, {3}, {1}}}, {3., 2., 4.}}]]]], "Output",
 ImageSize->{126, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]//MatrixForm=",
 CellID->601566762]
}, Open  ]],

Cell["\<\
Allowing the default value to be changed makes many element-wise operations \
very fast. They just need to work on the elements that are actually present \
and the default value.\
\>", "Text",
 CellID->179558858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", "%", "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->631202371],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}], ",", "0.8414709848078965`"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->49033217]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->1615041318],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.1411200080598672`", "0.8414709848078965`", "0.8414709848078965`", 
      "0.8414709848078965`", "0.8414709848078965`"},
     {
      RowBox[{"-", "0.7568024953079282`"}], "0.8414709848078965`", 
      "0.9092974268256817`", "0.8414709848078965`", "0.8414709848078965`"},
     {"0.8414709848078965`", "0.8414709848078965`", "0.8414709848078965`", 
      "0.8414709848078965`", "0.8414709848078965`"},
     {"0.8414709848078965`", "0.8414709848078965`", "0.8414709848078965`", 
      "0.8414709848078965`", "0.8414709848078965`"},
     {"0.8414709848078965`", "0.8414709848078965`", "0.8414709848078965`", 
      "0.8414709848078965`", "0.8414709848078965`"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {5, 5}, 0.841470984807897, {
    1, {{0, 1, 3, 3, 3, 3}, {{1}, {3}, {1}}}, {0.141120008059867, 
     0.909297426825682, -0.756802495307928}}]]]], "Output",
 ImageSize->{344, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]//MatrixForm=",
 CellID->1953617193]
}, Open  ]],

Cell[TextData[{
 "You can also give patterns for the rules. This can often be a convenient \
way to build structured matrices. You can use the names of the patterns on \
the right-hand side of the rules. Typically, it is better to us ",
 Cell[BoxData[
  ButtonBox["Band",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Band"]], "InlineFormula"],
 " if this can be done, this is discussed in the section \"",
 ButtonBox["Banded Sparse Arrays",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraSparseArrays#69082539"],
 "\"."
}], "Text",
 CellID->21561225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", "i"}], ",", 
     "\[IndentingNewLine]", "\t", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
       RowBox[{"i", "==", 
        RowBox[{"j", "+", "1"}]}]}], "\[Rule]", "j"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->957092909],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "19", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 19, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "10"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->1208005533]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->638594393],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"1", "2", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "2", "3", "0", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "3", "4", "0", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "4", "5", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "5", "6", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "6", "7", "0", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "7", "8", "0", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "8", "9", "0"},
     {"0", "0", "0", "0", "0", "0", "0", "0", "9", "10"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {10, 10}, 0, {
    1, {{0, 1, 3, 5, 7, 9, 11, 13, 15, 17, 19}, {{1}, {1}, {2}, {2}, {3}, {
      3}, {4}, {5}, {4}, {6}, {5}, {6}, {7}, {7}, {8}, {8}, {9}, {10}, {
      9}}}, {1, 1, 2, 2, 3, 3, 4, 5, 4, 6, 5, 6, 7, 7, 8, 8, 9, 10, 
     9}}]]]], "Output",
 ImageSize->{173, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]//MatrixForm=",
 CellID->1880179092]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses symbolic algebraic techniques to simplify certain of the patterns for \
building sparse arrays. This allows it to construct the sparse array without \
testing every potential element to see if it is actually present in the \
array, thus providing a significant saving in computational time."
}], "Text",
 CellID->2095617286],

Cell[TextData[{
 "You can use the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 StyleBox["Random", "MR"],
 " to generate sparse arrays with entries that are pseudorandom numbers. You \
can also use ",
 StyleBox["Random", "MR"],
 " to generate the indices for the sparse array. In this example a \
10\[Cross]10 sparse matrix with at most 50 non-default entries is generated."
}], "Text",
 CellID->160431355],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", "\[IndentingNewLine]", "\t", 
    RowBox[{
     RowBox[{"Table", "[", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Random", "[", 
           RowBox[{"Integer", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "10"}], "}"}]}], "]"}], ",", 
          RowBox[{"Random", "[", 
           RowBox[{"Integer", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "10"}], "}"}]}], "]"}]}], "}"}], "\[Rule]", 
        "1"}], ",", 
       RowBox[{"{", "50", "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[16]:=",
 CellID->1277806500],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnDFTwjAUx0srqIjOjn4anfwQHOcdDp4eOrAxMjI41I07vwBjR0ZGRkZG
RkbG+pqktoSmTWmEFv/c0TThpe0vfcnLC0ke2x/dp5f2x3OnfffQa791nzvv
d/evPUpyapZlfdP389aic5/O2Pfb9ymMH+vB0RmPxz77WDYd6iR6RaFDYUuE
V3umN9j1B4OBuL7D7nrGTheLhed5wSl/iuAJuVSTJf7GWR5LkdoqSd5GWJLz
+VwmdV1XSJ0O6Waz6ff7EakTpnJYIXX8py2S95zFh8MhYfmidnBSezabnZfk
KYsTUjWkyrhNyLR2tVr5J/UuozYnThq1T6dDSirLm3UFadAS2ZTp2t9uuVt7
prNni7V0tcS7fknx/ysVWIa45ZQtaVZctrQXWnfV0289bTQppZcXjGAEIxjL
x5hkTfPGd61p+axWWaXqCeVYJLzUuivz7jT1qmqpenqPEkAJoARQAiiB41ig
strj4/UAQn+4KYWyHy2nm+wByH3IrLheT7RIr9Z83QYjGMEIxr9hjFvT0E+W
Q9XvsKbFpVS9GdUotPy7bH0P1Ys0r6956xVIQQpSkFaNNM1/TbOsKguNEex8
Uir/Nev/378YwTbTdyzjKA14wQte8FaFN80P1rXO8IP3lwpnaWWNFmf5x8Vm
aR1KUw8/bwKkIAUpSMtDGp/JpWtZMZPLnJTsB6ssqcoiy/lM+sEmR2nM1wKT
PWiQghSkID0EaZKPmzXCnGaB4ePmk5JXIun6tioLrVf+RVbamdfUInXB5CoI
8IIXvOA9Pm/a+uAs/zcp3/+xyqPRSEMq2nMjLuW67nq9Dss/zQo3fb35zWHI
V4Uvl8vJZBKcxleFe54ndq0wP9/BzH8zWXFON51OE/YxoAIVzNWmI73a2odC
3lvEqTRdVD8iOpu0sqrvLLAXNukde36x70v0ruwKU+3onKDjm4VUny7i4HRp
flHeuclBeMOuyvdfsmo/4MZlIQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{162, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]//MatrixForm=",
 CellID->165478800]
}, Open  ]],

Cell[TextData[{
 "If you want to use ",
 StyleBox["Random", "MR"],
 " on the right-hand side of the rules in sparse array, or any other \
expression that will evaluate, you should use ",
 Cell[BoxData[
  ButtonBox["RuleDelayed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RuleDelayed"]], "InlineFormula"],
 " (entered with \[RuleDelayed]) to form the rules. If you do not do this, \
the same number will be used throughout the sparse matrix. "
}], "Text",
 CellID->1470942020],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", "\[IndentingNewLine]", "\t ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"i", "-", "j"}], "]"}], "<", "2"}]}], "\[RuleDelayed]", 
      RowBox[{"Random", "[", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[18]:=",
 CellID->290785876],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.3793705659327975`", "0.3307236230138234`", "0", "0"},
     {"0.672175570416085`", "0.41353867027476743`", "0.6903289696041711`", 
      "0"},
     {"0", "0.30653990268114745`", "0.34298799229580795`", 
      "0.5426837133557332`"},
     {"0", "0", "0.426609301333666`", "0.1257342760815868`"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {4, 4}, 0, {
    1, {{0, 2, 5, 8, 10}, {{1}, {2}, {1}, {2}, {3}, {3}, {4}, {2}, {3}, {
      4}}}, {0.379370565932798, 0.330723623013823, 0.672175570416085, 
     0.413538670274768, 0.690328969604171, 0.342987992295808, 
     0.542683713355733, 0.306539902681147, 0.426609301333666, 
     0.125734276081587}}]]]], "Output",
 ImageSize->{272, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]//MatrixForm=",
 CellID->1712921007]
}, Open  ]],

Cell[TextData[{
 "The general principle is that the rules you use with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " work in the typical way for rules in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->2045076614],

Cell[CellGroupData[{

Cell["Rule Inputs for SparseArray", "Subsubsection",
 CellTags->{"t:230", "c:40"},
 CellID->1126881263],

Cell[TextData[{
 "There are two different ways that rules can be used as input syntax for ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ". These are demonstrated below."
}], "Text",
 CellID->835104348],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp1", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "3."}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "2."}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "4."}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"sp2", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"3.", ",", "2.", ",", "4."}], "}"}]}], "]"}]}], ";"}]}], "Input",\

 CellLabel->"In[1]:=",
 CellID->1793143691],

Cell["Both generate identical sparse arrays.", "Text",
 CellID->1727996286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp1", "===", "sp2"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2012220421],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->816142791]
}, Open  ]],

Cell["\<\
The first form, which has many rules, is convenient if you want to mix \
explicit indices with patterns. It is also more readable for small examples. \
The second is more efficient, and is preferred if you only have explicit \
indices, for example, after reading data from a file.\
\>", "Text",
 CellID->933834948],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " with many rules to mix explicit values with patterns."
}], "Text",
 CellID->1153478760],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp1", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "3."}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "2."}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", "4."}], ",", " ", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", 
       RowBox[{"-", "1"}]}]}], "}"}], "]"}]}], ";"}], "\n", 
 RowBox[{"sp1", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->1182637851],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "1"}], "3.`", "0"},
     {"0", 
      RowBox[{"-", "1"}], "2.`"},
     {"4.`", "0", 
      RowBox[{"-", "1"}]}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 4, 6}, {{1}, {2}, {3}, {2}, {3}, {1}}}, {-1, 3., 2., -1, -1, 
      4.}}]]]], "Output",
 ImageSize->{85, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->1633208772]
}, Open  ]],

Cell[TextData[{
 "This demonstrates the form of ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " that uses only one rule. The timing is measured to demonstrate \
performance."
}], "Text",
 CellID->203855050],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", ",", "i"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "50000"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"elems", "=", 
   RowBox[{"Range", "[", "50000", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SparseArray", "[", " ", 
   RowBox[{"ind", "\[Rule]", "elems"}], "]"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[6]:=",
 CellID->955408385],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.010000000000000009`", " ", "Second"}], ",", 
   TagBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{
      InterpretationBox[
       RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "50000", 
        "\[InvisibleSpace]", "\<\">\"\>"}],
       SequenceForm["<", 50000, ">"],
       Editable->False], ",", 
      RowBox[{"{", 
       RowBox[{"50000", ",", "50000"}], "}"}]}], "]"}],
    False,
    Editable->False]}], "}"}]], "Output",
 ImageSize->{355, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->813498076]
}, Open  ]],

Cell[TextData[{
 "It is possible to convert the single rule to multiple rules using ",
 Cell[BoxData[
  ButtonBox["Thread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thread"]], "InlineFormula"],
 ". This takes more time than generating the sparse array."
}], "Text",
 CellID->1581266530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"tind", "=", 
    RowBox[{"Thread", "[", 
     RowBox[{"ind", "\[Rule]", " ", "elems"}], "]"}]}], ";"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1236438085],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.21000000000000002`", " ", "Second"}], ",", "Null"}], 
  "}"}]], "Output",
 ImageSize->{131, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->1763126223]
}, Open  ]],

Cell[TextData[{
 "This uses the multiple rule form of ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ".",
 " ",
 "It is slower than the single rule form."
}], "Text",
 CellID->1883068655],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", "tind", "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->1268378746],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.10999999999999999`", " ", "Second"}], ",", 
   TagBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{
      InterpretationBox[
       RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "50000", 
        "\[InvisibleSpace]", "\<\">\"\>"}],
       SequenceForm["<", 50000, ">"],
       Editable->False], ",", 
      RowBox[{"{", 
       RowBox[{"50000", ",", "50000"}], "}"}]}], "]"}],
    False,
    Editable->False]}], "}"}]], "Output",
 ImageSize->{355, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->1718903900]
}, Open  ]],

Cell[TextData[{
 "One reason why the single rule form of ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " is faster is that the indices and elements can use packed arrays, an \
efficient storage technology. If they are converted from packed arrays then \
",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " is slower as shown below."
}], "Text",
 CellID->1667827856],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"Developer`FromPackedArray", "[", "ind", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"elems", "=", 
   RowBox[{"Developer`FromPackedArray", "[", "elems", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SparseArray", "[", " ", 
   RowBox[{"ind", "\[Rule]", "elems"}], "]"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[11]:=",
 CellID->78731501],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.040000000000000036`", " ", "Second"}], ",", 
   TagBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{
      InterpretationBox[
       RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "50000", 
        "\[InvisibleSpace]", "\<\">\"\>"}],
       SequenceForm["<", 50000, ">"],
       Editable->False], ",", 
      RowBox[{"{", 
       RowBox[{"50000", ",", "50000"}], "}"}]}], "]"}],
    False,
    Editable->False]}], "}"}]], "Output",
 ImageSize->{355, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->390410755]
}, Open  ]],

Cell[TextData[{
 "More information on packed arrays is found under \"",
 ButtonBox["Packed Arrays",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraPerformance#1945433762"],
 "\"."
}], "Text",
 CellID->1071017700]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Banded Sparse Arrays", "Subsection",
 CellTags->{"t:205", "c:41"},
 CellID->69082539],

Cell[TextData[{
 "If you want to build sparse matrices that have some type of banded \
structure, this can be achieved with ",
 Cell[BoxData[
  ButtonBox["Band",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Band"]], "InlineFormula"],
 "."
}], "Text",
 CellID->367598786],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", 
     RowBox[{
      RowBox[{
       ButtonBox["Band",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Band"], "[", 
       StyleBox["b", "TI"], "]"}], "\[Rule]", 
      StyleBox["v", "TI"]}], ",", "{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "an ",
     Cell[BoxData[
      RowBox[{"m", "\[Cross]", "n"}]], "InlineFormula"],
     " banded sparse array",
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Band",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Band"], "[", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["i", "TI"], ",", 
       StyleBox["j", "TI"]}], "}"}], "]"}], Cell[TextData[{
     "a diagonal band that starts with the position ",
     "{",
     StyleBox["i", "TI"],
     ",",
     " ",
     StyleBox["j", "TI"],
     "}",
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Band",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Band"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["j", "TI"], 
        StyleBox["min", "TI"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["max", "TI"]], ",", 
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["max", "TI"]]}], "}"}], "]"}], Cell[TextData[{
     "a diagonal band from ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox[
        SubscriptBox["i", "min"], "TI"]}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["j", "min"], "TI"]], "InlineFormula"],
     "} to ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox[
        SubscriptBox["i", "max"], "TI"]}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["j", "max"], "TI"]], "InlineFormula"],
     "} "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Band",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Band"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["j", "TI"], 
        StyleBox["min", "TI"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["max", "TI"]], ",", 
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["max", "TI"]]}], "}"}], 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["d", "TI"], 
        StyleBox["i", "TI"]], ",", 
       SubscriptBox[
        StyleBox["d", "TI"], 
        StyleBox["j", "TI"]]}], "}"}], "]"}], Cell[TextData[{
     "a diagonal band from ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox[
        SubscriptBox["i", "min"], "TI"]}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["j", "min"], "TI"]], "InlineFormula"],
     "} moving with step ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox[
        SubscriptBox["d", "i"], "TI"]}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox["d", "j"], "TI"]], "InlineFormula"],
     "} "
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"S3.7.12",
 CellID->283198658],

Cell["This creates a diagonal matrix.", "Text",
 CellID->76232053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Band", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "x"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->384700003],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWCtzwkAQDnm0UKioKi2GX9MOAo3OMJ0BwbRDETgkEonkJyAjkUgkEolE
Iq97rzyOSwhwOTKFzCS32ezc93G7+82wTXfQ+eq5g27brX/23Z9Ot/1b//ju
g8sqGIbRgrtRNcBGYJG7hRCs4aeDn9ZsNkPkMhrkfTQasXeLRNnEXK/Xnudh
E79bsGElZn2C1YTVZOsDR1mtVuKu0+k0jOVgnvwy2F4KvLbvBeORwO33++Fw
GPCxuJdSovwy4FNmp1IieOPxGCCxafoszOVy6WhBh4RCWqPoJCfb7TbLMzjM
SRFFayzMJ6jHrPiUULRi/QqhraGZzSvPAnMVpOi4QpK6sCrEy3dp3qOOnKeo
ZmXmL6XaVVGNRHqlLI0rauLDFaRyZ5G73Ig6Jo/SxebtAvS4bqyhU7ovr1pz
fXWLUzX+PSN1S9Erumo2WUFui0XecpNOx3SxkevYJehiN9bQOd2XV625nrod
UzVl6nZ2r6iv2XMU5L+yyFtuLtEx9WxO0TEV6iaq2u2p22QySREVzN/CUfD/
f7fbEROlUzW+0ixtNpv5fI7N8PTC8zw2hSM1orhX5F46TVksFpJZE/xExtJB
qhQkiQVkJDJvE6eQthYWQQUELEzIi76c4JmsCSdPEOkc2PZPAalWrXgOBxNg
NpOmA0hsvmSKHuBQ9HeU3FvPJIpOz43CHztCS38=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{87, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->219506269]
}, Open  ]],

Cell["This has bands above and below the diagonal.", "Text",
 CellID->114287875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "]"}], "\[Rule]", "x"}], ",", 
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], "]"}], "\[Rule]", "y"}]}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->659211409],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWL9PAjEULgenIjqpEaMDMUZnB/Uf8EccnJmJMdHBaNCBjZGRkZE/gfFG
RkZGRkZGRsb62tfau7N3tvTOaCS5a/t4r+/jvdfvjnfXeH98eG68P903ajfN
xuvj0/1b7fqlCaJigRBSh+u2SmBOYcavOqUw4v0C7iUQHvCVz+7Ffr9P+Yec
8jWzwfUOX7fbbbEucqsSn04mkyAI2JStmdFGbNyM7VYR8lXpdTwex3ft9Xph
X/6nNdchZN1CynB4MFa0365wJ4vFotVqKRRFKUUgiMoJRSUUBZKIBmPS6XTA
NZt6n2i80WjkZ4OipHKRpIc4ILGQ3igOnpvZbJZNVGykiEnVWxiTqk13TGWK
9YlbyU85BRMkCw9Pbpj2tNI1mQ8hKmi9+1R/LvfFWI7p63e5+9NahxT57sRI
+4hGGevYyCoe5yTeYxlmfOSJcc1od5saSmc8bhPhALMKsEFgxnYVgXM9H/8G
PJcfAmtpzhmxYbUyzbtC9Xy2a+Qnfs4kj1WNrH8rQ5lpbVHksXMjbXxvU3V1
ZhVfU/6ScpeatWUsvZ5Lndox1kY+/i0YK3sEboyVfUZcGEuP2gWNnrHS3stM
z9k+/X/vYyzGrHyujLTxP5qqtsulrL7jL/k8MYv/Cs2CsVzq1A/9vmUZy9m/
M2Nlf1LdGMsFD1tny1guaLa0tnrGcvGzTaP8ZXeOfitD2Wh1u10DLdVfC2vB
v/f5fE6peh58x09yxOxMp9PBYMCm4d5DEASiq5ZyRpY+DWn9meFwqOkZwU8U
KJPffmw5Ig0FZCTSQTPrKmaNQlWAQuFBXn4uJ/wpBZFHQvJjUfC0Ni7MlIzi
S/QFGmwlJqOx4as078oPepenKs5ake6N6JaTwgfJDCGp\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{87, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->96019624]
}, Open  ]],

Cell["This inserts a band along the anti-diagonal.", "Text",
 CellID->22021673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Band", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "]"}], "\[Rule]", "x"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->199368755],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWLFuwjAQNQ5QKN3aSq3aga9pxcDMHKFKdKhaUQY2RkZGRj6BMSMjIyMj
IyMjo3vx2U1iGUiwHdECUmL7dPK93Lt7Etf0e523D7/33vbrr13/q/Pe/q6/
fHbB5BUIIS14Gg8E9gx2/GkxBmv8XQrf3mQyYfxHGvw8GAzE2eNeRb5dLpdB
EIRbCi8KF8q1BqsH682O9UpGWSwW6q3j8TgeqxjixDPeS0q/FjSSa2NrmYfb
brf9fj/C40krQuK5oeIrXKDArAyHQwgps4oo6Hw+L+cSHQgFWpPROSfr9ZrT
kRsniCdZYxJPsh7jlWcedx8aIAZbYweaW0fRK5IFYSpoo9+x/V1XVfz1tzQv
XsJaEnkLOUmjbunyyztIz7vlvqoY4KkxW2rz91GcGjdVZlvzTNA85hRdduMT
u6ibDS+ZT5m/QypnrG6W+8q4o62ozX9FcWrcmGiefTRZNC+busluU1Xuom7Z
vNR8HlI5R+p2dF856uiManNeKE6Nm3SalxcaveYdp26qyp2Puo1GoxRe0fwt
7gX//zebzb587lI5nF6sVqvpdBpu49OLIAjEFM5SB6XoK6ya2WymmTXBJwqU
rvBItalKRhLzNu0U0jmKqAIiFBR4yY+TsEYoZJ5HFHPgKAvUEQ5V48q67As0
OIJ0ieZeiYPRD02zn7kXzs9J4QeQUkt/\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{87, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->632096917]
}, Open  ]],

Cell[TextData[{
 "In general, if you can use ",
 Cell[BoxData[
  ButtonBox["Band",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Band"]], "InlineFormula"],
 " to create a sparse array it will be more efficient."
}], "Text",
 CellID->427894693]
}, Open  ]],

Cell[CellGroupData[{

Cell["Identity and Diagonal Sparse Matrices", "Subsection",
 CellTags->{"t:205", "c:41"},
 CellID->386554746],

Cell[TextData[{
 "There are a number of ways to create identity and diagonal sparse matrices \
in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->687583847],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["IdentityMatrix",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IdentityMatrix"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      RowBox[{"Sparse", "\[Rule]", "True"}]}], "]"}], Cell[
    "a sparse identity matrix", "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["DiagonalMatrix",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DiagonalMatrix"], "[", 
      RowBox[{
       ButtonBox["SparseArray",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SparseArray"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["a", "TI"], ",", 
         StyleBox["b", "TI"], ",", 
         StyleBox["c", "TI"], ",", 
         StyleBox["d", "TI"]}], "}"}], "]"}]}], "]"}], Cell[
    "a sparse diagonal matrix", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->612212022],

Cell["\<\
This generates a 4\[Cross]4 sparse identity matrix.\
\>", "Text",
 CellID->853300977],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"IdentityMatrix", "[", 
    RowBox[{"4", ",", 
     RowBox[{"Sparse", "\[Rule]", "True"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->533725773],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmL1ugzAQgA2E/iXZO+Y1unRss/QhUFQpGapWaYZsjIyMjDwCI2NGRkZG
RsaMGd3zX+y4jhQarEQqSHC2dfJn351PPt6C1fz9I1gtZsHkdRl8zRez78nL
5xKGPAchNIX36RFBG0OLvlOMQapfn3y9NE0xfZAHHw9UR5ocgvRB3lClMAwV
fYQGtFlVVZ7n+1GijsUDbfTQYnREp9mPci6ssyxLnZskiboaC9zdbrderyXX
E6MMzdbRKfeW9qMoAghpunuuWxSFb4kH7gMnHvKofZumsblPGTkqV0aZLS4Y
l4X+ES6xs+k0EOkKlhJ/jnGWZ63/f7V0e4qsMuT9+5NmaRMNut/NWnc9t+de
jGvKMiS7jHGbU3GtZ/5yWUbPLsK+52SZ0/zefRT23J57HlfNMmp2aXcqrvXM
t9GK4/gELVkTqVpw19tut5j70ZRdhGReqes6yzLSVG+YcNnldQyrL/7md/Mo
u9luNhvDTR6Wzldjiwu2PahY9ArNt8SV3pNcF2zc/T7JjC5Yke6M70fub2CF
96vG5VxWltnkSgLjkmg3ZQ8hx1SL/VtAzg9U6pJB\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{72, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->236587145]
}, Open  ]],

Cell["\<\
This generates a 4\[Cross]4 sparse diagonal matrix.\
\>", "Text",
 CellID->1407507248],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"diag", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"SparseArray", "[", "diag", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1441945431],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlmL1uwjAQgI+YtLSlVN36s/AaXTq2LH2ICFWCoWpFGdgyMjIy8giMjIyM
jIyMjIyM7p1/YhOFljQxICVSkotz8uc7+y6+vAXd1vtH0G03g/prJ/hqtZvf
9ZfPDjaxEgA08Hy6A5Q5SuJscI53++rTlY1GIy4OYHhhqFpNuPug9cMwtPQB
ykJcLBaTySRqJXWuD5ThMnPrmR7tfD6P04fDoT0mZ/TNZtPr9Qyd6VY5ADka
B/Rzwen3+4gi0Yvo3mw28/OhsqgVvIiJk4pTu80U/l6tVvlYfEVWkCBdSi+V
t82astlm/WVn12J2yxWOTpZBsYNLWklxUlOWVLSPlH4psZfn2HNxtXb5U98v
9urFVexV3NCtVVctAvdo3qb8Uj4g7z4DJx4JjzxNBJxqfB8vo9AM+UXJKIWg
0/dVfJWtPFY5pPVl2Qqgc8vByH9m7ixcO2LIxzf8PxFzqvkgjdZgMNhDy1RN
thbu+dbrtfanr/yZtKeRs7JcLsfjMYn2ThM3varGcVtPTKfThL09GqDG5JaO
ft6qZuKVHD3v/m6n55kZNDwP/ezKSqphPPSk6F9VFtt1KkuZQX6rTGMVsOLJ
Io3E25w4pkfJeeDJ6/tavJX/GaD0AxLciUo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{72, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->108805007]
}, Open  ]],

Cell[TextData[{
 "If you want to compute with floating point numbers it can be advantageous \
to use matrices that contain floating point entries; this is described in \
more detail under ",
 ButtonBox["Performance of Linear Algebra Computation: Matrix Contents",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraPerformance#478605279"],
 ". For ",
 Cell[BoxData[
  ButtonBox["IdentityMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IdentityMatrix"]], "InlineFormula"],
 " you can use the",
 " ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " option."
}], "Text",
 CellID->1324749455],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"IdentityMatrix", "[", 
    RowBox[{"4", ",", 
     RowBox[{"Sparse", "\[Rule]", "True"}], ",", 
     RowBox[{"WorkingPrecision", "\[Rule]", "MachinePrecision"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[6]:=",
 CellID->2101121736],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWL1uwjAQNjGp+gO0VRk68hp9gXbqC3SLoBIMVSvKkI2RMWPGPAIjIyMj
IyMjY8aM7vkPG+NCaGK1KkRKzj+X++7syydfnoNB9/UtGPTaQeupH3x0e+3P
1uN7H4ZwBSHUgfvhHkGbQIvdHUJA6k+fPnGSJIRdCMMDg2oVpAeyvqdfA+mD
xKJ/zowMh0PNHtdGeLFYTCaT9Sh9jcgLaTZqBWYbzPx61vAL4pzP56ZfcRzr
3m7Zvj1g9M7Ar7N+lmVhGCpcLEc5NPejVFy+DqPRCEBo01vjerPZzHeEB9sL
m7yJx9Z3tVq5jFNllo6rstAVLiwu/3S+waXrjMXbpvQklpZ/FauVF6N/vFpy
PfOykTl/mQvFni3F+Gf3W0X8ypevdq3rE+4J18pSNCubon+Ty8pf5YzfZ6l9
rOSCpX7GQ+5YKl++lv/1nHD/C67OUjo7SdY6HpaKoiiHlqrpdC04a6ZpSsQ+
HsJKZv+C2Vsul+PxmDb1EzAcxkWddUbK56Hds9yv6XRqqUQgdOGt6dch+Wof
bci92ai4zArTd4Srdl/herAH5cdJ88CDVWSRiXhUfFUneFs1usDlZaVLXIXA
ca+InX2kbDIt/m8FVb4AqkX4OQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//MatrixForm=",
 CellID->32827705]
}, Open  ]],

Cell["\<\
For a diagonal matrix you can make sure that the diagonals already are \
machine precision numbers.\
\>", "Text",
 CellID->1659939729],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"diag", "=", 
   RowBox[{"Range", "[", 
    RowBox[{"1.", ",", "5"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"SparseArray", "[", "diag", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[8]:=",
 CellID->646967126],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWbtuwjAUNU6C+oaWVurI17Tq0I+IUCWQWhVRBsTCyMiYkU9gzMjIyMjI
yMjI6PoZOyZAoiROhkRK7Gs79sl9HJvLpzvsfv24w17Hbb8P3H631/lrv/0O
cJNVAwCM8f3xCnAd4Rq9xwjhUn065GnN53NEL/BN5clkwmWLjrJpdbPZ+L5P
qkS2AGuHuLxPKV8JFOv1Wl/V8zwVi0O+Q1y4TlvJHHcF9TLsh8NhNBpJ7JZo
ZfDZtxzN8Zi69YWuE7QyrNZ0OsVLkyoM0MDVauUYRYGdBbtMGAW15263y1Mn
T4h5VwOFvVZFIT08TxSqThgabBYWbAWjaQpbcLkWicbhmmydKe1A0/K96Nn6
1ShNr3H5scFleKL/Jtaq0b6VBQdSb7LV3svvpMGcNB7qAuNRbzzPzSsqo1tN
YaKcIK1WOJ4WkhxVvHayRHOKR8m+CYHcsZqxZisrq5WfRy/JRfNomt7s+VQ/
1TUSvJt9lJYLDYlgEbmVTrJqTcemelmxabJROpsSvnEUhqnYNB52/bdWEo7I
PlbVcwypFns+fdbQRJ/KTaFJw58Vq56brawcl2TUbDaLMUrmTtVRnuft93vE
bZ2GRXX5ms6/3W4XiwWpqnkk3/d5BrWOwp5dNJ8y1MvlMiIjiBXFv0VHnVdE
PAj7hrKker7ZMYpG+pVEA7E1TemE+BnEdqBa4N8udWEbRHGU8+doWNrYPBq5
LkNzi5hPk73sHFPSvY7/zwJq/yLnXKQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{122, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]//MatrixForm=",
 CellID->383624115]
}, Open  ]],

Cell[TextData[{
 "Notice how all the entries of the matrix are machine precision numbers. \
This can help to improve the efficiency of your computations. The different \
types of matrices that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can work with are described in more detail under \"",
 ButtonBox["Matrix Types",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixTypes#1880892864"],
 "\"."
}], "Text",
 CellID->1622168646]
}, Open  ]],

Cell[CellGroupData[{

Cell["Normal", "Subsection",
 CellTags->{"t:123", "c:42"},
 CellID->1483534657],

Cell[TextData[{
 "To convert from a sparse array to the dense object that it represents, you \
can use ",
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1481838529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", " ", "=", " ", 
  RowBox[{"SparseArray", "[", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "3"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "2"}]}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->892302644],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->607326666]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "sp", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->313659504],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "3", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{268, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->71085636]
}, Open  ]],

Cell["\<\
Of course, it is very straightforward to make a sparse array that cannot be \
represented on your system. For example, the following sparse matrix only has \
two nonzero elements, but it has 2499999998 zero elements.\
\>", "Text",
 CellID->829449677],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "3"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"50000", ",", "50000"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1244368662],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"50000", ",", "50000"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{227, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->70012398]
}, Open  ]],

Cell["\<\
If this is converted to a dense matrix, an exception is thrown because it is \
not possible to represent this on typical computers.\
\>", "Text",
 CellID->932332691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "sp", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1674849125],

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "::", "\<\"ntb\"\>"}], ":", 
  " ", "\<\"Cannot convert the sparse array \
\\!\\(\\*TagBox[\\(SparseArray[\\(\\(Automatic, \\(\\(\[LeftSkeleton] 3 \
\[RightSkeleton]\\)\\)\\)\\)]\\), False, Rule[Editable, False]]\\) to an \
ordinary array because the \\!\\(2500000000\\) elements required exceeds the \
current size limit.\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[4]:=",
 CellID->635519652],

Cell[BoxData[
 RowBox[{"SystemException", "[", 
  RowBox[{"\<\"SparseArrayNormalLimit\"\>", ",", 
   RowBox[{"Normal", "[", 
    TagBox[
     RowBox[{"SparseArray", "[", 
      RowBox[{
       InterpretationBox[
        RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
         "\[InvisibleSpace]", "\<\">\"\>"}],
        SequenceForm["<", 2, ">"],
        Editable->False], ",", 
       RowBox[{"{", 
        RowBox[{"50000", ",", "50000"}], "}"}]}], "]"}],
     False,
     Editable->False], "]"}]}], "]"}]], "Output",
 ImageSize->{567, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->310793818]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ArrayRules", "Subsection",
 CellTags->{"t:124", "c:43"},
 CellID->1554122061],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " can accept a list of rules to form a sparse array. These rules hold the \
indices and values of nonzero elements. In the following example, the element \
at position {2,1} has the value 5. ",
 Cell[BoxData[
  ButtonBox["ArrayRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayRules"]], "InlineFormula"],
 " generates the rules for a sparse array."
}], "Text",
 CellID->285880766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", " ", "=", " ", 
  RowBox[{"SparseArray", "[", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "5"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "11"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->877115823],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1357884153]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArrayRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayRules"]], "InlineFormula"],
 " returns the rules that represent the sparse array. It returns a rule of \
blank patterns {_,_} to show the default value."
}], "Text",
 CellID->650242802],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayRules", "[", " ", "sp", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->86493631],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "11"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "5"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"_", ",", "_"}], "}"}], "\[Rule]", "0"}]}], "}"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1999510845]
}, Open  ]],

Cell["\<\
When a scalar is added to the sparse array, the default value is changed. For \
example, here the default value is 5.\
\>", "Text",
 CellID->1954663659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayRules", "[", 
  RowBox[{"sp", "+", "5"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1974768654],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "16"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "10"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"_", ",", "_"}], "}"}], "\[Rule]", "5"}]}], "}"}]], "Output",
 ImageSize->{241, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->577003393]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArrayRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayRules"]], "InlineFormula"],
 " can take a second argument, which is the default value shown on output. \
Here, a default rule with value 5 is used. Because there is only one element \
with this value, the list of rules is much longer."
}], "Text",
 CellID->1807359946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayRules", "[", " ", 
  RowBox[{"sp", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->142425607],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "11"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"_", ",", "_"}], "}"}], "\[Rule]", "5"}]}], "}"}]], "Output",
 ImageSize->{374, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1450394091]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArrayRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayRules"]], "InlineFormula"],
 " is a useful way to get information about a sparse array such as the \
non-default elements or the default value. This example shows how to get the \
indices of the non-default elements."
}], "Text",
 CellID->686610340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"Map", "[", " ", 
    RowBox[{"First", ",", " ", 
     RowBox[{"ArrayRules", "[", " ", "sp", "]"}]}], "]"}], ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1430349049],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->944522025]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Structural Operations", "Section",
 CellTags->{"t:125", "c:44"},
 CellID->382555551],

Cell["\<\
Structural operations on sparse arrays are all equivalent to the operations \
on dense matrices.\
\>", "Text",
 CellID->45106539],

Cell[CellGroupData[{

Cell["Getting Pieces of Matrices", "Subsection",
 CellTags->{"t:126", "c:45"},
 CellID->43873582],

Cell[TextData[{
 "Extracting elements, rows, and columns of a sparse matrix is quite \
straightforward with the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 ". Typically ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " is entered with ",
 StyleBox["[[ ]]", "MR"],
 " notation."
}], "Text",
 CellID->796401753],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["i", "TI"], ",", 
     StyleBox["j", "TI"], "]", "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      RowBox[{"i", ",", "j"}]], "InlineFormula"],
     Cell[BoxData[
      SuperscriptBox["\[Null]", "th"]], "InlineFormula"],
     " entry "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["i", "TI"], "]", "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData["i"], "InlineFormula"],
     Cell[BoxData[
      SuperscriptBox["\[Null]", "th"]], "InlineFormula"],
     " row "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["i", "TI"], ";;", 
     StyleBox["i", "TI"], "]", "]"}], Cell[TextData[{
     " rows ",
     StyleBox["i", "TI"],
     " through ",
     StyleBox["j", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], ",", 
     StyleBox["i", "TI"], "]", "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData["i"], "InlineFormula"],
     Cell[BoxData[
      SuperscriptBox["\[Null]", "th"]], "InlineFormula"],
     " column "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], ",", 
     StyleBox["i", "TI"], ";;", 
     StyleBox["j", "TI"], "]", "]"}], Cell[TextData[{
     " columns ",
     StyleBox["i", "TI"],
     " through ",
     StyleBox["j", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", "{", 
     SubscriptBox[
      StyleBox["i", "TI"], "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["r", "TI"]], "}", ",", "{", 
     SubscriptBox[
      StyleBox["j", "TI"], "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox[
      StyleBox["j", "TI"], 
      StyleBox["s", "TI"]], "}", "]", "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      RowBox[{"r", "\[Cross]", "s"}]], "InlineFormula"],
     " submatrix with elements having row indices ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " and column indices ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Tr",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tr"], "[", 
     StyleBox["m", "TI"], ",", 
     ButtonBox["List",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/List"], "]"}], Cell[TextData[{
     "list of the diagonal elements of ",
     StyleBox["m", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.2",
 CellID->785100947],

Cell["Ways to get pieces of matrices. ", "Caption",
 CellTags->"S3.7.2",
 CellID->135206022],

Cell["Here is a sample sparse matrix.", "Text",
 CellID->369913228],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "3"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "4"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "5"}], "}"}], "\[Rule]", "5"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "1"}], "}"}], "\[Rule]", "5"}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "InputOnly",
 CellLabel->"In[1]:=",
 CellID->166464931],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWDtvwjAQNnnxLHNHfk0rBmbmCFWCoWpFGdgYGRkz8hMYMzIyMjIyMjIy
uudXbNwUHIETkBIpsc9yfJ/v810u1wsnw4/PcDIahJ33cfg9HA1+Om9fYxhy
KwihPtzdVwR9DD169zGGVn365Okul0tML9Sl8mw247JLZ3m0u9vt4jgmXSK7
sGDrSlsVq2+3W321KIpUHT7BJy7oo4al0YCqPJ1O0+lUYnLFKIOFalRO3mWy
BTTMQvP5HFSTrpOgcTabTT1XFEAuUHyOgvJ0OBzoa5ix2rSKQp4yFYU8kb5m
E7togBbmHAWjqQku+FDlXzQeZ+iSX9a199JX65WzFLuaxDszu9L4l1u8qxWK
qY3P/SMo0SSjwkuLPTVNzSbPiMbEPz1jX3jUKFR83GvztoFtxz3dU7NkPrdE
vDS9gdhhQfqLi/+EX4e3yJOo8kOg26OhyHlaIn3FlnU0aR7ooL8ZXpnRZZtV
ZnQlphLTs2O6rxc/aqzKMmuxWBjMkvU+dVYURcfjEXOufeUr09RkYVfG0n6/
X61WpKvWSOI45lU/9peVMGztzLCKzXq9TqliwcY4RjM0+n9IlrpOVTBxVtPT
q5565eh6hpHVdgyH5F7icIAZMzu8aLOy5MFEgwNWpzvn+5X794z035IPB5pG
V8HBSprmOO5Vd5Z6GRpyrhxu50sRjPLAa/ao8guIhqgi\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{87, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->539357866]
}, Open  ]],

Cell["This gets the third element in the first row.", "Text",
 CellID->1776279903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1766152774],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2027941]
}, Open  ]],

Cell["\<\
This gets the third row; the row is returned as a sparse vector.\
\>", "Text",
 CellID->890942363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "[", 
  RowBox[{"[", "3", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1812308057],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", "5", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->25443016]
}, Open  ]],

Cell[TextData[{
 "It can also obtain a column by using ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " to specify all rows; the column is returned as a sparse vector."
}], "Text",
 CellID->540777722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->700379550],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", "5", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->285952785]
}, Open  ]],

Cell["\<\
Negative indices are used to refer to the end of the matrix. The following \
gets the last element of the last row.\
\>", "Text",
 CellID->1863384678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "[", 
  RowBox[{"[", 
   RowBox[{
    RowBox[{"-", "1"}], ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1152258945],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->253498241]
}, Open  ]],

Cell[TextData[{
 "You can get ranges of a matrix using ",
 StyleBox[";;", "MR"],
 ". This gets the second through the fourth rows."
}], "Text",
 CellID->507977834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "[", 
  RowBox[{"[", 
   RowBox[{"2", ";;", "4"}], "]"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->432468603],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->98525889]
}, Open  ]],

Cell["This gets the second through the fourth columns.", "Text",
 CellID->148521699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", 
    RowBox[{"2", ";;", "4"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->368642283],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->928115802]
}, Open  ]],

Cell["You can also give a step. This gets every other column.", "Text",
 CellID->299733056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", 
    RowBox[{"1", ";;", 
     RowBox[{"-", "1"}], ";;", "2"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->31191635],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "5", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 5, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->252733338]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["Tr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tr"]], "InlineFormula"],
 " works on the diagonal elements of a matrix. The one argument form adds \
them up."
}], "Text",
 CellID->2133478281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", "sp", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->835014808],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->288244911]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tr"]], "InlineFormula"],
 " can also take a function as its second argument, which will apply to the \
diagonal elements. If ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 " is used, this returns the diagonal elements."
}], "Text",
 CellID->1956595192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", 
  RowBox[{"sp", ",", "List"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->78305433],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "4"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->1819420467]
}, Open  ]],

Cell[CellGroupData[{

Cell["Getting Multiple Pieces", "Subsubsection",
 CellTags->"c:46",
 CellID->980139236],

Cell["\<\
It is possible to extract multiple elements by using indices in lists. This \
will be demonstrated with the following sample matrix.\
\>", "Text",
 CellID->2000566962],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "3"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "4"}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "InputOnly",
 CellLabel->"In[1]:=",
 CellID->377469255],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "2"},
     {"0", "0", "0"},
     {"0", "3", "4"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 2, 4}, {{1}, {3}, {2}, {3}}}, {1, 2, 3, 4}}]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->459075547]
}, Open  ]],

Cell["\<\
The following gets the first and third elements of the third row.\
\>", "Text",
 CellID->1921458405],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "[", 
  RowBox[{"[", 
   RowBox[{"3", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->92329249],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "1", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 1, ">"],
     Editable->False], ",", 
    RowBox[{"{", "2", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1294494809]
}, Open  ]],

Cell["The following gets the first and third rows.", "Text",
 CellID->417427106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "[", 
  RowBox[{"[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2015779440],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->503033008]
}, Open  ]],

Cell["\<\
The following gets the first and third elements of the first and second rows.\
\
\>", "Text",
 CellID->1980130864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "[", 
  RowBox[{"[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->505353689],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->181627138]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting Pieces of Matrices", "Subsection",
 CellTags->{"t:127", "c:47"},
 CellID->1033045979],

Cell[TextData[{
 "Setting elements, rows, and columns so that a sparse matrix is updated is \
quite straightforward by using the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " on the left-hand side of an assignment."
}], "Text",
 CellID->2145966705],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["m", "TI"], 
     StyleBox["=", "MR"], "{", "{", 
     SubscriptBox[
      StyleBox["a", "TI"], "11"], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], "12"], ",", "\[Ellipsis]", "}", ",", "{", 
     SubscriptBox[
      StyleBox["a", "TI"], "21"], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], "22"], ",", "\[Ellipsis]", "}", ",", "\[Ellipsis]",
      "}"}], Cell[TextData[{
     "assign ",
     StyleBox["m", "TI"],
     " to be a matrix "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["i", "TI"], ",", 
     StyleBox["j", "TI"], "]", "]", 
     StyleBox["=", "MR"], 
     StyleBox["v", "TI"]}], Cell[TextData[{
     "reset element ",
     Cell[BoxData["{"], "InlineFormula"],
     StyleBox["i", "TI"],
     StyleBox[",", "MR"],
     " ",
     StyleBox["j", "TI"],
     Cell[BoxData["}"], "InlineFormula"],
     " to be ",
     StyleBox["v", "TI"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["i", "TI"], "]", "]", 
     StyleBox["=", "MR"], 
     StyleBox["v", "TI"]}], Cell[TextData[{
     "reset all elements in row ",
     StyleBox["i", "TI"],
     " to be ",
     StyleBox["v", "TI"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["i", "TI"], "]", "]", 
     StyleBox["=", "MR"], "{", 
     SubscriptBox[
      StyleBox["v", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["v", "TI"], "2"], ",", "\[Ellipsis]", "}"}], Cell[TextData[{
     "reset elements in row ",
     StyleBox["i", "TI"],
     " to be ",
     Cell[BoxData["{"], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], "1"]], "InlineFormula"],
     StyleBox[",", "MR"],
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], "2"]], "InlineFormula"],
     StyleBox[",", "MR"],
     " \[Ellipsis] ",
     Cell[BoxData["}"], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], ",", 
     StyleBox["j", "TI"], "]", "]", 
     StyleBox["=", "MR"], 
     StyleBox["v", "TI"]}], Cell[TextData[{
     "reset all elements in column ",
     StyleBox["j", "TI"],
     " to be ",
     StyleBox["v", "TI"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], ",", 
     StyleBox["j", "TI"], "]", "]", 
     StyleBox["=", "MR"], "{", 
     SubscriptBox[
      StyleBox["v", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["v", "TI"], "2"], ",", "\[Ellipsis]", "}"}], Cell[TextData[{
     "reset elements in column ",
     StyleBox["j", "TI"],
     " to be ",
     Cell[BoxData["{"], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], "1"]], "InlineFormula"],
     StyleBox[",", "MR"],
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], "2"]], "InlineFormula"],
     StyleBox[",", "MR"],
     " \[Ellipsis] ",
     Cell[BoxData["}"], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.2",
 CellID->274559570],

Cell["Resetting parts of matrices. ", "Caption",
 CellTags->"S3.7.2",
 CellID->1727819234],

Cell["Here is a sample sparse matrix.", "Text",
 CellID->1183991104],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "3"}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->755011826],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVj1vgzAQNRA3tEk7d8yeoXP+QDv1R6CoUjJUrdIMbIyMjIz8BEZGRkZG
RkZGRkZ6/gAT142MkkodQAKfrfN753fG51fnuHt7d477rbN6OTifu/32a/X8
cYAhy0AIbeBdPyKwW7Dou2lbaIdfTL5WFEUtfdCa9j3P432Les2oWRRFkiTE
JH0LAJdSO+/Q8jyXZ4dhOMTEJJ7uARvdjRi9oTBN07iuK3isbpRRMd4fcx+o
Vz+KbKUXW4nv+wBHTLNnMLMswxcjg5Ag5yky1aiqqt9jJzqb0C7OIIssDZFF
Ri9XBSRhG2YUw5j82p0afMhQ8pAsqHbhreSnnv00eV1Fx2tle+KZeP5+t/7X
f3CMVxAEGl6ipg+94Eyt67rl+cK8lli8xf0ZX5ZlHMfEHJ7xUFh4ZWcVWNSL
MXlmDGmaKiogBMd59RgWkpfdKXRSt+UbCNbCXkpec0lngW2CKnrx3kteJBIT
Vkwj5HGJOGdamHLtVt63ODa7Xuhjn7t/CSzGQHJh8jUO/0y6Zn7fRMY3l7I1
Bg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->416052368]
}, Open  ]],

Cell[TextData[{
 "To update parts of a matrix you can use ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " on the left-hand side of an assignment. This sets the third element of the \
third row."
}], "Text",
 CellID->1318497179],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sp", "[", 
    RowBox[{"[", 
     RowBox[{"3", ",", "3"}], "]"}], "]"}], "=", "x"}], ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->98334060],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVi9zwjAUD2kLdHSzQ+IR03yBTe1D9LjdgdiNY4g6JLKysh+hshKJRFYi
kZWV3Uvy2oQQ7tLNTJC79r28vvzevzQv7+Fm8fEZbpbzcPK2DleL5fx78vq1
BpHTI4TM4JmOCfA1cPyZ1TVQ9e2xt5Omac0HmfL5drvFucO1XM4WRZHnOWPZ
3AHAAOkDUAqUIu03qMfjUUdJkkTF9phfzSCIdUPqtlJgBhyiqqooiqQNp5EK
M8LmFdoT15JoPvrtc/lutwMAxtIWkx4OB+8XWJAwSNslFs/B+Xy+7V+AGKOr
qIdaJVRUWTW7qAda1dqMiu3QCdtctecmWhT1jIgsr+puGmvfzate7lo38tdQ
32p1l3qapcO7nbsdazt/263/9R/sohXHsYWW7MmqFpylZVnWWC8Pe4SD1GtP
8dPplGUZY9VTHJoGdmTRoWUv6FJnYWG/3xs6GziHdu0sjDStYZOhiw6s3xw8
K+xA0xpoeZbYFLJi5++jpsU8oRAx9xD9kn66Vph6XzbekxBbXBvssc3SvoYl
LLBaUIxR/TN5zHhfJL0fyoALMA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->212534355]
}, Open  ]],

Cell["This sets the second row of the matrix.", "Text",
 CellID->1613914272],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sp", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->191224247],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVq1ywkAQPhKOn4a2skg8opoXaFUfIsN0BkSHDkXgkEgkkkeIjEQikUgk
EhmZ7t3t5Y7laI+0oqKZSW53c/n2/zYv8WTw+hZPhv248zyO3wfD/kfnaTQG
UVhhjPXg7rYZ0DlQ8u7lOaz2k4tnuFqtcnmxruRnsxnyodxVleRut0vTVJCC
DwGwhesNrAGsAa41jbrdbinKcrm0sbmwS18MsS5Iq4UUiLqEyLJsOp0aHaGW
KjVK5xnandxl0Jpod1PK5/M5AAgyKDCDzWbDS2BBwCBsp1gyBofD4bJ9LcSI
zrxukEzYqCZrfl7XSdaKiKpyuArbnbUH7S2KKk5EEVe7mtrkvfurx/9dKBUZ
4ZgDjlUTFhX43deqV01VfNF/Z9JGKQ0R4e8JXyuF2iI8rfZyqLcO24PSsaU2
UZvL2fj7GePopfDe7kw/r/9qn1yza7FYeOwyc9PeBefd8XjMrc7UHRkhr07a
/X6fJIkg7ZMWDnacmj/Js9KwXq8d0weMQ71+Gmi/NnSETqYkne7cC5t2QJ3E
2WAHEBU/e2nPymoGj6WFaJexs+qFSTvX+S+D2Gq0+2O7pTWCpTTo84d2pvQZ
/+lY5RPGqdtR\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->340908634]
}, Open  ]],

Cell["Here, the second column is set.", "Text",
 CellID->1051671045],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sp", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "3"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[7]:=",
 CellID->1644838505],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVitzwkAQPnIc4dV2pgMtEl9ZUY1pVX9EhukMiE47FBGHRCKR/AQkEolE
IpFIJDLdu9vLheUghEFUNDPJPnL5dm8ft3kP+p2Pz6DfbQfNt17w3em2f5qv
Xz1Q8RxjrAX3U4MBHwGn7lYUAU0+hXzyyWQSqYs9K3kwGKDM1aq8Yler1Ww2
k6yUOQDWkJaBekA9pAWDulwuKcp4PE5iC+mXuYBn905tWZmNtcD4CmK324Vh
aG1wo9VmtE0nmogxLGoJ/S8p/XA4BCDJejG2t1gshBPz4SQWBA7Ct4+lYrHZ
bI77WUOMysHuiyQjSVSbPTcq9dQn2Ysjq8siE7Y7e49mt6jKORFlXJNV1SDv
3V+9/K9CrcyIwBwIrBoeV2Da17pnbVWc6MMDbfEiC6YL80R/R+TCReg1It9e
BbVOZBlj7+IY006sXsXH62dO4C7l7qWhapSlsv5qv2RZNRqNzlhl52hyFZx7
2+02cnTo/hxar9fT6VSyyRMXDnicomkV7s6wxp7P5475A26hxWO9KYi+QuSi
ic7epKSTnqJQz2nd+yS6FtWDWKTF4YbIqnphn8or9MX6Rk+ftHPD+ReDqHqY
n4PqzlWBoGhsc8bUkcr9caTmP47lfgG7cNO6\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{65, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//MatrixForm=",
 CellID->366257686]
}, Open  ]],

Cell[TextData[{
 "You can also use the range syntax for setting pieces of the matrix. This \
sets every element in every other row to be ",
 StyleBox["z", "MR"],
 "."
}], "Text",
 CellID->515100245],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sp", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", 
      RowBox[{"1", ";;", 
       RowBox[{"-", "1"}], ";;", "2"}]}], "]"}], "]"}], "=", "z"}], 
  ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[9]:=",
 CellID->249228003],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVrFuwjAQNUmAhHaipUVqK6GuHTt0ZmmnfkSEKsFQtaIMbIyMjBnzCYyM
jIyMjIwZMzK6Z/uCk4tDUnVsIyW+u9y9s895vrz6k+Hbuz8ZDfzey9j/HI4G
X73njzGY7BpjrA/3Q5eBzEGSd59zGNPPunjaYRhyebFHqc9mM9Rt6eVIcbfb
rVarxFoHwAsYbRjPUG8kaNvtlkYHQZDGFO48uUBmbaO1ZbSqPIfDYTqd6jx2
YlWpcG3H2OMsm8TuEd2V+nw+ByghWkd0a7PZ0OgroreIrvyhcFC+LJqsSRRF
QpQ1cnQUYx2RD2ubfeOS3Ugj6p1zcLV0fm6mCrBEtfkFKDfG+l+THa0ZY2+5
+jq6xG72fvr3Qmuyc20cWzi6laN/x65qeYrY5RD7OdG9SugNEnVZgvqD2mS4
RNnh5TyqzbeMbdXmd4ptZbF/j22LxaKCl+5taS84u+I45ifYps7H/X6/XC6F
mD4f4eDFDmdmG/1azTxTGdbrtaEzwOQwbxHPTPY8I6BGmS5GezFFKeNZk9RY
o1pQEXMXy1Ui4yEQLVirjMX56PlZuFpTRfUfB/m3QBTVWnnCq1R0h7xXUfdc
ddw7qan/I1b7BgYPehQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{65, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]//MatrixForm=",
 CellID->78820798]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting Multiple Pieces", "Subsubsection",
 CellTags->"c:48",
 CellID->1718872299],

Cell["\<\
It is possible to set multiple elements by using indices in lists. This will \
be demonstrated with the following sample matrix.\
\>", "Text",
 CellID->1136709849],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "3"}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->667908431],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "2"},
     {"0", "0", "0"},
     {"0", "3", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 2, 3}, {{1}, {3}, {2}}}, {1, 2, 3}}]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->639976948]
}, Open  ]],

Cell["\<\
The following sets the first and third elements of the second row.\
\>", "Text",
 CellID->1494460860],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sp", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], "=", "x"}], 
  ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->434938708],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "2"},
     {"x", "0", "x"},
     {"0", "3", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 4, 5}, {{1}, {3}, {1}, {3}, {2}}}, {
     1, 2, $CellContext`x, $CellContext`x, 3}}]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->2128014615]
}, Open  ]],

Cell["\<\
If the right-hand side of the assignment is a list that matches the number of \
elements being assigned, the assignment is done element by element. Thus, the \
following gives two different values for the first and third elements of the \
second row.\
\>", "Text",
 CellID->1348977167],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sp", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->1274384390],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "2"},
     {"x", "0", "y"},
     {"0", "3", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 4, 5}, {{1}, {3}, {1}, {3}, {2}}}, {
     1, 2, $CellContext`x, $CellContext`y, 3}}]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->1724031199]
}, Open  ]],

Cell["The following sets the second and third rows.", "Text",
 CellID->1942996269],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sp", "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[7]:=",
 CellID->1301956801],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "2"},
     {"1", "2", "3"},
     {"1", "2", "3"}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//MatrixForm=",
 CellID->1277075124]
}, Open  ]],

Cell["\<\
The following gives two different values for the second and third rows.\
\>", "Text",
 CellID->1850040950],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sp", "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[9]:=",
 CellID->222521737],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "2"},
     {"1", "2", "3"},
     {
      RowBox[{"-", "1"}], 
      RowBox[{"-", "2"}], 
      RowBox[{"-", "3"}]}
    }], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{85, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]//MatrixForm=",
 CellID->1153804332]
}, Open  ]],

Cell["\<\
The following sets the first and third elements of the second and third rows.\
\
\>", "Text",
 CellID->212075514],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "3"}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"sp", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], "=", "x"}], 
  ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[11]:=",
 CellID->1677793425],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "2"},
     {"x", "0", "x"},
     {"x", "3", "x"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 4, 7}, {{1}, {3}, {1}, {3}, {1}, {3}, {2}}}, {
     1, 2, $CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x, 
      3}}]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]//MatrixForm=",
 CellID->66325218]
}, Open  ]],

Cell["\<\
The following sets the first and third elements of the second and third rows \
with different values.\
\>", "Text",
 CellID->183926133],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sp", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[14]:=",
 CellID->1017549298],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "2"},
     {"a", "0", "b"},
     {"c", "3", "d"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 4, 7}, {{1}, {3}, {1}, {3}, {1}, {3}, {2}}}, {
     1, 2, $CellContext`a, $CellContext`b, $CellContext`c, $CellContext`d, 
      3}}]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]//MatrixForm=",
 CellID->1538770425]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Extracting Submatrices", "Subsection",
 CellTags->{"t:128", "c:49"},
 CellID->2116455801],

Cell["The range syntax is useful to extract a submatrix.", "Text",
 CellID->87061150],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["m", "TI"], "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], "0"], ";;", 
        SubscriptBox[
         StyleBox["i", "TI"], "1"]}], ",", 
       RowBox[{
        StyleBox[
         SubscriptBox[
          StyleBox["j", "TI"], "0"], "TI"], ";;", 
        SubscriptBox[
         StyleBox["j", "TI"], "1"]}]}], "]"}], "]"}], Cell[TextData[{
     "extract the submatrix with rows ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], "0"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], "1"]], "InlineFormula"],
     " and columns ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], "0"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], "1"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", 
     RowBox[{"[", 
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], "0"], ";;", 
       SubscriptBox[
        StyleBox["i", "TI"], "1"]}], "]"}], "]"}], Cell[TextData[{
     "extract the submatrix with rows ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], "0"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], "1"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", 
       SubscriptBox[
        StyleBox["j", "TI"], "0"], ";;", 
       SubscriptBox[
        StyleBox["j", "TI"], "1"]}], "]"}], "]"}], Cell[TextData[{
     "extract the submatrix with columns ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], "0"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], "1"]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.2",
 CellID->298293044],

Cell["Extracting submatrices. ", "Caption",
 CellTags->"S3.7.2",
 CellID->915154724],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "3"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "5"}], "}"}], "\[Rule]", "4"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "4"}], "}"}], "\[Rule]", "2"}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->727566454],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmL1uwjAQgI0DAQpl7sjTtGJgZo5QJRiqVi0DGyMjY0YegTEjIyMjIyMj
I6N7thNsjjQ1NSFpm0iJf3Q5f7nzXZLreqPB84s3Gva99tO79zYY9j/aj6/v
MOWUCCE9ODsPBPoMeuLsMQatfq3wqzOfz5k4SEeMJ5NJOHaEVFl0N5tNEAS8
y8cOKGyitgFtJWz5uBppX6/XWJvv+/oa/DYWHdAndynNumLJw+EwHo8VkxPN
SizJaLVOQ2g8zsrxmZS00HQ6haV5lx5p6Gq1qlhTNBFFvJSkAOeCi08phJ92
u911bHKPaOoJNGq36TRqZ9rTtBBNLYEG3CODJDWaS2YFqRZBpVgmvnviohS3
dXRfvLZuIWVo1xbTs9932tLaOXh3u5nS8Fk3c5skRVNWTOK9UFZ+yppHf2Nk
b52f0ZhEKDXWltc8lL/Md9kb5fdEudmXwv+k4T6nUR4rbJKDPVx896UjxX2t
/93+vewnqwEqiuxj2obGRTTZ2qaKaOL/XW9FU0M09vmuyIJJ2vKaky6Rms1m
BlKqFqhL+b6/3+8ZO8+CuOYX2VV6abvdLhYL3tXrJkEQhBXBW8W4jN7lchlT
4YIHCxnNaMwqe0kc4ImTeh+uiOI8bFPbS+JQvlccFDxjZgezat7XVVgKVhdP
Hj6vev6y0fo233wuWtHROGS505zjWjVpta6k4fuKhnZOymDCD2E9n5Q+AXAd
uhA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{87, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->806753369]
}, Open  ]],

Cell[TextData[{
 "This extracts the submatrix from ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["m", 
    RowBox[{"2", ",", "1"}]], TraditionalForm]]],
 " to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["m", 
    RowBox[{"3", ",", "2"}]], TraditionalForm]]],
 "."
}], "Text",
 CellID->185385192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"sp", "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"2", ";;", "3"}], ",", 
     RowBox[{"1", ";;", "2"}]}], "]"}], "]"}], "//", "MatrixForm"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->1917633794],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwaAGxjAQDkP0fyAJj
rf//gTSEZAWRzCBRMGCQRuOzgFWxYBEFcXmgNDuaPDNWXWBRVjgfrIaBgQur
KBsFJvJh8wOGWczYVBE0Cz28mEgwCxRaTECagwIzqOke7CGPHpfYTQTZi5wC
iPOT/KgqpBgBBT03SeFHm3hE5nNTYBZ6nqXEXeiqOEkwCz2/o6viwGoWJSUO
JWUYcWUpceU0pExnYAQAVUs/Mg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{42, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->713171915]
}, Open  ]],

Cell["This extracts the submatrix of rows 1 to 3.", "Text",
 CellID->1570558077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"sp", "[", 
   RowBox[{"[", 
    RowBox[{"1", ";;", "3"}], "]"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1648094862],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVztzgkAQPkFQo0md0j7/I5kU1taMkxktMskYCzpKSkpKfoIlJaUlJSUl
JaXlZe+Bd54YYc5HCpmBW26W2+/2291bJs5q/vHprBYzZ/y2dL7ni9nP+PVr
CVNmByE0hfvlGYGMQaL3FGMY5adFnmYURZhe6J2+e57H302q1aVilmVxHBOR
vJuw4OjE2KtWT9NUXS0MQ9mGRfBVF8jo4UKzNjW53W5d1xWYzGqWwWIYD759
olq7WdTXRsM85Ps+mCaisUNjbDYb66oogFygeB8F5akoiuM+IVwbMA7PhEJE
mYxCROR1mQFaWHK0QnOp2KW7kjKnU4uJRE2T7Bwo39WvNrlr8VnCtcUjXd+v
t4icU5jYaSCySD+nddDYCprb+qanoBncFE1fQaNf73TQ/NdYvldBWSsIggZa
oheUteDMKcsS48MqOMT1VZGxlOf5er0monx+wgHPO8Jr5TjL3iRJajoc2BjH
2AzNUNFqUyV7FRN7/Z7aEat1uH6tkYbvGA7BvcBhADPN/PCoaLWpiMSCAV6n
O+f7FfvvNrKv0/PZikVTwsHa3eY4zvVPIuwyNCSuDO7nvyoY5YH/z6HOL8m2
AIQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{87, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->18966267]
}, Open  ]],

Cell["This extracts the submatrix of columns 2 to 4.", "Text",
 CellID->1712826094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"sp", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", 
     RowBox[{"2", ";;", "4"}]}], "]"}], "]"}], "//", "MatrixForm"}]], "Input",\

 CellLabel->"In[5]:=",
 CellID->449873823],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWL1uwjAQdpKGn4Z27sjeoTMv0KpDHyJClWCoWlEGNkZGRkYegZExY0ZG
xowZM2ZMz2cbG+taJSqVGsmRgu9O5/suZ5/M55d4Pnl9i+fTcTx8msUfk+n4
c/j4PgNT4DHGRvA+3zGQK5DwHVUVjOZvyH+D7XZb4cPuUV8ul1IP0OsKxePx
uN/vucj1AAIO5BjBGMLYUdEOh4M9e7PZmDG5e6UekNl1A6vAKctysVhonEBZ
BZTArRkxwrknK+uhvlqtIBwX/ROCn6Zp2CDywIrcRR0KCeU8j4w1yvO8ae43
FkLHWi0TQa9sE4RbCyFUlRYb5wIItLWnqiJNHonDszF3oxr7lh89+8F5XaSO
l1pth+Nw/n63/tcedF1P4wgv63xuGQI/l331X6NlubuubpdXO7ra4TicynU9
6Ov1uoaX5ummF/CjoijMOio+HkldrEKWZbvdjosmXwOSKNn671dbcNskSQhu
CylKdBrHZuD0KdlV1Trj5fVuGGwm/tM36MprBB/qROduM/A+6YXnP9QAY0gO
rXP2yTk286ZP9g71/RJBXCh8j9D83kVHFDhql9ndi1WR90zM+wJQGOEK\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->706375854]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 StyleBox["n", "MR"],
 "egative indices to count from the end."
}], "Text",
 CellID->1333437598],

Cell["\<\
This returns the matrix with the first and last columns dropped.\
\>", "Text",
 CellID->2093853141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"sp", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", 
     RowBox[{"2", ";;", 
      RowBox[{"-", "2"}]}]}], "]"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->575217398],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWL1uwjAQdpKGn4Z27sjeoTMv0KpDHyJClWCoWlEGNkZGRkYegZExY0ZG
xowZM2ZMz2cbG+taJSqVGsmRgu9O5/suZ5/M55d4Pnl9i+fTcTx8msUfk+n4
c/j4PgNT4DHGRvA+3zGQK5DwHVUVjOZvyH+D7XZb4cPuUV8ul1IP0OsKxePx
uN/vucj1AAIO5BjBGMLYUdEOh4M9e7PZmDG5e6UekNl1A6vAKctysVhonEBZ
BZTArRkxwrknK+uhvlqtIBwX/ROCn6Zp2CDywIrcRR0KCeU8j4w1yvO8ae43
FkLHWi0TQa9sE4RbCyFUlRYb5wIItLWnqiJNHonDszF3oxr7lh89+8F5XaSO
l1pth+Nw/n63/tcedF1P4wgv63xuGQI/l331X6NlubuubpdXO7ra4TicynU9
6Ov1uoaX5ummF/CjoijMOio+HkldrEKWZbvdjosmXwOSKNn671dbcNskSQhu
CylKdBrHZuD0KdlV1Trj5fVuGGwm/tM36MprBB/qROduM/A+6YXnP9QAY0gO
rXP2yTk286ZP9g71/RJBXCh8j9D83kVHFDhql9ndi1WR90zM+wJQGOEK\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->715478780]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Deleting Rows and Columns", "Subsection",
 CellTags->{"t:180", "c:50"},
 CellID->503342974],

Cell[TextData[{
 "If you want to delete rows or columns, you can use ",
 Cell[BoxData[
  ButtonBox["Drop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Drop"]], "InlineFormula"],
 "."
}], "Text",
 CellID->747278485],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Drop",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Drop"], "[", 
     StyleBox["m", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["i", "TI"], "0"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], "1"], "}", "]"}], Cell[TextData[{
     "delete",
     " ",
     "rows",
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], "0"]], "InlineFormula"],
     " ",
     "through",
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], "1"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Drop",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Drop"], "[", 
     StyleBox["m", "TI"], ",", "{", "}", ",", "{", 
     SubscriptBox[
      StyleBox["j", "TI"], "0"], ",", 
     SubscriptBox[
      StyleBox["j", "TI"], "1"], "}", "]"}], Cell[TextData[{
     "delete",
     " ",
     "columns",
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], "0"]], "InlineFormula"],
     " ",
     "through",
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], "1"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Drop",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Drop"], "[", 
     StyleBox["m", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["i", "TI"], "0"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["j", "TI"], "0"], ",", 
     SubscriptBox[
      StyleBox["j", "TI"], "1"], "}", "]"}], Cell[TextData[{
     "delete",
     " ",
     "rows",
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], "0"]], "InlineFormula"],
     " ",
     "through",
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], "1"]], "InlineFormula"],
     " ",
     "and",
     " ",
     "columns",
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], "0"]], "InlineFormula"],
     " ",
     "through",
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], "1"]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.2",
 CellID->1025129739],

Cell["Deleting rows and columns. ", "Caption",
 CellTags->"S3.7.2",
 CellID->94223492],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "3"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "5"}], "}"}], "\[Rule]", "4"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "4"}], "}"}], "\[Rule]", "2"}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->918782205],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "2", "0", "0"},
     {"2", "0", "0", "0", "0"},
     {"0", "3", "0", "0", "0"},
     {"0", "0", "0", "0", "4"},
     {"0", "0", "0", "2", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {5, 5}, 0, {
    1, {{0, 2, 3, 4, 5, 6}, {{1}, {3}, {1}, {2}, {5}, {4}}}, {1, 2, 2, 3, 4, 
     2}}]]]], "Output",
 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->1565097505]
}, Open  ]],

Cell["This drops rows 2 through 4.", "Text",
 CellID->66574432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Drop", "[", 
   RowBox[{"sp", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->77498537],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "2", "0", "0"},
     {"0", "0", "0", "2", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {2, 5}, 0, {
    1, {{0, 2, 3}, {{1}, {3}, {4}}}, {1, 2, 2}}]]]], "Output",
 ImageSize->{91, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->1142821277]
}, Open  ]],

Cell["This drops columns 2 through 4.", "Text",
 CellID->303463771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Drop", "[", 
   RowBox[{"sp", ",", 
    RowBox[{"{", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->41937572],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0"},
     {"2", "0"},
     {"0", "0"},
     {"0", "4"},
     {"0", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {5, 2}, 0, {
    1, {{0, 1, 2, 2, 3, 3}, {{1}, {1}, {2}}}, {1, 2, 4}}]]]], "Output",
 ImageSize->{46, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->470136388]
}, Open  ]],

Cell["\<\
In this example rows 2 and 3, and columns 1, 2, and 3 are all dropped.\
\>", "Text",
 CellID->989935803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Drop", "[", 
   RowBox[{"sp", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1295227712],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0"},
     {"0", "4"},
     {"2", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 2}, 0, {1, {{0, 0, 1, 2}, {{2}, {1}}}, {4, 2}}]]]], "Output",\

 ImageSize->{46, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->1997909592]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inserting Rows and Columns", "Subsection",
 CellTags->{"t:224", "c:51"},
 CellID->812208252],

Cell[TextData[{
 "If you want to insert a row, you can use ",
 Cell[BoxData[
  ButtonBox["Insert",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Insert"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1378031032],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Insert",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Insert"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["r", "TI"], ",", 
     StyleBox["i", "TI"], "]"}], Cell[TextData[{
     "insert row ",
     StyleBox["r", "TI"],
     " into matrix ",
     StyleBox["m", "TI"],
     " at position ",
     StyleBox["i", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.3",
 CellID->2103905576],

Cell["Inserting a row. ", "Caption",
 CellTags->"S3.7.2",
 CellID->2022767977],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "3"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "5"}], "}"}], "\[Rule]", "4"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "4"}], "}"}], "\[Rule]", "2"}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1995257429],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "2", "0", "0"},
     {"2", "0", "0", "0", "0"},
     {"0", "3", "0", "0", "0"},
     {"0", "0", "0", "0", "4"},
     {"0", "0", "0", "2", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {5, 5}, 0, {
    1, {{0, 2, 3, 4, 5, 6}, {{1}, {3}, {1}, {2}, {5}, {4}}}, {1, 2, 2, 3, 4, 
     2}}]]]], "Output",
 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->1334461298]
}, Open  ]],

Cell["This inserts a row before row 3.", "Text",
 CellID->2119309865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Insert", "[", 
   RowBox[{"sp", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], ",", "3"}],
    "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1077131913],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "2", "0", "0"},
     {"2", "0", "0", "0", "0"},
     {"x", "x", "x", "x", "x"},
     {"0", "3", "0", "0", "0"},
     {"0", "0", "0", "0", "4"},
     {"0", "0", "0", "2", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {6, 5}, 0, {
    1, {{0, 2, 3, 8, 9, 10, 11}, {{1}, {3}, {1}, {1}, {2}, {3}, {4}, {5}, {
      2}, {5}, {4}}}, {
     1, 2, 2, $CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, 3, 4, 2}}]]]], "Output",
 ImageSize->{91, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->68917581]
}, Open  ]],

Cell["\<\
If you want to insert a column, you must transpose the matrix, insert the \
column as a row, and then transpose the matrix back. This inserts a column \
before column 5.\
\>", "Text",
 CellID->804098134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "[", 
   RowBox[{"Insert", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", "sp", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], ",", 
     "5"}], "]"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->362747567],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "2", "0", "x", "0"},
     {"2", "0", "0", "0", "x", "0"},
     {"0", "3", "0", "0", "x", "0"},
     {"0", "0", "0", "0", "x", "4"},
     {"0", "0", "0", "2", "x", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {5, 6}, 0, {
    1, {{0, 3, 5, 7, 9, 11}, {{1}, {3}, {5}, {1}, {5}, {2}, {5}, {5}, {6}, {
      4}, {5}}}, {
     1, 2, $CellContext`x, 2, $CellContext`x, 
      3, $CellContext`x, $CellContext`x, 4, 2, $CellContext`x}}]]]], "Output",\

 ImageSize->{106, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->2139768383]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Extending Matrices", "Subsection",
 CellTags->{"t:129", "c:52"},
 CellID->1326060419],

Cell[TextData[{
 "You can increase the size of a matrix by padding it with ",
 Cell[BoxData[
  ButtonBox["PadLeft",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadLeft"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PadRight",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadRight"]], "InlineFormula"],
 "."
}], "Text",
 CellID->512173567],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "3"}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "InputOnly",
 CellLabel->"In[1]:=",
 CellID->986683393],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "2"},
     {"0", "0", "0"},
     {"0", "3", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 2, 3}, {{1}, {3}, {2}}}, {1, 2, 3}}]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->319064017]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PadLeft",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadLeft"]], "InlineFormula"],
 " adds the elements to the beginning of the matrix. This example returns a 4\
\[Cross]4 sparse matrix."
}], "Text",
 CellID->242267160],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadLeft", "[", 
  RowBox[{"sp", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->155163408],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->786250798]
}, Open  ]],

Cell[TextData[{
 "You can see the result with ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1050281995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1921395272],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", "0", "0"},
     {"0", "1", "0", "2"},
     {"0", "0", "0", "0"},
     {"0", "0", "3", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {4, 4}, 0, {
    1, {{0, 0, 2, 2, 3}, {{2}, {4}, {3}}}, {1, 2, 3}}]]]], "Output",
 ImageSize->{76, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->1178736565]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PadRight",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadRight"]], "InlineFormula"],
 " adds the elements to the end of the matrix; the result is a sparse array."
}], "Text",
 CellID->488804380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PadRight", "[", 
   RowBox[{"sp", ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1210264885],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "2", "0"},
     {"0", "0", "0", "0"},
     {"0", "3", "0", "0"},
     {"0", "0", "0", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {4, 4}, 0, {
    1, {{0, 2, 2, 3, 3}, {{1}, {3}, {2}}}, {1, 2, 3}}]]]], "Output",
 ImageSize->{76, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->2104301458]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["PadLeft",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadLeft"]], "InlineFormula"],
 " to pad on the right if you specify negative indices."
}], "Text",
 CellID->86422163],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PadLeft", "[", 
   RowBox[{"sp", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "4"}], ",", 
      RowBox[{"-", "4"}]}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->798348169],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "2", "0"},
     {"0", "0", "0", "0"},
     {"0", "3", "0", "0"},
     {"0", "0", "0", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {4, 4}, 0, {
    1, {{0, 2, 2, 3, 3}, {{1}, {3}, {2}}}, {1, 2, 3}}]]]], "Output",
 ImageSize->{76, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->359849927]
}, Open  ]],

Cell["\<\
One important use of the padding functions is to replicate and tile a matrix. \
In this example the input matrix is extended to have two versions in every \
row and three in every column.\
\>", "Text",
 CellID->683773137],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "3"}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "InputOnly",
 CellLabel->"In[7]:=",
 CellID->990118462],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "2"},
     {"0", "3", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {2, 3}, 0, {
    1, {{0, 2, 3}, {{1}, {3}, {2}}}, {1, 2, 3}}]]]], "Output",
 ImageSize->{61, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//MatrixForm=",
 CellID->70210231]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PadRight", "[", 
   RowBox[{"sp", ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "9"}], "}"}], ",", "sp"}], "]"}], "//", 
  "MatrixForm"}]], "InputOnly",
 CellLabel->"In[9]:=",
 CellID->1054830214],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "2", "1", "0", "2", "1", "0", "2"},
     {"0", "3", "0", "0", "3", "0", "0", "3", "0"},
     {"1", "0", "2", "1", "0", "2", "1", "0", "2"},
     {"0", "3", "0", "0", "3", "0", "0", "3", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {4, 9}, 0, {
    1, {{0, 6, 9, 15, 18}, {{1}, {3}, {4}, {6}, {7}, {9}, {2}, {5}, {8}, {
      1}, {3}, {4}, {6}, {7}, {9}, {2}, {5}, {8}}}, {1, 2, 1, 2, 1, 2, 3, 3, 
     3, 1, 2, 1, 2, 1, 2, 3, 3, 3}}]]]], "Output",
 ImageSize->{151, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]//MatrixForm=",
 CellID->1053900713]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PadLeft",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadLeft"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PadRight",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadRight"]], "InlineFormula"],
 " have a number of extra features. These are described in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " documentation."
}], "Text",
 CellID->464162935]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transpose", "Subsection",
 CellTags->{"t:130", "c:53"},
 CellID->1525842641],

Cell["Transposition of elements is a general matrix operation.", "Text",
 CellID->1735038460],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "3"}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->110954607],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwWAKxjAQDkP0fyAJj
y///gTSEZAWRzCBRMGDQQuOzgFWxYBEFcXnQaHY0dcxYdYNFWeF8sBoGBi4S
RNkosIcPTRUHCTYwYwsdMm1ADysmEmwAhTcTkOamusm0dzsp8UycPaA0jC01
chClW29UFVJ8sUJTFTOUZiU6FtBzDPXjmTgbuNFUEZcKiDObB00VNd3NS0AX
xGz0Mg69/MZuNnquxlpSkmk2JSU0iM8E9TvheoS4ugpSrzEwAgA6ecpb\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->2118724]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Transpose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Transpose"]], "InlineFormula"],
 " swaps elements at specific indices; the result is a sparse array."
}], "Text",
 CellID->1265027362],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", "sp", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1226767834],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->217095622]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->965386097],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztlitzg0AQgI9HEtI21RUV6PR/tKo/gsl0JhGddtIIHBKJRPITkEgkEolE
IpHI696D3HGhDJSKzrTMwC3H7nf7gFuendP+5dU5HXaO/XR03veH3Yf9+HaE
KUNDCG3hfLhDIGOQ6LnFGEb5uiBXI4oiTA90T+89z+P3BtUyqVgURZIk7ewC
gNcwGjCuWkqe56pVGIYyi5jh9gAZXfXOLqlB0zSu6wqi0c4yKPf+bEv9uWQx
73zfB0Mi6meWnmXZSmH0+8O0IHxIQpdBI6yqiogqaz3AEtmUWSLzlsKyBlgQ
GCvhFyxzQuYtpWpaL5Fknjh3w8e18rzfyv7XmpW/6XX8HvEWd9+95S9hkWzp
M7P1k/7Myfzf/YKCIBihJXqSrAX7Ul3XmFdE7kEs62VZxnFMRHknhI2WdyZW
7XG7fZqmPbs9LM9XmMKCmDvdR+2NaicbYolMCZYO8Y3zh2jpEAH1gK8r/DBH
My46O2exVjiVJawYi1SVfOkbzKq7obPsnwVpnynWSU0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{42, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->137571714]
}, Open  ]],

Cell[TextData[{
 "If you wish to compute the conjugate transpose of a sparse matrix, you can \
use ",
 Cell[BoxData[
  ButtonBox["ConjugateTranspose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ConjugateTranspose"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1940346256],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1."}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", 
       RowBox[{"-", "I"}]}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "I"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "10.5"}]}], "}"}], "]"}]}],
   ";"}], "\n", 
 RowBox[{
  RowBox[{"spCT", "=", 
   RowBox[{"ConjugateTranspose", "[", "sp", "]"}]}], ";"}], "\n", 
 RowBox[{"spCT", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->1860344897],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVjtvwjAQNnHCo4+hDVUrtZVQO1b9G22HdmWPUCUYqlaUgY2RkZGRn8DI
yMjIyMjIyMho7vzAjpNIARKpQyMld2ef77vcne37CDrNz6+g02oEtdd28NNs
NX5rL99tGKIFQkgd3qcbAjwDjr91xoCaXw+/dDQaMf6QNy73ej0pU67lcnax
WEwmE2RRpmDwEmgJaAWoB5TKcZx3iLCOckmhzOdz2+pwODSx0AxTD/DE51Ni
FOVzQ0bWiV1FpQdu7GyR29hsNt1uV/tD1ahwKWHtYf7YWiLu/X4f4HarhNez
2czLHRkSCekMI/NcrFarrP/9hIkqKLNwFZnIuuLikS+YqLD0iKZWWWVWFPpe
yI8HIVZUPKVciEVU++PKWn3KwvsHZXcXQb0+3ur7v5YVX1/SKhPnlZ9qdXIl
RkfNDGo5SwSsAY+oEztPpPz/JX8EX0Yre8vPqSzalXdt/DGy1VRW/uq+2kdr
MBik0NIdiKkF5+d6vWYyQ6rDcOQ9QA16z/WXy+V4PEbWPOHhupF9R9HKgrJ2
xpJ2XHT0ji+cTqcx9yc4K/FtpOQ9nYQAcQv1Bna35B2NoHOgERyI1DG+36IN
iAH3VvqofXaPtBzpFiWCaFqyQdC2BIK6i3HHmhX3wGdFF00KW0orja4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{86, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//MatrixForm=",
 CellID->138343104]
}, Open  ]],

Cell["\<\
If a matrix is equal to its conjugate transpose, it is said to be hermitian.\
\>", "Text",
 CellID->2007481509],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "===", "spCT"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->626143746],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->48900909]
}, Open  ]],

Cell[TextData[{
 "You can also test with the function ",
 Cell[BoxData[
  ButtonBox["HermitianMatrixQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HermitianMatrixQ"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->69451272],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HermitianMatrixQ", "[", "sp", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->986225542],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->185446389]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rotating Elements", "Subsection",
 CellTags->{"t:131", "c:54"},
 CellID->877282493],

Cell[TextData[{
 "Another structural operation is to rotate elements within an index. This \
can be done with the functions ",
 Cell[BoxData[
  ButtonBox["RotateLeft",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RotateLeft"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RotateRight",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RotateRight"]], "InlineFormula"],
 "."
}], "Text",
 CellID->2011623196],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "3"}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1516000451],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "2"},
     {"0", "0", "0"},
     {"0", "3", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 2, 3}, {{1}, {3}, {2}}}, {1, 2, 3}}]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->1673591949]
}, Open  ]],

Cell["\<\
This rotates left by one step in the first level, thereby operating on the \
rows; the result is a sparse array.\
\>", "Text",
 CellID->319078437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RotateLeft", "[", 
  RowBox[{"sp", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->484624100],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1819259276]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->418485746],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", "0"},
     {"0", "3", "0"},
     {"1", "0", "2"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 0, 1, 3}, {{2}, {1}, {3}}}, {3, 1, 2}}]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->480989097]
}, Open  ]],

Cell["\<\
This rotates left by one step in the second level, that operates on the \
columns; the result is a sparse array.\
\>", "Text",
 CellID->855305971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RotateLeft", "[", 
   RowBox[{"sp", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->2019405226],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "2", "1"},
     {"0", "0", "0"},
     {"3", "0", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 2, 3}, {{3}, {2}, {1}}}, {1, 2, 3}}]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->1312076194]
}, Open  ]],

Cell["This rotates the columns in the opposite direction.", "Text",
 CellID->1702505162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RotateRight", "[", 
   RowBox[{"sp", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->932145106],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2", "1", "0"},
     {"0", "0", "0"},
     {"0", "0", "3"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 2, 3}, {{2}, {1}, {3}}}, {1, 2, 3}}]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->669591677]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Testing Matrices", "Subsection",
 CellTags->{"t:132", "c:55"},
 CellID->1013005059],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a number of functions for testing sparse matrices and extracting \
size information."
}], "Text",
 CellID->325673197],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["VectorQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/VectorQ"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "give ",
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"],
     " if ",
     StyleBox["expr", "TI"],
     " has the form of a vector, and ",
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"],
     " otherwise "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MatrixQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatrixQ"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "give ",
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"],
     " if ",
     StyleBox["expr", "TI"],
     " has the form of a matrix, and ",
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"],
     " otherwise "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ArrayQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArrayQ"], "[", 
     StyleBox["t", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "test whether ",
     StyleBox["t", "TI"],
     " is a tensor of rank ",
     StyleBox["n", "TI"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Dimensions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dimensions"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "a list of the dimensions of a vector or matrix ", "TableText"]},
   {
    RowBox[{
     ButtonBox["ArrayDepth",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArrayDepth"], "[", 
     StyleBox["t", "TI"], "]"}], Cell[
    "find the rank of a tensor ", "TableText"]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["m", "TI"], 
      StyleBox["i", "TI"]], 
     StyleBox["==", "MR"], 
     SubscriptBox[
      StyleBox["m", "TI"], 
      StyleBox["j", "TI"]]}], Cell[
    "compare two matrices for equality ", "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.3",
 CellID->1801089423],

Cell[TextData[{
 "The predicate ",
 Cell[BoxData[
  ButtonBox["MatrixQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixQ"]], "InlineFormula"],
 " can be used to test sparse matrices. It can also be used to test dense \
matrices as shown ",
 ButtonBox["previously",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#1736222906"],
 "."
}], "Text",
 CellID->2127927896],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "3"}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "InputOnly",
 CellLabel->"In[1]:=",
 CellID->2038974581],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2", "0", "2"},
     {"0", "0", "0"},
     {"0", "3", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 2, 3}, {{1}, {3}, {2}}}, {2, 2, 3}}]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->1649227688]
}, Open  ]],

Cell[TextData[{
 "This tests that ",
 StyleBox["sp", "MR"],
 " is a sparse matrix."
}], "Text",
 CellID->998320387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", "sp", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->481010298],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1211631178]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixQ"]], "InlineFormula"],
 " takes an optional second argument that specifies a test to apply to every \
element. In this example every element is tested to see if it is an integer."
}], "Text",
 CellID->1445267792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", " ", 
  RowBox[{"sp", ",", "IntegerQ"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->428248927],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1362014992]
}, Open  ]],

Cell[TextData[{
 "In the example below, every element must be an integer greater than 1. \
Because some of the elements are 0, the result is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1357777171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", " ", 
  RowBox[{"sp", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"IntegerQ", "[", "#", "]"}], " ", "&&", " ", 
     RowBox[{"#", ">", "1"}]}], " ", "&"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->999679975],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1856769344]
}, Open  ]],

Cell[TextData[{
 "In addition to ",
 Cell[BoxData[
  ButtonBox["MatrixQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixQ"]], "InlineFormula"],
 ", there are predicates ",
 Cell[BoxData[
  ButtonBox["VectorQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VectorQ"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ArrayQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayQ"]], "InlineFormula"],
 ", which are useful for testing vectors and tensors."
}], "Text",
 CellID->1637490051],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorQ", "[", 
  RowBox[{"SparseArray", "[", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", "1", "}"}], "\[Rule]", "2"}], ",", 
     RowBox[{
      RowBox[{"{", "5", "}"}], "\[Rule]", "2"}], ",", 
     RowBox[{
      RowBox[{"{", "9", "}"}], "\[Rule]", "3"}]}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1292350852],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->891163806]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayQ", "[", " ", 
  RowBox[{"SparseArray", "[", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "5"}], "}"}], "\[Rule]", "2"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "4", ",", "2"}], "}"}], "\[Rule]", "3"}]}], "}"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1239133264],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1963843089]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArrayQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayQ"]], "InlineFormula"],
 " can also take a rank argument to test the depth of the array. In this \
example, the sparse argument is not a rank-4 tensor and the result is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1634626080],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayQ", "[", " ", 
  RowBox[{
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "5"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "4", ",", "2"}], "}"}], "\[Rule]", "3"}]}], "}"}], 
    "]"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->402230489],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->9307867]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArrayQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayQ"]], "InlineFormula"],
 " also takes a third argument that tests each element. In this example the \
result is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " because all the elements are ",
 Cell[BoxData[
  ButtonBox["NumberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberQ"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1818498085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayQ", "[", " ", 
  RowBox[{
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "5"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "4", ",", "2"}], "}"}], "\[Rule]", "3"}]}], "}"}], 
    "]"}], ",", " ", "3", ",", "NumberQ"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->510050491],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->1811367060]
}, Open  ]],

Cell[TextData[{
 "The command ",
 StyleBox["Dimension", "MR"],
 " is useful for extracting size information."
}], "Text",
 CellID->917997548],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "3"}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "InputOnly",
 CellLabel->"In[10]:=",
 CellID->1262269188],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2", "0", "2"},
     {"0", "0", "0"},
     {"0", "3", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 2, 3}, {{1}, {3}, {2}}}, {2, 2, 3}}]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]//MatrixForm=",
 CellID->2114777650]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", " ", "sp", "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->66122053],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "3"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->1064299272]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dimensions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dimensions"]], "InlineFormula"],
 " returns a list of length 2 when the input is a matrix, stating that two \
indices are used to reference any element in the matrix. Another way to test \
the number of indices required to reference elements is with ",
 Cell[BoxData[
  ButtonBox["ArrayDepth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayDepth"]], "InlineFormula"],
 "; this is equivalent to ",
 StyleBox["Length[Dimensions[sp]]", "MR"],
 "."
}], "Text",
 CellID->1286568641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayDepth", "[", " ", "sp", "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->346307644],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->711889338]
}, Open  ]],

Cell[TextData[{
 "To compare if the elements of two matrices are equal it is possible to use \
",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 ", typically entered using a ",
 StyleBox["==", "MR"],
 " short-hand notation. For example, comparing a matrix with itself returns \
",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1092706329],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", "1", "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", "5", "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", "9", "}"}], "\[Rule]", "3"}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"sp", "\[Equal]", "sp"}]}], "Input",
 CellLabel->"In[14]:=",
 CellID->1982606006],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->1302875990]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " uses the value of numbers so it can be used to compare integer and real \
values."
}], "Text",
 CellID->1693499118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "\[Equal]", 
  RowBox[{"N", "[", "sp", "]"}]}]], "Input",
 CellLabel->"In[16]:=",
 CellID->2038902535],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->438350566]
}, Open  ]],

Cell[TextData[{
 "It should be noted that ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 " works on any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. If you want to compare two matrices for equality using \
properties of the matrix as a whole, it may be better to compare matrix \
norms. These are discussed under \"",
 ButtonBox["Matrix Norms",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#1973408751"],
 "\"."
}], "Text",
 CellID->1489053552]
}, Open  ]],

Cell[CellGroupData[{

Cell["Further Structural Operations", "Subsection",
 CellTags->"c:56",
 CellID->1896109973],

Cell["\<\
This section discusses some further structural operations that are useful for \
working with matrices.\
\>", "Text",
 CellID->1410478378],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Flatten",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Flatten"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "flatten out nested lists in ",
     StyleBox["m", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Flatten",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Flatten"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "flatten out nested lists in ",
     StyleBox["m", "TI"],
     " to level ",
     StyleBox["n", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Partition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Partition"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "partition ",
     StyleBox["m", "TI"],
     " into sublists of length ",
     StyleBox["n", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Join",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Join"], "[", 
     SubscriptBox[
      StyleBox["m", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["m", "TI"], "2"], "]"}], Cell[TextData[{
     "concatenate ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["m", "TI"], "1"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["m", "TI"], "2"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Append",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Append"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["r", "TI"], "]"}], Cell[TextData[{
     "insert row ",
     StyleBox["r", "TI"],
     " at the end of ",
     StyleBox["m", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Prepend",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Prepend"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["r", "TI"], "]"}], Cell[TextData[{
     "insert row ",
     StyleBox["r", "TI"],
     " at the beginning of ",
     StyleBox["m", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.3",
 CellID->1985603460],

Cell["This generates a sample matrix for demonstration.", "Text",
 CellID->141477840],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "a"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "b"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "c"}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->553659651],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVr1ugzAQNhiSJm2HTo06Zc/QOS/QTn0IFFVKhqpVmoGNkZGRkUdgZGRk
ZGRkZGRkpOcfwLhUgkCkDrEEvjvs78zns+/ejNP+/cM4HXbG+vVofO0Pu+/1
y+cRTFhBCG3h2awQyCVI9NmWJfTiWydv7HleSRvaUN2yLK5jOkqjYpIkQRAQ
kegYAO+kfl6hxXEsz3ZdV8TUyXqqBjJaDrDOKExRFKZpNn5wZWWumN8hfnBt
RQuq27YNcERUaw9qFEX6aGQgEuhsI1OOsiw7a+2/rHNpz0Q/zf4O8XMLvVYj
AzEsbCZAfqz+npuUTkTCuhhtK+l796zn66g/+CN7QbZi0Wv2+Ii8ufrp4UeF
np4o4c6YXeaPNGZFtF0oCoS/WPby0BWlKtf/46mafpTjOD1GNTlbHAV3aJ7n
FY8650/kk0Vtmqa+7xNRvL0hVfDMPVX+CcOwI8/BErn3qfwAZ61MLdccRNfO
Qm54b5BVYGn8ysmpVoEHisQrsXaVhHnWHVYXSZUWR2aFBREfBiM2cxniU9mO
qXtqZRUlUn4A6I8dHg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->116334242]
}, Open  ]],

Cell["This flattens the matrix into a vector.", "Text",
 CellID->1882607344],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"vec", "=", 
   RowBox[{"Flatten", "[", "sp", "]"}]}], ";"}], "\n", 
 RowBox[{"vec", "//", "Normal"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->2105059357],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "0", ",", "0", ",", "0", ",", "0", ",", "b", ",", "0", ",", "0", 
   ",", "c"}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->254142683]
}, Open  ]],

Cell[TextData[{
 "The vector can be partitioned back into a matrix with rows of length 3 \
using ",
 Cell[BoxData[
  ButtonBox["Partition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Partition"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1567353296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{"vec", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1472431770],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->541666]
}, Open  ]],

Cell[TextData[{
 "Matrices can be joined together with the function ",
 StyleBox["Join.", "MR"]
}], "Text",
 CellID->467136284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Join", "[", " ", 
   RowBox[{"sp", ",", "sp"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->2106795403],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWL9Pg0AUvnKAbdXBaLRx6n/g3H9AJ2dn0pi0g9HUDmwdO3Zk7J/QkbFj
R0ZGxo6MjPjuFxyICddSpRYSuLvH8X3cd+/By3u2pqPXN2s6Hlr9p4n1MRoP
P/uP7xMw4RZCaADnSw9BP4YePQdxDK18NcgVL5fLmB4IwwXD1Itce0ZvzmYz
aR5COu36vu+6bmI1CJM4oI+6ClZTvI/neXkex3FkdhUenFhRm46jKLJtO2XA
wspIGOOODB06ns/nAEe6WsKgbTYbY2+N2F6A5CB8Fp9qtN1uVVdwDq2eIKf7
KSOne6+CfCt0ZS72AyLRRPa2nlgLv98qfOohNz7dWXn9yF6QreiUelrZ179Z
2w1PCR4NWur/0rfCPMyKdGZF9DiQF0ir6JZiKPJSjY/rGFV1nUV0NLh+sp6n
Ge1EDf3oV4D5X7ha5OvKEW/iXXyurpH093/qfxK7yv+CGjL8glYiz64e+a4U
YnGeXb8oqeusJs8+Bp4mzz71PHuxWJSYlVa95FmO44RhKHQsyrOZ1wZBsFqt
SFeuabiuyytX+0cHq8as1+uCOg+8Imevigc0y9Sr8jU3MlbNs/NVwxRZA5X2
f3MS1RroQJF4LTNbJVTNq80CDIHMCmuke6WMmD7LEO/jrE9dUiuryaLWFx+C
tlY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->241505230]
}, Open  ]],

Cell["Alternatively, you can join the new matrix as new columns.", "Text",
 CellID->20075361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Join", "[", " ", 
   RowBox[{"sp", ",", "sp", ",", "2"}], "]"}], "//", "MatrixForm"}]], "Input",\

 CellLabel->"In[7]:=",
 CellID->251834163],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV71ugzAQNjjQ/FVVp6btkr3v0U7dO3RBUaNkqFqlGdgYGRkz5hEyZmRk
ZGRkZMyYkZ5tHAxyKoxIS6Uggc+n893H3fl8fraWs7d3azmfWOOnhfU5m0++
xo8fC2BhDSE0hfdhhIBOgaLvNE1hFL8G+eL1ep3SB73QueM42RxTqQ4loyja
breEJHMMCocVxwtuJQzDstbVaiXaMghO/gCN+r/KNSmQ/X5v23aOFHMuA8uQ
q9jBBy71Sd21PTp3XRegEFI/oNODIDD+FBWkBiRIERWNbpIktXx2Ai7LwzyP
RaR5zqsgHcDYUUTB1zA0EEq2/RpAc6sge5MWd58mtU5yStzJ96X5qCQv1/J6
ljriTxIbQ1IxOb9XSWsb9lb3jPSfINVhpLVGqOHdBnSYp/Frh3ER4rWz/uoT
7aaGztF+JXSyCkKicXWEP6ykta31UkXK87wKUnmvK0rBObjb7bh/jcx/5V5W
xmd7NI7jzWZDSPEUhzYj63jbUE1Yv+H7vqRPg5/P8LcHKcSz0OeW7wtkXrf3
UkeT51GORofotsFfpPLqED+KJbvTFe9VWLF2DmqsMSV2ORp2CSDktYJGlX7W
LNlh1u/Sn/vXSyrF7sJI+wZK/JiC\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{102, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//MatrixForm=",
 CellID->59585568]
}, Open  ]],

Cell[TextData[{
 "A new row can be inserted at the end of a matrix with ",
 Cell[BoxData[
  ButtonBox["Append",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Append"]], "InlineFormula"],
 "."
}], "Text",
 CellID->817784418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Append", "[", 
   RowBox[{"sp", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->607372526],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlV71uwjAQNnZSCJShU1EnnqCdeYF26kNEqBIMFRVlYMvIyJiRR2DMmDEj
IyMjIyNjej7bcWKlbQKhhTZSYvv03efz/SSXZ3cyeHl1J8O+230au2+DYf+9
+zgag4jVCCE9fncIzGOY4d2LYxjTT5s/rcViEauLApDK0flmfcW1med5QpUw
5LRwul6vgyBIpBbfX6AIaRWQ1FEVLFutVia37/sSZ0lL2sbYQNx+v59Op1qb
KakgwNPnaTuIm81mAOVTmmjTKIrsg84jLAKXgGOynHie7Xar7CwTgbrh6zSr
jsu9OrcI9CeoB8O3tS9Qev1/UTwPGMTg2hidQtqYyXaSIYghpFlC2jjNPkxn
bfNSd/gBX/EKt07CfFuI0cy+TiGtc62l369eHgv78qv3j+2jvnXpd4bZdVR0
Ivm1JnidKAtKv/nyspTK9TlWVfWo+XxeAJV0sBkU9DK73U750Zb+S/tTZO1m
s1kul3ya7oygpZK95/HVIfq0MAxzuj8wUe5e1T7gs0znmtc1Wwcxa79rZgpe
Ot5yXtUU/IBM4r8kZTGT8WqVZDQ5FLNot/n0pjSj1hWMd3E2p9ooFf9XpPYB
Bibacw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//MatrixForm=",
 CellID->124391160]
}, Open  ]],

Cell[TextData[{
 "It should be noted that this can also be done with ",
 Cell[BoxData[
  ButtonBox["Insert",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Insert"]], "InlineFormula"],
 ". This is shown in the section \"",
 ButtonBox["Inserting Rows and Columns",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraSparseArrays#812208252"],
 "\"."
}], "Text",
 CellID->1393647588]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Element-wise Operations", "Section",
 CellTags->{"t:134", "c:57"},
 CellID->430873687],

Cell[TextData[{
 "If you want to work on the elements of a sparse matrix, you can do this \
easily with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". First, a matrix of floating point numbers is created."
}], "Text",
 CellID->379199725],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1.2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "2.3"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "3.1"}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1625797426],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.2`", "0", "2.3`"},
     {"0", "0", "0"},
     {"0", "3.1`", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.28], {
         Offset[0.7]}, 
        Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {3, 3}, 0, {
     1, {{0, 2, 2, 3}, {{1}, {3}, {2}}}, {1.2, 2.3, 3.1}}]]]]], "Output",
 ImageSize->{103, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->195414354]
}, Open  ]],

Cell["\<\
In general arithmetic operations applied to a matrix work on each element. \
This adds 5 to the matrix.\
\>", "Text",
 CellID->826551415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"sp", "+", "5"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1925403109],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"6.2`", "5.`", "7.3`"},
     {"5.`", "5.`", "5.`"},
     {"5.`", "8.1`", "5.`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.28], {
         Offset[0.7]}, 
        Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {3, 3}, 5., {
     1, {{0, 2, 2, 3}, {{1}, {3}, {2}}}, {6.2, 7.3, 8.1}}]]]]], "Output",
 ImageSize->{103, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->1966459967]
}, Open  ]],

Cell["Here, every element of the matrix is squared.", "Text",
 CellID->519338039],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SuperscriptBox["sp", "2"], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1140880065],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.44`", "0", "5.289999999999999`"},
     {"0", "0", "0"},
     {"0", "9.610000000000001`", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.28], {
         Offset[0.7]}, 
        Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {3, 3}, 0, {
     1, {{0, 2, 2, 3}, {{1}, {3}, {2}}}, {1.44, 5.29, 9.61}}]]]]], "Output",
 ImageSize->{124, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->2037252039]
}, Open  ]],

Cell["\<\
If one matrix is divided by another, the division is done element by element. \
If the dimensions of the two matrices do not agree, then an error ensues.\
\>", "Text",
 CellID->615751705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"sp", "/", 
   RowBox[{"(", 
    RowBox[{"1", "+", "sp"}], ")"}]}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->215211042],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.5454545454545454`", "0.`", "0.6969696969696969`"},
     {"0.`", "0.`", "0.`"},
     {"0.`", "0.7560975609756099`", "0.`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.28], {
         Offset[0.7]}, 
        Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {3, 3}, 0., {
     1, {{0, 2, 2, 3}, {{1}, {3}, {2}}}, {0.545454545454545, 
      0.696969696969697, 0.75609756097561}}]]]]], "Output",
 ImageSize->{201, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->689521346]
}, Open  ]],

Cell[TextData[{
 "To apply the ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " function to every element, you apply ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " to the entire matrix."
}], "Text",
 CellID->963503010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", "sp", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1568390690],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.9320390859672263`", "0", "0.7457052121767203`"},
     {"0", "0", "0"},
     {"0", "0.04158066243329049`", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 2, 3}, {{1}, {3}, {2}}}, {0.932039085967226, 0.745705212176721,
      0.0415806624332905}}]]]], "Output",
 ImageSize->{215, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->1728043552]
}, Open  ]],

Cell["\<\
If both of the arguments of an operation are matrices, the operation is \
carried out on corresponding elements. This result is the same as multiplying \
the matrix by two.\
\>", "Text",
 CellID->659136436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"sp", " ", "+", "sp"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1385428626],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2.4`", "0.`", "4.6`"},
     {"0.`", "0.`", "0.`"},
     {"0.`", "6.2`", "0.`"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0., {
    1, {{0, 2, 2, 3}, {{1}, {3}, {2}}}, {2.4, 4.6, 6.2}}]]]], "Output",
 ImageSize->{103, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//MatrixForm=",
 CellID->1881216408]
}, Open  ]],

Cell["\<\
If the one argument is a matrix and the other is a vector, the operation is \
carried out between rows of the matrix and elements of the vector. This is an \
efficient way of generating a diagonal sparse matrix.\
\>", "Text",
 CellID->202434475],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vec", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{"Range", "[", "5", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[8]:=",
 CellID->702124477],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", "0", "0"},
     {"0", "1", "0", "0", "0"},
     {"0", "0", "1", "0", "0"},
     {"0", "0", "0", "1", "0"},
     {"0", "0", "0", "0", "1"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {5, 5}, 0, {
    1, {{0, 1, 2, 3, 4, 5}, {{1}, {2}, {3}, {4}, {5}}}, {1, 1, 1, 1, 
     1}}]]]], "Output",
 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]//MatrixForm=",
 CellID->183444674]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", " ", "vec"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->1515602473],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "5", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 5, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->1427226644]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->5868718],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", "0", "0"},
     {"0", "2", "0", "0", "0"},
     {"0", "0", "3", "0", "0"},
     {"0", "0", "0", "4", "0"},
     {"0", "0", "0", "0", "5"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {5, 5}, 0, {
    1, {{0, 1, 2, 3, 4, 5}, {{1}, {2}, {3}, {4}, {5}}}, {1, 2, 3, 4, 
     5}}]]]], "Output",
 ImageSize->{91, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]//MatrixForm=",
 CellID->1998779311]
}, Open  ]],

Cell["\<\
These operations are all fast because they only need to operate on the \
elements that are actually stored (including the default element). \
\>", "Text",
 CellID->397189956],

Cell[TextData[{
 "Note that multiplying two matrices using the operator ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " is equivalent to multiplying the corresponding elements. On the other hand \
matrix multiplication can be done with the function ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 ", which is described in the section \"",
 ButtonBox["Matrix Multiplication",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraSparseArrays#243730537"],
 "\". An example of element-wise multiplication is shown in the following \
example."
}], "Text",
 CellID->1192415616],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", " ", "=", " ", 
   RowBox[{"SparseArray", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "3"}], ",", " ", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "4"}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"sp", " ", "sp"}], "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[8]:=",
 CellID->611864308],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "9", "0"},
     {"0", "0", "16"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {2, 3}, 0, {1, {{0, 1, 2}, {{2}, {3}}}, {9, 16}}]]]], "Output",
 ImageSize->{68, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]//MatrixForm=",
 CellID->1451722720]
}, Open  ]],

Cell[CellGroupData[{

Cell["Listability", "Subsection",
 CellTags->{"t:135", "c:58"},
 CellID->1542041473],

Cell[TextData[{
 "If you want to apply your own function to each element in a matrix, you may \
give your function the attribute ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 ". This function squares each element and divides the result by 3."
}], "Text",
 CellID->1258384715],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"fun", ",", "Listable"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"fun", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "/", "3"}]}]}], "InputOnly",
 CellLabel->"In[1]:=",
 CellID->1252949349],

Cell[BoxData[
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1.2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "2.3"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "3.1"}]}], "}"}], "]"}]}], 
  ";"}]], "InputOnly",
 CellLabel->"In[3]:=",
 CellID->95066161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"fun", "[", " ", "sp", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->49134559],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.48`", "0", "1.763333333333333`"},
     {"0", "0", "0"},
     {"0", "3.2033333333333336`", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 2, 3}, {{1}, {3}, {2}}}, {0.48, 1.76333333333333, 
     3.20333333333333}}]]]], "Output",
 ImageSize->{166, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->1170812665]
}, Open  ]],

Cell[TextData[{
 "When a listable operation is applied to a sparse array, it only operates on \
the elements that are actually stored (including the default element), so the \
value of ",
 StyleBox["fun[0]", "MR"],
 " is only computed once."
}], "Text",
 CellID->455803194]
}, Open  ]],

Cell[CellGroupData[{

Cell["Map", "Subsection",
 CellTags->{"t:136", "c:59"},
 CellID->2077369385],

Cell[TextData[{
 "Instead of using listability you can use ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " to apply a function to every element in a matrix."
}], "Text",
 CellID->558120769],

Cell[BoxData[
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1.2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "2.3"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "3.1"}]}], "}"}], "]"}]}], 
  ";"}]], "InputOnly",
 CellLabel->"In[1]:=",
 CellID->127194487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " will apply the function ",
 StyleBox["fun", "MR"],
 " to every element in the matrix."
}], "Text",
 CellID->1011514244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", "sp", ",", 
   RowBox[{"{", 
    RowBox[{"-", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1039349256],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}], ",", 
    RowBox[{"f", "[", "0", "]"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{206, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->710960894]
}, Open  ]],

Cell[TextData[{
 "You can see the matrix that the sparse array represents. Note that because \
the function ",
 StyleBox["f", "MR"],
 " did not have any definition, it is just kept wrapped around every \
element."
}], "Text",
 CellID->520733550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->972913325],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"f", "[", "1.2`", "]"}], 
      RowBox[{"f", "[", "0", "]"}], 
      RowBox[{"f", "[", "2.3`", "]"}]},
     {
      RowBox[{"f", "[", "0", "]"}], 
      RowBox[{"f", "[", "0", "]"}], 
      RowBox[{"f", "[", "0", "]"}]},
     {
      RowBox[{"f", "[", "0", "]"}], 
      RowBox[{"f", "[", "3.1`", "]"}], 
      RowBox[{"f", "[", "0", "]"}]}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, $CellContext`f[0], {
    1, {{0, 2, 2, 3}, {{1}, {3}, {2}}}, {$CellContext`f[1.2], $CellContext`f[
      2.3], $CellContext`f[3.1]}}]]]], "Output",
 ImageSize->{166, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->813765017]
}, Open  ]],

Cell["\<\
Here, a function that squares its argument and divides the result by 5 is \
applied to every element in the matrix.\
\>", "Text",
 CellID->1772776623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", "^", "2"}], "/", "5"}], " ", "&"}], ",", "sp", ",", 
   RowBox[{"{", 
    RowBox[{"-", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->868584283],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1849695722]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->862725682],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.288`", "0", "1.0579999999999998`"},
     {"0", "0", "0"},
     {"0", "1.9220000000000004`", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 2, 3}, {{1}, {3}, {2}}}, {0.288, 1.058, 1.922}}]]]], "Output",
 ImageSize->{145, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->20952830]
}, Open  ]],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " applies a function to a sparse array, it only operates on the elements \
that are actually stored (including the default element)."
}], "Text",
 CellID->2114379349]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Visualization of Sparse Matrices", "Section",
 CellTags->{"t:137", "c:60"},
 CellID->1853380947],

Cell[TextData[{
 "This section reviews the functions that are available for formatting and \
plotting sparse matrices. Because sparse matrices are well integrated into \
the system, most of the examples in this section are very similar to the way \
that dense matrices work. Visualization techniques for dense matrices are \
described under \"",
 ButtonBox["Visualization of Matrices",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#1361817013"],
 "\"."
}], "Text",
 CellID->523276494],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MatrixForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatrixForm"], "[", 
     StyleBox["mat", "TI"], "]"}], Cell["\<\
print a matrix with the elements arranged in a two\[Hyphen]dimensional array \
\
\>", "TableText"]},
   {
    RowBox[{
     StyleBox["MatrixPlot", "MR"], "[", 
     StyleBox["mat", "TI"], "]"}], Cell[TextData[{
     "show the structural pattern of ",
     StyleBox["mat", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"S3.7.3",
 CellID->1601493378],

Cell[CellGroupData[{

Cell["Formatting Sparse Matrices", "Subsection",
 CellTags->{"t:138", "c:61"},
 CellID->1305822102],

Cell[TextData[{
 "Sparse matrices can be formatted with the function ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1816679621],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", " ", "=", " ", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "4"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "1"}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"MatrixForm", "[", "sp", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->11897101],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "4", "0"},
     {"0", "0", "1"},
     {"0", "0", "0"},
     {"0", "2", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {4, 3}, 0, {
    1, {{0, 1, 2, 2, 3}, {{2}, {3}, {2}}}, {4, 1, 2}}]]]], "Output",
 ImageSize->{61, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->238597336]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 " also works for vectors and higher rank sparse arrays; the braces can help \
in understanding the grouping."
}], "Text",
 CellID->753457203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", " ", 
  RowBox[{"SparseArray", "[", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "2", ",", "1"}], "}"}], "\[Rule]", "4"}], 
     ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "1", ",", "2", ",", "2"}], "}"}], "\[Rule]", "2"}], 
     ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "3", ",", "1"}], "}"}], "\[Rule]", "1"}]}],
     "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1791628109],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXb+P2jAUDgQIP45rT1XVSjfAX9NO/SPQqdLdULW63sDGyMhIN6RbMjJV
jIyMjIyMjIyMqX8lDhYhdjHHi3lIgO28vM/vc+wk7yPiW+/l8fuP3svTQ6/7
9bn36/Hp4Xf3y89n0uSXPM97Je+/nz1SjkiJvV+jiHynP6v0059MJhF7eQGr
j8djUb9n9d1ux028uxO311l9MBiI7T7rRYUVV6vVbDaTvSCVzWZDi3S7TwK4
Ed9B7EVsf3dm+yBmablcqr2WsXKr0WiUjq1KeY9fpOw1D7bW2A7r9Zq7Ez2E
5yuIx7Pf70sm/Lh1z4qQNZ/PY351EVUW20B98fpwOCRh02I5YaK8WCzqsbXY
enqv4flKZimZuPsMsFmxN3cIT2Ivc8QwDIWvNlBfvC7XrzQTcq07nQly2JJj
y07vz+MrWR/Een+MCVk3RSwTwFsgPhpRtHcWKGlFTM+76TNOPaNHp9o1FDu9
3nUyUPLaEQ3R3ECL51OLfFePrBiXmZ/FXy/tRNxiVklrJvsuxHqjxOryuLaV
WGsOx3qrxFp1OFaXVyi8okM0RIOGJu9qD80nz59Op+v1mhbVu2Db9mrm81iv
ZY7F/F5c3om2gfrSZ4Jm0qon9hqCD72IuZXMxZvnaTebDR8ikfOF50tv7iZM
iCylOSKB28v1w/NlwgSBC8PQFLEa78sXKe89UF9NLSY4X5w8Wiz/D+J2u6XF
O6C+9JigR2H6TNPNqX/Q8voHrUSrmtG9j8QoWdJA9UaZz3w4GqjJegVPt7Tp
y+T6E55uadOX4TUtMP3Spi8TJuDplzZ9vRUT8LVQEyYun/XCzNnh3nUyUPLa
EQ3R3ECDPT+vb73EiDFijBgjLl7EsM8knQyUvHZEQ7Qio6FGCs8XaqSokWoy
AUzXRI0UNVLUSF23uk6NlOLTA7SVYe+WRspnXrLXVaqjNS0OVC9u6aLn5wCe
iqn6MuHAVS3UhANXVFD9mGFlxcoef4oGs2KIhminocHOWkNZKVE3wYgxYowY
Iy7qmaSTgZLXjmiIVmQ01D/h+UL9E/VPTSaAaZaof6L+ifqn61bXqX/iM6L4
jKipL7e0UHxG1IYvt3RRfEYUM2eu5UQQDdFM0HTnXSC2N3Ps4GmkfKVOrHkd
4Eppa12vke0Nx2MszvnPRm9ZJqEij2C3o03/csv1kS1KrCZnCfoLtlaOHV7F
IVqx0GQ24C3QpB6TRhuPxyKXrN5hX1r/5P0hFdJEi+l/j5nNZuLft9S8ChTN
0qavJE9w4L+VyOAJftg6CUC7tOFDzQDyiCsHreBpljZ9qTkhyUSZzIBr0D3Z
cU2OcTb6QgGTxwC3hqdR2vRVV2L2U0xIHTFQ6lA0Spu+6oovzsTHyEzf/MT2
4v956ZX+AZ+3AqE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{162, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->201386073]
}, Open  ]],

Cell[TextData[{
 "The view that you get from ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 " is dense, which can help you see the sparsity pattern. However, it can \
quickly lead to very large output, especially as the rank of the array \
increases."
}], "Text",
 CellID->1359321835]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plotting Sparse Matrices", "Subsection",
 CellTags->{"t:139", "c:62"},
 CellID->1191044059],

Cell[TextData[{
 "A convenient way to plot sparse matrices is with the function ",
 StyleBox["MatrixPlot", "MR"],
 " ",
 "and described in greater detail under \"",
 ButtonBox["Plotting Matrices",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations#1336717728"],
 "\"."
}], "Text",
 CellID->1182425926],

Cell[TextData[{
 "This reads in a sparse matrix, using the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " function demonstrated in the ",
 ButtonBox["previous section",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraSparseArrays#212323487"],
 "."
}], "Text",
 CellID->2038338144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"Import", "[", 
   RowBox[{
   "\"\<LinearAlgebraExamples/Data/dwg961b.cua\>\"", ",", 
    "\"\<HarwellBoeing\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1690049264],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "10591", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 10591, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"961", ",", "961"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{225, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38417178]
}, Open  ]],

Cell["\<\
The matrix can be plotted. This is a useful way to see the structure of the \
matrix.\
\>", "Text",
 CellID->84924462],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", "sp", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1396291226],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXFlzG8cRXgELgpRIgsACFImDoiTbJSuJFCuHnViJT8mxI9mJj8hR8qJy
pcp+SCXl+FfkyY/5FXny/5t099dz7GAWGJAUBaWkWgHYxex+fU1PHwM+fPLd
13/7+5PvvvnqyfEH3z7559fffPWv4/v/+JYutS8URfED/f/vQUGfDX2S/z8Y
Q+/zrxW9tgu8l/TeovcWvbf1fcCj+Atj/4Xf9qNz+77XcP2ivpfB9baOL4oh
v7YdltBUdHDuXoVCOyo+54+9OsUZd+zwy0Z4R9592ye8bytNYSeUcqHSnZfK
8ET88Q1F11HZKNFnIY9NtYKiE9En9jGn2zmJjBY8v5G/+PsldJ9GLnxfawWc
7qJxmVayqkx2V6RxR3WWO/6kttGt86wDeUAZjUzbxuCEuKvKYzepm6c1Y0Qq
jT5APialUylXI5P2z4u9/SCQSY63v2Tq3t7eB4ttWpEY5XtLS5FaLco57icR
t+Po/HDJ92mfmsJugaq0/Of03zkHSuelkaaljfcNPZV/y2hn4H/ru5XAci99
QZEa7DotpeD+vwhHo8nR3sGUjsHhVLQxOJwV7e3RZPeyCPEKX7s0nBTt2XTU
3ZvytQa9xDOpSTZZfibm9pGcC50zJrFFhAMVtI4mdI1IvCrIRDB9pmNrMKVX
PG0xxQkaVMIreYBzobt2JdarUq3CLhKeIb7jM3ppE13FBtHpNNY/mDKtRKbQ
T1emRFFLyJpNqtlUJsmMXzZ29sc0rrs7pYMGEBsR5Sbto0DkIKLnE2uH3T2h
AQdd3NmfMDktulx0CYcuERl8CD1M3zHfe7GaFB0S7ubWjMbTwQYca3cvif1A
ZSEYTF7/kEkQvRVtTArGadMLyaK6JnojWgBEeqMxRYsEEks5jfch4wkWWOzR
3WwaxUY1nmHMdLrP/E0GhDd8WeRNDO7uTzbLIzpoMJ121xDtHr2UIjf6QGIR
ycg5dMdjGAU2NXXXXpHnkAHQDay5FqGH92xkob9jrYgZ7sGbCVKXHktskDHR
QVeH4xkRIUZ9k+UjxrK5wejEKh1bWXi/YTyC8jOcZEo4Yj2EUZQETpdEuhV4
HlqpFzeFMfgEOsjTEhlE/aW1x/61nBMS3WEnTbHRF5n3RNJwFS2eNqWdrOzk
bvFV+r61uTOTuUWwfHMe7i+tlcBJwLLYNGju4aALhAJ5ONyC6fipsasa3by5
MxWvwjaRhXwHHB4qh3TAPwov8tRdMSyxOPgJNq9ppdde45fO0aRPs4yOzT6v
v4K/m4V/y+Jj5fb4xHPRhbtz1i2MD8jyJ1U4x34uzxAaqm5vSgeNovv2nhMK
xGY7kQ50dSYi6DniObZHYzFIouGIaeAXmugDfcrrMh6aIDUojXSu3/eyaLnB
nLMrLd36SWfiR5gWgR8JNj1/8CaPJgihg0BnoKsfPzWN9RK9lOK26QPBCZfi
sWSijXDEfN4NZE0HUOk0zuOAGcYOcbYRr2pPgZ7GzCh8XxD5Lsjo4vNjwaPQ
l9wVPFYLVow5TMqj5VBjLqFwgCn7ttAvnyta8jlam1RE/6hO/xKK7DkXEzlq
WxLRL+GLTyU87zh+6CCnr6PZue/zUcAfsVky0W5WiJfmoW+xDNgsKa4Zgjew
J3lRbj2igbvAtnKz/vj8wMjKPm0Rf/K4ruhKD/rCyIQXlxvy9a5Ih7UmQSOt
7DyKOb2ctLtF9J2NzuKcs0XqYq743UZNbIxikWX/QDlDzFTj7Z6zSGEMvNHp
4TO0yOeEuxW8ndRUOLbqH2DNJmPznIwl7i9KZAmeE55vH8qdjgOdg94jHiQt
MO354jWBo4Z2n0Mv2L64Y5EpKBFiRpaS3xud3e36HIhrJun1h3sLZV/DPCy8
qr8Qi8K86uNAZw6JT7NwRPKclRBLOGAfYjucb8KXIdCilSae6580WMzRuqJ7
3RMGK1JiaJeW0QeCFa1yJiShbeU8nI2p/mACz62oiL6u5CIb8adizvCnxCQA
bK4m+cPnpsmXHmdJmG1G8rpOWHPAM2Cnj1SGVSTDa+vxfHphhcea/zPkIjUQ
L/3rec9Uyh7Ldbo/wJJzlIckSp2JpnUd11pd7HPTKH81yBXJjx3OPPJICgEA
RdVPYmH6QJfzny5VRbZIetJwMrOx03SETEErXTyA45SZ0wx738E5PfFx8ETH
mT4R8ao8Uco8o0gLy/j/kiXHGXfX6c9IiQHTCJZQOnshzeXVpVwdkZRWHUIK
WEfJKJDKK4X0rfIl3obmaAVJkR7tcrV+eH+yeKG0S8wjOjhyEMlOZuEoVB9p
2pBAUYAzkoXkYX4h56iE1TBpUdO8xejMwynyBc1hpZBFL3lYXGNt6WjMNoB4
OQKFP6IWPBVIRPGMlWcnnyZ5qsT+YIJtpzVo8dioJ2FEJ1ounKURV4mXzpya
c8wN/2hSFsllMTFHOspoBGjn1ddYr2nEHJu6R+cehUtlvWd9DukFhT7U5YnQ
60b9fonQHBN5vr92vlntxwkrQh25xw0UBFXRGNTlyYYogadDR9kZeLocNvfu
lAbOlpd4vi2jLJ35ODpPwM/DBD/SVURuQB/KaARiIR+zlpaPdL8wixPbT4p7
5rF8HiSpRacBXaa26kN6EBxFY6prFyjuezThpvO0j4zMsgmowtTz+vZ+BF0X
RKbhqpbf45nzWxo9cmEO6D2braHbwmhGnBYd6FauI9rvrO0gdPUrNukP4WFs
beglocUjsbMkx/77vF7SfaOrdi2qc5EC/Cc99FVLHwFKTyKiJg/tnn0KBZ8j
jXjjmCH2EQ7Z+Mhkcw3R3rf2Uou9SVywF64d6AhrMTccPWQ1nI9eRgc4ryv3
nsWrWUwleIQ6RFwpEQgWu+JHxuY+6KHJXdl4tuvo4zyKc6owXvZx3o+NzeFg
wSzJvN7X25E+wsgVWrMaC7GQ0chcGK0n1lsLsHxEjizAryCMx1mAnuN2Dm6y
MG3vFHYHy3B7LwK7uM3nHXhlOGZ2JdtZGHetFQZ8oTeNYNK4OebH3FKu/CpA
AzmtWlPEN+V8cFjLl3lxR6xPX5TRiNuKx7kwjMlIqJ+H5/rOMV4vXsulXzuX
T+X1et8wQd62JE7jrrLYfemu0Yc8nNcT+pLIBIpwcZQfwV1k8VO8xKLNaJBt
rCsiOvY+Fgh9MbZHxYh3jGZUJbpxmIrpLnm0M8osjgS5+yyxQLcKakaghcsc
sqITRdKl9nVO3aHA38RULMZvp2g8QQb3MytDu5/MBHWZ2rz2dik8lEe218C7
s3haLqY/KxNaZb+7zebOjoNt4zO5ZZTEmU9E5wkynzsBH15+lY1kXH3Ac/EL
sSXiAoV13Z+ztwh/pTzuNNy8toAbpEBiyTT7xG9obwOsGnECe3X7MSv3UM+A
i9vG1bbd7qZWn4uQ3rZcvKd7wt6w/Jh6RnJaflbzR7es/EPOeGcCREw8YE4M
HN2/sta0PdL9TuzO+ikJLfFKyd09T4GW9Krwkya0i7wq1Pcl+1GiNfRTR7Ln
JHpK3s4difVdPQwc+po1+GNOENvA/wia2Fj/cLoS2s0Ep8460bq11jm2kr1r
kSFWyV/zdgqdL9qrSS32A5uJ13aO32wfemTXVZ56WXg3FuDRq9oo0y/x/ZHH
kb49fZ+H84o+pR1KD4pXK/E0iPRK7XLzXJjwnek9VjHOy5ny8yOYL95D5ddE
I2H0euK9tFRfMd5vLR6qntAcjcvDu57C43yUtMJqLFWvkt1uYHcojB77GUdZ
KFedVfjdtMhOuZcaxjKeEovIFTC3hyAb8VjOWQxSvLD1k4lG7a4C5vG4IsGV
TM7qEHiwR9tfQ7QrAZq3EaChumfn9LsG3XfJC3A3Xc1DmVmddZ3OjHRogVLE
HDGW7EfqQGEOLpMruIpBTYaId2mxrHVSh84Pv28xeR3ctTtcL68lHvYN9aM8
UuQ5psN1bpkCv2K+5zSITcLIy/MQx82ItZreUOr2rOr71ipxx46U5GT3Vhox
9RvtOGKTXYi6AxHc+Tkf4vPHDyw+2CQr4i1U8a/QUqj135OFr6tmjpeTUkON
E5S3E1TLnh/ZdQQlWc6LrTCmjEjLyBxPnwmfMT+nzITbiRE5vc39Ji5oJQq7
zAM3c8SWdP1we+zVktuRnebp4iS0h+eyt7MfVFAx7bHG0nXue4n14/cldLD1
x7+5zKHi7DviVUL+1lvWqxF+jO7l5DVuJFFy9H20l3MJVQ28rbDL4hx4MPNe
qTl/HCToCWams2k/4iNLjZHCYgHqvc3HMzS9LvQX4AY1DBrw0OLZX6XRtbz9
rz19AnSASZqSL3bZam8Hc3QFFNTm/Grp1pMdyq9HY7UAj/bA6PrdFgFKDssy
XEc01IoH6ShPVu/YOqRrvyH9nwo6w8998nYSy+/jB3Px3iSM91gzumd3WqEP
6sKSPJSLAVcu6nKZwCRpIw4R55Ak/0pvTRG3rJ3UNTeOs4F5PNYccp2eOP+8
XdibSUvB2piO8z71OjxyuVU2Huzc7fouapFdFUV2WkH5TG50fpQOXtuuZOG5
lT30IYE8gwhG0Zg/FzXrzpSD6Tqiac2uXokNEL3+IGHv6xnV5Vs7Nt9aIlW/
dwjq050WiEWG+nOT0FK+sCglFIfA/LgZobZLvuO4i1cAz8fnJshRnVE9U4TY
1nUu0TGw9Rf/dNkdW8uZRIfZCKVFqK2+rBLZW1wGTx7z1bynNsc2ft5+qZQP
tV2IePNajvUY7DXF70a95caSf2Q0k9jVTEJnzNUkBq9AfLE8e6xahMYY0juf
25XQriND7dLF7ERoIrtEdhFLL46jLzXitiWE9VbcUQ0+DqwASC21AierrOef
y19+ec4o+b5xtP1rQf/Rd4nGGv9K0Iu/W/fi79Y9a3m8+Lt19fEv/m5dJIsX
f7cuJZX/u79bV1z4Hx7YGT0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->417875906]
}, Open  ]],

Cell["\<\
If the matrix is multiplied with itself the result is less sparse, but it \
still has a related structure.\
\>", "Text",
 CellID->1013075101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"sp", ".", "sp"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1502869091],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->473599364]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import and Export of Sparse Matrices", "Section",
 CellTags->{"t:120", "c:63"},
 CellID->212323487],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a number of different tools for I/O. You can save your data in a \
file so that you or a colleague can continue to work with it in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " later. For this you might want to use some of the expression I/O \
functions; these are discussed under \"",
 ButtonBox["Expression Input and Output",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraIntroduction#1564598842"],
 "\"."
}], "Text",
 CellID->1550508342],

Cell[TextData[{
 "If you want to work with matrices from a source external to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using specific data formats, the functions ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " are useful. The ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " function supports a variety of different formats, some of which are \
relevant to sparse matrices."
}], "Text",
 CellID->1827131296],

Cell[TextData[{
 "There are two formats that are specific to sparse matrices and are \
supported in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ": \"",
 ButtonBox["Harwell-Boeing",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraAppendix#1350971188"],
 "\" and \"",
 ButtonBox["Matrix Market",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraAppendix#1964229445"],
 "\". This example imports the matrix in the file ",
 StyleBox["dwg961b.cua", "MR"],
 " using the Harwell-Boeing format."
}], "Text",
 CellID->1727023419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"Import", "[", 
   RowBox[{
   "\"\<LinearAlgebraExamples/Data/dwg961b.cua\>\"", ",", 
    "\"\<HarwellBoeing\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->693630281],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "10591", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 10591, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"961", ",", "961"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{225, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1302896851]
}, Open  ]],

Cell["\<\
The result is a 961\[Cross]961 matrix of numbers with 10591 nonzero elements.\
\
\>", "Text",
 CellID->2044109945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", " ", 
  RowBox[{"sp", ",", "NumberQ"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2059944556],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1904279405]
}, Open  ]],

Cell["You can confirm the dimensions of the matrix.", "Text",
 CellID->1275168594],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "sp", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2019245945],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"961", ",", "961"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->782524074]
}, Open  ]],

Cell["\<\
If the matrix is multiplied with itself, the result may not be as sparse as \
before.\
\>", "Text",
 CellID->692257490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", ".", "sp"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1852718631],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "40849", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 40849, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"961", ",", "961"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{225, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->129149717]
}, Open  ]],

Cell[TextData[{
 "Many examples of matrices in Harwell-Boeing and Matrix Market formats can \
be found at ",
 ButtonBox["http://math.nist.gov/MatrixMarket/index.html",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://math.nist.gov/MatrixMarket/index.html"], None}],
 "."
}], "Text",
 CellID->1660810149]
}, Open  ]],

Cell[CellGroupData[{

Cell["Matrix Multiplication", "Section",
 CellTags->{"t:119", "c:64"},
 CellID->243730537],

Cell[TextData[{
 "Matrix multiplication is carried out in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with the function ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 ", which is typically entered with a dot short-hand syntax. The operation is \
fully supported for sparse arrays."
}], "Text",
 CellID->1127820530],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", " ", "=", " ", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "4"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", "1"}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"MatrixForm", "[", "sp", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1588979288],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmL1uwjAQgB0HKH9l7shrdOnYsvQhIlQJhqoVZcjGmDFjxjxCRkbGjBkZ
GTMyMqbnP2wcI7BIVKQmUnK2Oeezz2dzl3dvOfv49JbzqTd+W3jfs/n0Z/z6
tYAm10EITeB+fkJQLqBE70lRgFSfbfJ04zgu6IVceLigOgDZ5pLUh1w+UKXV
aqXoI9Sixe12u16vj62keyEuKKP+za0dMdosy3R6FEXqmEp9B/SnYyurW3EP
h4Pv+5LrilaGZuMo9R1qXJv5MmsHQQAQUsRHLk7TtG3s86jxetY8WERYylMe
tW+e5+fnOdK4XWuu9B+VK33NzL3dqxgdTMy2wRk6sba6E3TZE1bi+o7xLS9a
/f9qXWfPS2+pyye6Db2h3ym9mp1zr+fC359EIvbpc1m9T+gxgV5viA2xTqLp
BMGIxY5YsO9wp1avFYbhFVoyP1K1INbb7/eqPUdc9jX7slXZ7XZJkpCiGmFC
yMuzmbri6s1mY4jnYeh8NOf9ryP+Tax4YNOTfOW6/KyqOF6unaRjsLB5ljQL
bEnr2uejGKxI381zaTlPbOyj7ljbGXZMluRclpzVyZUExhXfBoiHYlT+VkAz
Uf6dATm/1pqPRA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{72, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->771625866]
}, Open  ]],

Cell["\<\
The sparse matrix can be multiplied by itself; the result is also a sparse \
matrix.\
\>", "Text",
 CellID->2037582172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", ".", "sp"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1869329742],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "5", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 5, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->241019553]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1230326905],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmL1ugzAQgI0JNClt5o55jS4d2yx9CBRVSoaqVZqBjTEjY8Y8QkZGRsaM
GRkzZmSk5x+wY7kKbhKKVJDA9ulyn+98mHNe/cX07d1fzCb+6GXuf05nk6/R
88ccRLaFEBrD/fiAoF9Aj97jooBWfjrkaa/X64JeyIaHDap3vPWgdaC95a1L
lcIwlPQR6tHubreL47iSEvWivBC3cZ7ULWe73W5V+mq1kudU06JHf1BJqd/y
+IaO8zwPgkAQ7VLKoGwGNYkqQU9cLpdgnnRxRcRpmjoGpPsTJBZNWDJYuGMS
jeZ+vzf1bXiCyLJN5IlMFDllQjSRVmvJ0v0HOpmj/Aao7aCMD9e3tFaelPH/
1aoXz1NWrpUT/Y7e0VtKv8yb09Z94e92orKm8X4VzzZmpFrFeA1x1e97U/6q
lc2gIa5a3/Qb4nY7TtNaURTV0BLnJlkLasPD4aCL51AZswo8y7LNZkO6ckUK
JTI/5Vy+Ak+SRFPzw6T5PEyz0OW54VY+QfyOzi/nnNHMa3yxToKOIZomftE9
tCcip5MQXzHEjNrlsRU+YgOavE66sauLHyeyg9p1iMI2I6rfTJJvmO/IuLTC
/1tA1jfyTYBT\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{72, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->5890135]
}, Open  ]],

Cell["\<\
This multiplies a sparse matrix by a dense vector. In this case the result is \
dense.\
\>", "Text",
 CellID->1668009432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", ".", 
  RowBox[{"{", 
   RowBox[{"4", ",", "5", ",", "2", ",", "1"}], "}"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->982995686],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"20", ",", "3", ",", "0", ",", "10"}], "}"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->203343554]
}, Open  ]],

Cell["\<\
If the vector is made into a sparse array, the result of the multiplication \
will be sparse.\
\>", "Text",
 CellID->624304348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", ".", 
  RowBox[{"SparseArray", "[", " ", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "1", ",", "1"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->78077594],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", "4", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->663054920]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->39299268],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVrtugzAUNRhKq6qPMWOUv+gPtFM/AkWVkqFqlWZgY2RkZOQTGDNmZGRk
ZGRkZKTX1yZ2XEKhqlClFAnbwDnHvg/s++xuVy+v7na9dOdPG/d9tV5+zB/f
NvCKGoSQBdwPMwLjBkZ4L5oGerW1WUvjOG7wIiY0NkAp9BR6B7/7vi++U2RZ
OMzzfLfbsSFXYTNIFWIfnpFDyEU7V5ZlulYURQI4Rquua8/zpBZt33I5gfpO
i9sYBAEQDyjUMtM0dUZogDvAKccaaFtZlmPXI72raslIjNECw3iIT2gxn5uE
ZwOTvNJiYnSyZtrz+aJav90PQmPGf4nU3T/3l7njovJXc2t6FPO5PVmE1D1s
WKT0nW/YXPo+fjuIdamxbibxyXllbRiGA1CyRlFRcEZVVdX6XK1ceOSKokiS
hA3Vkw8OVlGDdEeq7yzd7/cdZzwsQsyj5zTt0QLLj2qOn9VCeo0mtUyw0unk
UE0Z0WABrkDMK9eBf5wl0d18lUEVHV78nF5/X4UnuVzxuuHRtUSP/6OoZYnx
CdhMm2k=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{34, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//MatrixForm=",
 CellID->370907787]
}, Open  ]],

Cell["\<\
In general the result of matrix multiplication will be sparse if both \
arguments are sparse. This is not true if the default values are different.\
\>", "Text",
 CellID->1693002046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"sp", "+", "4"}], ")"}], ".", "sp"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->127064372],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "24", ",", "8", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "26", ",", "4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "24", ",", "4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "24", ",", "6", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{382, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->707342426]
}, Open  ]],

Cell["\<\
What is particularly important about sparse matrix vector multiplication is \
that it is fast. In this example a 100000\[Cross]100000 tri-diagonal sparse \
matrix is multiplied by a dense vector.\
\>", "Text",
 CellID->954944026],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "]"}], ",", 
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}], "]"}]}], "}"}], "\[Rule]", "1."}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"100000", ",", "100000"}], "}"}], ",", "0."}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"vec", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Random", "[", "]"}], ",", 
     RowBox[{"{", "100000", "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[9]:=",
 CellID->1598950951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"sp", ".", "vec"}], ";"}], "//", "Timing"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->2105758546],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.5265566588595902`*^-16", ",", "Null"}], "}"}]], "Output",
 ImageSize->{147, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->8584415]
}, Open  ]],

Cell["\<\
Another issue with multiplication of sparse and dense matrices is that there \
are differences in the speed of computation depending on whether the dense \
matrix is on the left or the right.\
\>", "Text",
 CellID->1083211767],

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Random", "[", "]"}], ",", 
     RowBox[{"{", "1000", "}"}], ",", 
     RowBox[{"{", "1000", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "1."}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{"1000", ",", "1000"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[12]:=",
 CellID->1321292350],

Cell["\<\
The first example is slower than the second, even though the result is the \
same in both cases.\
\>", "Text",
 CellID->1979616470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Head", "[", 
   RowBox[{"mat", ".", "sp"}], "]"}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->449868319],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.34400000000000014`", ",", "List"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->2582619]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Head", "[", 
   RowBox[{"sp", ".", "mat"}], "]"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->1367827530],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.03099999999999957`", ",", "List"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->279840503]
}, Open  ]],

Cell["\<\
One possibility to improve the speed is to convert the dense matrix to a \
sparse representation. Now the result is a sparse matrix. \
\>", "Text",
 CellID->1841532441],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp1", "=", 
   RowBox[{"SparseArray", "[", "mat", "]"}]}], ";"}], "\n", 
 RowBox[{"Timing", "[", 
  RowBox[{"Head", "[", 
   RowBox[{"sp1", ".", "sp"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[16]:=",
 CellID->1101415323],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.030999999999999556`", ",", "SparseArray"}], "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->749660048]
}, Open  ]],

Cell["\<\
Another solution would be to reverse the order by working with the transpose \
of each matrix.\
\>", "Text",
 CellID->889940882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Head", "[", 
   RowBox[{"Transpose", "[", " ", 
    RowBox[{
     RowBox[{"Transpose", "[", "sp", "]"}], ".", 
     RowBox[{"Transpose", "[", "mat", "]"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->12802419],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.04699999999999953`", ",", "List"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->168769642]
}, Open  ]],

Cell[CellGroupData[{

Cell["Outer Product", "Subsection",
 CellTags->{"t:206", "c:65"},
 CellID->1885795684],

Cell[TextData[{
 "The outer product is a way to build a higher rank tensor from ones of lower \
rank. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides this functionality with the function ",
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 ". One use of this is to combine two vectors to form a matrix as an outer \
product. This works for sparse vector input to generate a sparse array."
}], "Text",
 CellID->2004398562],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"vec1", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "0", ",", "c"}], "}"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vec2", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "y", ",", "z"}], "}"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Outer", "[", 
  RowBox[{"Times", ",", "vec1", ",", "vec2"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->350661045],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->64252854]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->531011039],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVjFPAjEULndXQXBSY1wMqImLf8Do4GCi0/2ICzGBwWiQgY2RkZGRn8DI
yMjIyMjIyMh4vr6+0l7p4Z0mxoFL7l7f62u/r6/v2hdG7cbrW9Ru1qPaSyv6
aDTrn7Xn9xaY/AJjLIT39pxBO4YWvmEcg5Tfa/gGYLxBjYuvPxwOY3zYBepi
jNSrqHe7XdJ9HBVgcz6fj8dj0RS6GHREsmTNUiH7AUhOElFns5k962AwMLH4
Zhb0YazstBZBeiArzl7utEoW6/W60+loFr6ySiKSlZuFsUJzxUzxSOnXeq/X
AyDR9DbY3nQ6dfN1YgZa3/Y4tPQi6rBpsHVJVIz7crn8ZsUZI7vDN8FXRkHn
kclH55ybj4iwmEzlnnRTT5l6BSan/MBdlameC+lexYdMBedYTjweLLvb+2nv
ZcVNnR1nJE8yjc6Tq6dO6/EeZ4+TGed32fpf/8FsXqI2EGfqFdr7/f5O7yrq
+rS/RF1XGuYoOFtXq5UdX10p6FkqZA9i81xfLBaj0Ug0zXMdLhWqL/Jkx08q
CcliMpk47lVYGHHLw8JcN0tlY0enpHYmUVVkq6vUfYpzJm5p1VO00KSud1yj
eRD3v6sicMcgxrIA4NZqvdTV+jSbu3rYrletCBKSLJrSke4sLzlW4T+iJitz
VvgCtOa1+A==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{77, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->362728771]
}, Open  ]],

Cell[TextData[{
 "This generation of sparse outer products can be very advantageous if you \
want to use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sparse arrays as general sparse data structures."
}], "Text",
 CellID->84111244]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Matrix Permutations", "Section",
 CellTags->{"t:150", "c:66"},
 CellID->1180395712],

Cell[TextData[{
 "Many matrix techniques rely on ordering a matrix in particular ways. For \
example, some techniques try to order the matrix to put elements on the \
diagonal, while others try to group certain elements into dense blocks. The \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " is very well suited to applying permutations to the rows and columns of a \
matrix."
}], "Text",
 CellID->456800598],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["perm", "TI"], "]", "]"}], Cell[
    "apply a permutation to the rows of a matrix", "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], ",", 
     StyleBox["perm", "TI"], "]", "]"}], Cell[
    "apply a permutation to the columns of a matrix", "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["perm", "TI"], ",", 
     StyleBox["perm", "TI"], "]", "]"}], Cell[
    "apply a permutation to the rows and columns of a matrix", "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["perm", "TI"], "]", "]", "=", "m"}], Cell[
    "apply the inverse of a permutation to the rows of a matrix", 
     "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], ",", 
     StyleBox["perm", "TI"], "]", "]", "=", "m"}], Cell["\<\
apply the inverse of a permutation to the columns of a matrix\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->193612561],

Cell["Applying permutations to matrices. ", "Caption",
 CellTags->"S3.7.2",
 CellID->608587522],

Cell["This generates a random matrix.", "Text",
 CellID->65871593],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Random", "[", 
       RowBox[{"Integer", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "3"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", "4", "}"}], ",", 
      RowBox[{"{", "4", "}"}]}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1149785346],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "1", "0", "2"},
     {"3", "3", "2", "2"},
     {"3", "0", "0", "3"},
     {"3", "0", "0", "2"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {4, 4}, 0, {
    1, {{0, 3, 7, 9, 11}, {{1}, {2}, {4}, {1}, {2}, {3}, {4}, {1}, {4}, {1}, {
      4}}}, {1, 1, 2, 3, 3, 2, 2, 3, 3, 3, 2}}]]]], "Output",
 ImageSize->{76, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->1384454516]
}, Open  ]],

Cell[TextData[{
 "Now the matrix will be reordered so that the rows with smallest 2-norm are \
first. (\"",
 ButtonBox["Norms",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraMatrixComputations#832278785"],
 "\" are discussed under ",
 "Matrix Computations",
 ".) First, the norm of each row is computed."
}], "Text",
 CellID->541735167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", " ", 
  RowBox[{"Norm", ",", " ", "sp"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1759772136],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox["6"], ",", 
   SqrtBox["26"], ",", 
   RowBox[{"3", " ", 
    SqrtBox["2"]}], ",", 
   SqrtBox["13"]}], "}"}]], "Output",
 ImageSize->{172, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1345503268]
}, Open  ]],

Cell["\<\
This computes the permutation that is necessary to reorder the matrix.\
\>", "Text",
 CellID->870622366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"perm", "=", 
  RowBox[{"Ordering", "[", 
   RowBox[{"%", ",", "All", ",", "Less"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1744018351],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "3", ",", "2"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->712127354]
}, Open  ]],

Cell["\<\
This applies the ordering to the rows of the matrix; the result has rows with \
smallest 2-norms first.\
\>", "Text",
 CellID->798073947],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"spperm", "=", 
   RowBox[{"sp", "[", 
    RowBox[{"[", "perm", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"spperm", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->45968067],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "1", "0", "2"},
     {"3", "0", "0", "2"},
     {"3", "0", "0", "3"},
     {"3", "3", "2", "2"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {4, 4}, 0, {
    1, {{0, 3, 5, 7, 11}, {{1}, {2}, {4}, {1}, {4}, {1}, {4}, {1}, {2}, {3}, {
      4}}}, {1, 1, 2, 3, 2, 3, 3, 3, 3, 2, 2}}]]]], "Output",
 ImageSize->{76, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->1638672796]
}, Open  ]],

Cell[TextData[{
 "Now the inverse permutation is applied using part assignment. Note that \
this modifies the matrix held by the symbol ",
 StyleBox["pmat", "MR"],
 ". Part assignment is described ",
 ButtonBox["previously",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraSparseArrays#1033045979"],
 "."
}], "Text",
 CellID->1843393244],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"spperm", "[", 
    RowBox[{"[", "perm", "]"}], "]"}], "=", "spperm"}], ";"}], "\n", 
 RowBox[{"spperm", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[7]:=",
 CellID->163676639],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "1", "0", "2"},
     {"3", "3", "2", "2"},
     {"3", "0", "0", "3"},
     {"3", "0", "0", "2"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {4, 4}, 0, {
    1, {{0, 3, 7, 9, 11}, {{1}, {2}, {4}, {1}, {2}, {3}, {4}, {1}, {4}, {1}, {
      4}}}, {1, 1, 2, 3, 3, 2, 2, 3, 3, 3, 2}}]]]], "Output",
 ImageSize->{76, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//MatrixForm=",
 CellID->2134203513]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Converting Equations to Sparse Arrays", "Section",
 CellTags->{"t:140", "c:67"},
 CellID->139087150],

Cell[TextData[{
 "Matrices are so important in many areas of science and technology because \
they are an efficient way to represent linear systems of equations. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is unique among technical computing systems in that it combines very \
efficient ways to work with matrices and also with the equations that the \
matrices represent. It is easy to go from a matrix to a system of equations \
and back. Here, a sparse matrix is multiplied by a vector of the unknowns and \
a system of equations is formed."
}], "Text",
 CellID->1175522114],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", " ", 
    RowBox[{"{", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "3.1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "3.1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "1.1"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", "3.2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "3.2"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "1.9"}]}], "}"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"eqns", "=", 
  RowBox[{"Thread", "[", 
   RowBox[{
    RowBox[{"sp", ".", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "\[Equal]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "6", ",", "8"}], "}"}]}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->150617598],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"3.1`", " ", "x"}], "+", 
     RowBox[{"3.1`", " ", "z"}]}], "\[Equal]", "2"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"1.9`", " ", "x"}], "+", 
     RowBox[{"1.1`", " ", "z"}]}], "\[Equal]", "6"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"3.2`", " ", "x"}], "+", 
     RowBox[{"3.2`", " ", "y"}]}], "\[Equal]", "8"}]}], "}"}]], "Output",
 ImageSize->{337, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1694233420]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1495414367],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"3.1`", "0", "3.1`"},
     {"1.9`", "0", "1.1`"},
     {"3.2`", "3.2`", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 3}, 0, {
    1, {{0, 2, 4, 6}, {{1}, {3}, {3}, {1}, {1}, {2}}}, {3.1, 3.1, 1.1, 1.9, 
     3.2, 3.2}}]]]], "Output",
 ImageSize->{103, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->1428145328]
}, Open  ]],

Cell[TextData[{
 "These equations can be solved with the algebraic equation solver, ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 "."
}], "Text",
 CellID->413805177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"eqns", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1271560853],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "6.612903225806452`"}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", "4.112903225806451`"}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"-", "5.967741935483871`"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{272, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1513485074]
}, Open  ]],

Cell[TextData[{
 "However, it is a bit more involved to go from the equation to the matrix \
representation. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides the function ",
 Cell[BoxData[
  ButtonBox["CoefficientArrays",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientArrays"]], "InlineFormula"],
 " to make this transformation easier. This takes the equations that were \
generated above; the result is a list of a sparse vector and a sparse \
matrix."
}], "Text",
 CellID->199840003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientArrays", "[", 
  RowBox[{"eqns", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->46506513],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{
      InterpretationBox[
       RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
        "\[InvisibleSpace]", "\<\">\"\>"}],
       SequenceForm["<", 3, ">"],
       Editable->False], ",", 
      RowBox[{"{", "3", "}"}]}], "]"}],
    False,
    Editable->False], ",", 
   TagBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{
      InterpretationBox[
       RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "6", 
        "\[InvisibleSpace]", "\<\">\"\>"}],
       SequenceForm["<", 6, ">"],
       Editable->False], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
    False,
    Editable->False]}], "}"}]], "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->2098400130]
}, Open  ]],

Cell[TextData[{
 "You can see the details of the sparse arrays with ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1834533876],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1588133953],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "2.`"}]},
       {
        RowBox[{"-", "6.`"}]},
       {
        RowBox[{"-", "8.`"}]}
      }], "\[NoBreak]", ")"}],
    MatrixForm[
     SparseArray[
     Automatic, {3}, 0., {1, {{0, 1, 2, 3}, {}}, {-2., -6., -8.}}]]], ",", 
   InterpretationBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"3.1`", "0", "3.1`"},
       {"1.9`", "0", "1.1`"},
       {"3.2`", "3.2`", "0"}
      }], "\[NoBreak]", ")"}],
    MatrixForm[
    SparseArray[
     Automatic, {3, 3}, 0, {
      1, {{0, 2, 4, 6}, {{1}, {3}, {1}, {3}, {1}, {2}}}, {3.1, 3.1, 1.9, 1.1, 
       3.2, 3.2}}]]]}], "}"}]], "Output",
 ImageSize->{170, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->693099508]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CoefficientArrays",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientArrays"]], "InlineFormula"],
 " is general and will work for non-linear as well as linear polynomial \
equations. "
}], "Text",
 CellID->972129628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"s0", ",", "s1", ",", "s2", ",", "s3"}], "}"}], " ", "=", " ", 
  RowBox[{"CoefficientArrays", "[", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"3", "+", 
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"5", 
        RowBox[{"y", "^", "3"}]}]}], ",", 
      RowBox[{"1", "+", 
       RowBox[{"x", "^", "3"}], "+", 
       RowBox[{"2", 
        RowBox[{"y", "^", "2"}]}]}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->527071420],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM1u2zAMViw7P22TJthQpLdswNCn2I7tYetl2AsExYD2ULRo+yrt63qS
TSYqTZuSY2+LnQCOTOqH0ieKor/r9cvt7/v1y93NenX1tH68vbt5Xl0+PBmV
Hig1eFVKfVoq856at+yxvzfz5K/528z8a1P51ZSxKRNTRqY8t7Uae6XqiMgT
Ip8KcgzjJkQ/bcj+vKH56AwV2vob09uVlzAaneUR6OdQLoRxNLRr2v4icB5U
jjJUxllVrlXZT8Ou2fYJKhTUmSdy6m2Zw40/NML1SkCNZdXshkROYIyqNmNm
hQnMlPYL0UvysIcYjv4StlsvjXD28bYWMChqko0GIExYLUUjZltJOPMWy6IR
6vleGC2GUNKYGFXaGtWslXYEex/2QN6D8T/ZoeKZOeF3xWOfJoV2eHrr7YLb
a+MHZL6IN40ZVj8TrEp5AR2XrmLRG6RCMyoJOTq/QerleWl+63EYacXfb77n
IC5aK+lZlin65FI+mWiVLHrc3iNUJ3cPj3ETBw+vuwna8XcMH9c5jBGZ0LGk
DI2PCh9IK7onErZSLMLvxX6jGOqxEqoV31vMeXJzffeU0zr8stDQxrWiSvpE
JePgN4XegKqcWneWUyJ/FHZAwo7N+SrsdROlUI+TUPPzOLvGC6JbETnLawon
6Iwbv9BqGqCVVkARbXvus9ZXVH6Pub5n/7+A7jOUx2nug0tmBCuekrLsRp83
YGseaJNn5Owr5S7D3zhmwoq7so9ts5u+7OWPbJU01tDR6rKJx0K/NtlLH7vX
7OrdDGUbi7vNuO01C/kud9RMr6a5XEn+npb51YHjQiQOXGGbOO7OyOY3A8Vk
VBvzfWOzusfr8V6PGUYoDyrh8zPlYiCJ10XU0n3nprrDzlXHpFAWU5of7y/4
jdxv9qgXHJsQS0N5Sgkz3t/ofddNbqibDJkfNyOxiRI2fn7TNpf0v3Fb9fiq
HEuOtdqVQ2qTn5L4qF/Z0FblwzCpwR+WF+6h\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{405, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->285198576]
}, Open  ]],

Cell["\<\
When the input is a non-linear polynomial, the result will include higher \
rank tensors.\
\>", "Text",
 CellID->1675633804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->276797070],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXLtS20AUlW0c/ICEx0wmM8lM6PIHSZE+VPkID0MwRSYeQkFHSUlJSemS
kpKS0p9ASUlJqdzVXbHi+Eor2Wt77WxmAN2VdnXuOfu42kd+9k77h797p8cH
vb39k96gf3zwd+/HnxNKatSiqPY1iqLvHyK6jukq+VH/vtEPX/LVQP1upHfj
aBPsLcv9L2B/BHvbcv99guJXkvr4+Hh7e6su38BTTfqlzHVIfwv2Gv1qkon5
2R6NRjc3N+pyN7HpZQ8PD0Xv29B/8f67is8zbno5uaguuxmvLy8vX6F87U3U
fLGTPONlSxzYczGiwWCg7Z3Evr6+roSlI6Y2LWxNUxbjfn5+ZuiaycM0lR0Y
qyeTMSm/W1D17u4ufqnrVKV0LSuHYv4cthL74uLi6elJXXYyHA6HQ11HpTYx
Xjb6uFGKM7TPz8+1zf1NfpuQUch+Y17su6Ypi3ETVUQYclgVvY3DFtgyFvNW
5pD09ZzDFuBuZzg0NcINh22plMBhJQ7L5WL76upK29xzUUvJ6Zv9YtIoXo5J
ZSsT2yhyl/ccs0HU0OBl2KIxJIettJw00sD7yIjt+Rb4V85rjOrQW7z/4qWO
t2xefrZ4hfcX6cX9/b2OWpfXizpFMFgzA/qAPqCfFD2iQXsX7E9g71i8dzbu
WNhQI6oaOrvxLMebLjzViOXveNQUv7vxbdsWFmcfB9kZxnyLinxQE/WFWY/G
vx7RtmlU5UtVLivoV02/epxRLmlLRfoFPX3Xcw3u12NJV3xKniUwtjSHWRYx
lrUFiIOuq6mrm3nVcrmYrXFdcSYH881/PrUNLAVdi3IFXV/bmF+cqZxQZyy7
Ax5Jc3FSHC2tjORH90ZbyTdJa1Weilg2YzfrbW6US1Eh2oZO70A6fvvgCJTm
6wI6fK7qGmxbYD3Fp9hGnFXXaLHWTMYmeoH3kYU9y/Oo8T6wIJWv2Dgq5U0d
UrFvkLyR6orkhak7xejT8iTUiKeWoGYRksScPj+/TSFSHCMQYdpvIzLVCmpU
jEJUm4jLWSGTOatab2eFzk2rWi10rnvG1Ds/esR0FEMvkSXbuGKL5lyP6nkR
m+tdM25GcTkC/N+ja1/2orjRWJq1DurOUl3EL3/FLLOuPs5hzX6vhFgvxxRx
8U2solvbyBf0NKmT6Zm3bldOx7w1ILHPK4ifVn3NYD46FilQvAYkra+WZT6o
uDgV5dVxpYPUpl2vjs9rj8E0e9rWBC0WsyPD7/0oy72bJqAP6P1Fv8Q7WfUJ
ED+8SPea2UZ963ijbZ/2UuefJJCjFTcxz2qdZ1gMh+Ykw7KcTWoB7iyHw+FQ
nzSYJ4dGuWXhkHGbE4XZ810mdT4c8lvMOQPVm9dHo5E0z+8Pd6SxPknI3PFp
1/wTpjZ7mnOu/X5f13qO4k3b8PWcK7fhs7MzbWc5JOmpMsyPQ7ZJTDw9nXNS
1BcOWXsCTYSpSz4rfJR6o5+S9sNKc5NlV8veQPnMFlU/HWtJPV42qph21Wwd
3s9e+3HOX13y/zsQ1f4BAZf9qg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{310, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->547405064]
}, Open  ]],

Cell["\<\
You can still regain the original expressions with dot products.\
\>", "Text",
 CellID->756578152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s0", "+", 
  RowBox[{"s1", ".", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "+", 
  RowBox[{"s2", ".", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ".", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "+", 
  RowBox[{"s3", ".", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ".", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ".", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}]}]], "Input",
 CellLabel->"In[9]:=",
 CellID->558326777],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"3", "+", 
    SuperscriptBox["x", "2"], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["y", "3"]}]}], ",", 
   RowBox[{"1", "+", 
    SuperscriptBox["x", "3"], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["y", "2"]}]}]}], "}"}]], "Output",
 ImageSize->{164, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->1442087296]
}, Open  ]],

Cell[TextData[{
 "The ability to work directly with systems of linear equations can be very \
advantageous for certain applications. For example, generating finite \
difference solutions. This is demonstrated in the example \"",
 ButtonBox["Finite Difference Solutions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraExamples#1711482715"],
 "\"."
}], "Text",
 CellID->660743830]
}, Open  ]],

Cell[CellGroupData[{

Cell["SparseArray Data Format", "Section",
 CellTags->{"t:141", "c:68"},
 CellID->483612173],

Cell[TextData[{
 "There are several different formats that can be used to hold sparse arrays. \
Each has its own advantages and disadvantages. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the Compressed Sparse Row (CSR) format as an internal storage format. \
This can be explained for a sample matrix shown below."
}], "Text",
 CellID->1991671363],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "a11"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "a13"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "a21"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", "a24"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "a32"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "a33"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"sp", "//", "MatrixForm"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1192992152],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a11", "0", "a13", "0"},
     {"a21", "0", "0", "a24"},
     {"0", "a32", "a33", "0"}
    }], "\[NoBreak]", ")"}],
  MatrixForm[
  SparseArray[
   Automatic, {3, 4}, 0, {
    1, {{0, 2, 4, 6}, {{1}, {3}, {1}, {4}, {2}, {
      3}}}, {$CellContext`a11, $CellContext`a13, $CellContext`a21, \
$CellContext`a24, $CellContext`a32, $CellContext`a33}}]]]], "Output",
 ImageSize->{132, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->1711770272]
}, Open  ]],

Cell[TextData[{
 "You can see the internal form in the ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " of the matrix."
}], "Text",
 CellID->2032026292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "//", "InputForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->833451403],

Cell["\<\
SparseArray[Automatic, {3, 4}, 0, 
 {1, {{0, 2, 4, 6}, {{1}, {3}, {1}, {4}, {2}, 
    {3}}}, {a11, a13, a21, a24, a32, a33}}]\
\>", "Output",
 ImageSize->{322, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//InputForm=",
 CellID->1929384487]
}, Open  ]],

Cell["\<\
This format is general enough to describe arbitrary rank tensors. Other \
advantages of the format include the fact that data elements in the same row \
are stored next to each other, which leads to better cache performance. A \
disadvantage is that it is not optimized for inserting new elements into the \
matrix.\
\>", "Text",
 CellID->162003309],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->2398209],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "TutorialMoreAbout",
 CellID->4791866],

Cell[TextData[ButtonBox["Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LinearSystems"]], "TutorialMoreAbout",
 CellID->212289775]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->404196674],

Cell[TextData[{
 ButtonBox["Linear Algebra in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraOverview"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->315063104],

Cell[TextData[ButtonBox["Matrix and Tensor Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixAndTensorOperations"]], \
"RelatedTutorials",
 CellID->3571032],

Cell[TextData[ButtonBox["Working with Sparse Arrays",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LinearAlgebraSparseArrays"]], "RelatedTutorials",\

 CellID->560755906],

Cell[TextData[ButtonBox["Matrix Computations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LinearAlgebraMatrixComputations"]], "RelatedTutorials",
 CellID->335456077],

Cell[TextData[ButtonBox["Matrix Types",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LinearAlgebraMatrixTypes"]], "RelatedTutorials",\

 CellID->472696132]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Working with Sparse Arrays - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 43.1165248}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Sparse representations of matrices are useful because they do not store \
every element. If one particular value appears very frequently it can be very \
advantageous to use a sparse representation. Mathematica offers a sparse \
representation for matrices, vectors, and tensors with SparseArray. This \
tutorial discusses how to create and work with SparseArray objects in \
Mathematica. If you are interested in carrying out linear algebra \
computations on sparse matrices, you should consult \"Matrix Computations\". \
The basic object for representing a sparse matrix in Mathematica is a \
SparseArray.", "synonyms" -> {}, "title" -> "Working with Sparse Arrays", 
    "type" -> "Tutorial", "uri" -> "tutorial/LinearAlgebraSparseArrays"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "t:28"->{
  Cell[5474, 119, 117, 3, 70, "Title",
   CellTags->{"t:28", "c:37"},
   CellID->1619024906]},
 "c:37"->{
  Cell[5474, 119, 117, 3, 70, "Title",
   CellTags->{"t:28", "c:37"},
   CellID->1619024906]},
 "t:121"->{
  Cell[6679, 159, 86, 2, 70, "Section",
   CellTags->{"t:121", "c:38"},
   CellID->1588951893]},
 "c:38"->{
  Cell[6679, 159, 86, 2, 70, "Section",
   CellTags->{"t:121", "c:38"},
   CellID->1588951893]},
 "S3.7.12"->{
  Cell[7067, 176, 4182, 138, 70, "DefinitionBox",
   CellTags->"S3.7.12",
   CellID->1011715958],
  Cell[53446, 1888, 3641, 135, 70, "DefinitionBox",
   CellTags->"S3.7.12",
   CellID->283198658]},
 "t:122"->{
  Cell[24371, 843, 84, 2, 70, "Subsection",
   CellTags->{"t:122", "c:39"},
   CellID->1458825321]},
 "c:39"->{
  Cell[24371, 843, 84, 2, 70, "Subsection",
   CellTags->{"t:122", "c:39"},
   CellID->1458825321]},
 "t:230"->{
  Cell[44364, 1543, 103, 2, 70, "Subsubsection",
   CellTags->{"t:230", "c:40"},
   CellID->1126881263]},
 "c:40"->{
  Cell[44364, 1543, 103, 2, 70, "Subsubsection",
   CellTags->{"t:230", "c:40"},
   CellID->1126881263]},
 "t:205"->{
  Cell[53075, 1873, 91, 2, 70, "Subsection",
   CellTags->{"t:205", "c:41"},
   CellID->69082539],
  Cell[62132, 2176, 109, 2, 70, "Subsection",
   CellTags->{"t:205", "c:41"},
   CellID->386554746]},
 "c:41"->{
  Cell[53075, 1873, 91, 2, 70, "Subsection",
   CellTags->{"t:205", "c:41"},
   CellID->69082539],
  Cell[62132, 2176, 109, 2, 70, "Subsection",
   CellTags->{"t:205", "c:41"},
   CellID->386554746]},
 "t:123"->{
  Cell[70011, 2419, 79, 2, 70, "Subsection",
   CellTags->{"t:123", "c:42"},
   CellID->1483534657]},
 "c:42"->{
  Cell[70011, 2419, 79, 2, 70, "Subsection",
   CellTags->{"t:123", "c:42"},
   CellID->1483534657]},
 "t:124"->{
  Cell[74520, 2590, 83, 2, 70, "Subsection",
   CellTags->{"t:124", "c:43"},
   CellID->1554122061]},
 "c:43"->{
  Cell[74520, 2590, 83, 2, 70, "Subsection",
   CellTags->{"t:124", "c:43"},
   CellID->1554122061]},
 "t:125"->{
  Cell[80392, 2815, 90, 2, 70, "Section",
   CellTags->{"t:125", "c:44"},
   CellID->382555551]},
 "c:44"->{
  Cell[80392, 2815, 90, 2, 70, "Section",
   CellTags->{"t:125", "c:44"},
   CellID->382555551]},
 "t:126"->{
  Cell[80649, 2827, 97, 2, 70, "Subsection",
   CellTags->{"t:126", "c:45"},
   CellID->43873582]},
 "c:45"->{
  Cell[80649, 2827, 97, 2, 70, "Subsection",
   CellTags->{"t:126", "c:45"},
   CellID->43873582]},
 "S3.7.2"->{
  Cell[81263, 2852, 2849, 101, 70, "DefinitionBox",
   CellTags->"S3.7.2",
   CellID->785100947],
  Cell[84115, 2955, 92, 2, 70, "Caption",
   CellTags->"S3.7.2",
   CellID->135206022],
  Cell[96900, 3476, 3305, 120, 70, "DefinitionBox",
   CellTags->"S3.7.2",
   CellID->274559570],
  Cell[100208, 3598, 90, 2, 70, "Caption",
   CellTags->"S3.7.2",
   CellID->1727819234],
  Cell[115288, 4143, 2041, 74, 70, "DefinitionBox",
   CellTags->"S3.7.2",
   CellID->298293044],
  Cell[117332, 4219, 84, 2, 70, "Caption",
   CellTags->"S3.7.2",
   CellID->915154724],
  Cell[124328, 4450, 2244, 94, 70, "DefinitionBox",
   CellTags->"S3.7.2",
   CellID->1025129739],
  Cell[126575, 4546, 86, 2, 70, "Caption",
   CellTags->"S3.7.2",
   CellID->94223492],
  Cell[131309, 4741, 78, 2, 70, "Caption",
   CellTags->"S3.7.2",
   CellID->2022767977],
  Cell[249617, 8683, 95, 2, 70, "Caption",
   CellTags->"S3.7.2",
   CellID->608587522]},
 "c:46"->{
  Cell[92511, 3294, 87, 2, 70, "Subsubsection",
   CellTags->"c:46",
   CellID->980139236]},
 "t:127"->{
  Cell[96412, 3458, 99, 2, 70, "Subsection",
   CellTags->{"t:127", "c:47"},
   CellID->1033045979]},
 "c:47"->{
  Cell[96412, 3458, 99, 2, 70, "Subsection",
   CellTags->{"t:127", "c:47"},
   CellID->1033045979]},
 "c:48"->{
  Cell[107094, 3814, 88, 2, 70, "Subsubsection",
   CellTags->"c:48",
   CellID->1718872299]},
 "t:128"->{
  Cell[115102, 4136, 95, 2, 70, "Subsection",
   CellTags->{"t:128", "c:49"},
   CellID->2116455801]},
 "c:49"->{
  Cell[115102, 4136, 95, 2, 70, "Subsection",
   CellTags->{"t:128", "c:49"},
   CellID->2116455801]},
 "t:180"->{
  Cell[124006, 4436, 97, 2, 70, "Subsection",
   CellTags->{"t:180", "c:50"},
   CellID->503342974]},
 "c:50"->{
  Cell[124006, 4436, 97, 2, 70, "Subsection",
   CellTags->{"t:180", "c:50"},
   CellID->503342974]},
 "t:224"->{
  Cell[130510, 4707, 98, 2, 70, "Subsection",
   CellTags->{"t:224", "c:51"},
   CellID->812208252]},
 "c:51"->{
  Cell[130510, 4707, 98, 2, 70, "Subsection",
   CellTags->{"t:224", "c:51"},
   CellID->812208252]},
 "S3.7.3"->{
  Cell[130828, 4721, 478, 18, 70, "DefinitionBox",
   CellTags->"S3.7.3",
   CellID->2103905576],
  Cell[154022, 5615, 2084, 76, 70, "DefinitionBox",
   CellTags->"S3.7.3",
   CellID->1801089423],
  Cell[168664, 6195, 2110, 78, 70, "DefinitionBox",
   CellTags->"S3.7.3",
   CellID->1985603460],
  Cell[197506, 7252, 555, 19, 70, "DefinitionBox",
   CellTags->"S3.7.3",
   CellID->1601493378]},
 "t:129"->{
  Cell[135240, 4884, 91, 2, 70, "Subsection",
   CellTags->{"t:129", "c:52"},
   CellID->1326060419]},
 "c:52"->{
  Cell[135240, 4884, 91, 2, 70, "Subsection",
   CellTags->{"t:129", "c:52"},
   CellID->1326060419]},
 "t:130"->{
  Cell[143157, 5199, 82, 2, 70, "Subsection",
   CellTags->{"t:130", "c:53"},
   CellID->1525842641]},
 "c:53"->{
  Cell[143157, 5199, 82, 2, 70, "Subsection",
   CellTags->{"t:130", "c:53"},
   CellID->1525842641]},
 "t:131"->{
  Cell[149171, 5414, 89, 2, 70, "Subsection",
   CellTags->{"t:131", "c:54"},
   CellID->877282493]},
 "c:54"->{
  Cell[149171, 5414, 89, 2, 70, "Subsection",
   CellTags->{"t:131", "c:54"},
   CellID->877282493]},
 "t:132"->{
  Cell[153733, 5603, 89, 2, 70, "Subsection",
   CellTags->{"t:132", "c:55"},
   CellID->1013005059]},
 "c:55"->{
  Cell[153733, 5603, 89, 2, 70, "Subsection",
   CellTags->{"t:132", "c:55"},
   CellID->1013005059]},
 "c:56"->{
  Cell[168420, 6185, 91, 2, 70, "Subsection",
   CellTags->"c:56",
   CellID->1896109973]},
 "t:134"->{
  Cell[177917, 6516, 92, 2, 70, "Section",
   CellTags->{"t:134", "c:57"},
   CellID->430873687]},
 "c:57"->{
  Cell[177917, 6516, 92, 2, 70, "Section",
   CellTags->{"t:134", "c:57"},
   CellID->430873687]},
 "t:135"->{
  Cell[189710, 6952, 84, 2, 70, "Subsection",
   CellTags->{"t:135", "c:58"},
   CellID->1542041473]},
 "c:58"->{
  Cell[189710, 6952, 84, 2, 70, "Subsection",
   CellTags->{"t:135", "c:58"},
   CellID->1542041473]},
 "t:136"->{
  Cell[191932, 7036, 76, 2, 70, "Subsection",
   CellTags->{"t:136", "c:59"},
   CellID->2077369385]},
 "c:59"->{
  Cell[191932, 7036, 76, 2, 70, "Subsection",
   CellTags->{"t:136", "c:59"},
   CellID->2077369385]},
 "t:137"->{
  Cell[196865, 7234, 102, 2, 70, "Section",
   CellTags->{"t:137", "c:60"},
   CellID->1853380947]},
 "c:60"->{
  Cell[196865, 7234, 102, 2, 70, "Section",
   CellTags->{"t:137", "c:60"},
   CellID->1853380947]},
 "t:138"->{
  Cell[198086, 7275, 99, 2, 70, "Subsection",
   CellTags->{"t:138", "c:61"},
   CellID->1305822102]},
 "c:61"->{
  Cell[198086, 7275, 99, 2, 70, "Subsection",
   CellTags->{"t:138", "c:61"},
   CellID->1305822102]},
 "t:139"->{
  Cell[202387, 7411, 97, 2, 70, "Subsection",
   CellTags->{"t:139", "c:62"},
   CellID->1191044059]},
 "c:62"->{
  Cell[202387, 7411, 97, 2, 70, "Subsection",
   CellTags->{"t:139", "c:62"},
   CellID->1191044059]},
 "t:120"->{
  Cell[228480, 7909, 105, 2, 70, "Section",
   CellTags->{"t:120", "c:63"},
   CellID->212323487]},
 "c:63"->{
  Cell[228480, 7909, 105, 2, 70, "Section",
   CellTags->{"t:120", "c:63"},
   CellID->212323487]},
 "t:119"->{
  Cell[233166, 8092, 90, 2, 70, "Section",
   CellTags->{"t:119", "c:64"},
   CellID->243730537]},
 "c:64"->{
  Cell[233166, 8092, 90, 2, 70, "Section",
   CellTags->{"t:119", "c:64"},
   CellID->243730537]},
 "t:206"->{
  Cell[244878, 8525, 86, 2, 70, "Subsection",
   CellTags->{"t:206", "c:65"},
   CellID->1885795684]},
 "c:65"->{
  Cell[244878, 8525, 86, 2, 70, "Subsection",
   CellTags->{"t:206", "c:65"},
   CellID->1885795684]},
 "t:150"->{
  Cell[247780, 8624, 89, 2, 70, "Section",
   CellTags->{"t:150", "c:66"},
   CellID->1180395712]},
 "c:66"->{
  Cell[247780, 8624, 89, 2, 70, "Section",
   CellTags->{"t:150", "c:66"},
   CellID->1180395712]},
 "t:140"->{
  Cell[254378, 8870, 106, 2, 70, "Section",
   CellTags->{"t:140", "c:67"},
   CellID->139087150]},
 "c:67"->{
  Cell[254378, 8870, 106, 2, 70, "Section",
   CellTags->{"t:140", "c:67"},
   CellID->139087150]},
 "t:141"->{
  Cell[266865, 9288, 92, 2, 70, "Section",
   CellTags->{"t:141", "c:68"},
   CellID->483612173]},
 "c:68"->{
  Cell[266865, 9288, 92, 2, 70, "Section",
   CellTags->{"t:141", "c:68"},
   CellID->483612173]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"t:28", 273360, 9495},
 {"c:37", 273466, 9499},
 {"t:121", 273573, 9503},
 {"c:38", 273681, 9507},
 {"S3.7.12", 273792, 9511},
 {"t:122", 274002, 9518},
 {"c:39", 274114, 9522},
 {"t:230", 274227, 9526},
 {"c:40", 274344, 9530},
 {"t:205", 274462, 9534},
 {"c:41", 274674, 9541},
 {"t:123", 274887, 9548},
 {"c:42", 275000, 9552},
 {"t:124", 275114, 9556},
 {"c:43", 275227, 9560},
 {"t:125", 275341, 9564},
 {"c:44", 275450, 9568},
 {"t:126", 275560, 9572},
 {"c:45", 275671, 9576},
 {"S3.7.2", 275784, 9580},
 {"c:46", 276723, 9611},
 {"t:127", 276828, 9615},
 {"c:47", 276941, 9619},
 {"c:48", 277054, 9623},
 {"t:128", 277161, 9627},
 {"c:49", 277275, 9631},
 {"t:180", 277390, 9635},
 {"c:50", 277503, 9639},
 {"t:224", 277617, 9643},
 {"c:51", 277730, 9647},
 {"S3.7.3", 277845, 9651},
 {"t:129", 278252, 9664},
 {"c:52", 278366, 9668},
 {"t:130", 278481, 9672},
 {"c:53", 278595, 9676},
 {"t:131", 278710, 9680},
 {"c:54", 278823, 9684},
 {"t:132", 278937, 9688},
 {"c:55", 279051, 9692},
 {"c:56", 279165, 9696},
 {"t:134", 279269, 9700},
 {"c:57", 279379, 9704},
 {"t:135", 279490, 9708},
 {"c:58", 279604, 9712},
 {"t:136", 279719, 9716},
 {"c:59", 279833, 9720},
 {"t:137", 279948, 9724},
 {"c:60", 280060, 9728},
 {"t:138", 280173, 9732},
 {"c:61", 280287, 9736},
 {"t:139", 280402, 9740},
 {"c:62", 280516, 9744},
 {"t:120", 280631, 9748},
 {"c:63", 280742, 9752},
 {"t:119", 280854, 9756},
 {"c:64", 280964, 9760},
 {"t:206", 281075, 9764},
 {"c:65", 281189, 9768},
 {"t:150", 281304, 9772},
 {"c:66", 281415, 9776},
 {"t:140", 281527, 9780},
 {"c:67", 281638, 9784},
 {"t:141", 281750, 9788},
 {"c:68", 281860, 9792}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 4849, 92, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5474, 119, 117, 3, 70, "Title",
 CellTags->{"t:28", "c:37"},
 CellID->1619024906],
Cell[5594, 124, 507, 13, 70, "Text",
 CellID->186304005],
Cell[6104, 139, 550, 16, 70, "Text",
 CellID->180254709],
Cell[CellGroupData[{
Cell[6679, 159, 86, 2, 70, "Section",
 CellTags->{"t:121", "c:38"},
 CellID->1588951893],
Cell[6768, 163, 296, 11, 70, "Text",
 CellID->1555315206],
Cell[7067, 176, 4182, 138, 70, "DefinitionBox",
 CellTags->"S3.7.12",
 CellID->1011715958],
Cell[11252, 316, 268, 10, 70, "Text",
 CellID->134589160],
Cell[CellGroupData[{
Cell[11545, 330, 466, 16, 28, "Input",
 CellID->739731829],
Cell[12014, 348, 479, 17, 36, "Output",
 CellID->890017520]
}, Open  ]],
Cell[12508, 368, 317, 9, 70, "Text",
 CellID->1300857285],
Cell[CellGroupData[{
Cell[12850, 381, 104, 3, 70, "Input",
 CellID->2124862535],
Cell[12957, 386, 447, 15, 78, "Output",
 CellID->2059059782]
}, Open  ]],
Cell[13419, 404, 205, 5, 70, "Text",
 CellID->2066268316],
Cell[CellGroupData[{
Cell[13649, 413, 95, 3, 70, "Input",
 CellID->813531375],
Cell[13747, 418, 480, 17, 36, "Output",
 CellID->2140922823]
}, Open  ]],
Cell[CellGroupData[{
Cell[14264, 440, 103, 3, 70, "Input",
 CellID->1401380676],
Cell[14370, 445, 479, 15, 78, "Output",
 CellID->1551864883]
}, Open  ]],
Cell[14864, 463, 120, 3, 70, "Text",
 CellID->1004195766],
Cell[CellGroupData[{
Cell[15009, 470, 100, 3, 70, "Input",
 CellID->444257389],
Cell[15112, 475, 480, 17, 36, "Output",
 CellID->1980779951]
}, Open  ]],
Cell[CellGroupData[{
Cell[15629, 497, 102, 3, 70, "Input",
 CellID->677140663],
Cell[15734, 502, 594, 19, 78, "Output",
 CellID->1187277588]
}, Open  ]],
Cell[16343, 524, 297, 8, 70, "Text",
 CellID->156373592],
Cell[CellGroupData[{
Cell[16665, 536, 95, 3, 70, "Input",
 CellID->1798460463],
Cell[16763, 541, 479, 17, 36, "Output",
 CellID->892670116]
}, Open  ]],
Cell[CellGroupData[{
Cell[17279, 563, 102, 3, 70, "Input",
 CellID->785881670],
Cell[17384, 568, 459, 15, 78, "Output",
 CellID->1288798640]
}, Open  ]],
Cell[17858, 586, 117, 3, 70, "Text",
 CellID->1318678838],
Cell[CellGroupData[{
Cell[18000, 593, 151, 5, 70, "Input",
 CellID->1003993226],
Cell[18154, 600, 224, 7, 36, "Output",
 CellID->1335134903]
}, Open  ]],
Cell[18393, 610, 111, 3, 70, "Text",
 CellID->555687218],
Cell[CellGroupData[{
Cell[18529, 617, 198, 6, 70, "Input",
 CellID->28692123],
Cell[18730, 625, 429, 13, 36, "Output",
 CellID->1192174333]
}, Open  ]],
Cell[19174, 641, 403, 7, 70, "Text",
 CellID->851588221],
Cell[CellGroupData[{
Cell[19602, 652, 73, 2, 70, "Input",
 CellID->1812206739],
Cell[19678, 656, 481, 17, 36, "Output",
 CellID->2145580619]
}, Open  ]],
Cell[20174, 676, 256, 5, 70, "Text",
 CellID->228063109],
Cell[CellGroupData[{
Cell[20455, 685, 97, 3, 70, "Input",
 CellID->1945846715],
Cell[20555, 690, 494, 17, 36, "Output",
 CellID->1964762489]
}, Open  ]],
Cell[21064, 710, 289, 9, 70, "Text",
 CellID->2054596351],
Cell[CellGroupData[{
Cell[21378, 723, 535, 18, 70, "Input",
 CellID->63827497],
Cell[21916, 743, 432, 15, 78, "Output",
 CellID->1154402226]
}, Open  ]],
Cell[22363, 761, 322, 10, 70, "Text",
 CellID->1670945384],
Cell[CellGroupData[{
Cell[22710, 775, 132, 4, 70, "Input",
 CellID->935417069],
Cell[22845, 781, 454, 15, 78, "Output",
 CellID->1974382643]
}, Open  ]],
Cell[23314, 799, 366, 12, 70, "Text",
 CellID->531767457],
Cell[CellGroupData[{
Cell[23705, 815, 158, 5, 70, "Input",
 CellID->1736194632],
Cell[23866, 822, 468, 16, 78, "Output",
 CellID->215384588]
}, Open  ]],
Cell[CellGroupData[{
Cell[24371, 843, 84, 2, 70, "Subsection",
 CellTags->{"t:122", "c:39"},
 CellID->1458825321],
Cell[24458, 847, 301, 8, 70, "Text",
 CellID->656372248],
Cell[CellGroupData[{
Cell[24784, 859, 416, 13, 70, "Input",
 CellID->24877497],
Cell[25203, 874, 480, 17, 36, "Output",
 CellID->1504264561]
}, Open  ]],
Cell[CellGroupData[{
Cell[25720, 896, 103, 3, 70, "Input",
 CellID->1996984243],
Cell[25826, 901, 438, 15, 78, "Output",
 CellID->292253138]
}, Open  ]],
Cell[26279, 919, 244, 7, 70, "Text",
 CellID->603389677],
Cell[CellGroupData[{
Cell[26548, 930, 463, 16, 70, "Input",
 CellID->752520205],
Cell[27014, 948, 480, 17, 36, "Output",
 CellID->1075888252]
}, Open  ]],
Cell[CellGroupData[{
Cell[27531, 970, 103, 3, 70, "Input",
 CellID->641543624],
Cell[27637, 975, 415, 14, 63, "Output",
 CellID->2055780628]
}, Open  ]],
Cell[28067, 992, 266, 8, 70, "Text",
 CellID->640618213],
Cell[CellGroupData[{
Cell[28358, 1004, 458, 15, 70, "Input",
 CellID->1534783480],
Cell[28819, 1021, 480, 17, 36, "Output",
 CellID->1679864243]
}, Open  ]],
Cell[29314, 1041, 229, 8, 70, "Text",
 CellID->510824992],
Cell[CellGroupData[{
Cell[29568, 1053, 98, 3, 70, "Input",
 CellID->1943503485],
Cell[29669, 1058, 162, 5, 36, "Output",
 CellID->1236801525]
}, Open  ]],
Cell[29846, 1066, 286, 8, 70, "Text",
 CellID->1429011362],
Cell[30135, 1076, 318, 8, 70, "Text",
 CellID->2084336733],
Cell[CellGroupData[{
Cell[30478, 1088, 514, 17, 70, "Input",
 CellID->1694221667],
Cell[30995, 1107, 480, 17, 36, "Output",
 CellID->1297881696]
}, Open  ]],
Cell[CellGroupData[{
Cell[31512, 1129, 103, 3, 70, "Input",
 CellID->1506262093],
Cell[31618, 1134, 541, 17, 108, "Output",
 CellID->1209766215]
}, Open  ]],
Cell[32174, 1154, 126, 4, 70, "Text",
 CellID->165605709],
Cell[CellGroupData[{
Cell[32325, 1162, 525, 17, 70, "Input",
 CellID->196344651],
Cell[32853, 1181, 493, 17, 36, "Output",
 CellID->1429667565]
}, Open  ]],
Cell[CellGroupData[{
Cell[33383, 1203, 103, 3, 70, "Input",
 CellID->228238672],
Cell[33489, 1208, 586, 17, 108, "Output",
 CellID->601566762]
}, Open  ]],
Cell[34090, 1228, 222, 5, 70, "Text",
 CellID->179558858],
Cell[CellGroupData[{
Cell[34337, 1237, 100, 3, 70, "Input",
 CellID->631202371],
Cell[34440, 1242, 507, 17, 36, "Output",
 CellID->49033217]
}, Open  ]],
Cell[CellGroupData[{
Cell[34984, 1264, 104, 3, 70, "Input",
 CellID->1615041318],
Cell[35091, 1269, 1111, 24, 108, "Output",
 CellID->1953617193]
}, Open  ]],
Cell[36217, 1296, 572, 14, 70, "Text",
 CellID->21561225],
Cell[CellGroupData[{
Cell[36814, 1314, 537, 18, 70, "Input",
 CellID->957092909],
Cell[37354, 1334, 485, 17, 36, "Output",
 CellID->1208005533]
}, Open  ]],
Cell[CellGroupData[{
Cell[37876, 1356, 103, 3, 70, "Input",
 CellID->638594393],
Cell[37982, 1361, 1117, 25, 182, "Output",
 CellID->1880179092]
}, Open  ]],
Cell[39114, 1389, 397, 8, 70, "Text",
 CellID->2095617286],
Cell[39514, 1399, 428, 12, 70, "Text",
 CellID->160431355],
Cell[CellGroupData[{
Cell[39967, 1415, 799, 24, 83, "Input",
 CellID->1277806500],
Cell[40769, 1441, 1230, 24, 182, "Output",
 Evaluatable->False,
 CellID->165478800]
}, Open  ]],
Cell[42014, 1468, 482, 12, 70, "Text",
 CellID->1470942020],
Cell[CellGroupData[{
Cell[42521, 1484, 557, 17, 70, "Input",
 CellID->290785876],
Cell[43081, 1503, 915, 22, 92, "Output",
 CellID->1712921007]
}, Open  ]],
Cell[44011, 1528, 328, 11, 70, "Text",
 CellID->2045076614],
Cell[CellGroupData[{
Cell[44364, 1543, 103, 2, 70, "Subsubsection",
 CellTags->{"t:230", "c:40"},
 CellID->1126881263],
Cell[44470, 1547, 284, 8, 70, "Text",
 CellID->835104348],
Cell[44757, 1557, 926, 32, 70, "Input",
 CellID->1793143691],
Cell[45686, 1591, 75, 1, 70, "Text",
 CellID->1727996286],
Cell[CellGroupData[{
Cell[45786, 1596, 99, 3, 70, "Input",
 CellID->2012220421],
Cell[45888, 1601, 161, 5, 36, "Output",
 CellID->816142791]
}, Open  ]],
Cell[46064, 1609, 324, 6, 70, "Text",
 CellID->933834948],
Cell[46391, 1617, 246, 8, 70, "Text",
 CellID->1153478760],
Cell[CellGroupData[{
Cell[46662, 1629, 668, 21, 70, "Input",
 CellID->1182637851],
Cell[47333, 1652, 540, 19, 78, "Output",
 CellID->1633208772]
}, Open  ]],
Cell[47888, 1674, 289, 9, 70, "Text",
 CellID->203855050],
Cell[CellGroupData[{
Cell[48202, 1687, 492, 16, 70, "Input",
 CellID->955408385],
Cell[48697, 1705, 613, 20, 36, "Output",
 CellID->813498076]
}, Open  ]],
Cell[49325, 1728, 294, 8, 70, "Text",
 CellID->1581266530],
Cell[CellGroupData[{
Cell[49644, 1740, 225, 8, 70, "Input",
 CellID->1236438085],
Cell[49872, 1750, 259, 9, 36, "Output",
 CellID->1763126223]
}, Open  ]],
Cell[50146, 1762, 269, 10, 70, "Text",
 CellID->1883068655],
Cell[CellGroupData[{
Cell[50440, 1776, 141, 4, 70, "Input",
 CellID->1268378746],
Cell[50584, 1782, 614, 20, 36, "Output",
 CellID->1718903900]
}, Open  ]],
Cell[51213, 1805, 527, 15, 70, "Text",
 CellID->1667827856],
Cell[CellGroupData[{
Cell[51765, 1824, 399, 11, 70, "Input",
 CellID->78731501],
Cell[52167, 1837, 614, 20, 36, "Output",
 CellID->390410755]
}, Open  ]],
Cell[52796, 1860, 230, 7, 70, "Text",
 CellID->1071017700]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[53075, 1873, 91, 2, 70, "Subsection",
 CellTags->{"t:205", "c:41"},
 CellID->69082539],
Cell[53169, 1877, 274, 9, 70, "Text",
 CellID->367598786],
Cell[53446, 1888, 3641, 135, 70, "DefinitionBox",
 CellTags->"S3.7.12",
 CellID->283198658],
Cell[57090, 2025, 66, 1, 70, "Text",
 CellID->76232053],
Cell[CellGroupData[{
Cell[57181, 2030, 335, 11, 28, "Input",
 CellID->384700003],
Cell[57519, 2043, 934, 19, 108, "Output",
 Evaluatable->False,
 CellID->219506269]
}, Open  ]],
Cell[58468, 2065, 80, 1, 70, "Text",
 CellID->114287875],
Cell[CellGroupData[{
Cell[58573, 2070, 527, 18, 28, "Input",
 CellID->659211409],
Cell[59103, 2090, 1120, 22, 108, "Output",
 Evaluatable->False,
 CellID->96019624]
}, Open  ]],
Cell[60238, 2115, 79, 1, 70, "Text",
 CellID->22021673],
Cell[CellGroupData[{
Cell[60342, 2120, 563, 19, 28, "Input",
 CellID->199368755],
Cell[60908, 2141, 926, 19, 108, "Output",
 Evaluatable->False,
 CellID->632096917]
}, Open  ]],
Cell[61849, 2163, 246, 8, 70, "Text",
 CellID->427894693]
}, Open  ]],
Cell[CellGroupData[{
Cell[62132, 2176, 109, 2, 70, "Subsection",
 CellTags->{"t:205", "c:41"},
 CellID->386554746],
Cell[62244, 2180, 186, 7, 70, "Text",
 CellID->687583847],
Cell[62433, 2189, 1014, 32, 70, "DefinitionBox",
 CellID->612212022],
Cell[63450, 2223, 95, 3, 70, "Text",
 CellID->853300977],
Cell[CellGroupData[{
Cell[63570, 2230, 264, 8, 47, "Input",
 CellID->533725773],
Cell[63837, 2240, 812, 17, 92, "Output",
 Evaluatable->False,
 CellID->236587145]
}, Open  ]],
Cell[64664, 2260, 96, 3, 70, "Text",
 CellID->1407507248],
Cell[CellGroupData[{
Cell[64785, 2267, 366, 11, 65, "Input",
 CellID->1441945431],
Cell[65154, 2280, 869, 18, 92, "Output",
 Evaluatable->False,
 CellID->108805007]
}, Open  ]],
Cell[66038, 2301, 702, 20, 70, "Text",
 CellID->1324749455],
Cell[CellGroupData[{
Cell[66765, 2325, 340, 10, 47, "Input",
 CellID->2101121736],
Cell[67108, 2337, 861, 18, 92, "Output",
 Evaluatable->False,
 CellID->32827705]
}, Open  ]],
Cell[67984, 2358, 144, 4, 70, "Text",
 CellID->1659939729],
Cell[CellGroupData[{
Cell[68153, 2366, 355, 11, 65, "Input",
 CellID->646967126],
Cell[68511, 2379, 989, 20, 108, "Output",
 Evaluatable->False,
 CellID->383624115]
}, Open  ]],
Cell[69515, 2402, 459, 12, 70, "Text",
 CellID->1622168646]
}, Open  ]],
Cell[CellGroupData[{
Cell[70011, 2419, 79, 2, 70, "Subsection",
 CellTags->{"t:123", "c:42"},
 CellID->1483534657],
Cell[70093, 2423, 258, 9, 70, "Text",
 CellID->1481838529],
Cell[CellGroupData[{
Cell[70376, 2436, 373, 13, 70, "Input",
 CellID->892302644],
Cell[70752, 2451, 479, 17, 36, "Output",
 CellID->607326666]
}, Open  ]],
Cell[CellGroupData[{
Cell[71268, 2473, 103, 3, 70, "Input",
 CellID->313659504],
Cell[71374, 2478, 420, 13, 36, "Output",
 CellID->71085636]
}, Open  ]],
Cell[71809, 2494, 260, 5, 70, "Text",
 CellID->829449677],
Cell[CellGroupData[{
Cell[72094, 2503, 451, 15, 70, "Input",
 CellID->1244368662],
Cell[72548, 2520, 486, 17, 36, "Output",
 CellID->70012398]
}, Open  ]],
Cell[73049, 2540, 175, 4, 70, "Text",
 CellID->932332691],
Cell[CellGroupData[{
Cell[73249, 2548, 104, 3, 70, "Input",
 CellID->1674849125],
Cell[73356, 2553, 462, 9, 70, "Message",
 CellID->635519652],
Cell[73821, 2564, 650, 20, 36, "Output",
 CellID->310793818]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[74520, 2590, 83, 2, 70, "Subsection",
 CellTags->{"t:124", "c:43"},
 CellID->1554122061],
Cell[74606, 2594, 534, 14, 70, "Text",
 CellID->285880766],
Cell[CellGroupData[{
Cell[75165, 2612, 453, 15, 70, "Input",
 CellID->877115823],
Cell[75621, 2629, 480, 17, 36, "Output",
 CellID->1357884153]
}, Open  ]],
Cell[76116, 2649, 296, 8, 70, "Text",
 CellID->650242802],
Cell[CellGroupData[{
Cell[76437, 2661, 111, 3, 70, "Input",
 CellID->86493631],
Cell[76551, 2666, 459, 16, 36, "Output",
 CellID->1999510845]
}, Open  ]],
Cell[77025, 2685, 162, 4, 70, "Text",
 CellID->1954663659],
Cell[CellGroupData[{
Cell[77212, 2693, 131, 4, 70, "Input",
 CellID->1974768654],
Cell[77346, 2699, 459, 16, 36, "Output",
 CellID->577003393]
}, Open  ]],
Cell[77820, 2718, 379, 9, 70, "Text",
 CellID->1807359946],
Cell[CellGroupData[{
Cell[78224, 2731, 135, 4, 70, "Input",
 CellID->142425607],
Cell[78362, 2737, 1005, 34, 54, "Output",
 CellID->1450394091]
}, Open  ]],
Cell[79382, 2774, 360, 9, 70, "Text",
 CellID->686610340],
Cell[CellGroupData[{
Cell[79767, 2787, 259, 8, 70, "Input",
 CellID->1430349049],
Cell[80029, 2797, 302, 11, 36, "Output",
 CellID->944522025]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[80392, 2815, 90, 2, 70, "Section",
 CellTags->{"t:125", "c:44"},
 CellID->382555551],
Cell[80485, 2819, 139, 4, 70, "Text",
 CellID->45106539],
Cell[CellGroupData[{
Cell[80649, 2827, 97, 2, 70, "Subsection",
 CellTags->{"t:126", "c:45"},
 CellID->43873582],
Cell[80749, 2831, 511, 19, 70, "Text",
 CellID->796401753],
Cell[81263, 2852, 2849, 101, 70, "DefinitionBox",
 CellTags->"S3.7.2",
 CellID->785100947],
Cell[84115, 2955, 92, 2, 70, "Caption",
 CellTags->"S3.7.2",
 CellID->135206022],
Cell[84210, 2959, 67, 1, 70, "Text",
 CellID->369913228],
Cell[CellGroupData[{
Cell[84302, 2964, 839, 27, 49, "InputOnly",
 CellID->166464931],
Cell[85144, 2993, 938, 19, 108, "Output",
 Evaluatable->False,
 CellID->539357866]
}, Open  ]],
Cell[86097, 3015, 82, 1, 70, "Text",
 CellID->1776279903],
Cell[CellGroupData[{
Cell[86204, 3020, 146, 5, 70, "Input",
 CellID->1766152774],
Cell[86353, 3027, 156, 5, 36, "Output",
 CellID->2027941]
}, Open  ]],
Cell[86524, 3035, 108, 3, 70, "Text",
 CellID->890942363],
Cell[CellGroupData[{
Cell[86657, 3042, 122, 4, 70, "Input",
 CellID->1812308057],
Cell[86782, 3048, 452, 16, 36, "Output",
 CellID->25443016]
}, Open  ]],
Cell[87249, 3067, 266, 8, 70, "Text",
 CellID->540777722],
Cell[CellGroupData[{
Cell[87540, 3079, 147, 5, 70, "Input",
 CellID->700379550],
Cell[87690, 3086, 453, 16, 36, "Output",
 CellID->285952785]
}, Open  ]],
Cell[88158, 3105, 160, 4, 70, "Text",
 CellID->1863384678],
Cell[CellGroupData[{
Cell[88343, 3113, 186, 7, 70, "Input",
 CellID->1152258945],
Cell[88532, 3122, 158, 5, 36, "Output",
 CellID->253498241]
}, Open  ]],
Cell[88705, 3130, 163, 5, 70, "Text",
 CellID->507977834],
Cell[CellGroupData[{
Cell[88893, 3139, 146, 5, 70, "Input",
 CellID->432468603],
Cell[89042, 3146, 478, 17, 36, "Output",
 CellID->98525889]
}, Open  ]],
Cell[89535, 3166, 84, 1, 70, "Text",
 CellID->148521699],
Cell[CellGroupData[{
Cell[89644, 3171, 173, 6, 70, "Input",
 CellID->368642283],
Cell[89820, 3179, 479, 17, 36, "Output",
 CellID->928115802]
}, Open  ]],
Cell[90314, 3199, 91, 1, 70, "Text",
 CellID->299733056],
Cell[CellGroupData[{
Cell[90430, 3204, 204, 7, 70, "Input",
 CellID->31191635],
Cell[90637, 3213, 479, 17, 36, "Output",
 CellID->252733338]
}, Open  ]],
Cell[91131, 3233, 259, 9, 70, "Text",
 CellID->2133478281],
Cell[CellGroupData[{
Cell[91415, 3246, 99, 3, 70, "Input",
 CellID->835014808],
Cell[91517, 3251, 158, 5, 36, "Output",
 CellID->288244911]
}, Open  ]],
Cell[91690, 3259, 418, 13, 70, "Text",
 CellID->1956595192],
Cell[CellGroupData[{
Cell[92133, 3276, 124, 4, 70, "Input",
 CellID->78305433],
Cell[92260, 3282, 214, 7, 36, "Output",
 CellID->1819420467]
}, Open  ]],
Cell[CellGroupData[{
Cell[92511, 3294, 87, 2, 70, "Subsubsection",
 CellTags->"c:46",
 CellID->980139236],
Cell[92601, 3298, 177, 4, 70, "Text",
 CellID->2000566962],
Cell[CellGroupData[{
Cell[92803, 3306, 639, 21, 70, "InputOnly",
 CellID->377469255],
Cell[93445, 3329, 438, 15, 78, "Output",
 CellID->459075547]
}, Open  ]],
Cell[93898, 3347, 110, 3, 70, "Text",
 CellID->1921458405],
Cell[CellGroupData[{
Cell[94033, 3354, 195, 7, 70, "Input",
 CellID->92329249],
Cell[94231, 3363, 454, 16, 36, "Output",
 CellID->1294494809]
}, Open  ]],
Cell[94700, 3382, 80, 1, 70, "Text",
 CellID->417427106],
Cell[CellGroupData[{
Cell[94805, 3387, 171, 6, 70, "Input",
 CellID->2015779440],
Cell[94979, 3395, 479, 17, 36, "Output",
 CellID->503033008]
}, Open  ]],
Cell[95473, 3415, 124, 4, 70, "Text",
 CellID->1980130864],
Cell[CellGroupData[{
Cell[95622, 3423, 247, 9, 70, "Input",
 CellID->505353689],
Cell[95872, 3434, 479, 17, 36, "Output",
 CellID->181627138]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[96412, 3458, 99, 2, 70, "Subsection",
 CellTags->{"t:127", "c:47"},
 CellID->1033045979],
Cell[96514, 3462, 383, 12, 70, "Text",
 CellID->2145966705],
Cell[96900, 3476, 3305, 120, 70, "DefinitionBox",
 CellTags->"S3.7.2",
 CellID->274559570],
Cell[100208, 3598, 90, 2, 70, "Caption",
 CellTags->"S3.7.2",
 CellID->1727819234],
Cell[100301, 3602, 68, 1, 70, "Text",
 CellID->1183991104],
Cell[CellGroupData[{
Cell[100394, 3607, 535, 18, 47, "Input",
 CellID->755011826],
Cell[100932, 3627, 776, 17, 78, "Output",
 Evaluatable->False,
 CellID->416052368]
}, Open  ]],
Cell[101723, 3647, 296, 9, 70, "Text",
 CellID->1318497179],
Cell[CellGroupData[{
Cell[102044, 3660, 236, 8, 47, "Input",
 CellID->98334060],
Cell[102283, 3670, 800, 17, 78, "Output",
 Evaluatable->False,
 CellID->212534355]
}, Open  ]],
Cell[103098, 3690, 76, 1, 70, "Text",
 CellID->1613914272],
Cell[CellGroupData[{
Cell[103199, 3695, 270, 9, 47, "Input",
 CellID->191224247],
Cell[103472, 3706, 845, 18, 78, "Output",
 Evaluatable->False,
 CellID->340908634]
}, Open  ]],
Cell[104332, 3727, 68, 1, 70, "Text",
 CellID->1051671045],
Cell[CellGroupData[{
Cell[104425, 3732, 362, 13, 47, "Input",
 CellID->1644838505],
Cell[104790, 3747, 869, 18, 78, "Output",
 Evaluatable->False,
 CellID->366257686]
}, Open  ]],
Cell[105674, 3768, 198, 6, 70, "Text",
 CellID->515100245],
Cell[CellGroupData[{
Cell[105897, 3778, 304, 11, 47, "Input",
 CellID->249228003],
Cell[106204, 3791, 853, 18, 78, "Output",
 Evaluatable->False,
 CellID->78820798]
}, Open  ]],
Cell[CellGroupData[{
Cell[107094, 3814, 88, 2, 70, "Subsubsection",
 CellTags->"c:48",
 CellID->1718872299],
Cell[107185, 3818, 173, 4, 70, "Text",
 CellID->1136709849],
Cell[CellGroupData[{
Cell[107383, 3826, 535, 18, 70, "Input",
 CellID->667908431],
Cell[107921, 3846, 430, 15, 78, "Output",
 CellID->639976948]
}, Open  ]],
Cell[108366, 3864, 111, 3, 70, "Text",
 CellID->1494460860],
Cell[CellGroupData[{
Cell[108502, 3871, 295, 11, 70, "Input",
 CellID->434938708],
Cell[108800, 3884, 479, 16, 78, "Output",
 CellID->2128014615]
}, Open  ]],
Cell[109294, 3903, 295, 6, 70, "Text",
 CellID->1348977167],
Cell[CellGroupData[{
Cell[109614, 3913, 342, 12, 70, "Input",
 CellID->1274384390],
Cell[109959, 3927, 479, 16, 78, "Output",
 CellID->1724031199]
}, Open  ]],
Cell[110453, 3946, 82, 1, 70, "Text",
 CellID->1942996269],
Cell[CellGroupData[{
Cell[110560, 3951, 324, 11, 70, "Input",
 CellID->1301956801],
Cell[110887, 3964, 362, 13, 78, "Output",
 CellID->1277075124]
}, Open  ]],
Cell[111264, 3980, 116, 3, 70, "Text",
 CellID->1850040950],
Cell[CellGroupData[{
Cell[111405, 3987, 508, 18, 70, "Input",
 CellID->222521737],
Cell[111916, 4007, 429, 16, 78, "Output",
 CellID->1153804332]
}, Open  ]],
Cell[112360, 4026, 123, 4, 70, "Text",
 CellID->212075514],
Cell[CellGroupData[{
Cell[112508, 4034, 782, 28, 70, "Input",
 CellID->1677793425],
Cell[113293, 4064, 527, 17, 78, "Output",
 CellID->66325218]
}, Open  ]],
Cell[113835, 4084, 145, 4, 70, "Text",
 CellID->183926133],
Cell[CellGroupData[{
Cell[114005, 4092, 504, 18, 70, "Input",
 CellID->1017549298],
Cell[114512, 4112, 529, 17, 78, "Output",
 CellID->1538770425]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[115102, 4136, 95, 2, 70, "Subsection",
 CellTags->{"t:128", "c:49"},
 CellID->2116455801],
Cell[115200, 4140, 85, 1, 70, "Text",
 CellID->87061150],
Cell[115288, 4143, 2041, 74, 70, "DefinitionBox",
 CellTags->"S3.7.2",
 CellID->298293044],
Cell[117332, 4219, 84, 2, 70, "Caption",
 CellTags->"S3.7.2",
 CellID->915154724],
Cell[CellGroupData[{
Cell[117441, 4225, 835, 27, 65, "Input",
 CellID->727566454],
Cell[118279, 4254, 959, 20, 108, "Output",
 Evaluatable->False,
 CellID->806753369]
}, Open  ]],
Cell[119253, 4277, 295, 13, 70, "Text",
 CellID->185385192],
Cell[CellGroupData[{
Cell[119573, 4294, 237, 9, 28, "Input",
 CellID->1917633794],
Cell[119813, 4305, 495, 12, 63, "Output",
 Evaluatable->False,
 CellID->713171915]
}, Open  ]],
Cell[120323, 4320, 80, 1, 70, "Text",
 CellID->1570558077],
Cell[CellGroupData[{
Cell[120428, 4325, 182, 6, 28, "Input",
 CellID->1648094862],
Cell[120613, 4333, 836, 18, 78, "Output",
 Evaluatable->False,
 CellID->18966267]
}, Open  ]],
Cell[121464, 4354, 83, 1, 70, "Text",
 CellID->1712826094],
Cell[CellGroupData[{
Cell[121572, 4359, 211, 8, 28, "Input",
 CellID->449873823],
Cell[121786, 4369, 828, 17, 108, "Output",
 Evaluatable->False,
 CellID->706375854]
}, Open  ]],
Cell[122629, 4389, 129, 5, 70, "Text",
 CellID->1333437598],
Cell[122761, 4396, 109, 3, 70, "Text",
 CellID->2093853141],
Cell[CellGroupData[{
Cell[122895, 4403, 231, 8, 28, "Input",
 CellID->575217398],
Cell[123129, 4413, 828, 17, 108, "Output",
 Evaluatable->False,
 CellID->715478780]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[124006, 4436, 97, 2, 70, "Subsection",
 CellTags->{"t:180", "c:50"},
 CellID->503342974],
Cell[124106, 4440, 219, 8, 70, "Text",
 CellID->747278485],
Cell[124328, 4450, 2244, 94, 70, "DefinitionBox",
 CellTags->"S3.7.2",
 CellID->1025129739],
Cell[126575, 4546, 86, 2, 70, "Caption",
 CellTags->"S3.7.2",
 CellID->94223492],
Cell[CellGroupData[{
Cell[126686, 4552, 835, 27, 70, "Input",
 CellID->918782205],
Cell[127524, 4581, 561, 18, 108, "Output",
 CellID->1565097505]
}, Open  ]],
Cell[128100, 4602, 63, 1, 70, "Text",
 CellID->66574432],
Cell[CellGroupData[{
Cell[128188, 4607, 208, 7, 70, "Input",
 CellID->77498537],
Cell[128399, 4616, 426, 14, 63, "Output",
 CellID->1142821277]
}, Open  ]],
Cell[128840, 4633, 67, 1, 70, "Text",
 CellID->303463771],
Cell[CellGroupData[{
Cell[128932, 4638, 238, 8, 70, "Input",
 CellID->41937572],
Cell[129173, 4648, 455, 17, 108, "Output",
 CellID->470136388]
}, Open  ]],
Cell[129643, 4668, 114, 3, 70, "Text",
 CellID->989935803],
Cell[CellGroupData[{
Cell[129782, 4675, 271, 9, 70, "Input",
 CellID->1295227712],
Cell[130056, 4686, 405, 15, 78, "Output",
 CellID->1997909592]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[130510, 4707, 98, 2, 70, "Subsection",
 CellTags->{"t:224", "c:51"},
 CellID->812208252],
Cell[130611, 4711, 214, 8, 70, "Text",
 CellID->1378031032],
Cell[130828, 4721, 478, 18, 70, "DefinitionBox",
 CellTags->"S3.7.3",
 CellID->2103905576],
Cell[131309, 4741, 78, 2, 70, "Caption",
 CellTags->"S3.7.2",
 CellID->2022767977],
Cell[CellGroupData[{
Cell[131412, 4747, 836, 27, 70, "Input",
 CellID->1995257429],
Cell[132251, 4776, 561, 18, 108, "Output",
 CellID->1334461298]
}, Open  ]],
Cell[132827, 4797, 69, 1, 70, "Text",
 CellID->2119309865],
Cell[CellGroupData[{
Cell[132921, 4802, 256, 8, 70, "Input",
 CellID->1077131913],
Cell[133180, 4812, 710, 21, 122, "Output",
 CellID->68917581]
}, Open  ]],
Cell[133905, 4836, 213, 5, 70, "Text",
 CellID->804098134],
Cell[CellGroupData[{
Cell[134143, 4845, 336, 10, 70, "Input",
 CellID->362747567],
Cell[134482, 4857, 709, 21, 108, "Output",
 CellID->2139768383]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[135240, 4884, 91, 2, 70, "Subsection",
 CellTags->{"t:129", "c:52"},
 CellID->1326060419],
Cell[135334, 4888, 360, 13, 70, "Text",
 CellID->512173567],
Cell[CellGroupData[{
Cell[135719, 4905, 539, 18, 70, "InputOnly",
 CellID->986683393],
Cell[136261, 4925, 430, 15, 78, "Output",
 CellID->319064017]
}, Open  ]],
Cell[136706, 4943, 269, 8, 70, "Text",
 CellID->242267160],
Cell[CellGroupData[{
Cell[137000, 4955, 176, 6, 70, "Input",
 CellID->155163408],
Cell[137179, 4963, 479, 17, 36, "Output",
 CellID->786250798]
}, Open  ]],
Cell[137673, 4983, 209, 8, 70, "Text",
 CellID->1050281995],
Cell[CellGroupData[{
Cell[137907, 4995, 103, 3, 70, "Input",
 CellID->1921395272],
Cell[138013, 5000, 476, 16, 92, "Output",
 CellID->1178736565]
}, Open  ]],
Cell[138504, 5019, 244, 7, 70, "Text",
 CellID->488804380],
Cell[CellGroupData[{
Cell[138773, 5030, 214, 7, 70, "Input",
 CellID->1210264885],
Cell[138990, 5039, 476, 16, 92, "Output",
 CellID->2104301458]
}, Open  ]],
Cell[139481, 5058, 237, 8, 70, "Text",
 CellID->86422163],
Cell[CellGroupData[{
Cell[139743, 5070, 256, 9, 70, "Input",
 CellID->798348169],
Cell[140002, 5081, 475, 16, 92, "Output",
 CellID->359849927]
}, Open  ]],
Cell[140492, 5100, 231, 5, 70, "Text",
 CellID->683773137],
Cell[CellGroupData[{
Cell[140748, 5109, 539, 18, 70, "InputOnly",
 CellID->990118462],
Cell[141290, 5129, 404, 14, 63, "Output",
 CellID->70210231]
}, Open  ]],
Cell[CellGroupData[{
Cell[141731, 5148, 232, 8, 70, "InputOnly",
 CellID->1054830214],
Cell[141966, 5158, 712, 18, 92, "Output",
 CellID->1053900713]
}, Open  ]],
Cell[142693, 5179, 427, 15, 70, "Text",
 CellID->464162935]
}, Open  ]],
Cell[CellGroupData[{
Cell[143157, 5199, 82, 2, 70, "Subsection",
 CellTags->{"t:130", "c:53"},
 CellID->1525842641],
Cell[143242, 5203, 93, 1, 70, "Text",
 CellID->1735038460],
Cell[CellGroupData[{
Cell[143360, 5208, 535, 18, 47, "Input",
 CellID->110954607],
Cell[143898, 5228, 521, 12, 63, "Output",
 Evaluatable->False,
 CellID->2118724]
}, Open  ]],
Cell[144434, 5243, 239, 7, 70, "Text",
 CellID->1265027362],
Cell[CellGroupData[{
Cell[144698, 5254, 107, 3, 70, "Input",
 CellID->1226767834],
Cell[144808, 5259, 479, 17, 36, "Output",
 CellID->217095622]
}, Open  ]],
Cell[CellGroupData[{
Cell[145324, 5281, 102, 3, 28, "Input",
 CellID->965386097],
Cell[145429, 5286, 755, 16, 78, "Output",
 Evaluatable->False,
 CellID->137571714]
}, Open  ]],
Cell[146199, 5305, 278, 9, 70, "Text",
 CellID->1940346256],
Cell[CellGroupData[{
Cell[146502, 5318, 761, 25, 65, "Input",
 CellID->1860344897],
Cell[147266, 5345, 889, 18, 78, "Output",
 Evaluatable->False,
 CellID->138343104]
}, Open  ]],
Cell[148170, 5366, 121, 3, 70, "Text",
 CellID->2007481509],
Cell[CellGroupData[{
Cell[148316, 5373, 98, 3, 70, "Input",
 CellID->626143746],
Cell[148417, 5378, 160, 5, 36, "Output",
 CellID->48900909]
}, Open  ]],
Cell[148592, 5386, 228, 8, 70, "Text",
 CellID->69451272],
Cell[CellGroupData[{
Cell[148845, 5398, 113, 3, 70, "Input",
 CellID->986225542],
Cell[148961, 5403, 161, 5, 36, "Output",
 CellID->185446389]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[149171, 5414, 89, 2, 70, "Subsection",
 CellTags->{"t:131", "c:54"},
 CellID->877282493],
Cell[149263, 5418, 422, 14, 70, "Text",
 CellID->2011623196],
Cell[CellGroupData[{
Cell[149710, 5436, 536, 18, 70, "Input",
 CellID->1516000451],
Cell[150249, 5456, 431, 15, 78, "Output",
 CellID->1673591949]
}, Open  ]],
Cell[150695, 5474, 156, 4, 70, "Text",
 CellID->319078437],
Cell[CellGroupData[{
Cell[150876, 5482, 130, 4, 70, "Input",
 CellID->484624100],
Cell[151009, 5488, 480, 17, 36, "Output",
 CellID->1819259276]
}, Open  ]],
Cell[CellGroupData[{
Cell[151526, 5510, 102, 3, 70, "Input",
 CellID->418485746],
Cell[151631, 5515, 430, 15, 78, "Output",
 CellID->480989097]
}, Open  ]],
Cell[152076, 5533, 156, 4, 70, "Text",
 CellID->855305971],
Cell[CellGroupData[{
Cell[152257, 5541, 216, 7, 70, "Input",
 CellID->2019405226],
Cell[152476, 5550, 431, 15, 78, "Output",
 CellID->1312076194]
}, Open  ]],
Cell[152922, 5568, 88, 1, 70, "Text",
 CellID->1702505162],
Cell[CellGroupData[{
Cell[153035, 5573, 216, 7, 70, "Input",
 CellID->932145106],
Cell[153254, 5582, 430, 15, 78, "Output",
 CellID->669591677]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[153733, 5603, 89, 2, 70, "Subsection",
 CellTags->{"t:132", "c:55"},
 CellID->1013005059],
Cell[153825, 5607, 194, 6, 70, "Text",
 CellID->325673197],
Cell[154022, 5615, 2084, 76, 70, "DefinitionBox",
 CellTags->"S3.7.3",
 CellID->1801089423],
Cell[156109, 5693, 420, 14, 70, "Text",
 CellID->2127927896],
Cell[CellGroupData[{
Cell[156554, 5711, 540, 18, 70, "InputOnly",
 CellID->2038974581],
Cell[157097, 5731, 431, 15, 78, "Output",
 CellID->1649227688]
}, Open  ]],
Cell[157543, 5749, 115, 5, 70, "Text",
 CellID->998320387],
Cell[CellGroupData[{
Cell[157683, 5758, 104, 3, 70, "Input",
 CellID->481010298],
Cell[157790, 5763, 162, 5, 36, "Output",
 CellID->1211631178]
}, Open  ]],
Cell[157967, 5771, 322, 8, 70, "Text",
 CellID->1445267792],
Cell[CellGroupData[{
Cell[158314, 5783, 139, 4, 70, "Input",
 CellID->428248927],
Cell[158456, 5789, 162, 5, 36, "Output",
 CellID->1362014992]
}, Open  ]],
Cell[158633, 5797, 294, 9, 70, "Text",
 CellID->1357777171],
Cell[CellGroupData[{
Cell[158952, 5810, 256, 8, 70, "Input",
 CellID->999679975],
Cell[159211, 5820, 163, 5, 36, "Output",
 CellID->1856769344]
}, Open  ]],
Cell[159389, 5828, 510, 18, 70, "Text",
 CellID->1637490051],
Cell[CellGroupData[{
Cell[159924, 5850, 386, 13, 70, "Input",
 CellID->1292350852],
Cell[160313, 5865, 161, 5, 36, "Output",
 CellID->891163806]
}, Open  ]],
Cell[CellGroupData[{
Cell[160511, 5875, 505, 16, 70, "Input",
 CellID->1239133264],
Cell[161019, 5893, 162, 5, 36, "Output",
 CellID->1963843089]
}, Open  ]],
Cell[161196, 5901, 429, 13, 70, "Text",
 CellID->1634626080],
Cell[CellGroupData[{
Cell[161650, 5918, 540, 17, 70, "Input",
 CellID->402230489],
Cell[162193, 5937, 160, 5, 36, "Output",
 CellID->9307867]
}, Open  ]],
Cell[162368, 5945, 522, 18, 70, "Text",
 CellID->1818498085],
Cell[CellGroupData[{
Cell[162915, 5967, 561, 17, 70, "Input",
 CellID->510050491],
Cell[163479, 5986, 162, 5, 36, "Output",
 CellID->1811367060]
}, Open  ]],
Cell[163656, 5994, 141, 5, 70, "Text",
 CellID->917997548],
Cell[CellGroupData[{
Cell[163822, 6003, 541, 18, 70, "InputOnly",
 CellID->1262269188],
Cell[164366, 6023, 432, 15, 78, "Output",
 CellID->2114777650]
}, Open  ]],
Cell[CellGroupData[{
Cell[164835, 6043, 112, 3, 70, "Input",
 CellID->66122053],
Cell[164950, 6048, 205, 7, 36, "Output",
 CellID->1064299272]
}, Open  ]],
Cell[165170, 6058, 591, 16, 70, "Text",
 CellID->1286568641],
Cell[CellGroupData[{
Cell[165786, 6078, 113, 3, 70, "Input",
 CellID->346307644],
Cell[165902, 6083, 159, 5, 36, "Output",
 CellID->711889338]
}, Open  ]],
Cell[166076, 6091, 496, 17, 70, "Text",
 CellID->1092706329],
Cell[CellGroupData[{
Cell[166597, 6112, 448, 15, 70, "Input",
 CellID->1982606006],
Cell[167048, 6129, 163, 5, 36, "Output",
 CellID->1302875990]
}, Open  ]],
Cell[167226, 6137, 247, 8, 70, "Text",
 CellID->1693499118],
Cell[CellGroupData[{
Cell[167498, 6149, 131, 4, 70, "Input",
 CellID->2038902535],
Cell[167632, 6155, 162, 5, 36, "Output",
 CellID->438350566]
}, Open  ]],
Cell[167809, 6163, 574, 17, 70, "Text",
 CellID->1489053552]
}, Open  ]],
Cell[CellGroupData[{
Cell[168420, 6185, 91, 2, 70, "Subsection",
 CellTags->"c:56",
 CellID->1896109973],
Cell[168514, 6189, 147, 4, 70, "Text",
 CellID->1410478378],
Cell[168664, 6195, 2110, 78, 70, "DefinitionBox",
 CellTags->"S3.7.3",
 CellID->1985603460],
Cell[170777, 6275, 85, 1, 70, "Text",
 CellID->141477840],
Cell[CellGroupData[{
Cell[170887, 6280, 535, 18, 47, "Input",
 CellID->553659651],
Cell[171425, 6300, 792, 17, 78, "Output",
 Evaluatable->False,
 CellID->116334242]
}, Open  ]],
Cell[172232, 6320, 76, 1, 70, "Text",
 CellID->1882607344],
Cell[CellGroupData[{
Cell[172333, 6325, 192, 6, 70, "Input",
 CellID->2105059357],
Cell[172528, 6333, 281, 9, 36, "Output",
 CellID->254142683]
}, Open  ]],
Cell[172824, 6345, 258, 9, 70, "Text",
 CellID->1567353296],
Cell[CellGroupData[{
Cell[173107, 6358, 131, 4, 70, "Input",
 CellID->1472431770],
Cell[173241, 6364, 476, 17, 36, "Output",
 CellID->541666]
}, Open  ]],
Cell[173732, 6384, 127, 4, 70, "Text",
 CellID->467136284],
Cell[CellGroupData[{
Cell[173884, 6392, 165, 5, 28, "Input",
 CellID->2106795403],
Cell[174052, 6399, 898, 19, 122, "Output",
 Evaluatable->False,
 CellID->241505230]
}, Open  ]],
Cell[174965, 6421, 93, 1, 70, "Text",
 CellID->20075361],
Cell[CellGroupData[{
Cell[175083, 6426, 176, 6, 28, "Input",
 CellID->251834163],
Cell[175262, 6434, 861, 18, 78, "Output",
 Evaluatable->False,
 CellID->59585568]
}, Open  ]],
Cell[176138, 6455, 226, 8, 70, "Text",
 CellID->817784418],
Cell[CellGroupData[{
Cell[176389, 6467, 224, 8, 28, "Input",
 CellID->607372526],
Cell[176616, 6477, 841, 18, 92, "Output",
 Evaluatable->False,
 CellID->124391160]
}, Open  ]],
Cell[177472, 6498, 396, 12, 70, "Text",
 CellID->1393647588]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[177917, 6516, 92, 2, 70, "Section",
 CellTags->{"t:134", "c:57"},
 CellID->430873687],
Cell[178012, 6520, 246, 7, 70, "Text",
 CellID->379199725],
Cell[CellGroupData[{
Cell[178283, 6531, 542, 18, 70, "Input",
 CellID->1625797426],
Cell[178828, 6551, 828, 26, 78, "Output",
 CellID->195414354]
}, Open  ]],
Cell[179671, 6580, 147, 4, 70, "Text",
 CellID->826551415],
Cell[CellGroupData[{
Cell[179843, 6588, 127, 4, 70, "Input",
 CellID->1925403109],
Cell[179973, 6594, 842, 26, 78, "Output",
 CellID->1966459967]
}, Open  ]],
Cell[180830, 6623, 81, 1, 70, "Text",
 CellID->519338039],
Cell[CellGroupData[{
Cell[180936, 6628, 128, 4, 70, "Input",
 CellID->1140880065],
Cell[181067, 6634, 861, 26, 78, "Output",
 CellID->2037252039]
}, Open  ]],
Cell[181943, 6663, 197, 4, 70, "Text",
 CellID->615751705],
Cell[CellGroupData[{
Cell[182165, 6671, 176, 6, 70, "Input",
 CellID->215211042],
Cell[182344, 6679, 934, 27, 78, "Output",
 CellID->689521346]
}, Open  ]],
Cell[183293, 6709, 352, 13, 70, "Text",
 CellID->963503010],
Cell[CellGroupData[{
Cell[183670, 6726, 134, 4, 70, "Input",
 CellID->1568390690],
Cell[183807, 6732, 542, 16, 78, "Output",
 CellID->1728043552]
}, Open  ]],
Cell[184364, 6751, 216, 5, 70, "Text",
 CellID->659136436],
Cell[CellGroupData[{
Cell[184605, 6760, 133, 4, 70, "Input",
 CellID->1385428626],
Cell[184741, 6766, 460, 15, 78, "Output",
 CellID->1881216408]
}, Open  ]],
Cell[185216, 6784, 255, 5, 70, "Text",
 CellID->202434475],
Cell[CellGroupData[{
Cell[185496, 6793, 494, 16, 70, "Input",
 CellID->702124477],
Cell[185993, 6811, 553, 18, 108, "Output",
 CellID->183444674]
}, Open  ]],
Cell[CellGroupData[{
Cell[186583, 6834, 97, 3, 70, "Input",
 CellID->1515602473],
Cell[186683, 6839, 481, 17, 36, "Output",
 CellID->1427226644]
}, Open  ]],
Cell[CellGroupData[{
Cell[187201, 6861, 101, 3, 70, "Input",
 CellID->5868718],
Cell[187305, 6866, 554, 18, 108, "Output",
 CellID->1998779311]
}, Open  ]],
Cell[187874, 6887, 184, 4, 70, "Text",
 CellID->397189956],
Cell[188061, 6893, 720, 19, 70, "Text",
 CellID->1192415616],
Cell[CellGroupData[{
Cell[188806, 6916, 469, 16, 70, "Input",
 CellID->611864308],
Cell[189278, 6934, 395, 13, 63, "Output",
 CellID->1451722720]
}, Open  ]],
Cell[CellGroupData[{
Cell[189710, 6952, 84, 2, 70, "Subsection",
 CellTags->{"t:135", "c:58"},
 CellID->1542041473],
Cell[189797, 6956, 352, 9, 70, "Text",
 CellID->1258384715],
Cell[190152, 6967, 279, 9, 70, "InputOnly",
 CellID->1252949349],
Cell[190434, 6978, 498, 17, 70, "InputOnly",
 CellID->95066161],
Cell[CellGroupData[{
Cell[190957, 6999, 137, 4, 70, "Input",
 CellID->49134559],
Cell[191097, 7005, 510, 16, 78, "Output",
 CellID->1170812665]
}, Open  ]],
Cell[191622, 7024, 273, 7, 70, "Text",
 CellID->455803194]
}, Open  ]],
Cell[CellGroupData[{
Cell[191932, 7036, 76, 2, 70, "Subsection",
 CellTags->{"t:136", "c:59"},
 CellID->2077369385],
Cell[192011, 7040, 256, 8, 70, "Text",
 CellID->558120769],
Cell[192270, 7050, 499, 17, 70, "InputOnly",
 CellID->127194487],
Cell[192772, 7069, 247, 9, 70, "Text",
 CellID->1011514244],
Cell[CellGroupData[{
Cell[193044, 7082, 178, 6, 70, "Input",
 CellID->1039349256],
Cell[193225, 7090, 519, 18, 36, "Output",
 CellID->710960894]
}, Open  ]],
Cell[193759, 7111, 245, 7, 70, "Text",
 CellID->520733550],
Cell[CellGroupData[{
Cell[194029, 7122, 102, 3, 70, "Input",
 CellID->972913325],
Cell[194134, 7127, 805, 25, 78, "Output",
 CellID->813765017]
}, Open  ]],
Cell[194954, 7155, 160, 4, 70, "Text",
 CellID->1772776623],
Cell[CellGroupData[{
Cell[195139, 7163, 252, 9, 70, "Input",
 CellID->868584283],
Cell[195394, 7174, 480, 17, 36, "Output",
 CellID->1849695722]
}, Open  ]],
Cell[CellGroupData[{
Cell[195911, 7196, 102, 3, 70, "Input",
 CellID->862725682],
Cell[196016, 7201, 483, 15, 78, "Output",
 CellID->20952830]
}, Open  ]],
Cell[196514, 7219, 302, 9, 70, "Text",
 CellID->2114379349]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[196865, 7234, 102, 2, 70, "Section",
 CellTags->{"t:137", "c:60"},
 CellID->1853380947],
Cell[196970, 7238, 533, 12, 70, "Text",
 CellID->523276494],
Cell[197506, 7252, 555, 19, 70, "DefinitionBox",
 CellTags->"S3.7.3",
 CellID->1601493378],
Cell[CellGroupData[{
Cell[198086, 7275, 99, 2, 70, "Subsection",
 CellTags->{"t:138", "c:61"},
 CellID->1305822102],
Cell[198188, 7279, 232, 8, 70, "Text",
 CellID->1816679621],
Cell[CellGroupData[{
Cell[198445, 7291, 548, 18, 70, "Input",
 CellID->11897101],
Cell[198996, 7311, 455, 16, 92, "Output",
 CellID->238597336]
}, Open  ]],
Cell[199466, 7330, 281, 8, 70, "Text",
 CellID->753457203],
Cell[CellGroupData[{
Cell[199772, 7342, 552, 18, 28, "Input",
 CellID->1791628109],
Cell[200327, 7362, 1644, 31, 216, "Output",
 Evaluatable->False,
 CellID->201386073]
}, Open  ]],
Cell[201986, 7396, 364, 10, 70, "Text",
 CellID->1359321835]
}, Open  ]],
Cell[CellGroupData[{
Cell[202387, 7411, 97, 2, 70, "Subsection",
 CellTags->{"t:139", "c:62"},
 CellID->1191044059],
Cell[202487, 7415, 345, 11, 70, "Text",
 CellID->1182425926],
Cell[202835, 7428, 371, 12, 70, "Text",
 CellID->2038338144],
Cell[CellGroupData[{
Cell[203231, 7444, 225, 7, 70, "Input",
 CellID->1690049264],
Cell[203459, 7453, 490, 17, 36, "Output",
 CellID->38417178]
}, Open  ]],
Cell[203964, 7473, 128, 4, 70, "Text",
 CellID->84924462],
Cell[CellGroupData[{
Cell[204117, 7481, 108, 3, 28, "Input",
 CellID->1396291226],
Cell[204228, 7486, 5178, 89, 195, "Output",
 Evaluatable->False,
 CellID->417875906]
}, Open  ]],
Cell[209421, 7578, 151, 4, 70, "Text",
 CellID->1013075101],
Cell[CellGroupData[{
Cell[209597, 7586, 132, 4, 28, "Input",
 CellID->1502869091],
Cell[209732, 7592, 18687, 310, 195, "Output",
 Evaluatable->False,
 CellID->473599364]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[228480, 7909, 105, 2, 70, "Section",
 CellTags->{"t:120", "c:63"},
 CellID->212323487],
Cell[228588, 7913, 545, 14, 70, "Text",
 CellID->1550508342],
Cell[229136, 7929, 691, 22, 70, "Text",
 CellID->1827131296],
Cell[229830, 7953, 562, 17, 70, "Text",
 CellID->1727023419],
Cell[CellGroupData[{
Cell[230417, 7974, 224, 7, 70, "Input",
 CellID->693630281],
Cell[230644, 7983, 492, 17, 36, "Output",
 CellID->1302896851]
}, Open  ]],
Cell[231151, 8003, 124, 4, 70, "Text",
 CellID->2044109945],
Cell[CellGroupData[{
Cell[231300, 8011, 139, 4, 70, "Input",
 CellID->2059944556],
Cell[231442, 8017, 162, 5, 36, "Output",
 CellID->1904279405]
}, Open  ]],
Cell[231619, 8025, 82, 1, 70, "Text",
 CellID->1275168594],
Cell[CellGroupData[{
Cell[231726, 8030, 108, 3, 70, "Input",
 CellID->2019245945],
Cell[231837, 8035, 207, 7, 36, "Output",
 CellID->782524074]
}, Open  ]],
Cell[232059, 8045, 129, 4, 70, "Text",
 CellID->692257490],
Cell[CellGroupData[{
Cell[232213, 8053, 95, 3, 70, "Input",
 CellID->1852718631],
Cell[232311, 8058, 491, 17, 36, "Output",
 CellID->129149717]
}, Open  ]],
Cell[232817, 8078, 312, 9, 70, "Text",
 CellID->1660810149]
}, Open  ]],
Cell[CellGroupData[{
Cell[233166, 8092, 90, 2, 70, "Section",
 CellTags->{"t:119", "c:64"},
 CellID->243730537],
Cell[233259, 8096, 391, 12, 70, "Text",
 CellID->1127820530],
Cell[CellGroupData[{
Cell[233675, 8112, 650, 21, 47, "Input",
 CellID->1588979288],
Cell[234328, 8135, 849, 18, 92, "Output",
 Evaluatable->False,
 CellID->771625866]
}, Open  ]],
Cell[235192, 8156, 129, 4, 70, "Text",
 CellID->2037582172],
Cell[CellGroupData[{
Cell[235346, 8164, 95, 3, 70, "Input",
 CellID->1869329742],
Cell[235444, 8169, 479, 17, 36, "Output",
 CellID->241019553]
}, Open  ]],
Cell[CellGroupData[{
Cell[235960, 8191, 103, 3, 28, "Input",
 CellID->1230326905],
Cell[236066, 8196, 843, 18, 92, "Output",
 Evaluatable->False,
 CellID->5890135]
}, Open  ]],
Cell[236924, 8217, 131, 4, 70, "Text",
 CellID->1668009432],
Cell[CellGroupData[{
Cell[237080, 8225, 160, 5, 70, "Input",
 CellID->982995686],
Cell[237243, 8232, 225, 7, 36, "Output",
 CellID->203343554]
}, Open  ]],
Cell[237483, 8242, 137, 4, 70, "Text",
 CellID->624304348],
Cell[CellGroupData[{
Cell[237645, 8250, 204, 6, 70, "Input",
 CellID->78077594],
Cell[237852, 8258, 453, 16, 36, "Output",
 CellID->663054920]
}, Open  ]],
Cell[CellGroupData[{
Cell[238342, 8279, 101, 3, 28, "Input",
 CellID->39299268],
Cell[238446, 8284, 780, 17, 92, "Output",
 Evaluatable->False,
 CellID->370907787]
}, Open  ]],
Cell[239241, 8304, 192, 4, 70, "Text",
 CellID->1693002046],
Cell[CellGroupData[{
Cell[239458, 8312, 141, 5, 70, "Input",
 CellID->127064372],
Cell[239602, 8319, 504, 15, 36, "Output",
 CellID->707342426]
}, Open  ]],
Cell[240121, 8337, 239, 5, 70, "Text",
 CellID->954944026],
Cell[240363, 8344, 826, 28, 70, "Input",
 CellID->1598950951],
Cell[CellGroupData[{
Cell[241214, 8376, 145, 5, 70, "Input",
 CellID->2105758546],
Cell[241362, 8383, 229, 7, 39, "Output",
 CellID->8584415]
}, Open  ]],
Cell[241606, 8393, 236, 5, 70, "Text",
 CellID->1083211767],
Cell[241845, 8400, 609, 21, 70, "Input",
 CellID->1321292350],
Cell[242457, 8423, 141, 4, 70, "Text",
 CellID->1979616470],
Cell[CellGroupData[{
Cell[242623, 8431, 161, 5, 70, "Input",
 CellID->449868319],
Cell[242787, 8438, 224, 7, 36, "Output",
 CellID->2582619]
}, Open  ]],
Cell[CellGroupData[{
Cell[243048, 8450, 162, 5, 70, "Input",
 CellID->1367827530],
Cell[243213, 8457, 226, 7, 36, "Output",
 CellID->279840503]
}, Open  ]],
Cell[243454, 8467, 178, 4, 70, "Text",
 CellID->1841532441],
Cell[CellGroupData[{
Cell[243657, 8475, 258, 8, 70, "Input",
 CellID->1101415323],
Cell[243918, 8485, 235, 7, 36, "Output",
 CellID->749660048]
}, Open  ]],
Cell[244168, 8495, 138, 4, 70, "Text",
 CellID->889940882],
Cell[CellGroupData[{
Cell[244331, 8503, 281, 8, 70, "Input",
 CellID->12802419],
Cell[244615, 8513, 226, 7, 36, "Output",
 CellID->168769642]
}, Open  ]],
Cell[CellGroupData[{
Cell[244878, 8525, 86, 2, 70, "Subsection",
 CellTags->{"t:206", "c:65"},
 CellID->1885795684],
Cell[244967, 8529, 501, 13, 70, "Text",
 CellID->2004398562],
Cell[CellGroupData[{
Cell[245493, 8546, 454, 14, 70, "Input",
 CellID->350661045],
Cell[245950, 8562, 478, 17, 36, "Output",
 CellID->64252854]
}, Open  ]],
Cell[CellGroupData[{
Cell[246465, 8584, 102, 3, 28, "Input",
 CellID->531011039],
Cell[246570, 8589, 906, 19, 78, "Output",
 Evaluatable->False,
 CellID->362728771]
}, Open  ]],
Cell[247491, 8611, 240, 7, 70, "Text",
 CellID->84111244]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[247780, 8624, 89, 2, 70, "Section",
 CellTags->{"t:150", "c:66"},
 CellID->1180395712],
Cell[247872, 8628, 542, 15, 70, "Text",
 CellID->456800598],
Cell[248417, 8645, 1197, 36, 70, "DefinitionBox",
 CellID->193612561],
Cell[249617, 8683, 95, 2, 70, "Caption",
 CellTags->"S3.7.2",
 CellID->608587522],
Cell[249715, 8687, 66, 1, 70, "Text",
 CellID->65871593],
Cell[CellGroupData[{
Cell[249806, 8692, 451, 14, 70, "Input",
 CellID->1149785346],
Cell[250260, 8708, 548, 17, 92, "Output",
 CellID->1384454516]
}, Open  ]],
Cell[250823, 8728, 355, 10, 70, "Text",
 CellID->541735167],
Cell[CellGroupData[{
Cell[251203, 8742, 137, 4, 70, "Input",
 CellID->1759772136],
Cell[251343, 8748, 304, 12, 43, "Output",
 CellID->1345503268]
}, Open  ]],
Cell[251662, 8763, 114, 3, 70, "Text",
 CellID->870622366],
Cell[CellGroupData[{
Cell[251801, 8770, 170, 5, 70, "Input",
 CellID->1744018351],
Cell[251974, 8777, 223, 7, 36, "Output",
 CellID->712127354]
}, Open  ]],
Cell[252212, 8787, 147, 4, 70, "Text",
 CellID->798073947],
Cell[CellGroupData[{
Cell[252384, 8795, 222, 7, 70, "Input",
 CellID->45968067],
Cell[252609, 8804, 548, 17, 92, "Output",
 CellID->1638672796]
}, Open  ]],
Cell[253172, 8824, 354, 10, 70, "Text",
 CellID->1843393244],
Cell[CellGroupData[{
Cell[253551, 8838, 227, 7, 70, "Input",
 CellID->163676639],
Cell[253781, 8847, 548, 17, 92, "Output",
 CellID->2134203513]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[254378, 8870, 106, 2, 70, "Section",
 CellTags->{"t:140", "c:67"},
 CellID->139087150],
Cell[254487, 8874, 588, 11, 70, "Text",
 CellID->1175522114],
Cell[CellGroupData[{
Cell[255100, 8889, 1058, 34, 70, "Input",
 CellID->150617598],
Cell[256161, 8925, 557, 19, 36, "Output",
 CellID->1694233420]
}, Open  ]],
Cell[CellGroupData[{
Cell[256755, 8949, 104, 3, 70, "Input",
 CellID->1495414367],
Cell[256862, 8954, 492, 16, 78, "Output",
 CellID->1428145328]
}, Open  ]],
Cell[257369, 8973, 236, 8, 70, "Text",
 CellID->413805177],
Cell[CellGroupData[{
Cell[257630, 8985, 187, 6, 70, "Input",
 CellID->1271560853],
Cell[257820, 8993, 425, 13, 36, "Output",
 CellID->1513485074]
}, Open  ]],
Cell[258260, 9009, 514, 14, 70, "Text",
 CellID->199840003],
Cell[CellGroupData[{
Cell[258799, 9027, 197, 6, 70, "Input",
 CellID->46506513],
Cell[258999, 9035, 865, 30, 36, "Output",
 CellID->2098400130]
}, Open  ]],
Cell[259879, 9068, 231, 8, 70, "Text",
 CellID->1834533876],
Cell[CellGroupData[{
Cell[260135, 9080, 132, 4, 70, "Input",
 CellID->1588133953],
Cell[260270, 9086, 859, 30, 64, "Output",
 CellID->693099508]
}, Open  ]],
Cell[261144, 9119, 271, 8, 70, "Text",
 CellID->972129628],
Cell[CellGroupData[{
Cell[261440, 9131, 587, 19, 28, "Input",
 CellID->527071420],
Cell[262030, 9152, 1224, 24, 54, "Output",
 Evaluatable->False,
 CellID->285198576]
}, Open  ]],
Cell[263269, 9179, 134, 4, 70, "Text",
 CellID->1675633804],
Cell[CellGroupData[{
Cell[263428, 9187, 131, 4, 28, "Input",
 CellID->276797070],
Cell[263562, 9193, 1765, 33, 80, "Output",
 Evaluatable->False,
 CellID->547405064]
}, Open  ]],
Cell[265342, 9229, 108, 3, 70, "Text",
 CellID->756578152],
Cell[CellGroupData[{
Cell[265475, 9236, 509, 18, 70, "Input",
 CellID->558326777],
Cell[265987, 9256, 429, 15, 39, "Output",
 CellID->1442087296]
}, Open  ]],
Cell[266431, 9274, 397, 9, 70, "Text",
 CellID->660743830]
}, Open  ]],
Cell[CellGroupData[{
Cell[266865, 9288, 92, 2, 70, "Section",
 CellTags->{"t:141", "c:68"},
 CellID->483612173],
Cell[266960, 9292, 363, 8, 70, "Text",
 CellID->1991671363],
Cell[CellGroupData[{
Cell[267348, 9304, 969, 30, 70, "Input",
 CellID->1192992152],
Cell[268320, 9336, 582, 17, 78, "Output",
 CellID->1711770272]
}, Open  ]],
Cell[268917, 9356, 230, 8, 70, "Text",
 CellID->2032026292],
Cell[CellGroupData[{
Cell[269172, 9368, 102, 3, 70, "Input",
 CellID->833451403],
Cell[269277, 9373, 294, 9, 82, "Output",
 CellID->1929384487]
}, Open  ]],
Cell[269586, 9385, 359, 7, 70, "Text",
 CellID->162003309],
Cell[CellGroupData[{
Cell[269970, 9396, 64, 1, 70, "TutorialMoreAboutSection",
 CellID->2398209],
Cell[270037, 9399, 169, 3, 70, "TutorialMoreAbout",
 CellID->4791866],
Cell[270209, 9404, 147, 3, 70, "TutorialMoreAbout",
 CellID->212289775]
}, Open  ]],
Cell[CellGroupData[{
Cell[270393, 9412, 72, 1, 70, "RelatedTutorialsSection",
 CellID->404196674],
Cell[270468, 9415, 304, 9, 70, "RelatedTutorials",
 CellID->315063104],
Cell[270775, 9426, 191, 5, 70, "RelatedTutorials",
 CellID->3571032],
Cell[270969, 9433, 175, 4, 70, "RelatedTutorials",
 CellID->560755906],
Cell[271147, 9439, 175, 4, 70, "RelatedTutorials",
 CellID->335456077],
Cell[271325, 9445, 160, 4, 70, "RelatedTutorials",
 CellID->472696132]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[271524, 9454, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

