(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22696,        866]
NotebookOptionsPosition[     16837,        677]
NotebookOutlinePosition[     19640,        749]
CellTagsIndexPosition[     19549,        743]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Modularity and the Naming of Things" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Modularity and the Naming of Things\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"With" :> Documentation`HelpLookup["paclet:ref/With"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"With\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Local Constants", "Title",
 CellTags->{"S2.7.2", "2.1"},
 CellID->19459],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["With",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/With"], "[", "{", 
     StyleBox["x", "TI"], "=", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], ",", 
     StyleBox["y", "TI"], "=", 
     SubscriptBox[
      StyleBox["y", "TI"], "0"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["body", "TI"], "]"}], Cell[TextData[{
     "define local constants ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", \[Ellipsis]",
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20432],

Cell["Defining local constants. ", "Caption",
 CellID->20955],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " allows you to set up local ",
 StyleBox["variables",
  FontSlant->"Italic"],
 ", to which you can assign values and then change them. Often, however, all \
you really need are local ",
 StyleBox["constants",
  FontSlant->"Italic"],
 ", to which you assign a value only once. The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " construct allows you to set up such local constants. "
}], "Text",
 CellID->22105],

Cell[TextData[{
 "This defines a global value for ",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20526],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", "17"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->5937],

Cell[BoxData["17"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->1366]
}, Open  ]],

Cell[TextData[{
 "This defines a function using ",
 Cell[BoxData["t"], "InlineFormula"],
 " as a local constant. "
}], "MathCaption",
 CellID->3914],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "[", "x_", "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t", "=", 
      RowBox[{"x", "+", "1"}]}], "}"}], ",", 
    RowBox[{"t", "+", 
     RowBox[{"t", "^", "3"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->23155],

Cell[TextData[{
 "This uses the definition of ",
 Cell[BoxData["w"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"w", "[", "a", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->6446],

Cell[BoxData[
 RowBox[{"1", "+", "a", "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "a"}], ")"}], "3"]}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->18182]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["t"], "InlineFormula"],
 " still has its global value. "
}], "MathCaption",
 CellID->19635],

Cell[CellGroupData[{

Cell[BoxData["t"], "Input",
 CellLabel->"In[4]:= ",
 CellID->20093],

Cell[BoxData["17"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->3936]
}, Open  ]],

Cell[TextData[{
 "Just as in ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 ", the initial values you define in ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " are evaluated before ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " is executed. "
}], "Text",
 CellID->15846],

Cell[TextData[{
 "The expression ",
 Cell[BoxData[
  RowBox[{"t", "+", "1"}]], "InlineFormula"],
 " which gives the value of the local constant ",
 Cell[BoxData["t"], "InlineFormula"],
 " is evaluated using the global ",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "=", 
     RowBox[{"t", "+", "1"}]}], "}"}], ",", 
   RowBox[{"t", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->5456],

Cell[BoxData["324"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->24403]
}, Open  ]],

Cell[TextData[{
 "The way ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["With",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/With"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       StyleBox["x", "TI"], "=", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["0", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["body", "TI"]}], "]"}]], "InlineFormula"],
 " works is to take ",
 Cell[BoxData[
  StyleBox["body", "TI"]], "InlineFormula"],
 ", and replace every occurrence of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", etc. in it by ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 ", etc. You can think of ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " as a generalization of the ",
 Cell[BoxData["/."], "InlineFormula"],
 " operator, suitable for application to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code instead of other expressions. "
}], "Text",
 CellID->19714],

Cell[TextData[{
 "This replaces ",
 Cell[BoxData["x"], "InlineFormula"],
 " with ",
 Cell[BoxData["a"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->25599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "a"}], "}"}], ",", 
   RowBox[{"x", "=", "5"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->30041],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->6925]
}, Open  ]],

Cell[TextData[{
 "After the replacement, the body of ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"a", "=", "5"}]], "InlineFormula"],
 ", so ",
 Cell[BoxData["a"], "InlineFormula"],
 " gets the global value ",
 Cell[BoxData["5"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->18074],

Cell[CellGroupData[{

Cell[BoxData["a"], "Input",
 CellLabel->"In[7]:= ",
 CellID->12324],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->10344]
}, Open  ]],

Cell[TextData[{
 "This clears the value of ",
 Cell[BoxData["a"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->29863],

Cell[BoxData[
 RowBox[{"Clear", "[", "a", "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->13749],

Cell[TextData[{
 "In some respects, ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " is like a special case of ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 ", in which each local variable is assigned a value exactly once. "
}], "Text",
 CellID->29276],

Cell[TextData[{
 "One of the main reasons for using ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " rather than ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " is that it typically makes the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs you write easier to understand. In a module, if you see a local \
variable ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " at a particular point, you potentially have to trace through all of the \
code in the module to work out the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " at that point. In a ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " construct, however, you can always find out the value of a local constant \
simply by looking at the initial list of values, without having to trace \
through specific code. "
}], "Text",
 CellID->10597],

Cell[TextData[{
 "If you have several ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " constructs, it is always the innermost one for a particular variable that \
is in effect. You can mix ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 ". The general rule is that the innermost one for a particular variable is \
the one that is in effect. "
}], "Text",
 CellID->14334],

Cell[TextData[{
 "With nested ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " constructs, the innermost one is always the one in effect. "
}], "MathCaption",
 CellID->16647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "=", "8"}], "}"}], ",", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", "=", "9"}], "}"}], ",", 
     RowBox[{"t", "^", "2"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->22426],

Cell[BoxData["81"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->20043]
}, Open  ]],

Cell[TextData[{
 "You can mix ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " constructs. "
}], "MathCaption",
 CellID->3244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "=", "8"}], "}"}], ",", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", "=", "9"}], "}"}], ",", 
     RowBox[{"t", "^", "2"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->13592],

Cell[BoxData["81"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->28761]
}, Open  ]],

Cell["\<\
Local variables in inner constructs do not mask ones outside unless the names \
conflict. \
\>", "MathCaption",
 CellID->17269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "=", "a"}], "}"}], ",", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", "=", "b"}], "}"}], ",", 
     RowBox[{"t", "+", "u"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->5175],

Cell[BoxData[
 RowBox[{"a", "+", "b"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->31139]
}, Open  ]],

Cell[TextData[{
 "Except for the question of when ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["body", "TI"]], "InlineFormula"],
 " are evaluated, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["With",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/With"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       StyleBox["x", "TI"], "=", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["0", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["body", "TI"]}], "]"}]], "InlineFormula"],
 " works essentially like ",
 Cell[BoxData[
  RowBox[{
   StyleBox["body", "TI"], "/.", 
   RowBox[{
    StyleBox["x", "TI"], "->", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["0", "TR"]]}]}]], "InlineFormula"],
 ". However, ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " behaves in a special way when the expression ",
 Cell[BoxData[
  StyleBox["body", "TI"]], "InlineFormula"],
 " itself contains ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " constructs. The main issue is to prevent the local constants in the \
various ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " constructs from conflicting with each other, or with global objects. The \
details of how this is done are discussed in ",
 ButtonBox["How Modules Work",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/HowModulesWork"],
 ". "
}], "Text",
 CellID->24696],

Cell[TextData[{
 "The ",
 Cell[BoxData["y"], "InlineFormula"],
 " in the inner ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " is renamed to prevent it from conflicting with the global ",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", 
     RowBox[{"2", "+", "y"}]}], "}"}], ",", 
   RowBox[{"Hold", "[", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"y", "=", "4"}], "}"}], ",", 
      RowBox[{"x", "+", "y"}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->14471],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"y$", "=", "4"}], "}"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "+", "y"}], ")"}], "+", "y$"}]}], "]"}], "]"}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->30268]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->688989791],

Cell[TextData[ButtonBox["Modularity and the Naming of Things",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], \
"RelatedTutorials",
 CellID->405226890]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Local Constants - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Modularity and the Naming of Things", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ModulesAndLocalVariables"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/HowModulesWork"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 45.4915856}", "context" -> "", 
    "keywords" -> {
     "constants", "fixed variables", "local constants", "macros", "programs", 
      "replacements", "substitution", "With", "with compared with ", 
      "Writeonce variables"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Defining local constants. Module allows you to set up local variables, \
to which you can assign values and then change them. Often, however, all you \
really need are local constants, to which you assign a value only once. The \
Mathematica With construct allows you to set up such local constants. This \
defines a global value for t. ", "synonyms" -> {"2.7.2"}, "title" -> 
    "Local Constants", "type" -> "Tutorial", "uri" -> 
    "tutorial/LocalConstants"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.7.2"->{
  Cell[1829, 58, 78, 2, 70, "Title",
   CellTags->{"S2.7.2", "2.1"},
   CellID->19459]},
 "2.1"->{
  Cell[1829, 58, 78, 2, 70, "Title",
   CellTags->{"S2.7.2", "2.1"},
   CellID->19459]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.7.2", 19338, 732},
 {"2.1", 19437, 736}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1204, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1829, 58, 78, 2, 70, "Title",
 CellTags->{"S2.7.2", "2.1"},
 CellID->19459],
Cell[1910, 62, 1084, 34, 70, "DefinitionBox",
 CellID->20432],
Cell[2997, 98, 61, 1, 70, "Caption",
 CellID->20955],
Cell[3061, 101, 667, 22, 70, "Text",
 CellID->22105],
Cell[3731, 125, 131, 5, 70, "MathCaption",
 CellID->20526],
Cell[CellGroupData[{
Cell[3887, 134, 89, 3, 28, "Input",
 CellID->5937],
Cell[3979, 139, 155, 5, 36, "Output",
 CellID->1366]
}, Open  ]],
Cell[4149, 147, 148, 5, 70, "MathCaption",
 CellID->3914],
Cell[4300, 154, 303, 11, 70, "Input",
 CellID->23155],
Cell[4606, 167, 127, 5, 70, "MathCaption",
 CellID->19290],
Cell[CellGroupData[{
Cell[4758, 176, 93, 3, 70, "Input",
 CellID->6446],
Cell[4854, 181, 260, 9, 36, "Output",
 CellID->18182]
}, Open  ]],
Cell[5129, 193, 121, 4, 70, "MathCaption",
 CellID->19635],
Cell[CellGroupData[{
Cell[5275, 201, 67, 2, 70, "Input",
 CellID->20093],
Cell[5345, 205, 155, 5, 36, "Output",
 CellID->3936]
}, Open  ]],
Cell[5515, 213, 481, 18, 70, "Text",
 CellID->15846],
Cell[5999, 233, 299, 10, 70, "MathCaption",
 CellID->21238],
Cell[CellGroupData[{
Cell[6323, 247, 218, 8, 70, "Input",
 CellID->5456],
Cell[6544, 257, 157, 5, 36, "Output",
 CellID->24403]
}, Open  ]],
Cell[6716, 265, 1103, 40, 70, "Text",
 CellID->19714],
Cell[7822, 307, 162, 7, 70, "MathCaption",
 CellID->25599],
Cell[CellGroupData[{
Cell[8009, 318, 193, 7, 70, "Input",
 CellID->30041],
Cell[8205, 327, 154, 5, 36, "Output",
 CellID->6925]
}, Open  ]],
Cell[8374, 335, 391, 15, 70, "MathCaption",
 CellID->18074],
Cell[CellGroupData[{
Cell[8790, 354, 67, 2, 70, "Input",
 CellID->12324],
Cell[8860, 358, 155, 5, 36, "Output",
 CellID->10344]
}, Open  ]],
Cell[9030, 366, 124, 5, 70, "MathCaption",
 CellID->29863],
Cell[9157, 373, 98, 3, 70, "Input",
 CellID->13749],
Cell[9258, 378, 393, 13, 70, "Text",
 CellID->29276],
Cell[9654, 393, 1056, 31, 70, "Text",
 CellID->10597],
Cell[10713, 426, 630, 20, 70, "Text",
 CellID->14334],
Cell[11346, 448, 242, 8, 70, "MathCaption",
 CellID->16647],
Cell[CellGroupData[{
Cell[11613, 460, 305, 11, 70, "Input",
 CellID->22426],
Cell[11921, 473, 156, 5, 36, "Output",
 CellID->20043]
}, Open  ]],
Cell[12092, 481, 319, 13, 70, "MathCaption",
 CellID->3244],
Cell[CellGroupData[{
Cell[12436, 498, 308, 11, 70, "Input",
 CellID->13592],
Cell[12747, 511, 157, 5, 36, "Output",
 CellID->28761]
}, Open  ]],
Cell[12919, 519, 137, 4, 70, "MathCaption",
 CellID->17269],
Cell[CellGroupData[{
Cell[13081, 527, 305, 11, 70, "Input",
 CellID->5175],
Cell[13389, 540, 178, 6, 36, "Output",
 CellID->31139]
}, Open  ]],
Cell[13582, 549, 1781, 63, 70, "Text",
 CellID->24696],
Cell[15366, 614, 335, 12, 70, "MathCaption",
 CellID->19481],
Cell[CellGroupData[{
Cell[15726, 630, 369, 13, 70, "Input",
 CellID->14471],
Cell[16098, 645, 373, 13, 36, "Output",
 CellID->30268]
}, Open  ]],
Cell[CellGroupData[{
Cell[16508, 663, 72, 1, 70, "RelatedTutorialsSection",
 CellID->688989791],
Cell[16583, 666, 200, 5, 70, "RelatedTutorials",
 CellID->405226890]
}, Open  ]]
}, Open  ]],
Cell[16810, 675, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

