(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     81762,       3187]
NotebookOptionsPosition[     65595,       2614]
NotebookOutlinePosition[     68933,       2694]
CellTagsIndexPosition[     68838,       2688]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EvaluationOfExpressionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Evaluation of Expressions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Break" :> Documentation`HelpLookup["paclet:ref/Break"], 
          "Catch" :> Documentation`HelpLookup["paclet:ref/Catch"], "Continue" :> 
          Documentation`HelpLookup["paclet:ref/Continue"], "Do" :> 
          Documentation`HelpLookup["paclet:ref/Do"], "FixedPoint" :> 
          Documentation`HelpLookup["paclet:ref/FixedPoint"], "For" :> 
          Documentation`HelpLookup["paclet:ref/For"], "Goto" :> 
          Documentation`HelpLookup["paclet:ref/Goto"], "Label" :> 
          Documentation`HelpLookup["paclet:ref/Label"], "Nest" :> 
          Documentation`HelpLookup["paclet:ref/Nest"], "NestWhile" :> 
          Documentation`HelpLookup["paclet:ref/NestWhile"], "Return" :> 
          Documentation`HelpLookup["paclet:ref/Return"], "Throw" :> 
          Documentation`HelpLookup["paclet:ref/Throw"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"], "While" :> 
          Documentation`HelpLookup["paclet:ref/While"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Break\"\>", 2->"\<\"Catch\"\>", 
       3->"\<\"Continue\"\>", 4->"\<\"Do\"\>", 5->"\<\"FixedPoint\"\>", 
       6->"\<\"For\"\>", 7->"\<\"Goto\"\>", 8->"\<\"Label\"\>", 
       9->"\<\"Nest\"\>", 10->"\<\"NestWhile\"\>", 11->"\<\"Return\"\>", 
       12->"\<\"Throw\"\>", 13->"\<\"True\"\>", 
       14->"\<\"While\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Loops and Control Structures", "Title",
 CellTags->{"S2.6.10", "10.1"},
 CellID->11091],

Cell[TextData[{
 "The execution of a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program involves the evaluation of a sequence of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. In simple programs, the expressions to be evaluated may be \
separated by semicolons, and evaluated one after another. Often, however, you \
need to evaluate expressions several times, in some kind of \"loop\". "
}], "Text",
 CellID->11874],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Do",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Do"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]}], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " repetitively, with ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " varying from ",
     Cell[BoxData["1"], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["max", "TI"]], "TI"]], "InlineFormula"],
     " in steps of ",
     Cell[BoxData["1"], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Do",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Do"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]], ",", 
        StyleBox["di", "TI"]}], "}"}]}], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " varying from ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["min", "TI"]], "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox[
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["max", "TI"]], "TI"]], "InlineFormula"],
     " in steps of ",
     Cell[BoxData[
      StyleBox["di", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Do",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Do"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox["list", "TI"]}], "}"}]}], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " taking on values from ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Do",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Do"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " times"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18563],

Cell["Simple looping constructs. ", "Caption",
 CellID->9125],

Cell[TextData[{
 "This evaluates ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "[", 
   RowBox[{"i", "^", "2"}], "]"}]], "InlineFormula"],
 ", with ",
 Cell[BoxData["i"], "InlineFormula"],
 " running from ",
 Cell[BoxData["1"], "InlineFormula"],
 " to ",
 Cell[BoxData["4"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"i", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->18370],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellID->15121],

Cell[BoxData["4"], "Print",
 CellID->7727],

Cell[BoxData["9"], "Print",
 CellID->2658],

Cell[BoxData["16"], "Print",
 CellID->24336]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "This executes an assignment for ",
 Cell[BoxData["t"], "InlineFormula"],
 " in a loop with ",
 Cell[BoxData["k"], "InlineFormula"],
 " running from ",
 Cell[BoxData["2"], "InlineFormula"],
 " to ",
 Cell[BoxData["6"], "InlineFormula"],
 " in steps of ",
 Cell[BoxData["2"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->18275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", "x"}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"t", "=", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"k", " ", "t"}]}], ")"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "2", ",", "6", ",", "2"}], "}"}]}], "]"}], ";", 
  "t"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->1221],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   FractionBox["6", 
    RowBox[{"1", "+", 
     FractionBox["4", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}]]}]]}]]], "Output",
 ImageSize->{67, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->11576]
}, Open  ]],

Cell[TextData[{
 "The way iteration is specified in ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 " is exactly the same as in functions like ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 ". Just as in those functions, you can set up several nested loops by giving \
a sequence of iteration specifications to ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->1799],

Cell[TextData[{
 "This loops over values of ",
 Cell[BoxData["i"], "InlineFormula"],
 " from ",
 Cell[BoxData["1"], "InlineFormula"],
 " to ",
 Cell[BoxData["4"], "InlineFormula"],
 ", and for each value of ",
 Cell[BoxData["i"], "InlineFormula"],
 ", loops over ",
 Cell[BoxData["j"], "InlineFormula"],
 " from ",
 Cell[BoxData["1"], "InlineFormula"],
 " to ",
 Cell[BoxData[
  RowBox[{"i", "-", "1"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"{", 
     RowBox[{"i", ",", "j"}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", 
     RowBox[{"i", "-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->14241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Print",
 CellID->28611],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "1"}], "}"}]], "Print",
 CellID->5712],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "2"}], "}"}]], "Print",
 CellID->30209],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "1"}], "}"}]], "Print",
 CellID->23635],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "2"}], "}"}]], "Print",
 CellID->23263],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "3"}], "}"}]], "Print",
 CellID->17830]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "Sometimes you may want to repeat a particular operation a certain number of \
times, without changing the value of an iteration variable. You can specify \
this kind of repetition in ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 " just as you can in ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " and other iteration functions. "
}], "Text",
 CellID->8514],

Cell[TextData[{
 "This repeats the assignment ",
 Cell[BoxData[
  RowBox[{"t", "=", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", "t"}], ")"}]}]}]], "InlineFormula"],
 " three times. "
}], "MathCaption",
 CellID->3336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", "x"}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"t", "=", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", "t"}], ")"}]}]}], ",", 
    RowBox[{"{", "3", "}"}]}], "]"}], ";", "t"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->5783],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     FractionBox["1", 
      RowBox[{"1", "+", "x"}]]}]]}]]], "Output",
 ImageSize->{60, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->31032]
}, Open  ]],

Cell[TextData[{
 "You can put a procedure inside ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", "67"}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Print", "[", "t", "]"}], ";", 
     RowBox[{"t", "=", 
      RowBox[{"Floor", "[", 
       RowBox[{"t", "/", "2"}], "]"}]}]}], ",", 
    RowBox[{"{", "3", "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->3339],

Cell[CellGroupData[{

Cell[BoxData["67"], "Print",
 CellID->23705],

Cell[BoxData["33"], "Print",
 CellID->14670],

Cell[BoxData["16"], "Print",
 CellID->15940]
}, Open  ]]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Nest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Nest"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " times"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FixedPoint",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FixedPoint"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "start with ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", and apply ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " repeatedly until the result no longer changes"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NestWhile",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NestWhile"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["test", "TI"], "]"}], Cell[TextData[{
     "start with ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", and apply ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " repeatedly until applying ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " to the result no longer yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->9868],

Cell["Applying functions repetitively. ", "Caption",
 CellID->28391],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 " allows you to repeat operations by evaluating a particular expression many \
times with different values for iteration variables. Often, however, you can \
make more elegant and efficient programs using the functional programming \
constructs discussed in \"",
 ButtonBox["Applying Functions Repeatedly\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ApplyingFunctionsRepeatedly"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Nest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nest"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["x", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 ", for example, allows you to apply a function repeatedly to an expression. \
"
}], "Text",
 CellID->7728],

Cell[TextData[{
 "This nests ",
 Cell[BoxData["f"], "InlineFormula"],
 " three times. "
}], "MathCaption",
 CellID->4985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{"f", ",", "x", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->5537],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"f", "[", 
   RowBox[{"f", "[", "x", "]"}], "]"}], "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->26320]
}, Open  ]],

Cell[TextData[{
 "By nesting a pure function, you can get the same result as in the example \
with ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 " above. "
}], "MathCaption",
 CellID->13124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"t", ",", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", "t"}], ")"}]}]}], "]"}], ",", "x", ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->30997],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     FractionBox["1", 
      RowBox[{"1", "+", "x"}]]}]]}]]], "Output",
 ImageSize->{60, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->9354]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Nest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nest"]], "InlineFormula"],
 " allows you to apply a function a specified number of times. Sometimes, \
however, you may simply want to go on applying a function until the results \
you get no longer change. You can do this using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FixedPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FixedPoint"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->28703],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FixedPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPoint"]], "InlineFormula"],
 " goes on applying a function until the result no longer changes. "
}], "MathCaption",
 CellID->5494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"t", ",", 
     RowBox[{
      RowBox[{"Print", "[", "t", "]"}], ";", 
      RowBox[{"Floor", "[", 
       RowBox[{"t", "/", "2"}], "]"}]}]}], "]"}], ",", "67"}], "]"}]], "Input",\

 CellLabel->"In[8]:= ",
 CellID->30562],

Cell[CellGroupData[{

Cell[BoxData["67"], "Print",
 CellID->23865],

Cell[BoxData["33"], "Print",
 CellID->17554],

Cell[BoxData["16"], "Print",
 CellID->20700],

Cell[BoxData["8"], "Print",
 CellID->32302],

Cell[BoxData["4"], "Print",
 CellID->29714],

Cell[BoxData["2"], "Print",
 CellID->31629],

Cell[BoxData["1"], "Print",
 CellID->16794],

Cell[BoxData["0"], "Print",
 CellID->21026]
}, Open  ]],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->20463]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["FixedPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPoint"]], "InlineFormula"],
 " to imitate the evaluation process in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", or the operation of functions such as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "//.", 
   StyleBox["rules", "TI"]}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["FixedPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPoint"]], "InlineFormula"],
 " goes on until two successive results it gets are the same. ",
 Cell[BoxData[
  ButtonBox["NestWhile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestWhile"]], "InlineFormula"],
 " allows you to go on until an arbitrary function no longer yields ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->528],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Catch",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Catch"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " until ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Throw",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Throw"], "[", 
       StyleBox["value", "TI"], "]"}]], "InlineFormula"],
     " is encountered, then return ",
     Cell[BoxData[
      StyleBox["value", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Catch",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Catch"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " until ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Throw",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Throw"], "[", 
       StyleBox["value", "TI"], ",", 
       StyleBox["tag", "TI"], "]"}]], "InlineFormula"],
     " is encountered, where ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " matches ",
     Cell[BoxData[
      StyleBox["tag", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Catch",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Catch"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], ",", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "return ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["value", "TI"], ",", 
       StyleBox["tag", "TI"], "]"}]], "InlineFormula"],
     " instead of ",
     Cell[BoxData[
      StyleBox["value", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31748],

Cell["\<\
Non\[Hyphen]local control of evaluation. \
\>", "Caption",
 CellID->25679],

Cell[TextData[{
 "When the ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " is encountered, evaluation stops, and the current value of ",
 Cell[BoxData["i"], "InlineFormula"],
 " is returned as the value of the enclosing ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Print", "[", "i", "]"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"i", ">", "3"}], ",", 
       RowBox[{"Throw", "[", "i", "]"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->20199],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellID->3],

Cell[BoxData["2"], "Print",
 CellID->18442],

Cell[BoxData["3"], "Print",
 CellID->19280],

Cell[BoxData["4"], "Print",
 CellID->10016]
}, Open  ]],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->15290]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " provide a flexible way to control the process of evaluation in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The basic idea is that whenever a ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " is encountered, the evaluation that is then being done is stopped, and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " immediately returns to the nearest appropriate enclosing ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 "."
}], "Text",
 CellID->15098],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Scan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scan"]], "InlineFormula"],
 " applies the function ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " to each successive element in the list, and in the end just returns ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->9858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "6", ",", "5", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->1730],

Cell[CellGroupData[{

Cell[BoxData["7"], "Print",
 CellID->8553],

Cell[BoxData["6"], "Print",
 CellID->29551],

Cell[BoxData["5"], "Print",
 CellID->23262],

Cell[BoxData["4"], "Print",
 CellID->444]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "The evaluation of ",
 Cell[BoxData[
  ButtonBox["Scan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scan"]], "InlineFormula"],
 " stops as soon as ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " is encountered, and the enclosing ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " returns as its value the argument of ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21649],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"Scan", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Print", "[", "#", "]"}], ";", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"#", "<", "6"}], ",", 
         RowBox[{"Throw", "[", "#", "]"}]}], "]"}]}], ")"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "6", ",", "5", ",", "4"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->10485],

Cell[CellGroupData[{

Cell[BoxData["7"], "Print",
 CellID->7055],

Cell[BoxData["6"], "Print",
 CellID->12572],

Cell[BoxData["5"], "Print",
 CellID->12889]
}, Open  ]],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->2858]
}, Open  ]],

Cell[TextData[{
 "The same result is obtained with ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 ", even though ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " would have returned a list if its evaluation had not been stopped by \
encountering a ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Print", "[", "#", "]"}], ";", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"#", "<", "6"}], ",", 
         RowBox[{"Throw", "[", "#", "]"}]}], "]"}]}], ")"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "6", ",", "5", ",", "4"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->129],

Cell[CellGroupData[{

Cell[BoxData["7"], "Print",
 CellID->14640],

Cell[BoxData["6"], "Print",
 CellID->6860],

Cell[BoxData["5"], "Print",
 CellID->8046]
}, Open  ]],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->28627]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " to divert the operation of functional programming constructs, allowing for \
example the evaluation of such constructs to continue only until some \
condition has been met. Note that if you stop evaluation using ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 ", then the structure of the result you get may be quite different from what \
you would have got if you had allowed the evaluation to complete. "
}], "Text",
 CellID->5044],

Cell["\<\
Here is a list generated by repeated application of a function. \
\>", "MathCaption",
 CellID->6422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"#", "+", "1"}], ")"}]}], "&"}], ",", 
   RowBox[{"-", "2.5"}], ",", "6"}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->25936],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2.5`"}], ",", 
   RowBox[{"-", "0.6666666666666666`"}], ",", "2.9999999999999996`", ",", 
   "0.25`", ",", "0.8`", ",", "0.5555555555555556`", ",", 
   "0.6428571428571428`"}], "}"}]], "Output",
 ImageSize->{353, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->7473]
}, Open  ]],

Cell[TextData[{
 "Since there is no ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " encountered, the result here is just as before. "
}], "MathCaption",
 CellID->19154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"#", "+", "1"}], ")"}]}], "&"}], ",", 
    RowBox[{"-", "2.5"}], ",", "6"}], "]"}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->333],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2.5`"}], ",", 
   RowBox[{"-", "0.6666666666666666`"}], ",", "2.9999999999999996`", ",", 
   "0.25`", ",", "0.8`", ",", "0.5555555555555556`", ",", 
   "0.6428571428571428`"}], "}"}]], "Output",
 ImageSize->{353, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->8756]
}, Open  ]],

Cell[TextData[{
 "Now the evaluation of the ",
 Cell[BoxData[
  ButtonBox["NestList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestList"]], "InlineFormula"],
 " is diverted, and the single number given as the argument of ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " is returned."
}], "MathCaption",
 CellID->11051],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"#", ">", "1"}], ",", 
       RowBox[{"Throw", "[", "#", "]"}], ",", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"#", "+", "1"}], ")"}]}]}], "]"}], "&"}], ",", 
    RowBox[{"-", "2.5"}], ",", "6"}], "]"}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->25391],

Cell[BoxData["2.9999999999999996`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->16534]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " operate in a completely global way: it does not matter how or where a ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " is generated\[LongDash]it will always stop evaluation and return to the \
enclosing ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->23931],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " stops the evaluation of ",
 Cell[BoxData["f"], "InlineFormula"],
 ", and causes the ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " to return just ",
 Cell[BoxData["a"], "InlineFormula"],
 ", with no trace of ",
 Cell[BoxData["f"], "InlineFormula"],
 " left. "
}], "MathCaption",
 CellID->22322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"f", "[", 
   RowBox[{"Throw", "[", "a", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->27079],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->8202]
}, Open  ]],

Cell[TextData[{
 "This defines a function which generates a ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " when its argument is larger than 10. "
}], "MathCaption",
 CellID->11176],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"x", ">", "10"}], ",", 
    RowBox[{"Throw", "[", "overflow", "]"}], ",", 
    RowBox[{"x", "!"}]}], "]"}]}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->21580],

Cell[TextData[{
 "No ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " is generated here. "
}], "MathCaption",
 CellID->13269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"g", "[", "4", "]"}], "]"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->5388],

Cell[BoxData["24"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->3429]
}, Open  ]],

Cell[TextData[{
 "But here the ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " generated inside the evaluation of ",
 Cell[BoxData["g"], "InlineFormula"],
 " returns to the enclosing ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->15885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"g", "[", "40", "]"}], "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->22002],

Cell[BoxData["overflow"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->27610]
}, Open  ]],

Cell[TextData[{
 "In small programs, it is often adequate to use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Throw",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Throw"], "[", 
   StyleBox["value", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Catch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Catch"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " in their simplest form. But particularly if you write larger programs that \
contain many separate pieces, it is usually much better to use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Throw",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Throw"], "[", 
   RowBox[{
    StyleBox["value", "TI"], ",", 
    StyleBox["tag", "TI"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Catch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Catch"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
 ". By keeping the expressions ",
 Cell[BoxData[
  StyleBox["tag", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " local to a particular piece of your program, you can then ensure that your \
",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " will also operate only within that piece."
}], "Text",
 CellID->16327],

Cell[TextData[{
 "Here the ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " is caught by the inner ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Throw", "[", 
       RowBox[{"x", ",", "a"}], "]"}], ",", "a"}], "]"}], "]"}], ",", "b"}], 
  "]"}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->5760],

Cell[BoxData[
 RowBox[{"f", "[", "x", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]= ",
 CellID->99]
}, Open  ]],

Cell[TextData[{
 "But here it is caught only by the outer ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->25042],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Throw", "[", 
       RowBox[{"x", ",", "b"}], "]"}], ",", "a"}], "]"}], "]"}], ",", "b"}], 
  "]"}]], "Input",
 CellLabel->"In[21]:= ",
 CellID->3055],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]= ",
 CellID->24393]
}, Open  ]],

Cell[TextData[{
 "You can use patterns in specifying the tags which a particular ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " should catch. "
}], "MathCaption",
 CellID->31065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{"Throw", "[", 
    RowBox[{"x", ",", "a"}], "]"}], ",", 
   RowBox[{"a", "|", "b"}]}], "]"}]], "Input",
 CellLabel->"In[22]:= ",
 CellID->4928],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]= ",
 CellID->24572]
}, Open  ]],

Cell[TextData[{
 "This keeps the tag ",
 Cell[BoxData["a"], "InlineFormula"],
 " completely local. "
}], "MathCaption",
 CellID->29284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"Catch", "[", 
    RowBox[{
     RowBox[{"Throw", "[", 
      RowBox[{"x", ",", "a"}], "]"}], ",", "a"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[23]:= ",
 CellID->14726],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]= ",
 CellID->28798]
}, Open  ]],

Cell[TextData[{
 "You should realize that there is no need for the tag that appears in ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " to be a constant; in general it can be any expression."
}], "Text",
 CellID->20523],

Cell[TextData[{
 "Here the inner ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " catches all throws with tags less than 4, and continues the ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 ". But as soon as the tag reaches 4, the outer ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " is needed. "
}], "MathCaption",
 CellID->26201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"Catch", "[", 
      RowBox[{
       RowBox[{"Throw", "[", 
        RowBox[{
         RowBox[{"i", "^", "2"}], ",", "i"}], "]"}], ",", 
       RowBox[{"n_", "/;", 
        RowBox[{"n", "<", "4"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "10"}], "}"}]}], "]"}], ",", "_"}], "]"}]], "Input",
 CellLabel->"In[24]:= ",
 CellID->31587],

Cell[BoxData["16"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]= ",
 CellID->4088]
}, Open  ]],

Cell[TextData[{
 "When you use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Catch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Catch"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Throw",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Throw"], "[", 
   RowBox[{
    StyleBox["value", "TI"], ",", 
    StyleBox["tag", "TI"]}], "]"}]], "InlineFormula"],
 ", the value returned by ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " is simply the expression ",
 Cell[BoxData[
  StyleBox["value", "TI"]], "InlineFormula"],
 " given in the ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 ". If you use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Catch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Catch"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["form", "TI"], ",", 
    StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
 ", however, then the value returned by ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " is instead ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["value", "TI"], ",", 
    StyleBox["tag", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->1997],

Cell[TextData[{
 "Here ",
 Cell[BoxData["f"], "InlineFormula"],
 " is applied to the value and tag in the ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11652],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{"Throw", "[", 
    RowBox[{"x", ",", "a"}], "]"}], ",", "a", ",", "f"}], "]"}]], "Input",
 CellLabel->"In[25]:= ",
 CellID->19175],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"x", ",", "a"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]= ",
 CellID->25750]
}, Open  ]],

Cell[TextData[{
 "If there is no ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 ", ",
 Cell[BoxData["f"], "InlineFormula"],
 " is never used. "
}], "MathCaption",
 CellID->10678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"x", ",", "a", ",", "f"}], "]"}]], "Input",
 CellLabel->"In[26]:= ",
 CellID->11455],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]= ",
 CellID->20893]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["While",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/While"], "[", 
     StyleBox["test", "TI"], ",", 
     StyleBox["body", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["body", "TI"]], "InlineFormula"],
     " repetitively, so long as ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["For",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/For"], "[", 
     StyleBox["start", "TI"], ",", 
     StyleBox["test", "TI"], ",", 
     StyleBox["incr", "TI"], ",", 
     StyleBox["body", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["start", "TI"]], "InlineFormula"],
     ", then repetitively evaluate ",
     Cell[BoxData[
      StyleBox["body", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["incr", "TI"]], "InlineFormula"],
     ", until ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " fails"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10630],

Cell["General loop constructs. ", "Caption",
 CellID->7406],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Nest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nest"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FixedPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPoint"]], "InlineFormula"],
 " provide structured ways to make loops in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs, while ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " provide opportunities for modifying this structure. Sometimes, however, \
you may want to create loops that even from the outset have less structure. \
And in such cases, you may find it convenient to use the functions ",
 Cell[BoxData[
  ButtonBox["While",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/While"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["For",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/For"]], "InlineFormula"],
 ", which perform operations repeatedly, stopping when a specified condition \
fails to be true. "
}], "Text",
 CellID->9531],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["While",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/While"]], "InlineFormula"],
 " loop continues until the condition fails. "
}], "MathCaption",
 CellID->10489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "=", "17"}], ";", 
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "=", 
       RowBox[{"Floor", "[", 
        RowBox[{"n", "/", "2"}], "]"}]}], ")"}], "!=", "0"}], ",", 
    RowBox[{"Print", "[", "n", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[27]:= ",
 CellID->15165],

Cell[CellGroupData[{

Cell[BoxData["8"], "Print",
 CellID->4521],

Cell[BoxData["4"], "Print",
 CellID->30127],

Cell[BoxData["2"], "Print",
 CellID->9964],

Cell[BoxData["1"], "Print",
 CellID->440]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "The functions ",
 Cell[BoxData[
  ButtonBox["While",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/While"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["For",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/For"]], "InlineFormula"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are similar to the control structures ",
 Cell[BoxData["while"], "InlineFormula"],
 " and ",
 Cell[BoxData["for"], "InlineFormula"],
 " in languages such as C. Notice, however, that there are a number of \
important differences. For example, the roles of comma and semicolon are \
reversed in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["For",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/For"]], "InlineFormula"],
 " loops relative to C language ones."
}], "Text",
 CellID->21113],

Cell[TextData[{
 "This is a very common form for a ",
 Cell[BoxData[
  ButtonBox["For",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/For"]], "InlineFormula"],
 " loop. ",
 Cell[BoxData[
  RowBox[{"i", "++"}]], "InlineFormula"],
 " increments the value of ",
 Cell[BoxData["i"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "<", "4"}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{"Print", "[", "i", "]"}]}], "]"}]], "Input",
 CellLabel->"In[28]:= ",
 CellID->22710],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellID->20488],

Cell[BoxData["2"], "Print",
 CellID->13763],

Cell[BoxData["3"], "Print",
 CellID->30320]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "Here is a more complicated ",
 Cell[BoxData[
  ButtonBox["For",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/For"]], "InlineFormula"],
 " loop. Notice that the loop terminates as soon as the test ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"i", "^", "2"}], "<", "10"}]], "InlineFormula"],
 " fails. "
}], "MathCaption",
 CellID->8188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"i", "=", "1"}], ";", 
    RowBox[{"t", "=", "x"}]}], ",", 
   RowBox[{
    RowBox[{"i", "^", "2"}], "<", "10"}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{
    RowBox[{"t", "=", 
     RowBox[{
      RowBox[{"t", "^", "2"}], "+", "i"}]}], ";", 
    RowBox[{"Print", "[", "t", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[29]:= ",
 CellID->23821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "2"]}]], "Print",
 CellID->17264],

Cell[BoxData[
 RowBox[{"2", "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}], ")"}], "2"]}]], "Print",
 CellID->6003],

Cell[BoxData[
 RowBox[{"3", "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"2", "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}], ")"}], "2"]}], ")"}], "2"]}]], "Print",
 CellID->9754]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", both ",
 Cell[BoxData[
  ButtonBox["While",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/While"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["For",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/For"]], "InlineFormula"],
 " always evaluate the loop test before evaluating the body of the loop. As \
soon as the loop test fails to be ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["While",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/While"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["For",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/For"]], "InlineFormula"],
 " terminate. The body of the loop is thus only evaluated in situations where \
the loop test is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->14722],

Cell["\<\
The loop test fails immediately, so the body of the loop is never evaluated. \
\
\>", "MathCaption",
 CellID->25316],

Cell[BoxData[
 RowBox[{"While", "[", 
  RowBox[{"False", ",", 
   RowBox[{"Print", "[", "x", "]"}]}], "]"}]], "Input",
 CellLabel->"In[30]:= ",
 CellID->5854],

Cell[TextData[{
 "In a ",
 Cell[BoxData[
  ButtonBox["While",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/While"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["For",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/For"]], "InlineFormula"],
 " loop, or in general in any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " procedure, the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions you give are evaluated in a definite sequence. You can think \
of this sequence as defining the \[OpenCurlyDoubleQuote]flow of control\
\[CloseCurlyDoubleQuote] in the execution of a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program. "
}], "Text",
 CellID->6586],

Cell[TextData[{
 "In most cases, you should try to keep the flow of control in your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs as simple as possible. The more the flow of control depends for \
example on specific values generated during the execution of the program, the \
more difficult you will typically find it to understand the structure and \
operation of the program. "
}], "Text",
 CellID->26425],

Cell[TextData[{
 "Functional programming constructs typically involve very simple flow of \
control. ",
 Cell[BoxData[
  ButtonBox["While",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/While"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["For",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/For"]], "InlineFormula"],
 " loops are always more complicated, since they are set up to make the flow \
of control depend on the values of the expressions given as tests. \
Nevertheless, even in such loops, the flow of control does not usually depend \
on the values of expressions given in the body of the loop. "
}], "Text",
 CellID->9524],

Cell[TextData[{
 "In some cases, however, you may need to construct ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs in which the flow of control is affected by values generated \
during the execution of a procedure or of the body of a loop. One way to do \
this, which fits in with functional programming ideas, is to use ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 ". But ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also provides various functions for modifying the flow of control which \
work like in languages such as C. "
}], "Text",
 CellID->15818],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Break",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Break"], "[", "]"}], Cell[
    "exit the nearest enclosing loop", "TableText"]},
   {
    RowBox[{
     ButtonBox["Continue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Continue"], "[", "]"}], Cell[
    "go to the next step in the current loop", "TableText"]},
   {
    RowBox[{
     ButtonBox["Return",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Return"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "return the value ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", exiting all procedures and loops in a function"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Goto",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Goto"], "[", 
     StyleBox["name", "TI"], "]"}], Cell[TextData[{
     "go to the element ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Label",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Label"], "[", 
       StyleBox["name", "TI"], "]"}]], "InlineFormula"],
     " in the current procedure"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Throw",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Throw"], "[", 
     StyleBox["value", "TI"], "]"}], Cell[TextData[{
     "return ",
     Cell[BoxData[
      StyleBox["value", "TI"]], "InlineFormula"],
     " as the value of the nearest enclosing ",
     Cell[BoxData[
      ButtonBox["Catch",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
     " (non\[Hyphen]local return)"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->27302],

Cell["Control flow functions. ", "Caption",
 CellID->30120],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Break",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Break"], "[", "]"}]], "InlineFormula"],
 " causes the loop to terminate as soon as ",
 Cell[BoxData["t"], "InlineFormula"],
 " exceeds ",
 Cell[BoxData["19"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->32659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", "1"}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"t", "*=", "k"}], ";", 
     RowBox[{"Print", "[", "t", "]"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"t", ">", "19"}], ",", 
       RowBox[{"Break", "[", "]"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[31]:= ",
 CellID->488],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellID->30682],

Cell[BoxData["2"], "Print",
 CellID->18341],

Cell[BoxData["6"], "Print",
 CellID->2574],

Cell[BoxData["24"], "Print",
 CellID->6500]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  RowBox[{"k", "<", "3"}]], "InlineFormula"],
 ", the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Continue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Continue"], "[", "]"}]], "InlineFormula"],
 " causes the loop to be continued, without executing ",
 Cell[BoxData[
  RowBox[{"t", "+=", "2"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->25566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", "1"}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"t", "*=", "k"}], ";", 
     RowBox[{"Print", "[", "t", "]"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"k", "<", "3"}], ",", 
       RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
     RowBox[{"t", "+=", "2"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[32]:= ",
 CellID->26222],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellID->5754],

Cell[BoxData["2"], "Print",
 CellID->1552],

Cell[BoxData["6"], "Print",
 CellID->850],

Cell[BoxData["32"], "Print",
 CellID->1516],

Cell[BoxData["170"], "Print",
 CellID->13226],

Cell[BoxData["1032"], "Print",
 CellID->23486],

Cell[BoxData["7238"], "Print",
 CellID->6602],

Cell[BoxData["57920"], "Print",
 CellID->7737],

Cell[BoxData["521298"], "Print",
 CellID->28901],

Cell[BoxData["5213000"], "Print",
 CellID->17901]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Return",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Return"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " allows you to exit a particular function, returning a value. You can think \
of ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " as a kind of non\[Hyphen]local return which allows you to exit a whole \
sequence of nested functions. Such behavior can be convenient for handling \
certain error conditions. "
}], "Text",
 CellID->22749],

Cell[TextData[{
 "Here is an example of the use of ",
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 ". This particular procedure could equally well have been written without \
using ",
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->15967],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"x", ">", "5"}], ",", 
      RowBox[{"Return", "[", "big", "]"}]}], "]"}], ";", 
    RowBox[{"t", "=", 
     RowBox[{"x", "^", "3"}]}], ";", 
    RowBox[{"Return", "[", 
     RowBox[{"t", "-", "7"}], "]"}]}], ")"}]}]], "Input",
 CellLabel->"In[33]:= ",
 CellID->30102],

Cell[TextData[{
 "When the argument is greater than 5, the first ",
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 " in the procedure is used. "
}], "MathCaption",
 CellID->4265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "10", "]"}]], "Input",
 CellLabel->"In[34]:= ",
 CellID->21881],

Cell[BoxData["big"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]= ",
 CellID->31843]
}, Open  ]],

Cell[TextData[{
 "This function \"throws\" ",
 Cell[BoxData["error"], "InlineFormula"],
 " if its argument is negative. "
}], "MathCaption",
 CellID->16710],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", "x_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"x", "<", "0"}], ",", 
    RowBox[{"Throw", "[", "error", "]"}], ",", 
    RowBox[{"Sqrt", "[", "x", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[35]:= ",
 CellID->14508],

Cell[TextData[{
 "No ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " is generated here. "
}], "MathCaption",
 CellID->26489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{"h", "[", "6", "]"}], "+", "2"}], "]"}]], "Input",
 CellLabel->"In[36]:= ",
 CellID->10184],

Cell[BoxData[
 RowBox[{"2", "+", 
  SqrtBox["6"]}]], "Output",
 ImageSize->{48, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[36]= ",
 CellID->18121]
}, Open  ]],

Cell[TextData[{
 "But in this case a ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " is generated, and the whole ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " returns the value ",
 Cell[BoxData["error"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"-", "6"}], "]"}], "+", "2"}], "]"}]], "Input",
 CellLabel->"In[37]:= ",
 CellID->23987],

Cell[BoxData["error"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]= ",
 CellID->31371]
}, Open  ]],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Continue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Continue"], "[", "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Break",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Break"], "[", "]"}]], "InlineFormula"],
 " allow you to \"transfer control\" to the beginning or end of a loop in a \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program. Sometimes you may instead need to transfer control to a \
particular element in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " procedure. If you give a ",
 Cell[BoxData[
  ButtonBox["Label",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Label"]], "InlineFormula"],
 " as an element in a procedure, you can use ",
 Cell[BoxData[
  ButtonBox["Goto",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Goto"]], "InlineFormula"],
 " to transfer control to this element. "
}], "Text",
 CellID->32490],

Cell[TextData[{
 "This goes on looping until ",
 Cell[BoxData["q"], "InlineFormula"],
 " exceeds ",
 Cell[BoxData["6"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24972],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"(", 
  RowBox[{
   RowBox[{"q", "=", "2"}], ";", 
   RowBox[{"Label", "[", "begin", "]"}], ";", 
   RowBox[{"Print", "[", "q", "]"}], ";", 
   RowBox[{"q", "+=", "3"}], ";", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"q", "<", "6"}], ",", 
     RowBox[{"Goto", "[", "begin", "]"}]}], "]"}]}], ")"}]], "Input",
 CellLabel->"In[38]:= ",
 CellID->10518],

Cell[CellGroupData[{

Cell[BoxData["2"], "Print",
 CellID->2073],

Cell[BoxData["5"], "Print",
 CellID->32353]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "Note that you can use ",
 Cell[BoxData[
  ButtonBox["Goto",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Goto"]], "InlineFormula"],
 " in a particular ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " procedure only when the ",
 Cell[BoxData[
  ButtonBox["Label",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Label"]], "InlineFormula"],
 " it specifies occurs as an element of the same ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " procedure. In general, use of ",
 Cell[BoxData[
  ButtonBox["Goto",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Goto"]], "InlineFormula"],
 " reduces the degree of structure that can readily be perceived in a \
program, and therefore makes the operation of the program more difficult to \
understand. "
}], "Text",
 CellID->1281],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->412218282],

Cell[TextData[ButtonBox["Evaluation of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EvaluationOfExpressionsOverview"]], "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Loops and Control Structures - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Evaluation of Expressions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/EvaluationOfExpressionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Conditionals"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/CollectingExpressionsDuringEvaluation"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 46.6791160}", "context" -> "", 
    "keywords" -> {
     "abort", "break", "catch", "compound expressions", "computed goto", 
      "continue", "control", "control structures", "divert", "do", 
      "evaluation", "exception handling", "FixedPoint", "flow of control", 
      "for", "functions", "Goto", "handling", "iterated functions", 
      "iteration", "jump", "label", "loops", "nest", "nested loops", 
      "NestList", "NestWhile", "nonlocal returns", "procedures", 
      "program flow", "repeat", "return", "returns", "routines", "Scan", 
      "scope", "stop", "structured programming", "subroutines", "throw", 
      "until", "while"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The execution of a Mathematica program involves the evaluation of a \
sequence of Mathematica expressions. In simple programs, the expressions to \
be evaluated may be separated by semicolons, and evaluated one after another. \
Often, however, you need to evaluate expressions several times, in some kind \
of \"loop\". Simple looping constructs. This evaluates Print[i^2], with i \
running from 1 to 4. ", "synonyms" -> {"2.6.9"}, "title" -> 
    "Loops and Control Structures", "type" -> "Tutorial", "uri" -> 
    "tutorial/LoopsAndControlStructures"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.6.10"->{
  Cell[3006, 75, 93, 2, 70, "Title",
   CellTags->{"S2.6.10", "10.1"},
   CellID->11091]},
 "10.1"->{
  Cell[3006, 75, 93, 2, 70, "Title",
   CellTags->{"S2.6.10", "10.1"},
   CellID->11091]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.6.10", 68622, 2677},
 {"10.1", 68724, 2681}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2381, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3006, 75, 93, 2, 70, "Title",
 CellTags->{"S2.6.10", "10.1"},
 CellID->11091],
Cell[3102, 79, 449, 11, 70, "Text",
 CellID->11874],
Cell[3554, 92, 3245, 114, 70, "DefinitionBox",
 CellID->18563],
Cell[6802, 208, 61, 1, 70, "Caption",
 CellID->9125],
Cell[6866, 211, 397, 16, 70, "MathCaption",
 CellID->7007],
Cell[CellGroupData[{
Cell[7288, 231, 225, 8, 70, "Input",
 CellID->18370],
Cell[CellGroupData[{
Cell[7538, 243, 43, 1, 70, "Print",
 CellID->15121],
Cell[7584, 246, 42, 1, 70, "Print",
 CellID->7727],
Cell[7629, 249, 42, 1, 70, "Print",
 CellID->2658],
Cell[7674, 252, 44, 1, 70, "Print",
 CellID->24336]
}, Open  ]]
}, Open  ]],
Cell[7745, 257, 350, 13, 70, "MathCaption",
 CellID->18275],
Cell[CellGroupData[{
Cell[8120, 274, 383, 14, 70, "Input",
 CellID->1221],
Cell[8506, 290, 324, 12, 68, "Output",
 CellID->11576]
}, Open  ]],
Cell[8845, 305, 705, 24, 70, "Text",
 CellID->1799],
Cell[9553, 331, 463, 18, 70, "MathCaption",
 CellID->24919],
Cell[CellGroupData[{
Cell[10041, 353, 336, 12, 70, "Input",
 CellID->14241],
Cell[CellGroupData[{
Cell[10402, 369, 88, 3, 70, "Print",
 CellID->28611],
Cell[10493, 374, 87, 3, 70, "Print",
 CellID->5712],
Cell[10583, 379, 88, 3, 70, "Print",
 CellID->30209],
Cell[10674, 384, 88, 3, 70, "Print",
 CellID->23635],
Cell[10765, 389, 88, 3, 70, "Print",
 CellID->23263],
Cell[10856, 394, 88, 3, 70, "Print",
 CellID->17830]
}, Open  ]]
}, Open  ]],
Cell[10971, 401, 511, 15, 70, "Text",
 CellID->8514],
Cell[11485, 418, 236, 9, 70, "MathCaption",
 CellID->3336],
Cell[CellGroupData[{
Cell[11746, 431, 305, 11, 70, "Input",
 CellID->5783],
Cell[12054, 444, 296, 11, 68, "Output",
 CellID->31032]
}, Open  ]],
Cell[12365, 458, 199, 8, 70, "MathCaption",
 CellID->24988],
Cell[CellGroupData[{
Cell[12589, 470, 340, 12, 70, "Input",
 CellID->3339],
Cell[CellGroupData[{
Cell[12954, 486, 44, 1, 70, "Print",
 CellID->23705],
Cell[13001, 489, 44, 1, 70, "Print",
 CellID->14670],
Cell[13048, 492, 44, 1, 70, "Print",
 CellID->15940]
}, Open  ]]
}, Open  ]],
Cell[13119, 497, 2018, 66, 70, "DefinitionBox",
 CellID->9868],
Cell[15140, 565, 68, 1, 70, "Caption",
 CellID->28391],
Cell[15211, 568, 869, 25, 70, "Text",
 CellID->7728],
Cell[16083, 595, 121, 5, 70, "MathCaption",
 CellID->4985],
Cell[CellGroupData[{
Cell[16229, 604, 129, 4, 70, "Input",
 CellID->5537],
Cell[16361, 610, 239, 8, 36, "Output",
 CellID->26320]
}, Open  ]],
Cell[16615, 621, 255, 9, 70, "MathCaption",
 CellID->13124],
Cell[CellGroupData[{
Cell[16895, 634, 275, 10, 70, "Input",
 CellID->30997],
Cell[17173, 646, 295, 11, 68, "Output",
 CellID->9354]
}, Open  ]],
Cell[17483, 660, 585, 18, 70, "Text",
 CellID->28703],
Cell[18071, 680, 241, 7, 70, "MathCaption",
 CellID->5494],
Cell[CellGroupData[{
Cell[18337, 691, 316, 11, 70, "Input",
 CellID->30562],
Cell[CellGroupData[{
Cell[18678, 706, 44, 1, 70, "Print",
 CellID->23865],
Cell[18725, 709, 44, 1, 70, "Print",
 CellID->17554],
Cell[18772, 712, 44, 1, 70, "Print",
 CellID->20700],
Cell[18819, 715, 43, 1, 70, "Print",
 CellID->32302],
Cell[18865, 718, 43, 1, 70, "Print",
 CellID->29714],
Cell[18911, 721, 43, 1, 70, "Print",
 CellID->31629],
Cell[18957, 724, 43, 1, 70, "Print",
 CellID->16794],
Cell[19003, 727, 43, 1, 70, "Print",
 CellID->21026]
}, Open  ]],
Cell[19061, 731, 155, 5, 36, "Output",
 CellID->20463]
}, Open  ]],
Cell[19231, 739, 932, 31, 70, "Text",
 CellID->528],
Cell[20166, 772, 2200, 72, 70, "DefinitionBox",
 CellID->31748],
Cell[22369, 846, 84, 3, 70, "Caption",
 CellID->25679],
Cell[22456, 851, 447, 15, 70, "MathCaption",
 CellID->21351],
Cell[CellGroupData[{
Cell[22928, 870, 387, 13, 70, "Input",
 CellID->20199],
Cell[CellGroupData[{
Cell[23340, 887, 39, 1, 70, "Print",
 CellID->3],
Cell[23382, 890, 43, 1, 70, "Print",
 CellID->18442],
Cell[23428, 893, 43, 1, 70, "Print",
 CellID->19280],
Cell[23474, 896, 43, 1, 70, "Print",
 CellID->10016]
}, Open  ]],
Cell[23532, 900, 155, 5, 36, "Output",
 CellID->15290]
}, Open  ]],
Cell[23702, 908, 858, 28, 70, "Text",
 CellID->15098],
Cell[24563, 938, 491, 17, 70, "MathCaption",
 CellID->9858],
Cell[CellGroupData[{
Cell[25079, 959, 193, 6, 70, "Input",
 CellID->1730],
Cell[CellGroupData[{
Cell[25297, 969, 42, 1, 70, "Print",
 CellID->8553],
Cell[25342, 972, 43, 1, 70, "Print",
 CellID->29551],
Cell[25388, 975, 43, 1, 70, "Print",
 CellID->23262],
Cell[25434, 978, 41, 1, 70, "Print",
 CellID->444]
}, Open  ]]
}, Open  ]],
Cell[25502, 983, 635, 23, 70, "MathCaption",
 CellID->21649],
Cell[CellGroupData[{
Cell[26162, 1010, 470, 16, 70, "Input",
 CellID->10485],
Cell[CellGroupData[{
Cell[26657, 1030, 42, 1, 70, "Print",
 CellID->7055],
Cell[26702, 1033, 43, 1, 70, "Print",
 CellID->12572],
Cell[26748, 1036, 43, 1, 70, "Print",
 CellID->12889]
}, Open  ]],
Cell[26806, 1040, 155, 5, 36, "Output",
 CellID->2858]
}, Open  ]],
Cell[26976, 1048, 536, 19, 70, "MathCaption",
 CellID->17552],
Cell[CellGroupData[{
Cell[27537, 1071, 467, 16, 70, "Input",
 CellID->129],
Cell[CellGroupData[{
Cell[28029, 1091, 43, 1, 70, "Print",
 CellID->14640],
Cell[28075, 1094, 42, 1, 70, "Print",
 CellID->6860],
Cell[28120, 1097, 42, 1, 70, "Print",
 CellID->8046]
}, Open  ]],
Cell[28177, 1101, 156, 5, 36, "Output",
 CellID->28627]
}, Open  ]],
Cell[28348, 1109, 774, 21, 70, "Text",
 CellID->5044],
Cell[29125, 1132, 110, 3, 70, "MathCaption",
 CellID->6422],
Cell[CellGroupData[{
Cell[29260, 1139, 253, 9, 70, "Input",
 CellID->25936],
Cell[29516, 1150, 379, 11, 36, "Output",
 CellID->7473]
}, Open  ]],
Cell[29910, 1164, 239, 8, 70, "MathCaption",
 CellID->19154],
Cell[CellGroupData[{
Cell[30174, 1176, 289, 10, 70, "Input",
 CellID->333],
Cell[30466, 1188, 379, 11, 36, "Output",
 CellID->8756]
}, Open  ]],
Cell[30860, 1202, 396, 13, 70, "MathCaption",
 CellID->11051],
Cell[CellGroupData[{
Cell[31281, 1219, 431, 14, 70, "Input",
 CellID->25391],
Cell[31715, 1235, 174, 5, 36, "Output",
 CellID->16534]
}, Open  ]],
Cell[31904, 1243, 677, 23, 70, "Text",
 CellID->23931],
Cell[32584, 1268, 507, 19, 70, "MathCaption",
 CellID->22322],
Cell[CellGroupData[{
Cell[33116, 1291, 160, 5, 70, "Input",
 CellID->27079],
Cell[33279, 1298, 155, 5, 36, "Output",
 CellID->8202]
}, Open  ]],
Cell[33449, 1306, 252, 8, 70, "MathCaption",
 CellID->11176],
Cell[33704, 1316, 270, 9, 70, "Input",
 CellID->21580],
Cell[33977, 1327, 195, 8, 70, "MathCaption",
 CellID->13269],
Cell[CellGroupData[{
Cell[34197, 1339, 126, 4, 70, "Input",
 CellID->5388],
Cell[34326, 1345, 156, 5, 36, "Output",
 CellID->3429]
}, Open  ]],
Cell[34497, 1353, 410, 15, 70, "MathCaption",
 CellID->15885],
Cell[CellGroupData[{
Cell[34932, 1372, 128, 4, 70, "Input",
 CellID->22002],
Cell[35063, 1378, 163, 5, 36, "Output",
 CellID->27610]
}, Open  ]],
Cell[35241, 1386, 1556, 53, 70, "Text",
 CellID->16327],
Cell[36800, 1441, 325, 13, 70, "MathCaption",
 CellID->14274],
Cell[CellGroupData[{
Cell[37150, 1458, 277, 10, 70, "Input",
 CellID->5760],
Cell[37430, 1470, 180, 6, 36, "Output",
 CellID->99]
}, Open  ]],
Cell[37625, 1479, 214, 8, 70, "MathCaption",
 CellID->25042],
Cell[CellGroupData[{
Cell[37864, 1491, 277, 10, 70, "Input",
 CellID->3055],
Cell[38144, 1503, 156, 5, 36, "Output",
 CellID->24393]
}, Open  ]],
Cell[38315, 1511, 250, 8, 70, "MathCaption",
 CellID->31065],
Cell[CellGroupData[{
Cell[38590, 1523, 203, 7, 70, "Input",
 CellID->4928],
Cell[38796, 1532, 156, 5, 36, "Output",
 CellID->24572]
}, Open  ]],
Cell[38967, 1540, 135, 5, 70, "MathCaption",
 CellID->29284],
Cell[CellGroupData[{
Cell[39127, 1549, 267, 9, 70, "Input",
 CellID->14726],
Cell[39397, 1560, 156, 5, 36, "Output",
 CellID->28798]
}, Open  ]],
Cell[39568, 1568, 289, 8, 70, "Text",
 CellID->20523],
Cell[39860, 1578, 536, 18, 70, "MathCaption",
 CellID->26201],
Cell[CellGroupData[{
Cell[40421, 1600, 448, 15, 70, "Input",
 CellID->31587],
Cell[40872, 1617, 156, 5, 36, "Output",
 CellID->4088]
}, Open  ]],
Cell[41043, 1625, 1471, 56, 70, "Text",
 CellID->1997],
Cell[42517, 1683, 262, 10, 70, "MathCaption",
 CellID->11652],
Cell[CellGroupData[{
Cell[42804, 1697, 190, 6, 70, "Input",
 CellID->19175],
Cell[42997, 1705, 206, 7, 36, "Output",
 CellID->25750]
}, Open  ]],
Cell[43218, 1715, 248, 10, 70, "MathCaption",
 CellID->10678],
Cell[CellGroupData[{
Cell[43491, 1729, 132, 4, 70, "Input",
 CellID->11455],
Cell[43626, 1735, 156, 5, 36, "Output",
 CellID->20893]
}, Open  ]],
Cell[43797, 1743, 1548, 51, 70, "DefinitionBox",
 CellID->10630],
Cell[45348, 1796, 59, 1, 70, "Caption",
 CellID->7406],
Cell[45410, 1799, 1330, 44, 70, "Text",
 CellID->9531],
Cell[46743, 1845, 219, 8, 70, "MathCaption",
 CellID->10489],
Cell[CellGroupData[{
Cell[46987, 1857, 349, 12, 70, "Input",
 CellID->15165],
Cell[CellGroupData[{
Cell[47361, 1873, 42, 1, 70, "Print",
 CellID->4521],
Cell[47406, 1876, 43, 1, 70, "Print",
 CellID->30127],
Cell[47452, 1879, 42, 1, 70, "Print",
 CellID->9964],
Cell[47497, 1882, 41, 1, 70, "Print",
 CellID->440]
}, Open  ]]
}, Open  ]],
Cell[47565, 1887, 854, 30, 70, "Text",
 CellID->21113],
Cell[48422, 1919, 340, 13, 70, "MathCaption",
 CellID->30389],
Cell[CellGroupData[{
Cell[48787, 1936, 241, 8, 70, "Input",
 CellID->22710],
Cell[CellGroupData[{
Cell[49053, 1948, 43, 1, 70, "Print",
 CellID->20488],
Cell[49099, 1951, 43, 1, 70, "Print",
 CellID->13763],
Cell[49145, 1954, 43, 1, 70, "Print",
 CellID->30320]
}, Open  ]]
}, Open  ]],
Cell[49215, 1959, 352, 12, 70, "MathCaption",
 CellID->8188],
Cell[CellGroupData[{
Cell[49592, 1975, 420, 15, 70, "Input",
 CellID->23821],
Cell[CellGroupData[{
Cell[50037, 1994, 89, 3, 70, "Print",
 CellID->17264],
Cell[50129, 1999, 164, 6, 70, "Print",
 CellID->6003],
Cell[50296, 2007, 249, 9, 70, "Print",
 CellID->9754]
}, Open  ]]
}, Open  ]],
Cell[50572, 2020, 1026, 38, 70, "Text",
 CellID->14722],
Cell[51601, 2060, 126, 4, 70, "MathCaption",
 CellID->25316],
Cell[51730, 2066, 158, 5, 70, "Input",
 CellID->5854],
Cell[51891, 2073, 699, 24, 70, "Text",
 CellID->6586],
Cell[52593, 2099, 425, 9, 70, "Text",
 CellID->26425],
Cell[53021, 2110, 652, 17, 70, "Text",
 CellID->9524],
Cell[53676, 2129, 777, 22, 70, "Text",
 CellID->15818],
Cell[54456, 2153, 2004, 64, 70, "DefinitionBox",
 CellID->27302],
Cell[56463, 2219, 59, 1, 70, "Caption",
 CellID->30120],
Cell[56525, 2222, 341, 13, 70, "MathCaption",
 CellID->32659],
Cell[CellGroupData[{
Cell[56891, 2239, 433, 15, 70, "Input",
 CellID->488],
Cell[CellGroupData[{
Cell[57349, 2258, 43, 1, 70, "Print",
 CellID->30682],
Cell[57395, 2261, 43, 1, 70, "Print",
 CellID->18341],
Cell[57441, 2264, 42, 1, 70, "Print",
 CellID->2574],
Cell[57486, 2267, 43, 1, 70, "Print",
 CellID->6500]
}, Open  ]]
}, Open  ]],
Cell[57556, 2272, 402, 15, 70, "MathCaption",
 CellID->25566],
Cell[CellGroupData[{
Cell[57983, 2291, 474, 16, 70, "Input",
 CellID->26222],
Cell[CellGroupData[{
Cell[58482, 2311, 42, 1, 70, "Print",
 CellID->5754],
Cell[58527, 2314, 42, 1, 70, "Print",
 CellID->1552],
Cell[58572, 2317, 41, 1, 70, "Print",
 CellID->850],
Cell[58616, 2320, 43, 1, 70, "Print",
 CellID->1516],
Cell[58662, 2323, 45, 1, 70, "Print",
 CellID->13226],
Cell[58710, 2326, 46, 1, 70, "Print",
 CellID->23486],
Cell[58759, 2329, 45, 1, 70, "Print",
 CellID->6602],
Cell[58807, 2332, 46, 1, 70, "Print",
 CellID->7737],
Cell[58856, 2335, 48, 1, 70, "Print",
 CellID->28901],
Cell[58907, 2338, 49, 1, 70, "Print",
 CellID->17901]
}, Open  ]]
}, Open  ]],
Cell[58983, 2343, 592, 17, 70, "Text",
 CellID->22749],
Cell[59578, 2362, 410, 14, 70, "MathCaption",
 CellID->15967],
Cell[59991, 2378, 412, 14, 70, "Input",
 CellID->30102],
Cell[60406, 2394, 247, 8, 70, "MathCaption",
 CellID->4265],
Cell[CellGroupData[{
Cell[60678, 2406, 96, 3, 70, "Input",
 CellID->21881],
Cell[60777, 2411, 158, 5, 36, "Output",
 CellID->31843]
}, Open  ]],
Cell[60950, 2419, 156, 5, 70, "MathCaption",
 CellID->16710],
Cell[61109, 2426, 279, 9, 70, "Input",
 CellID->14508],
Cell[61391, 2437, 195, 8, 70, "MathCaption",
 CellID->26489],
Cell[CellGroupData[{
Cell[61611, 2449, 151, 5, 70, "Input",
 CellID->10184],
Cell[61765, 2456, 190, 7, 38, "Output",
 CellID->18121]
}, Open  ]],
Cell[61970, 2466, 406, 15, 70, "MathCaption",
 CellID->10106],
Cell[CellGroupData[{
Cell[62401, 2485, 171, 6, 70, "Input",
 CellID->23987],
Cell[62575, 2493, 160, 5, 36, "Output",
 CellID->31371]
}, Open  ]],
Cell[62750, 2501, 978, 33, 70, "Text",
 CellID->32490],
Cell[63731, 2536, 178, 7, 70, "MathCaption",
 CellID->24972],
Cell[CellGroupData[{
Cell[63934, 2547, 381, 12, 70, "Input",
 CellID->10518],
Cell[CellGroupData[{
Cell[64340, 2563, 42, 1, 70, "Print",
 CellID->2073],
Cell[64385, 2566, 43, 1, 70, "Print",
 CellID->32353]
}, Open  ]]
}, Open  ]],
Cell[64455, 2571, 806, 26, 70, "Text",
 CellID->1281],
Cell[CellGroupData[{
Cell[65286, 2601, 72, 1, 70, "RelatedTutorialsSection",
 CellID->412218282],
Cell[65361, 2604, 180, 4, 70, "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],
Cell[65568, 2612, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

