(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20956,        738]
NotebookOptionsPosition[     15672,        570]
NotebookOutlinePosition[     18396,        641]
CellTagsIndexPosition[     18303,        635]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Textual Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TextualInputAndOutputOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Textual Input and Output\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MakeBoxes" :> Documentation`HelpLookup["paclet:ref/MakeBoxes"],
           "MakeExpression" :> 
          Documentation`HelpLookup["paclet:ref/MakeExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MakeBoxes\"\>", 
       2->"\<\"MakeExpression\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\<\
Low\[Hyphen]Level Input and Output Rules\
\>", "Title",
 CellTags->{"S2.9.17", "17.1"},
 CellID->27901],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MakeBoxes",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MakeBoxes"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "construct boxes to represent ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " in the specified form"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MakeExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MakeExpression"], "[", 
     StyleBox["boxes", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "construct an expression corresponding to ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->15343],

Cell["\<\
Low\[Hyphen]level functions for converting between expressions and boxes. \
\>", "Caption",
 CellID->5876],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MakeBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeBoxes"]], "InlineFormula"],
 " generates boxes without evaluating its input. "
}], "MathCaption",
 CellID->1731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeBoxes", "[", 
  RowBox[{
   RowBox[{"2", "+", "2"}], ",", "StandardForm"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->27500],

Cell[BoxData[
 RowBox[{"RowBox", "[", 
  RowBox[{"{", 
   RowBox[{"\<\"2\"\>", ",", "\<\"+\"\>", ",", "\<\"2\"\>"}], "}"}], 
  "]"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->15648]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MakeExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeExpression"]], "InlineFormula"],
 " interprets boxes but uses ",
 Cell[BoxData[
  ButtonBox["HoldComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldComplete"]], "InlineFormula"],
 " to prevent the resulting expression from being evaluated. "
}], "MathCaption",
 CellID->13613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeExpression", "[", 
  RowBox[{"%", ",", "StandardForm"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->253],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"2", "+", "2"}], "]"}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->20311]
}, Open  ]],

Cell[TextData[{
 "Built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are a large number of rules for generating output and interpreting input. \
Particularly in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", these rules are carefully set up to be consistent, and to allow input and \
output to be used interchangeably. "
}], "Text",
 CellID->9693],

Cell[TextData[{
 "It is fairly rare that you will need to modify these rules. The main reason \
is that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " already has built\[Hyphen]in rules for the input and output of many \
operators to which it does not itself assign specific meanings. "
}], "Text",
 CellID->6332],

Cell[TextData[{
 "Thus, if you want to add, for example, a generalized form of addition, you \
can usually just use an operator like ",
 Cell[BoxData[
  FormBox["\[CirclePlus]", TraditionalForm]], "InlineMath"],
 " for which ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " already has built\[Hyphen]in input and output rules. "
}], "Text",
 CellID->27451],

Cell[TextData[{
 "This outputs using the ",
 Cell[BoxData[
  FormBox["\[CirclePlus]", TraditionalForm]], "InlineMath"],
 " operator. "
}], "MathCaption",
 CellID->1814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CirclePlus", "[", 
  RowBox[{"u", ",", "v", ",", "w"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->31599],

Cell[BoxData[
 RowBox[{"u", "\[CirclePlus]", "v", "\[CirclePlus]", "w"}]], "Output",
 ImageSize->{48, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->216]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " understands ",
 Cell[BoxData[
  FormBox["\[CirclePlus]", TraditionalForm]], "InlineMath"],
 " on input. "
}], "MathCaption",
 CellID->23212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
  "u", " ", "\[CirclePlus]", " ", "v", " ", "\[CirclePlus]", " ", "w"}], "//",
   "FullForm"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->6834],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"CirclePlus", "[", 
    RowBox[{"u", ",", "v", ",", "w"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//FullForm= ",
 CellID->3849]
}, Open  ]],

Cell[TextData[{
 "In dealing with output, you can make definitions for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Format",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Format"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " to change the way that a particular expression will be formatted. You \
should realize, however, that as soon as you do this, there is no guarantee \
that the output form of your expression will be interpreted correctly if it \
is given as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input. "
}], "Text",
 CellID->32252],

Cell[TextData[{
 "If you want to, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to redefine the basic rules that it uses for the input and \
output of all expressions. You can do this by making definitions for ",
 Cell[BoxData[
  ButtonBox["MakeBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeBoxes"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MakeExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeExpression"]], "InlineFormula"],
 ". You should realize, however, that unless you make such definitions with \
great care, you are likely to end up with inconsistent results. "
}], "Text",
 CellID->20912],

Cell[TextData[{
 "This defines how ",
 Cell[BoxData["gplus"], "InlineFormula"],
 " objects should be output in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10141],

Cell[BoxData[
 RowBox[{"gplus", "/:", 
  RowBox[{"MakeBoxes", "[", 
   RowBox[{
    RowBox[{"gplus", "[", 
     RowBox[{"x_", ",", "y_", ",", "n_"}], "]"}], ",", "StandardForm"}], 
   "]"}], ":=", 
  RowBox[{"RowBox", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"MakeBoxes", "[", 
      RowBox[{"x", ",", "StandardForm"}], "]"}], ",", 
     RowBox[{"SubscriptBox", "[", 
      RowBox[{"\"\<\[CirclePlus]\>\"", ",", 
       RowBox[{"MakeBoxes", "[", 
        RowBox[{"n", ",", "StandardForm"}], "]"}]}], "]"}], ",", 
     RowBox[{"MakeBoxes", "[", 
      RowBox[{"y", ",", "StandardForm"}], "]"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->23209],

Cell[TextData[{
 Cell[BoxData["gplus"], "InlineFormula"],
 " is now output using a subscripted ",
 Cell[BoxData[
  FormBox["\[CirclePlus]", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->27450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gplus", "[", 
  RowBox[{"a", ",", "b", ",", 
   RowBox[{"m", "+", "n"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->9180],

Cell[BoxData[
 RowBox[{"a", 
  SubscriptBox["\[CirclePlus]", 
   RowBox[{"m", "+", "n"}]], "b"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->17569]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " cannot however interpret this as input. "
}], "MathCaption",
 CellID->9535],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", 
  SubscriptBox["\[CirclePlus]", 
   RowBox[{"m", "+", "n"}]], "b"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->4562],

Cell[BoxData[
 RowBox[{
  RowBox[{"Syntax", "::", "\<\"sntxi\"\>"}], ":", 
  " ", "\<\"Incomplete expression; more input is \
needed.\\!\\(\\\"\\\"\\)\"\>"}]], "Message", "MSG",
 CellID->23365]
}, Open  ]],

Cell[TextData[{
 "This tells ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to interpret a subscripted ",
 Cell[BoxData[
  FormBox["\[CirclePlus]", TraditionalForm]], "InlineMath"],
 " as a specific piece of ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " input. "
}], "MathCaption",
 CellID->25111],

Cell[BoxData[
 RowBox[{
  RowBox[{"MakeExpression", "[", 
   RowBox[{
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{"x_", ",", 
       RowBox[{"SubscriptBox", "[", 
        RowBox[{"\"\<\[CirclePlus]\>\"", ",", "n_"}], "]"}], ",", "y_"}], 
      "}"}], "]"}], ",", "StandardForm"}], "]"}], ":=", 
  RowBox[{"MakeExpression", "[", 
   RowBox[{
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{
      "\"\<gplus\>\"", ",", "\"\<[\>\"", ",", "x", ",", "\"\<,\>\"", ",", "y",
        ",", "\"\<,\>\"", ",", "n", ",", "\"\<]\>\""}], "}"}], "]"}], ",", 
    "StandardForm"}], "]"}]}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->12817],

Cell[TextData[{
 "Now the subscripted ",
 Cell[BoxData[
  FormBox["\[CirclePlus]", TraditionalForm]], "InlineMath"],
 " is interpreted as a ",
 Cell[BoxData["gplus"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11011],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", 
   SubscriptBox["\[CirclePlus]", 
    RowBox[{"m", "+", "n"}]], "b"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->763],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"gplus", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"Plus", "[", 
      RowBox[{"m", ",", "n"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{157, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//FullForm= ",
 CellID->31321]
}, Open  ]],

Cell[TextData[{
 "When you give definitions for ",
 Cell[BoxData[
  ButtonBox["MakeBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeBoxes"]], "InlineFormula"],
 ", you can think of this as essentially a lower\[Hyphen]level version of \
giving definitions for ",
 Cell[BoxData[
  ButtonBox["Format",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Format"]], "InlineFormula"],
 ". An important difference is that ",
 Cell[BoxData[
  ButtonBox["MakeBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeBoxes"]], "InlineFormula"],
 " does not evaluate its argument, so you can define rules for formatting \
expressions without being concerned about how these expressions would \
evaluate. "
}], "Text",
 CellID->32606],

Cell[TextData[{
 "In addition, while ",
 Cell[BoxData[
  ButtonBox["Format",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Format"]], "InlineFormula"],
 " is automatically called again on any results obtained by applying it, the \
same is not true of ",
 Cell[BoxData[
  ButtonBox["MakeBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeBoxes"]], "InlineFormula"],
 ". This means that in giving definitions for ",
 Cell[BoxData[
  ButtonBox["MakeBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeBoxes"]], "InlineFormula"],
 " you explicitly have to call ",
 Cell[BoxData[
  ButtonBox["MakeBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeBoxes"]], "InlineFormula"],
 " again on any subexpressions that still need to be formatted. "
}], "Text",
 CellID->13345],

Cell[BoxData[GridBox[{
   {Cell["\[FilledSmallSquare] Break input into tokens.", "TableText"]},
   {Cell["\[FilledSmallSquare] Strip spacing characters.", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Construct boxes using built\[Hyphen]in operator \
precedences.\
\>", "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Strip ",
     Cell[BoxData[
      ButtonBox["StyleBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StyleBox"]], "InlineFormula"],
     " and other boxes not intended for interpretation."
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Apply rules defined for ",
     Cell[BoxData[
      ButtonBox["MakeExpression",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/MakeExpression"]], "InlineFormula"],
     "."
    }], "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31443],

Cell[TextData[{
 "Operations done on ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input. "
}], "Caption",
 CellID->9850],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->207505862],

Cell[TextData[ButtonBox["Textual Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TextualInputAndOutputOverview"]], "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Low-Level Input and Output Rules - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Textual Input and Output", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/TextualInputAndOutputOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DefiningOutputFormats"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/GeneratingUnstructuredOutput"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 49.6791928}", "context" -> "", 
    "keywords" -> {
     "annotated operator", "input", "interpretation", "MakeBoxes", 
      "MakeExpression", "parser", "Subscripted operators", "syntax"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Low-level functions for converting between expressions and boxes. \
MakeBoxes generates boxes without evaluating its input. MakeExpression \
interprets boxes but uses HoldComplete to prevent the resulting expression \
from being evaluated. ", "synonyms" -> {"2.9.17"}, "title" -> 
    "Low-Level Input and Output Rules", "type" -> "Tutorial", "uri" -> 
    "tutorial/LowLevelInputAndOutputRules"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.9.17"->{
  Cell[1944, 60, 113, 4, 70, "Title",
   CellTags->{"S2.9.17", "17.1"},
   CellID->27901]},
 "17.1"->{
  Cell[1944, 60, 113, 4, 70, "Title",
   CellTags->{"S2.9.17", "17.1"},
   CellID->27901]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.9.17", 18085, 624},
 {"17.1", 18188, 628}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1319, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1944, 60, 113, 4, 70, "Title",
 CellTags->{"S2.9.17", "17.1"},
 CellID->27901],
Cell[2060, 66, 1060, 32, 70, "DefinitionBox",
 CellID->15343],
Cell[3123, 100, 116, 3, 70, "Caption",
 CellID->5876],
Cell[3242, 105, 221, 7, 70, "MathCaption",
 CellID->1731],
Cell[CellGroupData[{
Cell[3488, 116, 160, 5, 28, "Input",
 CellID->27500],
Cell[3651, 123, 272, 9, 36, "Output",
 CellID->15648]
}, Open  ]],
Cell[3938, 135, 403, 12, 70, "MathCaption",
 CellID->13613],
Cell[CellGroupData[{
Cell[4366, 151, 139, 4, 28, "Input",
 CellID->253],
Cell[4508, 157, 217, 7, 36, "Output",
 CellID->20311]
}, Open  ]],
Cell[4740, 167, 449, 13, 70, "Text",
 CellID->9693],
Cell[5192, 182, 321, 8, 70, "Text",
 CellID->6332],
Cell[5516, 192, 362, 10, 70, "Text",
 CellID->27451],
Cell[5881, 204, 168, 6, 70, "MathCaption",
 CellID->1814],
Cell[CellGroupData[{
Cell[6074, 214, 136, 4, 70, "Input",
 CellID->31599],
Cell[6213, 220, 209, 6, 36, "Output",
 CellID->216]
}, Open  ]],
Cell[6437, 229, 208, 8, 70, "MathCaption",
 CellID->23212],
Cell[CellGroupData[{
Cell[6670, 241, 179, 6, 70, "Input",
 CellID->6834],
Cell[6852, 249, 359, 13, 50, "Output",
 CellID->3849]
}, Open  ]],
Cell[7226, 265, 577, 16, 70, "Text",
 CellID->32252],
Cell[7806, 283, 666, 18, 70, "Text",
 CellID->20912],
Cell[8475, 303, 281, 10, 70, "MathCaption",
 CellID->10141],
Cell[8759, 315, 669, 19, 70, "Input",
 CellID->23209],
Cell[9431, 336, 214, 7, 70, "MathCaption",
 CellID->27450],
Cell[CellGroupData[{
Cell[9670, 347, 154, 5, 70, "Input",
 CellID->9180],
Cell[9827, 354, 235, 8, 36, "Output",
 CellID->17569]
}, Open  ]],
Cell[10077, 365, 143, 5, 70, "MathCaption",
 CellID->9535],
Cell[CellGroupData[{
Cell[10245, 374, 146, 5, 70, "Input",
 CellID->4562],
Cell[10394, 381, 193, 5, 70, "Message",
 CellID->23365]
}, Open  ]],
Cell[10602, 389, 384, 14, 70, "MathCaption",
 CellID->25111],
Cell[10989, 405, 655, 19, 70, "Input",
 CellID->12817],
Cell[11647, 426, 225, 8, 70, "MathCaption",
 CellID->11011],
Cell[CellGroupData[{
Cell[11897, 438, 178, 6, 70, "Input",
 CellID->763],
Cell[12078, 446, 416, 15, 50, "Output",
 CellID->31321]
}, Open  ]],
Cell[12509, 464, 736, 21, 70, "Text",
 CellID->32606],
Cell[13248, 487, 796, 24, 70, "Text",
 CellID->13345],
Cell[14047, 513, 1160, 32, 70, "FramedBox",
 CellID->31443],
Cell[15210, 547, 130, 6, 70, "Caption",
 CellID->9850],
Cell[CellGroupData[{
Cell[15365, 557, 72, 1, 70, "RelatedTutorialsSection",
 CellID->207505862],
Cell[15440, 560, 178, 4, 70, "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],
Cell[15645, 568, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

