(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16136,        557]
NotebookOptionsPosition[     11116,        406]
NotebookOutlinePosition[     14108,        480]
CellTagsIndexPosition[     14017,        474]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Transformation Rules and Definitions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Transformation Rules and Definitions\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Clear" :> Documentation`HelpLookup["paclet:ref/Clear"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Clear\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Making Definitions", "Title",
 CellTags->{"S2.5.3", "3.1"},
 CellID->16933],

Cell[TextData[{
 "The replacement operator ",
 Cell[BoxData["/."], "InlineFormula"],
 " allows you to apply transformation rules to a specific expression. Often, \
however, you want to have transformation rules automatically applied whenever \
possible. "
}], "Text",
 CellID->8695],

Cell[TextData[{
 "You can do this by assigning explicit values to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions and patterns. Each assignment specifies a transformation rule \
to be applied whenever an expression of the appropriate form occurs. "
}], "Text",
 CellID->14709],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["expr", "TI"], "/.", 
     StyleBox["lhs", "TI"], "->", 
     StyleBox["rhs", "TI"]}], Cell[
    "apply a transformation rule to a specific expression", "TableText"]},
   {
    RowBox[{
     StyleBox["lhs", "TI"], "=", 
     StyleBox["rhs", "TI"]}], Cell["\<\
assign a value which defines a transformation rule to be used whenever \
possible\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21072],

Cell["Manual and automatic application of transformation rules. ", "Caption",
 CellID->7468],

Cell[TextData[{
 "This applies a transformation rule for ",
 Cell[BoxData["x"], "InlineFormula"],
 " to a specific expression. "
}], "MathCaption",
 CellID->8703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "^", "6"}], "/.", 
  RowBox[{"x", "->", 
   RowBox[{"3", "-", "a"}]}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->12864],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"4", "-", "a"}], ")"}], "6"]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->30845]
}, Open  ]],

Cell[TextData[{
 "By assigning a value to ",
 Cell[BoxData["x"], "InlineFormula"],
 ", you tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to apply a transformation rule for ",
 Cell[BoxData["x"], "InlineFormula"],
 " whenever possible. "
}], "MathCaption",
 CellID->1849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"3", "-", "a"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->9050],

Cell[BoxData[
 RowBox[{"3", "-", "a"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->28646]
}, Open  ]],

Cell[TextData[{
 "Now ",
 Cell[BoxData["x"], "InlineFormula"],
 " is transformed automatically. "
}], "MathCaption",
 CellID->31142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], "^", "7"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->22444],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"4", "-", "a"}], ")"}], "7"]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->12155]
}, Open  ]],

Cell[TextData[{
 "You should realize that except inside constructs like ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 ", all assignments you make in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session are ",
 StyleBox["permanent",
  FontSlant->"Italic"],
 ". They continue to be used for the duration of the session, unless you \
explicitly clear or overwrite them. "
}], "Text",
 CellID->26459],

Cell[TextData[{
 "The fact that assignments are permanent means that they must be made with \
care. Probably the single most common mistake in using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is to make an assignment for a variable like ",
 Cell[BoxData["x"], "InlineFormula"],
 " at one point in your session, and then later to use ",
 Cell[BoxData["x"], "InlineFormula"],
 " having forgotten about the assignment you made. "
}], "Text",
 CellID->768],

Cell[TextData[{
 "There are several ways to avoid this kind of mistake. First, you should \
avoid using assignments whenever possible, and instead use more controlled \
constructs such as the ",
 Cell[BoxData["/."], "InlineFormula"],
 " replacement operator. Second, you should explicitly use the deassignment \
operator ",
 Cell[BoxData["=."], "InlineFormula"],
 " or the function ",
 Cell[BoxData[
  ButtonBox["Clear",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Clear"]], "InlineFormula"],
 " to remove values you have assigned when you have finished with them. "
}], "Text",
 CellID->8885],

Cell[TextData[{
 "Another important way to avoid mistakes is to think particularly carefully \
before assigning values to variables with common or simple names. You will \
often want to use a variable such as ",
 Cell[BoxData["x"], "InlineFormula"],
 " as a symbolic parameter. But if you make an assignment such as ",
 Cell[BoxData[
  RowBox[{"x", "=", "3"}]], "InlineFormula"],
 ", then ",
 Cell[BoxData["x"], "InlineFormula"],
 " will be replaced by ",
 Cell[BoxData["3"], "InlineFormula"],
 " whenever it occurs, and you can no longer use ",
 Cell[BoxData["x"], "InlineFormula"],
 " as a symbolic parameter. "
}], "Text",
 CellID->30301],

Cell[TextData[{
 "In general, you should be sure not to assign permanent values to any \
variables that you might want to use for more than one purpose. If at one \
point in your session you wanted the variable ",
 Cell[BoxData["c"], "InlineFormula"],
 " to stand for the speed of light, you might assign it a value such as ",
 Cell[BoxData[
  RowBox[{"3.", "*", 
   RowBox[{"10", "^", "8"}]}]], "InlineFormula"],
 ". But then you cannot use ",
 Cell[BoxData["c"], "InlineFormula"],
 " later in your session to stand, say, for an undetermined coefficient. One \
way to avoid this kind of problem is to make assignments only for variables \
with more explicit names, such as ",
 Cell[BoxData["SpeedOfLight"], "InlineFormula"],
 "."
}], "Text",
 CellID->9847],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["x", "TI"], "=."}], Cell[TextData[{
     "remove the value assigned to the object ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Clear",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Clear"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "clear all the values of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", \[Ellipsis]",
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32606],

Cell["Removing assignments. ", "Caption",
 CellID->3187],

Cell[TextData[{
 "This does not give what you might expect, because ",
 Cell[BoxData["x"], "InlineFormula"],
 " still has the value you assigned it above. "
}], "MathCaption",
 CellID->14535],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "-", "1"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->10309],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "4"}], "+", "a"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "a"}], ")"}]}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->28364]
}, Open  ]],

Cell[TextData[{
 "This removes any value assigned to ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17633],

Cell[BoxData[
 RowBox[{"Clear", "[", "x", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->19351],

Cell["Now this gives the result you expect. ", "MathCaption",
 CellID->19140],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "-", "1"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->18625],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}]}]], "Output",
 ImageSize->{96, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->31724]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->309456248],

Cell[TextData[ButtonBox["Transformation Rules and Definitions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], \
"RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Making Definitions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Transformation Rules and Definitions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ManipulatingSetsOfTransformationRules"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SpecialFormsOfAssignment"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 51.1948566}", "context" -> "", 
    "keywords" -> {
     "/.", "=.", ":=", "=", "assignments", "clear", "definitions", 
      "deleting symbols", "equals sign", "killing", "removing assignments", 
      "removing symbols", "rules", "symbols", "unset"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "The replacement operator /. allows you to apply transformation rules to \
a specific expression. Often, however, you want to have transformation rules \
automatically applied whenever possible. You can do this by assigning \
explicit values to Mathematica expressions and patterns. Each assignment \
specifies a transformation rule to be applied whenever an expression of the \
appropriate form occurs. Manual and automatic application of transformation \
rules. ", "synonyms" -> {"2.5.3"}, "title" -> "Making Definitions", "type" -> 
    "Tutorial", "uri" -> "tutorial/MakingDefinitions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.5.3"->{
  Cell[1846, 59, 81, 2, 70, "Title",
   CellTags->{"S2.5.3", "3.1"},
   CellID->16933]},
 "3.1"->{
  Cell[1846, 59, 81, 2, 70, "Title",
   CellTags->{"S2.5.3", "3.1"},
   CellID->16933]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.5.3", 13806, 463},
 {"3.1", 13905, 467}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1221, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1846, 59, 81, 2, 70, "Title",
 CellTags->{"S2.5.3", "3.1"},
 CellID->16933],
Cell[1930, 63, 282, 7, 70, "Text",
 CellID->8695],
Cell[2215, 72, 295, 7, 70, "Text",
 CellID->14709],
Cell[2513, 81, 730, 22, 70, "DefinitionBox",
 CellID->21072],
Cell[3246, 105, 92, 1, 70, "Caption",
 CellID->7468],
Cell[3341, 108, 162, 5, 70, "MathCaption",
 CellID->8703],
Cell[CellGroupData[{
Cell[3528, 117, 210, 8, 28, "Input",
 CellID->12864],
Cell[3741, 127, 225, 8, 36, "Output",
 CellID->30845]
}, Open  ]],
Cell[3981, 138, 284, 10, 70, "MathCaption",
 CellID->1849],
Cell[CellGroupData[{
Cell[4290, 152, 111, 4, 28, "Input",
 CellID->9050],
Cell[4404, 158, 177, 6, 36, "Output",
 CellID->28646]
}, Open  ]],
Cell[4596, 167, 132, 5, 70, "MathCaption",
 CellID->31142],
Cell[CellGroupData[{
Cell[4753, 176, 136, 5, 70, "Input",
 CellID->22444],
Cell[4892, 183, 225, 8, 36, "Output",
 CellID->12155]
}, Open  ]],
Cell[5132, 194, 604, 20, 70, "Text",
 CellID->26459],
Cell[5739, 216, 464, 11, 70, "Text",
 CellID->768],
Cell[6206, 229, 598, 15, 70, "Text",
 CellID->8885],
Cell[6807, 246, 641, 16, 70, "Text",
 CellID->30301],
Cell[7451, 264, 757, 17, 70, "Text",
 CellID->9847],
Cell[8211, 283, 1002, 33, 70, "DefinitionBox",
 CellID->32606],
Cell[9216, 318, 56, 1, 70, "Caption",
 CellID->3187],
Cell[9275, 321, 191, 5, 70, "MathCaption",
 CellID->14535],
Cell[CellGroupData[{
Cell[9491, 330, 146, 5, 70, "Input",
 CellID->10309],
Cell[9640, 337, 312, 12, 36, "Output",
 CellID->28364]
}, Open  ]],
Cell[9967, 352, 134, 5, 70, "MathCaption",
 CellID->17633],
Cell[10104, 359, 98, 3, 70, "Input",
 CellID->19351],
Cell[10205, 364, 77, 1, 70, "MathCaption",
 CellID->19140],
Cell[CellGroupData[{
Cell[10307, 369, 146, 5, 70, "Input",
 CellID->18625],
Cell[10456, 376, 291, 11, 36, "Output",
 CellID->31724]
}, Open  ]],
Cell[CellGroupData[{
Cell[10784, 392, 72, 1, 70, "RelatedTutorialsSection",
 CellID->309456248],
Cell[10859, 395, 203, 5, 70, "RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],
Cell[11089, 404, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

