(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11328,        422]
NotebookOptionsPosition[      6552,        276]
NotebookOutlinePosition[      9474,        349]
CellTagsIndexPosition[      9385,        343]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Building Up Calculations" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/BuildingUpCalculationsOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Building Up Calculations\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Making Lists of Objects", "Title",
 CellTags->{"S1.2.3", "3.1"},
 CellID->15346],

Cell[TextData[{
 "In doing calculations, it is often convenient to collect together several \
objects, and treat them as a single entity. ",
 StyleBox["Lists",
  FontSlant->"Italic"],
 " give you a way to make collections of objects in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". As you will see later, lists are very important and general structures in \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->3200],

Cell[TextData[{
 "A list such as ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"3", ",", "5", ",", "1"}], "}"}]], "InlineFormula"],
 " is a collection of three objects. But in many ways, you can treat the \
whole list as a single object. You can, for example, do arithmetic on the \
whole list at once, or assign the whole list to be the value of a variable. "
}], "Text",
 CellID->20838],

Cell["Here is a list of three numbers. ", "MathCaption",
 CellID->26031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "5", ",", "1"}], "}"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->11221],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "5", ",", "1"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->3217]
}, Open  ]],

Cell[TextData[{
 "This squares each number in the list, and adds ",
 Cell[BoxData["1"], "InlineFormula"],
 " to it. "
}], "MathCaption",
 CellID->23624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "5", ",", "1"}], "}"}], "^", "2"}], "+", "1"}]], "Input",\

 CellLabel->"In[2]:= ",
 CellID->13584],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "26", ",", "2"}], "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->14815]
}, Open  ]],

Cell["\<\
This takes differences between corresponding elements in the two lists. The \
lists must be the same length. \
\>", "MathCaption",
 CellID->2344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"6", ",", "7", ",", "8"}], "}"}], "-", 
  RowBox[{"{", 
   RowBox[{"3.5", ",", "4", ",", "2.5"}], "}"}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->8352],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.5`", ",", "3", ",", "5.5`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->12019]
}, Open  ]],

Cell[TextData[{
 "The value of ",
 Cell[BoxData["%"], "InlineFormula"],
 " is the whole list. "
}], "MathCaption",
 CellID->6070],

Cell[CellGroupData[{

Cell[BoxData["%"], "Input",
 CellLabel->"In[4]:= ",
 CellID->11367],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.5`", ",", "3", ",", "5.5`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->8919]
}, Open  ]],

Cell[TextData[{
 "You can apply any of the mathematical functions in \"",
 ButtonBox["Some Mathematical Functions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SomeMathematicalFunctions"],
 " to whole lists. "
}], "MathCaption",
 CellID->32174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Exp", "[", "%", "]"}], "//", "N"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->24487],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "12.182493960703473`", ",", "20.085536923187668`", ",", 
   "244.69193226422038`"}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->7030]
}, Open  ]],

Cell["\<\
Just as you can set variables to be numbers, so also you can set them to be \
lists. \
\>", "Text",
 CellID->22345],

Cell[TextData[{
 "This assigns ",
 Cell[BoxData["v"], "InlineFormula"],
 " to be a list. "
}], "MathCaption",
 CellID->22716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"{", 
   RowBox[{"2", ",", "4", ",", "3.1"}], "}"}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->28044],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "4", ",", "3.1`"}], "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->31699]
}, Open  ]],

Cell[TextData[{
 "Wherever ",
 Cell[BoxData["v"], "InlineFormula"],
 " appears, it is replaced by the list. "
}], "MathCaption",
 CellID->25162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "/", 
  RowBox[{"(", 
   RowBox[{"v", "-", "1"}], ")"}]}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->21685],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   FractionBox["4", "3"], ",", "1.476190476190476`"}], "}"}]], "Output",
 ImageSize->{108, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->16115]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->162778910],

Cell[TextData[ButtonBox["Building Up Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/BuildingUpCalculationsOverview"]], "RelatedTutorials",
 CellID->71949343]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Making Lists of Objects - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Building Up Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/BuildingUpCalculationsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DefiningVariables"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ManipulatingElementsOfLists"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 51.6792440}", "context" -> "", 
    "keywords" -> {"arrays", "collections", "list", "lists", "sequences"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "In doing calculations, it is often convenient to collect together \
several objects, and treat them as a single entity. Lists give you a way to \
make collections of objects in Mathematica. As you will see later, lists are \
very important and general structures in Mathematica. A list such as {3,5,1} \
is a collection of three objects. But in many ways, you can treat the whole \
list as a single object. You can, for example, do arithmetic on the whole \
list at once, or assign the whole list to be the value of a variable. Here is \
a list of three numbers. ", "synonyms" -> {"1.2.3"}, "title" -> 
    "Making Lists of Objects", "type" -> "Tutorial", "uri" -> 
    "tutorial/MakingListsOfObjects"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.2.3"->{
  Cell[1271, 43, 86, 2, 70, "Title",
   CellTags->{"S1.2.3", "3.1"},
   CellID->15346]},
 "3.1"->{
  Cell[1271, 43, 86, 2, 70, "Title",
   CellTags->{"S1.2.3", "3.1"},
   CellID->15346]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.2.3", 9174, 332},
 {"3.1", 9273, 336}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 646, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1271, 43, 86, 2, 70, "Title",
 CellTags->{"S1.2.3", "3.1"},
 CellID->15346],
Cell[1360, 47, 452, 14, 70, "Text",
 CellID->3200],
Cell[1815, 63, 387, 9, 70, "Text",
 CellID->20838],
Cell[2205, 74, 72, 1, 70, "MathCaption",
 CellID->26031],
Cell[CellGroupData[{
Cell[2302, 79, 122, 4, 28, "Input",
 CellID->11221],
Cell[2427, 85, 209, 7, 36, "Output",
 CellID->3217]
}, Open  ]],
Cell[2651, 95, 152, 5, 70, "MathCaption",
 CellID->23624],
Cell[CellGroupData[{
Cell[2828, 104, 173, 7, 28, "Input",
 CellID->13584],
Cell[3004, 113, 212, 7, 36, "Output",
 CellID->14815]
}, Open  ]],
Cell[3231, 123, 155, 4, 70, "MathCaption",
 CellID->2344],
Cell[CellGroupData[{
Cell[3411, 131, 206, 7, 28, "Input",
 CellID->8352],
Cell[3620, 140, 216, 7, 36, "Output",
 CellID->12019]
}, Open  ]],
Cell[3851, 150, 129, 5, 70, "MathCaption",
 CellID->6070],
Cell[CellGroupData[{
Cell[4005, 159, 67, 2, 70, "Input",
 CellID->11367],
Cell[4075, 163, 215, 7, 36, "Output",
 CellID->8919]
}, Open  ]],
Cell[4305, 173, 254, 7, 70, "MathCaption",
 CellID->32174],
Cell[CellGroupData[{
Cell[4584, 184, 120, 4, 70, "Input",
 CellID->24487],
Cell[4707, 190, 271, 9, 36, "Output",
 CellID->7030]
}, Open  ]],
Cell[4993, 202, 125, 4, 70, "Text",
 CellID->22345],
Cell[5121, 208, 125, 5, 70, "MathCaption",
 CellID->22716],
Cell[CellGroupData[{
Cell[5271, 217, 148, 5, 70, "Input",
 CellID->28044],
Cell[5422, 224, 213, 7, 36, "Output",
 CellID->31699]
}, Open  ]],
Cell[5650, 234, 144, 5, 70, "MathCaption",
 CellID->25162],
Cell[CellGroupData[{
Cell[5819, 243, 136, 5, 70, "Input",
 CellID->21685],
Cell[5958, 250, 250, 8, 51, "Output",
 CellID->16115]
}, Open  ]],
Cell[CellGroupData[{
Cell[6245, 263, 72, 1, 70, "RelatedTutorialsSection",
 CellID->162778910],
Cell[6320, 266, 178, 4, 70, "RelatedTutorials",
 CellID->71949343]
}, Open  ]]
}, Open  ]],
Cell[6525, 274, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

