(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16661,        592]
NotebookOptionsPosition[     11653,        437]
NotebookOutlinePosition[     14560,        511]
CellTagsIndexPosition[     14469,        505]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Building Up Calculations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/BuildingUpCalculationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Building Up Calculations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Part" :> Documentation`HelpLookup["paclet:ref/Part"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Part\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Manipulating Elements of Lists", "Title",
 CellTags->{"S1.2.4", "4.1"},
 CellID->12464],

Cell[TextData[{
 "Many of the most powerful list manipulation operations in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " treat whole lists as single objects. Sometimes, however, you need to pick \
out or set individual elements in a list."
}], "Text",
 CellID->14537],

Cell[TextData[{
 "You can refer to an element of a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list by giving its \"index\". The elements are numbered in order, starting \
at 1."
}], "Text",
 CellID->5558],

Cell[BoxData[GridBox[{
   {
    RowBox[{"{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["c", "TI"], "}"}], Cell["a list", "TableText"]},
   {
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["i", "TI"], "]", Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     StyleBox["list", "TI"], "[", "[", 
     StyleBox["i", "TI"], "]", "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " element of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " (the first element is ",
     Cell[BoxData[
      RowBox[{
       StyleBox["list", "TI"], "[", "[", "1", "]", "]"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     StyleBox["list", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     StyleBox["j", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]", Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     StyleBox["list", "TI"], "[", "[", "{", 
     StyleBox["i", "TI"], ",", 
     StyleBox["j", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "a list of the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     ", ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     " elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      RowBox[{
       StyleBox["i", "TI"], ";;", 
       StyleBox["j", "TI"]}]}], "]"}], Cell[TextData[{
     "a list of the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " through ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17206],

Cell["Operations on list elements. ", "Caption",
 CellID->16911],

Cell["This extracts the second element of the list. ", "MathCaption",
 CellID->29414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"5", ",", "8", ",", "6", ",", "9"}], "}"}], "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->19947],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->21293]
}, Open  ]],

Cell["This extracts a list of elements. ", "MathCaption",
 CellID->9129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"5", ",", "8", ",", "6", ",", "9"}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "3", ",", "2", ",", "4"}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->26587],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "5", ",", "6", ",", "8", ",", "9"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->14080]
}, Open  ]],

Cell[TextData[{
 "This assigns the value of ",
 Cell[BoxData["v"], "InlineFormula"],
 " to be a list. "
}], "MathCaption",
 CellID->85],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"{", 
   RowBox[{"2", ",", "4", ",", "7"}], "}"}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->8764],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "4", ",", "7"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->7234]
}, Open  ]],

Cell[TextData[{
 "You can extract elements of ",
 Cell[BoxData["v"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->14015],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->30118]
}, Open  ]],

Cell[TextData[{
 "By assigning a variable to be a list, you can use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " lists much like \"arrays\" in other computer languages. Thus, for example, \
you can reset an element of a list by assigning a value to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["v", "TI"], "[", 
   RowBox[{"[", 
    StyleBox["i", "TI"], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->13384],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     StyleBox["v", "TI"], ",", 
     StyleBox["i", "TI"], "]", Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     StyleBox["v", "TI"], "[", "[", 
     StyleBox["i", "TI"], "]", "]"}], Cell[TextData[{
     "extract the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " element of a list"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     StyleBox["v", "TI"], ",", 
     StyleBox["i", "TI"], "]", "=", 
     StyleBox["value", "TI"], Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     StyleBox["v", "TI"], "[", "[", 
     StyleBox["i", "TI"], "]", "]", "=", 
     StyleBox["value", "TI"]}], Cell[TextData[{
     "reset the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " element of a list"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24847],

Cell["\<\
Array\[Hyphen]like operations on lists. \
\>", "Caption",
 CellID->20648],

Cell["Here is a list. ", "MathCaption",
 CellID->20547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"{", 
   RowBox[{"4", ",", 
    RowBox[{"-", "1"}], ",", "8", ",", "7"}], "}"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->5555],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", 
   RowBox[{"-", "1"}], ",", "8", ",", "7"}], "}"}]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->10832]
}, Open  ]],

Cell["This resets the third element of the list. ", "MathCaption",
 CellID->26781],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", 
   RowBox[{"[", "3", "]"}], "]"}], "=", "0"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->30837],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->27427]
}, Open  ]],

Cell[TextData[{
 "Now the list assigned to ",
 Cell[BoxData["v"], "InlineFormula"],
 " has been modified. "
}], "MathCaption",
 CellID->25896],

Cell[CellGroupData[{

Cell[BoxData["v"], "Input",
 CellLabel->"In[7]:= ",
 CellID->5859],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", 
   RowBox[{"-", "1"}], ",", "0", ",", "7"}], "}"}]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->8324]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->608845344],

Cell[TextData[ButtonBox["Building Up Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/BuildingUpCalculationsOverview"]], "RelatedTutorials",
 CellID->71949343]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Manipulating Elements of Lists - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Building Up Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/BuildingUpCalculationsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/MakingListsOfObjects"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TheFourKindsOfBracketingInMathematica"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 57.7262738}", "context" -> "", 
    "keywords" -> {
     "]]", "[[", "arrays", "indexed variables", "indices", "lists", "part", 
      "parts", "ranges of elements", "ReplacePart", 
      "resetting parts of lists", "sequence of elements", "Span", 
      "subscripts"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Many of the most powerful list manipulation operations in Mathematica \
treat whole lists as single objects. Sometimes, however, you need to pick out \
or set individual elements in a list. You can refer to an element of a \
Mathematica list by giving its \"index\". The elements are numbered in order, \
starting at 1. Operations on list elements. ", "synonyms" -> {"1.2.4"}, 
    "title" -> "Manipulating Elements of Lists", "type" -> "Tutorial", "uri" -> 
    "tutorial/ManipulatingElementsOfLists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.2.4"->{
  Cell[1796, 57, 93, 2, 70, "Title",
   CellTags->{"S1.2.4", "4.1"},
   CellID->12464]},
 "4.1"->{
  Cell[1796, 57, 93, 2, 70, "Title",
   CellTags->{"S1.2.4", "4.1"},
   CellID->12464]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.2.4", 14258, 494},
 {"4.1", 14357, 498}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1171, 30, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1796, 57, 93, 2, 70, "Title",
 CellTags->{"S1.2.4", "4.1"},
 CellID->12464],
Cell[1892, 61, 277, 7, 70, "Text",
 CellID->14537],
Cell[2172, 70, 216, 7, 70, "Text",
 CellID->5558],
Cell[2391, 79, 3215, 102, 70, "DefinitionBox",
 CellID->17206],
Cell[5609, 183, 64, 1, 70, "Caption",
 CellID->16911],
Cell[5676, 186, 85, 1, 70, "MathCaption",
 CellID->29414],
Cell[CellGroupData[{
Cell[5786, 191, 184, 6, 28, "Input",
 CellID->19947],
Cell[5973, 199, 155, 5, 36, "Output",
 CellID->21293]
}, Open  ]],
Cell[6143, 207, 72, 1, 70, "MathCaption",
 CellID->9129],
Cell[CellGroupData[{
Cell[6240, 212, 266, 9, 28, "Input",
 CellID->26587],
Cell[6509, 223, 230, 7, 36, "Output",
 CellID->14080]
}, Open  ]],
Cell[6754, 233, 135, 5, 70, "MathCaption",
 CellID->85],
Cell[CellGroupData[{
Cell[6914, 242, 145, 5, 70, "Input",
 CellID->8764],
Cell[7062, 249, 209, 7, 36, "Output",
 CellID->7234]
}, Open  ]],
Cell[7286, 259, 127, 5, 70, "MathCaption",
 CellID->17076],
Cell[CellGroupData[{
Cell[7438, 268, 117, 4, 70, "Input",
 CellID->14015],
Cell[7558, 274, 155, 5, 36, "Output",
 CellID->30118]
}, Open  ]],
Cell[7728, 282, 426, 13, 70, "Text",
 CellID->13384],
Cell[8157, 297, 1656, 50, 70, "DefinitionBox",
 CellID->24847],
Cell[9816, 349, 83, 3, 70, "Caption",
 CellID->20648],
Cell[9902, 354, 55, 1, 70, "MathCaption",
 CellID->20547],
Cell[CellGroupData[{
Cell[9982, 359, 175, 6, 70, "Input",
 CellID->5555],
Cell[10160, 367, 239, 8, 36, "Output",
 CellID->10832]
}, Open  ]],
Cell[10414, 378, 82, 1, 70, "MathCaption",
 CellID->26781],
Cell[CellGroupData[{
Cell[10521, 383, 141, 5, 70, "Input",
 CellID->30837],
Cell[10665, 390, 155, 5, 36, "Output",
 CellID->27427]
}, Open  ]],
Cell[10835, 398, 142, 5, 70, "MathCaption",
 CellID->25896],
Cell[CellGroupData[{
Cell[11002, 407, 66, 2, 70, "Input",
 CellID->5859],
Cell[11071, 411, 238, 8, 36, "Output",
 CellID->8324]
}, Open  ]],
Cell[CellGroupData[{
Cell[11346, 424, 72, 1, 70, "RelatedTutorialsSection",
 CellID->608845344],
Cell[11421, 427, 178, 4, 70, "RelatedTutorials",
 CellID->71949343]
}, Open  ]]
}, Open  ]],
Cell[11626, 435, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

