(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33700,       1122]
NotebookOptionsPosition[     26377,        908]
NotebookOutlinePosition[     29940,        991]
CellTagsIndexPosition[     29846,        985]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]}\
, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>"}, \
"\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLClose" :> Documentation`HelpLookup["paclet:ref/c/MLClose"], 
          "MLCreateMark" :> 
          Documentation`HelpLookup["paclet:ref/c/MLCreateMark"], 
          "MLDestroyMark" :> 
          Documentation`HelpLookup["paclet:ref/c/MLDestroyMark"], 
          "MLGetArgCount" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetArgCount"], 
          "MLGetInteger32" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetInteger"], "MLGetNext" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetNext"], "MLGetReal64" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetReal"], "MLGetString" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetString"], "MLGetSymbol" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetSymbol"], "MLINK" :> 
          Documentation`HelpLookup["paclet:ref/c/MLINK"], "MLLoopbackOpen" :> 
          Documentation`HelpLookup["paclet:ref/c/MLLoopbackOpen"], "MLMARK" :> 
          Documentation`HelpLookup["paclet:ref/c/MLMARK"], "MLPutArgCount" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutArgCount"], 
          "MLPutInteger32" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutInteger"], "MLPutNext" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutNext"], "MLPutReal64" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutReal"], "MLPutString" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutString"], "MLPutSymbol" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutSymbol"], "MLSeekMark" :> 
          Documentation`HelpLookup["paclet:ref/c/MLSeekMark"], 
          "MLTransferExpression" :> 
          Documentation`HelpLookup["paclet:ref/c/MLTransferExpression"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"MLClose\"\>", 
       2->"\<\"MLCreateMark\"\>", 3->"\<\"MLDestroyMark\"\>", 
       4->"\<\"MLGetArgCount\"\>", 5->"\<\"MLGetInteger32\"\>", 
       6->"\<\"MLGetNext\"\>", 7->"\<\"MLGetReal64\"\>", 
       8->"\<\"MLGetString\"\>", 9->"\<\"MLGetSymbol\"\>", 
       10->"\<\"MLINK\"\>", 11->"\<\"MLLoopbackOpen\"\>", 
       12->"\<\"MLMARK\"\>", 13->"\<\"MLPutArgCount\"\>", 
       14->"\<\"MLPutInteger32\"\>", 15->"\<\"MLPutNext\"\>", 
       16->"\<\"MLPutReal64\"\>", 17->"\<\"MLPutString\"\>", 
       18->"\<\"MLPutSymbol\"\>", 19->"\<\"MLSeekMark\"\>", 
       20->"\<\"MLTransferExpression\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Manipulating Expressions in External Programs", "Title",
 CellTags->{"S2.13.12", "12.1"},
 CellID->27799],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions provide a very general way to handle all kinds of data, and \
you may sometimes want to use such expressions inside your external programs. \
A language like C, however, offers no direct way to store general ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. But it is nevertheless possible to do this by using the ",
 StyleBox["loopback links",
  FontSlant->"Italic"],
 " provided by the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library. A loopback link is a local ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connection inside your external program, to which you can write \
expressions that can later be read back. "
}], "Text",
 CellID->15653],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MLINK",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLINK"], 
     ButtonBox["MLLoopbackOpen",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLLoopbackOpen"], 
     RowBox[{"(", 
      RowBox[{"stdenv", ",", 
       RowBox[{"int", "*", 
        StyleBox["errno", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["open a loopback link", "TableText"]},
   {
    RowBox[{"void", 
     ButtonBox["MLClose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLClose"], 
     RowBox[{"(", 
      RowBox[{"MLINK", " ", 
       StyleBox["link", "TI"]}], ")"}]}], Cell["close a link", "TableText"]},
   {
    RowBox[{"int", 
     ButtonBox["MLTransferExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLTransferExpression"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"MLINK", " ", 
        StyleBox["dest", "TI"]}], ",", 
       RowBox[{"MLINK", " ", 
        StyleBox["src", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "get an expression from ",
     Cell[BoxData[
      StyleBox["src", "TI"]], "InlineFormula"],
     " and put it onto ",
     Cell[BoxData[
      StyleBox["dest", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, True, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7701],

Cell["Functions for manipulating loopback links. ", "Caption",
 CellID->28841],

Cell["This opens a loopback link. ", "MathCaption",
 CellID->19215],

Cell["\<\
...
ml = MLLoopbackOpen(stdenv, &errno);\
\>", "Program",
 CellID->15729],

Cell[TextData[{
 "This puts the expression ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Power",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Power"], "[", 
   RowBox[{"x", ",", "3"}], "]"}]], "InlineFormula"],
 " onto the loopback link. "
}], "MathCaption",
 CellID->3650],

Cell["\<\
MLPutFunction(ml, \"Power\", 2);
  MLPutSymbol(ml, \"x\");
  MLPutInteger32(ml, 3);
...\
\>", "Program",
 CellID->25532],

Cell["This gets the expression back from the loopback link. ", "MathCaption",
 CellID->29719],

Cell["\<\
MLGetFunction(ml, &head, &n);
  MLGetSymbol(ml, &sname);
  MLGetInteger32(ml, &k);
...\
\>", "Program",
 CellID->18296],

Cell["This closes the loopback link again. ", "MathCaption",
 CellID->778],

Cell["MLClose(ml);", "Program",
 CellID->12238],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLTransferExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLTransferExpression"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " to take an expression that you get via ",
 Cell[BoxData[
  ButtonBox["stdlink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/stdlink"]], "InlineFormula"],
 " from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and save it in a local loopback link for later processing. "
}], "Text",
 CellID->20803],

Cell[TextData[{
 "You can also use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLTransferExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLTransferExpression"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " to take an expression that you have built up on a local loopback link, and \
transfer it back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " via ",
 Cell[BoxData[
  ButtonBox["stdlink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/stdlink"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->6006],

Cell[TextData[{
 "This puts ",
 Cell[BoxData[
  RowBox[{"21", "!"}]], "InlineFormula"],
 " onto a local loopback link. "
}], "MathCaption",
 CellID->7849],

Cell["\<\
...
MLPutFunction(ml, \"Factorial\", 1);
  MLPutInteger32(ml, 21);\
\>", "Program",
 CellID->32670],

Cell[TextData[{
 "This sends the head ",
 Cell[BoxData[
  ButtonBox["FactorInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorInteger"]], "InlineFormula"],
 " to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->4524],

Cell["MLPutFunction(stdlink, \"FactorInteger\", 1);", "Program",
 CellID->25078],

Cell[TextData[{
 "This transfers the ",
 Cell[BoxData[
  RowBox[{"21", "!"}]], "InlineFormula"],
 " from the loopback link to ",
 Cell[BoxData[
  ButtonBox["stdlink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/stdlink"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->11787],

Cell["MLTransferExpression(stdlink, ml);", "Program",
 CellID->21984],

Cell["\<\
You can put any sequence of expressions onto a loopback link. Usually you get \
the expressions off the link in the same order as you put them on. \
\>", "Text",
 CellID->139],

Cell[TextData[{
 "And once you have got an expression off the link it is usually no longer \
saved. But by using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLCreateMark",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLCreateMark"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " you can mark a particular position in a sequence of expressions on a link, \
forcing ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " to save every expression after the mark so that you can go back to it \
later. "
}], "Text",
 CellID->7898],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MLMARK",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLMARK"], 
     ButtonBox["MLCreateMark",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLCreateMark"], 
     RowBox[{"(", 
      RowBox[{
       ButtonBox[
        RowBox[{"MLINK", " "}],
        BaseStyle->"Link",
        ButtonData->"paclet:ref/c/MLINK"], 
       StyleBox["link", "TI"]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["\<\
create a mark at the current position in a sequence of expressions on a link\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLSeekMark",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLSeekMark"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        ButtonBox["MLINK",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/c/MLINK"], " ", 
        StyleBox["link", "TI"]}], ",", 
       RowBox[{
        ButtonBox["MLMARK",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/c/MLMARK"], " ", 
        StyleBox["mark", "TI"]}], ",", 
       RowBox[{"int", " ", 
        StyleBox["n", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "go back to a position ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " expressions after the specified mark on a link"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MLDestroyMark",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLDestroyMark"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        ButtonBox["MLINK",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/c/MLINK"], " ", 
        StyleBox["link", "TI"]}], ",", 
       RowBox[{
        ButtonBox["MLMARK",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/c/MLMARK"], " ", 
        StyleBox["mark", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["destroy a mark in a link", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->19973],

Cell[TextData[{
 "Setting up marks in ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " links. "
}], "Caption",
 CellID->22638],

Cell[TextData[{
 "This puts the integer ",
 Cell[BoxData["45"], "InlineFormula"],
 " onto a loopback link. "
}], "MathCaption",
 CellID->24041],

Cell["\<\
...
MLPutInteger32(ml, 45);\
\>", "Program",
 CellID->21002],

Cell[TextData[{
 "This puts ",
 Cell[BoxData["33"], "InlineFormula"],
 " onto the link. "
}], "MathCaption",
 CellID->15063],

Cell["MLPutInteger32(ml, 33);", "Program",
 CellID->22211],

Cell[TextData[{
 "And this puts ",
 Cell[BoxData["76"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20066],

Cell["\<\
MLPutInteger32(ml, 76);
\
\>", "Program",
 CellID->18827],

Cell[TextData[{
 "This will read ",
 Cell[BoxData["45"], "InlineFormula"],
 " from the link. The ",
 Cell[BoxData["45"], "InlineFormula"],
 " will no longer be saved. "
}], "MathCaption",
 CellID->9583],

Cell["MLGetInteger32(ml, &i);", "Program",
 CellID->3930],

Cell["This creates a mark at the current position on the link. ", \
"MathCaption",
 CellID->26565],

Cell["mark = MLCreateMark(ml);", "Program",
 CellID->12082],

Cell[TextData[{
 "This will now read ",
 Cell[BoxData["33"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27982],

Cell["MLGetInteger32(ml, &i);", "Program",
 CellID->8831],

Cell[TextData[{
 "And this will read ",
 Cell[BoxData["76"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28235],

Cell["MLGetInteger32(ml, &i);", "Program",
 CellID->23290],

Cell["This goes back to the position of the mark. ", "MathCaption",
 CellID->11812],

Cell["MLSeekMark(ml, mark, 0);", "Program",
 CellID->3256],

Cell[TextData[{
 "Now this will read ",
 Cell[BoxData["33"], "InlineFormula"],
 " again. "
}], "MathCaption",
 CellID->15802],

Cell["MLGetInteger32(ml, &i);", "Program",
 CellID->1448],

Cell["\<\
It is important to destroy marks when you have finished with them, so no \
unnecessary expressions will be saved.\
\>", "MathCaption",
 CellID->6513],

Cell["MLDestroyMark(ml, mark);", "Program",
 CellID->26126],

Cell[TextData[{
 "The way the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library is implemented, it is very efficient to open and close loopback \
links, and to create and destroy marks in them. The only point to remember is \
that as soon as you create a mark on a particular link, ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " will save subsequent expressions that are put on that link, and will go on \
doing this until the mark is destroyed. "
}], "Text",
 CellID->27064],

Cell[BoxData[GridBox[{
   {
    RowBox[{"int", 
     ButtonBox["MLGetNext",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetNext"], 
     RowBox[{"(", 
      RowBox[{"MLINK", " ", 
       StyleBox["link", "TI"]}], ")"}]}], Cell[
    "find the type of the next object on a link", "TableText"]},
   {
    RowBox[{"int", 
     ButtonBox["MLGetArgCount",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetArgCount"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        ButtonBox["MLINK",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/c/MLINK"], " ", 
        StyleBox["link", "TI"]}], ",", 
       RowBox[{"int", "*", 
        StyleBox["n", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "store in ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " the number of arguments for a function on a link"
    }], "TableText"]},
   {
    RowBox[{"int", 
     ButtonBox["MLGetSymbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetSymbol"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        ButtonBox["MLINK",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/c/MLINK"], " ", 
        StyleBox["link", "TI"]}], ",", 
       RowBox[{"char", "**", 
        StyleBox["name", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["get the name of a symbol", "TableText"]},
   {
    RowBox[{"int", 
     ButtonBox["MLGetInteger32",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetInteger"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        ButtonBox["MLINK",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/c/MLINK"], " ", 
        StyleBox["link", "TI"]}], ",", 
       RowBox[{"int", "*", 
        StyleBox["i", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["get a machine integer", "TableText"]},
   {
    RowBox[{"int", 
     ButtonBox["MLGetReal64",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetReal"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        ButtonBox["MLINK",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/c/MLINK"], " ", 
        StyleBox["link", "TI"]}], ",", 
       RowBox[{"double", "*", 
        StyleBox["x", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["\<\
get a machine floating\[Hyphen]point number\
\>", "TableText"]},
   {
    RowBox[{"int", 
     ButtonBox["MLGetString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetString"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        ButtonBox["MLINK",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/c/MLINK"], " ", 
        StyleBox["link", "TI"]}], ",", 
       RowBox[{"char", "**", 
        StyleBox["string", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["get a character string", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, True, False, True, False, False, False, False, False, False, {
     False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3215],

Cell["Functions for getting pieces of expressions from a link. ", "Caption",
 CellID->12293],

Cell[BoxData[GridBox[{
   {"MLTKFUNC", Cell["\<\
composite function\[LongDash]head and arguments\
\>", "TableText"]},
   {"MLTKSYM", Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " symbol"
    }], "TableText"]},
   {"MLTKINT", Cell["integer", "TableText"]},
   {"MLTKREAL", Cell["floating\[Hyphen]point number", "TableText"]},
   {"MLTKSTR", Cell["character string", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31907],

Cell[TextData[{
 "Constants returned by ",
 StyleBox["MLGetNext()", "MR"],
 ". "
}], "Caption",
 CellID->8437],

Cell["switch(MLGetNext(ml)) {", "Program",
 CellID->16338],

Cell["This reads a composite function. ", "MathCaption",
 CellID->22424],

Cell[TextData[{
 "    case MLTKFUNC:\n    MLGetArgCount(ml, &n);\n    ",
 StyleBox[" recurse for head", "MO"],
 "\n    for (i = 0; i < n; i++) ",
 Cell[BoxData[
  FormBox[
   StyleBox["{", "TR"], TraditionalForm]], "InlineFormula"],
 "\n        ",
 StyleBox[" recurse for each argument", "MO"],
 "\n    ",
 Cell[BoxData[
  FormBox[
   StyleBox["}", "TR"], TraditionalForm]], "InlineFormula"],
 "\n    \[Ellipsis] "
}], "Program",
 CellID->70],

Cell["This reads a single symbol. ", "MathCaption",
 CellID->11183],

Cell["\<\
    case MLTKSYM:
    MLGetSymbol(ml, &name);
    \[Ellipsis] \
\>", "Program",
 CellID->6345],

Cell["This reads a machine integer. ", "MathCaption",
 CellID->9328],

Cell["\<\
    case MLTKINT:
    MLGetInteger32(ml, &i);
    \[Ellipsis] 
}\
\>", "Program",
 CellID->26059],

Cell[TextData[{
 "By using ",
 Cell[BoxData[
  RowBox[{"MLGetNext", 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " it is straightforward to write programs that can read any expression. The \
way ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " works, the head and arguments of a function appear as successive \
expressions on the link, which you read one after another. "
}], "Text",
 CellID->12537],

Cell[TextData[{
 "Note that if you know that the head of a function will be a symbol, then \
you can use ",
 Cell[BoxData[
  RowBox[{"MLGetFunction", 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " instead of ",
 Cell[BoxData[
  RowBox[{"MLGetNext", 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ". In this case, however, you still need to call ",
 Cell[BoxData[
  RowBox[{"MLReleaseSymbol", 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " to disown the memory used to store the symbol name. "
}], "Text",
 CellID->11560],

Cell[BoxData[GridBox[{
   {
    RowBox[{"int", 
     ButtonBox["MLPutNext",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutNext"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        ButtonBox["MLINK",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/c/MLINK"], " ", 
        StyleBox["link", "TI"]}], ",", 
       RowBox[{"int", " ", 
        StyleBox["type", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell[
    "prepare to put an object of the specified type on a link", 
     "TableText"]},
   {
    RowBox[{"int", 
     ButtonBox["MLPutArgCount",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutArgCount"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        ButtonBox["MLINK",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/c/MLINK"], " ", 
        StyleBox["link", "TI"]}], ",", 
       RowBox[{"int", " ", 
        StyleBox["n", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell[
    "give the number of arguments for a composite function", "TableText"]},
   {
    RowBox[{"int", 
     ButtonBox["MLPutSymbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutSymbol"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        ButtonBox["MLINK",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/c/MLINK"], " ", 
        StyleBox["link", "TI"]}], ",", 
       RowBox[{"char", "*", 
        StyleBox["name", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["put a symbol on the link", "TableText"]},
   {
    RowBox[{"int", 
     ButtonBox["MLPutInteger32",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutInteger"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        ButtonBox["MLINK",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/c/MLINK"], " ", 
        StyleBox["link", "TI"]}], ",", 
       RowBox[{"int", " ", 
        StyleBox["i", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["put a machine integer", "TableText"]},
   {
    RowBox[{"int", 
     ButtonBox["MLPutReal64",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutReal"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        ButtonBox["MLINK",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/c/MLINK"], " ", 
        StyleBox["link", "TI"]}], ",", 
       RowBox[{"double", " ", 
        StyleBox["x", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["\<\
put a machine floating\[Hyphen]point number\
\>", "TableText"]},
   {
    RowBox[{"int", 
     ButtonBox["MLPutString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutString"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        ButtonBox["MLINK",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/c/MLINK"], " ", 
        StyleBox["link", "TI"]}], ",", 
       RowBox[{"char", "*", 
        StyleBox["string", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["put a character string", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, True, False, True, False, False, False, False, False, 
     False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31349],

Cell["Functions for putting pieces of expressions onto a link. ", "Caption",
 CellID->10923],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLPutNext",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLPutNext"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " specifies types of expressions using constants such as ",
 Cell[BoxData["MLTKFUNC"], "InlineFormula"],
 " from the ",
 Cell[BoxData[
  RowBox[{"mathlink", ".", "h"}]], "InlineFormula"],
 " header file\[LongDash]just like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLGetNext",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLGetNext"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->30883],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->504981699],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Manipulating Expressions in External Programs - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "MathLink and External Program Communication", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/RunningExternalProgramsUnderADebugger"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ErrorAndInterruptHandling"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 58.2887882}", "context" -> "", 
    "keywords" -> {
     "duplicate", "expressions", "local links", "Loopback links", "Marks", 
      "MLClose()", "MLCreateMark", "MLCreateMark()", "MLDestroyMark()", 
      "MLGetArgCount()", "MLGetInteger()", "MLGetNext()", "MLGetReal()", 
      "MLGetString()", "MLGetSymbol()", "MLLoopbackOpen()", "MLPutArgCount()",
       "MLPutInteger()", "MLPutNext()", "MLPutReal()", "MLPutString()", 
      "MLPutSymbol()", "MLSeekMark", "MLSeekMark()", "MLTK constants", 
      "MLTransferExpression()", "positions", "record", "seek", "stdlink"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica expressions provide a very general way to handle all kinds \
of data, and you may sometimes want to use such expressions inside your \
external programs. A language like C, however, offers no direct way to store \
general Mathematica expressions. But it is nevertheless possible to do this \
by using the loopback links provided by the MathLink library. A loopback link \
is a local MathLink connection inside your external program, to which you can \
write expressions that can later be read back. Functions for manipulating \
loopback links. This opens a loopback link. ", "synonyms" -> {"2.13.12"}, 
    "title" -> "Manipulating Expressions in External Programs", "type" -> 
    "Tutorial", "uri" -> 
    "tutorial/ManipulatingExpressionsInExternalPrograms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.13.12"->{
  Cell[4086, 93, 111, 2, 70, "Title",
   CellTags->{"S2.13.12", "12.1"},
   CellID->27799]},
 "12.1"->{
  Cell[4086, 93, 111, 2, 70, "Title",
   CellTags->{"S2.13.12", "12.1"},
   CellID->27799]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.13.12", 29626, 974},
 {"12.1", 29730, 978}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3461, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4086, 93, 111, 2, 70, "Title",
 CellTags->{"S2.13.12", "12.1"},
 CellID->27799],
Cell[4200, 97, 762, 20, 70, "Text",
 CellID->15653],
Cell[4965, 119, 1743, 53, 70, "DefinitionBox",
 CellID->7701],
Cell[6711, 174, 78, 1, 70, "Caption",
 CellID->28841],
Cell[6792, 177, 67, 1, 70, "MathCaption",
 CellID->19215],
Cell[6862, 180, 83, 4, 70, "Program",
 CellID->15729],
Cell[6948, 186, 276, 10, 70, "MathCaption",
 CellID->3650],
Cell[7227, 198, 130, 6, 70, "Program",
 CellID->25532],
Cell[7360, 206, 93, 1, 70, "MathCaption",
 CellID->29719],
Cell[7456, 209, 129, 6, 70, "Program",
 CellID->18296],
Cell[7588, 217, 74, 1, 70, "MathCaption",
 CellID->778],
Cell[7665, 220, 47, 1, 70, "Program",
 CellID->12238],
Cell[7715, 223, 534, 18, 70, "Text",
 CellID->20803],
Cell[8252, 243, 536, 19, 70, "Text",
 CellID->6006],
Cell[8791, 264, 154, 6, 70, "MathCaption",
 CellID->7849],
Cell[8948, 272, 109, 5, 70, "Program",
 CellID->32670],
Cell[9060, 279, 267, 11, 70, "MathCaption",
 CellID->4524],
Cell[9330, 292, 80, 1, 70, "Program",
 CellID->25078],
Cell[9413, 295, 287, 11, 70, "MathCaption",
 CellID->11787],
Cell[9703, 308, 69, 1, 70, "Program",
 CellID->21984],
Cell[9775, 311, 185, 4, 70, "Text",
 CellID->139],
Cell[9963, 317, 532, 16, 70, "Text",
 CellID->7898],
Cell[10498, 335, 2387, 74, 70, "DefinitionBox",
 CellID->19973],
Cell[12888, 411, 129, 6, 70, "Caption",
 CellID->22638],
Cell[13020, 419, 143, 5, 70, "MathCaption",
 CellID->24041],
Cell[13166, 426, 70, 4, 70, "Program",
 CellID->21002],
Cell[13239, 432, 124, 5, 70, "MathCaption",
 CellID->15063],
Cell[13366, 439, 58, 1, 70, "Program",
 CellID->22211],
Cell[13427, 442, 114, 5, 70, "MathCaption",
 CellID->20066],
Cell[13544, 449, 67, 4, 70, "Program",
 CellID->18827],
Cell[13614, 455, 202, 7, 70, "MathCaption",
 CellID->9583],
Cell[13819, 464, 57, 1, 70, "Program",
 CellID->3930],
Cell[13879, 467, 98, 2, 70, "MathCaption",
 CellID->26565],
Cell[13980, 471, 59, 1, 70, "Program",
 CellID->12082],
Cell[14042, 474, 119, 5, 70, "MathCaption",
 CellID->27982],
Cell[14164, 481, 57, 1, 70, "Program",
 CellID->8831],
Cell[14224, 484, 119, 5, 70, "MathCaption",
 CellID->28235],
Cell[14346, 491, 58, 1, 70, "Program",
 CellID->23290],
Cell[14407, 494, 83, 1, 70, "MathCaption",
 CellID->11812],
Cell[14493, 497, 58, 1, 70, "Program",
 CellID->3256],
Cell[14554, 500, 125, 5, 70, "MathCaption",
 CellID->15802],
Cell[14682, 507, 57, 1, 70, "Program",
 CellID->1448],
Cell[14742, 510, 159, 4, 70, "MathCaption",
 CellID->6513],
Cell[14904, 516, 59, 1, 70, "Program",
 CellID->26126],
Cell[14966, 519, 490, 12, 70, "Text",
 CellID->27064],
Cell[15459, 533, 3352, 105, 70, "DefinitionBox",
 CellID->3215],
Cell[18814, 640, 92, 1, 70, "Caption",
 CellID->12293],
Cell[18909, 643, 764, 21, 70, "DefinitionBox",
 CellID->31907],
Cell[19676, 666, 110, 5, 70, "Caption",
 CellID->8437],
Cell[19789, 673, 58, 1, 70, "Program",
 CellID->16338],
Cell[19850, 676, 72, 1, 70, "MathCaption",
 CellID->22424],
Cell[19925, 679, 442, 15, 70, "Program",
 CellID->70],
Cell[20370, 696, 67, 1, 70, "MathCaption",
 CellID->11183],
Cell[20440, 699, 104, 5, 70, "Program",
 CellID->6345],
Cell[20547, 706, 68, 1, 70, "MathCaption",
 CellID->9328],
Cell[20618, 709, 107, 6, 70, "Program",
 CellID->26059],
Cell[20728, 717, 403, 12, 70, "Text",
 CellID->12537],
Cell[21134, 731, 521, 16, 70, "Text",
 CellID->11560],
Cell[21658, 749, 3487, 109, 70, "DefinitionBox",
 CellID->31349],
Cell[25148, 860, 92, 1, 70, "Caption",
 CellID->10923],
Cell[25243, 863, 602, 21, 70, "Text",
 CellID->30883],
Cell[CellGroupData[{
Cell[25870, 888, 72, 1, 70, "RelatedTutorialsSection",
 CellID->504981699],
Cell[25945, 891, 378, 11, 70, "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],
Cell[26350, 906, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

