(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13087,        494]
NotebookOptionsPosition[      8078,        337]
NotebookOutlinePosition[     10844,        407]
CellTagsIndexPosition[     10753,        401]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Expressions" :> 
         Documentation`HelpLookup["paclet:tutorial/ExpressionsOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Expressions\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Manipulating Expressions like Lists", "Title",
 CellTags->{"S2.1.5", "5.1"},
 CellID->4485],

Cell[TextData[{
 "You can use most of the list operations discussed in\[NonBreakingSpace]\"",
 ButtonBox["Lists\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ListsOverview"],
 " on any kind of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. By using these operations, you can manipulate the structure of \
expressions in many ways. "
}], "Text",
 CellID->23592],

Cell["Here is an expression that corresponds to a sum of terms. ", \
"MathCaption",
 CellID->31022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"1", "+", "x", "+", 
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"y", "^", "2"}]}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->4733],

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["y", "2"]}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->32735]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"], "[", 
   RowBox[{"t", ",", "2"}], "]"}]], "InlineFormula"],
 " takes the first two elements from ",
 Cell[BoxData["t"], "InlineFormula"],
 ", just as if ",
 Cell[BoxData["t"], "InlineFormula"],
 " were a list. "
}], "MathCaption",
 CellID->11383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{"t", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->9827],

Cell[BoxData[
 RowBox[{"1", "+", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->24499]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Length",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Length"]], "InlineFormula"],
 " gives the number of elements in ",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->3061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "t", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->22090],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->17135]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FreeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FreeQ"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
 " to test whether ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " appears nowhere in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FreeQ", "[", 
  RowBox[{"t", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->21479],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->26573]
}, Open  ]],

Cell[TextData[{
 "This gives a list of the positions at which ",
 Cell[BoxData["x"], "InlineFormula"],
 " appears in ",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10906],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{"t", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->6885],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->17245]
}, Open  ]],

Cell[TextData[{
 "You should remember that all functions which manipulate the structure of \
expressions act on the internal forms of these expressions. You can see these \
forms using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FullForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullForm"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 ". They may not be what you would expect from the printed versions of the \
expressions. "
}], "Text",
 CellID->13209],

Cell["Here is a function with four arguments. ", "MathCaption",
 CellID->25836],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->19981],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->20939]
}, Open  ]],

Cell[TextData[{
 "You can add an argument using ",
 Cell[BoxData[
  ButtonBox["Append",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Append"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->9699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Append", "[", 
  RowBox[{"%", ",", "e"}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->30101],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "]"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->9407]
}, Open  ]],

Cell["This reverses the arguments. ", "MathCaption",
 CellID->30195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reverse", "[", "%", "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->31219],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"e", ",", "d", ",", "c", ",", "b", ",", "a"}], "]"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->3084]
}, Open  ]],

Cell[TextData[{
 "There are a few extra functions that can be used with expressions, as \
discussed in \"",
 ButtonBox["Structural Operations\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/StructuralOperations"],
 ". "
}], "Text",
 CellID->11427],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->43076672],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExpressionsOverview"]], "RelatedTutorials",
 CellID->323659647]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->210067287],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->48157467]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Manipulating Expressions like Lists - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Expressions", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/ExpressionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/PartsOfExpressions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ExpressionsAsTrees"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 38, 58.7419248}", "context" -> "", 
    "keywords" -> {
     "Append", "elements of expression", "expression elements", "expressions",
       "FreeQ", "Length", "number of elements", "Reverse", "Take"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "You can use most of the list operations discussed in \"Lists\" on any \
kind of Mathematica expression. By using these operations, you can manipulate \
the structure of expressions in many ways. Here is an expression that \
corresponds to a sum of terms. Take[t,2] takes the first two elements from t, \
just as if t were a list. ", "synonyms" -> {"2.1.5"}, "title" -> 
    "Manipulating Expressions like Lists", "type" -> "Tutorial", "uri" -> 
    "tutorial/ManipulatingExpressionsLikeLists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.1.5"->{
  Cell[1224, 42, 97, 2, 70, "Title",
   CellTags->{"S2.1.5", "5.1"},
   CellID->4485]},
 "5.1"->{
  Cell[1224, 42, 97, 2, 70, "Title",
   CellTags->{"S2.1.5", "5.1"},
   CellID->4485]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.1.5", 10544, 390},
 {"5.1", 10642, 394}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 599, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1224, 42, 97, 2, 70, "Title",
 CellTags->{"S2.1.5", "5.1"},
 CellID->4485],
Cell[1324, 46, 390, 11, 70, "Text",
 CellID->23592],
Cell[1717, 59, 99, 2, 70, "MathCaption",
 CellID->31022],
Cell[CellGroupData[{
Cell[1841, 65, 179, 6, 28, "Input",
 CellID->4733],
Cell[2023, 73, 245, 8, 36, "Output",
 CellID->32735]
}, Open  ]],
Cell[2283, 84, 368, 13, 70, "MathCaption",
 CellID->11383],
Cell[CellGroupData[{
Cell[2676, 101, 119, 4, 28, "Input",
 CellID->9827],
Cell[2798, 107, 177, 6, 36, "Output",
 CellID->24499]
}, Open  ]],
Cell[2990, 116, 246, 9, 70, "MathCaption",
 CellID->3061],
Cell[CellGroupData[{
Cell[3261, 129, 99, 3, 28, "Input",
 CellID->22090],
Cell[3363, 134, 155, 5, 36, "Output",
 CellID->17135]
}, Open  ]],
Cell[3533, 142, 456, 18, 70, "MathCaption",
 CellID->12100],
Cell[CellGroupData[{
Cell[4014, 164, 121, 4, 70, "Input",
 CellID->21479],
Cell[4138, 170, 159, 5, 36, "Output",
 CellID->26573]
}, Open  ]],
Cell[4312, 178, 198, 7, 70, "MathCaption",
 CellID->10906],
Cell[CellGroupData[{
Cell[4535, 189, 123, 4, 70, "Input",
 CellID->6885],
Cell[4661, 195, 273, 10, 36, "Output",
 CellID->17245]
}, Open  ]],
Cell[4949, 208, 480, 13, 70, "Text",
 CellID->13209],
Cell[5432, 223, 79, 1, 70, "MathCaption",
 CellID->25836],
Cell[CellGroupData[{
Cell[5536, 228, 137, 4, 70, "Input",
 CellID->19981],
Cell[5676, 234, 225, 7, 36, "Output",
 CellID->20939]
}, Open  ]],
Cell[5916, 244, 205, 8, 70, "MathCaption",
 CellID->9699],
Cell[CellGroupData[{
Cell[6146, 256, 122, 4, 70, "Input",
 CellID->30101],
Cell[6271, 262, 235, 7, 36, "Output",
 CellID->9407]
}, Open  ]],
Cell[6521, 272, 68, 1, 70, "MathCaption",
 CellID->30195],
Cell[CellGroupData[{
Cell[6614, 277, 100, 3, 70, "Input",
 CellID->31219],
Cell[6717, 282, 235, 7, 36, "Output",
 CellID->3084]
}, Open  ]],
Cell[6967, 292, 255, 8, 70, "Text",
 CellID->11427],
Cell[CellGroupData[{
Cell[7247, 304, 71, 1, 70, "RelatedTutorialsSection",
 CellID->43076672],
Cell[7321, 307, 152, 3, 70, "RelatedTutorials",
 CellID->323659647]
}, Open  ]],
Cell[CellGroupData[{
Cell[7510, 315, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->210067287],
Cell[7611, 318, 413, 13, 70, "TutorialRelatedLinks",
 CellID->48157467]
}, Open  ]]
}, Open  ]],
Cell[8051, 335, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

