(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11102,        416]
NotebookOptionsPosition[      6647,        279]
NotebookOutlinePosition[      9346,        347]
CellTagsIndexPosition[      9255,        341]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Calculus" :> 
         Documentation`HelpLookup["paclet:tutorial/CalculusOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Calculus\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Manipulating Integrals in Symbolic Form", "Title",
 CellTags->{"S3.5.10", "10.1"},
 CellID->5398],

Cell[TextData[{
 "When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " cannot give you an explicit result for an integral, it leaves the integral \
in a symbolic form. It is often useful to manipulate this symbolic form."
}], "Text",
 CellID->6875],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " cannot give an explicit result for this integral, so it leaves the \
integral in symbolic form. "
}], "MathCaption",
 CellID->11569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], " ", 
    RowBox[{"f", "[", "x", "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->304],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"f", "[", "x", "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{78, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->16990]
}, Open  ]],

Cell["\<\
Differentiating the symbolic form gives the integrand back again. \
\>", "MathCaption",
 CellID->27843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->29557],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], " ", 
  RowBox[{"f", "[", "x", "]"}]}]], "Output",
 ImageSize->{48, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->7857]
}, Open  ]],

Cell["\<\
Here is a definite integral which cannot be done explicitly. \
\>", "MathCaption",
 CellID->11319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"a", "[", "x", "]"}], ",", 
     RowBox[{"b", "[", "x", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->11875],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", 
   RowBox[{"a", "[", "x", "]"}], 
   RowBox[{"b", "[", "x", "]"}]], 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{83, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->24149]
}, Open  ]],

Cell["This gives the derivative of the definite integral. ", "MathCaption",
 CellID->18190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->3946],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    RowBox[{"f", "[", 
     RowBox[{"a", "[", "x", "]"}], "]"}]}], " ", 
   RowBox[{
    SuperscriptBox["a", "\[Prime]",
     MultilineFunction->None], "[", "x", "]"}]}], "+", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"b", "[", "x", "]"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["b", "\[Prime]",
     MultilineFunction->None], "[", "x", "]"}]}]}]], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->10798]
}, Open  ]],

Cell[TextData[{
 "Here is a definite integral with end points that do not explicitly depend \
on\[NonBreakingSpace]",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"defint", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "a", ",", "b"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->26346],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "a", "b"], 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{68, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->20509]
}, Open  ]],

Cell[TextData[{
 "The partial derivative of this with respect to ",
 Cell[BoxData["u"], "InlineFormula"],
 " is zero. "
}], "MathCaption",
 CellID->30080],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"defint", ",", "u"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->30479],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->7981]
}, Open  ]],

Cell["\<\
There is a non\[Hyphen]trivial total derivative, however. \
\>", "MathCaption",
 CellID->23207],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{"defint", ",", "u"}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->7719],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dt", "[", 
     RowBox[{"a", ",", "u"}], "]"}]}], " ", 
   RowBox[{"f", "[", "a", "]"}]}], "+", 
  RowBox[{
   RowBox[{"Dt", "[", 
    RowBox[{"b", ",", "u"}], "]"}], " ", 
   RowBox[{"f", "[", "b", "]"}]}]}]], "Output",
 ImageSize->{193, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->32138]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->146626261],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CalculusOverview"]], "RelatedTutorials",
 CellID->808424779]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Manipulating Integrals in Symbolic Form - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Calculus", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/CalculusOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/IntegralsOverRegions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DifferentialEquations"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 0.1013346}", "context" -> "", 
    "keywords" -> {"differentiation", "integrals", "integration"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "When Mathematica cannot give you an explicit result for an integral, it \
leaves the integral in a symbolic form. It is often useful to manipulate this \
symbolic form. Mathematica cannot give an explicit result for this integral, \
so it leaves the integral in symbolic form. Differentiating the symbolic form \
gives the integrand back again. ", "synonyms" -> {"3.5.10"}, "title" -> 
    "Manipulating Integrals in Symbolic Form", "type" -> "Tutorial", "uri" -> 
    "tutorial/ManipulatingIntegralsInSymbolicForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.5.10"->{
  Cell[1215, 42, 103, 2, 70, "Title",
   CellTags->{"S3.5.10", "10.1"},
   CellID->5398]},
 "10.1"->{
  Cell[1215, 42, 103, 2, 70, "Title",
   CellTags->{"S3.5.10", "10.1"},
   CellID->5398]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.5.10", 9039, 330},
 {"10.1", 9141, 334}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 590, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1215, 42, 103, 2, 70, "Title",
 CellTags->{"S3.5.10", "10.1"},
 CellID->5398],
Cell[1321, 46, 255, 7, 70, "Text",
 CellID->6875],
Cell[1579, 55, 200, 6, 70, "MathCaption",
 CellID->11569],
Cell[CellGroupData[{
Cell[1804, 65, 202, 7, 28, "Input",
 CellID->304],
Cell[2009, 74, 314, 11, 50, "Output",
 CellID->16990]
}, Open  ]],
Cell[2338, 88, 113, 3, 70, "MathCaption",
 CellID->27843],
Cell[CellGroupData[{
Cell[2476, 95, 117, 4, 28, "Input",
 CellID->29557],
Cell[2596, 101, 228, 8, 36, "Output",
 CellID->7857]
}, Open  ]],
Cell[2839, 112, 108, 3, 70, "MathCaption",
 CellID->11319],
Cell[CellGroupData[{
Cell[2972, 119, 275, 9, 28, "Input",
 CellID->11875],
Cell[3250, 130, 353, 12, 53, "Output",
 CellID->24149]
}, Open  ]],
Cell[3618, 145, 91, 1, 70, "MathCaption",
 CellID->18190],
Cell[CellGroupData[{
Cell[3734, 150, 116, 4, 70, "Input",
 CellID->3946],
Cell[3853, 156, 547, 19, 36, "Output",
 CellID->10798]
}, Open  ]],
Cell[4415, 178, 196, 6, 70, "MathCaption",
 CellID->19467],
Cell[CellGroupData[{
Cell[4636, 188, 245, 8, 70, "Input",
 CellID->26346],
Cell[4884, 198, 295, 10, 51, "Output",
 CellID->20509]
}, Open  ]],
Cell[5194, 211, 154, 5, 70, "MathCaption",
 CellID->30080],
Cell[CellGroupData[{
Cell[5373, 220, 122, 4, 70, "Input",
 CellID->30479],
Cell[5498, 226, 154, 5, 36, "Output",
 CellID->7981]
}, Open  ]],
Cell[5667, 234, 105, 3, 70, "MathCaption",
 CellID->23207],
Cell[CellGroupData[{
Cell[5797, 241, 122, 4, 70, "Input",
 CellID->7719],
Cell[5922, 247, 413, 15, 36, "Output",
 CellID->32138]
}, Open  ]],
Cell[CellGroupData[{
Cell[6372, 267, 72, 1, 70, "RelatedTutorialsSection",
 CellID->146626261],
Cell[6447, 270, 146, 3, 70, "RelatedTutorials",
 CellID->808424779]
}, Open  ]]
}, Open  ]],
Cell[6620, 277, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

