(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41023,       1032]
NotebookOptionsPosition[     35579,        869]
NotebookOutlinePosition[     38631,        944]
CellTagsIndexPosition[     38540,        938]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Graphics and Sound\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options Management" :> 
          Documentation`HelpLookup["paclet:guide/OptionsManagement"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Options Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AbsoluteOptions" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteOptions"], "All" :> 
          Documentation`HelpLookup["paclet:ref/All"], "Automatic" :> 
          Documentation`HelpLookup["paclet:ref/Automatic"], "Options" :> 
          Documentation`HelpLookup["paclet:ref/Options"], "SetOptions" :> 
          Documentation`HelpLookup["paclet:ref/SetOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AbsoluteOptions\"\>", 
       2->"\<\"All\"\>", 3->"\<\"Automatic\"\>", 4->"\<\"Options\"\>", 
       5->"\<\"SetOptions\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Manipulating Options", "Title",
 CellTags->{"S1.9.4", "4.1"},
 CellID->15639],

Cell[TextData[{
 "There are a number of functions built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " which, like ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ", have various options you can set. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides some general mechanisms for handling such options. "
}], "Text",
 CellID->19455],

Cell[TextData[{
 "If you do not give a specific setting for an option to a function like ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ", then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will automatically use a default value for the option. The function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Options",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Options"], "[", 
   RowBox[{
    StyleBox["function", "TI"], ",", 
    StyleBox["option", "TI"]}], "]"}]], "InlineFormula"],
 " allows you to find out the default value for a particular option. You can \
reset the default using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetOptions"], "[", 
   RowBox[{
    StyleBox["function", "TI"], ",", 
    RowBox[{
     StyleBox["option", "TI"], "->", 
     StyleBox["value", "TI"]}]}], "]"}]], "InlineFormula"],
 ". Note that if you do this, the default value you have given will stay \
until you explicitly change it. "
}], "Text",
 CellID->6561],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Options",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Options"], "[", 
     StyleBox["function", "TI"], "]"}], Cell[
    "give a list of the current default settings for all options", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["Options",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Options"], "[", 
     StyleBox["function", "TI"], ",", 
     StyleBox["option", "TI"], "]"}], Cell[
    "give the default setting for a particular option", "TableText"]},
   {
    RowBox[{
     ButtonBox["SetOptions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SetOptions"], "[", 
     StyleBox["function", "TI"], ",", 
     StyleBox["option", "TI"], "->", 
     StyleBox["value", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["reset defaults", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2651],

Cell["Manipulating default settings for options. ", "Caption",
 CellID->4410],

Cell[TextData[{
 "Here is the default setting for the ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " option of ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->32677],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{"Plot", ",", "PlotRange"}], "]"}]], "Input",
 CellLabel->"In[38]:=",
 CellID->16576],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PlotRange", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"Full", ",", "Automatic"}], "}"}]}], "}"}]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[38]=",
 CellID->384205660]
}, Open  ]],

Cell[TextData[{
 "This resets the default for the ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " option. The semicolon stops ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from printing out the rather long list of options for ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17222],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Plot", ",", 
    RowBox[{"PlotRange", "->", "All"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[39]:=",
 CellID->27502],

Cell[TextData[{
 "Until you explicitly reset it, the default for the ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " option will now be ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->32224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{"Plot", ",", "PlotRange"}], "]"}]], "Input",
 CellLabel->"In[40]:=",
 CellID->3196],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PlotRange", "\[Rule]", "All"}], "}"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]=",
 CellID->50973035]
}, Open  ]],

Cell[TextData[{
 "The graphics objects that you get from ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 " store information on the options they use. You can get this information by \
applying the ",
 Cell[BoxData[
  ButtonBox["Options",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Options"]], "InlineFormula"],
 " function to these graphics objects. "
}], "Text",
 CellID->24023],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Options",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Options"], "[", 
     StyleBox["plot", "TI"], "]"}], Cell[
    "show all the options used for a particular plot", "TableText"]},
   {
    RowBox[{
     ButtonBox["Options",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Options"], "[", 
     StyleBox["plot", "TI"], ",", 
     StyleBox["option", "TI"], "]"}], Cell[
    "show the setting for a specific option", "TableText"]},
   {
    RowBox[{
     ButtonBox["AbsoluteOptions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AbsoluteOptions"], "[", 
     StyleBox["plot", "TI"], ",", 
     StyleBox["option", "TI"], "]"}], Cell[TextData[{
     "show the absolute form used for a specific option, even if the setting \
for the option is ",
     Cell[BoxData[
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      ButtonBox["All",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/All"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13912],

Cell["Getting information on options used in plots. ", "Caption",
 CellID->17723],

Cell["Here is a plot, with default settings for all options. ", "MathCaption",
 CellID->5714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"SinIntegral", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[41]:=",
 CellID->5371],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[41]=",
 CellID->140529887]
}, Open  ]],

Cell[TextData[{
 "The setting used for the ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " option was ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{"g", ",", "PlotRange"}], "]"}]], "Input",
 CellLabel->"In[42]:=",
 CellID->18981],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PlotRange", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"All", ",", "All"}], "}"}]}], "}"}]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[42]=",
 CellID->87262837]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteOptions"]], "InlineFormula"],
 " gives the ",
 StyleBox["absolute",
  FontSlant->"Italic"],
 " automatically chosen values used for ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23298],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteOptions", "[", 
  RowBox[{"g", ",", "PlotRange"}], "]"}]], "Input",
 CellLabel->"In[43]:=",
 CellID->30149],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PlotRange", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.0816326530612243`*^-7", ",", "19.999999591836733`"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"4.081632654084899`*^-7", ",", "1.8519355407444107`"}], "}"}]}],
     "}"}]}], "}"}]], "Output",
 ImageSize->{413, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[43]=",
 CellID->136101026]
}, Open  ]],

Cell["\<\
While it's often convenient to use a variable to represent a graphic as in \
the above examples, the graphic itself can be evaluated directly. The typical \
ways to do this in the notebook interface are to copy and paste the graphic \
or to simply begin typing in the graphical output cell, at which point the \
output cell will be converted into a new input cell.\
\>", "Text",
 CellID->951721388],

Cell[TextData[{
 "When a plot created with no explicit ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " is placed into an input cell, it will automatically shrink to more easily \
accommodate input."
}], "Text",
 CellID->386341310],

Cell["\<\
The input cell below was created by copying and pasting the graphical output \
created in the previous example.\
\>", "MathCaption",
 CellID->516196809],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteOptions", "[", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd2Hk4lN/bAHD7TkL2LEPMiBnGUsrXuSsJSZJsSSVJkSSKSIpUQpJsCYmi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       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0., 0.},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", " ", "PlotRange"}], 
  "]"}]], "Input",
 CellLabel->"In[47]:=",
 CellID->617684031],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PlotRange", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.0816326530612243`*^-7", ",", "19.999999591836733`"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"4.081632654084899`*^-7", ",", "1.8519355407444107`"}], "}"}]}],
     "}"}]}], "}"}]], "Output",
 ImageSize->{413, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[47]=",
 CellID->131033071]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->373422913],

Cell[TextData[ButtonBox["Options Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OptionsManagement"]], "TutorialMoreAbout",
 CellID->337310512]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->527635844],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "RelatedTutorials",\

 CellID->151800574]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Manipulating Options - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Graphics and Sound", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/GraphicsAndSoundOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/RedrawingAndCombiningPlots"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ThreeDimensionalSurfacePlots"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 8.2265426}", "context" -> "", 
    "keywords" -> {
     "AbsoluteOptions", "automatic options", "options", "PlotRange", 
      "plot range", "SetOptions"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "There are a number of functions built into Mathematica which, like Plot, \
have various options you can set. Mathematica provides some general \
mechanisms for handling such options. If you do not give a specific setting \
for an option to a function like Plot, then Mathematica will automatically \
use a default value for the option. The function Options[function,option] \
allows you to find out the default value for a particular option. You can \
reset the default using SetOptions[function,option->value]. Note that if you \
do this, the default value you have given will stay until you explicitly \
change it. Manipulating default settings for options. ", 
    "synonyms" -> {"1.9.4"}, "title" -> "Manipulating Options", "type" -> 
    "Tutorial", "uri" -> "tutorial/ManipulatingOptions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.9.4"->{
  Cell[2786, 79, 83, 2, 70, "Title",
   CellTags->{"S1.9.4", "4.1"},
   CellID->15639]},
 "4.1"->{
  Cell[2786, 79, 83, 2, 70, "Title",
   CellTags->{"S1.9.4", "4.1"},
   CellID->15639]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.9.4", 38329, 927},
 {"4.1", 38428, 931}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2161, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2786, 79, 83, 2, 70, "Title",
 CellTags->{"S1.9.4", "4.1"},
 CellID->15639],
Cell[2872, 83, 424, 14, 70, "Text",
 CellID->19455],
Cell[3299, 99, 1090, 33, 70, "Text",
 CellID->6561],
Cell[4392, 134, 1354, 38, 70, "DefinitionBox",
 CellID->2651],
Cell[5749, 174, 77, 1, 70, "Caption",
 CellID->4410],
Cell[5829, 177, 345, 13, 70, "MathCaption",
 CellID->32677],
Cell[CellGroupData[{
Cell[6199, 194, 134, 4, 28, "Input",
 CellID->16576],
Cell[6336, 200, 279, 9, 36, "Output",
 CellID->384205660]
}, Open  ]],
Cell[6630, 212, 468, 16, 70, "MathCaption",
 CellID->17222],
Cell[7101, 230, 184, 6, 70, "Input",
 CellID->27502],
Cell[7288, 238, 367, 13, 70, "MathCaption",
 CellID->32224],
Cell[CellGroupData[{
Cell[7680, 255, 133, 4, 70, "Input",
 CellID->3196],
Cell[7816, 261, 220, 7, 36, "Output",
 CellID->50973035]
}, Open  ]],
Cell[8051, 271, 572, 19, 70, "Text",
 CellID->24023],
Cell[8626, 292, 1458, 43, 70, "DefinitionBox",
 CellID->13912],
Cell[10087, 337, 81, 1, 70, "Caption",
 CellID->17723],
Cell[10171, 340, 93, 1, 70, "MathCaption",
 CellID->5714],
Cell[CellGroupData[{
Cell[10289, 345, 245, 8, 28, "Input",
 CellID->5371],
Cell[10537, 355, 2361, 43, 136, "Output",
 Evaluatable->False,
 CellID->140529887]
}, Open  ]],
Cell[12913, 401, 332, 13, 70, "MathCaption",
 CellID->1620],
Cell[CellGroupData[{
Cell[13270, 418, 131, 4, 70, "Input",
 CellID->18981],
Cell[13404, 424, 271, 9, 36, "Output",
 CellID->87262837]
}, Open  ]],
Cell[13690, 436, 415, 15, 70, "MathCaption",
 CellID->23298],
Cell[CellGroupData[{
Cell[14130, 455, 139, 4, 70, "Input",
 CellID->30149],
Cell[14272, 461, 464, 15, 39, "Output",
 CellID->136101026]
}, Open  ]],
Cell[14751, 479, 408, 7, 70, "Text",
 CellID->951721388],
Cell[15162, 488, 309, 9, 70, "Text",
 CellID->386341310],
Cell[15474, 499, 162, 4, 70, "MathCaption",
 CellID->516196809],
Cell[CellGroupData[{
Cell[15661, 507, 18858, 316, 70, "Input",
 CellID->617684031],
Cell[34522, 825, 464, 15, 39, "Output",
 CellID->131033071]
}, Open  ]],
Cell[CellGroupData[{
Cell[35023, 845, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->373422913],
Cell[35092, 848, 155, 3, 70, "TutorialMoreAbout",
 CellID->337310512]
}, Open  ]],
Cell[CellGroupData[{
Cell[35284, 856, 72, 1, 70, "RelatedTutorialsSection",
 CellID->527635844],
Cell[35359, 859, 166, 4, 70, "RelatedTutorials",
 CellID->151800574]
}, Open  ]]
}, Open  ]],
Cell[35552, 867, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

