(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24699,        910]
NotebookOptionsPosition[     17823,        683]
NotebookOutlinePosition[     20580,        755]
CellTagsIndexPosition[     20487,        749]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Modularity and the Naming of Things" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Modularity and the Naming of Things\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Clear" :> Documentation`HelpLookup["paclet:ref/Clear"], 
          "Contexts" :> Documentation`HelpLookup["paclet:ref/Contexts"], 
          "NameQ" :> Documentation`HelpLookup["paclet:ref/NameQ"], "Names" :> 
          Documentation`HelpLookup["paclet:ref/Names"], "Remove" :> 
          Documentation`HelpLookup["paclet:ref/Remove"], "Symbol" :> 
          Documentation`HelpLookup["paclet:ref/Symbol"], "SymbolName" :> 
          Documentation`HelpLookup["paclet:ref/SymbolName"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Clear\"\>", 2->"\<\"Contexts\"\>", 
       3->"\<\"NameQ\"\>", 4->"\<\"Names\"\>", 5->"\<\"Remove\"\>", 
       6->"\<\"Symbol\"\>", 7->"\<\"SymbolName\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Manipulating Symbols and Contexts by Name", "Title",
 CellTags->{"S2.7.12", "12.1"},
 CellID->26009],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Symbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Symbol"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}], Cell[
    "construct a symbol with a given name", "TableText"]},
   {
    RowBox[{
     ButtonBox["SymbolName",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SymbolName"], "[", 
     StyleBox["symb", "TI"], "]"}], Cell[
    "find the name of a symbol", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->8941],

Cell["Converting between symbols and their names. ", "Caption",
 CellID->26231],

Cell[TextData[{
 "Here is the symbol ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "//", "InputForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4898],

Cell["x", "Output",
 ImageSize->{7, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->1502903277]
}, Open  ]],

Cell["Its name is a string. ", "MathCaption",
 CellID->24387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SymbolName", "[", "x", "]"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->759],

Cell["\"x\"", "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->592720525]
}, Open  ]],

Cell[TextData[{
 "This gives the symbol ",
 Cell[BoxData["x"], "InlineFormula"],
 " again. "
}], "MathCaption",
 CellID->16145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Symbol", "[", "\"\<x\>\"", "]"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15729],

Cell["x", "Output",
 ImageSize->{7, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//InputForm=",
 CellID->1824708889]
}, Open  ]],

Cell[TextData[{
 "Once you have made an assignment such as ",
 Cell[BoxData[
  RowBox[{"x", "=", "2"}]], "InlineFormula"],
 ", then whenever ",
 Cell[BoxData["x"], "InlineFormula"],
 " is evaluated, it is replaced by ",
 Cell[BoxData["2"], "InlineFormula"],
 ". Sometimes, however, you may want to continue to refer to ",
 Cell[BoxData["x"], "InlineFormula"],
 " itself, without immediately getting the value of ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "Text",
 CellID->9324],

Cell[TextData[{
 "You can do this by referring to ",
 Cell[BoxData["x"], "InlineFormula"],
 " by name. The name of the symbol ",
 Cell[BoxData["x"], "InlineFormula"],
 " is the string ",
 Cell[BoxData["\"\<x\>\""], "InlineFormula"],
 ", and even though ",
 Cell[BoxData["x"], "InlineFormula"],
 " itself may be replaced by a value, the string ",
 Cell[BoxData["\"\<x\>\""], "InlineFormula"],
 " will always stay the same. "
}], "Text",
 CellID->767],

Cell[TextData[{
 "The names of the symbols ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["xp"], "InlineFormula"],
 " are the strings ",
 Cell[BoxData["\"\<x\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<xp\>\""], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->4966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SymbolName", "[", "x", "]"}], ",", 
     RowBox[{"SymbolName", "[", "xp", "]"}]}], "}"}], "//", 
   "InputForm"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->3968],

Cell["{\"x\", \"xp\"}", "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//InputForm=",
 CellID->1815818263]
}, Open  ]],

Cell[TextData[{
 "This assigns a value to ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", "2"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->10849],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->567438724]
}, Open  ]],

Cell[TextData[{
 "Whenever you enter ",
 Cell[BoxData["x"], "InlineFormula"],
 " it is now replaced by ",
 Cell[BoxData["2"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->29542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "xp"}], "}"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->17923],

Cell["{2, xp}", "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//InputForm=",
 CellID->2115241588]
}, Open  ]],

Cell[TextData[{
 "The name ",
 Cell[BoxData["\"\<x\>\""], "InlineFormula"],
 " is not affected, however. "
}], "MathCaption",
 CellID->5417],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "//", "InputForm"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->15411],

Cell["InputForm[{\"x\", \"xp\"}]", "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//InputForm=",
 CellID->1421077078]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NameQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NameQ"], "[", "\"\<\!\(\*
StyleBox[\"form\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "test whether any symbol has a name which matches ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Names",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Names"], "[", "\"\<\!\(\*
StyleBox[\"form\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "give a list of all symbol names which match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Contexts",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Contexts"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"form\", \"TI\"]`\)]\)\>\"", "]"}], Cell[TextData[{
     "give a list of all context names which match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->12048],

Cell["Referring to symbols and contexts by name. ", "Caption",
 CellID->15781],

Cell[TextData[{
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["xp"], "InlineFormula"],
 " are symbols that have been created in this ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session; ",
 Cell[BoxData["xpp"], "InlineFormula"],
 " is not. "
}], "MathCaption",
 CellID->23833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"NameQ", "[", "\"\<x\>\"", "]"}], ",", 
   RowBox[{"NameQ", "[", "\"\<xp\>\"", "]"}], ",", 
   RowBox[{"NameQ", "[", "\"\<xpp\>\"", "]"}]}], "}"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->10574],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "False"}], "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->1876811659]
}, Open  ]],

Cell[TextData[{
 "You can specify the form of symbol names using ",
 StyleBox["string patterns",
  FontSlant->"Italic"],
 " of the kind discussed in\[NonBreakingSpace]\"",
 ButtonBox["String Patterns\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/StringPatterns"],
 ". ",
 Cell[BoxData["\"\<x*\>\""], "InlineFormula"],
 " stands, for example, for all names that start with ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "Text",
 CellID->21884],

Cell[TextData[{
 "This gives a list of all symbol names in this ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session that begin with\[NonBreakingSpace]",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Names", "[", "\"\<x*\>\"", "]"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->10468],

Cell["{\"x\", \"xp\"}", "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]//InputForm=",
 CellID->1333745677]
}, Open  ]],

Cell[TextData[{
 "These names correspond to built\[Hyphen]in functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->6204],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Names", "[", "\"\<Qu*\>\"", "]"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->31844],

Cell["\<\
{\"QuadraticIrrationalQ\", \"Quantile\", \"Quartics\", \"QuartileDeviation\", \
\"Quartiles\", 
 \"QuartileSkewness\", \"Quiet\", \"Quit\", \"Quotient\", \"QuotientRemainder\
\"}\
\>", "Output",
 ImageSize->{581, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]//InputForm=",
 CellID->829285953]
}, Open  ]],

Cell[TextData[{
 "This asks for names \[OpenCurlyDoubleQuote]close\[CloseCurlyDoubleQuote] to \
",
 Cell[BoxData["WeierstrssP"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Names", "[", 
  RowBox[{"\"\<WeierstrssP\>\"", ",", 
   RowBox[{"SpellingCorrection", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->31911],

Cell[BoxData[
 RowBox[{"{", "\<\"WeierstrassP\"\>", "}"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->640143041]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Clear",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Clear"], "[", "\"\<\!\(\*
StyleBox[\"form\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "clear the values of all symbols whose names match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Clear",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Clear"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)*\>\"", "]"}], Cell[
    "clear the values of all symbols in the specified context", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["Remove",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Remove"], "[", "\"\<\!\(\*
StyleBox[\"form\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "remove completely all symbols whose names match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Remove",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Remove"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)*\>\"", "]"}], Cell[
    "remove completely all symbols in the specified context", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->19951],

Cell["Getting rid of symbols by name. ", "Caption",
 CellID->26700],

Cell[TextData[{
 "This clears the values of all symbols whose names start with ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10342],

Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<x*\>\"", "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->630],

Cell[TextData[{
 "The name ",
 Cell[BoxData["\"\<x\>\""], "InlineFormula"],
 " is still known, however. "
}], "MathCaption",
 CellID->3425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Names", "[", "\"\<x*\>\"", "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->10430],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"x\"\>", ",", "\<\"xp\"\>"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->2138502264]
}, Open  ]],

Cell[TextData[{
 "But the value of ",
 Cell[BoxData["x"], "InlineFormula"],
 " has been cleared. "
}], "MathCaption",
 CellID->17720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "xp"}], "}"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->10198],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "xp"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->1521234856]
}, Open  ]],

Cell[TextData[{
 "This removes completely all symbols whose names start with ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31480],

Cell[BoxData[
 RowBox[{"Remove", "[", "\"\<x*\>\"", "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->24405],

Cell[TextData[{
 "Now not even the name ",
 Cell[BoxData["\"\<x\>\""], "InlineFormula"],
 " is known. "
}], "MathCaption",
 CellID->21382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Names", "[", "\"\<x*\>\"", "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->12425],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->1601407257]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Remove",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Remove"], "[", "\"\<Global`*\>\"", "]"}], Cell[
    TextData[{
     "remove completely all symbols in the ",
     Cell[BoxData["Global`"], "InlineFormula"],
     " context"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16612],

Cell["Removing all symbols you have introduced. ", "Caption",
 CellID->3192],

Cell[TextData[{
 "If you do not set up any additional contexts, then all the symbols that you \
introduce in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session will be placed in the ",
 Cell[BoxData["Global`"], "InlineFormula"],
 " context. You can remove these symbols completely using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Remove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Remove"], "[", "\"\<Global`*\>\"", "]"}]], 
  "InlineFormula"],
 ". Built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " objects are in the ",
 Cell[BoxData["System`"], "InlineFormula"],
 " context, and are thus unaffected by this."
}], "Text",
 CellID->4009],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->2986311],

Cell[TextData[ButtonBox["Modularity and the Naming of Things",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], \
"RelatedTutorials",
 CellID->405226890]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Manipulating Symbols and Contexts by Name - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Modularity and the Naming of Things", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/AutomaticLoadingOfPackages"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/InterceptingTheCreationOfNewSymbols"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 9.0234380}", "context" -> "", 
    "keywords" -> {
     "catalog", "cleaning up expressions", "clear", "contexts", "inert forms",
       "listing", "NameQ", "names", "referring to symbols by name", "remove", 
      "resetting", "symbol", "SymbolName", "symbols", 
      "unevaluated symbol names", "workspace"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Converting between symbols and their names. Here is the symbol x. Its \
name is a string. ", "synonyms" -> {"2.7.12"}, "title" -> 
    "Manipulating Symbols and Contexts by Name", "type" -> "Tutorial", "uri" -> 
    "tutorial/ManipulatingSymbolsAndContextsByName"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.7.12"->{
  Cell[2406, 66, 106, 2, 70, "Title",
   CellTags->{"S2.7.12", "12.1"},
   CellID->26009]},
 "12.1"->{
  Cell[2406, 66, 106, 2, 70, "Title",
   CellTags->{"S2.7.12", "12.1"},
   CellID->26009]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.7.12", 20269, 738},
 {"12.1", 20372, 742}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1781, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2406, 66, 106, 2, 70, "Title",
 CellTags->{"S2.7.12", "12.1"},
 CellID->26009],
Cell[2515, 70, 778, 23, 70, "DefinitionBox",
 CellID->8941],
Cell[3296, 95, 79, 1, 70, "Caption",
 CellID->26231],
Cell[3378, 98, 118, 5, 70, "MathCaption",
 CellID->26099],
Cell[CellGroupData[{
Cell[3521, 107, 96, 3, 28, "Input",
 CellID->4898],
Cell[3620, 112, 160, 5, 50, "Output",
 CellID->1502903277]
}, Open  ]],
Cell[3795, 120, 61, 1, 70, "MathCaption",
 CellID->24387],
Cell[CellGroupData[{
Cell[3881, 125, 132, 4, 28, "Input",
 CellID->759],
Cell[4016, 131, 164, 5, 50, "Output",
 CellID->592720525]
}, Open  ]],
Cell[4195, 139, 127, 5, 70, "MathCaption",
 CellID->16145],
Cell[CellGroupData[{
Cell[4347, 148, 138, 4, 28, "Input",
 CellID->15729],
Cell[4488, 154, 160, 5, 50, "Output",
 CellID->1824708889]
}, Open  ]],
Cell[4663, 162, 485, 14, 70, "Text",
 CellID->9324],
Cell[5151, 178, 449, 13, 70, "Text",
 CellID->767],
Cell[5603, 193, 297, 11, 70, "MathCaption",
 CellID->4966],
Cell[CellGroupData[{
Cell[5925, 208, 253, 9, 70, "Input",
 CellID->3968],
Cell[6181, 219, 175, 5, 50, "Output",
 CellID->1815818263]
}, Open  ]],
Cell[6371, 227, 122, 5, 70, "MathCaption",
 CellID->2094],
Cell[CellGroupData[{
Cell[6518, 236, 88, 3, 70, "Input",
 CellID->10849],
Cell[6609, 241, 158, 5, 36, "Output",
 CellID->567438724]
}, Open  ]],
Cell[6782, 249, 184, 7, 70, "MathCaption",
 CellID->29542],
Cell[CellGroupData[{
Cell[6991, 260, 145, 5, 70, "Input",
 CellID->17923],
Cell[7139, 267, 167, 5, 50, "Output",
 CellID->2115241588]
}, Open  ]],
Cell[7321, 275, 140, 5, 70, "MathCaption",
 CellID->5417],
Cell[CellGroupData[{
Cell[7486, 284, 97, 3, 70, "Input",
 CellID->15411],
Cell[7586, 289, 187, 5, 50, "Output",
 CellID->1421077078]
}, Open  ]],
Cell[7788, 297, 1357, 40, 70, "DefinitionBox",
 CellID->12048],
Cell[9148, 339, 78, 1, 70, "Caption",
 CellID->15781],
Cell[9229, 342, 303, 11, 70, "MathCaption",
 CellID->23833],
Cell[CellGroupData[{
Cell[9557, 357, 247, 7, 70, "Input",
 CellID->10574],
Cell[9807, 366, 225, 7, 36, "Output",
 CellID->1876811659]
}, Open  ]],
Cell[10047, 376, 456, 14, 70, "Text",
 CellID->21884],
Cell[10506, 392, 241, 8, 70, "MathCaption",
 CellID->7668],
Cell[CellGroupData[{
Cell[10772, 404, 138, 4, 70, "Input",
 CellID->10468],
Cell[10913, 410, 175, 5, 50, "Output",
 CellID->1333745677]
}, Open  ]],
Cell[11103, 418, 165, 6, 70, "MathCaption",
 CellID->6204],
Cell[CellGroupData[{
Cell[11293, 428, 140, 4, 70, "Input",
 CellID->31844],
Cell[11436, 434, 347, 10, 66, "Output",
 CellID->829285953]
}, Open  ]],
Cell[11798, 447, 187, 6, 70, "MathCaption",
 CellID->14960],
Cell[CellGroupData[{
Cell[12010, 457, 184, 5, 70, "Input",
 CellID->31911],
Cell[12197, 464, 201, 6, 36, "Output",
 CellID->640143041]
}, Open  ]],
Cell[12413, 473, 1573, 46, 70, "DefinitionBox",
 CellID->19951],
Cell[13989, 521, 67, 1, 70, "Caption",
 CellID->26700],
Cell[14059, 524, 160, 5, 70, "MathCaption",
 CellID->10342],
Cell[14222, 531, 105, 3, 70, "Input",
 CellID->630],
Cell[14330, 536, 139, 5, 70, "MathCaption",
 CellID->3425],
Cell[CellGroupData[{
Cell[14494, 545, 107, 3, 70, "Input",
 CellID->10430],
Cell[14604, 550, 222, 7, 36, "Output",
 CellID->2138502264]
}, Open  ]],
Cell[14841, 560, 133, 5, 70, "MathCaption",
 CellID->17720],
Cell[CellGroupData[{
Cell[14999, 569, 113, 4, 70, "Input",
 CellID->10198],
Cell[15115, 575, 206, 7, 36, "Output",
 CellID->1521234856]
}, Open  ]],
Cell[15336, 585, 158, 5, 70, "MathCaption",
 CellID->31480],
Cell[15497, 592, 108, 3, 70, "Input",
 CellID->24405],
Cell[15608, 597, 138, 5, 70, "MathCaption",
 CellID->21382],
Cell[CellGroupData[{
Cell[15771, 606, 107, 3, 70, "Input",
 CellID->12425],
Cell[15881, 611, 177, 6, 36, "Output",
 CellID->1601407257]
}, Open  ]],
Cell[16073, 620, 634, 19, 70, "DefinitionBox",
 CellID->16612],
Cell[16710, 641, 76, 1, 70, "Caption",
 CellID->3192],
Cell[16789, 644, 682, 21, 70, "Text",
 CellID->4009],
Cell[CellGroupData[{
Cell[17496, 669, 70, 1, 70, "RelatedTutorialsSection",
 CellID->2986311],
Cell[17569, 672, 200, 5, 70, "RelatedTutorials",
 CellID->405226890]
}, Open  ]]
}, Open  ]],
Cell[17796, 681, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

