(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15769,        522]
NotebookOptionsPosition[     11035,        386]
NotebookOutlinePosition[     14076,        459]
CellTagsIndexPosition[     13982,        453]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files and External Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FilesAndExternalOperationsOverview"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Files and External Operations\"\>", 
       2->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       4->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Install" :> Documentation`HelpLookup["paclet:ref/Install"], 
          "Uninstall" :> Documentation`HelpLookup["paclet:ref/Uninstall"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Install\"\>", 
       2->"\<\"Uninstall\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["MathLink",
 FontSlant->"Italic"]], "Title",
 CellTags->{"S1.11.11", "11.1"},
 CellID->4813],

Cell["\<\
In many cases, you will find it convenient to communicate with external \
programs at a high level, and to exchange structured data with them. \
\>", "Text",
 CellID->1183],

Cell[TextData[{
 "On almost all computer systems, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " communication standard, which allows higher\[Hyphen]level communication \
between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and external programs. In order to use ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ", an external program has to include some special source code and a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library, which are usually distributed with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->10391],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " allows external programs both to call ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and to be called by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". \"",
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
 "\" discusses some of the details of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". By using ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ", you can, for example, treat ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " essentially like a subroutine embedded inside an external program. Or you \
can create a front end that implements your own user interface, and \
communicates with the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel via ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->148],

Cell[TextData[{
 "You can also use ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " to let ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " call individual functions inside an external program. As described in \"",
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
 "\", you can set up a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template file to specify how particular functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " should call functions inside your external program. From the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template file, you can generate source code to include in your program. \
Then when you start your program, the appropriate ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " definitions are automatically made, and when you call a particular ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function, code in your external program is executed. "
}], "Text",
 CellID->23646],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Install",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Install"], "[", "\"\<\!\(\*
StyleBox[\"command\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "start an external program and install ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " definitions to call functions it contains"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Uninstall",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Uninstall"], "[", 
     StyleBox["link", "TI"], "]"}], Cell["\<\
terminate an external program and uninstall definitions for functions in it\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20333],

Cell["Calling functions in external programs. ", "Caption",
 CellID->3559],

Cell[TextData[{
 "This starts the external program ",
 Cell[BoxData["simul"], "InlineFormula"],
 ", and installs ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " definitions to call various functions in it. "
}], "MathCaption",
 CellID->19127],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Install", "[", "\"\<simul\>\"", "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->11773],

Cell["LinkObject[simul, 5, 4]", "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28601]
}, Open  ]],

Cell[TextData[{
 "Here is a usage message for a function that was installed in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to call a function in the external program. "
}], "MathCaption",
 CellID->32207],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "srun"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->22495],

Cell["\<\
srun[{a, r, gamma}, x] performs a simulation with the
   specified parameters.\
\>", "Print",
 CellID->552]
}, Open  ]],

Cell["\<\
When you call this function, it executes code in the external program. \
\>", "MathCaption",
 CellID->18835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"srun", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "7"}], "}"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->4460],

Cell["6.78124", "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->19652]
}, Open  ]],

Cell[TextData[{
 "This terminates the ",
 Cell[BoxData["simul"], "InlineFormula"],
 " program. "
}], "MathCaption",
 CellID->23171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Uninstall", "[", "\"\<simul\>\"", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->18595],

Cell["simul", "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->29720]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " to communicate with many types of programs, including with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " itself. There are versions of the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library for a variety of common programming languages. The ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " system provides a standard way to integrate ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with Java, based on ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". With ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " you can take any Java class, and immediately make its methods accessible \
as functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->7273],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->14651286],

Cell[TextData[ButtonBox["Files and External Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FilesAndExternalOperationsOverview"]], "RelatedTutorials",
 CellID->16088632],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "RelatedTutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "RelatedTutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "RelatedTutorials",
 CellID->441486358]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathLink - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Files and External Operations", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/FilesAndExternalOperationsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/RunningExternalPrograms"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 23.6488124}", "context" -> "", 
    "keywords" -> {
     "external functions", "install", "Java", "JLink", "MathLink", "Python", 
      "Uninstall"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "In many cases, you will find it convenient to communicate with external \
programs at a high level, and to exchange structured data with them. On \
almost all computer systems, Mathematica supports the MathLink communication \
standard, which allows higher-level communication between Mathematica and \
external programs. In order to use MathLink, an external program has to \
include some special source code and a MathLink library, which are usually \
distributed with Mathematica. MathLink allows external programs both to call \
Mathematica, and to be called by Mathematica. \"MathLink and External Program \
Communication\" discusses some of the details of MathLink. By using MathLink, \
you can, for example, treat Mathematica essentially like a subroutine \
embedded inside an external program. Or you can create a front end that \
implements your own user interface, and communicates with the Mathematica \
kernel via MathLink. ", "synonyms" -> {"1.11.11"}, "title" -> "MathLink", 
    "type" -> "Tutorial", "uri" -> "tutorial/MathLink"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.11.11"->{
  Cell[2594, 71, 115, 3, 70, "Title",
   CellTags->{"S1.11.11", "11.1"},
   CellID->4813]},
 "11.1"->{
  Cell[2594, 71, 115, 3, 70, "Title",
   CellTags->{"S1.11.11", "11.1"},
   CellID->4813]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.11.11", 13764, 442},
 {"11.1", 13867, 446}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1969, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2594, 71, 115, 3, 70, "Title",
 CellTags->{"S1.11.11", "11.1"},
 CellID->4813],
Cell[2712, 76, 182, 4, 70, "Text",
 CellID->1183],
Cell[2897, 82, 646, 22, 70, "Text",
 CellID->10391],
Cell[3546, 106, 1110, 38, 70, "Text",
 CellID->148],
Cell[4659, 146, 1223, 35, 70, "Text",
 CellID->23646],
Cell[5885, 183, 963, 28, 70, "DefinitionBox",
 CellID->20333],
Cell[6851, 213, 74, 1, 70, "Caption",
 CellID->3559],
Cell[6928, 216, 249, 8, 70, "MathCaption",
 CellID->19127],
Cell[CellGroupData[{
Cell[7202, 228, 112, 3, 28, "Input",
 CellID->11773],
Cell[7317, 233, 168, 5, 36, "Output",
 CellID->28601]
}, Open  ]],
Cell[7500, 241, 214, 6, 70, "MathCaption",
 CellID->32207],
Cell[CellGroupData[{
Cell[7739, 251, 87, 3, 70, "Input",
 CellID->22495],
Cell[7829, 256, 117, 4, 70, "Print",
 CellID->552]
}, Open  ]],
Cell[7961, 263, 118, 3, 70, "MathCaption",
 CellID->18835],
Cell[CellGroupData[{
Cell[8104, 270, 178, 6, 70, "Input",
 CellID->4460],
Cell[8285, 278, 151, 5, 36, "Output",
 CellID->19652]
}, Open  ]],
Cell[8451, 286, 131, 5, 70, "MathCaption",
 CellID->23171],
Cell[CellGroupData[{
Cell[8607, 295, 114, 3, 70, "Input",
 CellID->18595],
Cell[8724, 300, 149, 5, 36, "Output",
 CellID->29720]
}, Open  ]],
Cell[8888, 308, 793, 28, 70, "Text",
 CellID->7273],
Cell[CellGroupData[{
Cell[9706, 340, 71, 1, 70, "RelatedTutorialsSection",
 CellID->14651286],
Cell[9780, 343, 187, 4, 70, "RelatedTutorials",
 CellID->16088632],
Cell[9970, 349, 338, 9, 70, "RelatedTutorials",
 CellID->403767969],
Cell[10311, 360, 334, 9, 70, "RelatedTutorials",
 CellID->309869466],
Cell[10648, 371, 333, 9, 70, "RelatedTutorials",
 CellID->441486358]
}, Open  ]]
}, Open  ]],
Cell[11008, 384, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

