(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    108094,       3398]
NotebookOptionsPosition[     61312,       2028]
NotebookOutlinePosition[     90976,       2852]
CellTagsIndexPosition[     90482,       2833]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       2->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C Language Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkCLanguageFunctions"],
           "MathLink Connection Management" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkConnectionManagement"], 
          "MathLink C Functions for Exchanging Data" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingData"], 
          "MathLink C Functions for Exchanging Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingExpressions"], 
          "MathLink C Functions for Exchanging Integers" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingIntegers"], 
          "MathLink C Functions for Exchanging Multidimensional Arrays" :> 
          Documentation`HelpLookup[
           "paclet:guide/\
MathLinkCFunctionsForExchangingMultidimensionalArrays"], 
          "MathLink C Functions for Exchanging Reals" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingReals"], 
          "MathLink C Functions for Exchanging Strings" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingStrings"], 
          "MathLink C Functions for Exchanging Symbols" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingSymbols"], 
          "MathLink Expression Packet Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkExpressionPacketHandling"], 
          "MathLink Packets" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkPackets"], 
          "Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MathLink C Language Functions\"\>", 
       2->"\<\"MathLink Connection Management\"\>", 
       3->"\<\"MathLink C Functions for Exchanging Data\"\>", 
       4->"\<\"MathLink C Functions for Exchanging Expressions\"\>", 
       5->"\<\"MathLink C Functions for Exchanging Integers\"\>", 
       6->"\<\"MathLink C Functions for Exchanging Multidimensional \
Arrays\"\>", 7->"\<\"MathLink C Functions for Exchanging Reals\"\>", 
       8->"\<\"MathLink C Functions for Exchanging Strings\"\>", 
       9->"\<\"MathLink C Functions for Exchanging Symbols\"\>", 
       10->"\<\"MathLink Expression Packet Handling\"\>", 
       11->"\<\"MathLink Packets\"\>", 
       12->"\<\"Alphabetical Listing of MathLink C Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Development in C (Mac OS X)"
}], "Title",
 CellTags->"MacIntroduction",
 CellID->4305],

Cell[TextData[{
 "This document describes how to compile and run ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs written in the C language on Mac OS X systems.",
 " ",
 "(\"",
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication\"",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
 " describes how to write ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs in both the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language and the C language.)"
}], "Text",
 CellTags->"MacIntroduction",
 CellID->21111],

Cell[TextData[{
 "This document does not teach you, in general, how to use your compiler and \
other development tools, nor does it teach you how to program in C. If you \
have any trouble building or running your ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs, see the troubleshooting ",
 ButtonBox["section",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh#23791"],
 " at the end of this document."
}], "Text",
 CellTags->"MacIntroduction",
 CellID->5281],

Cell[TextData[{
 "Most of what is described in this document is Unix specific and is \
applicable to all supported Unix platforms. However, there may be some \
information which is specific to Mac OS X machines. To learn how to compile \
and run ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs for another platform, see the Developer Guide for that platform."
}], "Text",
 CellTags->"MacIntroduction",
 CellID->11650],

Cell[CellGroupData[{

Cell["Supported Development Platforms", "Section",
 CellID->1716103401],

Cell[TextData[{
 "The mathlink.framework shared library in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " developer kit for Mac OS X can be used for Mac OS X 10.3.9 and newer and \
Xcode 1.1 and newer",
 ". ",
 "The framework includes universal binary support for the 32-bit PPC, 32-bit \
x86, and 64-bit x86 architectures."
}], "Text",
 CellID->114230375]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Installing the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Components"
}], "Section",
 CellTags->"MacInstalling",
 CellID->30231],

Cell[TextData[{
 "The ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Developer Kit is located in the ",
 StyleBox["$InstallationDirectory/SystemFiles/Links/MathLink/DeveloperKit/\
MacOSX", "InlineCode"],
 " directory within your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " directory."
}], "Text",
 CellTags->"MacInstalling",
 CellID->12135],

Cell[CellGroupData[{

Cell["Recommended Installation", "Subsection",
 CellTags->"MacInstalling",
 CellID->15632],

Cell[CellGroupData[{

Cell["CompilerAdditions Installation", "Subsubsection",
 CellTags->"MacInstalling",
 CellID->19582],

Cell[TextData[{
 "The ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " components that you will need to build ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs have already been installed in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " bundle. One way to use these components is to leave them in the ",
 StyleBox["Mathematica.app", "InlineCode"],
 " directory and specify their full path name when you call your compiler. \
This approach is taken in the example \[OpenCurlyDoubleQuote]makefiles\
\[CloseCurlyDoubleQuote] in the section \"",
 ButtonBox["Building ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh#13362"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh#13362"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh#13362"],
 "\"."
}], "Text",
 CellTags->"MacInstalling",
 CellID->1382],

Cell[TextData[{
 "An alternative is to copy these components (\[OpenCurlyDoubleQuote]",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"mathlink", ".", "h"}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/mathlink.h"]], "InlineFormula"],
 "\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]",
 StyleBox["libMLi3.a", "InlineCode"],
 "\[CloseCurlyDoubleQuote], and \[OpenCurlyDoubleQuote]",
 StyleBox["mathlink.framework", "InlineCode"],
 "\[CloseCurlyDoubleQuote]) into directories in which your compiler will \
automatically search for such files. These directories are commonly \
\[OpenCurlyDoubleQuote]",
 StyleBox["/usr/include", "InlineCode"],
 "\[CloseCurlyDoubleQuote] or \[OpenCurlyDoubleQuote]",
 StyleBox["/usr/lib", "InlineCode"],
 "\[CloseCurlyDoubleQuote]",
 StyleBox[" ", "InlineCode"],
 "for the \[OpenCurlyDoubleQuote]",
 StyleBox["libMLi3.a", "InlineCode"],
 "\[CloseCurlyDoubleQuote] and ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"mathlink", ".", "h"}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/mathlink.h"]], "InlineFormula"],
 " and ",
 StyleBox["/Library/Frameworks", "InlineCode"],
 " or ",
 StyleBox["~/Library/Frameworks", "InlineCode"],
 " for \[OpenCurlyDoubleQuote]",
 StyleBox["mathlink.framework", "InlineCode"],
 "\[CloseCurlyDoubleQuote]. On many systems not all users have write access \
to these directories."
}], "Text",
 CellTags->"MacInstalling",
 CellID->13250]
}, Open  ]],

Cell[CellGroupData[{

Cell["MathLinkExamples Installation", "Subsubsection",
 CellTags->"MacInstalling",
 CellID->12644],

Cell[TextData[{
 "Copy the \[OpenCurlyDoubleQuote]",
 StyleBox["MathLinkExamples", "InlineCode"],
 "\[CloseCurlyDoubleQuote] directory to your home directory."
}], "Text",
 CellTags->"MacInstalling",
 CellID->8852]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Framework Components"
}], "Subsection",
 CellTags->{"parts", "MacInstalling"},
 CellID->17457],

Cell[TextData[{
 "The following is a description of each file or directory in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Developer's Kit (MLDK)."
}], "Text",
 CellTags->{"parts", "MacInstalling"},
 CellID->9601],

Cell[CellGroupData[{

Cell["CompilerAdditions Directory", "Subsubsection",
 CellTags->{"parts", "MacInstalling"},
 CellID->32268],

Cell[CellGroupData[{

Cell["mathlink.h", "Subsubsubsection",
 CellTags->{"parts", "mathlink.h", "MacInstalling"},
 CellID->21033],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox[
   RowBox[{"mathlink", ".", "h"}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/mathlink.h"]], "InlineFormula"],
 " is the header file that must be included in your C and C++ source files. \
It should be placed where your compiler can find it. You could copy this \
header file into the same directory as your source files,",
 " ",
 "copy it into the same location as the standard header files, or leave it \
where it is if you added the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " directory to the search path for header files."
}], "Text",
 CellTags->{"parts", "mathlink.h", "MacInstalling"},
 CellID->773]
}, Open  ]],

Cell[CellGroupData[{

Cell["libMLi3.a", "Subsubsubsection",
 CellTags->{"parts", "MathLinkLibraries", "MacInstalling"},
 CellID->21894],

Cell[TextData[{
 StyleBox["libMLi3.a", "InlineCode"],
 " is the static library that contains all of the ",
 StyleBox["MathLink ",
  FontSlant->"Italic"],
 "functions. It should be included in your project. You could copy this \
library into the same directory as your source files or leave it where it is \
if you added the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " directory to the search path for libraries."
}], "Text",
 CellTags->{"parts", "MathLinkLibraries", "MacInstalling"},
 CellID->10419]
}, Open  ]],

Cell[CellGroupData[{

Cell["mathlink.framework", "Subsubsubsection",
 CellID->269385689],

Cell[TextData[{
 StyleBox["mathlink.framework", "InlineCode"],
 " is the dynamic library framework that contains all the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " functions",
 ". ",
 "Use the framework when you want to build a version of your program that \
links dynamically with the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library. You could copy this library in the same directory as your source \
files or leave it where it is if you added the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " directory to the framework search paths."
}], "Text",
 CellID->669747147]
}, Open  ]],

Cell[CellGroupData[{

Cell["mprep", "Subsubsubsection",
 CellTags->{"parts", "mprep", "MacInstalling"},
 CellID->8526],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["mprep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mprep"]], "InlineFormula"],
 " is an application that writes ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs automatically by processing \[OpenCurlyDoubleQuote]template\
\[CloseCurlyDoubleQuote] files",
 ". ",
 "It may be convenient to copy this application into the same directory as \
your project or to create an alias to it."
}], "Text",
 CellTags->{"parts", "mprep", "MacInstalling"},
 CellID->10883],

Cell[TextData[StyleBox["mcc", "Subsubsubsection"]], "Text",
 CellTags->{"parts", "mcc", "MacInstalling"},
 CellID->6533],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["mcc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mcc"]], "InlineFormula"],
 " is a script that preprocesses and compiles your ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " source files."
}], "Text",
 CellTags->{"parts", "mcc", "MacInstalling"},
 CellID->16782],

Cell[TextData[StyleBox["AlternativeLibraries/libMLi3.a", \
"Subsubsubsection"]], "Text",
 CellID->1272394934],

Cell[TextData[{
 "In ",
 StyleBox["$InstallationDirectory/SystemFiles/Links/MathLink/DeveloperKit/\
MacOSX/CompilerAdditions/AlternativeLibraries", "InlineCode", "InlineCode"],
 ", the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " developer kit contains a version of \[OpenCurlyDoubleQuote]",
 StyleBox["libMLi3.a", "InlineCode"],
 "\[CloseCurlyDoubleQuote] that was compiled on a Mac OS X 10.4.x system. The \
byte size of the C ",
 StyleBox["long double", "InlineCode"],
 " type changed between Mac OS X 10.3.9 and 10.4.0. If you are building on a \
10.4.x system use the \[OpenCurlyDoubleQuote]",
 StyleBox["libMLi3.a", "InlineCode"],
 "\[CloseCurlyDoubleQuote] in the ",
 StyleBox["AlternativeLibraries", "InlineCode"],
 " directory. If you need a \[OpenCurlyDoubleQuote]",
 StyleBox["mathlink.framework", "InlineCode"],
 "\[CloseCurlyDoubleQuote] that has been updated for 10.4.x, use the \
\[OpenCurlyDoubleQuote]",
 StyleBox["mathlink.framework", "InlineCode"],
 "\[CloseCurlyDoubleQuote] found in ",
 StyleBox["$InstallationDirectory/SystemFiles/Links/MathLink/DeveloperKit/\
MacOSX-x86-64/CompilerAdditions", "InlineCode", "InlineCode"],
 ". This \[OpenCurlyDoubleQuote]",
 StyleBox["mathlink.framework", "InlineCode"],
 "\[CloseCurlyDoubleQuote] contains a Tiger built Universal version of the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " framework suitable for running on MacOS X 10.4.x for PPC, PPC64, x86-64, \
and I386 architectures."
}], "Text",
 CellID->712054077]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MathLinkExamples Directory", "Subsubsection",
 CellTags->{"parts", "MacInstalling"},
 CellID->27512],

Cell[TextData[{
 "This directory contains the source code for some very simple ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs",
 ". ",
 "By using this source code, you can learn how to build and run ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs without having to write any code yourself."
}], "Text",
 CellTags->{"parts", "MacInstalling"},
 CellID->17436]
}, Open  ]],

Cell[CellGroupData[{

Cell["PrebuiltExamples Directory", "Subsubsection",
 CellTags->{"parts", "prebuilt", "MacInstalling"},
 CellID->16825],

Cell[TextData[{
 "This directory contains prebuilt versions of the example programs. The ",
 ButtonBox["following section",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh#2922"],
 " describes how to run two of these programs",
 ". ",
 "The ",
 ButtonBox["section after that",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh#13362"],
 " describes how to build them yourself using the source code in the \
\[OpenCurlyDoubleQuote]",
 StyleBox["MathLinkExamples", "InlineCode"],
 "\[CloseCurlyDoubleQuote] directory."
}], "Text",
 CellTags->{"parts", "prebuilt", "MacInstalling"},
 CellID->21052]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Building ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Programs"
}], "Section",
 CellTags->"MacBuilding",
 CellID->13362],

Cell[TextData[{
 "The general procedure for building ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs is to include ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"mathlink", ".", "h"}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/mathlink.h"]], "InlineFormula"],
 " in any C or C++ source files that make ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " function calls, to compile your source files, and then to link the \
resulting object code with the \[OpenCurlyDoubleQuote]",
 StyleBox["libMLi3.a", "InlineCode"],
 "\[CloseCurlyDoubleQuote] library or \[OpenCurlyDoubleQuote]",
 StyleBox["mathlink.framework", "InlineCode"],
 "\[CloseCurlyDoubleQuote] and any other standard libraries required by your \
application. If your application uses the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template mechanism, then your template files must first be processed into \
a C source file using ",
 Cell[BoxData[
  ButtonBox["mprep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mprep"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"MacBuilding",
 CellID->5606],

Cell[CellGroupData[{

Cell[TextData[{
 "Using ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Template Files"
}], "Subsection",
 CellTags->{"mprep", "MacBuilding"},
 CellID->3666],

Cell[TextData[{
 "If your program uses the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template mechanism as described in \"",
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
 "\", you must simultaneously preprocess source files containing template \
entries using the ",
 Cell[BoxData[
  ButtonBox["mprep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mprep"]], "InlineFormula"],
 " application. (A template entry is a sequence of lines that contain \
template keywords. Each entry defines a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function that when evaluated calls an associated C function.)",
 " ",
 "When ",
 Cell[BoxData[
  ButtonBox["mprep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mprep"]], "InlineFormula"],
 " processes such source files, it converts template entries into C \
functions, without changing other text, and writes out additional C functions \
that implement a remote procedure call mechanism using ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". The result is a C source file that is ready for compilation."
}], "Text",
 CellTags->{"mprep", "MacBuilding"},
 CellID->21735],

Cell["For example, the command", "Text",
 CellTags->{"mprep", "MacBuilding"},
 CellID->6219],

Cell[TextData[{
 StyleBox[ButtonBox["mprep",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mprep"], "MR"],
 StyleBox[" addtwo.tm -o addtwotm.c", "MR"]
}], "Program",
 CellTags->{"mprep", "MacBuilding"},
 CellID->21671],

Cell[TextData[{
 "will produce a C source file \[OpenCurlyDoubleQuote]",
 StyleBox["addtwotm.c", "InlineCode"],
 "\[CloseCurlyDoubleQuote] from the template entries and the other text \
remaining in \[OpenCurlyDoubleQuote]",
 StyleBox["addtwo.tm", "InlineCode"],
 "\[CloseCurlyDoubleQuote]. You would then compile the output file using the \
C compiler",
 ". ",
 "If you use the \[OpenCurlyDoubleQuote]",
 StyleBox["make", "InlineCode"],
 "\[CloseCurlyDoubleQuote] utility to build your program, you could add a \
rule similar to the following to your makefile."
}], "Text",
 CellTags->{"mprep", "MacBuilding"},
 CellID->26664],

Cell[TextData[StyleBox["addtwotm.c  :  addtwo.tm\n    mprep  addtwo.tm  -o \
addtwotm.c", "MR"]], "Program",
 CellTags->{"mprep", "MacBuilding"},
 CellID->32599]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Building ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs from the Command Line"
}], "Subsection",
 CellTags->"MacBuilding",
 CellID->608],

Cell[TextData[{
 "What follows is a sample makefile needed to build the sample programs in \
the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Developer's Kit, including \[OpenCurlyDoubleQuote]",
 StyleBox["addtwo", "InlineCode"],
 "\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]",
 StyleBox["factor", "InlineCode"],
 "\[CloseCurlyDoubleQuote]",
 ". ",
 "To build a sample program, in this case \[OpenCurlyDoubleQuote]",
 StyleBox["addtwo", "InlineCode"],
 "\[CloseCurlyDoubleQuote], evaluate the following command in the ",
 StyleBox["MathLinkExamples", "InlineCode"],
 " directory."
}], "Text",
 CellTags->"MacBuilding",
 CellID->9847],

Cell[TextData[StyleBox["make addtwo", "MR"]], "Program",
 CellTags->"MacBuilding",
 CellID->24014],

Cell[CellGroupData[{

Cell["Using a Makefile", "Subsubsection",
 CellTags->"MacBuilding",
 CellID->2914],

Cell[TextData[{
 StyleBox["# This makefile can be used to build all or some of the sample\n# \
programs", "MR"],
 ". ",
 StyleBox["To build all of them, use the command\n# 'make all'", "MR"],
 ". ",
 StyleBox["To build one, say addtwo, use the command\n# 'make addtwo'.\n\n\
MLINKDIR = \
/Applications/Mathematica.app/SystemFiles/Links/MathLink/DeveloperKit\nSYS = \
MacOSX\nCADDSDIR = ${MLINKDIR}/${SYS}/CompilerAdditions\n\nINCDIR = \
${CADDSDIR}\nLIBDIR = ${CADDSDIR}\n\nMPREP = ${CADDSDIR}/mprep\n\nall : \
addtwo bitops counter factor factor2 factor3 quotient reverse sumalist\n\n\
addtwo : addtwotm.o addtwo.o\n\t${CC} -I${INCDIR} addtwotm.o addtwo.o \
-L${LIBDIR} -lMLi3 -o $@\n\nbitops : bitopstm.o bitops.o\n\t${CC} -I${INCDIR} \
bitopstm.o bitops.o -L${LIBDIR} -lMLi3 -o $@\n\ncounter : countertm.o\n\t\
${CC} -I${INCDIR} countertm.o -L${LIBDIR} -lMLi3 -o $@\n\nfactor : factor.o\n\
\t${CC} -I${INCDIR} factor.o -L${LIBDIR} -lMLi3 -o $@\n\nfactor2 : factor2.o\n\
\t${CC} -I${INCDIR} factor2.o -L${LIBDIR} -lMLi3 -o $@\n\nfactor3 : factor3.o\
\n\t${CC} -I${INCDIR} factor3.o -L${LIBDIR} -lMLi3 -o $@\n\nquotient : \
quotient.o\n\t${CC} -I${INCDIR} quotient.o -L${LIBDIR} -lMLi3 -o $@\n\n\
reverse : reversetm.o\n\t${CC} -I${INCDIR} reversetm.o -L${LIBDIR} -lMLi3 -o \
$@\n\nsumalist : sumalisttm.o sumalist.o\n\t${CC} -I${INCDIR} sumalisttm.o \
sumalist.o -L${LIBDIR} -lMLi3 -o $@\n\n.c.o :\n\t${CC} -c -I${INCDIR} $<\n\n\
addtwotm.c : addtwo.tm\n\t${MPREP} $? -o $@\n\nbitopstm.c : bitops.tm\n\t\
${MPREP} $? -o $@\n\ncountertm.c : counter.tm\n\t${MPREP} $? -o $@\n\n\
reversetm.c : reverse.tm\n\t${MPREP} $? -o $@\n\nsumalisttm.c : sumalist.tm\n\
\t${MPREP} $? -o $@", "MR"]
}], "Program",
 CellTags->"MacBuilding",
 CellID->3212]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Building Mac OS X ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs with Xcode"
}], "Subsection",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->7507],

Cell[CellGroupData[{

Cell["Creating a project", "Subsubsection",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->22622],

Cell["\<\
To create a project that can be used to edit, build, and debug \
\[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote]:\
\>", "Text",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->8327],

Cell["Start Xcode.", "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->22492],

Cell[TextData[{
 "From the ",
 StyleBox["File", "MenuName"],
 " menu, choose ",
 StyleBox["New Project", "MenuName"],
 "."
}], "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->20320],

Cell["The New Project dialog box appears.", "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->26999],

Cell["\<\
In the New Project box, select Standard Tool and then click Next.\
\>", "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->19898],

Cell["The New Standard Tool dialog box appears.", "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->11271],

Cell["Create the Project.", "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->18386],

Cell[TextData[{
 "In the New Standard Tool dialog box, enter addtwo as the project name, and \
hit the tab key. The default location for your project will be ",
 StyleBox["~/addtwo/", "InlineCode"],
 ". This is a directory in your home directory called addtwo (e.g. ",
 StyleBox["/Users/<", "InlineCode"],
 StyleBox["login name", "TI"],
 StyleBox[">/addtwo", "InlineCode"],
 "). Later steps assume that you use this default directory. Click Finish."
}], "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->2192],

Cell["Copy the source files to the project directory.", "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->8552],

Cell[CellGroupData[{

Cell[TextData[{
 "Start the Terminal application and change the directory (cd) to where ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Plain"],
 "was installed",
 ". ",
 "When you reach that directory, cd to ",
 StyleBox["$InstallationDirectory/Mathematica.app/SystemFiles/Links/MathLink/\
DeveloperKit/MacOSX/MathLinkExamples", "InlineCode"],
 "."
}], "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->16217],

Cell["\<\
cd \"/Applications/Mathematica.app/SystemFiles/Links/MathLink/DeveloperKit/\
MacOSX/MathLinkExamples\"\
\>", "Program",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->32524]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Copy the addtwo source files to your project directory that you chose in \
step 4 using the copy (",
 StyleBox["cp", "InlineCode"],
 ") command."
}], "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->14988],

Cell[TextData[StyleBox["cp addtwo.tm addtwo.c ~/addtwo/", "InlineCode"]], \
"Program",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->693]
}, Open  ]],

Cell[TextData[{
 "Run ",
 Cell[BoxData[
  ButtonBox["mprep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mprep"]], "InlineFormula"],
 " on the template file."
}], "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->15089],

Cell[CellGroupData[{

Cell["Change directory to the project directory.", "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->7688],

Cell[TextData[StyleBox["cd ~/addtwo/", "InlineCode"]], "Program",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->22414]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["mprep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mprep"]], "InlineFormula"],
 " to generate a source file."
}], "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->12296],

Cell[TextData[{
 StyleBox["/Applications/", "InlineCode"],
 StyleBox["Mathematica", "InlineCode",
  FontSlant->"Plain"],
 StyleBox[".app/SystemFiles/Links/", "InlineCode"],
 StyleBox["MathLink", "InlineCode",
  FontSlant->"Plain"],
 StyleBox["/DeveloperKit/MacOSX/CompilerAdditions/mprep addtwo.tm -o \
addtwo.tm.c", "InlineCode"]
}], "Program",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->20268]
}, Open  ]],

Cell["Add files to the project.", "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->25358],

Cell["\<\
In the \[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote] project window \
under the \[OpenCurlyDoubleQuote]Groups & Files\[CloseCurlyDoubleQuote] pane \
click the triangle next to the \[OpenCurlyDoubleQuote]addtwo\
\[CloseCurlyDoubleQuote] entry.\
\>", "BulletedText",
 CellID->690457637],

Cell["\<\
Right-click on the \[OpenCurlyDoubleQuote]Source\[CloseCurlyDoubleQuote] \
entry.\
\>", "BulletedText",
 CellID->1667360318],

Cell[TextData[{
 "Select ",
 StyleBox["Add \[FilledRightTriangle] Existing Files", "MenuName"],
 "."
}], "BulletedText",
 CellID->810754923],

Cell["\<\
From the drop-down menu click on <user name> directory and then click on the \
addtwo directory, select \[OpenCurlyDoubleQuote]addtwo.c\
\[CloseCurlyDoubleQuote], and click \[OpenCurlyDoubleQuote]Add.\
\[CloseCurlyDoubleQuote]\
\>", "BulletedText",
 CellID->574250646],

Cell["\<\
In the next drop-down menu be sure that the program \
\[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote] box is checked in the \
\[OpenCurlyDoubleQuote]Add To Targets\[CloseCurlyDoubleQuote] section and \
click \[OpenCurlyDoubleQuote]Add.\[CloseCurlyDoubleQuote]\
\>", "BulletedText",
 CellID->639097704],

Cell["Right-click on the \"Source\" entry.", "BulletedText",
 CellID->840817090],

Cell[TextData[{
 "Select ",
 StyleBox["Add \[FilledRightTriangle] Existing Files", "MenuName"],
 "."
}], "BulletedText",
 CellID->1170434370],

Cell["\<\
From the drop-down menu click on <user name> directory and then click on teh \
addtwo directory, select \[OpenCurlyDoubleQuote]addtwo.tm.c\
\[CloseCurlyDoubleQuote], and click \[OpenCurlyDoubleQuote]Add.\
\[CloseCurlyDoubleQuote]\
\>", "BulletedText",
 CellID->540250070],

Cell["\<\
In the next drop-down menu be sure that the program \
\[OpenCurlyDoubleQuote]addtwo\[CloseCurlyDoubleQuote] box is checked in the \
\[OpenCurlyDoubleQuote]Add To Targets\[CloseCurlyDoubleQuote] section and \
click \[OpenCurlyDoubleQuote]Add.\[CloseCurlyDoubleQuote]\
\>", "BulletedText",
 CellID->422066974],

Cell[TextData[{
 "Click the Finder icon in the Dock to make the Finder active",
 ". ",
 "Go to the folder where ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is installed."
}], "BulletedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->10797],

Cell[TextData[{
 "Click on the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " icon while pressing the Control key. A pop-up menu will appear. Select \
Show Package Contents to view the contents of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". ",
 "Open the folders ",
 StyleBox["SystemFiles/Links/MathLink/DeveloperKit/MacOSX/CompilerAdditions", 
  "InlineCode"],
 StyleBox[".",
  FontFamily->"Lucida Grande"]
}], "BulletedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->30825],

Cell[TextData[{
 "Drag the file ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"mathlink", ".", "h"}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/mathlink.h"]], "InlineFormula"],
 " from the Finder window to the Source group to the Groups & Files list in \
Xcode",
 ". ",
 "Make sure that Copy items into destination folder is not checked and click \
the Add button."
}], "BulletedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->29647],

Cell[TextData[{
 "Drag the file ",
 "libMLi3",
 StyleBox[".a", "InlineCode"],
 " from the Finder window to the Source group to the Groups & Files list in \
Xcode. Make sure that Copy items into destination folder is not checked and \
click the Add button."
}], "BulletedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->28221],

Cell["Remove main.c from the project.", "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->7237],

Cell["\<\
Right-click on the file main.c and select \[OpenCurlyDoubleQuote]Delete.\
\[CloseCurlyDoubleQuote] In the drop-down menu click the \
\[OpenCurlyDoubleQuote]Delete References & Files\[CloseCurlyDoubleQuote] \
button.\
\>", "ItemizedTextParagraph",
 CellID->541145977],

Cell["Build the project.", "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->29907],

Cell["From the Build menu, select Build.", "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->3670]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Creating a project for \[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote]\
\>", "Subsubsection",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->4549],

Cell["\<\
To create a project that can be used to edit, build, and debug \
\[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote]:\
\>", "Text",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->12546],

Cell["Start Xcode.", "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->19039],

Cell[TextData[{
 "From the ",
 StyleBox["File", "MenuName"],
 " menu, choose ",
 StyleBox["New Project", "MenuName"],
 "."
}], "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->32252],

Cell["The New Project dialog box appears.", "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->30012],

Cell["\<\
In the New Project box, select Standard Tool and then click Next.\
\>", "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->26020],

Cell["The New Standard Tool dialog box appears.", "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->11431],

Cell["Create the Project.", "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->32476],

Cell[TextData[{
 "In the New Standard Tool dialog, enter factor as the project name and hit \
the tab key. The default location for your project will be ",
 StyleBox["~/factor/", "InlineCode"],
 ". This is a directory in your home directory called factor (e.g. ",
 StyleBox["/Users/<", "InlineCode"],
 StyleBox["login name", "TI"],
 StyleBox[">/factor", "InlineCode"],
 "). Later steps assume that you use this default directory."
}], "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->691],

Cell["Click Finish.", "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->30525],

Cell["Copy the source files to the project directory.", "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->2845],

Cell[CellGroupData[{

Cell[TextData[{
 "Start the Terminal application and change the directory (cd) to where ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "was installed",
 ". ",
 "When you reach that directory, cd to ",
 StyleBox["Mathematica.app/SystemFiles/Links/MathLink/DeveloperKit/MacOSX/\
MathLinkExamples", "InlineCode"],
 "."
}], "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->26099],

Cell[TextData[{
 StyleBox["cd ", "InlineCode"],
 "/Applications/Mathematica.app/SystemFiles/Links/MathLink/DeveloperKit/\
MacOSX/MathLinkExamples"
}], "Program",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->4416]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Copy the factor source files to your project directory that you chose in \
step 4 using the copy (",
 StyleBox["cp", "InlineCode"],
 ") command."
}], "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->7774],

Cell[TextData[{
 StyleBox["cp ", "InlineCode"],
 "factor",
 StyleBox[".c ~/", "InlineCode"],
 "factor",
 StyleBox["/", "InlineCode"]
}], "Program", "InlineCode",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->17056]
}, Open  ]],

Cell["Change directory to the project directory.", "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->18677],

Cell["Add files to the project.", "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->6872],

Cell["\<\
In the \[OpenCurlyDoubleQuote]factor\[CloseCurlyDoubleQuote] project window \
under the \[OpenCurlyDoubleQuote]Groups & Files\[CloseCurlyDoubleQuote] pane \
click the triangle next to the \[OpenCurlyDoubleQuote]factor\
\[CloseCurlyDoubleQuote] entry.\
\>", "BulletedText",
 CellID->447190394],

Cell["\<\
Right-click on the \[OpenCurlyDoubleQuote]Source\[CloseCurlyDoubleQuote] \
entry.\
\>", "BulletedText",
 CellID->1883671105],

Cell[TextData[{
 "Select ",
 StyleBox["Add \[FilledRightTriangle] Existing Files", "MenuName"],
 "."
}], "BulletedText",
 CellID->656337661],

Cell["\<\
From the drop-down menu click on <user name> directory and then click on the \
addtwo directory, select \[OpenCurlyDoubleQuote]factor.c\
\[CloseCurlyDoubleQuote], and click \[OpenCurlyDoubleQuote]Add.\
\[CloseCurlyDoubleQuote]\
\>", "BulletedText",
 CellID->1591057435],

Cell[TextData[{
 "Click the Finder icon in the Dock to make the Finder active",
 ". ",
 "Go to the folder where ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is installed."
}], "BulletedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->6896],

Cell[TextData[{
 "Click on the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " icon while pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key. A pop-up menu will appear. Select ",
 StyleBox["Show Package Contents", "MenuName"],
 " to view the contents of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Open the folders ",
 StyleBox["SystemFiles/Links/", "InlineCode"],
 StyleBox["MathLink", "InlineCode",
  FontSlant->"Plain"],
 StyleBox["/DeveloperKit/MacOSX/CompilerAdditions", "InlineCode"],
 StyleBox[".",
  FontFamily->"Lucida Grande"]
}], "BulletedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->30309],

Cell[TextData[{
 "Drag the file ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"mathlink", ".", "h"}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/mathlink.h"]], "InlineFormula"],
 " from the Finder window to the Source group to the Groups & Files list in \
Xcode. Make sure that Copy items into destinations folder is not checked and \
click the Add button."
}], "BulletedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->15132],

Cell[TextData[{
 "Drag the file ",
 StyleBox["libMLi3.a", "InlineCode"],
 " from the Finder window to the Source group to the Groups & Files list in \
Xcode. Make sure that Copy items into destinations folder is not checked and \
click the Add button."
}], "BulletedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->32358],

Cell["Remove main.c from the project.", "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->31788],

Cell["\<\
Right-click on the file main.c and select \[OpenCurlyDoubleQuote]Delete.\
\[CloseCurlyDoubleQuote] In the drop-down menu click the \
\[OpenCurlyDoubleQuote]Delete References & Files\[CloseCurlyDoubleQuote] \
button.\
\>", "ItemizedTextParagraph",
 CellID->435937601],

Cell["Build the project.", "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->4],

Cell["From the Build menu, select Build.", "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->8930]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using mcc", "Subsection",
 CellTags->{"mcc", "MacBuilding"},
 CellID->16727],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["mcc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mcc"]], "InlineFormula"],
 " is a script that preprocesses and compiles your ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " source files. It will preprocess ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " templates in any file whose name ends with .tm, and then call \
\[OpenCurlyDoubleQuote]",
 StyleBox["cc", "InlineCode"],
 "\[CloseCurlyDoubleQuote] on the resulting C source code. ",
 Cell[BoxData[
  ButtonBox["mcc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mcc"]], "InlineFormula"],
 " will pass command-line options and other files directly to \
\[OpenCurlyDoubleQuote]",
 StyleBox["cc", "InlineCode"],
 "\[CloseCurlyDoubleQuote]",
 ". ",
 "Following is a command that would build the \[OpenCurlyDoubleQuote]",
 StyleBox["addtwo", "InlineCode"],
 "\[CloseCurlyDoubleQuote] application using ",
 Cell[BoxData[
  ButtonBox["mcc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mcc"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->{"mcc", "MacBuilding"},
 CellID->27649],

Cell[TextData[{
 StyleBox[ButtonBox["mcc",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mcc"], "MR"],
 StyleBox[" addtwo.tm addtwo.c -o addtwo", "MR"]
}], "Program",
 CellTags->{"mcc", "MacBuilding"},
 CellID->18519]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Running ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Programs"
}], "Section",
 CellTags->"MacRunning",
 CellID->2922],

Cell[TextData[{
 "The instructions in the next section describe how to build two ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs using source code in the \[OpenCurlyDoubleQuote]",
 StyleBox["MathLinkExamples", "InlineCode"],
 "\[CloseCurlyDoubleQuote] directory. These two programs, \
\[OpenCurlyDoubleQuote]",
 StyleBox["addtwo", "InlineCode"],
 "\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]",
 StyleBox["factor", "InlineCode"],
 "\[CloseCurlyDoubleQuote], are already built for you in the \
\[OpenCurlyDoubleQuote]",
 StyleBox["PrebuiltExamples", "InlineCode"],
 "\[CloseCurlyDoubleQuote] folder. Before building them on your own, you \
should try to run the prebuilt examples to verify that the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " system additions are installed and working and to learn what to expect \
from these examples when they are properly built",
 ". ",
 "The rest of the comments assume that you are using the programs found in \
the Developer Kit."
}], "Text",
 CellTags->"MacRunning",
 CellID->11707],

Cell[CellGroupData[{

Cell[TextData[{
 "Running a Prebuilt Example from the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Kernel"
}], "Subsection",
 CellTags->{"addtwo", "MacRunning"},
 CellID->23529],

Cell[TextData[{
 "The first example program, \[OpenCurlyDoubleQuote]",
 StyleBox["addtwo", "InlineCode"],
 "\[CloseCurlyDoubleQuote], is a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template program that is installed into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". That is, this program runs in the background, providing, as a service to \
",
 StyleBox["Mathematica,",
  FontSlant->"Italic"],
 " one or more externally compiled functions. To the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " user, these functions appear to be built-in. In order to get this new \
functionality, the user of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " must run the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"], "InlineFormula"]], "InlineFormula"],
 StyleBox["[]", "InlineFormula"],
 " function. The \[OpenCurlyDoubleQuote]",
 StyleBox["addtwo", "InlineCode"],
 "\[CloseCurlyDoubleQuote] program uses a template file that defines the ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "function ",
 StyleBox["AddTwo[]", "InlineFormula", "InlineCode"],
 " as a call to the C function ",
 StyleBox["addtwo()", "InlineCode"],
 ". (The template mechanism is described in \"",
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
 "\".)",
 " ",
 "The source code for this program looks likes this."
}], "Text",
 CellTags->{"addtwo", "MacRunning"},
 CellID->9266],

Cell[TextData[StyleBox[":Begin:\n:Function:       addtwo\n:Pattern:        \
AddTwo[i_Integer, j_Integer]\n:Arguments:      { i, j }\n:ArgumentTypes:  { \
Integer, Integer }\n:ReturnType:     Integer\n:End:\n\n:Evaluate: \
AddTwo::usage = \"AddTwo[x, y] gives the sum of two machine integers x and y.\
\"\n\nint addtwo( int i, int j)\n{\n\treturn i+j;\n}\n\nint main(int argc; \
char* argv[])\n{\n\treturn MLMain(argc, argv);\n}", "MR"]], "Program",
 CellTags->{"addtwo", "MacRunning"},
 CellID->23627],

Cell["Evaluate the following two cells:", "MathCaption",
 CellTags->{"addtwo", "MacRunning"},
 CellID->9425],

Cell[BoxData[
 RowBox[{"SetDirectory", "[", 
  RowBox[{
  "$InstallationDirectory", "<>", 
   "\"\</SystemFiles/Links/MathLink/DeveloperKit/PrebuiltExamples\>\""}], 
  "]"}]], "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->19900],

Cell[BoxData[
 RowBox[{"link", " ", "=", " ", 
  RowBox[{"Install", "[", "\"\<./addtwo\>\"", "]"}]}]], "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->3248],

Cell["\<\
To see a list of the newly available functions, evaluate the following cell:\
\>", "MathCaption",
 CellTags->{"addtwo", "MacRunning"},
 CellID->7975],

Cell[BoxData[
 RowBox[{"LinkPatterns", "[", "link", "]"}]], "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->17530],

Cell[TextData[{
 "This displays the usage message for the ",
 StyleBox["AddTwo[]", "InlineFormula"],
 " function as defined in the file \[OpenCurlyDoubleQuote]",
 StyleBox["addtwo.tm", "InlineCode"],
 "\[CloseCurlyDoubleQuote]:"
}], "MathCaption",
 CellTags->{"addtwo", "MacRunning"},
 CellID->7757],

Cell[BoxData[
 RowBox[{"?", "AddTwo"}]], "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->21413],

Cell["Now try it:", "MathCaption",
 CellTags->{"addtwo", "MacRunning"},
 CellID->19096],

Cell[BoxData[
 RowBox[{"AddTwo", "[", 
  RowBox[{"2", ",", " ", "3"}], "]"}]], "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->17016],

Cell[TextData[{
 "See what happens if the sum of the two machine integers won't fit in a \
machine integer or if either argument is not a machine integer (",
 StyleBox["2^31-1", "InlineFormula"],
 " is the largest machine integer. If your compiler uses 2-byte ints, then ",
 StyleBox["2^15-1", "InlineFormula"],
 " is the largest C ",
 StyleBox["int", "InlineCode"],
 "):"
}], "MathCaption",
 CellID->702020527],

Cell[BoxData[
 RowBox[{
  RowBox[{"AddTwo", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "^", "31"}], "-", "1"}], ",", " ", "1"}], "]"}], 
  "   "}]], "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->26905],

Cell[TextData[{
 "The \[OpenCurlyDoubleQuote]",
 StyleBox["addtwo", "InlineCode"],
 "\[CloseCurlyDoubleQuote] program is not prepared for big integers:"
}], "MathCaption",
 CellID->583840671],

Cell[BoxData[
 RowBox[{
  RowBox[{"AddTwo", "[", 
   RowBox[{
    RowBox[{"2", "^", "31"}], ",", " ", "1"}], "]"}], "          "}]], "Input",\

 CellTags->{"addtwo", "MacRunning"},
 CellID->31807],

Cell[TextData[{
 "This does not match ",
 StyleBox["AddTwo[_Integer, _Integer]", "InlineFormula"],
 ":"
}], "MathCaption",
 CellID->757374354],

Cell[BoxData[
 RowBox[{
  RowBox[{"AddTwo", "[", 
   RowBox[{"x", ",", " ", "1"}], "]"}], "                   "}]], "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->27703],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"], "[", "]"}]], "InlineFormula"],
 " called ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkOpen"], "[", "]"}]], "InlineFormula"],
 " and then exchanged information with the external program to set up the \
definition for ",
 StyleBox["AddTwo[]", "InlineFormula"],
 ". ",
 "You really don't have to worry about these details, but if you are curious, \
evaluate:"
}], "MathCaption",
 CellTags->{"addtwo", "MacRunning"},
 CellID->4452],

Cell[BoxData[
 RowBox[{"??", "AddTwo"}]], "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->22255],

Cell["When you are finished using the external program, evaluate:", \
"MathCaption",
 CellTags->{"addtwo", "MacRunning"},
 CellID->14684],

Cell[BoxData[
 RowBox[{"Uninstall", "[", "link", "]"}]], "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->8535]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Invoking the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Kernel from Within a Prebuilt Example"
}], "Subsection",
 CellTags->{"factor", "MacRunning"},
 CellID->594],

Cell[TextData[{
 "The second example program, \[OpenCurlyDoubleQuote]",
 StyleBox["factor", "InlineCode"],
 "\[CloseCurlyDoubleQuote], is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end in the sense that the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel runs in the background providing, as a service to \
\[OpenCurlyDoubleQuote]",
 StyleBox["factor", "InlineCode"],
 "\[CloseCurlyDoubleQuote], the computational services of the kernel\
\[LongDash]in this case, the ability to factor an integer typed by the user",
 ". ",
 "These examples assume that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is installed in the Applications directory."
}], "Text",
 CellTags->{"factor", "MacRunning"},
 CellID->146],

Cell[TextData[{
 "Launch the \[OpenCurlyDoubleQuote]",
 StyleBox["factor", "InlineCode"],
 "\[CloseCurlyDoubleQuote] application by executing the following command."
}], "Text",
 CellTags->{"factor", "MacRunning"},
 CellID->7790],

Cell[TextData[StyleBox["factor -linkmode launch -linkname \
'\"/Applications/Mathematica.app/Contents/MacOS/MathKernel\" -mathlink'", \
"MR"]], "Program",
 CellTags->{"factor", "MacRunning"},
 CellID->18036],

Cell[TextData[{
 "After a moment, a prompt will appear requesting that you type an integer. \
Type an integer with fewer than 10 digits and press the ",
 StyleBox["Return", "KeyEvent"],
 " key. (The other factor examples relax the restriction on the size of \
integer you may type in.)"
}], "Text",
 CellTags->{"factor", "MacRunning"},
 CellID->10047],

Cell[TextData[StyleBox["Integer to factor:", "MR"]], "Program",
 CellTags->{"factor", "MacRunning"},
 CellID->8505],

Cell[TextData[{
 "The prime factors returned by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are printed, and \[OpenCurlyDoubleQuote]",
 StyleBox["factor", "InlineCode"],
 "\[CloseCurlyDoubleQuote] closes its link with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->{"factor", "MacRunning"},
 CellID->10607],

Cell[TextData[StyleBox["Integer to factor: 123456789\n3 ^ 2\n3607 ^ 1\n3803 ^ \
1", "MR"]], "Program",
 CellTags->{"factor", "MacRunning"},
 CellID->3278]
}, Open  ]],

Cell[CellGroupData[{

Cell["Supported Link Protocols", "Subsection",
 CellTags->{"protocols", "MacRunning"},
 CellID->4958],

Cell[TextData[{
 "The C function ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"MLOpenArgcArgv", 
    RowBox[{"(", ")"}]}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/MLOpenArgcArgv"]], "InlineFormula"],
 " and the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkOpen"], "[", "]"}]], "InlineFormula"],
 " are documented in \"",
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
 "\". On Macintosh OS X machines, the legal values for the ",
 Cell[BoxData[
  ButtonBox["LinkProtocol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkProtocol"]], "InlineFormula"],
 " option are \"",
 StyleBox["TCPIP", "InlineCode"],
 "\", \"",
 StyleBox["TCP", "InlineCode"],
 "\", \"",
 StyleBox["SharedMemory", "InlineCode"],
 "\", and \"",
 StyleBox["Pipes", "InlineCode"],
 "\". A ",
 Cell[BoxData[
  ButtonBox["LinkProtocol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkProtocol"]], "InlineFormula"],
 " is the mechanism used to transport data from one end of a connection to \
the other. \"",
 StyleBox["Pipes", "InlineCode"],
 "\" is the default protocol for ",
 Cell[BoxData[
  RowBox[{"LinkMode", "->", "Launch"}]], "InlineFormula"],
 " links",
 ". ",
 "\"",
 StyleBox["SharedMemory", "InlineCode"],
 "\" is the default for ",
 Cell[BoxData[
  RowBox[{"LinkMode", "->", "Listen"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"LinkMode", "->", "Connect"}]], "InlineFormula"],
 " links."
}], "Text",
 CellTags->{"protocols", "MacRunning"},
 CellID->16281],

Cell[TextData[{
 "Note that link names are unsigned 16-bit integers for the \"",
 StyleBox["TCPIP", "InlineCode"],
 "\" and \"",
 StyleBox["TCP", "InlineCode"],
 "\" protocols. Even though \"",
 StyleBox["TCPIP", "InlineCode"],
 "\" link names are integers, they are still given as strings (of digits) to \
",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"MLOpenArgcArgv", 
    RowBox[{"(", ")"}]}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/MLOpenArgcArgv"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkOpen"], "[", "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellTags->{"protocols", "MacRunning"},
 CellID->17746]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Troubleshooting", "Section",
 CellTags->"MacTroubleshooting",
 CellID->23791],

Cell["\<\
Turn off compiler optimization until your program is working. This makes \
compiling faster, debugging easier, and, besides, the optimizer may be broken \
and the cause of some problems. (Optimized code uses the stack and registers \
differently than unoptimized code in such a way that may expose or mask a bug \
in your code. For example, the common mistake of returning a pointer to a \
local variable may or may not cause a problem depending on stack and register \
use.)\
\>", "BulletedText",
 CellTags->"MacTroubleshooting",
 CellID->27576],

Cell[TextData[{
 "Check the return values from the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library functions or call ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"MLError", 
    RowBox[{"(", ")"}]}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/MLError"]], "InlineFormula"],
 " at key points in your program",
 ". ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " will often be able to tell you what has gone wrong."
}], "BulletedText",
 CellTags->"MacTroubleshooting",
 CellID->16924],

Cell[TextData[{
 "The files \[OpenCurlyDoubleQuote]",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"mathlink", ".", "h"}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/mathlink.h"]], "InlineFormula"],
 "\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]libMLi3.a\
\[CloseCurlyDoubleQuote] are a matched set. If you have used an earlier \
release of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ", you should take care that you don't mix components when building your \
application."
}], "BulletedText",
 CellTags->"MacTroubleshooting",
 CellID->10657],

Cell[TextData[{
 "Check whether the C compiler you are using supports prototypes. If it does \
not, you will need to change your code and the way you build your project",
 ". ",
 "This is explained in the section \"",
 ButtonBox["Building ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh#13362"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh#13362"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh#13362"],
 "\"."
}], "BulletedText",
 CellTags->"MacTroubleshooting",
 CellID->6708],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->211133989],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Language Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"]
}], "TutorialMoreAbout",
 CellID->558589989],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkConnectionManagement"],
  FontSlant->"Italic"],
 ButtonBox[" Connection Management",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkConnectionManagement"]
}], "TutorialMoreAbout",
 CellID->40858578],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Data",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"]
}], "TutorialMoreAbout",
 CellID->8146795],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"]
}], "TutorialMoreAbout",
 CellID->424932163],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingIntegers"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Integers",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingIntegers"]
}], "TutorialMoreAbout",
 CellID->2262398],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:guide/MathLinkCFunctionsForExchangingMultidimensionalArrays"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Multidimensional Arrays",
  BaseStyle->"Link",
  ButtonData->
   "paclet:guide/MathLinkCFunctionsForExchangingMultidimensionalArrays"]
}], "TutorialMoreAbout",
 CellID->101684538],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingReals"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Reals",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingReals"]
}], "TutorialMoreAbout",
 CellID->655130],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingStrings"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Strings",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingStrings"]
}], "TutorialMoreAbout",
 CellID->148916145],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingSymbols"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Symbols",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingSymbols"]
}], "TutorialMoreAbout",
 CellID->182367630],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkExpressionPacketHandling"],
  FontSlant->"Italic"],
 ButtonBox[" Expression Packet Handling",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkExpressionPacketHandling"]
}], "TutorialMoreAbout",
 CellID->113882963],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkPackets"],
  FontSlant->"Italic"],
 ButtonBox[" Packets",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkPackets"]
}], "TutorialMoreAbout",
 CellID->5094559],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "TutorialMoreAbout",
 CellID->246479563]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->26530286],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "RelatedTutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "RelatedTutorials",
 CellID->441486358]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathLink Development in C (Mac OS X) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 21.7425136}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "This document describes how to compile and run MathLink programs written \
in the C language on Mac OS X systems. (\"MathLink and External Program \
Communication\" describes how to write MathLink programs in both the \
Mathematica language and the C language.) This document does not teach you, \
in general, how to use your compiler and other development tools, nor does it \
teach you how to program in C. If you have any trouble building or running \
your MathLink programs, see the troubleshooting section at the end of this \
document. Most of what is described in this document is Unix specific and is \
applicable to all supported Unix platforms. However, there may be some \
information which is specific to Mac OS X machines. To learn how to compile \
and run MathLink programs for another platform, see the Developer Guide for \
that platform.", "synonyms" -> {}, "title" -> 
    "MathLink Development in C Mac OS X", "type" -> "Tutorial", "uri" -> 
    "tutorial/MathLinkDeveloperGuide-Macintosh"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "MacIntroduction"->{
  Cell[4581, 108, 151, 6, 70, "Title",
   CellTags->"MacIntroduction",
   CellID->4305],
  Cell[4735, 116, 753, 25, 70, "Text",
   CellTags->"MacIntroduction",
   CellID->21111],
  Cell[5491, 143, 508, 13, 70, "Text",
   CellTags->"MacIntroduction",
   CellID->5281],
  Cell[6002, 158, 430, 10, 70, "Text",
   CellTags->"MacIntroduction",
   CellID->11650]},
 "MacInstalling"->{
  Cell[6933, 190, 155, 7, 70, "Section",
   CellTags->"MacInstalling",
   CellID->30231],
  Cell[7091, 199, 356, 13, 70, "Text",
   CellTags->"MacInstalling",
   CellID->12135],
  Cell[7472, 216, 90, 2, 70, "Subsection",
   CellTags->"MacInstalling",
   CellID->15632],
  Cell[7587, 222, 99, 2, 70, "Subsubsection",
   CellTags->"MacInstalling",
   CellID->19582],
  Cell[7689, 226, 1016, 28, 70, "Text",
   CellTags->"MacInstalling",
   CellID->1382],
  Cell[8708, 256, 1409, 37, 70, "Text",
   CellTags->"MacInstalling",
   CellID->13250],
  Cell[10154, 298, 98, 2, 70, "Subsubsection",
   CellTags->"MacInstalling",
   CellID->12644],
  Cell[10255, 302, 214, 6, 70, "Text",
   CellTags->"MacInstalling",
   CellID->8852],
  Cell[10518, 314, 159, 6, 70, "Subsection",
   CellTags->{"parts", "MacInstalling"},
   CellID->17457],
  Cell[10680, 322, 224, 7, 70, "Text",
   CellTags->{"parts", "MacInstalling"},
   CellID->9601],
  Cell[10929, 333, 107, 2, 70, "Subsubsection",
   CellTags->{"parts", "MacInstalling"},
   CellID->32268],
  Cell[11061, 339, 107, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "mathlink.h", "MacInstalling"},
   CellID->21033],
  Cell[11171, 343, 669, 17, 70, "Text",
   CellTags->{"parts", "mathlink.h", "MacInstalling"},
   CellID->773],
  Cell[11877, 365, 113, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "MathLinkLibraries", "MacInstalling"},
   CellID->21894],
  Cell[11993, 369, 508, 13, 70, "Text",
   CellTags->{"parts", "MathLinkLibraries", "MacInstalling"},
   CellID->10419],
  Cell[13239, 412, 96, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "mprep", "MacInstalling"},
   CellID->8526],
  Cell[13338, 416, 527, 15, 70, "Text",
   CellTags->{"parts", "mprep", "MacInstalling"},
   CellID->10883],
  Cell[13868, 433, 120, 2, 70, "Text",
   CellTags->{"parts", "mcc", "MacInstalling"},
   CellID->6533],
  Cell[13991, 437, 324, 11, 70, "Text",
   CellTags->{"parts", "mcc", "MacInstalling"},
   CellID->16782],
  Cell[15972, 493, 106, 2, 70, "Subsubsection",
   CellTags->{"parts", "MacInstalling"},
   CellID->27512],
  Cell[16081, 497, 384, 12, 70, "Text",
   CellTags->{"parts", "MacInstalling"},
   CellID->17436],
  Cell[16502, 514, 118, 2, 70, "Subsubsection",
   CellTags->{"parts", "prebuilt", "MacInstalling"},
   CellID->16825],
  Cell[16623, 518, 667, 17, 70, "Text",
   CellTags->{"parts", "prebuilt", "MacInstalling"},
   CellID->21052]},
 "parts"->{
  Cell[10518, 314, 159, 6, 70, "Subsection",
   CellTags->{"parts", "MacInstalling"},
   CellID->17457],
  Cell[10680, 322, 224, 7, 70, "Text",
   CellTags->{"parts", "MacInstalling"},
   CellID->9601],
  Cell[10929, 333, 107, 2, 70, "Subsubsection",
   CellTags->{"parts", "MacInstalling"},
   CellID->32268],
  Cell[11061, 339, 107, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "mathlink.h", "MacInstalling"},
   CellID->21033],
  Cell[11171, 343, 669, 17, 70, "Text",
   CellTags->{"parts", "mathlink.h", "MacInstalling"},
   CellID->773],
  Cell[11877, 365, 113, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "MathLinkLibraries", "MacInstalling"},
   CellID->21894],
  Cell[11993, 369, 508, 13, 70, "Text",
   CellTags->{"parts", "MathLinkLibraries", "MacInstalling"},
   CellID->10419],
  Cell[13239, 412, 96, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "mprep", "MacInstalling"},
   CellID->8526],
  Cell[13338, 416, 527, 15, 70, "Text",
   CellTags->{"parts", "mprep", "MacInstalling"},
   CellID->10883],
  Cell[13868, 433, 120, 2, 70, "Text",
   CellTags->{"parts", "mcc", "MacInstalling"},
   CellID->6533],
  Cell[13991, 437, 324, 11, 70, "Text",
   CellTags->{"parts", "mcc", "MacInstalling"},
   CellID->16782],
  Cell[15972, 493, 106, 2, 70, "Subsubsection",
   CellTags->{"parts", "MacInstalling"},
   CellID->27512],
  Cell[16081, 497, 384, 12, 70, "Text",
   CellTags->{"parts", "MacInstalling"},
   CellID->17436],
  Cell[16502, 514, 118, 2, 70, "Subsubsection",
   CellTags->{"parts", "prebuilt", "MacInstalling"},
   CellID->16825],
  Cell[16623, 518, 667, 17, 70, "Text",
   CellTags->{"parts", "prebuilt", "MacInstalling"},
   CellID->21052]},
 "mathlink.h"->{
  Cell[11061, 339, 107, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "mathlink.h", "MacInstalling"},
   CellID->21033],
  Cell[11171, 343, 669, 17, 70, "Text",
   CellTags->{"parts", "mathlink.h", "MacInstalling"},
   CellID->773]},
 "MathLinkLibraries"->{
  Cell[11877, 365, 113, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "MathLinkLibraries", "MacInstalling"},
   CellID->21894],
  Cell[11993, 369, 508, 13, 70, "Text",
   CellTags->{"parts", "MathLinkLibraries", "MacInstalling"},
   CellID->10419]},
 "mprep"->{
  Cell[13239, 412, 96, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "mprep", "MacInstalling"},
   CellID->8526],
  Cell[13338, 416, 527, 15, 70, "Text",
   CellTags->{"parts", "mprep", "MacInstalling"},
   CellID->10883],
  Cell[18626, 586, 161, 7, 70, "Subsection",
   CellTags->{"mprep", "MacBuilding"},
   CellID->3666],
  Cell[18790, 595, 1425, 39, 70, "Text",
   CellTags->{"mprep", "MacBuilding"},
   CellID->21735],
  Cell[20218, 636, 92, 2, 70, "Text",
   CellTags->{"mprep", "MacBuilding"},
   CellID->6219],
  Cell[20313, 640, 227, 7, 70, "Program",
   CellTags->{"mprep", "MacBuilding"},
   CellID->21671],
  Cell[20543, 649, 627, 15, 70, "Text",
   CellTags->{"mprep", "MacBuilding"},
   CellID->26664],
  Cell[21173, 666, 161, 3, 70, "Program",
   CellTags->{"mprep", "MacBuilding"},
   CellID->32599]},
 "mcc"->{
  Cell[13868, 433, 120, 2, 70, "Text",
   CellTags->{"parts", "mcc", "MacInstalling"},
   CellID->6533],
  Cell[13991, 437, 324, 11, 70, "Text",
   CellTags->{"parts", "mcc", "MacInstalling"},
   CellID->16782],
  Cell[39718, 1288, 82, 2, 70, "Subsection",
   CellTags->{"mcc", "MacBuilding"},
   CellID->16727],
  Cell[39803, 1292, 1117, 34, 70, "Text",
   CellTags->{"mcc", "MacBuilding"},
   CellID->27649],
  Cell[40923, 1328, 226, 7, 70, "Program",
   CellTags->{"mcc", "MacBuilding"},
   CellID->18519]},
 "prebuilt"->{
  Cell[16502, 514, 118, 2, 70, "Subsubsection",
   CellTags->{"parts", "prebuilt", "MacInstalling"},
   CellID->16825],
  Cell[16623, 518, 667, 17, 70, "Text",
   CellTags->{"parts", "prebuilt", "MacInstalling"},
   CellID->21052]},
 "MacBuilding"->{
  Cell[17351, 542, 145, 7, 70, "Section",
   CellTags->"MacBuilding",
   CellID->13362],
  Cell[17499, 551, 1102, 31, 70, "Text",
   CellTags->"MacBuilding",
   CellID->5606],
  Cell[18626, 586, 161, 7, 70, "Subsection",
   CellTags->{"mprep", "MacBuilding"},
   CellID->3666],
  Cell[18790, 595, 1425, 39, 70, "Text",
   CellTags->{"mprep", "MacBuilding"},
   CellID->21735],
  Cell[20218, 636, 92, 2, 70, "Text",
   CellTags->{"mprep", "MacBuilding"},
   CellID->6219],
  Cell[20313, 640, 227, 7, 70, "Program",
   CellTags->{"mprep", "MacBuilding"},
   CellID->21671],
  Cell[20543, 649, 627, 15, 70, "Text",
   CellTags->{"mprep", "MacBuilding"},
   CellID->26664],
  Cell[21173, 666, 161, 3, 70, "Program",
   CellTags->{"mprep", "MacBuilding"},
   CellID->32599],
  Cell[21371, 674, 168, 7, 70, "Subsection",
   CellTags->"MacBuilding",
   CellID->608],
  Cell[21542, 683, 649, 18, 70, "Text",
   CellTags->"MacBuilding",
   CellID->9847],
  Cell[22194, 703, 98, 2, 70, "Program",
   CellTags->"MacBuilding",
   CellID->24014],
  Cell[22317, 709, 82, 2, 70, "Subsubsection",
   CellTags->"MacBuilding",
   CellID->2914],
  Cell[22402, 713, 1741, 29, 70, "Program",
   CellTags->"MacBuilding",
   CellID->3212],
  Cell[24192, 748, 187, 7, 70, "Subsection",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->7507],
  Cell[24404, 759, 105, 2, 70, "Subsubsection",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->22622],
  Cell[24512, 763, 204, 5, 70, "Text",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->8327],
  Cell[24719, 770, 98, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->22492],
  Cell[24820, 774, 204, 8, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->20320],
  Cell[25027, 784, 130, 2, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->26999],
  Cell[25160, 788, 159, 4, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->19898],
  Cell[25322, 794, 136, 2, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->11271],
  Cell[25461, 798, 105, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->18386],
  Cell[25569, 802, 539, 11, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->2192],
  Cell[26111, 815, 132, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->8552],
  Cell[26268, 821, 473, 14, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->16217],
  Cell[26744, 837, 191, 5, 70, "Program",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->32524],
  Cell[26972, 847, 254, 7, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->14988],
  Cell[27229, 856, 146, 3, 70, "Program",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->693],
  Cell[27390, 862, 253, 9, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->15089],
  Cell[27668, 875, 136, 2, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->7688],
  Cell[27807, 879, 127, 2, 70, "Program",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->22414],
  Cell[27971, 886, 267, 9, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->12296],
  Cell[28241, 897, 407, 11, 70, "Program",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->20268],
  Cell[28663, 911, 111, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->25358],
  Cell[30794, 978, 263, 9, 70, "BulletedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->10797],
  Cell[31060, 989, 509, 16, 70, "BulletedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->30825],
  Cell[31572, 1007, 455, 14, 70, "BulletedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->29647],
  Cell[32030, 1023, 338, 9, 70, "BulletedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->28221],
  Cell[32371, 1034, 116, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->7237],
  Cell[32769, 1046, 104, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->29907],
  Cell[32876, 1050, 128, 2, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->3670],
  Cell[33041, 1057, 170, 4, 70, "Subsubsection",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->4549],
  Cell[33214, 1063, 205, 5, 70, "Text",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->12546],
  Cell[33422, 1070, 98, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->19039],
  Cell[33523, 1074, 204, 8, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->32252],
  Cell[33730, 1084, 130, 2, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->30012],
  Cell[33863, 1088, 159, 4, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->26020],
  Cell[34025, 1094, 136, 2, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->11431],
  Cell[34164, 1098, 105, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->32476],
  Cell[34272, 1102, 519, 11, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->691],
  Cell[34794, 1115, 108, 2, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->30525],
  Cell[34905, 1119, 132, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->2845],
  Cell[35062, 1125, 413, 12, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->26099],
  Cell[35478, 1139, 222, 6, 70, "Program",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->4416],
  Cell[35737, 1150, 253, 7, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->7774],
  Cell[35993, 1159, 223, 8, 70, "Program",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->17056],
  Cell[36231, 1170, 128, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->18677],
  Cell[36362, 1174, 110, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->6872],
  Cell[37342, 1207, 262, 9, 70, "BulletedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->6896],
  Cell[37607, 1218, 643, 20, 70, "BulletedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->30309],
  Cell[38253, 1240, 446, 12, 70, "BulletedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->15132],
  Cell[38702, 1254, 334, 8, 70, "BulletedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->32358],
  Cell[39039, 1264, 117, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->31788],
  Cell[39438, 1276, 100, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->4],
  Cell[39541, 1280, 128, 2, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->8930],
  Cell[39718, 1288, 82, 2, 70, "Subsection",
   CellTags->{"mcc", "MacBuilding"},
   CellID->16727],
  Cell[39803, 1292, 1117, 34, 70, "Text",
   CellTags->{"mcc", "MacBuilding"},
   CellID->27649],
  Cell[40923, 1328, 226, 7, 70, "Program",
   CellTags->{"mcc", "MacBuilding"},
   CellID->18519]},
 "ProjectBuilder"->{
  Cell[24192, 748, 187, 7, 70, "Subsection",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->7507],
  Cell[24404, 759, 105, 2, 70, "Subsubsection",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->22622],
  Cell[24512, 763, 204, 5, 70, "Text",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->8327],
  Cell[24719, 770, 98, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->22492],
  Cell[24820, 774, 204, 8, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->20320],
  Cell[25027, 784, 130, 2, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->26999],
  Cell[25160, 788, 159, 4, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->19898],
  Cell[25322, 794, 136, 2, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->11271],
  Cell[25461, 798, 105, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->18386],
  Cell[25569, 802, 539, 11, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->2192],
  Cell[26111, 815, 132, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->8552],
  Cell[26268, 821, 473, 14, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->16217],
  Cell[26744, 837, 191, 5, 70, "Program",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->32524],
  Cell[26972, 847, 254, 7, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->14988],
  Cell[27229, 856, 146, 3, 70, "Program",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->693],
  Cell[27390, 862, 253, 9, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->15089],
  Cell[27668, 875, 136, 2, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->7688],
  Cell[27807, 879, 127, 2, 70, "Program",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->22414],
  Cell[27971, 886, 267, 9, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->12296],
  Cell[28241, 897, 407, 11, 70, "Program",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->20268],
  Cell[28663, 911, 111, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->25358],
  Cell[30794, 978, 263, 9, 70, "BulletedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->10797],
  Cell[31060, 989, 509, 16, 70, "BulletedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->30825],
  Cell[31572, 1007, 455, 14, 70, "BulletedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->29647],
  Cell[32030, 1023, 338, 9, 70, "BulletedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->28221],
  Cell[32371, 1034, 116, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->7237],
  Cell[32769, 1046, 104, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->29907],
  Cell[32876, 1050, 128, 2, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->3670],
  Cell[33041, 1057, 170, 4, 70, "Subsubsection",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->4549],
  Cell[33214, 1063, 205, 5, 70, "Text",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->12546],
  Cell[33422, 1070, 98, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->19039],
  Cell[33523, 1074, 204, 8, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->32252],
  Cell[33730, 1084, 130, 2, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->30012],
  Cell[33863, 1088, 159, 4, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->26020],
  Cell[34025, 1094, 136, 2, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->11431],
  Cell[34164, 1098, 105, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->32476],
  Cell[34272, 1102, 519, 11, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->691],
  Cell[34794, 1115, 108, 2, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->30525],
  Cell[34905, 1119, 132, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->2845],
  Cell[35062, 1125, 413, 12, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->26099],
  Cell[35478, 1139, 222, 6, 70, "Program",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->4416],
  Cell[35737, 1150, 253, 7, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->7774],
  Cell[35993, 1159, 223, 8, 70, "Program",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->17056],
  Cell[36231, 1170, 128, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->18677],
  Cell[36362, 1174, 110, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->6872],
  Cell[37342, 1207, 262, 9, 70, "BulletedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->6896],
  Cell[37607, 1218, 643, 20, 70, "BulletedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->30309],
  Cell[38253, 1240, 446, 12, 70, "BulletedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->15132],
  Cell[38702, 1254, 334, 8, 70, "BulletedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->32358],
  Cell[39039, 1264, 117, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->31788],
  Cell[39438, 1276, 100, 2, 70, "ItemizedText",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->4],
  Cell[39541, 1280, 128, 2, 70, "ItemizedTextParagraph",
   CellTags->{"ProjectBuilder", "MacBuilding"},
   CellID->8930]},
 "MacRunning"->{
  Cell[41198, 1341, 142, 7, 70, "Section",
   CellTags->"MacRunning",
   CellID->2922],
  Cell[41343, 1350, 1051, 25, 70, "Text",
   CellTags->"MacRunning",
   CellID->11707],
  Cell[42419, 1379, 187, 7, 70, "Subsection",
   CellTags->{"addtwo", "MacRunning"},
   CellID->23529],
  Cell[42609, 1388, 1721, 51, 70, "Text",
   CellTags->{"addtwo", "MacRunning"},
   CellID->9266],
  Cell[44333, 1441, 502, 7, 70, "Program",
   CellTags->{"addtwo", "MacRunning"},
   CellID->23627],
  Cell[44838, 1450, 108, 2, 70, "MathCaption",
   CellTags->{"addtwo", "MacRunning"},
   CellID->9425],
  Cell[44949, 1454, 237, 7, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->19900],
  Cell[45189, 1463, 163, 4, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->3248],
  Cell[45355, 1469, 159, 4, 70, "MathCaption",
   CellTags->{"addtwo", "MacRunning"},
   CellID->7975],
  Cell[45517, 1475, 121, 3, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->17530],
  Cell[45641, 1480, 299, 8, 70, "MathCaption",
   CellTags->{"addtwo", "MacRunning"},
   CellID->7757],
  Cell[45943, 1490, 102, 3, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->21413],
  Cell[46048, 1495, 87, 2, 70, "MathCaption",
   CellTags->{"addtwo", "MacRunning"},
   CellID->19096],
  Cell[46138, 1499, 140, 4, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->17016],
  Cell[46695, 1517, 216, 8, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->26905],
  Cell[47108, 1534, 196, 7, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->31807],
  Cell[47452, 1550, 177, 5, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->27703],
  Cell[47632, 1557, 619, 20, 70, "MathCaption",
   CellTags->{"addtwo", "MacRunning"},
   CellID->4452],
  Cell[48254, 1579, 103, 3, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->22255],
  Cell[48360, 1584, 137, 3, 70, "MathCaption",
   CellTags->{"addtwo", "MacRunning"},
   CellID->14684],
  Cell[48500, 1589, 117, 3, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->8535],
  Cell[48654, 1597, 193, 7, 70, "Subsection",
   CellTags->{"factor", "MacRunning"},
   CellID->594],
  Cell[48850, 1606, 748, 21, 70, "Text",
   CellTags->{"factor", "MacRunning"},
   CellID->146],
  Cell[49601, 1629, 229, 6, 70, "Text",
   CellTags->{"factor", "MacRunning"},
   CellID->7790],
  Cell[49833, 1637, 207, 4, 70, "Program",
   CellTags->{"factor", "MacRunning"},
   CellID->18036],
  Cell[50043, 1643, 351, 8, 70, "Text",
   CellTags->{"factor", "MacRunning"},
   CellID->10047],
  Cell[50397, 1653, 115, 2, 70, "Program",
   CellTags->{"factor", "MacRunning"},
   CellID->8505],
  Cell[50515, 1657, 350, 12, 70, "Text",
   CellTags->{"factor", "MacRunning"},
   CellID->10607],
  Cell[50868, 1671, 154, 3, 70, "Program",
   CellTags->{"factor", "MacRunning"},
   CellID->3278],
  Cell[51059, 1679, 101, 2, 70, "Subsection",
   CellTags->{"protocols", "MacRunning"},
   CellID->4958],
  Cell[51163, 1683, 1868, 64, 70, "Text",
   CellTags->{"protocols", "MacRunning"},
   CellID->16281],
  Cell[53034, 1749, 709, 24, 70, "Text",
   CellTags->{"protocols", "MacRunning"},
   CellID->17746]},
 "addtwo"->{
  Cell[42419, 1379, 187, 7, 70, "Subsection",
   CellTags->{"addtwo", "MacRunning"},
   CellID->23529],
  Cell[42609, 1388, 1721, 51, 70, "Text",
   CellTags->{"addtwo", "MacRunning"},
   CellID->9266],
  Cell[44333, 1441, 502, 7, 70, "Program",
   CellTags->{"addtwo", "MacRunning"},
   CellID->23627],
  Cell[44838, 1450, 108, 2, 70, "MathCaption",
   CellTags->{"addtwo", "MacRunning"},
   CellID->9425],
  Cell[44949, 1454, 237, 7, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->19900],
  Cell[45189, 1463, 163, 4, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->3248],
  Cell[45355, 1469, 159, 4, 70, "MathCaption",
   CellTags->{"addtwo", "MacRunning"},
   CellID->7975],
  Cell[45517, 1475, 121, 3, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->17530],
  Cell[45641, 1480, 299, 8, 70, "MathCaption",
   CellTags->{"addtwo", "MacRunning"},
   CellID->7757],
  Cell[45943, 1490, 102, 3, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->21413],
  Cell[46048, 1495, 87, 2, 70, "MathCaption",
   CellTags->{"addtwo", "MacRunning"},
   CellID->19096],
  Cell[46138, 1499, 140, 4, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->17016],
  Cell[46695, 1517, 216, 8, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->26905],
  Cell[47108, 1534, 196, 7, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->31807],
  Cell[47452, 1550, 177, 5, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->27703],
  Cell[47632, 1557, 619, 20, 70, "MathCaption",
   CellTags->{"addtwo", "MacRunning"},
   CellID->4452],
  Cell[48254, 1579, 103, 3, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->22255],
  Cell[48360, 1584, 137, 3, 70, "MathCaption",
   CellTags->{"addtwo", "MacRunning"},
   CellID->14684],
  Cell[48500, 1589, 117, 3, 70, "Input",
   CellTags->{"addtwo", "MacRunning"},
   CellID->8535]},
 "factor"->{
  Cell[48654, 1597, 193, 7, 70, "Subsection",
   CellTags->{"factor", "MacRunning"},
   CellID->594],
  Cell[48850, 1606, 748, 21, 70, "Text",
   CellTags->{"factor", "MacRunning"},
   CellID->146],
  Cell[49601, 1629, 229, 6, 70, "Text",
   CellTags->{"factor", "MacRunning"},
   CellID->7790],
  Cell[49833, 1637, 207, 4, 70, "Program",
   CellTags->{"factor", "MacRunning"},
   CellID->18036],
  Cell[50043, 1643, 351, 8, 70, "Text",
   CellTags->{"factor", "MacRunning"},
   CellID->10047],
  Cell[50397, 1653, 115, 2, 70, "Program",
   CellTags->{"factor", "MacRunning"},
   CellID->8505],
  Cell[50515, 1657, 350, 12, 70, "Text",
   CellTags->{"factor", "MacRunning"},
   CellID->10607],
  Cell[50868, 1671, 154, 3, 70, "Program",
   CellTags->{"factor", "MacRunning"},
   CellID->3278]},
 "protocols"->{
  Cell[51059, 1679, 101, 2, 70, "Subsection",
   CellTags->{"protocols", "MacRunning"},
   CellID->4958],
  Cell[51163, 1683, 1868, 64, 70, "Text",
   CellTags->{"protocols", "MacRunning"},
   CellID->16281],
  Cell[53034, 1749, 709, 24, 70, "Text",
   CellTags->{"protocols", "MacRunning"},
   CellID->17746]},
 "MacTroubleshooting"->{
  Cell[53792, 1779, 83, 2, 70, "Section",
   CellTags->"MacTroubleshooting",
   CellID->23791],
  Cell[53878, 1783, 556, 10, 70, "BulletedText",
   CellTags->"MacTroubleshooting",
   CellID->27576],
  Cell[54437, 1795, 502, 18, 70, "BulletedText",
   CellTags->"MacTroubleshooting",
   CellID->16924],
  Cell[54942, 1815, 561, 16, 70, "BulletedText",
   CellTags->"MacTroubleshooting",
   CellID->10657],
  Cell[55506, 1833, 678, 18, 70, "BulletedText",
   CellTags->"MacTroubleshooting",
   CellID->6708]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"MacIntroduction", 63409, 2071},
 {"MacInstalling", 63788, 2084},
 {"parts", 66206, 2154},
 {"mathlink.h", 67904, 2200},
 {"MathLinkLibraries", 68166, 2207},
 {"mprep", 68432, 2214},
 {"mcc", 69264, 2239},
 {"prebuilt", 69790, 2255},
 {"MacBuilding", 70041, 2262},
 {"ProjectBuilder", 77609, 2467},
 {"MacRunning", 83658, 2624},
 {"addtwo", 86871, 2721},
 {"factor", 88803, 2779},
 {"protocols", 89614, 2804},
 {"MacTroubleshooting", 89951, 2814}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3956, 81, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4581, 108, 151, 6, 70, "Title",
 CellTags->"MacIntroduction",
 CellID->4305],
Cell[4735, 116, 753, 25, 70, "Text",
 CellTags->"MacIntroduction",
 CellID->21111],
Cell[5491, 143, 508, 13, 70, "Text",
 CellTags->"MacIntroduction",
 CellID->5281],
Cell[6002, 158, 430, 10, 70, "Text",
 CellTags->"MacIntroduction",
 CellID->11650],
Cell[CellGroupData[{
Cell[6457, 172, 71, 1, 70, "Section",
 CellID->1716103401],
Cell[6531, 175, 365, 10, 70, "Text",
 CellID->114230375]
}, Open  ]],
Cell[CellGroupData[{
Cell[6933, 190, 155, 7, 70, "Section",
 CellTags->"MacInstalling",
 CellID->30231],
Cell[7091, 199, 356, 13, 70, "Text",
 CellTags->"MacInstalling",
 CellID->12135],
Cell[CellGroupData[{
Cell[7472, 216, 90, 2, 70, "Subsection",
 CellTags->"MacInstalling",
 CellID->15632],
Cell[CellGroupData[{
Cell[7587, 222, 99, 2, 70, "Subsubsection",
 CellTags->"MacInstalling",
 CellID->19582],
Cell[7689, 226, 1016, 28, 70, "Text",
 CellTags->"MacInstalling",
 CellID->1382],
Cell[8708, 256, 1409, 37, 70, "Text",
 CellTags->"MacInstalling",
 CellID->13250]
}, Open  ]],
Cell[CellGroupData[{
Cell[10154, 298, 98, 2, 70, "Subsubsection",
 CellTags->"MacInstalling",
 CellID->12644],
Cell[10255, 302, 214, 6, 70, "Text",
 CellTags->"MacInstalling",
 CellID->8852]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10518, 314, 159, 6, 70, "Subsection",
 CellTags->{"parts", "MacInstalling"},
 CellID->17457],
Cell[10680, 322, 224, 7, 70, "Text",
 CellTags->{"parts", "MacInstalling"},
 CellID->9601],
Cell[CellGroupData[{
Cell[10929, 333, 107, 2, 70, "Subsubsection",
 CellTags->{"parts", "MacInstalling"},
 CellID->32268],
Cell[CellGroupData[{
Cell[11061, 339, 107, 2, 70, "Subsubsubsection",
 CellTags->{"parts", "mathlink.h", "MacInstalling"},
 CellID->21033],
Cell[11171, 343, 669, 17, 70, "Text",
 CellTags->{"parts", "mathlink.h", "MacInstalling"},
 CellID->773]
}, Open  ]],
Cell[CellGroupData[{
Cell[11877, 365, 113, 2, 70, "Subsubsubsection",
 CellTags->{"parts", "MathLinkLibraries", "MacInstalling"},
 CellID->21894],
Cell[11993, 369, 508, 13, 70, "Text",
 CellTags->{"parts", "MathLinkLibraries", "MacInstalling"},
 CellID->10419]
}, Open  ]],
Cell[CellGroupData[{
Cell[12538, 387, 66, 1, 70, "Subsubsubsection",
 CellID->269385689],
Cell[12607, 390, 595, 17, 70, "Text",
 CellID->669747147]
}, Open  ]],
Cell[CellGroupData[{
Cell[13239, 412, 96, 2, 70, "Subsubsubsection",
 CellTags->{"parts", "mprep", "MacInstalling"},
 CellID->8526],
Cell[13338, 416, 527, 15, 70, "Text",
 CellTags->{"parts", "mprep", "MacInstalling"},
 CellID->10883],
Cell[13868, 433, 120, 2, 70, "Text",
 CellTags->{"parts", "mcc", "MacInstalling"},
 CellID->6533],
Cell[13991, 437, 324, 11, 70, "Text",
 CellTags->{"parts", "mcc", "MacInstalling"},
 CellID->16782],
Cell[14318, 450, 109, 2, 70, "Text",
 CellID->1272394934],
Cell[14430, 454, 1493, 33, 70, "Text",
 CellID->712054077]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15972, 493, 106, 2, 70, "Subsubsection",
 CellTags->{"parts", "MacInstalling"},
 CellID->27512],
Cell[16081, 497, 384, 12, 70, "Text",
 CellTags->{"parts", "MacInstalling"},
 CellID->17436]
}, Open  ]],
Cell[CellGroupData[{
Cell[16502, 514, 118, 2, 70, "Subsubsection",
 CellTags->{"parts", "prebuilt", "MacInstalling"},
 CellID->16825],
Cell[16623, 518, 667, 17, 70, "Text",
 CellTags->{"parts", "prebuilt", "MacInstalling"},
 CellID->21052]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17351, 542, 145, 7, 70, "Section",
 CellTags->"MacBuilding",
 CellID->13362],
Cell[17499, 551, 1102, 31, 70, "Text",
 CellTags->"MacBuilding",
 CellID->5606],
Cell[CellGroupData[{
Cell[18626, 586, 161, 7, 70, "Subsection",
 CellTags->{"mprep", "MacBuilding"},
 CellID->3666],
Cell[18790, 595, 1425, 39, 70, "Text",
 CellTags->{"mprep", "MacBuilding"},
 CellID->21735],
Cell[20218, 636, 92, 2, 70, "Text",
 CellTags->{"mprep", "MacBuilding"},
 CellID->6219],
Cell[20313, 640, 227, 7, 70, "Program",
 CellTags->{"mprep", "MacBuilding"},
 CellID->21671],
Cell[20543, 649, 627, 15, 70, "Text",
 CellTags->{"mprep", "MacBuilding"},
 CellID->26664],
Cell[21173, 666, 161, 3, 70, "Program",
 CellTags->{"mprep", "MacBuilding"},
 CellID->32599]
}, Open  ]],
Cell[CellGroupData[{
Cell[21371, 674, 168, 7, 70, "Subsection",
 CellTags->"MacBuilding",
 CellID->608],
Cell[21542, 683, 649, 18, 70, "Text",
 CellTags->"MacBuilding",
 CellID->9847],
Cell[22194, 703, 98, 2, 70, "Program",
 CellTags->"MacBuilding",
 CellID->24014],
Cell[CellGroupData[{
Cell[22317, 709, 82, 2, 70, "Subsubsection",
 CellTags->"MacBuilding",
 CellID->2914],
Cell[22402, 713, 1741, 29, 70, "Program",
 CellTags->"MacBuilding",
 CellID->3212]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24192, 748, 187, 7, 70, "Subsection",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->7507],
Cell[CellGroupData[{
Cell[24404, 759, 105, 2, 70, "Subsubsection",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->22622],
Cell[24512, 763, 204, 5, 70, "Text",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->8327],
Cell[24719, 770, 98, 2, 70, "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->22492],
Cell[24820, 774, 204, 8, 70, "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->20320],
Cell[25027, 784, 130, 2, 70, "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->26999],
Cell[25160, 788, 159, 4, 70, "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->19898],
Cell[25322, 794, 136, 2, 70, "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->11271],
Cell[25461, 798, 105, 2, 70, "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->18386],
Cell[25569, 802, 539, 11, 70, "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->2192],
Cell[26111, 815, 132, 2, 70, "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->8552],
Cell[CellGroupData[{
Cell[26268, 821, 473, 14, 70, "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->16217],
Cell[26744, 837, 191, 5, 70, "Program",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->32524]
}, Open  ]],
Cell[CellGroupData[{
Cell[26972, 847, 254, 7, 70, "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->14988],
Cell[27229, 856, 146, 3, 70, "Program",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->693]
}, Open  ]],
Cell[27390, 862, 253, 9, 70, "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->15089],
Cell[CellGroupData[{
Cell[27668, 875, 136, 2, 70, "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->7688],
Cell[27807, 879, 127, 2, 70, "Program",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->22414]
}, Open  ]],
Cell[CellGroupData[{
Cell[27971, 886, 267, 9, 70, "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->12296],
Cell[28241, 897, 407, 11, 70, "Program",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->20268]
}, Open  ]],
Cell[28663, 911, 111, 2, 70, "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->25358],
Cell[28777, 915, 302, 6, 70, "BulletedText",
 CellID->690457637],
Cell[29082, 923, 134, 4, 70, "BulletedText",
 CellID->1667360318],
Cell[29219, 929, 140, 5, 70, "BulletedText",
 CellID->810754923],
Cell[29362, 936, 278, 6, 70, "BulletedText",
 CellID->574250646],
Cell[29643, 944, 317, 6, 70, "BulletedText",
 CellID->639097704],
Cell[29963, 952, 80, 1, 70, "BulletedText",
 CellID->840817090],
Cell[30046, 955, 141, 5, 70, "BulletedText",
 CellID->1170434370],
Cell[30190, 962, 281, 6, 70, "BulletedText",
 CellID->540250070],
Cell[30474, 970, 317, 6, 70, "BulletedText",
 CellID->422066974],
Cell[30794, 978, 263, 9, 70, "BulletedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->10797],
Cell[31060, 989, 509, 16, 70, "BulletedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->30825],
Cell[31572, 1007, 455, 14, 70, "BulletedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->29647],
Cell[32030, 1023, 338, 9, 70, "BulletedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->28221],
Cell[32371, 1034, 116, 2, 70, "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->7237],
Cell[32490, 1038, 276, 6, 70, "ItemizedTextParagraph",
 CellID->541145977],
Cell[32769, 1046, 104, 2, 70, "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->29907],
Cell[32876, 1050, 128, 2, 70, "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->3670]
}, Open  ]],
Cell[CellGroupData[{
Cell[33041, 1057, 170, 4, 70, "Subsubsection",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->4549],
Cell[33214, 1063, 205, 5, 70, "Text",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->12546],
Cell[33422, 1070, 98, 2, 70, "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->19039],
Cell[33523, 1074, 204, 8, 70, "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->32252],
Cell[33730, 1084, 130, 2, 70, "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->30012],
Cell[33863, 1088, 159, 4, 70, "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->26020],
Cell[34025, 1094, 136, 2, 70, "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->11431],
Cell[34164, 1098, 105, 2, 70, "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->32476],
Cell[34272, 1102, 519, 11, 70, "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->691],
Cell[34794, 1115, 108, 2, 70, "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->30525],
Cell[34905, 1119, 132, 2, 70, "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->2845],
Cell[CellGroupData[{
Cell[35062, 1125, 413, 12, 70, "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->26099],
Cell[35478, 1139, 222, 6, 70, "Program",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->4416]
}, Open  ]],
Cell[CellGroupData[{
Cell[35737, 1150, 253, 7, 70, "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->7774],
Cell[35993, 1159, 223, 8, 70, "Program",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->17056]
}, Open  ]],
Cell[36231, 1170, 128, 2, 70, "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->18677],
Cell[36362, 1174, 110, 2, 70, "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->6872],
Cell[36475, 1178, 302, 6, 70, "BulletedText",
 CellID->447190394],
Cell[36780, 1186, 134, 4, 70, "BulletedText",
 CellID->1883671105],
Cell[36917, 1192, 140, 5, 70, "BulletedText",
 CellID->656337661],
Cell[37060, 1199, 279, 6, 70, "BulletedText",
 CellID->1591057435],
Cell[37342, 1207, 262, 9, 70, "BulletedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->6896],
Cell[37607, 1218, 643, 20, 70, "BulletedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->30309],
Cell[38253, 1240, 446, 12, 70, "BulletedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->15132],
Cell[38702, 1254, 334, 8, 70, "BulletedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->32358],
Cell[39039, 1264, 117, 2, 70, "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->31788],
Cell[39159, 1268, 276, 6, 70, "ItemizedTextParagraph",
 CellID->435937601],
Cell[39438, 1276, 100, 2, 70, "ItemizedText",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->4],
Cell[39541, 1280, 128, 2, 70, "ItemizedTextParagraph",
 CellTags->{"ProjectBuilder", "MacBuilding"},
 CellID->8930]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[39718, 1288, 82, 2, 70, "Subsection",
 CellTags->{"mcc", "MacBuilding"},
 CellID->16727],
Cell[39803, 1292, 1117, 34, 70, "Text",
 CellTags->{"mcc", "MacBuilding"},
 CellID->27649],
Cell[40923, 1328, 226, 7, 70, "Program",
 CellTags->{"mcc", "MacBuilding"},
 CellID->18519]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41198, 1341, 142, 7, 70, "Section",
 CellTags->"MacRunning",
 CellID->2922],
Cell[41343, 1350, 1051, 25, 70, "Text",
 CellTags->"MacRunning",
 CellID->11707],
Cell[CellGroupData[{
Cell[42419, 1379, 187, 7, 70, "Subsection",
 CellTags->{"addtwo", "MacRunning"},
 CellID->23529],
Cell[42609, 1388, 1721, 51, 70, "Text",
 CellTags->{"addtwo", "MacRunning"},
 CellID->9266],
Cell[44333, 1441, 502, 7, 70, "Program",
 CellTags->{"addtwo", "MacRunning"},
 CellID->23627],
Cell[44838, 1450, 108, 2, 70, "MathCaption",
 CellTags->{"addtwo", "MacRunning"},
 CellID->9425],
Cell[44949, 1454, 237, 7, 70, "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->19900],
Cell[45189, 1463, 163, 4, 70, "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->3248],
Cell[45355, 1469, 159, 4, 70, "MathCaption",
 CellTags->{"addtwo", "MacRunning"},
 CellID->7975],
Cell[45517, 1475, 121, 3, 70, "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->17530],
Cell[45641, 1480, 299, 8, 70, "MathCaption",
 CellTags->{"addtwo", "MacRunning"},
 CellID->7757],
Cell[45943, 1490, 102, 3, 70, "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->21413],
Cell[46048, 1495, 87, 2, 70, "MathCaption",
 CellTags->{"addtwo", "MacRunning"},
 CellID->19096],
Cell[46138, 1499, 140, 4, 70, "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->17016],
Cell[46281, 1505, 411, 10, 70, "MathCaption",
 CellID->702020527],
Cell[46695, 1517, 216, 8, 70, "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->26905],
Cell[46914, 1527, 191, 5, 70, "MathCaption",
 CellID->583840671],
Cell[47108, 1534, 196, 7, 70, "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->31807],
Cell[47307, 1543, 142, 5, 70, "MathCaption",
 CellID->757374354],
Cell[47452, 1550, 177, 5, 70, "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->27703],
Cell[47632, 1557, 619, 20, 70, "MathCaption",
 CellTags->{"addtwo", "MacRunning"},
 CellID->4452],
Cell[48254, 1579, 103, 3, 70, "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->22255],
Cell[48360, 1584, 137, 3, 70, "MathCaption",
 CellTags->{"addtwo", "MacRunning"},
 CellID->14684],
Cell[48500, 1589, 117, 3, 70, "Input",
 CellTags->{"addtwo", "MacRunning"},
 CellID->8535]
}, Open  ]],
Cell[CellGroupData[{
Cell[48654, 1597, 193, 7, 70, "Subsection",
 CellTags->{"factor", "MacRunning"},
 CellID->594],
Cell[48850, 1606, 748, 21, 70, "Text",
 CellTags->{"factor", "MacRunning"},
 CellID->146],
Cell[49601, 1629, 229, 6, 70, "Text",
 CellTags->{"factor", "MacRunning"},
 CellID->7790],
Cell[49833, 1637, 207, 4, 70, "Program",
 CellTags->{"factor", "MacRunning"},
 CellID->18036],
Cell[50043, 1643, 351, 8, 70, "Text",
 CellTags->{"factor", "MacRunning"},
 CellID->10047],
Cell[50397, 1653, 115, 2, 70, "Program",
 CellTags->{"factor", "MacRunning"},
 CellID->8505],
Cell[50515, 1657, 350, 12, 70, "Text",
 CellTags->{"factor", "MacRunning"},
 CellID->10607],
Cell[50868, 1671, 154, 3, 70, "Program",
 CellTags->{"factor", "MacRunning"},
 CellID->3278]
}, Open  ]],
Cell[CellGroupData[{
Cell[51059, 1679, 101, 2, 70, "Subsection",
 CellTags->{"protocols", "MacRunning"},
 CellID->4958],
Cell[51163, 1683, 1868, 64, 70, "Text",
 CellTags->{"protocols", "MacRunning"},
 CellID->16281],
Cell[53034, 1749, 709, 24, 70, "Text",
 CellTags->{"protocols", "MacRunning"},
 CellID->17746]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[53792, 1779, 83, 2, 70, "Section",
 CellTags->"MacTroubleshooting",
 CellID->23791],
Cell[53878, 1783, 556, 10, 70, "BulletedText",
 CellTags->"MacTroubleshooting",
 CellID->27576],
Cell[54437, 1795, 502, 18, 70, "BulletedText",
 CellTags->"MacTroubleshooting",
 CellID->16924],
Cell[54942, 1815, 561, 16, 70, "BulletedText",
 CellTags->"MacTroubleshooting",
 CellID->10657],
Cell[55506, 1833, 678, 18, 70, "BulletedText",
 CellTags->"MacTroubleshooting",
 CellID->6708],
Cell[CellGroupData[{
Cell[56209, 1855, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->211133989],
Cell[56278, 1858, 309, 9, 70, "TutorialMoreAbout",
 CellID->558589989],
Cell[56590, 1869, 313, 9, 70, "TutorialMoreAbout",
 CellID->40858578],
Cell[56906, 1880, 336, 9, 70, "TutorialMoreAbout",
 CellID->8146795],
Cell[57245, 1891, 359, 9, 70, "TutorialMoreAbout",
 CellID->424932163],
Cell[57607, 1902, 348, 9, 70, "TutorialMoreAbout",
 CellID->2262398],
Cell[57958, 1913, 401, 11, 70, "TutorialMoreAbout",
 CellID->101684538],
Cell[58362, 1926, 338, 9, 70, "TutorialMoreAbout",
 CellID->655130],
Cell[58703, 1937, 347, 9, 70, "TutorialMoreAbout",
 CellID->148916145],
Cell[59053, 1948, 347, 9, 70, "TutorialMoreAbout",
 CellID->182367630],
Cell[59403, 1959, 327, 9, 70, "TutorialMoreAbout",
 CellID->113882963],
Cell[59733, 1970, 272, 9, 70, "TutorialMoreAbout",
 CellID->5094559],
Cell[60008, 1981, 457, 12, 70, "TutorialMoreAbout",
 CellID->246479563]
}, Open  ]],
Cell[CellGroupData[{
Cell[60502, 1998, 71, 1, 70, "RelatedTutorialsSection",
 CellID->26530286],
Cell[60576, 2001, 334, 9, 70, "RelatedTutorials",
 CellID->309869466],
Cell[60913, 2012, 333, 9, 70, "RelatedTutorials",
 CellID->441486358]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[61285, 2026, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

