(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     76829,       2416]
NotebookOptionsPosition[     49306,       1572]
NotebookOutlinePosition[     66558,       2070]
CellTagsIndexPosition[     66098,       2052]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       2->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C Language Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkCLanguageFunctions"],
           "MathLink Connection Management" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkConnectionManagement"], 
          "MathLink C Functions for Exchanging Data" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingData"], 
          "MathLink C Functions for Exchanging Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingExpressions"], 
          "MathLink C Functions for Exchanging Integers" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingIntegers"], 
          "MathLink C Functions for Exchanging Multidimensional Arrays" :> 
          Documentation`HelpLookup[
           "paclet:guide/\
MathLinkCFunctionsForExchangingMultidimensionalArrays"], 
          "MathLink C Functions for Exchanging Reals" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingReals"], 
          "MathLink C Functions for Exchanging Strings" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingStrings"], 
          "MathLink C Functions for Exchanging Symbols" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingSymbols"], 
          "MathLink Expression Packet Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkExpressionPacketHandling"], 
          "MathLink Packets" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkPackets"], 
          "Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MathLink C Language Functions\"\>", 
       2->"\<\"MathLink Connection Management\"\>", 
       3->"\<\"MathLink C Functions for Exchanging Data\"\>", 
       4->"\<\"MathLink C Functions for Exchanging Expressions\"\>", 
       5->"\<\"MathLink C Functions for Exchanging Integers\"\>", 
       6->"\<\"MathLink C Functions for Exchanging Multidimensional \
Arrays\"\>", 7->"\<\"MathLink C Functions for Exchanging Reals\"\>", 
       8->"\<\"MathLink C Functions for Exchanging Strings\"\>", 
       9->"\<\"MathLink C Functions for Exchanging Symbols\"\>", 
       10->"\<\"MathLink Expression Packet Handling\"\>", 
       11->"\<\"MathLink Packets\"\>", 
       12->"\<\"Alphabetical Listing of MathLink C Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Development in C (Unix and Linux)"
}], "Title",
 CellTags->"UnixIntroduction",
 CellID->10708],

Cell[TextData[{
 "This document describes how to compile and run ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs written in the C language on Linux/Unix systems",
 ". ",
 "(\"",
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
 "\" describes how to write ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs in both the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language and the C language.)"
}], "Text",
 CellTags->"UnixIntroduction",
 CellID->10820],

Cell[TextData[{
 "This document does not teach you, in general, how to use your compiler and \
other development tools, nor does it teach you how to program in C. If you \
have any trouble building or running your ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs, see the troubleshooting ",
 ButtonBox["section",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix#20042"],
 " at the end of this document."
}], "Text",
 CellTags->"UnixIntroduction",
 CellID->22266],

Cell[TextData[{
 "Most of what is described in this document is Linux/Unix specific, and is \
applicable to all supported Linux/Unix platforms",
 ". ",
 "To learn how to compile and run ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs for another platform, see the Developer Guide for that platform."
}], "Text",
 CellTags->"UnixIntroduction",
 CellID->25069],

Cell[CellGroupData[{

Cell["Supported Development Platforms", "Section",
 CellID->725481284],

Cell[TextData[{
 "As a shared library, ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " can be used with any development environment that adheres to the standard \
calling conventions and binary interfaces as specified by the compilers \
listed below."
}], "Text",
 CellID->1713067304],

Cell["\<\
While some of the compilers listed below integrate with integrated \
development environments produced by the compiler creators, they also \
function equally well with a make utility.\
\>", "Text",
 CellID->208922999],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], Cell["$SystemID", "TableText"], Cell[
    "C compiler", "TableText"], Cell["C++ compiler", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell["AIX-Power64", "TableText"], Cell[
    "IBM XL C Enterprise Edition V8 .0 for AIX", "TableText"], Cell[
    "IBM XL C++ Enterprise Edition V8.0 for AIX", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell["HPUX-PA64", "TableText"], Cell[
    "HP92453-01 B.11.11.14 HP C Compiler", "TableText"], Cell[
    "HP ANSI C++ B3910B A.03.67", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell["Linux", "TableText"], Cell[
    "gcc - 3.2.3 20030502 (Red Hat Linux 3.2.3-52)", "TableText"], Cell[
    "g++ - 3.2.3 20030502 (Red Hat Linux 3.2.3-52)", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell["Linux-IA64", "TableText"], Cell[
    "Intel C 9.0", "TableText"], Cell["Intel C++ 9.0", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell["Linux-x86-64", "TableText"], Cell[
    "gcc - 3.2.3 20030502 (Red Hat Linux 3.2.3-34)", "TableText"], Cell[
    "g++ - 3.2.3 20030502 (Red Hat Linux 3.2.3-34)", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell["Solaris-SPARC", "TableText"], Cell[
    "Sun C 5.8 2005/10/13", "TableText"], Cell[
    "Sun C++ 5.8 2005/10/13", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell["Solaris-x86-64", "TableText"], Cell[
    "Sun C 5.8 Patch 121016-03 2006/06/07", "TableText"], Cell[
    "Sun C++ 5.8 Patch 121018-04 2006/08/02", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->2090248064]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Installing the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Components"
}], "Section",
 CellTags->"UnixInstalling",
 CellID->26966],

Cell[TextData[{
 "The ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Developer Kit is located in the directory ",
 StyleBox["$InstallationDirectory/SystemFiles/Links/MathLink/DeveloperKit/$\
SystemID", "InlineCode"],
 " within your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " directory."
}], "Text",
 CellTags->"UnixInstalling",
 CellID->11099],

Cell[CellGroupData[{

Cell["Recommended Installation", "Subsection",
 CellTags->"UnixInstalling",
 CellID->4756],

Cell[CellGroupData[{

Cell["CompilerAdditions Installation", "Subsubsection",
 CellTags->"UnixInstalling",
 CellID->20609],

Cell[TextData[{
 "The ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " components that you will need to build ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs have already been installed by the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " installer. One way to use these components is to leave them in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " directory and specify their full path name when you call your compiler",
 ". ",
 "This approach is taken in the example makefiles in the section \
\[OpenCurlyDoubleQuote]",
 ButtonBox["Building ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix#32679"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix#32679"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix#32679"],
 "\[CloseCurlyDoubleQuote]."
}], "Text",
 CellTags->"UnixInstalling",
 CellID->2466],

Cell[TextData[{
 "An alternative is to copy these components (\[OpenCurlyDoubleQuote]",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"mathlink", ".", "h"}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/mathlink.h"]], "InlineFormula"],
 ",\[CloseCurlyDoubleQuote] \[OpenCurlyDoubleQuote]",
 StyleBox["libML32i3.a", "InlineCode"],
 ",\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]",
 StyleBox["libML32i3.so", "InlineCode"],
 "\[CloseCurlyDoubleQuote]) into directories in which your compiler will \
automatically search for such files. These directories are commonly ",
 StyleBox["/usr/include", "InlineCode"],
 " and ",
 StyleBox["/usr/lib", "InlineCode"],
 ", but may be different on your system",
 ". ",
 "On many systems not all users have write access to these directories."
}], "Text",
 CellTags->"UnixInstalling",
 CellID->23668]
}, Open  ]],

Cell[CellGroupData[{

Cell["MathLinkExamples Installation", "Subsubsection",
 CellTags->"UnixInstalling",
 CellID->9359],

Cell[TextData[{
 "Copy the ",
 StyleBox["MathLinkExamples", "InlineCode"],
 " directory to your home directory."
}], "Text",
 CellTags->"UnixInstalling",
 CellID->6395]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Components of the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Developer's Kit"
}], "Subsection",
 CellTags->{"parts", "UnixInstalling"},
 CellID->27184],

Cell[TextData[{
 "The following is a description of each file or directory in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Developer's Kit (MLDK)."
}], "Text",
 CellTags->{"parts", "UnixInstalling"},
 CellID->27928],

Cell[CellGroupData[{

Cell["CompilerAdditions Directory", "Subsubsection",
 CellTags->{"parts", "UnixInstalling"},
 CellID->15094],

Cell[CellGroupData[{

Cell["mathlink.h", "Subsubsubsection",
 CellTags->{"parts", "mathlink.h", "UnixInstalling"},
 CellID->24332],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox[
   RowBox[{"mathlink", ".", "h"}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/mathlink.h"]], "InlineFormula"],
 " is the header file that must be included in your C and C++ source files. \
It should be placed where your compiler can find it",
 ". ",
 "You could copy this header file into the same directory as your source \
files that include it, or in the same location as the standard header files, \
or leave it where it is if you added the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " directory to the search path for header files."
}], "Text",
 CellTags->{"parts", "mathlink.h", "UnixInstalling"},
 CellID->21866]
}, Open  ]],

Cell[CellGroupData[{

Cell["libML32i3.a/libML64i4.a", "Subsubsubsection",
 CellTags->{"parts", "MathLinkLibraries", "UnixInstalling"},
 CellID->26458],

Cell[TextData[{
 "This is the static library that contains all of the ",
 StyleBox["MathLink ",
  FontSlant->"Italic"],
 "functions. It should be included in your project. You could copy this \
library into the same directory as your source files, or leave it where it is \
if you added the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " directory to the search path for libraries",
 ". ",
 "The 32/64 indicates whether the library is a 32-bit or a 64-bit version of \
the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library."
}], "Text",
 CellTags->{"parts", "MathLinkLibraries", "UnixInstalling"},
 CellID->15266]
}, Open  ]],

Cell[CellGroupData[{

Cell["libML32i3.so/libML64i3.a/(.sl on HPUX)", "Subsubsubsection",
 CellID->1736540090],

Cell[TextData[{
 "This is the dynamic shared library that contains all of the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " functions. It should be included in your project. You could copy this \
library into the same directory as your source files, into a systemwide \
location such as ",
 StyleBox["/lib", "InlineCode"],
 " or ",
 StyleBox["/usr/lib", "InlineCode"],
 ", or leave it where it is if you added the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " directory to the search path for libraries",
 ". ",
 "The 32/64 indicates whether the library is a 32-bit or a 64-bit version of \
the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library."
}], "Text",
 CellID->1726529900]
}, Open  ]],

Cell[CellGroupData[{

Cell["mprep", "Subsubsubsection",
 CellTags->{"parts", "mprep", "UnixInstalling"},
 CellID->9463],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["mprep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mprep"]], "InlineFormula"],
 " is an application that writes ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs automatically by processing \[OpenCurlyDoubleQuote]",
 ButtonBox["template",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/file.tm"],
 "\[CloseCurlyDoubleQuote] files. It may be convenient to copy this \
application into the same directory as your project or to create an alias to \
it."
}], "Text",
 CellTags->{"parts", "mprep", "UnixInstalling"},
 CellID->26913]
}, Open  ]],

Cell[CellGroupData[{

Cell["mcc", "Subsubsubsection",
 CellTags->{"parts", "mcc", "UnixInstalling"},
 CellID->17431],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["mcc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mcc"]], "InlineFormula"],
 " is a script that preprocesses and compiles your ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " source files."
}], "Text",
 CellTags->{"parts", "mcc", "UnixInstalling"},
 CellID->1286]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MathLinkExamples Directory", "Subsubsection",
 CellTags->{"parts", "UnixInstalling"},
 CellID->13360],

Cell[TextData[{
 "This directory contains the source code for some very simple ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs",
 ". ",
 "By using this source code, you can learn how to build and run ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs without having to write any code yourself."
}], "Text",
 CellTags->{"parts", "UnixInstalling"},
 CellID->23166]
}, Open  ]],

Cell[CellGroupData[{

Cell["PrebuiltExamples Folder", "Subsubsection",
 CellTags->{"parts", "prebuilt", "UnixInstalling"},
 CellID->28449],

Cell[TextData[{
 "This folder contains prebuilt versions of the example programs. The ",
 ButtonBox["following section",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix#763"],
 " describes how to run two of these programs",
 ". ",
 "The ",
 ButtonBox["section after that",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix#32679"],
 " describes how to build them yourself using the source code in the \
\[OpenCurlyDoubleQuote]",
 StyleBox["MathLinkExamples", "InlineCode"],
 "\[CloseCurlyDoubleQuote] folder."
}], "Text",
 CellTags->{"parts", "prebuilt", "UnixInstalling"},
 CellID->29122]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Building ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Programs"
}], "Section",
 CellTags->"UnixBuilding",
 CellID->32679],

Cell[TextData[{
 "The general procedure for building ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs is to include ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"mathlink", ".", "h"}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/mathlink.h"]], "InlineFormula"],
 " in any C or C++ source files that make ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " function calls, to compile your source files, and then to link the \
resulting object code with the ",
 StyleBox["\[OpenCurlyDoubleQuote]libML32i3.a\[CloseCurlyDoubleQuote]", 
  "InlineCode"],
 ", \[OpenCurlyDoubleQuote]",
 StyleBox["libML64i3", "InlineCode"],
 "\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]",
 StyleBox["libML32i3.so", "InlineCode"],
 "\[CloseCurlyDoubleQuote], or \[OpenCurlyDoubleQuote]",
 StyleBox["libML64i3.so", "InlineCode"],
 "\[CloseCurlyDoubleQuote] library and any other standard libraries required \
by your application",
 ". ",
 "If your application uses the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template mechanism, then your template files must first be processed into \
a C source file using ",
 Cell[BoxData[
  ButtonBox["mprep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mprep"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"UnixBuilding",
 CellID->10637],

Cell[CellGroupData[{

Cell[TextData[{
 "Using ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Template Files"
}], "Subsection",
 CellTags->{"mprep", "UnixBuilding"},
 CellID->21100],

Cell[TextData[{
 "If your program uses the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template mechanism as described in \"",
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
 "\", you must simultaneously preprocess your source files that contain \
template entries using the ",
 Cell[BoxData[
  ButtonBox["mprep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mprep"]], "InlineFormula"],
 " application. (A template entry is a sequence of lines that contain \
template keywords. Each entry defines a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function that when evaluated calls an associated C function.)",
 " ",
 "When ",
 Cell[BoxData[
  ButtonBox["mprep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mprep"]], "InlineFormula"],
 " processes such source files, it converts template entries into C \
functions, passes other text through unmodified, and writes out additional C \
functions that implement a remote procedure call mechanism using ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". The result is a C source file that is ready for compilation."
}], "Text",
 CellTags->{"mprep", "UnixBuilding"},
 CellID->26637],

Cell["For example, the command", "Text",
 CellTags->{"mprep", "UnixBuilding"},
 CellID->10909],

Cell[TextData[{
 StyleBox[ButtonBox["mprep",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mprep"], "MR"],
 StyleBox["  addtwo.tm  -o addtwotm.c", "MR"]
}], "Program",
 CellTags->{"mprep", "UnixBuilding"},
 CellID->31750],

Cell[TextData[{
 "will produce a C source file \[OpenCurlyDoubleQuote]",
 StyleBox["addtwotm.c", "InlineCode"],
 "\[CloseCurlyDoubleQuote] from the template entries and other text in \
\[OpenCurlyDoubleQuote]",
 StyleBox["addtwo.tm", "InlineCode"],
 "\[CloseCurlyDoubleQuote]. You would then compile the output file using the \
C compiler",
 ". ",
 "If you use the \[OpenCurlyDoubleQuote]",
 StyleBox["make", "InlineCode"],
 "\[CloseCurlyDoubleQuote] utility to build your program, you could add a \
rule similar to the following one to your makefile."
}], "Text",
 CellTags->{"mprep", "UnixBuilding"},
 CellID->4654],

Cell[TextData[StyleBox["addtwotm.c  :  addtwo.tm\n    mprep  addtwo.tm  -o \
addtwotm.c", "MR"]], "Program",
 CellTags->{"mprep", "UnixBuilding"},
 CellID->28540]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Building ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs"
}], "Subsection",
 CellTags->"UnixBuilding",
 CellID->31597],

Cell[TextData[{
 "What follows is a sample makefile needed to build the sample programs in \
the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Developer's Kit, including \[OpenCurlyDoubleQuote]",
 StyleBox["addtwo", "InlineCode"],
 "\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]",
 StyleBox["factor", "InlineCode"],
 "\[CloseCurlyDoubleQuote]",
 ". ",
 "To build a sample program, in this case \[OpenCurlyDoubleQuote]",
 StyleBox["addtwo", "InlineCode"],
 "\[CloseCurlyDoubleQuote], evaluate the following command in the ",
 StyleBox["MathLinkExamples", "InlineCode"],
 " directory."
}], "Text",
 CellTags->"UnixBuilding",
 CellID->8827],

Cell[TextData[StyleBox["make addtwo", "MR"]], "Program",
 CellTags->"UnixBuilding",
 CellID->26979],

Cell[CellGroupData[{

Cell["Using a Makefile", "Subsubsection",
 CellTags->"UnixBuilding",
 CellID->19046],

Cell[TextData[{
 StyleBox["# This makefile can be used to build all or some of the sample\n# \
programs", "MR"],
 ". ",
 StyleBox["To build all of them, use the command\n# 'make all'", "MR"],
 ". ",
 StyleBox["To build one, say addtwo, use the command\n# 'make addtwo'.\n\n\
MLINKDIR = \
/usr/local/Wolfram/Mathematica/6.0/SystemFiles/Links/MathLink/DeveloperKit\n\
SYS = Linux  # Set this value with the result of evaluating $SystemID\n\
CADDSDIR = ${MLINKDIR}/${SYS}/CompilerAdditions\n\nINCDIR = ${CADDSDIR}\n\
LIBDIR = ${CADDSDIR}\n\nEXTRALIBS = -lm -lpthread -lrt # Set these with \
appropriate libs for your system.\nMLLIB = ML32i3 # Set this to ML64i3 if \
using a 64-bit system\n\nMPREP = ${CADDSDIR}/mprep\n\nall : addtwo bitops \
counter factor factor2 factor3 quotient reverse sumalist\n\naddtwo : \
addtwotm.o addtwo.o\n\t${CC} -I${INCDIR} addtwotm.o addtwo.o -L${LIBDIR} \
-l${MLLIB} ${EXTRALIBS} -o $@\n\nbitops : bitopstm.o bitops.o\n\t${CC} \
-I${INCDIR} bitopstm.o bitops.o -L${LIBDIR} -l${MLLIB} ${EXTRALIBS} -o $@\n\n\
counter : countertm.o\n\t${CC} -I${INCDIR} countertm.o -L${LIBDIR} -l${MLLIB} \
${EXTRALIBS} -o $@\n\nfactor : factor.o\n\t${CC} -I${INCDIR} factor.o \
-L${LIBDIR} -l${MLLIB} ${EXTRALIBS} -o $@\n\nfactor2 : factor2.o\n\t${CC} \
-I${INCDIR} factor2.o -L${LIBDIR} -l${MLLIB} ${EXTRALIBS} -o $@\n\nfactor3 : \
factor3.o\n\t${CC} -I${INCDIR} factor3.o -L${LIBDIR} -l${MLLIB} ${EXTRALIBS} \
-o $@\n\nquotient : quotient.o\n\t${CC} -I${INCDIR} quotient.o -L${LIBDIR} \
-l${MLLIB} ${EXTRALIBS} -o $@\n\nreverse : reversetm.o\n\t${CC} -I${INCDIR} \
reversetm.o -L${LIBDIR} -l${MLLIB} ${EXTRALIBS} -o $@\n\nsumalist : \
sumalisttm.o sumalist.o\n\t${CC} -I${INCDIR} sumalisttm.o sumalist.o \
-L${LIBDIR} -l${MLLIB} ${EXTRALIBS} -o $@\n\n.c.o :\n\t${CC} -c -I${INCDIR} \
$<\n\naddtwotm.c : addtwo.tm\n\t${MPREP} $? -o $@\n\nbitopstm.c : bitops.tm\n\
\t${MPREP} $? -o $@\n\ncountertm.c : counter.tm\n\t${MPREP} $? -o $@\n\n\
reversetm.c : reverse.tm\n\t${MPREP} $? -o $@\n\nsumalisttm.c : sumalist.tm\n\
\t${MPREP} $? -o $@", "MR"]
}], "Program",
 CellTags->"UnixBuilding",
 CellID->2139],

Cell[TextData[{
 "Use the following table to determine the extra libraries needed for linking \
",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs on your system."
}], "Reference",
 CellID->183585510],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["$SystemID", "InlineFormula"], Cell["EXTRALIBS", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"AIX", "-", "Power64"}], Cell[
    "-lm -lpthread -lc128", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"HPUX", "-", "PA64"}], Cell[
    "-lm /usr/lib/libdld.sl /usr/lib/libm.0 -lpthread -lrt", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Linux", Cell[
    "-lm -lpthread -lrt", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"Linux", "-", "IA64"}], Cell["-lm -lpthread -lrt", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"Linux", "-", "x86", "-", "64"}], Cell[
    "-lm -lpthread -lrt", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"Solaris", "-", "SPARC"}], Cell[
    "-lm -lsocket -lnsl -lrt", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"Solaris", "-", "x86", "-", "64"}], Cell[
    "-lm -lsocket -lnsl -lrt", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->914669408]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using mcc", "Subsection",
 CellTags->{"mcc", "UnixBuilding"},
 CellID->25838],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["mcc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mcc"]], "InlineFormula"],
 " is a script that preprocesses and compiles your ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " source files. It will preprocess ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " templates in any file whose name ends with ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{".", "tm"}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/file.tm"]], "InlineFormula"],
 ", and then call \[OpenCurlyDoubleQuote]",
 StyleBox["cc", "InlineCode"],
 "\[CloseCurlyDoubleQuote] on the resulting C source code. ",
 Cell[BoxData[
  ButtonBox["mcc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mcc"]], "InlineFormula"],
 " will pass command-line options and other files directly to ",
 StyleBox["cc", "InlineCode"],
 ". Following is a command that would build the \[OpenCurlyDoubleQuote]",
 StyleBox["addtwo", "InlineCode"],
 "\[CloseCurlyDoubleQuote] application using ",
 Cell[BoxData[
  ButtonBox["mcc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mcc"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->{"mcc", "UnixBuilding"},
 CellID->8081],

Cell[TextData[{
 StyleBox[ButtonBox["mcc",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mcc"], "MR"],
 StyleBox[" addtwo.tm addtwo.c -o addtwo", "MR"]
}], "Program",
 CellTags->{"mcc", "UnixBuilding"},
 CellID->898]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Running ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Programs"
}], "Section",
 CellTags->"UnixRunning",
 CellID->763],

Cell[TextData[{
 "The instructions in the next section describe how to build two ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs using source code in the \[OpenCurlyDoubleQuote]",
 StyleBox["MathLinkExamples", "InlineCode"],
 "\[CloseCurlyDoubleQuote] directory. These two programs, \
\[OpenCurlyDoubleQuote]",
 StyleBox["addtwo", "InlineCode"],
 "\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]",
 StyleBox["factor", "InlineCode"],
 "\[CloseCurlyDoubleQuote], are already built for you in the \
\[OpenCurlyDoubleQuote]",
 StyleBox["PrebuiltExamples", "InlineCode"],
 "\[CloseCurlyDoubleQuote] folder",
 ". ",
 "Before building them on your own, you should try to run the prebuilt \
examples to verify that the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " system additions are installed and working and to learn what to expect \
from these examples when they are properly built. "
}], "Text",
 CellTags->"WindowsRunning",
 CellID->16696],

Cell[TextData[{
 "There are two basic types of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program, epitomized by the \"",
 StyleBox["addtwo", "InlineCode"],
 "\" and \"",
 StyleBox["factor", "InlineCode"],
 "\" programs. The first is an Installable program. An Installable program \
provides new functionality to the kernel by linking a C program to the kernel \
through a calling mechanism. In order to get this new functionality, the user \
of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " must run the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"], "InlineFormula"]], "InlineFormula"],
 StyleBox["[]", "InlineFormula"],
 " function. With the \[OpenCurlyDoubleQuote]",
 StyleBox["addtwo", "InlineCode"],
 "\[CloseCurlyDoubleQuote] example we'll be adding a new function called ",
 StyleBox["AddTwo[]", "InlineFormula"],
 " that adds two numbers (provided as arguments) together. The Kernel and \
Installable programs have a special relationship that allows them only to \
communicate with one another. When an installable program is run it requires \
that you provide some information in order for it to connect. The other type \
of program is a Front End. Front Ends do all of the work of creating and \
managing their own links. In addition to the \"",
 StyleBox["factor", "InlineCode"],
 "\" example, the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Front End and the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Kernel are also example of the Front End type. A Front End does not \
require any extra information in order to run, but it will usually make a \
connection at some point during its execution."
}], "Text",
 CellTags->"WindowsRunning",
 CellID->6894],

Cell[CellGroupData[{

Cell[TextData[{
 "Running a Prebuilt Example from the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Kernel"
}], "Subsection",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->24335],

Cell[TextData[{
 "The first example program, \[OpenCurlyDoubleQuote]",
 StyleBox["addtwo", "InlineCode"],
 "\[CloseCurlyDoubleQuote], is a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template program that is installed into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". That is, this program runs in the background, providing, as a service to \
",
 StyleBox["Mathematica,",
  FontSlant->"Italic"],
 " one or more externally compiled functions. To the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " user, these functions appear to be built-in. The \[OpenCurlyDoubleQuote]",
 StyleBox["addtwo", "InlineCode"],
 "\[CloseCurlyDoubleQuote] program uses a template file that defines the ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "function ",
 StyleBox["AddTwo[]", "InlineFormula"],
 " as a call to the C function ",
 StyleBox["addtwo()", "InlineCode"],
 ". (The template mechanism is described in \"",
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
 "\".)",
 " ",
 "The source code for this program looks likes this:"
}], "Text",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->19616],

Cell[TextData[StyleBox[":Begin:\n:Function:       addtwo\n:Pattern:        \
AddTwo[i_Integer, j_Integer]\n:Arguments:      { i, j }\n:ArgumentTypes:  { \
Integer, Integer }\n:ReturnType:     Integer\n:End:\n\n:Evaluate: \
AddTwo::usage = \"AddTwo[x, y] gives the sum of two machine integers x and y.\
\"\n\nint addtwo( int i, int j)\n{\n\treturn i+j;\n}\n\nint main(int argc; \
char* argv[])\n{\n\treturn MLMain(argc, argv);\n}", "MR"]], "Program",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->31857],

Cell["\<\
Edit the path string below and evaluate the following two cells:\
\>", "MathCaption",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->10980],

Cell[BoxData[
 RowBox[{"SetDirectory", "[", 
  RowBox[{
  "$InstallationDirectory", "<>", 
   "\"\</SystemFiles/Links/MathLink/DeveloperKit/\>\"", "<>", "$SystemID", 
   "<>", "\"\</PrebuiltExamples\>\""}], "]"}]], "Input",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->12166],

Cell[BoxData[
 RowBox[{"link", " ", "=", " ", 
  RowBox[{"Install", "[", "\"\<./addtwo\>\"", "]"}]}]], "Input",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->21661],

Cell["\<\
To see a list of the newly available functions, evaluate the following cell:\
\>", "MathCaption",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->25491],

Cell[BoxData[
 RowBox[{"LinkPatterns", "[", "link", "]"}]], "Input",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->13933],

Cell[TextData[{
 "This displays the usage message for the ",
 StyleBox["AddTwo[]", "InlineFormula"],
 " function as defined in the file \[OpenCurlyDoubleQuote]",
 StyleBox["addtwo.tm", "InlineCode"],
 "\[CloseCurlyDoubleQuote]:"
}], "MathCaption",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->3929],

Cell[BoxData[
 RowBox[{"?", "AddTwo"}]], "Input",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->24085],

Cell["Now try it:", "MathCaption",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->15250],

Cell[BoxData[
 RowBox[{"AddTwo", "[", 
  RowBox[{"2", ",", " ", "3"}], "]"}]], "Input",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->891],

Cell[TextData[{
 "See what happens if the sum of the two machine integers won't fit in a \
machine integer or if either argument is not a machine integer (",
 StyleBox["2^31-1", "InlineFormula"],
 " is the largest machine integer",
 ". ",
 "If your compiler uses 2-byte ints, the ",
 StyleBox["2^15-1", "InlineFormula"],
 " is the largest C ",
 StyleBox["int", "InlineCode"],
 "):"
}], "MathCaption",
 CellID->988991036],

Cell[BoxData[
 RowBox[{
  RowBox[{"AddTwo", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "^", "31"}], "-", "1"}], ",", " ", "1"}], "]"}], 
  "   "}]], "Input",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->23288],

Cell[TextData[{
 "The \[OpenCurlyDoubleQuote]",
 StyleBox["addtwo", "InlineCode"],
 "\[CloseCurlyDoubleQuote] program is not prepared for big integers:"
}], "MathCaption",
 CellID->448914272],

Cell[BoxData[
 RowBox[{
  RowBox[{"AddTwo", "[", 
   RowBox[{
    RowBox[{"2", "^", "31"}], ",", " ", "1"}], "]"}], "          "}]], "Input",\

 CellTags->{"addtwo", "UnixRunning"},
 CellID->786],

Cell[TextData[{
 "This does not match ",
 StyleBox["AddTwo[_Integer, _Integer]", "InlineFormula"],
 ":"
}], "MathCaption",
 CellID->792117593],

Cell[BoxData[
 RowBox[{
  RowBox[{"AddTwo", "[", 
   RowBox[{"x", ",", " ", "1"}], "]"}], "                   "}]], "Input",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->12559],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"], "[", "]"}]], "InlineFormula"],
 " called ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkOpen"], "[", "]"}]], "InlineFormula"],
 " and then exchanged information with the external program to set up the \
definition for ",
 StyleBox["AddTwo[]", "InlineFormula"],
 ". ",
 "You really don't have to worry about these details, but if you are curious, \
evaluate:"
}], "MathCaption",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->6910],

Cell[BoxData[
 RowBox[{"??", "AddTwo"}]], "Input",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->26226],

Cell["When you are finished using the external program, evaluate:", \
"MathCaption",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->21290],

Cell[BoxData[
 RowBox[{"Uninstall", "[", "link", "]"}]], "Input",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->21241]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Invoking the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Kernel from Within a Prebuilt Example"
}], "Subsection",
 CellTags->{"factor", "UnixRunning"},
 CellID->10264],

Cell[TextData[{
 "The second example program, \[OpenCurlyDoubleQuote]",
 StyleBox["factor", "InlineCode"],
 "\[CloseCurlyDoubleQuote], is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end in the sense that the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel runs in the background providing, as a service to \
\[OpenCurlyDoubleQuote]",
 StyleBox["factor", "InlineCode"],
 "\[CloseCurlyDoubleQuote], the computational services of the kernel\
\[LongDash]in this case the ability to factor an integer typed by the user."
}], "Text",
 CellTags->{"factor", "UnixRunning"},
 CellID->30666],

Cell[TextData[{
 "Launch the \[OpenCurlyDoubleQuote]",
 StyleBox["factor", "InlineCode"],
 "\[CloseCurlyDoubleQuote] application by executing the following command:"
}], "Text",
 CellTags->{"factor", "UnixRunning"},
 CellID->30074],

Cell[TextData[StyleBox["factor -linkmode launch -linkname 'math -mathlink'", \
"MR"]], "Program",
 CellTags->{"factor", "UnixRunning"},
 CellID->26692],

Cell[TextData[{
 "After a moment, a prompt will appear requesting that you type an integer. \
Type an integer with fewer than 10 digits and press the ",
 StyleBox["Return", "KeyEvent"],
 " key. (The other factor examples relax the restriction on the size of \
integer you may type in.)"
}], "Text",
 CellTags->{"factor", "UnixRunning"},
 CellID->30148],

Cell[TextData[StyleBox["Integer to factor:", "MR"]], "Program",
 CellTags->{"factor", "UnixRunning"},
 CellID->24412],

Cell[TextData[{
 "The prime factors returned by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are printed and \[OpenCurlyDoubleQuote]",
 StyleBox["factor", "InlineCode"],
 "\[CloseCurlyDoubleQuote] closes its link with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->{"factor", "UnixRunning"},
 CellID->24892],

Cell[TextData[StyleBox["Integer to factor: 123456789\n3 ^ 2\n3607 ^ 1\n3803 ^ \
1", "MR"]], "Program",
 CellTags->{"factor", "UnixRunning"},
 CellID->216]
}, Open  ]],

Cell[CellGroupData[{

Cell["Supported Link Protocols", "Subsection",
 CellTags->{"protocols", "UnixRunning"},
 CellID->20158],

Cell[TextData[{
 "The C function ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"MLOpenArgcArgv", 
    RowBox[{"(", ")"}]}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/MLOpenArgcArgv"]], "InlineFormula"],
 " and the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkOpen"], "[", "]"}]], "InlineFormula"],
 " are documented in \"",
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
 "\". On Linux/Unix machines, the legal values for the ",
 Cell[BoxData[
  ButtonBox["LinkProtocol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkProtocol"]], "InlineFormula"],
 " option are \"",
 StyleBox["TCPIP", "InlineCode"],
 "\", \"",
 StyleBox["TCP", "InlineCode"],
 "\", \"",
 StyleBox["SharedMemory", "InlineCode"],
 "\", and \"",
 StyleBox["Pipes", "InlineCode"],
 "\". A ",
 Cell[BoxData[
  ButtonBox["LinkProtocol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkProtocol"]], "InlineFormula"],
 " is the mechanism used to transport data from one end of a connection to \
the other. \"",
 StyleBox["Pipes", "InlineCode"],
 "\" is the default protocol for all ",
 StyleBox["LinkMode->Launch", "InlineFormula"],
 " links. \"",
 StyleBox["SharedMemory", "InlineCode"],
 "\" is the default protocol for all ",
 StyleBox["LinkMode->Listen", "InlineFormula"],
 " and ",
 StyleBox["LinkMode->Connect", "InlineFormula"],
 " links."
}], "Text",
 CellTags->{"protocols", "UnixRunning"},
 CellID->18827],

Cell[TextData[{
 "Note that link names are unsigned 16-bit integers for the \"",
 StyleBox["TCPIP", "InlineCode"],
 "\"",
 " ",
 "and \"",
 StyleBox["TCP", "InlineCode"],
 "\" protocols. Even though \"",
 StyleBox["TCPIP", "InlineCode"],
 "\" link names are integers, they are still given as strings (of digits) to \
",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"MLOpenArgcArgv", 
    RowBox[{"(", ")"}]}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/MLOpenArgcArgv"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkOpen"], "[", "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellTags->{"protocols", "UnixRunning"},
 CellID->11159]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Troubleshooting", "Section",
 CellID->20042],

Cell["\<\
Turn off compiler optimization until your program is working. This makes \
compiling faster, debugging easier, and, besides, the optimizer may be broken \
and the cause of some problems. (Optimized code uses the stack and registers \
differently than unoptimized code in such a way that may expose or mask a bug \
in your code. For example, the common mistake of returning a pointer to a \
local variable may or may not cause a problem depending on stack and register \
use.)\
\>", "BulletedText",
 CellID->2839],

Cell[TextData[{
 "Check the return values from the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library functions or call ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"MLError", 
    RowBox[{"(", ")"}]}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/MLError"]], "InlineFormula"],
 " at key points in your program",
 ". ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " will often be able to tell you what has gone wrong."
}], "BulletedText",
 CellID->10163],

Cell[TextData[{
 "The files \[OpenCurlyDoubleQuote]",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"mathlink", ".", "h"}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/mathlink.h"]], "InlineFormula"],
 "\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]",
 StyleBox["libML32i3.a", "InlineCode"],
 "\[CloseCurlyDoubleQuote], and \[OpenCurlyDoubleQuote]",
 StyleBox["libML32i3.so", "InlineCode"],
 "\[CloseCurlyDoubleQuote] (",
 StyleBox["libML64i3.*", "InlineCode"],
 " on 64-bit platforms) are a matched set",
 ". ",
 "If you have used an earlier release of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ", you should take care that you don't mix components when building your \
application."
}], "BulletedText",
 CellID->21448],

Cell[TextData[{
 "Check whether the C compiler you are using supports prototypes. If it does \
not, you will need to change your code and the way you build your project",
 ". ",
 "This is explained in the section \"",
 ButtonBox["Building ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix#32679"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix#32679"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix#32679"],
 "\"."
}], "BulletedText",
 CellID->6396],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->162458548],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Language Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"]
}], "TutorialMoreAbout",
 CellID->558589989],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkConnectionManagement"],
  FontSlant->"Italic"],
 ButtonBox[" Connection Management",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkConnectionManagement"]
}], "TutorialMoreAbout",
 CellID->40858578],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Data",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"]
}], "TutorialMoreAbout",
 CellID->8146795],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"]
}], "TutorialMoreAbout",
 CellID->424932163],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingIntegers"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Integers",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingIntegers"]
}], "TutorialMoreAbout",
 CellID->2262398],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:guide/MathLinkCFunctionsForExchangingMultidimensionalArrays"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Multidimensional Arrays",
  BaseStyle->"Link",
  ButtonData->
   "paclet:guide/MathLinkCFunctionsForExchangingMultidimensionalArrays"]
}], "TutorialMoreAbout",
 CellID->101684538],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingReals"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Reals",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingReals"]
}], "TutorialMoreAbout",
 CellID->655130],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingStrings"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Strings",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingStrings"]
}], "TutorialMoreAbout",
 CellID->148916145],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingSymbols"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Symbols",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingSymbols"]
}], "TutorialMoreAbout",
 CellID->182367630],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkExpressionPacketHandling"],
  FontSlant->"Italic"],
 ButtonBox[" Expression Packet Handling",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkExpressionPacketHandling"]
}], "TutorialMoreAbout",
 CellID->113882963],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkPackets"],
  FontSlant->"Italic"],
 ButtonBox[" Packets",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkPackets"]
}], "TutorialMoreAbout",
 CellID->5094559],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "TutorialMoreAbout",
 CellID->246479563]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->204472993],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "RelatedTutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "RelatedTutorials",
 CellID->441486358]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathLink Development in C (Unix and Linux) - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 22.1018978}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "This document describes how to compile and run MathLink programs written \
in the C language on Linux/Unix systems. (\"MathLink and External Program \
Communication\" describes how to write MathLink programs in both the \
Mathematica language and the C language.) This document does not teach you, \
in general, how to use your compiler and other development tools, nor does it \
teach you how to program in C. If you have any trouble building or running \
your MathLink programs, see the troubleshooting section at the end of this \
document. Most of what is described in this document is Linux/Unix specific, \
and is applicable to all supported Linux/Unix platforms. To learn how to \
compile and run MathLink programs for another platform, see the Developer \
Guide for that platform.", "synonyms" -> {}, "title" -> 
    "MathLink Development in C Unix and Linux", "type" -> "Tutorial", "uri" -> 
    "tutorial/MathLinkDeveloperGuide-Unix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "UnixIntroduction"->{
  Cell[4574, 108, 159, 6, 70, "Title",
   CellTags->"UnixIntroduction",
   CellID->10708],
  Cell[4736, 116, 756, 25, 70, "Text",
   CellTags->"UnixIntroduction",
   CellID->10820],
  Cell[5495, 143, 505, 13, 70, "Text",
   CellTags->"UnixIntroduction",
   CellID->22266],
  Cell[6003, 158, 371, 10, 70, "Text",
   CellTags->"UnixIntroduction",
   CellID->25069]},
 "UnixInstalling"->{
  Cell[8859, 228, 156, 7, 70, "Section",
   CellTags->"UnixInstalling",
   CellID->26966],
  Cell[9018, 237, 360, 13, 70, "Text",
   CellTags->"UnixInstalling",
   CellID->11099],
  Cell[9403, 254, 90, 2, 70, "Subsection",
   CellTags->"UnixInstalling",
   CellID->4756],
  Cell[9518, 260, 100, 2, 70, "Subsubsection",
   CellTags->"UnixInstalling",
   CellID->20609],
  Cell[9621, 264, 1014, 30, 70, "Text",
   CellTags->"UnixInstalling",
   CellID->2466],
  Cell[10638, 296, 843, 21, 70, "Text",
   CellTags->"UnixInstalling",
   CellID->23668],
  Cell[11518, 322, 98, 2, 70, "Subsubsection",
   CellTags->"UnixInstalling",
   CellID->9359],
  Cell[11619, 326, 168, 6, 70, "Text",
   CellTags->"UnixInstalling",
   CellID->6395],
  Cell[11836, 338, 178, 7, 70, "Subsection",
   CellTags->{"parts", "UnixInstalling"},
   CellID->27184],
  Cell[12017, 347, 226, 7, 70, "Text",
   CellTags->{"parts", "UnixInstalling"},
   CellID->27928],
  Cell[12268, 358, 108, 2, 70, "Subsubsection",
   CellTags->{"parts", "UnixInstalling"},
   CellID->15094],
  Cell[12401, 364, 108, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "mathlink.h", "UnixInstalling"},
   CellID->24332],
  Cell[12512, 368, 681, 17, 70, "Text",
   CellTags->{"parts", "mathlink.h", "UnixInstalling"},
   CellID->21866],
  Cell[13230, 390, 128, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "MathLinkLibraries", "UnixInstalling"},
   CellID->26458],
  Cell[13361, 394, 628, 18, 70, "Text",
   CellTags->{"parts", "MathLinkLibraries", "UnixInstalling"},
   CellID->15266],
  Cell[14854, 446, 97, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "mprep", "UnixInstalling"},
   CellID->9463],
  Cell[14954, 450, 601, 17, 70, "Text",
   CellTags->{"parts", "mprep", "UnixInstalling"},
   CellID->26913],
  Cell[15592, 472, 94, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "mcc", "UnixInstalling"},
   CellID->17431],
  Cell[15689, 476, 324, 11, 70, "Text",
   CellTags->{"parts", "mcc", "UnixInstalling"},
   CellID->1286],
  Cell[16062, 493, 107, 2, 70, "Subsubsection",
   CellTags->{"parts", "UnixInstalling"},
   CellID->13360],
  Cell[16172, 497, 385, 12, 70, "Text",
   CellTags->{"parts", "UnixInstalling"},
   CellID->23166],
  Cell[16594, 514, 116, 2, 70, "Subsubsection",
   CellTags->{"parts", "prebuilt", "UnixInstalling"},
   CellID->28449],
  Cell[16713, 518, 651, 17, 70, "Text",
   CellTags->{"parts", "prebuilt", "UnixInstalling"},
   CellID->29122]},
 "parts"->{
  Cell[11836, 338, 178, 7, 70, "Subsection",
   CellTags->{"parts", "UnixInstalling"},
   CellID->27184],
  Cell[12017, 347, 226, 7, 70, "Text",
   CellTags->{"parts", "UnixInstalling"},
   CellID->27928],
  Cell[12268, 358, 108, 2, 70, "Subsubsection",
   CellTags->{"parts", "UnixInstalling"},
   CellID->15094],
  Cell[12401, 364, 108, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "mathlink.h", "UnixInstalling"},
   CellID->24332],
  Cell[12512, 368, 681, 17, 70, "Text",
   CellTags->{"parts", "mathlink.h", "UnixInstalling"},
   CellID->21866],
  Cell[13230, 390, 128, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "MathLinkLibraries", "UnixInstalling"},
   CellID->26458],
  Cell[13361, 394, 628, 18, 70, "Text",
   CellTags->{"parts", "MathLinkLibraries", "UnixInstalling"},
   CellID->15266],
  Cell[14854, 446, 97, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "mprep", "UnixInstalling"},
   CellID->9463],
  Cell[14954, 450, 601, 17, 70, "Text",
   CellTags->{"parts", "mprep", "UnixInstalling"},
   CellID->26913],
  Cell[15592, 472, 94, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "mcc", "UnixInstalling"},
   CellID->17431],
  Cell[15689, 476, 324, 11, 70, "Text",
   CellTags->{"parts", "mcc", "UnixInstalling"},
   CellID->1286],
  Cell[16062, 493, 107, 2, 70, "Subsubsection",
   CellTags->{"parts", "UnixInstalling"},
   CellID->13360],
  Cell[16172, 497, 385, 12, 70, "Text",
   CellTags->{"parts", "UnixInstalling"},
   CellID->23166],
  Cell[16594, 514, 116, 2, 70, "Subsubsection",
   CellTags->{"parts", "prebuilt", "UnixInstalling"},
   CellID->28449],
  Cell[16713, 518, 651, 17, 70, "Text",
   CellTags->{"parts", "prebuilt", "UnixInstalling"},
   CellID->29122]},
 "mathlink.h"->{
  Cell[12401, 364, 108, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "mathlink.h", "UnixInstalling"},
   CellID->24332],
  Cell[12512, 368, 681, 17, 70, "Text",
   CellTags->{"parts", "mathlink.h", "UnixInstalling"},
   CellID->21866]},
 "MathLinkLibraries"->{
  Cell[13230, 390, 128, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "MathLinkLibraries", "UnixInstalling"},
   CellID->26458],
  Cell[13361, 394, 628, 18, 70, "Text",
   CellTags->{"parts", "MathLinkLibraries", "UnixInstalling"},
   CellID->15266]},
 "mprep"->{
  Cell[14854, 446, 97, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "mprep", "UnixInstalling"},
   CellID->9463],
  Cell[14954, 450, 601, 17, 70, "Text",
   CellTags->{"parts", "mprep", "UnixInstalling"},
   CellID->26913],
  Cell[18900, 593, 163, 7, 70, "Subsection",
   CellTags->{"mprep", "UnixBuilding"},
   CellID->21100],
  Cell[19066, 602, 1442, 39, 70, "Text",
   CellTags->{"mprep", "UnixBuilding"},
   CellID->26637],
  Cell[20511, 643, 94, 2, 70, "Text",
   CellTags->{"mprep", "UnixBuilding"},
   CellID->10909],
  Cell[20608, 647, 230, 7, 70, "Program",
   CellTags->{"mprep", "UnixBuilding"},
   CellID->31750],
  Cell[20841, 656, 617, 15, 70, "Text",
   CellTags->{"mprep", "UnixBuilding"},
   CellID->4654],
  Cell[21461, 673, 162, 3, 70, "Program",
   CellTags->{"mprep", "UnixBuilding"},
   CellID->28540]},
 "mcc"->{
  Cell[15592, 472, 94, 2, 70, "Subsubsubsection",
   CellTags->{"parts", "mcc", "UnixInstalling"},
   CellID->17431],
  Cell[15689, 476, 324, 11, 70, "Text",
   CellTags->{"parts", "mcc", "UnixInstalling"},
   CellID->1286],
  Cell[26389, 801, 83, 2, 70, "Subsection",
   CellTags->{"mcc", "UnixBuilding"},
   CellID->25838],
  Cell[26475, 805, 1194, 36, 70, "Text",
   CellTags->{"mcc", "UnixBuilding"},
   CellID->8081],
  Cell[27672, 843, 225, 7, 70, "Program",
   CellTags->{"mcc", "UnixBuilding"},
   CellID->898]},
 "prebuilt"->{
  Cell[16594, 514, 116, 2, 70, "Subsubsection",
   CellTags->{"parts", "prebuilt", "UnixInstalling"},
   CellID->28449],
  Cell[16713, 518, 651, 17, 70, "Text",
   CellTags->{"parts", "prebuilt", "UnixInstalling"},
   CellID->29122]},
 "UnixBuilding"->{
  Cell[17425, 542, 146, 7, 70, "Section",
   CellTags->"UnixBuilding",
   CellID->32679],
  Cell[17574, 551, 1301, 38, 70, "Text",
   CellTags->"UnixBuilding",
   CellID->10637],
  Cell[18900, 593, 163, 7, 70, "Subsection",
   CellTags->{"mprep", "UnixBuilding"},
   CellID->21100],
  Cell[19066, 602, 1442, 39, 70, "Text",
   CellTags->{"mprep", "UnixBuilding"},
   CellID->26637],
  Cell[20511, 643, 94, 2, 70, "Text",
   CellTags->{"mprep", "UnixBuilding"},
   CellID->10909],
  Cell[20608, 647, 230, 7, 70, "Program",
   CellTags->{"mprep", "UnixBuilding"},
   CellID->31750],
  Cell[20841, 656, 617, 15, 70, "Text",
   CellTags->{"mprep", "UnixBuilding"},
   CellID->4654],
  Cell[21461, 673, 162, 3, 70, "Program",
   CellTags->{"mprep", "UnixBuilding"},
   CellID->28540],
  Cell[21660, 681, 149, 7, 70, "Subsection",
   CellTags->"UnixBuilding",
   CellID->31597],
  Cell[21812, 690, 650, 18, 70, "Text",
   CellTags->"UnixBuilding",
   CellID->8827],
  Cell[22465, 710, 99, 2, 70, "Program",
   CellTags->"UnixBuilding",
   CellID->26979],
  Cell[22589, 716, 84, 2, 70, "Subsubsection",
   CellTags->"UnixBuilding",
   CellID->19046],
  Cell[22676, 720, 2114, 34, 70, "Program",
   CellTags->"UnixBuilding",
   CellID->2139],
  Cell[26389, 801, 83, 2, 70, "Subsection",
   CellTags->{"mcc", "UnixBuilding"},
   CellID->25838],
  Cell[26475, 805, 1194, 36, 70, "Text",
   CellTags->{"mcc", "UnixBuilding"},
   CellID->8081],
  Cell[27672, 843, 225, 7, 70, "Program",
   CellTags->{"mcc", "UnixBuilding"},
   CellID->898]},
 "UnixRunning"->{
  Cell[27946, 856, 142, 7, 70, "Section",
   CellTags->"UnixRunning",
   CellID->763],
  Cell[30855, 938, 188, 7, 70, "Subsection",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->24335],
  Cell[31046, 947, 1387, 40, 70, "Text",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->19616],
  Cell[32436, 989, 503, 7, 70, "Program",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->31857],
  Cell[32942, 998, 149, 4, 70, "MathCaption",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->10980],
  Cell[33094, 1004, 277, 7, 70, "Input",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->12166],
  Cell[33374, 1013, 165, 4, 70, "Input",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->21661],
  Cell[33542, 1019, 161, 4, 70, "MathCaption",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->25491],
  Cell[33706, 1025, 122, 3, 70, "Input",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->13933],
  Cell[33831, 1030, 300, 8, 70, "MathCaption",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->3929],
  Cell[34134, 1040, 103, 3, 70, "Input",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->24085],
  Cell[34240, 1045, 88, 2, 70, "MathCaption",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->15250],
  Cell[34331, 1049, 139, 4, 70, "Input",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->891],
  Cell[34896, 1069, 217, 8, 70, "Input",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->23288],
  Cell[35310, 1086, 195, 7, 70, "Input",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->786],
  Cell[35653, 1102, 178, 5, 70, "Input",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->12559],
  Cell[35834, 1109, 620, 20, 70, "MathCaption",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->6910],
  Cell[36457, 1131, 104, 3, 70, "Input",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->26226],
  Cell[36564, 1136, 138, 3, 70, "MathCaption",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->21290],
  Cell[36705, 1141, 119, 3, 70, "Input",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->21241],
  Cell[36861, 1149, 196, 7, 70, "Subsection",
   CellTags->{"factor", "UnixRunning"},
   CellID->10264],
  Cell[37060, 1158, 614, 16, 70, "Text",
   CellTags->{"factor", "UnixRunning"},
   CellID->30666],
  Cell[37677, 1176, 231, 6, 70, "Text",
   CellTags->{"factor", "UnixRunning"},
   CellID->30074],
  Cell[37911, 1184, 151, 3, 70, "Program",
   CellTags->{"factor", "UnixRunning"},
   CellID->26692],
  Cell[38065, 1189, 352, 8, 70, "Text",
   CellTags->{"factor", "UnixRunning"},
   CellID->30148],
  Cell[38420, 1199, 117, 2, 70, "Program",
   CellTags->{"factor", "UnixRunning"},
   CellID->24412],
  Cell[38540, 1203, 350, 12, 70, "Text",
   CellTags->{"factor", "UnixRunning"},
   CellID->24892],
  Cell[38893, 1217, 154, 3, 70, "Program",
   CellTags->{"factor", "UnixRunning"},
   CellID->216],
  Cell[39084, 1225, 103, 2, 70, "Subsection",
   CellTags->{"protocols", "UnixRunning"},
   CellID->20158],
  Cell[39190, 1229, 1794, 59, 70, "Text",
   CellTags->{"protocols", "UnixRunning"},
   CellID->18827],
  Cell[40987, 1290, 720, 26, 70, "Text",
   CellTags->{"protocols", "UnixRunning"},
   CellID->11159]},
 "WindowsRunning"->{
  Cell[28091, 865, 962, 24, 70, "Text",
   CellTags->"WindowsRunning",
   CellID->16696],
  Cell[29056, 891, 1774, 43, 70, "Text",
   CellTags->"WindowsRunning",
   CellID->6894]},
 "addtwo"->{
  Cell[30855, 938, 188, 7, 70, "Subsection",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->24335],
  Cell[31046, 947, 1387, 40, 70, "Text",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->19616],
  Cell[32436, 989, 503, 7, 70, "Program",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->31857],
  Cell[32942, 998, 149, 4, 70, "MathCaption",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->10980],
  Cell[33094, 1004, 277, 7, 70, "Input",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->12166],
  Cell[33374, 1013, 165, 4, 70, "Input",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->21661],
  Cell[33542, 1019, 161, 4, 70, "MathCaption",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->25491],
  Cell[33706, 1025, 122, 3, 70, "Input",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->13933],
  Cell[33831, 1030, 300, 8, 70, "MathCaption",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->3929],
  Cell[34134, 1040, 103, 3, 70, "Input",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->24085],
  Cell[34240, 1045, 88, 2, 70, "MathCaption",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->15250],
  Cell[34331, 1049, 139, 4, 70, "Input",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->891],
  Cell[34896, 1069, 217, 8, 70, "Input",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->23288],
  Cell[35310, 1086, 195, 7, 70, "Input",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->786],
  Cell[35653, 1102, 178, 5, 70, "Input",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->12559],
  Cell[35834, 1109, 620, 20, 70, "MathCaption",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->6910],
  Cell[36457, 1131, 104, 3, 70, "Input",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->26226],
  Cell[36564, 1136, 138, 3, 70, "MathCaption",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->21290],
  Cell[36705, 1141, 119, 3, 70, "Input",
   CellTags->{"addtwo", "UnixRunning"},
   CellID->21241]},
 "factor"->{
  Cell[36861, 1149, 196, 7, 70, "Subsection",
   CellTags->{"factor", "UnixRunning"},
   CellID->10264],
  Cell[37060, 1158, 614, 16, 70, "Text",
   CellTags->{"factor", "UnixRunning"},
   CellID->30666],
  Cell[37677, 1176, 231, 6, 70, "Text",
   CellTags->{"factor", "UnixRunning"},
   CellID->30074],
  Cell[37911, 1184, 151, 3, 70, "Program",
   CellTags->{"factor", "UnixRunning"},
   CellID->26692],
  Cell[38065, 1189, 352, 8, 70, "Text",
   CellTags->{"factor", "UnixRunning"},
   CellID->30148],
  Cell[38420, 1199, 117, 2, 70, "Program",
   CellTags->{"factor", "UnixRunning"},
   CellID->24412],
  Cell[38540, 1203, 350, 12, 70, "Text",
   CellTags->{"factor", "UnixRunning"},
   CellID->24892],
  Cell[38893, 1217, 154, 3, 70, "Program",
   CellTags->{"factor", "UnixRunning"},
   CellID->216]},
 "protocols"->{
  Cell[39084, 1225, 103, 2, 70, "Subsection",
   CellTags->{"protocols", "UnixRunning"},
   CellID->20158],
  Cell[39190, 1229, 1794, 59, 70, "Text",
   CellTags->{"protocols", "UnixRunning"},
   CellID->18827],
  Cell[40987, 1290, 720, 26, 70, "Text",
   CellTags->{"protocols", "UnixRunning"},
   CellID->11159]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"UnixIntroduction", 51347, 1615},
 {"UnixInstalling", 51733, 1628},
 {"parts", 54187, 1698},
 {"mathlink.h", 55914, 1744},
 {"MathLinkLibraries", 56180, 1751},
 {"mprep", 56448, 1758},
 {"mcc", 57289, 1783},
 {"prebuilt", 57825, 1799},
 {"UnixBuilding", 58079, 1806},
 {"UnixRunning", 59628, 1855},
 {"WindowsRunning", 62793, 1949},
 {"addtwo", 62987, 1956},
 {"factor", 64935, 2014},
 {"protocols", 65759, 2039}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3949, 81, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4574, 108, 159, 6, 70, "Title",
 CellTags->"UnixIntroduction",
 CellID->10708],
Cell[4736, 116, 756, 25, 70, "Text",
 CellTags->"UnixIntroduction",
 CellID->10820],
Cell[5495, 143, 505, 13, 70, "Text",
 CellTags->"UnixIntroduction",
 CellID->22266],
Cell[6003, 158, 371, 10, 70, "Text",
 CellTags->"UnixIntroduction",
 CellID->25069],
Cell[CellGroupData[{
Cell[6399, 172, 70, 1, 70, "Section",
 CellID->725481284],
Cell[6472, 175, 288, 8, 70, "Text",
 CellID->1713067304],
Cell[6763, 185, 227, 5, 70, "Text",
 CellID->208922999],
Cell[6993, 192, 1829, 31, 70, "3ColumnTableMod",
 CellID->2090248064]
}, Open  ]],
Cell[CellGroupData[{
Cell[8859, 228, 156, 7, 70, "Section",
 CellTags->"UnixInstalling",
 CellID->26966],
Cell[9018, 237, 360, 13, 70, "Text",
 CellTags->"UnixInstalling",
 CellID->11099],
Cell[CellGroupData[{
Cell[9403, 254, 90, 2, 70, "Subsection",
 CellTags->"UnixInstalling",
 CellID->4756],
Cell[CellGroupData[{
Cell[9518, 260, 100, 2, 70, "Subsubsection",
 CellTags->"UnixInstalling",
 CellID->20609],
Cell[9621, 264, 1014, 30, 70, "Text",
 CellTags->"UnixInstalling",
 CellID->2466],
Cell[10638, 296, 843, 21, 70, "Text",
 CellTags->"UnixInstalling",
 CellID->23668]
}, Open  ]],
Cell[CellGroupData[{
Cell[11518, 322, 98, 2, 70, "Subsubsection",
 CellTags->"UnixInstalling",
 CellID->9359],
Cell[11619, 326, 168, 6, 70, "Text",
 CellTags->"UnixInstalling",
 CellID->6395]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11836, 338, 178, 7, 70, "Subsection",
 CellTags->{"parts", "UnixInstalling"},
 CellID->27184],
Cell[12017, 347, 226, 7, 70, "Text",
 CellTags->{"parts", "UnixInstalling"},
 CellID->27928],
Cell[CellGroupData[{
Cell[12268, 358, 108, 2, 70, "Subsubsection",
 CellTags->{"parts", "UnixInstalling"},
 CellID->15094],
Cell[CellGroupData[{
Cell[12401, 364, 108, 2, 70, "Subsubsubsection",
 CellTags->{"parts", "mathlink.h", "UnixInstalling"},
 CellID->24332],
Cell[12512, 368, 681, 17, 70, "Text",
 CellTags->{"parts", "mathlink.h", "UnixInstalling"},
 CellID->21866]
}, Open  ]],
Cell[CellGroupData[{
Cell[13230, 390, 128, 2, 70, "Subsubsubsection",
 CellTags->{"parts", "MathLinkLibraries", "UnixInstalling"},
 CellID->26458],
Cell[13361, 394, 628, 18, 70, "Text",
 CellTags->{"parts", "MathLinkLibraries", "UnixInstalling"},
 CellID->15266]
}, Open  ]],
Cell[CellGroupData[{
Cell[14026, 417, 87, 1, 70, "Subsubsubsection",
 CellID->1736540090],
Cell[14116, 420, 701, 21, 70, "Text",
 CellID->1726529900]
}, Open  ]],
Cell[CellGroupData[{
Cell[14854, 446, 97, 2, 70, "Subsubsubsection",
 CellTags->{"parts", "mprep", "UnixInstalling"},
 CellID->9463],
Cell[14954, 450, 601, 17, 70, "Text",
 CellTags->{"parts", "mprep", "UnixInstalling"},
 CellID->26913]
}, Open  ]],
Cell[CellGroupData[{
Cell[15592, 472, 94, 2, 70, "Subsubsubsection",
 CellTags->{"parts", "mcc", "UnixInstalling"},
 CellID->17431],
Cell[15689, 476, 324, 11, 70, "Text",
 CellTags->{"parts", "mcc", "UnixInstalling"},
 CellID->1286]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16062, 493, 107, 2, 70, "Subsubsection",
 CellTags->{"parts", "UnixInstalling"},
 CellID->13360],
Cell[16172, 497, 385, 12, 70, "Text",
 CellTags->{"parts", "UnixInstalling"},
 CellID->23166]
}, Open  ]],
Cell[CellGroupData[{
Cell[16594, 514, 116, 2, 70, "Subsubsection",
 CellTags->{"parts", "prebuilt", "UnixInstalling"},
 CellID->28449],
Cell[16713, 518, 651, 17, 70, "Text",
 CellTags->{"parts", "prebuilt", "UnixInstalling"},
 CellID->29122]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17425, 542, 146, 7, 70, "Section",
 CellTags->"UnixBuilding",
 CellID->32679],
Cell[17574, 551, 1301, 38, 70, "Text",
 CellTags->"UnixBuilding",
 CellID->10637],
Cell[CellGroupData[{
Cell[18900, 593, 163, 7, 70, "Subsection",
 CellTags->{"mprep", "UnixBuilding"},
 CellID->21100],
Cell[19066, 602, 1442, 39, 70, "Text",
 CellTags->{"mprep", "UnixBuilding"},
 CellID->26637],
Cell[20511, 643, 94, 2, 70, "Text",
 CellTags->{"mprep", "UnixBuilding"},
 CellID->10909],
Cell[20608, 647, 230, 7, 70, "Program",
 CellTags->{"mprep", "UnixBuilding"},
 CellID->31750],
Cell[20841, 656, 617, 15, 70, "Text",
 CellTags->{"mprep", "UnixBuilding"},
 CellID->4654],
Cell[21461, 673, 162, 3, 70, "Program",
 CellTags->{"mprep", "UnixBuilding"},
 CellID->28540]
}, Open  ]],
Cell[CellGroupData[{
Cell[21660, 681, 149, 7, 70, "Subsection",
 CellTags->"UnixBuilding",
 CellID->31597],
Cell[21812, 690, 650, 18, 70, "Text",
 CellTags->"UnixBuilding",
 CellID->8827],
Cell[22465, 710, 99, 2, 70, "Program",
 CellTags->"UnixBuilding",
 CellID->26979],
Cell[CellGroupData[{
Cell[22589, 716, 84, 2, 70, "Subsubsection",
 CellTags->"UnixBuilding",
 CellID->19046],
Cell[22676, 720, 2114, 34, 70, "Program",
 CellTags->"UnixBuilding",
 CellID->2139],
Cell[24793, 756, 210, 7, 70, "Reference",
 CellID->183585510],
Cell[25006, 765, 1334, 30, 70, "2ColumnTableMod",
 CellID->914669408]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26389, 801, 83, 2, 70, "Subsection",
 CellTags->{"mcc", "UnixBuilding"},
 CellID->25838],
Cell[26475, 805, 1194, 36, 70, "Text",
 CellTags->{"mcc", "UnixBuilding"},
 CellID->8081],
Cell[27672, 843, 225, 7, 70, "Program",
 CellTags->{"mcc", "UnixBuilding"},
 CellID->898]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27946, 856, 142, 7, 70, "Section",
 CellTags->"UnixRunning",
 CellID->763],
Cell[28091, 865, 962, 24, 70, "Text",
 CellTags->"WindowsRunning",
 CellID->16696],
Cell[29056, 891, 1774, 43, 70, "Text",
 CellTags->"WindowsRunning",
 CellID->6894],
Cell[CellGroupData[{
Cell[30855, 938, 188, 7, 70, "Subsection",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->24335],
Cell[31046, 947, 1387, 40, 70, "Text",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->19616],
Cell[32436, 989, 503, 7, 70, "Program",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->31857],
Cell[32942, 998, 149, 4, 70, "MathCaption",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->10980],
Cell[33094, 1004, 277, 7, 70, "Input",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->12166],
Cell[33374, 1013, 165, 4, 70, "Input",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->21661],
Cell[33542, 1019, 161, 4, 70, "MathCaption",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->25491],
Cell[33706, 1025, 122, 3, 70, "Input",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->13933],
Cell[33831, 1030, 300, 8, 70, "MathCaption",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->3929],
Cell[34134, 1040, 103, 3, 70, "Input",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->24085],
Cell[34240, 1045, 88, 2, 70, "MathCaption",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->15250],
Cell[34331, 1049, 139, 4, 70, "Input",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->891],
Cell[34473, 1055, 420, 12, 70, "MathCaption",
 CellID->988991036],
Cell[34896, 1069, 217, 8, 70, "Input",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->23288],
Cell[35116, 1079, 191, 5, 70, "MathCaption",
 CellID->448914272],
Cell[35310, 1086, 195, 7, 70, "Input",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->786],
Cell[35508, 1095, 142, 5, 70, "MathCaption",
 CellID->792117593],
Cell[35653, 1102, 178, 5, 70, "Input",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->12559],
Cell[35834, 1109, 620, 20, 70, "MathCaption",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->6910],
Cell[36457, 1131, 104, 3, 70, "Input",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->26226],
Cell[36564, 1136, 138, 3, 70, "MathCaption",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->21290],
Cell[36705, 1141, 119, 3, 70, "Input",
 CellTags->{"addtwo", "UnixRunning"},
 CellID->21241]
}, Open  ]],
Cell[CellGroupData[{
Cell[36861, 1149, 196, 7, 70, "Subsection",
 CellTags->{"factor", "UnixRunning"},
 CellID->10264],
Cell[37060, 1158, 614, 16, 70, "Text",
 CellTags->{"factor", "UnixRunning"},
 CellID->30666],
Cell[37677, 1176, 231, 6, 70, "Text",
 CellTags->{"factor", "UnixRunning"},
 CellID->30074],
Cell[37911, 1184, 151, 3, 70, "Program",
 CellTags->{"factor", "UnixRunning"},
 CellID->26692],
Cell[38065, 1189, 352, 8, 70, "Text",
 CellTags->{"factor", "UnixRunning"},
 CellID->30148],
Cell[38420, 1199, 117, 2, 70, "Program",
 CellTags->{"factor", "UnixRunning"},
 CellID->24412],
Cell[38540, 1203, 350, 12, 70, "Text",
 CellTags->{"factor", "UnixRunning"},
 CellID->24892],
Cell[38893, 1217, 154, 3, 70, "Program",
 CellTags->{"factor", "UnixRunning"},
 CellID->216]
}, Open  ]],
Cell[CellGroupData[{
Cell[39084, 1225, 103, 2, 70, "Subsection",
 CellTags->{"protocols", "UnixRunning"},
 CellID->20158],
Cell[39190, 1229, 1794, 59, 70, "Text",
 CellTags->{"protocols", "UnixRunning"},
 CellID->18827],
Cell[40987, 1290, 720, 26, 70, "Text",
 CellTags->{"protocols", "UnixRunning"},
 CellID->11159]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41756, 1322, 50, 1, 70, "Section",
 CellID->20042],
Cell[41809, 1325, 522, 9, 70, "BulletedText",
 CellID->2839],
Cell[42334, 1336, 469, 17, 70, "BulletedText",
 CellID->10163],
Cell[42806, 1355, 734, 21, 70, "BulletedText",
 CellID->21448],
Cell[43543, 1378, 630, 17, 70, "BulletedText",
 CellID->6396],
Cell[CellGroupData[{
Cell[44198, 1399, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->162458548],
Cell[44267, 1402, 309, 9, 70, "TutorialMoreAbout",
 CellID->558589989],
Cell[44579, 1413, 313, 9, 70, "TutorialMoreAbout",
 CellID->40858578],
Cell[44895, 1424, 336, 9, 70, "TutorialMoreAbout",
 CellID->8146795],
Cell[45234, 1435, 359, 9, 70, "TutorialMoreAbout",
 CellID->424932163],
Cell[45596, 1446, 348, 9, 70, "TutorialMoreAbout",
 CellID->2262398],
Cell[45947, 1457, 401, 11, 70, "TutorialMoreAbout",
 CellID->101684538],
Cell[46351, 1470, 338, 9, 70, "TutorialMoreAbout",
 CellID->655130],
Cell[46692, 1481, 347, 9, 70, "TutorialMoreAbout",
 CellID->148916145],
Cell[47042, 1492, 347, 9, 70, "TutorialMoreAbout",
 CellID->182367630],
Cell[47392, 1503, 327, 9, 70, "TutorialMoreAbout",
 CellID->113882963],
Cell[47722, 1514, 272, 9, 70, "TutorialMoreAbout",
 CellID->5094559],
Cell[47997, 1525, 457, 12, 70, "TutorialMoreAbout",
 CellID->246479563]
}, Open  ]],
Cell[CellGroupData[{
Cell[48491, 1542, 72, 1, 70, "RelatedTutorialsSection",
 CellID->204472993],
Cell[48566, 1545, 338, 9, 70, "RelatedTutorials",
 CellID->403767969],
Cell[48907, 1556, 333, 9, 70, "RelatedTutorials",
 CellID->441486358]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[49279, 1570, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

