(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     48059,       1221]
NotebookOptionsPosition[     44394,       1120]
NotebookOutlinePosition[     46348,       1165]
CellTagsIndexPosition[     46305,       1162]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Interface 3"
}], "Title",
 CellID->509267359],

Cell["\<\
The library now fully supports the Unicode character encoding forms UTF-8, \
UTF-16, and UTF-32. Use the following new API functions to put or get Unicode \
characters to or from a link.\
\>", "Text",
 CellID->1534169418],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutUTF8String",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutUTF8String"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetUTF8String",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetUTF8String"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutUTF16String",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutUTF16String"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetUTF16String",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetUTF16String"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutUTF32String",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutUTF32String"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetUTF32String",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetUTF32String"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutUTF8Symbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutUTF8Symbol"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetUTF8Symbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetUTF8Symbol"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutUTF16Symbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutUTF16Symbol"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetUTF16Symbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetUTF16Symbol"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutUTF32Symbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutUTF32Symbol"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetUTF32Symbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetUTF32Symbol"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLReleaseUTF8String",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLReleaseUTF8String"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLReleaseUTF8Symbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLReleaseUTF8Symbol"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLReleaseUTF16String",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLReleaseUTF16String"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLReleaseUTF16Symbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLReleaseUTF16Symbol"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLReleaseUTF32String",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLReleaseUTF32String"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLReleaseUTF32Symbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLReleaseUTF32Symbol"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True, True}}}},
 CellID->423544577],

Cell[TextData[{
 "The ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 " no longer contains obsolete platform support sections such as those \
defined by ",
 StyleBox["MACINTOSH_MATHLINK", "InlineCode"],
 " or ",
 StyleBox["OS2_MATHLINK", "InlineCode"],
 ". ",
 StyleBox["MACINTOSH_MATHLINK", "InlineCode"],
 " definitions referred to MacOS 9 and earlier.",
 " ",
 StyleBox["DARWIN_MATHLINK", "InlineCode"],
 " contains all platform specific definitions for Mac OS X."
}], "Text",
 CellID->1202276477],

Cell[TextData[{
 "All uses of special alternative names for common C types have been removed \
from the API.",
 " ",
 "The ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 " still contains versions of the API functions with these types for use with \
Interface 2 and older programs."
}], "Text",
 CellID->1945580710],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"Previous", " ", "MathLink", " ", "type"}], Cell[
    "C type", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["uchar_ct", "InlineCode"], Cell[TextData[StyleBox[
    "unsigned char", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["ucharp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "unsigned char *", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["ucharpp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "unsigned char **", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["ucharppp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "unsigned char ***", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["ushort_ct", "InlineCode"], Cell[TextData[StyleBox[
    "unsigned short", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["ushortp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "unsigned short *", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["ushortpp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "unsigned short **", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["ushortppp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "unsigned short ***", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["uint_ct", "InlineCode"], Cell[TextData[StyleBox[
    "unsigned int", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["uintp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "unsigned int *", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["uintpp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "unsigned int **", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["int_ct", "InlineCode"], Cell[TextData[StyleBox[
    "int", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["voidp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "void *", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["voidpp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "void **", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["charp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "char *", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["charpp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "char **", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["charppp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "char ***", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["long_ct", "InlineCode"], Cell[TextData[StyleBox[
    "long", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["longp_ct", "InlineCode"], Cell["long *", "InlineCode"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["longpp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "long **", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["long_st", "InlineCode"], Cell[TextData[StyleBox[
    "long", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["longp_st", "InlineCode"], Cell[TextData[StyleBox[
    "long *", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["longpp_st", "InlineCode"], Cell[TextData[StyleBox[
    "long **", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["ulong_ct", "InlineCode"], Cell[TextData[StyleBox[
    "unsigned long", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["ulongp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "unsigned long *", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["kushortp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "const unsigned short *", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["kushortpp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "const unsigned short **", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["kuintp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "const unsigned int *", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["kuintpp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "const unsigned int **", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["kucharp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "const unsigned char *", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["kucharpp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "const unsigned char **", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["kcharp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "const char *", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["kcharpp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "const char **", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["kvoidp_ct", "InlineCode"], Cell[TextData[StyleBox[
    "const void *", "InlineCode"]], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->1788983748],

Cell[TextData[{
 "The memory allocator/deallocator functions passed to the library using ",
 StyleBox[ButtonBox["MLSetAllocParameter",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLSetAllocParameter"], "InlineCode"],
 StyleBox["()", "InlineCode"],
 " now must be thread-safe."
}], "Text",
 CellID->531310989],

Cell[TextData[{
 "API functions that previously took a ",
 StyleBox["MLParametersPointer", "InlineCode"],
 " type as an argument or returned a MLParametersPointer type now instead \
take or return a ",
 StyleBox["char *", "InlineCode"],
 " type."
}], "Text",
 CellID->987114316],

Cell[TextData[{
 "API functions that take as an argument or return a ",
 StyleBox["mlapi_result", "InlineCode"],
 " type now take or return type ",
 StyleBox["int", "InlineCode"],
 "."
}], "Text",
 CellID->1119135937],

Cell[TextData[{
 "API functions that take as an argument or return a ",
 StyleBox["mlapi_error", "InlineCode"],
 " type now take or return type ",
 StyleBox["int", "InlineCode"],
 "."
}], "Text",
 CellID->1655912733],

Cell[TextData[{
 "API functions that take as an argument or return a ",
 StyleBox["mlapi_token", "InlineCode"],
 " type now take or return return type ",
 StyleBox["int", "InlineCode"],
 "."
}], "Text",
 CellID->1684722058],

Cell[TextData[{
 "API functions that take as an argument or return a ",
 StyleBox["mlapi_packet", "InlineCode"],
 " type now take or return type ",
 StyleBox["int", "InlineCode"],
 "."
}], "Text",
 CellID->551743111],

Cell[TextData[{
 "API functions that take as an argument or return a ",
 StyleBox["MLPointer", "InlineCode"],
 " type now take or return ",
 StyleBox["void *", "InlineCode"],
 "."
}], "Text",
 CellID->312078831],

Cell[TextData[{
 "The ",
 StyleBox["MLOpen*", "InlineCode"],
 " functions previously took type ",
 StyleBox["long *", "InlineCode"],
 " for the error variable but now take type ",
 StyleBox["int *", "InlineCode"],
 "."
}], "Text",
 CellID->953846643],

Cell[TextData[{
 "The header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 " now contains several new error definitions related to the Unicode \
character encoding forms."
}], "Text",
 CellID->335104046],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"Error", " ", "code"}], Cell["Interpretation", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["MLEPDATABAD", "InlineCode"], Cell["\<\
MathLink encountered invalid character data in given character encoding.\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["MLEPSCONVERT", "InlineCode"], Cell["\<\
Unable to convert from given character encoding to MathLink encoding.\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["MLEGSCONVERT", "InlineCode"], Cell["\<\
Unable to convert from MathLink encoding to requested character encoding\
\>", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->664040877],

Cell[TextData[{
 StyleBox[ButtonBox["MLPutMessage",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutMessage"], "InlineCode"],
 StyleBox["()", "InlineCode"],
 " and ",
 StyleBox[ButtonBox["MLGetMessage",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetMessage"], "InlineCode"],
 StyleBox["()", "InlineCode"],
 " now use types ",
 StyleBox["int", "InlineCode"],
 " and ",
 StyleBox["int *", "InlineCode"],
 " respectively instead of the ",
 StyleBox["dev_message", "InlineCode"],
 " and ",
 StyleBox["dev_message *", "InlineCode"],
 " types."
}], "Text",
 CellID->1391578688],

Cell[TextData[{
 StyleBox[ButtonBox["MLSeekMark",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLSeekMark"], "InlineCode"],
 StyleBox["()", "InlineCode"],
 " and ",
 StyleBox[ButtonBox["MLSeekToMark",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLSeekToMark"], "InlineCode"],
 StyleBox["()", "InlineCode"],
 " now use type ",
 StyleBox["int", "InlineCode"],
 " rather than type ",
 StyleBox["long", "InlineCode"],
 " for the expression index."
}], "Text",
 CellID->18609739],

Cell[TextData[{
 "The functions in the following table took ",
 StyleBox["long", "InlineCode"],
 " types for some arguments; they now take ",
 StyleBox["int", "InlineCode"],
 "."
}], "Text",
 CellID->1752899481],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLGetRawData()", "InlineCode"]], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetData",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetData"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetArgCount",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetArgCount"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[StyleBox[
    "MLGetRawArgCount()", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLBytesToGet",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLBytesToGet"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[StyleBox[
    "MLRawBytesToGet()", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLExpressionsToGet()", "InlineCode"]], "TableText"], Cell[TextData[
    StyleBox["MLTakeLast()", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutRawSize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutRawSize"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutRawData",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutRawData"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutArgCount",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutArgCount"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[StyleBox[
    "MLPutComposite()", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLBytesToPut",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLBytesToPut"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], ""}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->1800907621],

Cell[TextData[{
 StyleBox[ButtonBox["MLGetReal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetReal"], "InlineCode"],
 StyleBox["()", "InlineCode"],
 " is now an actual API function rather than a ",
 StyleBox["#define", "InlineCode"],
 " alias to ",
 StyleBox[ButtonBox["MLGetDouble",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetDouble"], "InlineCode"],
 StyleBox["()", "InlineCode"],
 ".",
 " ",
 StyleBox[ButtonBox["MLGetReal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetReal"], "InlineCode"],
 StyleBox["()", "InlineCode"],
 " still has the same functionality as ",
 StyleBox[ButtonBox["MLGetDouble",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetDouble"], "InlineCode"],
 StyleBox["()", "InlineCode"],
 "."
}], "Text",
 CellID->1219865329],

Cell[TextData[{
 StyleBox[ButtonBox["MLActivate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLActivate"], "InlineCode"],
 StyleBox["()", "InlineCode"],
 " is now an actual API function rather than a ",
 StyleBox["#define", "InlineCode"],
 " alias to ",
 StyleBox["MLConnect()", "InlineCode"],
 ".",
 " ",
 StyleBox[ButtonBox["MLActivate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLActivate"], "InlineCode"],
 StyleBox["()", "InlineCode"],
 " still has the same functionality as ",
 StyleBox["MLConnect()", "InlineCode"],
 "."
}], "Text",
 CellID->250206594],

Cell["\<\
The functions in column one listed below are now obsolete. New programs \
should use the functions listed in column two for replacement functionality.\
\>", "Text",
 CellID->449244532],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLCheckFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLCheckFunction"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLTestHead",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLTestHead"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLCheckFunctionWithArg()", "InlineCode"]], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLTestHead",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLTestHead"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetShortInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetShortInteger"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetInteger16",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetInteger16"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetInteger"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetInteger32",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetInteger32"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetLongInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetLongInteger"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetInteger64",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetInteger64"], "InlineCode"],
     StyleBox["()", "InlineCode"],
     " for 64-bit integers or ",
     StyleBox[ButtonBox["MLGetInteger32",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetInteger32"], "InlineCode"],
     StyleBox["()", "InlineCode"],
     " for 32-bit integers"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetFloat",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetFloat"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetReal32",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetReal32"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetDouble",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetDouble"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetReal64",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetReal64"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLGetLongDouble()", "InlineCode"]], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetReal128",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetReal128"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLGetShortIntegerArrayData()", "InlineCode"]], "TableText"], Cell[
    TextData[StyleBox[
    "MLGetInteger16ArrayData()", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLGetIntegerArrayData()", "InlineCode"]], "TableText"], Cell[TextData[
    StyleBox["MLGetInteger32ArrayData()", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLGetLongIntegerArrayData()", "InlineCode"]], "TableText"], Cell[
    TextData[{
     StyleBox["MLGetInteger64ArrayData()", "InlineCode"],
     " for 64-bit integers or ",
     StyleBox["MLGetInteger32ArrayData()", "InlineCode"],
     " for 32-bit integers"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLGetFloatArrayData()", "InlineCode"]], "TableText"], Cell[TextData[
    StyleBox["MLGetReal32ArrayData()", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLGetDoubleArrayData()", "InlineCode"]], "TableText"], Cell[TextData[
    StyleBox["MLGetReal64ArrayData()", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLGetLongDoubleArrayData()", "InlineCode"]], "TableText"], Cell[TextData[
    StyleBox["MLGetReal128ArrayData()", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLGetShortIntegerArray()", "InlineCode"]], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetInteger16Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetInteger16Array"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetIntegerArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetIntegerArray"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetInteger32Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetInteger32Array"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLGetLongIntegerArray()", "InlineCode"]], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetInteger64Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetInteger64Array"], "InlineCode"],
     StyleBox["()", "InlineCode"],
     " for 64-bit integers or ",
     StyleBox[ButtonBox["MLGetInteger32Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetInteger32Array"], "InlineCode"],
     StyleBox["()", "InlineCode"],
     " for 32-bit integers"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLGetFloatArray()", "InlineCode"]], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetReal32Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetReal32Array"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLGetDoubleArray()", "InlineCode"]], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetReal64Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetReal64Array"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLGetLongDoubleArray()", "InlineCode"]], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetReal128Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetReal128Array"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLDisownShortIntegerArray()", "InlineCode"]], "TableText"], Cell[
    TextData[{
     StyleBox[ButtonBox["MLReleaseInteger16Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLReleaseInteger16Array"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLDisownIntegerArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLDisownIntegerArray"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLReleaseInteger32Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLReleaseInteger32Array"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLDisownLongIntegerArray()", "InlineCode"]], "TableText"], Cell[
    TextData[{
     StyleBox[ButtonBox["MLReleaseInteger64Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLReleaseInteger64Array"], "InlineCode"],
     StyleBox["()", "InlineCode"],
     " for 64-bit integers or ",
     StyleBox[ButtonBox["MLReleaseInteger32Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLReleaseInteger32Array"], "InlineCode"],
     StyleBox["()", "InlineCode"],
     " for 32-bit integers"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLDisownFloatArray()", "InlineCode"]], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLReleaseReal32Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLReleaseReal32Array"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLDisownDoubleArray()", "InlineCode"]], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLReleaseReal64Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLReleaseReal64Array"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLDisownLongDoubleArray()", "InlineCode"]], "TableText"], Cell[
    TextData[{
     StyleBox[ButtonBox["MLReleaseReal128Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLReleaseReal128Array"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetIntegerList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetIntegerList"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetInteger32List",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetInteger32List"], "InlineCode"],
     StyleBox["(()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetRealList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetRealList"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetReal64List",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetReal64List"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLDisownIntegerList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLDisownIntegerList"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLReleaseInteger32List",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLReleaseInteger32List"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLDisownRealList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLDisownRealList"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLReleaseReal64List",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLReleaseReal64List"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True}}}},
 CellID->2047830119],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutShortInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutShortInteger"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutInteger16",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutInteger16"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutInteger"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutInteger32",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutInteger32"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutLongInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutLongInteger"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutInteger64",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutInteger64"], "InlineCode"],
     StyleBox["()", "InlineCode"],
     " for 64-bit integers or ",
     StyleBox[ButtonBox["MLPutInteger32",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutInteger32"], "InlineCode"],
     StyleBox["()", "InlineCode"],
     " for 32-bit integers"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutFloat",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutFloat"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutReal32",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutReal32"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutDouble",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutDouble"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutReal64",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutReal64"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLPutLongDouble()", "InlineCode"]], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutReal128",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutReal128"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLPutShortIntegerArrayData()", "InlineCode"]], "TableText"], Cell[
    TextData[StyleBox[
    "MLPutInteger16ArrayData()", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLPutIntegerArrayData()", "InlineCode"]], "TableText"], Cell[TextData[
    StyleBox["MLPutInteger32ArrayData()", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLPutLongIntegerArrayData()", "InlineCode"]], "TableText"], Cell[
    TextData[{
     StyleBox["MLPutInteger64ArrayData()", "InlineCode"],
     " for 64-bit integers or ",
     StyleBox["MLPutInteger32ArrayData()", "InlineCode"],
     " for 32-bit integers"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLPutFloatArrayData()", "InlineCode"]], "TableText"], Cell[TextData[
    StyleBox["MLPutReal32ArrayData()", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLPutDoubleArrayData()", "InlineCode"]], "TableText"], Cell[TextData[
    StyleBox["MLPutReal64ArrayData()", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLPutLongDoubleArrayData()", "InlineCode"]], "TableText"], Cell[TextData[
    StyleBox["MLPutReal128ArrayData()", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLPutShortIntegerArray()", "InlineCode"]], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutInteger16Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutInteger16Array"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLPutIntegerArray()", "InlineCode"]], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutInteger32Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutInteger32Array"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLPutLongIntegerArray()", "InlineCode"]], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutInteger64Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutInteger64Array"], "InlineCode"],
     StyleBox["()", "InlineCode"],
     " for 64-bit integers or ",
     StyleBox[ButtonBox["MLPutInteger32Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutInteger32Array"], "InlineCode"],
     StyleBox["()", "InlineCode"],
     " for 32-bit integers"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLPutFloatArray()", "InlineCode"]], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutReal32Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutReal32Array"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLPutDoubleArray()", "InlineCode"]], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutReal64Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutReal64Array"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLPutLongDoubleArray()", "InlineCode"]], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutReal128Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutReal128Array"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutIntegerList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutIntegerList"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutInteger32List",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutInteger32List"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutRealList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutRealList"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutReal64List",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutReal64List"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True}}}},
 CellID->160399564],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetUnicodeString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetUnicodeString"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetUCS2String",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetUCS2String"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLGetUnicodeSymbol()", "InlineCode"]], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLGetUCS2Symbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetUCS2Symbol"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutUnicodeString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutUnicodeString"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutUCS2String",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutUCS2String"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLPutUnicodeSymbol()", "InlineCode"]], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLPutUCS2Symbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutUCS2Symbol"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLPut16BitCharacters()", "InlineCode"]], "TableText"], Cell[TextData[
    StyleBox["MLPutUCS2Characters()", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     StyleBox[ButtonBox["MLDisownUnicodeString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLDisownUnicodeString"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLReleaseUCS2String",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLReleaseUCS2String"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "MLDisownUnicodeSymbol()", "InlineCode"]], "TableText"], Cell[TextData[{
     StyleBox[ButtonBox["MLReleaseUCS2Symbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLReleaseUCS2Symbol"], "InlineCode"],
     StyleBox["()", "InlineCode"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->1085369097],

Cell[TextData[{
 "Interface 3 changes the default linkprotocol for linkmode Listen and \
linkmode Connect links.",
 " ",
 "By default the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library will create \"SharedMemory\" links for linkmode Listen and \
linkmode Connect links on all platforms."
}], "Text",
 CellID->1573091918]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathLink Interface 3 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 23.0862980}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "", "status" -> "None", "summary" -> 
    "The library now fully supports the Unicode character encoding forms \
UTF-8, UTF-16, and UTF-32. Use the following new API functions to put or get \
Unicode characters to or from a link. The MathLink library header file \
mathlink.h no longer contains obsolete platform support sections such as \
those defined by MACINTOSH_MATHLINK or OS2_MATHLINK. MACINTOSH_MATHLINK \
definitions referred to MacOS 9 and earlier. DARWIN_MATHLINK contains all \
platform specific definitions for Mac OS X. All uses of special alternative \
names for common C types have been removed from the API. The MathLink header \
file mathlink.h still contains versions of the API functions with these types \
for use with Interface 2 and older programs.", "synonyms" -> {}, "title" -> 
    "MathLink Interface 3", "type" -> "Tutorial", "uri" -> 
    "tutorial/MathLinkInterface3"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[728, 29, 110, 5, 70, "Title",
 CellID->509267359],
Cell[841, 36, 231, 5, 70, "Text",
 CellID->1534169418],
Cell[1075, 43, 4466, 108, 70, "2ColumnTableMod",
 CellID->423544577],
Cell[5544, 153, 643, 20, 70, "Text",
 CellID->1202276477],
Cell[6190, 175, 450, 14, 70, "Text",
 CellID->1945580710],
Cell[6643, 191, 6030, 120, 70, "2ColumnTableMod",
 CellID->1788983748],
Cell[12676, 313, 313, 8, 70, "Text",
 CellID->531310989],
Cell[12992, 323, 278, 8, 70, "Text",
 CellID->987114316],
Cell[13273, 333, 217, 7, 70, "Text",
 CellID->1119135937],
Cell[13493, 342, 216, 7, 70, "Text",
 CellID->1655912733],
Cell[13712, 351, 223, 7, 70, "Text",
 CellID->1684722058],
Cell[13938, 360, 216, 7, 70, "Text",
 CellID->551743111],
Cell[14157, 369, 211, 7, 70, "Text",
 CellID->312078831],
Cell[14371, 378, 250, 9, 70, "Text",
 CellID->953846643],
Cell[14624, 389, 281, 8, 70, "Text",
 CellID->335104046],
Cell[14908, 399, 948, 21, 70, "2ColumnTableMod",
 CellID->664040877],
Cell[15859, 422, 585, 20, 70, "Text",
 CellID->1391578688],
Cell[16447, 444, 483, 16, 70, "Text",
 CellID->18609739],
Cell[16933, 462, 211, 7, 70, "Text",
 CellID->1752899481],
Cell[17147, 471, 2460, 57, 70, "2ColumnTableMod",
 CellID->1800907621],
Cell[19610, 530, 780, 25, 70, "Text",
 CellID->1219865329],
Cell[20393, 557, 573, 19, 70, "Text",
 CellID->250206594],
Cell[20969, 578, 194, 4, 70, "Text",
 CellID->449244532],
Cell[21166, 584, 12171, 275, 70, "2ColumnTableMod",
 CellID->2047830119],
Cell[33340, 861, 7774, 174, 70, "2ColumnTableMod",
 CellID->160399564],
Cell[41117, 1037, 2899, 66, 70, "2ColumnTableMod",
 CellID->1085369097],
Cell[44019, 1105, 333, 10, 70, "Text",
 CellID->1573091918]
}, Open  ]],
Cell[44367, 1118, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

