(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18428,        575]
NotebookOptionsPosition[     13687,        436]
NotebookOutlinePosition[     16622,        508]
CellTagsIndexPosition[     16531,        502]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Calculations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalCalculationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Calculations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Degree" :> Documentation`HelpLookup["paclet:ref/Degree"], "E" :> 
          Documentation`HelpLookup["paclet:ref/E"], "I" :> 
          Documentation`HelpLookup["paclet:ref/I"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Degree\"\>", 2->"\<\"E\"\>", 
       3->"\<\"I\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Mathematical Notation in Notebooks", "Title",
 CellTags->{"S1.1.7", "7.1"},
 CellID->19688],

Cell[TextData[{
 "If you use a text\[Hyphen]based interface to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then the input you give must consist only of characters that you can type \
directly on your computer keyboard. But if you use a notebook interface then \
other kinds of input become possible."
}], "Text",
 CellID->5352],

Cell[TextData[{
 "There are palettes provided which operate like extensions of your keyboard, \
and which have buttons that you can click to enter particular forms. You can \
access standard palettes using the ",
 StyleBox["Palettes", "MenuName"],
 " menu."
}], "Text",
 CellID->9197],

Cell[TextData[{
 "Clicking the ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 " button in this palette will enter a Pi into your notebook."
}], "MathCaption",
 CellID->20989],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW12O2jAQNnES0Gr3DpyBQ/RHbR/astpntKq0+1C12u5htvdCSLBAhQDx
88AVaDyJFyeZCXZ+IECQ7ERjO/m+mYln7IQvneeHHz87z4/3neb7p87vh8f7
P813v548Ea8xxu688q3JxPnWOw2qO7bdijMOx1arBeW7qGt+k8U2m01bEXh9
PQl7efkL5auorTzb7VC7Vz4Lgb2/H7R+FLwi97A0xwZqaLdvodxAHZZdacqu
E2TiJ2/PzaANhyMo11BzuKCUX2nKsLGqTMLT1fhlQLNFDbZzyguSQ+0ABHk9
URjcnOrPQ/19mRuSKbSOwMrSRCmReuPsAxNzQoClyh3EHLKfQyI8IfKuEQnc
L7H+Ub+k/LdSzqkqB8A51HRqqpJ0/UuqGmyqNLN5pYjzVwR9d/NYpJsGKGOw
y2H6DYgfIxlKYVKYsnnUp47IocQJcd7QPgSuKMelWB1VC7dzcYbLhSYnz/H4
H1ssFlAsqOtsPp+z19chFlnyhI+FAyzG0pTqsRAkYY9G4yAUuWwymRQcJHWZ
7LJRMuF2dlHBjbEThvGOflxx2XK5zETMDl1chqTg7srPDghF4LgUETc5+mEp
hUswFg7JmK84zrrdrmfzXq8H9i3YPenMB+lnRYN5vNWnGM+a/GfO77Fer0tp
USvCArG3ooEGZUY4n06nnPX7fY/0YDCIOcjJWDLurLPZTH08V6tVwfMOtrlj
If1SP5BxbxUTrDohF2AuXVamoU7MGWIGFcWCui6c8RAeeKZJxJlCq5YIlTNU
0C4EGrZ9kyRLk1iY7hKabembYc+oLh4QVy/P8N11+s3h/n3VuqYFGkFvLLPJ
yDSa75ks5WjHiOXcDeoaIANmOZovmdSJW8zANy/wyc0y0ZVkri5xGKmgnTq0
KuuvnKGCdrbQnBA0UdRMZl+8BplNRf3kZPAgC5hY1kMmrZFcDsuOjL5+ILaY
92kiI2sMYjGU8e8coD8k0liKKEfclIOwRRnElPXuPQD2CWgBrKPPJ2W+qBHU
Y+aP2ww8HF9fZVQCgHApiPwNIknAplrp7fLEVVRGPsW8yy4DYt1wQr6lytt1
ShWCywstZe7/KaClijX+BKI3rOD/v9yK5po6oPYfl8HxyQ==\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{87, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->17895],

Cell["\<\
Clicking the first button in this palette will create an empty structure for \
entering a power. You can use the mouse to fill in the structure. \
\>", "MathCaption",
 CellID->398],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWV1OwkAQ3naLgIABFHwlRi7AGYyaGBMxMUZ5aogJPBgNchi8GDfgHLgz
ZctSp0vrllpIm8wyzM8337Lb/Qn37nT09u5Ox0O3czNxP0fj4Vfn+mMiTNxi
jA2EXHUY6EuhrpoBWy6F9sp6vZ7l6YyzxWIBBpTn367Z7BvlCVo7Sb+z4Rfi
JXA2n89RA7mDlm/PRa8N3RQA0BX53Co2mWNHxFtx6fcfUS6w9WyQBt+6K9tf
4C8RiSOCxOwqNokZtftZx6tCLo5Rm0Bee89Na4hoeEADaYVVC8S1E6grp562
rnEvKwH2kF8ErQSWIlE3mOHHYUYpQS6byOlyOcbcwsaoygpHWk7RMg+VW5l4
G2zC5mh5xkdJmjMPs8XirEcx4Yyjxf1xC6mrbl+FMOIRoIzplghkZ8sPJo8S
ocRjgRp3oU4gNwhWVFzzgOviGuxgGPcXE/g8Tau4mLdqnNTFc2ZAoUFQqGv7
T61QjRQYUHH7WBdna1VdiNRq6K0Fvf99Es3xzPC66F3fhDw8zyax8ovWQePh
koFL+MkukCMcI6t53XiXDzxMNbPLwHg26WuYvAF65Jq/yVX2kH0yyNwfwXIK
40td0agZS11AkuHSyhlkhcGOZ90+7s4ZwXvAYLqMUdKO/5t4AbelJlg/1GQu
TQ==\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{91, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->4951],

Cell["\<\
You can also give input by using special keys on your keyboard. Pressing one \
of these keys does not lead to an ordinary character being entered, but \
instead typically causes some action to occur or some structure to be \
created. \
\>", "Text",
 CellID->12018],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]", "InlineCode"],
     StyleBox["p", "InlineCode"],
     StyleBox["\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"], Cell[TextData[{
     "the symbol ",
     Cell[BoxData[
      FormBox["\[Pi]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell[TextData[{
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]", "InlineCode"],
     StyleBox["inf", "InlineCode"],
     StyleBox["\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"], Cell[TextData[{
     "the symbol ",
     Cell[BoxData[
      FormBox["\[Infinity]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell[TextData[{
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]ee\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"], Cell[TextData[{
     "the symbol ",
     Cell[BoxData[
      FormBox["\[ExponentialE]", TraditionalForm]], "InlineMath"],
     " for the exponential constant (equivalent to ",
     Cell[BoxData[
      ButtonBox["E",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/E"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell[TextData[{
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]ii\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"], Cell[TextData[{
     "the symbol ",
     Cell[BoxData[
      FormBox["\[ImaginaryI]", TraditionalForm]], "InlineMath"],
     " for ",
     Cell[BoxData[
      FormBox[
       SqrtBox[
        RowBox[{"-", "1"}]], TraditionalForm]], "InlineMath"],
     " (equivalent to ",
     Cell[BoxData[
      ButtonBox["I",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/I"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell[TextData[{
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]", "InlineCode"],
     StyleBox["deg", "InlineCode"],
     StyleBox["\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"], Cell[TextData[{
     "the symbol ",
     Cell[BoxData[
      FormBox["\[Degree]", TraditionalForm]], "InlineMath"],
     " (equivalent to ",
     Cell[BoxData[
      ButtonBox["Degree",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["^", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["6", "KeyEvent"]
    }], "TableText"], Cell[
    "go to the superscript for a power", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["/", "KeyEvent"]
    }], "TableText"], Cell[
    "go to the denominator for a fraction", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["@", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["2", "KeyEvent"]
    }], "TableText"], Cell["go into a square root", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], Cell[
    "return from a superscript, denominator or square root", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, True, False, False, {True}, False}, 
   "RowsIndexed" -> {}}},
 CellID->19373],

Cell["\<\
A few ways to enter special notations on a standard English\[Hyphen]language \
keyboard. \
\>", "Caption",
 CellID->16257],

Cell["\<\
Here is a computation entered using ordinary characters on a keyboard. \
\>", "MathCaption",
 CellID->31719],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Pi", "^", "2"}], "/", "6"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->23873],

Cell[BoxData["1.6449340668482262`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->6915]
}, Open  ]],

Cell["\<\
Here is the same computation entered using a palette or special keys. \
\>", "MathCaption",
 CellID->3068],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  FractionBox[
   SuperscriptBox["\[Pi]", "2"], "6"], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->2883],

Cell[BoxData["1.6449340668482262`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->25610]
}, Open  ]],

Cell["\<\
Here is an actual sequence of keys that can be used to enter the input. \
\>", "MathCaption",
 CellID->11859],

Cell[CellGroupData[{

Cell[TextData[{
 "N[ ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["p", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 " 2 ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["/", "KeyEvent"],
 " 6 ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " ]"
}], "Input",
 CellLabel->"In[3]:= ",
 CellID->2125],

Cell[BoxData["1.6449340668482262`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->27596]
}, Open  ]],

Cell[TextData[{
 "In a traditional computer language such as C, Fortran, Java or Perl, the \
input you give must always consist of a string of ordinary characters that \
can be typed directly on a keyboard. But the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language also allows you to give input that contains special characters, \
superscripts, built\[Hyphen]up fractions, and so on. "
}], "Text",
 CellID->22839],

Cell["\<\
The language incorporates many features of traditional mathematical notation. \
But you should realize that the goal of the language is to provide a precise \
and consistent way to specify computations. And as a result, it does not \
follow all of the somewhat haphazard details of traditional mathematical \
notation.\
\>", "Text",
 CellID->17583],

Cell[TextData[{
 "Nevertheless, as discussed in\[NonBreakingSpace]\"",
 ButtonBox["Forms of Input and Output\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/FormsOfInputAndOutput"],
 ", it is always possible to get ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to produce ",
 StyleBox["output",
  FontSlant->"Italic"],
 " that imitates every aspect of traditional mathematical notation. And it is \
also possible for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to import text that uses such notation, and to some extent to translate it \
into its own more precise language."
}], "Text",
 CellID->13518],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->651378168],

Cell[TextData[ButtonBox["Numerical Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalCalculationsOverview"]], "RelatedTutorials",
 CellID->21356267]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->145957740],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->140535376]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mathematical Notation in Notebooks - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/NumericalCalculationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/GettingUsedToMathematica"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 14.3360740}", "context" -> "", 
    "keywords" -> {
     "builtup fractions", "buttons", "computer languages", "consistency", 
      "control", "control", "control", "Control6", "control keys", 
      "ControlSpace", "escape key", "fractions", "keys", "languages", 
      "mathematical notation", "menu", "notation", "palettes", "square roots",
       "superscripts"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "If you use a text-based interface to Mathematica, then the input you \
give must consist only of characters that you can type directly on your \
computer keyboard. But if you use a notebook interface then other kinds of \
input become possible. There are palettes provided which operate like \
extensions of your keyboard, and which have buttons that you can click to \
enter particular forms. You can access standard palettes using the Palettes \
menu. Clicking the \\[Pi] button in this palette will enter a Pi into your \
notebook.", "synonyms" -> {"1.1.7"}, "title" -> 
    "Mathematical Notation in Notebooks", "type" -> "Tutorial", "uri" -> 
    "tutorial/MathematicalNotationInNotebooks-NumericalCalculations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.1.7"->{
  Cell[1957, 60, 97, 2, 70, "Title",
   CellTags->{"S1.1.7", "7.1"},
   CellID->19688]},
 "7.1"->{
  Cell[1957, 60, 97, 2, 70, "Title",
   CellTags->{"S1.1.7", "7.1"},
   CellID->19688]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.1.7", 16320, 491},
 {"7.1", 16419, 495}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1332, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1957, 60, 97, 2, 70, "Title",
 CellTags->{"S1.1.7", "7.1"},
 CellID->19688],
Cell[2057, 64, 339, 8, 70, "Text",
 CellID->5352],
Cell[2399, 74, 284, 7, 70, "Text",
 CellID->9197],
Cell[2686, 83, 199, 6, 70, "MathCaption",
 CellID->20989],
Cell[2888, 91, 1331, 25, 70, "Picture",
 Evaluatable->False,
 CellID->17895],
Cell[4222, 118, 190, 4, 70, "MathCaption",
 CellID->398],
Cell[4415, 124, 859, 18, 70, "Picture",
 Evaluatable->False,
 CellID->4951],
Cell[5277, 144, 274, 6, 70, "Text",
 CellID->12018],
Cell[5554, 152, 3735, 113, 70, "DefinitionBox",
 CellID->19373],
Cell[9292, 267, 132, 4, 70, "Caption",
 CellID->16257],
Cell[9427, 273, 118, 3, 70, "MathCaption",
 CellID->31719],
Cell[CellGroupData[{
Cell[9570, 280, 142, 5, 70, "Input",
 CellID->23873],
Cell[9715, 287, 172, 5, 36, "Output",
 CellID->6915]
}, Open  ]],
Cell[9902, 295, 116, 3, 70, "MathCaption",
 CellID->3068],
Cell[CellGroupData[{
Cell[10043, 302, 143, 5, 70, "Input",
 CellID->2883],
Cell[10189, 309, 173, 5, 36, "Output",
 CellID->25610]
}, Open  ]],
Cell[10377, 317, 119, 3, 70, "MathCaption",
 CellID->11859],
Cell[CellGroupData[{
Cell[10521, 324, 673, 26, 70, "Input",
 CellID->2125],
Cell[11197, 352, 173, 5, 36, "Output",
 CellID->27596]
}, Open  ]],
Cell[11385, 360, 427, 9, 70, "Text",
 CellID->22839],
Cell[11815, 371, 358, 7, 70, "Text",
 CellID->17583],
Cell[12176, 380, 630, 18, 70, "Text",
 CellID->13518],
Cell[CellGroupData[{
Cell[12831, 402, 72, 1, 70, "RelatedTutorialsSection",
 CellID->651378168],
Cell[12906, 405, 175, 4, 70, "RelatedTutorials",
 CellID->21356267]
}, Open  ]],
Cell[CellGroupData[{
Cell[13118, 414, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->145957740],
Cell[13219, 417, 414, 13, 70, "TutorialRelatedLinks",
 CellID->140535376]
}, Open  ]]
}, Open  ]],
Cell[13660, 434, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

