(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19734,        642]
NotebookOptionsPosition[     15553,        517]
NotebookOutlinePosition[     18097,        582]
CellTagsIndexPosition[     18004,        576]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Symbolic Mathematics" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SymbolicMathematicsOverview"]}, #, 2]& , Evaluator -> 
       Automatic], {
      1->"\<\"Symbolic Mathematics\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Mathematical Notation in Notebooks", "Title",
 CellTags->{"S1.5.16", "16.1"},
 CellID->9159],

Cell[TextData[{
 "If you use the notebook front end for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then you can enter some of the operations discussed here in special ways. \
"
}], "Text",
 CellID->21518],

Cell[BoxData[GridBox[{
   {Cell[BoxData[
     FormBox[
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"i", "=", 
         SubscriptBox["i", 
          StyleBox["min", "TI"]]}], 
        SubscriptBox["i", 
         StyleBox["max", "TI"]]], "f"}], TraditionalForm]], "InlineMath"], 
    RowBox[{
     ButtonBox["Sum",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sum"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]}], "]"}], Cell["sum", "TableText"]},
   {Cell[BoxData[
     FormBox[
      RowBox[{
       UnderoverscriptBox["\[Product]", 
        RowBox[{"i", "=", 
         SubscriptBox["i", 
          StyleBox["min", "TI"]]}], 
        SubscriptBox["i", 
         StyleBox["max", "TI"]]], "f"}], TraditionalForm]], "InlineMath"], 
    RowBox[{
     ButtonBox["Product",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Product"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], Cell["product", "TableText"]},
   {Cell[BoxData[
     FormBox[
      RowBox[{"\[Integral]", 
       RowBox[{"f", " ", 
        RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], 
     "InlineMath"], 
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell["indefinite integral", "TableText"]},
   {Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox["\[Integral]", 
        SubscriptBox["x", 
         StyleBox["min", "TI"]], 
        SubscriptBox["x", 
         StyleBox["max", "TI"]]], 
       RowBox[{"f", " ", 
        RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], 
     "InlineMath"], 
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], Cell[
    "definite integral", "TableText"]},
   {Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], "f"}], TraditionalForm]], 
     "InlineMath"], 
    RowBox[{
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell["partial derivative", "TableText"]},
   {Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["\[PartialD]", 
        RowBox[{"x", ",", "y"}]], "f"}], TraditionalForm]], "InlineMath"], 
    RowBox[{
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "]"}], Cell[
    "multivariate partial derivative", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.19], 
     Scaled[0.3500000000000003], {
      Scaled[0.45]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->23061],

Cell["\<\
Special and ordinary ways to enter mathematical operations in notebooks. \
\>", "Caption",
 CellID->6167],

Cell["\<\
This shows part of the standard palette for entering mathematical operations. \
When you press a button in the palette, the form shown in the button is \
inserted into your notebook, with the black square replaced by whatever you \
had selected in the notebook.\
\>", "MathCaption",
 CellID->28603],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXN1u0zAUTpufduvfVrYxED+DC5Dgbg8BV9xtQlwgVCqk7QKBxl4Fabxb
9wp7hZHjtHbifHGS2u7iLZFcebZzzndcn3M+x+k+zS7PfvycXZ7PZ0cfL2a/
z87nf44+/LqIm/yO53nzuPw98qh+G1eXH3Pv9jauffeOj487Sd3zvZubG2pg
5Vu+6+rqHytf6bNrsj/I9MflCzX45eNY7ymZ1K1zx3vv5OS0S0PeUi3GRxeN
pFJVyjtvsbiOR5MEGkflDWsLWFtKZity8yIndHuYrI1VbWJezdZSJF1US/6i
zzDTRoWDKegLgayeech9oCZYE3IEZEUt5Li3B9SEa0IulpWFzNZ3wO9gtb4l
MyTXqgUxNY4u2YcswT6sCDHiRgUAWDdrvFOwlUuvNaQ1xFVDdCJSw9x9Izni
bgKwg+nPQeLhIORCEi259IYIshsbHDdEnrDe9XbYOvc+pD3+mEe75dZzdXWL
2sYAxLC2lKEebBaU+iIEBRm/5tEn14zAM3Q+l5V82yGHnI9pOamaxqDQ5GNN
iEioACN7ZapCpWAW66rTnAiUMkK+tCJeq2eVnM4yojQRI3pxkMs56+B8lM1h
ZnP6frMgohy+1yyIDswiWotB1me0wTJRE1OIkb9XjERUhmuaVEn4yJSRDFsv
LUjSfgjAs/DP8ltBpD3QAyXSPtIu0rmmGjc4UMsz7YsUu+qX5oUzb+kqXMyC
zkRTlHNMRUh5DlDsgnFTAwEHkTY0C1Ogf9esfiqvlVEGfWsLMwStFpjK2wgL
oPrZZBbxeQmT7y8PmWHzRW9V8OLpSGDTjEDtIKqDTmRt6QNAidi7bGU5D9tp
rWucdZFi/HQzFoU8JKSeufBZLowkIjlbxSncdCz10jUAwLaBlCeWgOUD5Yjj
RdhEqHlmAlEtJvEU4NHkM8wcwaFShjWdWjZsR/CQWL1YNIhTaQoPsVe+Mq8J
PdyxsGWoqmaXO6AmE6+lMD/TFrRL53ESy0XHgwOe0gpYriB6WzbxapAFZNa2
YrwIwC7bVk7zota6xlk3UIzvb8aiCiQWIRePE6ziRNQVnUfJ78pQ2TMPR3BU
BGLAex+bUJ2LvS+AThPvczBKYSEDu8Gq2ufRTopEHo9OV0ZgnOY5yx2qHnN/
7fGwW/iKiDRO8zEqCsVROYjCOzThjHCMVCMalN2kCWoALMYHuyqU6CVPtRRN
2PIXVUSyfCXsqlTNNwUbneaoISLPtQrnYDNcpapqY0fN6CBrv0IISNZEfO3f
A/1DsWiA1h3q3W5c3nRDZEvK7kbklAeIHUvC89nXfU22JsyNNWPs578oY7kr
nPWyl8omztpg9pfdKTex5EQrVgP9/r7ptD+djQ8gn6m34D9K2P5fGCX9M+ru
pG/o/AfSeWvN\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{99, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->28166],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]sum\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"], Cell[TextData[{
     "summation sign ",
     Cell[BoxData[
      FormBox["\[Sum]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell[TextData[{
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]prod\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"], Cell[TextData[{
     "product sign ",
     Cell[BoxData[
      FormBox["\[Product]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell[TextData[{
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]int\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"], Cell[TextData[{
     "integral sign ",
     Cell[BoxData[
      FormBox["\[Integral]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell[TextData[{
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]dd\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"], Cell[TextData[{
     "special differential ",
     Cell[BoxData[
      FormBox["\[DifferentialD]", TraditionalForm]], "InlineMath"],
     " for use in integrals"
    }], "TableText"]},
   {Cell[TextData[{
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]pd\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"], Cell[TextData[{
     "partial derivative ",
     Cell[BoxData[
      FormBox["\[PartialD]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["_", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["-", "KeyEvent"]
    }], "TableText"], Cell[
    "move to the subscript position or lower limit of an integral", 
     "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["^", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["6", "KeyEvent"]
    }], "TableText"], Cell["\<\
move to the superscript position or upper limit of an integral\
\>", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["+", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["=", "KeyEvent"]
    }], "TableText"], Cell["\<\
move to the underscript position or lower limit of a sum or product\
\>", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["&", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["7", "KeyEvent"]
    }], "TableText"], Cell["\<\
move to the overscript position or upper limit of a sum or product\
\>", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["%", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["5", "KeyEvent"]
    }], "TableText"], Cell[
    "switch between upper and lower positions", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], Cell[
    "return from upper or lower positions", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, True, False, False, False, True, {
     False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->29938],

Cell["\<\
Ways to enter special notations on a standard English\[Hyphen]language \
keyboard. \
\>", "Caption",
 CellID->26226],

Cell[TextData[{
 "You can enter an integral like this. Be sure to use the special \
differential ",
 Cell[BoxData[
  FormBox["\[DifferentialD]", TraditionalForm]], "InlineMath"],
 " entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]dd\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", not just an ordinary\[NonBreakingSpace]",
 Cell[BoxData["d"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "n"], " ", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->17882],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", 
   RowBox[{"1", "+", "n"}]], 
  RowBox[{"1", "+", "n"}]]], "Output",
 ImageSize->{35, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->27876]
}, Open  ]],

Cell["Here is the actual key sequence you type to get the input.", \
"MathCaption",
 CellID->15760],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]int\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 Cell[BoxData["x"], "InlineCode"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 " ",
 StyleBox["n", "InlineCode"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]dd", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 StyleBox["x", "InlineCode"]
}], "Input",
 CellLabel->"In[2]:= ",
 CellID->8738],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", 
   RowBox[{"1", "+", "n"}]], 
  RowBox[{"1", "+", "n"}]]], "Output",
 ImageSize->{35, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->14557]
}, Open  ]],

Cell[TextData[{
 "When entering a sum, product or integral that has limits, you can create \
the first limit using the standard control sequences for subscripts, \
superscripts, underscripts, or overscripts. However, you must use ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 " to create the second limit. "
}], "Text",
 CellID->126286155],

Cell["You can enter a sum like this. ", "MathCaption",
 CellID->273106350],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"x", "=", "0"}], "n"], "x"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->975577009],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "n", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "n"}], ")"}]}]], "Output",
 ImageSize->{69, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->347117614]
}, Open  ]],

Cell["Here is the actual key sequence you type to get the input.", \
"MathCaption",
 CellID->456542248],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]sum\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["=", "KeyEvent"],
 " ",
 StyleBox["x=0", "InlineCode"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 " ",
 StyleBox["n", "InlineCode"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " ",
 StyleBox["x", "InlineCode"]
}], "Input",
 CellLabel->"In[2]:= ",
 CellID->176404858],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "n", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "n"}], ")"}]}]], "Output",
 ImageSize->{69, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->651512646]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->149737786],

Cell[TextData[ButtonBox["Symbolic Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SymbolicMathematicsOverview"]], "RelatedTutorials",
 CellID->391267452]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mathematical Notation in Notebooks - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Symbolic Mathematics", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/SymbolicMathematicsOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/GenericAndNonGenericCases"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 14.6954582}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "If you use the notebook front end for Mathematica, then you can enter \
some of the operations discussed here in special ways. Special and ordinary \
ways to enter mathematical operations in notebooks. This shows part of the \
standard palette for entering mathematical operations. When you press a \
button in the palette, the form shown in the button is inserted into your \
notebook, with the black square replaced by whatever you had selected in the \
notebook.", "synonyms" -> {"1.5.16"}, "title" -> 
    "Mathematical Notation in Notebooks", "type" -> "Tutorial", "uri" -> 
    "tutorial/MathematicalNotationInNotebooks-SymbolicMathematics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.5.16"->{
  Cell[1260, 43, 98, 2, 70, "Title",
   CellTags->{"S1.5.16", "16.1"},
   CellID->9159]},
 "16.1"->{
  Cell[1260, 43, 98, 2, 70, "Title",
   CellTags->{"S1.5.16", "16.1"},
   CellID->9159]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.5.16", 17790, 565},
 {"16.1", 17891, 569}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 635, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1260, 43, 98, 2, 70, "Title",
 CellTags->{"S1.5.16", "16.1"},
 CellID->9159],
Cell[1361, 47, 217, 7, 70, "Text",
 CellID->21518],
Cell[1581, 56, 3534, 112, 70, "DefinitionBox3Col",
 CellID->23061],
Cell[5118, 170, 115, 3, 70, "Caption",
 CellID->6167],
Cell[5236, 175, 308, 6, 70, "MathCaption",
 CellID->28603],
Cell[5547, 183, 1601, 30, 70, "Picture",
 Evaluatable->False,
 CellID->28166],
Cell[7151, 215, 4076, 118, 70, "DefinitionBox",
 CellID->29938],
Cell[11230, 335, 126, 4, 70, "Caption",
 CellID->26226],
Cell[11359, 341, 434, 13, 70, "MathCaption",
 CellID->7193],
Cell[CellGroupData[{
Cell[11818, 358, 176, 6, 70, "Input",
 CellID->17882],
Cell[11997, 366, 246, 9, 54, "Output",
 CellID->27876]
}, Open  ]],
Cell[12258, 378, 99, 2, 70, "MathCaption",
 CellID->15760],
Cell[CellGroupData[{
Cell[12382, 384, 653, 25, 70, "Input",
 CellID->8738],
Cell[13038, 411, 246, 9, 54, "Output",
 CellID->14557]
}, Open  ]],
Cell[13299, 423, 393, 9, 70, "Text",
 CellID->126286155],
Cell[13695, 434, 74, 1, 70, "MathCaption",
 CellID->273106350],
Cell[CellGroupData[{
Cell[13794, 439, 149, 5, 70, "Input",
 CellID->975577009],
Cell[13946, 446, 258, 9, 51, "Output",
 CellID->347117614]
}, Open  ]],
Cell[14219, 458, 103, 2, 70, "MathCaption",
 CellID->456542248],
Cell[CellGroupData[{
Cell[14347, 464, 607, 24, 70, "Input",
 CellID->176404858],
Cell[14957, 490, 258, 9, 51, "Output",
 CellID->651512646]
}, Open  ]],
Cell[CellGroupData[{
Cell[15252, 504, 72, 1, 70, "RelatedTutorialsSection",
 CellID->149737786],
Cell[15327, 507, 172, 4, 70, "RelatedTutorials",
 CellID->391267452]
}, Open  ]]
}, Open  ]],
Cell[15526, 515, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

