(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20930,        618]
NotebookOptionsPosition[     16808,        509]
NotebookOutlinePosition[     20059,        586]
CellTagsIndexPosition[     19966,        580]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalFunctionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Mathematical Functions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathieuC" :> Documentation`HelpLookup["paclet:ref/MathieuC"], 
          "MathieuCharacteristicA" :> 
          Documentation`HelpLookup["paclet:ref/MathieuCharacteristicA"], 
          "MathieuCharacteristicB" :> 
          Documentation`HelpLookup["paclet:ref/MathieuCharacteristicB"], 
          "MathieuCharacteristicExponent" :> 
          Documentation`HelpLookup[
           "paclet:ref/MathieuCharacteristicExponent"], "MathieuCPrime" :> 
          Documentation`HelpLookup["paclet:ref/MathieuCPrime"], "MathieuS" :> 
          Documentation`HelpLookup["paclet:ref/MathieuS"], "MathieuSPrime" :> 
          Documentation`HelpLookup["paclet:ref/MathieuSPrime"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MathieuC\"\>", 
       2->"\<\"MathieuCharacteristicA\"\>", 
       3->"\<\"MathieuCharacteristicB\"\>", 
       4->"\<\"MathieuCharacteristicExponent\"\>", 5->"\<\"MathieuCPrime\"\>",
        6->"\<\"MathieuS\"\>", 
       7->"\<\"MathieuSPrime\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Mathieu and Related Functions", "Title",
 CellTags->{"S3.2.13", "13.1"},
 CellID->10287],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MathieuC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MathieuC"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["q", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "even Mathieu functions with characteristic value ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and parameter ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MathieuS",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MathieuS"], "[", 
     StyleBox["b", "TI"], ",", 
     StyleBox["q", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "odd Mathieu function with characteristic value ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     " and parameter ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MathieuCPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MathieuCPrime"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["q", "TI"], ",", 
     StyleBox["z", "TI"], "]", Cell[
     " \[ThinSpace]and\[ThinSpace]", "TableText"], 
     ButtonBox["MathieuSPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MathieuSPrime"], "[", 
     StyleBox["b", "TI"], ",", 
     StyleBox["q", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     StyleBox["z", "TI"],
     " derivatives of Mathieu functions"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MathieuCharacteristicA",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MathieuCharacteristicA"], "[", 
     StyleBox["r", "TI"], ",", 
     StyleBox["q", "TI"], "]"}], Cell[TextData[{
     "characteristic value ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["r", "TI"]]], "InlineFormula"],
     " for even Mathieu functions with characteristic exponent ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " and parameter ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MathieuCharacteristicB",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MathieuCharacteristicB"], "[", 
     StyleBox["r", "TI"], ",", 
     StyleBox["q", "TI"], "]"}], Cell[TextData[{
     "characteristic value ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["b", "TI"], 
       StyleBox["r", "TI"]]], "InlineFormula"],
     " for odd Mathieu functions with characteristic exponent ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " and parameter ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MathieuCharacteristicExponent",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MathieuCharacteristicExponent"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["q", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "characteristic exponent ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " for Mathieu functions with characteristic value ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and parameter ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, True, False, True, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28208],

Cell["Mathieu and related functions. ", "Caption",
 CellID->4738],

Cell[TextData[{
 "The ",
 StyleBox["Mathieu functions", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MathieuC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathieuC"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["q", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MathieuS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathieuS"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["q", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " are solutions to the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "\[Prime]\[Prime]"], "+", 
    RowBox[{"[", 
     RowBox[{"a", "-", "2", "q", "cos", 
      RowBox[{"(", 
       RowBox[{"2", "z"}], ")"}]}], "]"}], "y", "=", "0"}], TraditionalForm]],
   "InlineMath"],
 ". This equation appears in many physical situations that involve elliptical \
shapes or periodic potentials. The function ",
 Cell[BoxData[
  ButtonBox["MathieuC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuC"]], "InlineFormula"],
 " is defined to be even in ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ", while ",
 Cell[BoxData[
  ButtonBox["MathieuS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuS"]], "InlineFormula"],
 " is odd."
}], "Text",
 CellID->25530],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  FormBox[
   RowBox[{"q", "=", "0"}], TraditionalForm]], "InlineMath"],
 " the Mathieu functions are simply ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", 
    RowBox[{"(", 
     RowBox[{
      SqrtBox["a"], "z"}], ")"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    RowBox[{"(", 
     RowBox[{
      SqrtBox["a"], "z"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". For non\[Hyphen]zero ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 ", the Mathieu functions are only periodic in ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " for certain values of ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 ". Such ",
 StyleBox["Mathieu characteristic values", "TB"],
 " are given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MathieuCharacteristicA",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathieuCharacteristicA"], "[", 
   RowBox[{
    StyleBox["r", "TI"], ",", 
    StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MathieuCharacteristicB",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathieuCharacteristicB"], "[", 
   RowBox[{
    StyleBox["r", "TI"], ",", 
    StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " an integer or rational number. These values are often denoted by ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", "r"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "r"], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->4605],

Cell[TextData[{
 "For integer ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 ", the even and odd Mathieu functions with characteristic values ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", "r"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "r"], TraditionalForm]], "InlineMath"],
 " are often denoted ",
 Cell[BoxData[
  FormBox[
   RowBox[{"c", 
    SubscriptBox["e", "r"], 
    RowBox[{"(", 
     RowBox[{"z", ",", "q"}], ")"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", 
    SubscriptBox["e", "r"], 
    RowBox[{"(", 
     RowBox[{"z", ",", "q"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ", respectively. Note the reversed order of the arguments ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->19490],

Cell[TextData[{
 "According to Floquet\[CloseCurlyQuote]s Theorem any Mathieu function can be \
written in the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["e", 
     StyleBox[
      RowBox[{"i", "r", "z"}], "TI"]], "f", 
    RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", 
    RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"],
 " has period ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " is the ",
 StyleBox["Mathieu characteristic exponent", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MathieuCharacteristicExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathieuCharacteristicExponent"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
 ". When the characteristic exponent ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " is an integer or rational number, the Mathieu function is therefore \
periodic. In general, however, when ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " is not a real integer, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", "r"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "r"], TraditionalForm]], "InlineMath"],
 " turn out to be equal. "
}], "Text",
 CellID->3799],

Cell[TextData[{
 "This shows the first five characteristic values ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", "r"], TraditionalForm]], "InlineMath"],
 " as functions of ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->29569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"MathieuCharacteristicA", "[", 
       RowBox[{"r", ",", "q"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"r", ",", "0", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->32407],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->876033579]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->95755023],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/MathematicalFunctionsOverview"]], "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mathieu and Related Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Mathematical Functions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/MathematicalFunctionsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 16.3517506}", "context" -> "", 
    "keywords" -> {
     "band structure calculations", "Bloch Theorem", 
      "electron wave functions", "elliptical geometries", "Floquet Theorem", 
      "hills equation", "MathieuC", "MathieuCharacteristicA", 
      "MathieuCharacteristicB", "MathieuCharacteristicExponent", 
      "MathieuCPrime", "MathieuS", "MathieuSPrime", "parametric amplifiers", 
      "penning traps", "periodic potentials", "Schrodinger equation", 
      "solid state physics", "stability of Mathieu functions"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathieu and related functions. The Mathieu functions MathieuC[a,q,z] and \
MathieuS[a,q,z] are solutions to the equation y^,,+[a-2qcos(2z)]y=0. This \
equation appears in many physical situations that involve elliptical shapes \
or periodic potentials. The function MathieuC is defined to be even in z, \
while MathieuS is odd. When q=0 the Mathieu functions are simply \
cos(SqrtBox[a]z) and sin(SqrtBox[a]z). For non-zero q, the Mathieu functions \
are only periodic in z for certain values of a. Such Mathieu characteristic \
values are given by MathieuCharacteristicA[r,q] and \
MathieuCharacteristicB[r,q] with r an integer or rational number. These \
values are often denoted by a_r and b_r. ", "synonyms" -> {"3.2.13"}, "title" -> 
    "Mathieu and Related Functions", "type" -> "Tutorial", "uri" -> 
    "tutorial/MathieuAndRelatedFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.2.13"->{
  Cell[2647, 72, 94, 2, 70, "Title",
   CellTags->{"S3.2.13", "13.1"},
   CellID->10287]},
 "13.1"->{
  Cell[2647, 72, 94, 2, 70, "Title",
   CellTags->{"S3.2.13", "13.1"},
   CellID->10287]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.2.13", 19750, 569},
 {"13.1", 19852, 573}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2022, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2647, 72, 94, 2, 70, "Title",
 CellTags->{"S3.2.13", "13.1"},
 CellID->10287],
Cell[2744, 76, 3901, 118, 70, "DefinitionBox",
 CellID->28208],
Cell[6648, 196, 65, 1, 70, "Caption",
 CellID->4738],
Cell[6716, 199, 1386, 49, 70, "Text",
 CellID->25530],
Cell[8105, 250, 1696, 61, 70, "Text",
 CellID->4605],
Cell[9804, 313, 943, 34, 70, "Text",
 CellID->19490],
Cell[10750, 349, 1481, 50, 70, "Text",
 CellID->3799],
Cell[12234, 401, 282, 10, 70, "MathCaption",
 CellID->29569],
Cell[CellGroupData[{
Cell[12541, 415, 422, 13, 28, "Input",
 CellID->32407],
Cell[12966, 430, 3502, 61, 120, "Output",
 Evaluatable->False,
 CellID->876033579]
}, Open  ]],
Cell[CellGroupData[{
Cell[16505, 496, 71, 1, 70, "RelatedTutorialsSection",
 CellID->95755023],
Cell[16579, 499, 175, 4, 70, "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]],
Cell[16781, 507, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

