(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26698,       1012]
NotebookOptionsPosition[     20723,        800]
NotebookOutlinePosition[     22503,        853]
CellTagsIndexPosition[     22412,        847]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Inverse" :> Documentation`HelpLookup["paclet:ref/Inverse"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Inverse\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Matrix Inversion", "Title",
 CellTags->{"S3.7.6", "6.1"},
 CellID->7971],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Inverse",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Inverse"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[
    "find the inverse of a square matrix", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->6490],

Cell["Matrix inversion. ", "Caption",
 CellID->2209],

Cell["Here is a simple 2\[Times]2 matrix.", "MathCaption",
 CellID->25458],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20925],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->562054830]
}, Open  ]],

Cell[TextData[{
 "This gives the inverse of ",
 Cell[BoxData["m"], "InlineFormula"],
 ". In producing this formula, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " implicitly assumes that the determinant ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "d"}], "-", 
   RowBox[{"b", "c"}]}]], "InlineFormula"],
 " is non\[Hyphen]zero."
}], "MathCaption",
 CellID->25868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18964],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["d", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "b"}], " ", "c"}], "+", 
       RowBox[{"a", " ", "d"}]}]], ",", 
     RowBox[{"-", 
      FractionBox["b", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "b"}], " ", "c"}], "+", 
        RowBox[{"a", " ", "d"}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["c", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "b"}], " ", "c"}], "+", 
        RowBox[{"a", " ", "d"}]}]]}], ",", 
     FractionBox["a", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "b"}], " ", "c"}], "+", 
       RowBox[{"a", " ", "d"}]}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{329, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->576174391]
}, Open  ]],

Cell["\<\
Multiplying the inverse by the original matrix should give the identity \
matrix. \
\>", "MathCaption",
 CellID->7905],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", ".", "m"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->21289],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "c"}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "b"}], " ", "c"}], "+", 
         RowBox[{"a", " ", "d"}]}]]}], "+", 
      FractionBox[
       RowBox[{"a", " ", "d"}], 
       RowBox[{
        RowBox[{
         RowBox[{"-", "b"}], " ", "c"}], "+", 
        RowBox[{"a", " ", "d"}]}]]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "c"}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "b"}], " ", "c"}], "+", 
         RowBox[{"a", " ", "d"}]}]]}], "+", 
      FractionBox[
       RowBox[{"a", " ", "d"}], 
       RowBox[{
        RowBox[{
         RowBox[{"-", "b"}], " ", "c"}], "+", 
        RowBox[{"a", " ", "d"}]}]]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{368, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->775291989]
}, Open  ]],

Cell[TextData[{
 "You have to use ",
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " to clear the denominators, and get back a standard identity matrix. "
}], "MathCaption",
 CellID->15355],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->23396],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->321303903]
}, Open  ]],

Cell["Here is a matrix of rational numbers. ", "MathCaption",
 CellID->10341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"hb", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"i", "+", "j"}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->17049],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "4"], ",", 
     FractionBox["1", "5"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "3"], ",", 
     FractionBox["1", "4"], ",", 
     FractionBox["1", "5"], ",", 
     FractionBox["1", "6"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "4"], ",", 
     FractionBox["1", "5"], ",", 
     FractionBox["1", "6"], ",", 
     FractionBox["1", "7"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "5"], ",", 
     FractionBox["1", "6"], ",", 
     FractionBox["1", "7"], ",", 
     FractionBox["1", "8"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{420, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->324962996]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " finds the exact inverse of the matrix. "
}], "MathCaption",
 CellID->26784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "[", "hb", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->21426],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"200", ",", 
     RowBox[{"-", "1200"}], ",", "2100", ",", 
     RowBox[{"-", "1120"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1200"}], ",", "8100", ",", 
     RowBox[{"-", "15120"}], ",", "8400"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2100", ",", 
     RowBox[{"-", "15120"}], ",", "29400", ",", 
     RowBox[{"-", "16800"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1120"}], ",", "8400", ",", 
     RowBox[{"-", "16800"}], ",", "9800"}], "}"}]}], "}"}]], "Output",
 ImageSize->{416, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->199189838]
}, Open  ]],

Cell["\<\
Multiplying by the original matrix gives the identity matrix. \
\>", "MathCaption",
 CellID->4611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", ".", "hb"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->18822],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->411613208]
}, Open  ]],

Cell[TextData[{
 "If you try to invert a singular matrix, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " prints a warning message, and returns the input unchanged."
}], "MathCaption",
 CellID->8258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->26411],

Cell[BoxData[
 RowBox[{
  RowBox[{"Inverse", "::", "\<\"sing\"\>"}], ":", 
  " ", "\<\"Matrix \\!\\({\\(\\({1, 2}\\)\\), \\(\\({1, 2}\\)\\)}\\) is \
singular. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/sing\\\", ButtonNote -> \
\\\"Inverse::sing\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[8]:=",
 CellID->132577143],

Cell[BoxData[
 RowBox[{"Inverse", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "]"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->844281940]
}, Open  ]],

Cell[TextData[{
 "If you give a matrix with exact symbolic or numerical entries, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gives the exact inverse. If, on the other hand, some of the entries in \
your matrix are approximate real numbers, then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " finds an approximate numerical result. "
}], "Text",
 CellID->24985],

Cell["Here is a matrix containing approximate real numbers. ", "MathCaption",
 CellID->30503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1.2", ",", "5.7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1.3", ",", "5.6"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[9]:=",
 CellID->32362],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.2`", ",", "5.7`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.3`", ",", "5.6`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->507512046]
}, Open  ]],

Cell["This finds the numerical inverse. ", "MathCaption",
 CellID->25922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "[", "%", "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->29040],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "8.115942028985483`"}], ",", "8.260869565217368`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1.8840579710144876`", ",", 
     RowBox[{"-", "1.7391304347826035`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->658418002]
}, Open  ]],

Cell["\<\
Multiplying by the original matrix gives you an identity matrix with small \
round-off errors. \
\>", "MathCaption",
 CellID->15937],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", ".", "m"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->30012],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.9999999999999991`", ",", "1.6618650899857812`*^-15"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"3.2742905609062234`*^-16", ",", "1.0000000000000002`"}], "}"}]}],
   "}"}]], "Output",
 ImageSize->{288, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->175017801]
}, Open  ]],

Cell[TextData[{
 "You can get rid of small off\[Hyphen]diagonal terms using ",
 Cell[BoxData[
  ButtonBox["Chop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Chop"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", "%", "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->27091],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.9999999999999991`", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1.0000000000000002`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->39360834]
}, Open  ]],

Cell[TextData[{
 "When you try to invert a matrix with exact numerical entries, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can always tell whether or not the matrix is singular. When you invert an \
approximate numerical matrix, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can usually not tell for certain whether or not the matrix is singular: \
all it can tell is for example that the determinant is small compared to the \
entries of the matrix. When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " suspects that you are trying to invert a singular numerical matrix, it \
prints a warning."
}], "Text",
 CellID->11160],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " prints a warning if you invert a numerical matrix that it suspects is \
singular. "
}], "MathCaption",
 CellID->1405],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1.", ",", "2."}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1.", ",", "2."}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->11425],

Cell[BoxData[
 RowBox[{
  RowBox[{"Inverse", "::", "\<\"sing\"\>"}], ":", 
  " ", "\<\"Matrix \\!\\({\\(\\({1.`, 2.`}\\)\\), \\(\\({1.`, 2.`}\\)\\)}\\) \
is singular. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/sing\\\", ButtonNote -> \
\\\"Inverse::sing\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[13]:=",
 CellID->233763782],

Cell[BoxData[
 RowBox[{"Inverse", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1.`", ",", "2.`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1.`", ",", "2.`"}], "}"}]}], "}"}], "]"}]], "Output",
 ImageSize->{199, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->594795930]
}, Open  ]],

Cell["\<\
This matrix is singular, but the warning is different, and the result is \
useless.\
\>", "MathCaption",
 CellID->283876961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "[", 
  RowBox[{"N", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->117205459],

Cell[BoxData[
 RowBox[{
  RowBox[{"Inverse", "::", "\<\"luc\"\>"}], ":", 
  " ", "\<\"Result for \\!\\(Inverse\\) of badly conditioned matrix \
\\!\\({\\(\\({1.`, 2.`, 3.`}\\)\\), \\(\\({4.`, 5.`, 6.`}\\)\\), \\(\\({7.`, \
8.`, 9.`}\\)\\)}\\) may contain significant numerical errors. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/luc\\\", \
ButtonNote -> \\\"Inverse::luc\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[14]:=",
 CellID->18639592],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.152211905965405`*^15", ",", 
     RowBox[{"-", "6.30442381193081`*^15"}], ",", "3.152211905965405`*^15"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "6.304423811930813`*^15"}], ",", "1.2608847623861622`*^16", 
     ",", 
     RowBox[{"-", "6.30442381193081`*^15"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.152211905965407`*^15", ",", 
     RowBox[{"-", "6.304423811930811`*^15"}], ",", "3.152211905965405`*^15"}],
     "}"}]}], "}"}]], "Output",
 ImageSize->{324, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->46827346]
}, Open  ]],

Cell[TextData[{
 "If you work with high\[Hyphen]precision approximate numbers, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will keep track of the precision of matrix inverses that you generate."
}], "Text",
 CellID->15281],

Cell["\<\
This generates a 6\[Times]6 numerical matrix with entries of 20\[Hyphen]digit \
precision. \
\>", "MathCaption",
 CellID->31888],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"GCD", "[", 
         RowBox[{"i", ",", "j"}], "]"}], "+", "1"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "6"}], "}"}]}], "]"}], ",", "20"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->20795],

Cell["\<\
This takes the matrix, multiplies it by its inverse, and shows the first row \
of the result. \
\>", "MathCaption",
 CellID->23638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"m", ".", 
    RowBox[{"Inverse", "[", "m", "]"}]}], ")"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->29411],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`18.619788758288397", ",", "0``18.69897000433602", ",", 
   "0``18.92081875395238", ",", "0``19.397940008672037", ",", 
   "0``19.69897000433602", ",", "0``19.096910013008056"}], "}"}]], "Output",
 ImageSize->{488, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->276247888]
}, Open  ]],

Cell["\<\
This generates a 20\[Hyphen]digit numerical approximation to a 6\[Times]6 \
Hilbert matrix. Hilbert matrices are notoriously hard to invert numerically. \
\
\>", "MathCaption",
 CellID->19647],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"i", "+", "j", "-", "1"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "6"}], "}"}]}], "]"}], ",", "20"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->6655],

Cell["\<\
The result is still correct, but the zeros now have lower accuracy. \
\>", "MathCaption",
 CellID->10371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"m", ".", 
    RowBox[{"Inverse", "[", "m", "]"}]}], ")"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->25502],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.00000000000000000000000000009`15.971835580575531", ",", 
   "0``14.527946008550298", ",", "0``13.704283396534018", ",", 
   "0``13.293534847446105", ",", "0``13.2538143365858", ",", 
   "0``13.660680556570679"}], "}"}]], "Output",
 ImageSize->{467, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->73658333]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Inverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inverse"]], "InlineFormula"],
 " works only on square matrices. \"",
 ButtonBox["Advanced Matrix Operations\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AdvancedMatrixOperations"],
 " discusses the function ",
 Cell[BoxData[
  ButtonBox["PseudoInverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PseudoInverse"]], "InlineFormula"],
 ", which can also be used with non\[Hyphen]square matrices. "
}], "Text",
 CellID->27761]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Matrix Inversion - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 24.1644506}", "context" -> "", 
    "keywords" -> {
     "chop", "Inverse", "inverse of a matrix", "LINPACK", "matrices", 
      "matrix inversion", "singular matrices"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Matrix inversion. Here is a simple 2x2 matrix. This gives the inverse of \
m. In producing this formula, Mathematica implicitly assumes that the \
determinant ad-bc is non-zero.", "synonyms" -> {"3.7.6"}, "title" -> 
    "Matrix Inversion", "type" -> "Tutorial", "uri" -> 
    "tutorial/MatrixInversion"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.7.6"->{
  Cell[1173, 41, 78, 2, 70, "Title",
   CellTags->{"S3.7.6", "6.1"},
   CellID->7971]},
 "6.1"->{
  Cell[1173, 41, 78, 2, 70, "Title",
   CellTags->{"S3.7.6", "6.1"},
   CellID->7971]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.7.6", 22203, 836},
 {"6.1", 22301, 840}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 548, 14, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1173, 41, 78, 2, 70, "Title",
 CellTags->{"S3.7.6", "6.1"},
 CellID->7971],
Cell[1254, 45, 552, 16, 70, "DefinitionBox",
 CellID->6490],
Cell[1809, 63, 52, 1, 70, "Caption",
 CellID->2209],
Cell[1864, 66, 74, 1, 70, "MathCaption",
 CellID->25458],
Cell[CellGroupData[{
Cell[1963, 71, 237, 9, 28, "Input",
 CellID->20925],
Cell[2203, 82, 302, 11, 36, "Output",
 CellID->562054830]
}, Open  ]],
Cell[2520, 96, 372, 13, 70, "MathCaption",
 CellID->25868],
Cell[CellGroupData[{
Cell[2917, 113, 99, 3, 28, "Input",
 CellID->18964],
Cell[3019, 118, 878, 33, 52, "Output",
 CellID->576174391]
}, Open  ]],
Cell[3912, 154, 128, 4, 70, "MathCaption",
 CellID->7905],
Cell[CellGroupData[{
Cell[4065, 162, 88, 3, 28, "Input",
 CellID->21289],
Cell[4156, 167, 1066, 39, 52, "Output",
 CellID->775291989]
}, Open  ]],
Cell[5237, 209, 263, 8, 70, "MathCaption",
 CellID->15355],
Cell[CellGroupData[{
Cell[5525, 221, 100, 3, 70, "Input",
 CellID->23396],
Cell[5628, 226, 302, 11, 36, "Output",
 CellID->321303903]
}, Open  ]],
Cell[5945, 240, 77, 1, 70, "MathCaption",
 CellID->10341],
Cell[CellGroupData[{
Cell[6047, 245, 335, 12, 70, "Input",
 CellID->17049],
Cell[6385, 259, 884, 31, 51, "Output",
 CellID->324962996]
}, Open  ]],
Cell[7284, 293, 143, 5, 70, "MathCaption",
 CellID->26784],
Cell[CellGroupData[{
Cell[7452, 302, 100, 3, 70, "Input",
 CellID->21426],
Cell[7555, 307, 720, 23, 54, "Output",
 CellID->199189838]
}, Open  ]],
Cell[8290, 333, 108, 3, 70, "MathCaption",
 CellID->4611],
Cell[CellGroupData[{
Cell[8423, 340, 89, 3, 70, "Input",
 CellID->18822],
Cell[8515, 345, 500, 15, 36, "Output",
 CellID->411613208]
}, Open  ]],
Cell[9030, 363, 206, 6, 70, "MathCaption",
 CellID->8258],
Cell[CellGroupData[{
Cell[9261, 373, 248, 9, 70, "Input",
 CellID->26411],
Cell[9512, 384, 439, 9, 70, "Message",
 CellID->132577143],
Cell[9954, 395, 341, 12, 36, "Output",
 CellID->844281940]
}, Open  ]],
Cell[10310, 410, 379, 10, 70, "Text",
 CellID->24985],
Cell[10692, 422, 93, 1, 70, "MathCaption",
 CellID->30503],
Cell[CellGroupData[{
Cell[10810, 427, 245, 9, 70, "Input",
 CellID->32362],
Cell[11058, 438, 314, 11, 36, "Output",
 CellID->507512046]
}, Open  ]],
Cell[11387, 452, 73, 1, 70, "MathCaption",
 CellID->25922],
Cell[CellGroupData[{
Cell[11485, 457, 100, 3, 70, "Input",
 CellID->29040],
Cell[11588, 462, 419, 14, 36, "Output",
 CellID->658418002]
}, Open  ]],
Cell[12022, 479, 142, 4, 70, "MathCaption",
 CellID->15937],
Cell[CellGroupData[{
Cell[12189, 487, 89, 3, 70, "Input",
 CellID->30012],
Cell[12281, 492, 392, 13, 39, "Output",
 CellID->175017801]
}, Open  ]],
Cell[12688, 508, 230, 8, 70, "MathCaption",
 CellID->26919],
Cell[CellGroupData[{
Cell[12943, 520, 97, 3, 70, "Input",
 CellID->27091],
Cell[13043, 525, 338, 11, 36, "Output",
 CellID->39360834]
}, Open  ]],
Cell[13396, 539, 651, 16, 70, "Text",
 CellID->11160],
Cell[14050, 557, 185, 6, 70, "MathCaption",
 CellID->1405],
Cell[CellGroupData[{
Cell[14260, 567, 253, 9, 70, "Input",
 CellID->11425],
Cell[14516, 578, 448, 9, 70, "Message",
 CellID->233763782],
Cell[14967, 589, 350, 12, 36, "Output",
 CellID->594795930]
}, Open  ]],
Cell[15332, 604, 134, 4, 70, "MathCaption",
 CellID->283876961],
Cell[CellGroupData[{
Cell[15491, 612, 383, 13, 70, "Input",
 CellID->117205459],
Cell[15877, 627, 563, 10, 70, "Message",
 CellID->18639592],
Cell[16443, 639, 679, 20, 77, "Output",
 CellID->46827346]
}, Open  ]],
Cell[17137, 662, 233, 6, 70, "Text",
 CellID->15281],
Cell[17373, 670, 138, 4, 70, "MathCaption",
 CellID->31888],
Cell[17514, 676, 445, 16, 70, "Input",
 CellID->20795],
Cell[17962, 694, 141, 4, 70, "MathCaption",
 CellID->23638],
Cell[CellGroupData[{
Cell[18128, 702, 200, 7, 70, "Input",
 CellID->29411],
Cell[18331, 711, 373, 10, 39, "Output",
 CellID->276247888]
}, Open  ]],
Cell[18719, 724, 202, 5, 70, "MathCaption",
 CellID->19647],
Cell[18924, 731, 447, 16, 70, "Input",
 CellID->6655],
Cell[19374, 749, 115, 3, 70, "MathCaption",
 CellID->10371],
Cell[CellGroupData[{
Cell[19514, 756, 200, 7, 70, "Input",
 CellID->25502],
Cell[19717, 765, 406, 11, 39, "Output",
 CellID->73658333]
}, Open  ]],
Cell[20138, 779, 543, 16, 70, "Text",
 CellID->27761]
}, Open  ]],
Cell[20696, 798, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

