(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16660,        581]
NotebookOptionsPosition[     10770,        410]
NotebookOutlinePosition[     14253,        490]
CellTagsIndexPosition[     14160,        484]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Transformation Rules and Definitions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Transformation Rules and Definitions\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Protect" :> Documentation`HelpLookup["paclet:ref/Protect"], 
          "Unprotect" :> Documentation`HelpLookup["paclet:ref/Unprotect"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Protect\"\>", 
       2->"\<\"Unprotect\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Modifying Built\[Hyphen]in Functions", "Title",
 CellTags->{"S2.5.12", "12.1"},
 CellID->15536],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to define transformation rules for any expression. You can \
define such rules not only for functions that you add to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", but also for intrinsic functions that are already built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". As a result, you can enhance, or modify, the features of built\[Hyphen]in \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions. "
}], "Text",
 CellID->18043],

Cell[TextData[{
 "This capability is powerful, but potentially dangerous. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will always follow the rules you give it. This means that if the rules you \
give are incorrect, then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will give you incorrect answers. "
}], "Text",
 CellID->31493],

Cell[TextData[{
 "To avoid the possibility of changing built\[Hyphen]in functions by mistake, \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \[OpenCurlyDoubleQuote]protects\[CloseCurlyDoubleQuote] all \
built\[Hyphen]in functions from redefinition. If you want to give a \
definition for a built\[Hyphen]in function, you have to remove the protection \
first. After you give the definition, you should usually restore the \
protection, to prevent future mistakes. "
}], "Text",
 CellID->32146],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Unprotect",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Unprotect"], "[", 
     StyleBox["f", "TI"], "]"}], Cell["remove protection", "TableText"]},
   {
    RowBox[{
     ButtonBox["Protect",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Protect"], "[", 
     StyleBox["f", "TI"], "]"}], Cell["add protection", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5021],

Cell["Protection for functions. ", "Caption",
 CellID->15828],

Cell["\<\
Built\[Hyphen]in functions are usually \[OpenCurlyDoubleQuote]protected\
\[CloseCurlyDoubleQuote], so you cannot redefine them. \
\>", "MathCaption",
 CellID->27094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", "7", "]"}], "=", "2"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22218],

Cell[BoxData[
 RowBox[{
  RowBox[{"Set", "::", "\<\"write\"\>"}], ":", 
  " ", "\<\"Tag \\!\\(Log\\) in \\!\\(Log[7]\\) is Protected. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/write\\\", \
ButtonNote -> \\\"Set::write\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[1]:=",
 CellID->52488480],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->154159422]
}, Open  ]],

Cell[TextData[{
 "This removes protection for ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->9496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Unprotect", "[", "Log", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29027],

Cell[BoxData[
 RowBox[{"{", "\<\"Log\"\>", "}"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18100981]
}, Open  ]],

Cell[TextData[{
 "Now you can give your own definitions for ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 ". This particular definition is not mathematically correct, but ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will still allow you to give it."
}], "MathCaption",
 CellID->22085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", "7", "]"}], "=", "2"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5403],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->18916890]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will use your definitions whenever it can, whether they are mathematically \
correct or not. "
}], "MathCaption",
 CellID->14776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", "7", "]"}], "+", 
  RowBox[{"Log", "[", "3", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->22685],

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"Log", "[", "3", "]"}]}]], "Output",
 ImageSize->{66, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->321416366]
}, Open  ]],

Cell[TextData[{
 "This removes the incorrect definition for ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->25066],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", "7", "]"}], "=."}]], "Input",
 CellLabel->"In[5]:=",
 CellID->7254],

Cell[TextData[{
 "This restores the protection for ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Protect", "[", "Log", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->9942],

Cell[BoxData[
 RowBox[{"{", "\<\"Log\"\>", "}"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->272328950]
}, Open  ]],

Cell[TextData[{
 "Definitions you give can override built\[Hyphen]in features of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". In general, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tries to use your definitions before it uses built\[Hyphen]in definitions. \
"
}], "Text",
 CellID->1500],

Cell[TextData[{
 "The rules that are built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are intended to be appropriate for the broadest range of calculations. In \
specific cases, however, you may not like what the built\[Hyphen]in rules do. \
In such cases, you can give your own rules to override the ones that are \
built in. "
}], "Text",
 CellID->26150],

Cell[TextData[{
 "There is a built\[Hyphen]in rule for simplifying ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exp"], "[", 
   RowBox[{
    ButtonBox["Log",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Log"], "[", 
    StyleBox["expr", "TI"], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->15866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"Log", "[", "y", "]"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->5209],

Cell[BoxData["y"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->711516311]
}, Open  ]],

Cell[TextData[{
 "You can give your own rule for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exp"], "[", 
   RowBox[{
    ButtonBox["Log",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Log"], "[", 
    StyleBox["expr", "TI"], "]"}], "]"}]], "InlineFormula"],
 ", overriding the built\[Hyphen]in rule. "
}], "MathCaption",
 CellID->6398],

Cell[BoxData[
 RowBox[{"(", 
  RowBox[{
   RowBox[{"Unprotect", "[", "Exp", "]"}], ";", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"Log", "[", "expr_", "]"}], "]"}], ":=", 
    RowBox[{"explog", "[", "expr", "]"}]}], ";", 
   RowBox[{"Protect", "[", "Exp", "]"}], ";"}], ")"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->17500],

Cell["\<\
Now your rule is used, rather than the built\[Hyphen]in one. \
\>", "MathCaption",
 CellID->182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"Log", "[", "y", "]"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1916],

Cell[BoxData[
 RowBox[{"explog", "[", "y", "]"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->41690596]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->349581818],

Cell[TextData[ButtonBox["Transformation Rules and Definitions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], \
"RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Modifying Built-in Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Transformation Rules and Definitions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DefiningNumericalValues"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ManipulatingValueLists"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 29.8989724}", "context" -> "", 
    "keywords" -> {
     "builtin functions", "built-in functions", "definitions", "functions", 
      "modifying builtin functions", "overriding builtin definitions", 
      "protect", "security", "system functions", "Unprotect", "unwritable", 
      "write protection"}, "index" -> True, "label" -> "Mathematica Tutorial",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica allows you to define transformation rules for any \
expression. You can define such rules not only for functions that you add to \
Mathematica, but also for intrinsic functions that are already built into \
Mathematica. As a result, you can enhance, or modify, the features of \
built-in Mathematica functions. This capability is powerful, but potentially \
dangerous. Mathematica will always follow the rules you give it. This means \
that if the rules you give are incorrect, then Mathematica will give you \
incorrect answers. To avoid the possibility of changing built-in functions by \
mistake, Mathematica 'protects' all built-in functions from redefinition. If \
you want to give a definition for a built-in function, you have to remove the \
protection first. After you give the definition, you should usually restore \
the protection, to prevent future mistakes. ", "synonyms" -> {"2.5.12"}, 
    "title" -> "Modifying Built-in Functions", "type" -> "Tutorial", "uri" -> 
    "tutorial/ModifyingBuiltInFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.5.12"->{
  Cell[1952, 60, 101, 2, 70, "Title",
   CellTags->{"S2.5.12", "12.1"},
   CellID->15536]},
 "12.1"->{
  Cell[1952, 60, 101, 2, 70, "Title",
   CellTags->{"S2.5.12", "12.1"},
   CellID->15536]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.5.12", 13942, 473},
 {"12.1", 14045, 477}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1327, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1952, 60, 101, 2, 70, "Title",
 CellTags->{"S2.5.12", "12.1"},
 CellID->15536],
Cell[2056, 64, 541, 16, 70, "Text",
 CellID->18043],
Cell[2600, 82, 348, 10, 70, "Text",
 CellID->31493],
Cell[2951, 94, 503, 11, 70, "Text",
 CellID->32146],
Cell[3457, 107, 715, 21, 70, "DefinitionBox",
 CellID->5021],
Cell[4175, 130, 61, 1, 70, "Caption",
 CellID->15828],
Cell[4239, 133, 175, 4, 70, "MathCaption",
 CellID->27094],
Cell[CellGroupData[{
Cell[4439, 141, 118, 4, 70, "Input",
 CellID->22218],
Cell[4560, 147, 411, 8, 19, "Message",
 CellID->52488480],
Cell[4974, 157, 158, 5, 36, "Output",
 CellID->154159422]
}, Open  ]],
Cell[5147, 165, 197, 8, 70, "MathCaption",
 CellID->9496],
Cell[CellGroupData[{
Cell[5369, 177, 103, 3, 70, "Input",
 CellID->29027],
Cell[5475, 182, 189, 6, 36, "Output",
 CellID->18100981]
}, Open  ]],
Cell[5679, 191, 361, 11, 70, "MathCaption",
 CellID->22085],
Cell[CellGroupData[{
Cell[6065, 206, 117, 4, 70, "Input",
 CellID->5403],
Cell[6185, 212, 157, 5, 36, "Output",
 CellID->18916890]
}, Open  ]],
Cell[6357, 220, 197, 6, 70, "MathCaption",
 CellID->14776],
Cell[CellGroupData[{
Cell[6579, 230, 148, 5, 70, "Input",
 CellID->22685],
Cell[6730, 237, 210, 7, 36, "Output",
 CellID->321416366]
}, Open  ]],
Cell[6955, 247, 212, 8, 70, "MathCaption",
 CellID->25066],
Cell[7170, 257, 113, 4, 70, "Input",
 CellID->7254],
Cell[7286, 263, 203, 8, 70, "MathCaption",
 CellID->21354],
Cell[CellGroupData[{
Cell[7514, 275, 100, 3, 70, "Input",
 CellID->9942],
Cell[7617, 280, 190, 6, 36, "Output",
 CellID->272328950]
}, Open  ]],
Cell[7822, 289, 309, 10, 70, "Text",
 CellID->1500],
Cell[8134, 301, 373, 9, 70, "Text",
 CellID->26150],
Cell[8510, 312, 380, 14, 70, "MathCaption",
 CellID->15866],
Cell[CellGroupData[{
Cell[8915, 330, 124, 4, 70, "Input",
 CellID->5209],
Cell[9042, 336, 158, 5, 36, "Output",
 CellID->711516311]
}, Open  ]],
Cell[9215, 344, 399, 14, 70, "MathCaption",
 CellID->6398],
Cell[9617, 360, 334, 10, 70, "Input",
 CellID->17500],
Cell[9954, 372, 106, 3, 70, "MathCaption",
 CellID->182],
Cell[CellGroupData[{
Cell[10085, 379, 124, 4, 70, "Input",
 CellID->1916],
Cell[10212, 385, 189, 6, 36, "Output",
 CellID->41690596]
}, Open  ]],
Cell[CellGroupData[{
Cell[10438, 396, 72, 1, 70, "RelatedTutorialsSection",
 CellID->349581818],
Cell[10513, 399, 203, 5, 70, "RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],
Cell[10743, 408, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

