(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24856,        928]
NotebookOptionsPosition[     17557,        695]
NotebookOutlinePosition[     20692,        769]
CellTagsIndexPosition[     20601,        763]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Modularity and the Naming of Things" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Modularity and the Naming of Things\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Module" :> Documentation`HelpLookup["paclet:ref/Module"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Module\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Modules and Local Variables", "Title",
 CellTags->{"S2.7.1", "1.1"},
 CellID->7693],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " normally assumes that all your variables are ",
 StyleBox["global",
  FontSlant->"Italic"],
 ". This means that every time you use a name like ",
 Cell[BoxData["x"], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " normally assumes that you are referring to the ",
 StyleBox["same",
  FontSlant->"Italic"],
 " object. "
}], "Text",
 CellID->3253],

Cell[TextData[{
 "Particularly when you write programs, however, you may not want all your \
variables to be global. You may, for example, want to use the name ",
 Cell[BoxData["x"], "InlineFormula"],
 " to refer to two quite different variables in two different programs. In \
this case, you need the ",
 Cell[BoxData["x"], "InlineFormula"],
 " in each program to be treated as a ",
 StyleBox["local",
  FontSlant->"Italic"],
 " variable. "
}], "Text",
 CellID->1924],

Cell[TextData[{
 "You can set up local variables in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using ",
 StyleBox["modules",
  FontSlant->"Italic"],
 ". Within each module, you can give a list of variables which are to be \
treated as local to the module. "
}], "Text",
 CellID->24621],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Module",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Module"], "[", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["body", "TI"], "]"}], Cell[TextData[{
     "a module with local variables ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", \[Ellipsis]",
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25248],

Cell[TextData[{
 "Creating modules in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->16111],

Cell[TextData[{
 "This defines the global variable ",
 Cell[BoxData["t"], "InlineFormula"],
 " to have value 17. "
}], "MathCaption",
 CellID->9275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", "17"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->22043],

Cell[BoxData["17"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->27103]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData["t"], "InlineFormula"],
 " inside the module is local, so it can be treated independently of the \
global ",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "t", "}"}], ",", 
   RowBox[{
    RowBox[{"t", "=", "8"}], ";", 
    RowBox[{"Print", "[", "t", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->28116],

Cell[BoxData["8"], "Print",
 CellID->29723]
}, Open  ]],

Cell[TextData[{
 "The global ",
 Cell[BoxData["t"], "InlineFormula"],
 " still has value 17. "
}], "MathCaption",
 CellID->4285],

Cell[CellGroupData[{

Cell[BoxData["t"], "Input",
 CellLabel->"In[3]:= ",
 CellID->15203],

Cell[BoxData["17"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->19712]
}, Open  ]],

Cell["\<\
The most common way that modules are used is to set up temporary or \
intermediate variables inside functions you define. It is important to make \
sure that such variables are kept local. If they are not, then you will run \
into trouble whenever their names happen to coincide with the names of other \
variables. \
\>", "Text",
 CellID->27117],

Cell[TextData[{
 "The intermediate variable ",
 Cell[BoxData["t"], "InlineFormula"],
 " is specified to be local to the module. "
}], "MathCaption",
 CellID->19084],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "v_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "t", "}"}], ",", 
    RowBox[{
     RowBox[{"t", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "v"}], ")"}], "^", "2"}]}], ";", 
     RowBox[{"t", "=", 
      RowBox[{"Expand", "[", "t", "]"}]}]}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->15469],

Cell[TextData[{
 "This runs the function ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->15807],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", "+", "b"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->15966],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "a"}], "+", 
  SuperscriptBox["a", "2"], "+", 
  RowBox[{"2", " ", "b"}], "+", 
  RowBox[{"2", " ", "a", " ", "b"}], "+", 
  SuperscriptBox["b", "2"]}]], "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->21104]
}, Open  ]],

Cell[TextData[{
 "The global ",
 Cell[BoxData["t"], "InlineFormula"],
 " still has value 17. "
}], "MathCaption",
 CellID->10584],

Cell[CellGroupData[{

Cell[BoxData["t"], "Input",
 CellLabel->"In[6]:= ",
 CellID->11381],

Cell[BoxData["17"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->2065]
}, Open  ]],

Cell["\<\
You can treat local variables in modules just like other symbols. Thus, for \
example, you can use them as names for local functions, you can assign \
attributes to them, and so on. \
\>", "Text",
 CellID->4372],

Cell[TextData[{
 "This sets up a module which defines a local function ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->630],

Cell[BoxData[
 RowBox[{
  RowBox[{"gfac10", "[", "k_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"f", ",", "n"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "=", "1"}], ";", 
     RowBox[{
      RowBox[{"f", "[", "n_", "]"}], ":=", 
      RowBox[{"k", "+", 
       RowBox[{"n", " ", 
        RowBox[{"f", "[", 
         RowBox[{"n", "-", "1"}], "]"}]}]}]}], ";", 
     RowBox[{"f", "[", "10", "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->10560],

Cell[TextData[{
 "In this case, the local function ",
 Cell[BoxData["f"], "InlineFormula"],
 " is just an ordinary factorial. "
}], "MathCaption",
 CellID->9087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gfac10", "[", "0", "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->2715],

Cell[BoxData["3628800"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->11945]
}, Open  ]],

Cell[TextData[{
 "In this case, ",
 Cell[BoxData["f"], "InlineFormula"],
 " is set up as a generalized factorial. "
}], "MathCaption",
 CellID->25993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gfac10", "[", "2", "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->2621],

Cell[BoxData["8841802"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->26842]
}, Open  ]],

Cell[TextData[{
 "When you set up a local variable in a module, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " initially assigns no value to the variable. This means that you can use \
the variable in a purely symbolic way, even if there was a global value \
defined for the variable outside the module. "
}], "Text",
 CellID->11465],

Cell[TextData[{
 "This uses the global value of ",
 Cell[BoxData["t"], "InlineFormula"],
 " defined above, and so yields a number. "
}], "MathCaption",
 CellID->12249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "t"}], ")"}], "^", "3"}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->12158],

Cell[BoxData["5832"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->30148]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  ButtonBox["Length",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Length"]], "InlineFormula"],
 " simply receives a number as its argument. "
}], "MathCaption",
 CellID->29766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "t"}], ")"}], "^", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->25070],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->1496]
}, Open  ]],

Cell[TextData[{
 "The local variable ",
 Cell[BoxData["t"], "InlineFormula"],
 " has no value, so it acts as a symbol, and ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " produces the anticipated algebraic result. "
}], "MathCaption",
 CellID->6693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "t", "}"}], ",", 
   RowBox[{"Length", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "t"}], ")"}], "^", "3"}], "]"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->18703],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->29967]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Module",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Module"], "[", "{", 
     StyleBox["x", "TI"], "=", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], ",", 
     StyleBox["y", "TI"], "=", 
     SubscriptBox[
      StyleBox["y", "TI"], "0"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["body", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[
    "a module with initial values for local variables", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4683],

Cell["Assigning initial values to local variables. ", "Caption",
 CellID->13460],

Cell[TextData[{
 "This specifies ",
 Cell[BoxData["t"], "InlineFormula"],
 " to be a local variable, with initial value ",
 Cell[BoxData["u"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1714],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "u_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t", "=", "u"}], "}"}], ",", 
    RowBox[{"t", "+=", 
     RowBox[{"t", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", "u"}], ")"}]}]}]}], "]"}]}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->12444],

Cell[TextData[{
 "This uses the definition of ",
 Cell[BoxData["g"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "[", "a", "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->23714],

Cell[BoxData[
 RowBox[{"a", "+", 
  FractionBox["a", 
   RowBox[{"1", "+", "a"}]]}]], "Output",
 ImageSize->{55, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->9924]
}, Open  ]],

Cell[TextData[{
 "You can define initial values for any of the local variables in a module. \
The initial values are always evaluated before the module is executed. As a \
result, even if a variable ",
 Cell[BoxData["x"], "InlineFormula"],
 " is defined as local to the module, the global ",
 Cell[BoxData["x"], "InlineFormula"],
 " will be used if it appears in an expression for an initial value. "
}], "Text",
 CellID->9961],

Cell[TextData[{
 "The initial value of ",
 Cell[BoxData["u"], "InlineFormula"],
 " is taken to be the global value of ",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "=", "6"}], ",", 
     RowBox[{"u", "=", "t"}]}], "}"}], ",", 
   RowBox[{"u", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->26200],

Cell[BoxData["289"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->1667]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["lhs", "TI"], ":=", 
     ButtonBox["Module",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Module"], "[", 
     StyleBox["vars", "TI"], ",", 
     StyleBox["rhs", "TI"], "/;", 
     StyleBox["cond", "TI"], "]"}], Cell[TextData[{
     "share local variables between ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["cond", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29772],

Cell["Using local variables in definitions with conditions. ", "Caption",
 CellID->5249],

Cell[TextData[{
 "When you set up ",
 Cell[BoxData["/;"], "InlineFormula"],
 " conditions for definitions, you often need to introduce temporary \
variables. In many cases, you may want to share these temporary variables \
with the body of the right\[Hyphen]hand side of the definition. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to enclose the whole right\[Hyphen]hand side of your definition \
in a module, including the condition. "
}], "Text",
 CellID->14817],

Cell["This defines a function with a condition attached. ", "MathCaption",
 CellID->12218],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", "x_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "t", "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"t", "^", "2"}], "-", "1"}], "/;", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"t", "=", 
        RowBox[{"x", "-", "4"}]}], ")"}], ">", "1"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->29813],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " shares the value of the local variable ",
 Cell[BoxData["t"], "InlineFormula"],
 " between the condition and the body of the right\[Hyphen]hand side. "
}], "MathCaption",
 CellID->27358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "[", "10", "]"}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->21379],

Cell[BoxData["35"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->10469]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->147809681],

Cell[TextData[ButtonBox["Modularity and the Naming of Things",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], \
"RelatedTutorials",
 CellID->405226890]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Modules and Local Variables - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Modularity and the Naming of Things", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/LocalConstants"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 30.2896074}", "context" -> "", 
    "keywords" -> {
     "assignments", "automatic variables", "blocks", "procedures", 
      "condition", "conditions", "conflicts", "declarations", "definitions", 
      "functions", "global variables", "initial values", 
      "intermediate variables", "local functions", "local variables", 
      "module", "names", "objects", "procedure", "procedures", "programs", 
      "scoping", "section", "symbols", "temporary variables", "variables"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica normally assumes that all your variables are global. This \
means that every time you use a name like x, Mathematica normally assumes \
that you are referring to the same object. Particularly when you write \
programs, however, you may not want all your variables to be global. You may, \
for example, want to use the name x to refer to two quite different variables \
in two different programs. In this case, you need the x in each program to be \
treated as a local variable. You can set up local variables in Mathematica \
using modules. Within each module, you can give a list of variables which are \
to be treated as local to the module. ", "synonyms" -> {"2.7.1"}, "title" -> 
    "Modules and Local Variables", "type" -> "Tutorial", "uri" -> 
    "tutorial/ModulesAndLocalVariables"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.7.1"->{
  Cell[1844, 59, 89, 2, 70, "Title",
   CellTags->{"S2.7.1", "1.1"},
   CellID->7693]},
 "1.1"->{
  Cell[1844, 59, 89, 2, 70, "Title",
   CellTags->{"S2.7.1", "1.1"},
   CellID->7693]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.7.1", 20392, 752},
 {"1.1", 20490, 756}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1219, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1844, 59, 89, 2, 70, "Title",
 CellTags->{"S2.7.1", "1.1"},
 CellID->7693],
Cell[1936, 63, 442, 16, 70, "Text",
 CellID->3253],
Cell[2381, 81, 468, 12, 70, "Text",
 CellID->1924],
Cell[2852, 95, 297, 10, 70, "Text",
 CellID->24621],
Cell[3152, 107, 856, 27, 70, "DefinitionBox",
 CellID->25248],
Cell[4011, 136, 126, 6, 70, "Caption",
 CellID->16111],
Cell[4140, 144, 148, 5, 70, "MathCaption",
 CellID->9275],
Cell[CellGroupData[{
Cell[4313, 153, 90, 3, 28, "Input",
 CellID->22043],
Cell[4406, 158, 156, 5, 36, "Output",
 CellID->27103]
}, Open  ]],
Cell[4577, 166, 225, 8, 70, "MathCaption",
 CellID->1623],
Cell[CellGroupData[{
Cell[4827, 178, 229, 8, 70, "Input",
 CellID->28116],
Cell[5059, 188, 43, 1, 70, "Print",
 CellID->29723]
}, Open  ]],
Cell[5117, 192, 128, 5, 70, "MathCaption",
 CellID->4285],
Cell[CellGroupData[{
Cell[5270, 201, 67, 2, 70, "Input",
 CellID->15203],
Cell[5340, 205, 156, 5, 36, "Output",
 CellID->19712]
}, Open  ]],
Cell[5511, 213, 356, 7, 70, "Text",
 CellID->27117],
Cell[5870, 222, 164, 5, 70, "MathCaption",
 CellID->19084],
Cell[6037, 229, 399, 14, 70, "Input",
 CellID->15469],
Cell[6439, 245, 122, 5, 70, "MathCaption",
 CellID->15807],
Cell[CellGroupData[{
Cell[6586, 254, 117, 4, 70, "Input",
 CellID->15966],
Cell[6706, 260, 345, 11, 36, "Output",
 CellID->21104]
}, Open  ]],
Cell[7066, 274, 129, 5, 70, "MathCaption",
 CellID->10584],
Cell[CellGroupData[{
Cell[7220, 283, 67, 2, 70, "Input",
 CellID->11381],
Cell[7290, 287, 155, 5, 36, "Output",
 CellID->2065]
}, Open  ]],
Cell[7460, 295, 221, 5, 70, "Text",
 CellID->4372],
Cell[7684, 302, 150, 5, 70, "MathCaption",
 CellID->630],
Cell[7837, 309, 536, 18, 70, "Input",
 CellID->10560],
Cell[8376, 329, 161, 5, 70, "MathCaption",
 CellID->9087],
Cell[CellGroupData[{
Cell[8562, 338, 98, 3, 70, "Input",
 CellID->2715],
Cell[8663, 343, 161, 5, 36, "Output",
 CellID->11945]
}, Open  ]],
Cell[8839, 351, 150, 5, 70, "MathCaption",
 CellID->25993],
Cell[CellGroupData[{
Cell[9014, 360, 98, 3, 70, "Input",
 CellID->2621],
Cell[9115, 365, 161, 5, 36, "Output",
 CellID->26842]
}, Open  ]],
Cell[9291, 373, 341, 8, 70, "Text",
 CellID->11465],
Cell[9635, 383, 167, 5, 70, "MathCaption",
 CellID->12249],
Cell[CellGroupData[{
Cell[9827, 392, 172, 6, 70, "Input",
 CellID->12158],
Cell[10002, 400, 159, 5, 36, "Output",
 CellID->30148]
}, Open  ]],
Cell[10176, 408, 222, 8, 70, "MathCaption",
 CellID->29766],
Cell[CellGroupData[{
Cell[10423, 420, 208, 7, 70, "Input",
 CellID->25070],
Cell[10634, 429, 155, 5, 36, "Output",
 CellID->1496]
}, Open  ]],
Cell[10804, 437, 322, 10, 70, "MathCaption",
 CellID->6693],
Cell[CellGroupData[{
Cell[11151, 451, 300, 11, 70, "Input",
 CellID->18703],
Cell[11454, 464, 156, 5, 36, "Output",
 CellID->29967]
}, Open  ]],
Cell[11625, 472, 949, 27, 70, "DefinitionBox",
 CellID->4683],
Cell[12577, 501, 80, 1, 70, "Caption",
 CellID->13460],
Cell[12660, 504, 200, 7, 70, "MathCaption",
 CellID->1714],
Cell[12863, 513, 335, 12, 70, "Input",
 CellID->12444],
Cell[13201, 527, 127, 5, 70, "MathCaption",
 CellID->12415],
Cell[CellGroupData[{
Cell[13353, 536, 95, 3, 70, "Input",
 CellID->23714],
Cell[13451, 541, 222, 8, 49, "Output",
 CellID->9924]
}, Open  ]],
Cell[13688, 552, 427, 9, 70, "Text",
 CellID->9961],
Cell[14118, 563, 199, 7, 70, "MathCaption",
 CellID->27725],
Cell[CellGroupData[{
Cell[14342, 574, 248, 9, 70, "Input",
 CellID->26200],
Cell[14593, 585, 157, 5, 36, "Output",
 CellID->1667]
}, Open  ]],
Cell[14765, 593, 821, 25, 70, "DefinitionBox",
 CellID->29772],
Cell[15589, 620, 88, 1, 70, "Caption",
 CellID->5249],
Cell[15680, 623, 486, 11, 70, "Text",
 CellID->14817],
Cell[16169, 636, 90, 1, 70, "MathCaption",
 CellID->12218],
Cell[16262, 639, 391, 14, 70, "Input",
 CellID->29813],
Cell[16656, 655, 254, 7, 70, "MathCaption",
 CellID->27358],
Cell[CellGroupData[{
Cell[16935, 666, 96, 3, 70, "Input",
 CellID->21379],
Cell[17034, 671, 157, 5, 36, "Output",
 CellID->10469]
}, Open  ]],
Cell[CellGroupData[{
Cell[17228, 681, 72, 1, 70, "RelatedTutorialsSection",
 CellID->147809681],
Cell[17303, 684, 200, 5, 70, "RelatedTutorials",
 CellID->405226890]
}, Open  ]]
}, Open  ]],
Cell[17530, 693, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

