(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26517,        869]
NotebookOptionsPosition[     20457,        679]
NotebookOutlinePosition[     23429,        754]
CellTagsIndexPosition[     23336,        748]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Operations on Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalOperationsOnFunctionsOverview"], 
          "The Algorithms of Mathematica" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheAlgorithmsOfMathematica"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Numerical Operations on Functions\"\>", 
       2->"\<\"The Algorithms of Mathematica\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Automatic" :> Documentation`HelpLookup["paclet:ref/Automatic"],
           "EvaluationMonitor" :> 
          Documentation`HelpLookup["paclet:ref/EvaluationMonitor"], "Method" :> 
          Documentation`HelpLookup["paclet:ref/Method"], "StepMonitor" :> 
          Documentation`HelpLookup["paclet:ref/StepMonitor"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Automatic\"\>", 
       2->"\<\"EvaluationMonitor\"\>", 3->"\<\"Method\"\>", 
       4->"\<\"StepMonitor\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Monitoring and Selecting Algorithms", "Title",
 CellTags->{"S3.9.10", "10.1"},
 CellID->25086],

Cell[TextData[{
 "Functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are carefully set up so that you normally do not have to know how they \
work inside. But particularly for numerical functions that use iterative \
algorithms, it is sometimes useful to be able to monitor the internal \
progress of these algorithms. "
}], "Text",
 CellID->5475],

Cell[BoxData[GridBox[{
   {
    ButtonBox["StepMonitor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StepMonitor"], Cell["\<\
an expression to evaluate whenever a successful step is taken\
\>", "TableText"]},
   {
    ButtonBox["EvaluationMonitor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EvaluationMonitor"], Cell["\<\
an expression to evaluate whenever functions from the input are evaluated\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32724],

Cell["Options for monitoring progress of numerical functions. ", "Caption",
 CellID->4246],

Cell[TextData[{
 "This prints the value of ",
 Cell[BoxData["x"], "InlineFormula"],
 " every time a step is taken. "
}], "MathCaption",
 CellID->5187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "==", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}], ",", 
   RowBox[{"StepMonitor", ":>", 
    RowBox[{"Print", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13517],

Cell[CellGroupData[{

Cell[BoxData["0.7503638678402439`"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->1755064330],

Cell[BoxData["0.7391128909113617`"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->551717133],

Cell[BoxData["0.739085133385284`"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->410684165],

Cell[BoxData["0.7390851332151607`"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->524861577]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "0.7390851332151607`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->758560910]
}, Open  ]],

Cell[TextData[{
 "Note the importance of using ",
 Cell[BoxData[
  RowBox[{
   StyleBox["option", "TI"], ":>", 
   StyleBox["expr", "TI"]}]], "InlineFormula"],
 " rather than ",
 Cell[BoxData[
  RowBox[{
   StyleBox["option", "TI"], "->", 
   StyleBox["expr", "TI"]}]], "InlineFormula"],
 ". You need a delayed rule ",
 Cell[BoxData[":>"], "InlineFormula"],
 " to make ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " be evaluated each time it is used, rather than just when the rule is \
given. "
}], "Text",
 CellID->12625],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reap",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reap"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Sow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sow"]], "InlineFormula"],
 " provide a convenient way to make a list of the steps taken. "
}], "MathCaption",
 CellID->23273],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{"FindRoot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "==", "x"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1"}], "}"}], ",", 
    RowBox[{"StepMonitor", ":>", 
     RowBox[{"Sow", "[", "x", "]"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9947],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0.7390851332151607`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "0.7503638678402439`", ",", "0.7391128909113617`", ",", 
      "0.739085133385284`", ",", "0.7390851332151607`"}], "}"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{408, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2109817432]
}, Open  ]],

Cell["This counts the steps. ", "MathCaption",
 CellID->17388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ct", "=", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FindRoot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", "x", "]"}], "==", "x"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1"}], "}"}], ",", 
       RowBox[{"StepMonitor", ":>", 
        RowBox[{"ct", "++"}]}]}], "]"}], ",", "ct"}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->20917],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0.7390851332151607`"}], "}"}], ",", "4"}], 
  "}"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1605244099]
}, Open  ]],

Cell["\<\
To take a successful step towards an answer, iterative numerical algorithms \
sometimes have to do several evaluations of the functions they have been \
given. Sometimes this is because each step requires, say, estimating a \
derivative from differences between function values, and sometimes it is \
because several attempts are needed to achieve a successful step. \
\>", "Text",
 CellID->29338],

Cell["\<\
This shows the successful steps taken in reaching the answer. \
\>", "MathCaption",
 CellID->32184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{"FindRoot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "==", "x"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "5"}], "}"}], ",", 
    RowBox[{"StepMonitor", ":>", 
     RowBox[{"Sow", "[", "x", "]"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->24957],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0.7390851332151607`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1.`"}], ",", 
      RowBox[{"-", "0.02837830412204312`"}], ",", "1.0296174587519653`", ",", 
      "0.7525886779802748`", ",", "0.7391248287000711`", ",", 
      "0.7390851335630761`", ",", "0.7390851332151607`"}], "}"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{583, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1386960553]
}, Open  ]],

Cell["This shows every time the function was evaluated. ", "MathCaption",
 CellID->31094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{"FindRoot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "==", "x"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "5"}], "}"}], ",", 
    RowBox[{"EvaluationMonitor", ":>", 
     RowBox[{"Sow", "[", "x", "]"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->29260],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0.7390851332151607`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"5.`", ",", 
      RowBox[{"-", "54.99999999999999`"}], ",", 
      RowBox[{"-", "1.`"}], ",", "8.716216958779569`", ",", 
      RowBox[{"-", "0.02837830412204312`"}], ",", "1.0296174587519653`", ",", 
      "0.7525886779802748`", ",", "0.7391248287000711`", ",", 
      "0.7390851335630761`", ",", "0.7390851332151607`"}], "}"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{446, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1786489625]
}, Open  ]],

Cell[TextData[{
 "The pattern of evaluations done by algorithms in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can be quite complicated. "
}], "MathCaption",
 CellID->253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Reap", "[", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"Sqrt", "[", "x", "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"EvaluationMonitor", ":>", 
       RowBox[{"Sow", "[", "x", "]"}]}]}], "]"}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "1"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->30665],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdlntoFWQYxo8psgRrxv4IiZymWTLCa97d512nzm26++3cbzu3CDPD8BAp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     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{{0., 264.}, {-0.9960213400237106, 0.9960213400237106}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1549562209]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Method",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Method"], "->", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}], Cell[
    "pick methods automatically (default)", "TableText"]},
   {
    RowBox[{
     ButtonBox["Method",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Method"], "->", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""}], Cell[
    "specify an explicit method to use", "TableText"]},
   {
    RowBox[{
     ButtonBox["Method",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Method"], "->", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"par\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", "->", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["1", "TR"]]}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], 
    "\[SpanFromLeft]"},
   {"", Cell["specify more details of a method", "TableText"]}
  }]], "DefinitionBox",
 CellID->15390],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " options. "
}], "Caption",
 CellID->7971],

Cell[TextData[{
 "There are often several different methods known for doing particular types \
of numerical computations. Typically ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports most generally successful ones that have been discussed in the \
literature, as well as many that have not. For any specific problem, it goes \
to considerable effort to pick the best method automatically. But if you have \
sophisticated knowledge of a problem, or are studying numerical methods for \
their own sake, you may find it useful to tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " explicitly what method it should use. Function reference pages list some \
of the methods built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "; others are discussed in ",
 ButtonBox["Numerical and Related Functions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#5107"], None}],
 " or in advanced documentation. "
}], "Text",
 CellID->12027],

Cell[TextData[{
 "This solves a differential equation using method ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 ", and returns the number of steps and evaluations needed. "
}], "MathCaption",
 CellID->24497],

Cell[BoxData[
 RowBox[{
  RowBox[{"try", "[", "m_", "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"s", "=", 
      RowBox[{"e", "=", "0"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
           RowBox[{"Sin", "[", 
            RowBox[{"y", "[", "x", "]"}], "]"}]}], "==", "0"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"y", "'"}], "[", "0", "]"}], "==", 
          RowBox[{"y", "[", "0", "]"}], "==", "1"}]}], "}"}], ",", "y", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "100"}], "}"}], ",", 
       RowBox[{"StepMonitor", ":>", 
        RowBox[{"s", "++"}]}], ",", 
       RowBox[{"EvaluationMonitor", ":>", 
        RowBox[{"e", "++"}]}], ",", 
       RowBox[{"Method", "->", "m"}]}], "]"}], ";", 
     RowBox[{"{", 
      RowBox[{"s", ",", "e"}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->19460],

Cell["\<\
With the method selected automatically, this is the number of steps and \
evaluations that are needed. \
\>", "MathCaption",
 CellID->28184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"try", "[", "Automatic", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->27491],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1118", ",", "2329"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->302940655]
}, Open  ]],

Cell["\<\
This shows what happens with several other possible methods. The Adams method \
that is selected automatically is the fastest. \
\>", "MathCaption",
 CellID->16491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"try", "/@", 
  RowBox[{"{", 
   RowBox[{
   "\"\<Adams\>\"", ",", "\"\<BDF\>\"", ",", "\"\<ExplicitRungeKutta\>\"", 
    ",", "\"\<ImplicitRungeKutta\>\"", ",", "\"\<Extrapolation\>\""}], 
   "}"}]}]], "Input",
 CellLabel->"In[9]:=",
 CellID->27940],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1118", ",", "2329"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2415", ",", "2861"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"287", ",", "4595"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"882", ",", "13092"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"84", ",", "4146"}], "}"}]}], "}"}]], "Output",
 ImageSize->{450, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->622516920]
}, Open  ]],

Cell["\<\
This shows what happens with the explicit Runge\[Hyphen]Kutta method when the \
difference order parameter is changed. \
\>", "MathCaption",
 CellID->8106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"try", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ExplicitRungeKutta\>\"", ",", 
      RowBox[{"\"\<DifferenceOrder\>\"", "->", "n"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "4", ",", "9"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->7413],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3519", ",", "14078"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"614", ",", "4300"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"849", ",", "6794"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"472", ",", "4722"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"288", ",", "3746"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"287", ",", "4594"}], "}"}]}], "}"}]], "Output",
 ImageSize->{536, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->638528536]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->153118904],

Cell[TextData[ButtonBox["Numerical Operations on Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]], \
"RelatedTutorials",
 CellID->163046772],

Cell[TextData[{
 ButtonBox["The Algorithms of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheAlgorithmsOfMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheAlgorithmsOfMathematica"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->301221197]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Monitoring and Selecting Algorithms - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Operations on Functions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ControllingThePrecisionOfResults"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/FunctionsWithSensitiveDependenceOnTheirInput"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 30.6802424}", "context" -> "", 
    "keywords" -> {
     "Adams method", "algorithms", "BDF methods", "EvaluationMonitor", 
      "intermediate results", "method", "monitoring", "RungeKutta method", 
      "StepMonitor"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Functions in Mathematica are carefully set up so that you normally do \
not have to know how they work inside. But particularly for numerical \
functions that use iterative algorithms, it is sometimes useful to be able to \
monitor the internal progress of these algorithms. Options for monitoring \
progress of numerical functions. This prints the value of x every time a step \
is taken. ", "synonyms" -> {"3.9.10"}, "title" -> 
    "Monitoring and Selecting Algorithms", "type" -> "Tutorial", "uri" -> 
    "tutorial/MonitoringAndSelectingAlgorithms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.9.10"->{
  Cell[2372, 67, 100, 2, 70, "Title",
   CellTags->{"S3.9.10", "10.1"},
   CellID->25086]},
 "10.1"->{
  Cell[2372, 67, 100, 2, 70, "Title",
   CellTags->{"S3.9.10", "10.1"},
   CellID->25086]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.9.10", 23118, 737},
 {"10.1", 23221, 741}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1747, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2372, 67, 100, 2, 70, "Title",
 CellTags->{"S3.9.10", "10.1"},
 CellID->25086],
Cell[2475, 71, 364, 9, 70, "Text",
 CellID->5475],
Cell[2842, 82, 749, 21, 70, "DefinitionBox",
 CellID->32724],
Cell[3594, 105, 90, 1, 70, "Caption",
 CellID->4246],
Cell[3687, 108, 150, 5, 70, "MathCaption",
 CellID->5187],
Cell[CellGroupData[{
Cell[3862, 117, 308, 10, 70, "Input",
 CellID->13517],
Cell[CellGroupData[{
Cell[4195, 131, 110, 2, 70, "Print",
 CellID->1755064330],
Cell[4308, 135, 109, 2, 70, "Print",
 CellID->551717133],
Cell[4420, 139, 108, 2, 70, "Print",
 CellID->410684165],
Cell[4531, 143, 109, 2, 70, "Print",
 CellID->524861577]
}, Open  ]],
Cell[4655, 148, 227, 7, 36, "Output",
 CellID->758560910]
}, Open  ]],
Cell[4897, 158, 542, 19, 70, "Text",
 CellID->12625],
Cell[5442, 179, 345, 12, 70, "MathCaption",
 CellID->23273],
Cell[CellGroupData[{
Cell[5812, 195, 343, 11, 70, "Input",
 CellID->9947],
Cell[6158, 208, 460, 15, 36, "Output",
 CellID->2109817432]
}, Open  ]],
Cell[6633, 226, 62, 1, 70, "MathCaption",
 CellID->17388],
Cell[CellGroupData[{
Cell[6720, 231, 484, 17, 70, "Input",
 CellID->20917],
Cell[7207, 250, 281, 10, 36, "Output",
 CellID->1605244099]
}, Open  ]],
Cell[7503, 263, 407, 7, 70, "Text",
 CellID->29338],
Cell[7913, 272, 109, 3, 70, "MathCaption",
 CellID->32184],
Cell[CellGroupData[{
Cell[8047, 279, 344, 11, 70, "Input",
 CellID->24957],
Cell[8394, 292, 575, 17, 36, "Output",
 CellID->1386960553]
}, Open  ]],
Cell[8984, 312, 89, 1, 70, "MathCaption",
 CellID->31094],
Cell[CellGroupData[{
Cell[9098, 317, 350, 11, 70, "Input",
 CellID->29260],
Cell[9451, 330, 663, 18, 54, "Output",
 CellID->1786489625]
}, Open  ]],
Cell[10129, 351, 182, 6, 70, "MathCaption",
 CellID->253],
Cell[CellGroupData[{
Cell[10336, 361, 525, 16, 70, "Input",
 CellID->30665],
Cell[10864, 379, 2593, 50, 129, "Output",
 CellID->1549562209]
}, Open  ]],
Cell[13472, 432, 1162, 37, 70, "DefinitionBox",
 CellID->15390],
Cell[14637, 471, 174, 7, 70, "Caption",
 CellID->7971],
Cell[14814, 480, 1046, 24, 70, "Text",
 CellID->12027],
Cell[15863, 506, 230, 6, 70, "MathCaption",
 CellID->24497],
Cell[16096, 514, 1076, 33, 70, "Input",
 CellID->19460],
Cell[17175, 549, 150, 4, 70, "MathCaption",
 CellID->28184],
Cell[CellGroupData[{
Cell[17350, 557, 103, 3, 70, "Input",
 CellID->27491],
Cell[17456, 562, 209, 7, 36, "Output",
 CellID->302940655]
}, Open  ]],
Cell[17680, 572, 174, 4, 70, "MathCaption",
 CellID->16491],
Cell[CellGroupData[{
Cell[17879, 580, 273, 8, 70, "Input",
 CellID->27940],
Cell[18155, 590, 506, 17, 36, "Output",
 CellID->622516920]
}, Open  ]],
Cell[18676, 610, 165, 4, 70, "MathCaption",
 CellID->8106],
Cell[CellGroupData[{
Cell[18866, 618, 336, 10, 70, "Input",
 CellID->7413],
Cell[19205, 630, 571, 19, 36, "Output",
 CellID->638528536]
}, Open  ]],
Cell[CellGroupData[{
Cell[19813, 654, 72, 1, 70, "RelatedTutorialsSection",
 CellID->153118904],
Cell[19888, 657, 198, 5, 70, "RelatedTutorials",
 CellID->163046772],
Cell[20089, 664, 314, 9, 70, "RelatedTutorials",
 CellID->301221197]
}, Open  ]]
}, Open  ]],
Cell[20430, 677, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

