(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25021,        964]
NotebookOptionsPosition[     19276,        763]
NotebookOutlinePosition[     21284,        819]
CellTagsIndexPosition[     21193,        813]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Cross" :> Documentation`HelpLookup["paclet:ref/Cross"], 
         "KroneckerProduct" :> 
         Documentation`HelpLookup["paclet:ref/KroneckerProduct"], "Outer" :> 
         Documentation`HelpLookup["paclet:ref/Outer"], "Times" :> 
         Documentation`HelpLookup["paclet:ref/Times"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Cross\"\>", 2->"\<\"KroneckerProduct\"\>", 
      3->"\<\"Outer\"\>", 4->"\<\"Times\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Multiplying Vectors and Matrices", "Title",
 CellTags->{"S3.7.5", "5.1"},
 CellID->22223],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["c", "TI"], 
     StyleBox["v", "TI"], Cell[", ", "TableText"], 
     StyleBox["c", "TI"], 
     StyleBox["m", "TI"], Cell[",  etc.", "TableText"]}], Cell[
    "multiply each element by a scalar", "TableText"]},
   {
    RowBox[{
     RowBox[{
      StyleBox["u", "TI"], ".", 
      StyleBox["v", "TI"]}], Cell[", ", "TableText"], 
     RowBox[{
      StyleBox["v", "TI"], ".", 
      StyleBox["m", "TI"]}], Cell[", ", "TableText"], 
     RowBox[{
      StyleBox["m", "TI"], ".", 
      StyleBox["v", "TI"]}], Cell[", ", "TableText"], 
     RowBox[{
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["1", "TR"]], ".", 
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["2", "TR"]], Cell[",  etc.", "TableText"]}]}], Cell[
    "vector and matrix multiplication", "TableText"]},
   {
    RowBox[{
     ButtonBox["Cross",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cross"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["v", "TI"]}], "]"}], Cell[TextData[{
     "vector cross product (also input as ",
     Cell[BoxData[
      RowBox[{
       StyleBox["u", "TI"], "\[Cross]", 
       StyleBox["v", "TI"]}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Outer",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Outer"], "[", 
     ButtonBox["Times",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Times"], ",", 
     StyleBox["t", "TI"], ",", 
     StyleBox["u", "TI"], "]"}], Cell["outer product", "TableText"]},
   {
    RowBox[{
     ButtonBox["KroneckerProduct",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/KroneckerProduct"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[
    "Kronecker product", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2790],

Cell["Different kinds of vector and matrix multiplication. ", "Caption",
 CellID->23562],

Cell[TextData[{
 "This multiplies each element of the vector by the scalar ",
 Cell[BoxData["k"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", " ", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->4221],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", " ", "k"}], ",", 
   RowBox[{"b", " ", "k"}], ",", 
   RowBox[{"c", " ", "k"}]}], "}"}]], "Output",
 ImageSize->{92, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->27995]
}, Open  ]],

Cell["The \"dot\" operator gives the scalar product of two vectors. ", \
"MathCaption",
 CellID->24946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], ".", 
  RowBox[{"{", 
   RowBox[{"ap", ",", "bp", ",", "cp"}], "}"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->29578],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "ap"}], "+", 
  RowBox[{"b", " ", "bp"}], "+", 
  RowBox[{"c", " ", "cp"}]}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->1754]
}, Open  ]],

Cell["You can also use dot to multiply a matrix by a vector. ", "MathCaption",
 CellID->29201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ".", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->31523],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->4413]
}, Open  ]],

Cell[TextData[{
 "Dot is also the notation for matrix multiplication in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->18098],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ".", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->23546],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "+", 
      RowBox[{"3", " ", "b"}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", "a"}], "+", 
      RowBox[{"4", " ", "b"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", "+", 
      RowBox[{"3", " ", "d"}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", "c"}], "+", 
      RowBox[{"4", " ", "d"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{247, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->25687]
}, Open  ]],

Cell[TextData[{
 "It is important to realize that you can use \[OpenCurlyDoubleQuote]dot\
\[CloseCurlyDoubleQuote] for both left\[Hyphen] and \
right\[Hyphen]multiplication of vectors by matrices. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " makes no distinction between \[OpenCurlyDoubleQuote]row\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]column\
\[CloseCurlyDoubleQuote] vectors. Dot carries out whatever operation is \
possible. (In formal terms, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", ".", "b"}], TraditionalForm]], "InlineMath"],
 " contracts the last index of the tensor ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " with the first index of ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 ".)"
}], "Text",
 CellID->30478],

Cell[TextData[{
 "Here are definitions for a matrix ",
 Cell[BoxData["m"], "InlineFormula"],
 " and a vector ",
 Cell[BoxData["v"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}], ";", 
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->8918],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->32482]
}, Open  ]],

Cell[TextData[{
 "This left\[Hyphen]multiplies the vector ",
 Cell[BoxData["v"], "InlineFormula"],
 " by ",
 Cell[BoxData["m"], "InlineFormula"],
 ". The object ",
 Cell[BoxData["v"], "InlineFormula"],
 " is effectively treated as a column vector in this case. "
}], "MathCaption",
 CellID->25684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", ".", "v"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->20714],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->22356]
}, Open  ]],

Cell[TextData[{
 "You can also use dot to right\[Hyphen]multiply ",
 Cell[BoxData["v"], "InlineFormula"],
 " by ",
 Cell[BoxData["m"], "InlineFormula"],
 ". Now ",
 Cell[BoxData["v"], "InlineFormula"],
 " is effectively treated as a row vector. "
}], "MathCaption",
 CellID->14019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", ".", "m"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->31458],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"c", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->6127]
}, Open  ]],

Cell[TextData[{
 "You can multiply ",
 Cell[BoxData["m"], "InlineFormula"],
 " by ",
 Cell[BoxData["v"], "InlineFormula"],
 " on both sides, to get a scalar. "
}], "MathCaption",
 CellID->4730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", ".", "m", ".", "v"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->17401],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"a", " ", "x"}], "+", 
     RowBox[{"c", " ", "y"}]}], ")"}]}], "+", 
  RowBox[{"y", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"d", " ", "y"}]}], ")"}]}]}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->18826]
}, Open  ]],

Cell["\<\
For some purposes, you may need to represent vectors and matrices \
symbolically, without explicitly giving their elements. You can use dot to \
represent multiplication of such symbolic objects.\
\>", "Text",
 CellID->12892],

Cell["\<\
Dot effectively acts here as a non\[Hyphen]commutative form of \
multiplication. \
\>", "MathCaption",
 CellID->29766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", ".", "b", ".", "a"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->16024],

Cell[BoxData[
 RowBox[{"a", ".", "b", ".", "a"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->24544]
}, Open  ]],

Cell["It is, nevertheless, associative. ", "MathCaption",
 CellID->10755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", ".", "b"}], ")"}], ".", 
  RowBox[{"(", 
   RowBox[{"a", ".", "b"}], ")"}]}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->30102],

Cell[BoxData[
 RowBox[{"a", ".", "b", ".", "a", ".", "b"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->14619]
}, Open  ]],

Cell["Dot products of sums are not automatically expanded out. ", \
"MathCaption",
 CellID->20288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "+", "b"}], ")"}], ".", "c", ".", 
  RowBox[{"(", 
   RowBox[{"d", "+", "e"}], ")"}]}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->12384],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "+", "b"}], ")"}], ".", "c", ".", 
  RowBox[{"(", 
   RowBox[{"d", "+", "e"}], ")"}]}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->4421]
}, Open  ]],

Cell[TextData[{
 "You can apply the distributive law in this case using the function ",
 Cell[BoxData[
  ButtonBox["Distribute",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Distribute"]], "InlineFormula"],
 ", as discussed in\[NonBreakingSpace]\"",
 ButtonBox["Structural Operations",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/StructuralOperations"],
 "\". "
}], "MathCaption",
 CellID->21756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", "%", "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->15635],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", ".", "c", ".", "d"}], "+", 
  RowBox[{"a", ".", "c", ".", "e"}], "+", 
  RowBox[{"b", ".", "c", ".", "d"}], "+", 
  RowBox[{"b", ".", "c", ".", "e"}]}]], "Output",
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->30668]
}, Open  ]],

Cell[TextData[{
 "The \"dot\" operator gives \"inner products\" of vectors, matrices, and so \
on. In more advanced calculations, you may also need to construct outer or \
Kronecker products of vectors and matrices. You can use the general function \
",
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["KroneckerProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/KroneckerProduct"]], "InlineFormula"],
 " to do this."
}], "Text",
 CellID->2199],

Cell["The outer product of two vectors is a matrix. ", "MathCaption",
 CellID->1410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"Times", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->27213],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", "c"}], ",", 
     RowBox[{"a", " ", "d"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", " ", "c"}], ",", 
     RowBox[{"b", " ", "d"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{148, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->11508]
}, Open  ]],

Cell["\<\
The outer product of a matrix and a vector is a rank three tensor.\
\>", "MathCaption",
 CellID->18135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"Times", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->29915],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", " ", "x"}], ",", 
       RowBox[{"2", " ", "y"}], ",", 
       RowBox[{"2", " ", "z"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", " ", "x"}], ",", 
       RowBox[{"3", " ", "y"}], ",", 
       RowBox[{"3", " ", "z"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"4", " ", "x"}], ",", 
       RowBox[{"4", " ", "y"}], ",", 
       RowBox[{"4", " ", "z"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{400, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->21562]
}, Open  ]],

Cell[TextData[{
 "Outer products are discussed in more detail in \"",
 ButtonBox["Tensors",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/Tensors"],
 "\". "
}], "Text",
 CellID->9354],

Cell["The Kronecker product of a matrix and a vector is a matrix.", \
"MathCaption",
 CellID->566815782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KroneckerProduct", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->495410344],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", 
     RowBox[{"2", " ", "x"}], ",", 
     RowBox[{"2", " ", "y"}], ",", 
     RowBox[{"2", " ", "z"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", " ", "x"}], ",", 
     RowBox[{"3", " ", "y"}], ",", 
     RowBox[{"3", " ", "z"}], ",", 
     RowBox[{"4", " ", "x"}], ",", 
     RowBox[{"4", " ", "y"}], ",", 
     RowBox[{"4", " ", "z"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{344, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->775382860]
}, Open  ]],

Cell["\<\
The Kronecker product of a pair of 2 \[Times] 2 matrices is a 4 \[Times] 4 \
matrix. \
\>", "MathCaption",
 CellID->42275398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KroneckerProduct", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->531795702],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"2", " ", "a"}], ",", 
     RowBox[{"2", " ", "b"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", 
     RowBox[{"2", " ", "c"}], ",", 
     RowBox[{"2", " ", "d"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", " ", "a"}], ",", 
     RowBox[{"3", " ", "b"}], ",", 
     RowBox[{"4", " ", "a"}], ",", 
     RowBox[{"4", " ", "b"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", " ", "c"}], ",", 
     RowBox[{"3", " ", "d"}], ",", 
     RowBox[{"4", " ", "c"}], ",", 
     RowBox[{"4", " ", "d"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{474, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->402363021]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Multiplying Vectors and Matrices - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 37.6804216}", "context" -> "", 
    "keywords" -> {
     "Cartesian products", "direct products", "distribute", "Dot", 
      "dot product", "exterior products", "inner products", 
      "KroneckerProduct", "multiplying matrices", "Outer", "outer products", 
      "scalar product", "tensor products", "tensors", "vectors", 
      "wedge product"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Different kinds of vector and matrix multiplication. This multiplies \
each element of the vector by the scalar k. The \"dot\" operator gives the \
scalar product of two vectors. ", "synonyms" -> {"3.7.5"}, "title" -> 
    "Multiplying Vectors and Matrices", "type" -> "Tutorial", "uri" -> 
    "tutorial/MultiplyingVectorsAndMatrices"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.7.5"->{
  Cell[1470, 45, 95, 2, 70, "Title",
   CellTags->{"S3.7.5", "5.1"},
   CellID->22223]},
 "5.1"->{
  Cell[1470, 45, 95, 2, 70, "Title",
   CellTags->{"S3.7.5", "5.1"},
   CellID->22223]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.7.5", 20982, 802},
 {"5.1", 21081, 806}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 845, 18, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1470, 45, 95, 2, 70, "Title",
 CellTags->{"S3.7.5", "5.1"},
 CellID->22223],
Cell[1568, 49, 2468, 78, 70, "DefinitionBox",
 CellID->2790],
Cell[4039, 129, 88, 1, 70, "Caption",
 CellID->23562],
Cell[4130, 132, 155, 5, 70, "MathCaption",
 CellID->7125],
Cell[CellGroupData[{
Cell[4310, 141, 145, 5, 28, "Input",
 CellID->4221],
Cell[4458, 148, 282, 10, 36, "Output",
 CellID->27995]
}, Open  ]],
Cell[4755, 161, 103, 2, 70, "MathCaption",
 CellID->24946],
Cell[CellGroupData[{
Cell[4883, 167, 206, 7, 28, "Input",
 CellID->29578],
Cell[5092, 176, 259, 9, 36, "Output",
 CellID->1754]
}, Open  ]],
Cell[5366, 188, 94, 1, 70, "MathCaption",
 CellID->29201],
Cell[CellGroupData[{
Cell[5485, 193, 285, 11, 28, "Input",
 CellID->31523],
Cell[5773, 206, 348, 13, 36, "Output",
 CellID->4413]
}, Open  ]],
Cell[6136, 222, 164, 6, 70, "MathCaption",
 CellID->18098],
Cell[CellGroupData[{
Cell[6325, 232, 387, 15, 70, "Input",
 CellID->23546],
Cell[6715, 249, 565, 21, 36, "Output",
 CellID->25687]
}, Open  ]],
Cell[7295, 273, 798, 21, 70, "Text",
 CellID->30478],
Cell[8096, 296, 190, 7, 70, "MathCaption",
 CellID->28212],
Cell[CellGroupData[{
Cell[8311, 307, 338, 13, 70, "Input",
 CellID->8918],
Cell[8652, 322, 200, 7, 36, "Output",
 CellID->32482]
}, Open  ]],
Cell[8867, 332, 297, 9, 70, "MathCaption",
 CellID->25684],
Cell[CellGroupData[{
Cell[9189, 345, 89, 3, 70, "Input",
 CellID->20714],
Cell[9281, 350, 349, 13, 36, "Output",
 CellID->22356]
}, Open  ]],
Cell[9645, 366, 281, 9, 70, "MathCaption",
 CellID->14019],
Cell[CellGroupData[{
Cell[9951, 379, 89, 3, 70, "Input",
 CellID->31458],
Cell[10043, 384, 348, 13, 36, "Output",
 CellID->6127]
}, Open  ]],
Cell[10406, 400, 193, 7, 70, "MathCaption",
 CellID->4730],
Cell[CellGroupData[{
Cell[10624, 411, 99, 3, 70, "Input",
 CellID->17401],
Cell[10726, 416, 426, 16, 36, "Output",
 CellID->18826]
}, Open  ]],
Cell[11167, 435, 235, 5, 70, "Text",
 CellID->12892],
Cell[11405, 442, 128, 4, 70, "MathCaption",
 CellID->29766],
Cell[CellGroupData[{
Cell[11558, 450, 99, 3, 70, "Input",
 CellID->16024],
Cell[11660, 455, 187, 6, 36, "Output",
 CellID->24544]
}, Open  ]],
Cell[11862, 464, 73, 1, 70, "MathCaption",
 CellID->10755],
Cell[CellGroupData[{
Cell[11960, 469, 184, 7, 70, "Input",
 CellID->30102],
Cell[12147, 478, 198, 6, 36, "Output",
 CellID->14619]
}, Open  ]],
Cell[12360, 487, 98, 2, 70, "MathCaption",
 CellID->20288],
Cell[CellGroupData[{
Cell[12483, 493, 194, 7, 70, "Input",
 CellID->12384],
Cell[12680, 502, 282, 10, 36, "Output",
 CellID->4421]
}, Open  ]],
Cell[12977, 515, 408, 12, 70, "MathCaption",
 CellID->21756],
Cell[CellGroupData[{
Cell[13410, 531, 104, 3, 70, "Input",
 CellID->15635],
Cell[13517, 536, 331, 10, 36, "Output",
 CellID->30668]
}, Open  ]],
Cell[13863, 549, 553, 16, 70, "Text",
 CellID->2199],
Cell[14419, 567, 84, 1, 70, "MathCaption",
 CellID->1410],
Cell[CellGroupData[{
Cell[14528, 572, 234, 8, 70, "Input",
 CellID->27213],
Cell[14765, 582, 404, 15, 36, "Output",
 CellID->11508]
}, Open  ]],
Cell[15184, 600, 113, 3, 70, "MathCaption",
 CellID->18135],
Cell[CellGroupData[{
Cell[15322, 607, 350, 12, 70, "Input",
 CellID->29915],
Cell[15675, 621, 804, 28, 36, "Output",
 CellID->21562]
}, Open  ]],
Cell[16494, 652, 189, 7, 70, "Text",
 CellID->9354],
Cell[16686, 661, 104, 2, 70, "MathCaption",
 CellID->566815782],
Cell[CellGroupData[{
Cell[16815, 667, 350, 12, 70, "Input",
 CellID->495410344],
Cell[17168, 681, 617, 20, 36, "Output",
 CellID->775382860]
}, Open  ]],
Cell[17800, 704, 135, 4, 70, "MathCaption",
 CellID->42275398],
Cell[CellGroupData[{
Cell[17960, 712, 446, 16, 70, "Input",
 CellID->531795702],
Cell[18409, 730, 813, 27, 36, "Output",
 CellID->402363021]
}, Open  ]]
}, Open  ]],
Cell[19249, 761, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

