(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20538,        593]
NotebookOptionsPosition[     16202,        450]
NotebookOutlinePosition[     18318,        511]
CellTagsIndexPosition[     18208,        504]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Advanced Numerical Differential Equation Solving in \
Mathematica" :> 
         Documentation`HelpLookup["paclet:tutorial/NDSolveOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Advanced Numerical Differential Equation Solving in Mathematica\
\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Components and Data Structures in NDSolve", "Title",
 CellTags->"c:1",
 CellID->2098955656],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 CellTags->"s:1",
 CellID->2125957807],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " is broken up into several basic steps. For advanced usage, it can \
sometimes be advantageous to access components to carry out each of these \
steps separately."
}], "Text",
 CellID->1143457485],

Cell[TextData[StyleBox["Equation processing and method selection", "Text"]], \
"BulletedText",
 CellID->147682335],

Cell[TextData[StyleBox["Method initialization", "Text"]], "BulletedText",
 CellID->1730236119],

Cell[TextData[StyleBox["Numerical solution", "Text"]], "BulletedText",
 CellID->85625698],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Solution processing", "Text"]], "BulletedText",
 CellID->415327255],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " performs each of these steps internally, hiding the details from a casual \
user. However, for advanced usage it can sometimes be advantageous to access \
components to carry out each of these steps separately."
}], "Text",
 CellID->1393036765],

Cell["\<\
Here are the low level functions that are used to break up these steps.\
\>", "Text",
 CellID->524769312]
}, Open  ]],

Cell[TextData[StyleBox["NDSolve`ProcessEquations", "MR"]], "BulletedText",
 CellID->1196103339],

Cell[TextData[StyleBox["NDSolve`Iterate", "MR"]], "BulletedText",
 CellID->724737621],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NDSolve`ProcessSolutions", "MR"]], "BulletedText",
 CellID->826874706],

Cell[TextData[{
 StyleBox["NDSolve`ProcessEquations", "MR"],
 " classifies the differential system into initial value problem, boundary \
value problem, differential algebraic problem, partial differential problem \
etc. It also chooses appropriate default integration methods and constructs \
the main ",
 StyleBox["NDSolve`StateData", "MR"],
 " data structure."
}], "Text",
 CellID->289453939],

Cell[TextData[{
 StyleBox["NDSolve`Iterate", "MR"],
 " advances the numerical solution. The first invocation ",
 "(there can be several) initializes the numerical integration methods."
}], "Text",
 CellID->1548881370],

Cell[TextData[{
 StyleBox["NDSolve`ProcessSolutions", "MR"],
 " converts numerical data into an ",
 StyleBox["InterpolatingFunction", "MR"],
 " to represent each solution."
}], "Text",
 CellID->299532054],

Cell[TextData[{
 "Note that ",
 StyleBox["NDSolve`ProcessEquations", "MR"],
 " can take a significant portion of the overall time to solve a differential \
system. In such cases, it can be useful to perform this step only once and \
use ",
 StyleBox["NDSolve`Reinitialize", "MR"],
 " to repeatedly solve for different options or initial conditions."
}], "Text",
 CellID->2110193054]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example", "Section",
 CellTags->"s:2",
 CellID->580655648],

Cell["\<\
Process equations and set up data structures for solving the differential \
system.\
\>", "MathCaption",
 CellID->922866270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ndssdata", " ", "=", " ", 
  RowBox[{"First", "[", 
   RowBox[{"NDSolve`ProcessEquations", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"y", "''"}], "[", "t", "]"}], " ", "+", " ", 
         RowBox[{"y", "[", "t", "]"}]}], " ", "\[Equal]", " ", "0"}], ",", 
       " ", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",",
      " ", 
     RowBox[{"{", 
      RowBox[{"y", ",", " ", 
       RowBox[{"y", "'"}]}], "}"}], ",", " ", "t", ",", " ", 
     RowBox[{"Method", "\[Rule]", "ExplicitRungeKutta"}]}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1903311029],

Cell[BoxData[
 TagBox[
  RowBox[{"NDSolve`StateData", "[", 
   InterpretationBox[
    RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "0.`", 
     "\[InvisibleSpace]", "\<\">\"\>"}],
    SequenceForm["<", 0., ">"],
    Editable->False], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->661138279]
}, Open  ]],

Cell[TextData[{
 "Initialize the method ",
 StyleBox["ExplicitRungeKutta", "MR"],
 ". and integrate the system up to time 10. The return value of ",
 StyleBox["NDSolve`Iterate", "MR"],
 " is ",
 StyleBox["Null", "MR"],
 " in order to avoid extra references, which would lead to undesirable \
copying."
}], "MathCaption",
 CellID->1442769015],

Cell[BoxData[
 RowBox[{"NDSolve`Iterate", "[", 
  RowBox[{"ndssdata", ",", " ", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1655013489],

Cell[TextData[{
 "Convert each set of solution data into an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 ".."
}], "MathCaption",
 CellID->926337867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ndsol", " ", "=", " ", 
  RowBox[{"NDSolve`ProcessSolutions", "[", "ndssdata", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1976994101],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"y", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], ",", 
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}]}], "}"}]], "Output",
 ImageSize->{305, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->404570689]
}, Open  ]],

Cell[TextData[{
 "Representing the solution as an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " allows continuous output even for points that are not part of the \
numerical solution grid."
}], "MathCaption",
 CellID->111494167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"y", "[", "t", "]"}], ",", " ", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "t", "]"}]}], "}"}], " ", "/.", " ", 
    "ndsol"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", " ", "0", ",", " ", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->447548939],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 357},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->79865494]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->117864893],

Cell[TextData[{
 ButtonBox["Advanced Numerical Differential Equation Solving in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NDSolveOverview"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->604721514]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Components and Data Structures in NDSolve - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 55.1808696}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "NDSolve is broken up into several basic steps. For advanced usage, it \
can sometimes be advantageous to access components to carry out each of these \
steps separately. NDSolve performs each of these steps internally, hiding the \
details from a casual user. However, for advanced usage it can sometimes be \
advantageous to access components to carry out each of these steps \
separately. Here are the low level functions that are used to break up these \
steps.", "synonyms" -> {}, "title" -> 
    "Components and Data Structures in NDSolve", "type" -> "Tutorial", "uri" -> 
    "tutorial/NDSolveIntroductoryTutorialStateData"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:1"->{
  Cell[1328, 44, 97, 2, 70, "Title",
   CellTags->"c:1",
   CellID->2098955656]},
 "s:1"->{
  Cell[1450, 50, 70, 2, 70, "Section",
   CellTags->"s:1",
   CellID->2125957807]},
 "s:2"->{
  Cell[4353, 149, 64, 2, 70, "Section",
   CellTags->"s:2",
   CellID->580655648]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:1", 17915, 489},
 {"s:1", 18007, 493},
 {"s:2", 18101, 497}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 703, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1328, 44, 97, 2, 70, "Title",
 CellTags->"c:1",
 CellID->2098955656],
Cell[CellGroupData[{
Cell[1450, 50, 70, 2, 70, "Section",
 CellTags->"s:1",
 CellID->2125957807],
Cell[1523, 54, 331, 9, 70, "Text",
 CellID->1143457485],
Cell[1857, 65, 114, 2, 70, "BulletedText",
 CellID->147682335],
Cell[1974, 69, 94, 1, 70, "BulletedText",
 CellID->1730236119],
Cell[2071, 72, 89, 1, 70, "BulletedText",
 CellID->85625698],
Cell[CellGroupData[{
Cell[2185, 77, 91, 1, 70, "BulletedText",
 CellID->415327255],
Cell[2279, 80, 380, 9, 70, "Text",
 CellID->1393036765],
Cell[2662, 91, 115, 3, 70, "Text",
 CellID->524769312]
}, Open  ]],
Cell[2792, 97, 95, 1, 70, "BulletedText",
 CellID->1196103339],
Cell[2890, 100, 85, 1, 70, "BulletedText",
 CellID->724737621],
Cell[CellGroupData[{
Cell[3000, 105, 94, 1, 70, "BulletedText",
 CellID->826874706],
Cell[3097, 108, 395, 9, 70, "Text",
 CellID->289453939],
Cell[3495, 119, 217, 5, 70, "Text",
 CellID->1548881370],
Cell[3715, 126, 204, 6, 70, "Text",
 CellID->299532054],
Cell[3922, 134, 382, 9, 70, "Text",
 CellID->2110193054]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4353, 149, 64, 2, 70, "Section",
 CellTags->"s:2",
 CellID->580655648],
Cell[4420, 153, 134, 4, 70, "MathCaption",
 CellID->922866270],
Cell[CellGroupData[{
Cell[4579, 161, 824, 25, 70, "Input",
 CellID->1903311029],
Cell[5406, 188, 408, 14, 36, "Output",
 CellID->661138279]
}, Open  ]],
Cell[5829, 205, 341, 10, 70, "MathCaption",
 CellID->1442769015],
Cell[6173, 217, 148, 4, 70, "Input",
 CellID->1655013489],
Cell[6324, 223, 252, 8, 70, "MathCaption",
 CellID->926337867],
Cell[CellGroupData[{
Cell[6601, 235, 165, 4, 70, "Input",
 CellID->1976994101],
Cell[6769, 241, 793, 29, 54, "Output",
 CellID->404570689]
}, Open  ]],
Cell[7577, 273, 333, 9, 70, "MathCaption",
 CellID->111494167],
Cell[CellGroupData[{
Cell[7935, 286, 395, 13, 28, "Input",
 CellID->447548939],
Cell[8333, 301, 7365, 125, 378, "Output",
 Evaluatable->False,
 CellID->79865494]
}, Open  ]],
Cell[CellGroupData[{
Cell[15735, 431, 72, 1, 70, "RelatedTutorialsSection",
 CellID->117864893],
Cell[15810, 434, 326, 9, 70, "RelatedTutorials",
 CellID->604721514]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[16175, 448, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

