(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34853,       1241]
NotebookOptionsPosition[     24976,        920]
NotebookOutlinePosition[     26357,        959]
CellTagsIndexPosition[     26314,        956]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[TextData[{
 "Advanced Numerical Integration in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "TOCDocumentTitle",
 CellID->816856310],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["NIntegrate Introduction",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NIntegrateIntroduction"]], "TOCChapter",
 CellID->46088874],

Cell[TextData[ButtonBox["Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NIntegrateIntroduction#32344101"]], "TOCSection",\

 CellID->519062375],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Design",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntroduction#951840905"]], "TOCSection",
 CellID->56450127],

Cell[TextData[ButtonBox["Features",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntroduction#540272418"]], "TOCSubsection",
 CellID->76068590],

Cell[TextData[ButtonBox["Strategies, rules, and preprocessors",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntroduction#118305364"]], "TOCSubsection",
 CellID->849778807],

Cell[TextData[ButtonBox["User extensibility",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntroduction#2713904"]], "TOCSubsection",
 CellID->84188182],

Cell[TextData[ButtonBox["Acknowledgements",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntroduction#425413732"]], "TOCSubsection",
 CellID->363029136]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["NIntegrate Integration Strategies",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NIntegrateIntegrationStrategies"]], "TOCChapter",\

 CellID->563476015],

Cell[TextData[ButtonBox["Introduction",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#235955634"]], "TOCSection",\

 CellID->248161065],

Cell[TextData[ButtonBox["Adaptive Strategies",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#155948475"]], "TOCSection",\

 CellID->200958240],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Global Adaptive Strategy",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#137878679"]], "TOCSection",\

 CellID->276941368],

Cell[TextData[ButtonBox["MinRecursion and MaxRecursion",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#280704764"]], \
"TOCSubsection",
 CellID->232601809],

Cell[TextData[ButtonBox["\"MaxErrorIncreases\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#285388386"]], \
"TOCSubsection",
 CellID->512912736],

Cell[TextData[ButtonBox["Example implementation of a global adaptive \
strategy",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#16672882"]], \
"TOCSubsection",
 CellID->117940896]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Local Adaptive Strategy",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#19475523"]], "TOCSection",
 CellID->404254437],

Cell[TextData[ButtonBox["MinRecursion and MaxRecursion",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#270286642"]], \
"TOCSubsection",
 CellID->182874800],

Cell[TextData[ButtonBox["\"InitialEstimateRelaxation\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#64704670"]], \
"TOCSubsection",
 CellID->316390205],

Cell[TextData[ButtonBox["\"Partitioning\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#526467531"]], \
"TOCSubsection",
 CellID->425530705],

Cell[TextData[ButtonBox["Reuse of integrand values",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#214095646"]], \
"TOCSubsection",
 CellID->15978605],

Cell[TextData[ButtonBox["Example implementation of a local adaptive strategy",
 
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#715598439"]], \
"TOCSubsection",
 CellID->61721845]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["\"GlobalAdaptive\" versus \"LocalAdaptive\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#290792217"]], "TOCSection",\

 CellID->23679894],

Cell[TextData[ButtonBox["\"GlobalAdaptive\" is generally better than \
\"LocalAdaptive\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#558182960"]], \
"TOCSubsubsection",
 CellID->62199098]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Singularity Handling",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#122144792"]], "TOCSection",\

 CellID->16292820],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["User specified singularities",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#112801667"]], \
"TOCSubsection",
 CellID->317741853],

Cell[TextData[ButtonBox["Point singularities",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#19203486"]], \
"TOCSubsubsection",
 CellID->837492821],

Cell[TextData[ButtonBox["Curve, surface, and hyper-surface singularities",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#146947120"]], \
"TOCSubsubsection",
 CellID->34504335],

Cell[TextData[ButtonBox["Example implementation of curve, surface, and \
hyper-surface singularity handling",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#542398406"]], \
"TOCSubsubsection",
 CellID->26293535]
}, Open  ]],

Cell[TextData[ButtonBox["\"SingularityHandler\" and \"SingularityDepth\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#31583791"]], \
"TOCSubsection",
 CellID->239010813],

Cell[TextData[ButtonBox["Use of the IMT variable transformation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#150310618"]], \
"TOCSubsection",
 CellID->4799393],

Cell[TextData[ButtonBox["IMT transformation by example",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#107913531"]], \
"TOCSubsection",
 CellID->179126195],

Cell[TextData[ButtonBox["Use of double exponential quadrature",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#225088061"]], \
"TOCSubsection",
 CellID->159796089],

Cell[TextData[{
 ButtonBox["IMT ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NIntegrateIntegrationStrategies#23700706"],
 "versus",
 ButtonBox[" \"DoubleExponential\" ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NIntegrateIntegrationStrategies#23700706"],
 "versus",
 ButtonBox[" no singularity handling for one-dimensional integrals",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NIntegrateIntegrationStrategies#23700706"]
}], "TOCSubsection",
 CellID->93188187],

Cell[TextData[ButtonBox["IMT multidimensional singularity handling",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#159907828"]], \
"TOCSubsection",
 CellID->431075197],

Cell[TextData[ButtonBox["Duffy's coordinates for multidimensional singularity \
handling",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#738848244"]], \
"TOCSubsection",
 CellID->401491862],

Cell[TextData[ButtonBox["Duffy's coordinates strategy",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#66551248"]], \
"TOCSubsection",
 CellID->486548928],

Cell[TextData[ButtonBox["Duffy's coordinates generalization and example \
implementation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#354695682"]], \
"TOCSubsection",
 CellID->594555757],

Cell[TextData[ButtonBox["Ignoring the singularity",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#74051012"]], \
"TOCSubsection",
 CellID->401465455],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Automatic singularity handling ",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#4135167"]], "TOCSubsection",\

 CellID->25110133],

Cell[TextData[ButtonBox["One-dimensional integration ",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#282959198"]], \
"TOCSubsubsection",
 CellID->200406440],

Cell[TextData[ButtonBox["Multidimensional integration",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#416363467"]], \
"TOCSubsubsection",
 CellID->645056419]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Cauchy principal value integration",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#295594003"]], \
"TOCSubsection",
 CellID->1586042],

Cell[TextData[ButtonBox["Sampling points visualization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#420809027"]], \
"TOCSubsubsection",
 CellID->14400076]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Double-Exponential Strategy",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#526196975"]], "TOCSection",\

 CellID->407973698],

Cell[TextData[ButtonBox["MinRecursion and MaxRecursion",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#168459464"]], \
"TOCSubsection",
 CellID->350221708],

Cell[TextData[ButtonBox["Comparison of double-exponential and Gaussian \
quadrature",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#140889501"]], \
"TOCSubsection",
 CellID->180153653],

Cell[TextData[ButtonBox["Convergence rate",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#175923852"]], \
"TOCSubsection",
 CellID->231686778],

Cell[TextData[ButtonBox["Example implementation of double-exponential \
quadrature",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#5698822"]], "TOCSubsection",\

 CellID->65386909]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["\"Trapezoidal\" Strategy",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#403370786"]], "TOCSection",\

 CellID->101465998],

Cell[TextData[ButtonBox["Example implementation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#159230017"]], \
"TOCSubsubsection",
 CellID->746308593]
}, Open  ]],

Cell[TextData[ButtonBox["Oscillatory Strategies",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#775797877"]], "TOCSection",\

 CellID->591458949],

Cell[TextData[ButtonBox["Finite Region Oscillatory Integration",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#144042466"]], "TOCSection",\

 CellID->92077588],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Extrapolating Oscillatory Strategy ",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#50593814"]], "TOCSection",
 CellID->72823918],

Cell[TextData[ButtonBox["Example implementation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#64282444"]], \
"TOCSubsubsection",
 CellID->86972363]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Double-Exponential Oscillatory Integration",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#48895312"]], "TOCSection",
 CellID->544265879],

Cell[TextData[ButtonBox["Generalized integrals",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#188549426"]], \
"TOCSubsection",
 CellID->363648078],

Cell[TextData[ButtonBox["Non-algebraic multiplicand",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#662597729"]], \
"TOCSubsection",
 CellID->60965605]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Crude Monte Carlo and Quasi Monte Carlo Strategies",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#20795380"]], "TOCSection",
 CellID->26291739],

Cell[TextData[ButtonBox["AccuracyGoal and PrecisionGoal",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#35773270"]], \
"TOCSubsection",
 CellID->26703503],

Cell[TextData[ButtonBox["MaxPoints",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#1551213"]], "TOCSubsection",\

 CellID->34251989],

Cell[TextData[ButtonBox["\"RandomSeed\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#605699968"]], \
"TOCSubsection",
 CellID->12626880],

Cell[TextData[ButtonBox["Stratified crude Monte Carlo integration",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#473354685"]], \
"TOCSubsection",
 CellID->110485629],

Cell[TextData[ButtonBox["Convergence speed up of the stratified Monte Carlo \
integration",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#40464370"]], \
"TOCSubsection",
 CellID->211009011]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Global Adaptive Monte Carlo and Quasi Monte Carlo \
Strategies",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#65285686"]], "TOCSection",
 CellID->131522320],

Cell[TextData[ButtonBox["MinRecursion and MaxRecursion",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#61206936"]], \
"TOCSubsection",
 CellID->44485686],

Cell[TextData[ButtonBox["\"Partitioning\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#574188911"]], \
"TOCSubsection",
 CellID->317486452],

Cell[TextData[ButtonBox["\"BisectionDithering\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#193092152"]], \
"TOCSubsection",
 CellID->387263229],

Cell[TextData[ButtonBox["Choice of bisection axis",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#744911582"]], \
"TOCSubsection",
 CellID->51992195],

Cell[TextData[ButtonBox["Example: Comparison with crude Monte Carlo",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#718032232"]], \
"TOCSubsection",
 CellID->156876262]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["\"MultiPeriodic\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#107447537"]], "TOCSection",\

 CellID->105949497],

Cell[TextData[ButtonBox["Comparison with \"MultiDimensionalRule\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#161179452"]], \
"TOCSubsection",
 CellID->853286544]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Preprocessors",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#12996145"]], "TOCSection",
 CellID->430931908],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["\"SymbolicPiecewiseSubdivision\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#440163298"]], \
"TOCSubsection",
 CellID->55123627],

Cell[TextData[ButtonBox["\"ExpandSpecialPiecewise\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#32368822"]], \
"TOCSubsubsection",
 CellID->560398179]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["\"EvenOddSubdivision\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#172715735"]], \
"TOCSubsection",
 CellID->93904596],

Cell[TextData[ButtonBox["Transformation theorem",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#284148603"]], \
"TOCSubsubsection",
 CellID->109853054],

Cell[TextData[ButtonBox["\"VerifyConvergence\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#302014659"]], \
"TOCSubsubsection",
 CellID->364257540]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["\"OscillatorySelection\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#52803663"]], \
"TOCSubsection",
 CellID->171807067],

Cell[TextData[ButtonBox["Working with sums of oscillating terms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#136089857"]], \
"TOCSubsubsection",
 CellID->522700802]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["\"UnitCubeRescaling\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#46192878"]], \
"TOCSubsection",
 CellID->375603316],

Cell[TextData[ButtonBox["Example implementation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#165290110"]], \
"TOCSubsubsection",
 CellID->22280853]
}, Open  ]],

Cell[TextData[ButtonBox["\"SymbolicPreprocessing\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#188031681"]], \
"TOCSubsection",
 CellID->3538593]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Examples and Applications",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#31617981"]], "TOCSection",
 CellID->195374595],

Cell[TextData[ButtonBox["Closed-contour integrals",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#184932443"]], \
"TOCSubsection",
 CellID->176712340],

Cell[TextData[ButtonBox["Fourier series calculation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies#5688699"]], "TOCSubsection",\

 CellID->63403799]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["NIntegrate Integration Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NIntegrateIntegrationRules"]], "TOCChapter"],

Cell[TextData[ButtonBox["Introduction",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#235359397"]], "TOCSection"],

Cell[TextData[ButtonBox["Integration Rule Specification",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#135207409"]], "TOCSection"],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["\"TrapezoidalRule\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#618158740"]], "TOCSection"],

Cell[TextData[ButtonBox["Romberg quadrature",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#101738258"]], "TOCSubsection"],

Cell[TextData[ButtonBox["\"TrapezoidalRule\" sampling points and weights",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#12731638"]], "TOCSubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["\"NewtonCotesRule\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#81663330"]], "TOCSection"],

Cell[TextData[ButtonBox["\"NewtonCotesRule\" sampling points and weights",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#617627612"]], "TOCSubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["\"GaussBerntsenEspelidRule\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#141675390"]], "TOCSection"],

Cell[TextData[ButtonBox["\"GaussBerntsenEspelidRule\" sampling points and \
weights",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#165210023"]], "TOCSubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["\"GaussKronrodRule\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#381359375"]], "TOCSection"],

Cell[TextData[ButtonBox["\"GaussKronrodRule\" sampling points and weights",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#360328261"]], "TOCSubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["\"LobattoKronrodRule\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#210486704"]], "TOCSection"],

Cell[TextData[ButtonBox["\"LobattoKronrodRule\" sampling points and weights",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#49911002"]], "TOCSubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["\"ClenshawCurtisRule\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#486402291"]], "TOCSection"],

Cell[TextData[ButtonBox["\"ClenshawCurtisRule\" sampling points and weights",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#123359709"]], "TOCSubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["\"MultiPanelRule\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#106389821"]], "TOCSection"],

Cell[TextData[ButtonBox["\"MultiPanelRule\" sampling points and weights",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#362787930"]], "TOCSubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["\"CartesianRule\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#650745857"]], "TOCSection"],

Cell[TextData[ButtonBox["\"CartesianRule\" sampling points and weights",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#643860566"]], "TOCSubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["\"MultiDimensionalRule\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#89177434"]], "TOCSection"],

Cell[TextData[ButtonBox["\"MultiDimensionalRule\" sampling points and \
weights",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#810793694"]], "TOCSubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["\"MonteCarloRule\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#430697921"]], "TOCSection"],

Cell[TextData[ButtonBox["\"AxisSelector\"",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#364207621"]], "TOCSubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Comparisons of the Rules",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#233261223"]], "TOCSection"],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Number of points in a rule",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#6741536"]], "TOCSubsection"],

Cell[TextData[ButtonBox["Minimal number of sampling points",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#870923766"]], "TOCSubsubsection"]
}, Open  ]],

Cell[TextData[ButtonBox["Rule comparison",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#870846129"]], "TOCSubsection"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Examples of Pathological Behavior",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#8354729"]], "TOCSection"],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Tricking the error estimator",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#81420002"]], "TOCSubsection"],

Cell[TextData[ButtonBox["The wrong estimation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#594163809"]], "TOCSubsubsection"],

Cell[TextData[ButtonBox["Better results",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#26508302"]], "TOCSubsubsection"],

Cell[TextData[ButtonBox["Why the estimator is misled",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#276439645"]], "TOCSubsubsection"]
}, Open  ]],

Cell[TextData[ButtonBox["Phase errors ",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#599865576"]], "TOCSubsection"]
}, Open  ]],

Cell[TextData[ButtonBox["Index of Technical Terms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules#17191326"]], "TOCSection"]
}, Open  ]],

Cell[TextData[ButtonBox["NIntegrate References",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NIntegrateReferences"]], "TOCChapter"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Advanced Numerical Integration in Mathematica - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 4.7295250}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "NIntegrate Introduction NIntegrate Integration Strategies NIntegrate \
Integration Rules", "synonyms" -> {}, "title" -> 
    "Advanced Numerical Integration in Mathematica", "type" -> "Tutorial", 
    "uri" -> "tutorial/NIntegrateOverview"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[706, 27, 146, 5, 70, "TOCDocumentTitle",
 CellID->816856310],
Cell[CellGroupData[{
Cell[877, 36, 160, 3, 70, "TOCChapter",
 CellID->46088874],
Cell[1040, 41, 157, 4, 70, "TOCSection",
 CellID->519062375],
Cell[CellGroupData[{
Cell[1222, 49, 156, 4, 70, "TOCSection",
 CellID->56450127],
Cell[1381, 55, 161, 4, 70, "TOCSubsection",
 CellID->76068590],
Cell[1545, 61, 190, 4, 70, "TOCSubsection",
 CellID->849778807],
Cell[1738, 67, 169, 4, 70, "TOCSubsection",
 CellID->84188182],
Cell[1910, 73, 170, 4, 70, "TOCSubsection",
 CellID->363029136]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2129, 83, 182, 4, 70, "TOCChapter",
 CellID->563476015],
Cell[2314, 89, 174, 5, 70, "TOCSection",
 CellID->248161065],
Cell[2491, 96, 181, 5, 70, "TOCSection",
 CellID->200958240],
Cell[CellGroupData[{
Cell[2697, 105, 186, 5, 70, "TOCSection",
 CellID->276941368],
Cell[2886, 112, 194, 5, 70, "TOCSubsection",
 CellID->232601809],
Cell[3083, 119, 186, 5, 70, "TOCSubsection",
 CellID->512912736],
Cell[3272, 126, 218, 6, 70, "TOCSubsection",
 CellID->117940896]
}, Open  ]],
Cell[CellGroupData[{
Cell[3527, 137, 182, 4, 70, "TOCSection",
 CellID->404254437],
Cell[3712, 143, 194, 5, 70, "TOCSubsection",
 CellID->182874800],
Cell[3909, 150, 193, 5, 70, "TOCSubsection",
 CellID->316390205],
Cell[4105, 157, 181, 5, 70, "TOCSubsection",
 CellID->425530705],
Cell[4289, 164, 189, 5, 70, "TOCSubsection",
 CellID->15978605],
Cell[4481, 171, 217, 6, 70, "TOCSubsection",
 CellID->61721845]
}, Open  ]],
Cell[CellGroupData[{
Cell[4735, 182, 204, 5, 70, "TOCSection",
 CellID->23679894],
Cell[4942, 189, 230, 6, 70, "TOCSubsubsection",
 CellID->62199098]
}, Open  ]],
Cell[CellGroupData[{
Cell[5209, 200, 181, 5, 70, "TOCSection",
 CellID->16292820],
Cell[CellGroupData[{
Cell[5415, 209, 193, 5, 70, "TOCSubsection",
 CellID->317741853],
Cell[5611, 216, 186, 5, 70, "TOCSubsubsection",
 CellID->837492821],
Cell[5800, 223, 214, 5, 70, "TOCSubsubsection",
 CellID->34504335],
Cell[6017, 230, 249, 6, 70, "TOCSubsubsection",
 CellID->26293535]
}, Open  ]],
Cell[6281, 239, 211, 5, 70, "TOCSubsection",
 CellID->239010813],
Cell[6495, 246, 201, 5, 70, "TOCSubsection",
 CellID->4799393],
Cell[6699, 253, 194, 5, 70, "TOCSubsection",
 CellID->179126195],
Cell[6896, 260, 201, 5, 70, "TOCSubsection",
 CellID->159796089],
Cell[7100, 267, 490, 13, 70, "TOCSubsection",
 CellID->93188187],
Cell[7593, 282, 206, 5, 70, "TOCSubsection",
 CellID->431075197],
Cell[7802, 289, 228, 6, 70, "TOCSubsection",
 CellID->401491862],
Cell[8033, 297, 192, 5, 70, "TOCSubsection",
 CellID->486548928],
Cell[8228, 304, 228, 6, 70, "TOCSubsection",
 CellID->594555757],
Cell[8459, 312, 188, 5, 70, "TOCSubsection",
 CellID->401465455],
Cell[CellGroupData[{
Cell[8672, 321, 193, 5, 70, "TOCSubsection",
 CellID->25110133],
Cell[8868, 328, 196, 5, 70, "TOCSubsubsection",
 CellID->200406440],
Cell[9067, 335, 196, 5, 70, "TOCSubsubsection",
 CellID->645056419]
}, Open  ]],
Cell[CellGroupData[{
Cell[9300, 345, 197, 5, 70, "TOCSubsection",
 CellID->1586042],
Cell[9500, 352, 196, 5, 70, "TOCSubsubsection",
 CellID->14400076]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9745, 363, 189, 5, 70, "TOCSection",
 CellID->407973698],
Cell[9937, 370, 194, 5, 70, "TOCSubsection",
 CellID->350221708],
Cell[10134, 377, 223, 6, 70, "TOCSubsection",
 CellID->180153653],
Cell[10360, 385, 181, 5, 70, "TOCSubsection",
 CellID->231686778],
Cell[10544, 392, 219, 6, 70, "TOCSubsection",
 CellID->65386909]
}, Open  ]],
Cell[CellGroupData[{
Cell[10800, 403, 186, 5, 70, "TOCSection",
 CellID->101465998],
Cell[10989, 410, 190, 5, 70, "TOCSubsubsection",
 CellID->746308593]
}, Open  ]],
Cell[11194, 418, 184, 5, 70, "TOCSection",
 CellID->591458949],
Cell[11381, 425, 198, 5, 70, "TOCSection",
 CellID->92077588],
Cell[CellGroupData[{
Cell[11604, 434, 193, 4, 70, "TOCSection",
 CellID->72823918],
Cell[11800, 440, 188, 5, 70, "TOCSubsubsection",
 CellID->86972363]
}, Open  ]],
Cell[CellGroupData[{
Cell[12025, 450, 201, 4, 70, "TOCSection",
 CellID->544265879],
Cell[12229, 456, 186, 5, 70, "TOCSubsection",
 CellID->363648078],
Cell[12418, 463, 190, 5, 70, "TOCSubsection",
 CellID->60965605]
}, Open  ]],
Cell[CellGroupData[{
Cell[12645, 473, 208, 4, 70, "TOCSection",
 CellID->26291739],
Cell[12856, 479, 193, 5, 70, "TOCSubsection",
 CellID->26703503],
Cell[13052, 486, 171, 5, 70, "TOCSubsection",
 CellID->34251989],
Cell[13226, 493, 178, 5, 70, "TOCSubsection",
 CellID->12626880],
Cell[13407, 500, 205, 5, 70, "TOCSubsection",
 CellID->110485629],
Cell[13615, 507, 228, 6, 70, "TOCSubsection",
 CellID->211009011]
}, Open  ]],
Cell[CellGroupData[{
Cell[13880, 518, 221, 5, 70, "TOCSection",
 CellID->131522320],
Cell[14104, 525, 192, 5, 70, "TOCSubsection",
 CellID->44485686],
Cell[14299, 532, 181, 5, 70, "TOCSubsection",
 CellID->317486452],
Cell[14483, 539, 187, 5, 70, "TOCSubsection",
 CellID->387263229],
Cell[14673, 546, 188, 5, 70, "TOCSubsection",
 CellID->51992195],
Cell[14864, 553, 207, 5, 70, "TOCSubsection",
 CellID->156876262]
}, Open  ]],
Cell[CellGroupData[{
Cell[15108, 563, 179, 5, 70, "TOCSection",
 CellID->105949497],
Cell[15290, 570, 205, 5, 70, "TOCSubsection",
 CellID->853286544]
}, Open  ]],
Cell[CellGroupData[{
Cell[15532, 580, 172, 4, 70, "TOCSection",
 CellID->430931908],
Cell[CellGroupData[{
Cell[15729, 588, 196, 5, 70, "TOCSubsection",
 CellID->55123627],
Cell[15928, 595, 193, 5, 70, "TOCSubsubsection",
 CellID->560398179]
}, Open  ]],
Cell[CellGroupData[{
Cell[16158, 605, 186, 5, 70, "TOCSubsection",
 CellID->93904596],
Cell[16347, 612, 190, 5, 70, "TOCSubsubsection",
 CellID->109853054],
Cell[16540, 619, 189, 5, 70, "TOCSubsubsection",
 CellID->364257540]
}, Open  ]],
Cell[CellGroupData[{
Cell[16766, 629, 188, 5, 70, "TOCSubsection",
 CellID->171807067],
Cell[16957, 636, 206, 5, 70, "TOCSubsubsection",
 CellID->522700802]
}, Open  ]],
Cell[CellGroupData[{
Cell[17200, 646, 185, 5, 70, "TOCSubsection",
 CellID->375603316],
Cell[17388, 653, 189, 5, 70, "TOCSubsubsection",
 CellID->22280853]
}, Open  ]],
Cell[17592, 661, 188, 5, 70, "TOCSubsection",
 CellID->3538593]
}, Open  ]],
Cell[CellGroupData[{
Cell[17817, 671, 184, 4, 70, "TOCSection",
 CellID->195374595],
Cell[18004, 677, 189, 5, 70, "TOCSubsection",
 CellID->176712340],
Cell[18196, 684, 188, 5, 70, "TOCSubsection",
 CellID->63403799]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18433, 695, 150, 2, 70, "TOCChapter"],
Cell[18586, 699, 147, 3, 70, "TOCSection"],
Cell[18736, 704, 165, 3, 70, "TOCSection"],
Cell[CellGroupData[{
Cell[18926, 711, 154, 3, 70, "TOCSection"],
Cell[19083, 716, 156, 3, 70, "TOCSubsection"],
Cell[19242, 721, 184, 3, 70, "TOCSubsection"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19463, 729, 153, 3, 70, "TOCSection"],
Cell[19619, 734, 185, 3, 70, "TOCSubsection"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19841, 742, 163, 3, 70, "TOCSection"],
Cell[20007, 747, 196, 4, 70, "TOCSubsection"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20240, 756, 155, 3, 70, "TOCSection"],
Cell[20398, 761, 186, 3, 70, "TOCSubsection"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20621, 769, 157, 3, 70, "TOCSection"],
Cell[20781, 774, 187, 3, 70, "TOCSubsection"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21005, 782, 157, 3, 70, "TOCSection"],
Cell[21165, 787, 188, 3, 70, "TOCSubsection"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21390, 795, 153, 3, 70, "TOCSection"],
Cell[21546, 800, 184, 3, 70, "TOCSubsection"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21767, 808, 152, 3, 70, "TOCSection"],
Cell[21922, 813, 183, 3, 70, "TOCSubsection"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22142, 821, 158, 3, 70, "TOCSection"],
Cell[22303, 826, 192, 4, 70, "TOCSubsection"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22532, 835, 153, 3, 70, "TOCSection"],
Cell[22688, 840, 154, 3, 70, "TOCSubsection"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22879, 848, 159, 3, 70, "TOCSection"],
Cell[CellGroupData[{
Cell[23063, 855, 162, 3, 70, "TOCSubsection"],
Cell[23228, 860, 174, 3, 70, "TOCSubsubsection"]
}, Open  ]],
Cell[23417, 866, 153, 3, 70, "TOCSubsection"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23607, 874, 166, 3, 70, "TOCSection"],
Cell[CellGroupData[{
Cell[23798, 881, 165, 3, 70, "TOCSubsection"],
Cell[23966, 886, 161, 3, 70, "TOCSubsubsection"],
Cell[24130, 891, 154, 3, 70, "TOCSubsubsection"],
Cell[24287, 896, 168, 3, 70, "TOCSubsubsection"]
}, Open  ]],
Cell[24470, 902, 151, 3, 70, "TOCSubsection"]
}, Open  ]],
Cell[24636, 908, 158, 3, 70, "TOCSection"]
}, Open  ]],
Cell[24809, 914, 137, 2, 70, "TOCChapter"],
Cell[24949, 918, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

