(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22461,        801]
NotebookOptionsPosition[     13682,        501]
NotebookOutlinePosition[     19254,        687]
CellTagsIndexPosition[     18407,        655]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Advanced Numerical Integration in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/NIntegrateOverview"], 
          "NIntegrate Introduction" :> 
          Documentation`HelpLookup["paclet:tutorial/NIntegrateIntroduction"], 
          "NIntegrate Integration Strategies" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NIntegrateIntegrationStrategies"], 
          "NIntegrate Integration Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NIntegrateIntegrationRules"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Advanced Numerical Integration in Mathematica\"\>", 
       2->"\<\"NIntegrate Introduction\"\>", 
       3->"\<\"NIntegrate Integration Strategies\"\>", 
       4->"\<\"NIntegrate Integration Rules\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Evaluation & Precision" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumericalEvaluationAndPrecision"], "Calculus" :> 
          Documentation`HelpLookup["paclet:guide/Calculus"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Evaluation & Precision\"\>", 
       2->"\<\"Calculus\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NIntegrate References", "Title",
 CellID->358665826],

Cell[TextData[{
 "[BerntEspGenz91] J. Berntsen, T. O. Espelid and A. Genz, \"An Adaptive \
Algorithm for the Approximate Calculation of Multiple Integrals,\" ",
 StyleBox["ACM Trans. Math. Softw",
  FontSlant->"Italic"],
 "., ",
 StyleBox["17",
  FontWeight->"Bold"],
 "(4), 1991 pp. 437-451. http://citeseer.ist.psu.edu/berntsen91adaptive.html"
}], "Text",
 CellTags->"BerntEspGenz91",
 CellID->133940620],

Cell[TextData[{
 "[BrezRedZag91] C. Brezinski and M. Redivo Zaglia, ",
 StyleBox["Extrapolation Methods",
  FontSlant->"Italic"],
 ", Amsterdam: North-Holland, 1991."
}], "Text",
 CellTags->"BrezRedZag91",
 CellID->712720874],

Cell[TextData[{
 "[CohRodVil99] H. Cohen, F. Rodriguez Villegas and D. Zagier, \"Convergence \
Acceleration of Alternating Series,\" ",
 StyleBox["Experimental Mathematics",
  FontSlant->"Italic"],
 " ",
 StyleBox["9",
  FontWeight->"Bold"],
 "(1), 2000. http://www.expmath.org/restricted/9/9.1/cohen.ps"
}], "Text",
 CellID->424151851],

Cell[TextData[{
 "[DavRab65IS] P. J. Davis and P. Rabinowitz, \"Ignoring the Singularity in \
Approximate Integration,\"",
 StyleBox[" J. SIAM: Series B, Numerical Analysis",
  FontSlant->"Italic"],
 ", ",
 StyleBox["2",
  FontWeight->"Bold"],
 "(3), 1965 pp. 367-383."
}], "Text",
 CellTags->"DavRab65IS",
 CellID->34491249],

Cell[TextData[{
 "[DavRab84] P. J. Davis and P. Rabinowitz, ",
 StyleBox["Methods of Numerical Integration",
  FontSlant->"Italic"],
 ", 2nd ed., Orlando: Academic Press, 1984."
}], "Text",
 CellTags->"DavRab84",
 CellID->587039710],

Cell[TextData[{
 "[DeBruijn58] N.G. De Bruijn, ",
 StyleBox["Asymptotic Methods in Analysis",
  FontSlant->"Italic"],
 ", Amsterdam: North-Holland, 1958."
}], "Text",
 CellID->45516089],

Cell[TextData[{
 "[Duffy82] M. G. Duffy, \"Quadrature over a Pyramid or Cube of Integrands \
with a Singularity at a Vertex,\" ",
 StyleBox["J. SIAM Numer. Anal",
  FontSlant->"Italic"],
 "., ",
 StyleBox["19",
  FontWeight->"Bold"],
 "(6), 1982."
}], "Text",
 CellTags->"Duffy82",
 CellID->138937541],

Cell[TextData[{
 "[Ehrich2000] S. Ehrich, \"Stopping Functionals for Gaussian Quadrature \
Formulas,\" ",
 StyleBox["J. Comput. Appl. Math. Special issue on Numerical Analysis 2000, \
Vol. V: Quadrature and Orthogonal Polynomials",
  FontSlant->"Italic"],
 ". ",
 StyleBox["127",
  FontWeight->"Bold"],
 "(1-2), 2001 pp. 153-171, http://citeseer.ist.psu.edu/ehrich00stopping.html"
}], "Text",
 CellTags->"Ehrich2000",
 CellID->78468907],

Cell[TextData[{
 "[Evans93] G. Evans, ",
 StyleBox["Practical Numerical Integration",
  FontSlant->"Italic"],
 ", Chichester, England; N.Y.: Wiley, 1993."
}], "Text",
 CellTags->"Evans93",
 CellID->42112923],

Cell[TextData[{
 "[GenzMalik80] A. C. Genz and A. A. Malik. \"An Adaptive Algorithm for \
Numerical Integration over an N-dimensional Rectangular Region,\"",
 StyleBox[" J. Comp. Appl. Math",
  FontSlant->"Italic"],
 "., ",
 StyleBox["6",
  FontWeight->"Bold"],
 "(4), 1980 pp. 295-302."
}], "Text",
 CellTags->"GenzMalik80",
 CellID->67891716],

Cell[TextData[{
 "[GenzMalik83] A. C. Genz and A. A. Malik. \"An Imbedded Family of Fully \
Symmetric Numerical Integration Rules,\"",
 StyleBox[" J. SIAM Numer. Anal.",
  FontSlant->"Italic"],
 ", ",
 StyleBox["20",
  FontWeight->"Bold"],
 "(3), 1983 pp. 580-588."
}], "Text",
 CellTags->"GenzMalik83",
 CellID->444100062],

Cell[TextData[{
 "[HammHand64] J. M. Hammersley and D. C. Handscomb, ",
 StyleBox["Monte Carlo Methods",
  FontSlant->"Italic"],
 ", London: Chapman and Hall, 1964."
}], "Text",
 CellTags->"HammHand64",
 CellID->110805391],

Cell[TextData[{
 "[IriMorTak70] M. Iri, S. Moriguti and Y. Takasawa, \"On a Certain \
Quadrature Formula,\"",
 StyleBox[" Kokyuroku of the Res. Inst. for Math. Sci. Kyoto Univ",
  FontSlant->"Italic"],
 "., ",
 StyleBox["91",
  FontWeight->"Bold"],
 ", 1970 pp. 82-118 (in Japanese). English translation in ",
 StyleBox["J. Comp. Appl. Math.",
  FontSlant->"Italic"],
 ", ",
 StyleBox["17",
  FontWeight->"Bold"],
 "(1-2), 1987 pp. 3-20."
}], "Text",
 CellTags->"IriMorTak70",
 CellID->18838335],

Cell[TextData[{
 "[KrUeb98] A. R. Krommer and C. W. Ueberhuber, ",
 StyleBox["Computational Integration",
  FontSlant->"Italic"],
 ", Philadelphia: SIAM Publications, 1998."
}], "Text",
 CellTags->"KrUeb98",
 CellID->75031785],

Cell[TextData[{
 "[LynKag76] J. N. Lyness and J. J. Kaganove. \"Comments on the Nature of \
Automatic Quadrature Routines,\"",
 StyleBox[" ACM Trans. Math. Software",
  FontSlant->"Italic"],
 ", ",
 StyleBox["2",
  FontWeight->"Bold"],
 "(1), 1976",
 " ",
 "pp. 65-81."
}], "Text",
 CellTags->"LynKag76",
 CellID->406642067],

Cell[TextData[{
 "[MalcSimp75] M. A. Malcolm and R. B. Simpson. \"Local Versus Global \
Strategies for Adaptive Quadrature,\" ",
 StyleBox["ACM Transactions on Mathematical Software",
  FontSlant->"Italic"],
 ", ",
 StyleBox["1",
  FontWeight->"Bold"],
 "(2), 1975 pp. 129-146."
}], "Text",
 CellTags->"MalcSimp75",
 CellID->147637128],

Cell[TextData[{
 "[Mori74] M.Mori, \"On the Superiority of the Trapezoidal Rule for the \
Integration of Periodic Analytic Functions,\" ",
 StyleBox["Memoirs of Numerical Mathematics",
  FontSlant->"Italic"],
 ", ",
 StyleBox["1",
  FontWeight->"Bold"],
 ", 1974 pp. 11-19."
}], "Text",
 CellTags->"Mori74",
 CellID->137456387],

Cell[TextData[{
 "[MoriOoura93] T. Ooura and M. Mori, \"Double Exponential Formulas for \
Fourier Type Integrals with a Divergent Integrand,\" in: ",
 StyleBox["Contributions in Numerical Mathematics",
  FontSlant->"Italic"],
 ",",
 " ",
 StyleBox["World Scientific Series in Applicable Analysis",
  FontSlant->"Italic"],
 ", N.Y.: World Scientific, 1993, pp.301 - 308."
}], "Text",
 CellTags->"MoriOoura93",
 CellID->90390145],

Cell[TextData[{
 "[MurIri82] K. Murota and M. Iri, \"Parameter Tuning and Repeated \
Application of the IMT-Type Transformation in Numerical Quadrature,\" ",
 StyleBox["Numerische Mathematik",
  FontSlant->"Italic"],
 ", ",
 StyleBox["38",
  FontWeight->"Bold"],
 "(3), 1982 pp. 347-363."
}], "Text",
 CellTags->"MurIri82",
 CellID->151206575],

Cell[TextData[{
 "[OouraMori91] T. Ooura and M. Mori, \"A Double Exponential Formula for \
Oscillatory Functions over the Half Infinite Interval,\" ",
 StyleBox["J. Comput. Appl. Math.",
  FontSlant->"Italic"],
 ", ",
 StyleBox["38",
  FontWeight->"Bold"],
 "(1\[Dash]3), 1991 pp. 353-360."
}], "Text",
 CellTags->"OouraMori91",
 CellID->1713173531],

Cell[TextData[{
 "[OouraMori99] T. Ooura and M. Mori, \"A Robust Double Exponential Formula \
for Fourier-Type Integrals,\"",
 StyleBox["J. Comput. Appl. Math.",
  FontSlant->"Italic"],
 ", ",
 StyleBox["112",
  FontWeight->"Bold"],
 "(1\[Dash]2), 1999 pp. 229-241."
}], "Text",
 CellID->32080313],

Cell[TextData[{
 "[OHaraSmith68]",
 " ",
 "H. O'Hara and F. J. Smith, \"Error Estimation in the Clenshaw-Curtis \
Quadrature Formula,\" ",
 StyleBox["Comput. J.",
  FontSlant->"Italic"],
 " ",
 StyleBox["11",
  FontWeight->"Bold"],
 ", 1968 pp. 213-219. "
}], "Text",
 CellTags->"OHaraSmith68",
 CellID->28772993],

Cell[TextData[{
 "[PiesBrand74] R. Piessens and M. Branders, \"A Note on the Optimal Addition \
of Abscissas to Quadrature Formulas of Gauss and Lobatto Type,\"",
 StyleBox[" Math. of Comput.",
  FontSlant->"Italic"],
 " ",
 StyleBox["28",
  FontWeight->"Bold"],
 "(125), 1974 pp. 135-139."
}], "Text",
 CellTags->"PiesBrand74",
 CellID->186112679],

Cell[TextData[{
 "[PiesBrand75] R. Piessens and M. Branders, \"Algorithm 002. Computation of \
Oscillating Integrals,\" ",
 StyleBox["J. Comput. Appl. Math.",
  FontSlant->"Italic"],
 " ",
 StyleBox["1",
  FontWeight->"Bold"],
 ", 1975 pp. 153-164."
}], "Text",
 CellTags->"PiesBrand75",
 CellID->631520174],

Cell[TextData[{
 "[PiesBrand84] R. Piessens and M. Branders, \"Computation of Fourier \
Transform Integrals Using Chebyshev Series Expansions,\" ",
 StyleBox["Computing",
  FontSlant->"Italic"],
 ", ",
 StyleBox["32",
  FontWeight->"Bold"],
 "(2), 1984 pp.177-186."
}], "Text",
 CellTags->"PiesBrand84",
 CellID->838261],

Cell[TextData[{
 "[PrFlTeuk92] W. H. Press, B. P. Flannery and S. A. Teukolsky, ",
 StyleBox["Numerical Recipes in C",
  FontSlant->"Italic"],
 ", Cambridge University Press, 1992."
}], "Text",
 CellTags->"PrFlTeuk92",
 CellID->196015578],

Cell[TextData[{
 "[Rice75] J. R. Rice, \"A Metalgorithm for Adaptive Quadrature,\" ",
 StyleBox["J. Assoc. Comput. Mach",
  FontSlant->"Italic"],
 ". ",
 StyleBox["22",
  FontWeight->"Bold"],
 "(1), 1975 pp. 61-82."
}], "Text",
 CellTags->"Rice75",
 CellID->323759304],

Cell[TextData[{
 "[SkKeip93] R. D. Skeel and J. B. Keiper, ",
 StyleBox["Elementary Numerical Computing with Mathematica,",
  FontSlant->"Italic"],
 " New York: McGraw-Hill, Inc., 1993."
}], "Text",
 CellTags->"SkKeip93",
 CellID->157030725],

Cell[TextData[{
 "[SloanJoe94] I. H. Sloan and S. Joe,",
 StyleBox[" Lattice Methods for Multiple Integration",
  FontSlant->"Italic"],
 ", New York; Oxford: Oxford University Press, 1994."
}], "Text",
 CellTags->"SloanJoe94",
 CellID->1965527607],

Cell[TextData[{
 "[Stroud71] A. H. Stroud, ",
 StyleBox["Approximate Calculation of Multiple Integrals, ",
  FontSlant->"Italic"],
 "Englewood Cliffs, NJ: Prentice-Hall, 1971. "
}], "Text",
 CellTags->"Stroud71",
 CellID->44510618],

Cell[TextData[{
 "[Weideman2002] J. A. C. Weideman, \"Numerical Integration of Periodic \
Functions: A Few Examples,\"",
 StyleBox[" Amer. Math. Monthly",
  FontSlant->"Italic"],
 ", ",
 StyleBox["109",
  FontWeight->"Bold"],
 "(1) 2002, pp. 21-36."
}], "Text",
 CellTags->"Weideman2003",
 CellID->253113814],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->171462907],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NumericalEvaluationAndPrecision"]], "TutorialMoreAbout",
 CellID->341702418],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Calculus"]], "TutorialMoreAbout",
 CellID->168618367]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->289585108],

Cell[TextData[{
 ButtonBox["Advanced Numerical Integration in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NIntegrateOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NIntegrateOverview"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->655978384],

Cell[TextData[ButtonBox["NIntegrate Introduction",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NIntegrateIntroduction"]], "RelatedTutorials",
 CellID->40399306],

Cell[TextData[ButtonBox["NIntegrate Integration Strategies",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationStrategies"]], "RelatedTutorials",
 CellID->129348187],

Cell[TextData[ButtonBox["NIntegrate Integration Rules",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NIntegrateIntegrationRules"]], "RelatedTutorials",
 CellID->314773658]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NIntegrate References - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 4.9170298}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "[BerntEspGenz91] J. Berntsen, T. O. Espelid and A. Genz, \"An Adaptive \
Algorithm for the Approximate Calculation of Multiple Integrals,\" ACM Trans. \
Math. Softw., 17(4), 1991 pp. 437-451. \
http://citeseer.ist.psu.edu/berntsen91adaptive.html [BrezRedZag91] C. \
Brezinski and M. Redivo Zaglia, Extrapolation Methods, Amsterdam: \
North-Holland, 1991. [CohRodVil99] H. Cohen, F. Rodriguez Villegas and D. \
Zagier, \"Convergence Acceleration of Alternating Series,\" Experimental \
Mathematics 9(1), 2000. http://www.expmath.org/restricted/9/9.1/cohen.ps", 
    "synonyms" -> {}, "title" -> "NIntegrate References", "type" -> 
    "Tutorial", "uri" -> "tutorial/NIntegrateReferences"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "BerntEspGenz91"->{
  Cell[2664, 76, 406, 11, 70, "Text",
   CellTags->"BerntEspGenz91",
   CellID->133940620]},
 "BrezRedZag91"->{
  Cell[3073, 89, 225, 7, 70, "Text",
   CellTags->"BrezRedZag91",
   CellID->712720874]},
 "DavRab65IS"->{
  Cell[3640, 110, 325, 11, 70, "Text",
   CellTags->"DavRab65IS",
   CellID->34491249]},
 "DavRab84"->{
  Cell[3968, 123, 232, 7, 70, "Text",
   CellTags->"DavRab84",
   CellID->587039710]},
 "Duffy82"->{
  Cell[4391, 140, 301, 11, 70, "Text",
   CellTags->"Duffy82",
   CellID->138937541]},
 "Ehrich2000"->{
  Cell[4695, 153, 436, 12, 70, "Text",
   CellTags->"Ehrich2000",
   CellID->78468907]},
 "Evans93"->{
  Cell[5134, 167, 207, 7, 70, "Text",
   CellTags->"Evans93",
   CellID->42112923]},
 "GenzMalik80"->{
  Cell[5344, 176, 344, 11, 70, "Text",
   CellTags->"GenzMalik80",
   CellID->67891716]},
 "GenzMalik83"->{
  Cell[5691, 189, 323, 11, 70, "Text",
   CellTags->"GenzMalik83",
   CellID->444100062]},
 "HammHand64"->{
  Cell[6017, 202, 222, 7, 70, "Text",
   CellTags->"HammHand64",
   CellID->110805391]},
 "IriMorTak70"->{
  Cell[6242, 211, 495, 17, 70, "Text",
   CellTags->"IriMorTak70",
   CellID->18838335]},
 "KrUeb98"->{
  Cell[6740, 230, 226, 7, 70, "Text",
   CellTags->"KrUeb98",
   CellID->75031785]},
 "LynKag76"->{
  Cell[6969, 239, 324, 13, 70, "Text",
   CellTags->"LynKag76",
   CellID->406642067]},
 "MalcSimp75"->{
  Cell[7296, 254, 335, 11, 70, "Text",
   CellTags->"MalcSimp75",
   CellID->147637128]},
 "Mori74"->{
  Cell[7634, 267, 327, 11, 70, "Text",
   CellTags->"Mori74",
   CellID->137456387]},
 "MoriOoura93"->{
  Cell[7964, 280, 427, 12, 70, "Text",
   CellTags->"MoriOoura93",
   CellID->90390145]},
 "MurIri82"->{
  Cell[8394, 294, 343, 11, 70, "Text",
   CellTags->"MurIri82",
   CellID->151206575]},
 "OouraMori91"->{
  Cell[8740, 307, 349, 11, 70, "Text",
   CellTags->"OouraMori91",
   CellID->1713173531]},
 "OHaraSmith68"->{
  Cell[9392, 332, 313, 13, 70, "Text",
   CellTags->"OHaraSmith68",
   CellID->28772993]},
 "PiesBrand74"->{
  Cell[9708, 347, 348, 11, 70, "Text",
   CellTags->"PiesBrand74",
   CellID->186112679]},
 "PiesBrand75"->{
  Cell[10059, 360, 307, 11, 70, "Text",
   CellTags->"PiesBrand75",
   CellID->631520174]},
 "PiesBrand84"->{
  Cell[10369, 373, 320, 11, 70, "Text",
   CellTags->"PiesBrand84",
   CellID->838261]},
 "PrFlTeuk92"->{
  Cell[10692, 386, 238, 7, 70, "Text",
   CellTags->"PrFlTeuk92",
   CellID->196015578]},
 "Rice75"->{
  Cell[10933, 395, 268, 10, 70, "Text",
   CellTags->"Rice75",
   CellID->323759304]},
 "SkKeip93"->{
  Cell[11204, 407, 241, 7, 70, "Text",
   CellTags->"SkKeip93",
   CellID->157030725]},
 "SloanJoe94"->{
  Cell[11448, 416, 247, 7, 70, "Text",
   CellTags->"SloanJoe94",
   CellID->1965527607]},
 "Stroud71"->{
  Cell[11698, 425, 231, 7, 70, "Text",
   CellTags->"Stroud71",
   CellID->44510618]},
 "Weideman2003"->{
  Cell[11932, 434, 308, 11, 70, "Text",
   CellTags->"Weideman2003",
   CellID->253113814]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"BerntEspGenz91", 15440, 540},
 {"BrezRedZag91", 15552, 544},
 {"DavRab65IS", 15659, 548},
 {"DavRab84", 15763, 552},
 {"Duffy82", 15864, 556},
 {"Ehrich2000", 15968, 560},
 {"Evans93", 16071, 564},
 {"GenzMalik80", 16174, 568},
 {"GenzMalik83", 16282, 572},
 {"HammHand64", 16390, 576},
 {"IriMorTak70", 16497, 580},
 {"KrUeb98", 16601, 584},
 {"LynKag76", 16701, 588},
 {"MalcSimp75", 16806, 592},
 {"Mori74", 16909, 596},
 {"MoriOoura93", 17013, 600},
 {"MurIri82", 17118, 604},
 {"OouraMori91", 17224, 608},
 {"OHaraSmith68", 17335, 612},
 {"PiesBrand74", 17444, 616},
 {"PiesBrand75", 17553, 620},
 {"PiesBrand84", 17663, 624},
 {"PrFlTeuk92", 17769, 628},
 {"Rice75", 17872, 632},
 {"SkKeip93", 17974, 636},
 {"SloanJoe94", 18079, 640},
 {"Stroud71", 18185, 644},
 {"Weideman2003", 18291, 648}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1978, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2603, 73, 58, 1, 70, "Title",
 CellID->358665826],
Cell[2664, 76, 406, 11, 70, "Text",
 CellTags->"BerntEspGenz91",
 CellID->133940620],
Cell[3073, 89, 225, 7, 70, "Text",
 CellTags->"BrezRedZag91",
 CellID->712720874],
Cell[3301, 98, 336, 10, 70, "Text",
 CellID->424151851],
Cell[3640, 110, 325, 11, 70, "Text",
 CellTags->"DavRab65IS",
 CellID->34491249],
Cell[3968, 123, 232, 7, 70, "Text",
 CellTags->"DavRab84",
 CellID->587039710],
Cell[4203, 132, 185, 6, 70, "Text",
 CellID->45516089],
Cell[4391, 140, 301, 11, 70, "Text",
 CellTags->"Duffy82",
 CellID->138937541],
Cell[4695, 153, 436, 12, 70, "Text",
 CellTags->"Ehrich2000",
 CellID->78468907],
Cell[5134, 167, 207, 7, 70, "Text",
 CellTags->"Evans93",
 CellID->42112923],
Cell[5344, 176, 344, 11, 70, "Text",
 CellTags->"GenzMalik80",
 CellID->67891716],
Cell[5691, 189, 323, 11, 70, "Text",
 CellTags->"GenzMalik83",
 CellID->444100062],
Cell[6017, 202, 222, 7, 70, "Text",
 CellTags->"HammHand64",
 CellID->110805391],
Cell[6242, 211, 495, 17, 70, "Text",
 CellTags->"IriMorTak70",
 CellID->18838335],
Cell[6740, 230, 226, 7, 70, "Text",
 CellTags->"KrUeb98",
 CellID->75031785],
Cell[6969, 239, 324, 13, 70, "Text",
 CellTags->"LynKag76",
 CellID->406642067],
Cell[7296, 254, 335, 11, 70, "Text",
 CellTags->"MalcSimp75",
 CellID->147637128],
Cell[7634, 267, 327, 11, 70, "Text",
 CellTags->"Mori74",
 CellID->137456387],
Cell[7964, 280, 427, 12, 70, "Text",
 CellTags->"MoriOoura93",
 CellID->90390145],
Cell[8394, 294, 343, 11, 70, "Text",
 CellTags->"MurIri82",
 CellID->151206575],
Cell[8740, 307, 349, 11, 70, "Text",
 CellTags->"OouraMori91",
 CellID->1713173531],
Cell[9092, 320, 297, 10, 70, "Text",
 CellID->32080313],
Cell[9392, 332, 313, 13, 70, "Text",
 CellTags->"OHaraSmith68",
 CellID->28772993],
Cell[9708, 347, 348, 11, 70, "Text",
 CellTags->"PiesBrand74",
 CellID->186112679],
Cell[10059, 360, 307, 11, 70, "Text",
 CellTags->"PiesBrand75",
 CellID->631520174],
Cell[10369, 373, 320, 11, 70, "Text",
 CellTags->"PiesBrand84",
 CellID->838261],
Cell[10692, 386, 238, 7, 70, "Text",
 CellTags->"PrFlTeuk92",
 CellID->196015578],
Cell[10933, 395, 268, 10, 70, "Text",
 CellTags->"Rice75",
 CellID->323759304],
Cell[11204, 407, 241, 7, 70, "Text",
 CellTags->"SkKeip93",
 CellID->157030725],
Cell[11448, 416, 247, 7, 70, "Text",
 CellTags->"SloanJoe94",
 CellID->1965527607],
Cell[11698, 425, 231, 7, 70, "Text",
 CellTags->"Stroud71",
 CellID->44510618],
Cell[11932, 434, 308, 11, 70, "Text",
 CellTags->"Weideman2003",
 CellID->253113814],
Cell[CellGroupData[{
Cell[12265, 449, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->171462907],
Cell[12334, 452, 186, 4, 70, "TutorialMoreAbout",
 CellID->341702418],
Cell[12523, 458, 136, 3, 70, "TutorialMoreAbout",
 CellID->168618367]
}, Open  ]],
Cell[CellGroupData[{
Cell[12696, 466, 72, 1, 70, "RelatedTutorialsSection",
 CellID->289585108],
Cell[12771, 469, 314, 9, 70, "RelatedTutorials",
 CellID->655978384],
Cell[13088, 480, 166, 3, 70, "RelatedTutorials",
 CellID->40399306],
Cell[13257, 485, 189, 4, 70, "RelatedTutorials",
 CellID->129348187],
Cell[13449, 491, 179, 4, 70, "RelatedTutorials",
 CellID->314773658]
}, Open  ]]
}, Open  ]],
Cell[13655, 499, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

