(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7356,        231]
NotebookOptionsPosition[      3890,        141]
NotebookOutlinePosition[      6902,        214]
CellTagsIndexPosition[      6813,        208]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Mathematical Functions" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/MathematicalFunctionsOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Mathematical Functions\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Naming Conventions", "Title",
 CellTags->{"S3.2.1", "1.1"},
 CellID->17942],

Cell[TextData[{
 "Mathematical functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are given names according to definite rules. As with most ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions, the names are usually complete English words, fully spelled \
out. For a few very common functions, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the traditional abbreviations. Thus the modulo function, for example, \
is ",
 Cell[BoxData[
  ButtonBox["Mod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mod"]], "InlineFormula"],
 ", not ",
 Cell[BoxData["Modulo"], "InlineFormula"],
 ". "
}], "Text",
 CellID->14972],

Cell[TextData[{
 "Mathematical functions that are usually referred to by a person\
\[CloseCurlyQuote]s name have names in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " of the form ",
 StyleBox["PersonSymbol",
  FontSlant->"Italic"],
 ". Thus, for example, the Legendre polynomials ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["P", "n"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " are denoted ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LegendreP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LegendreP"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 ". Although this convention does lead to longer function names, it avoids \
any ambiguity or confusion. "
}], "Text",
 CellID->22650],

Cell[TextData[{
 "When the standard notation for a mathematical function involves both \
subscripts and superscripts, the subscripts are given ",
 StyleBox["before",
  FontSlant->"Italic"],
 " the superscripts in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " form. Thus, for example, the associated Legendre polynomials ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["P", "n", "m"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " are denoted ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LegendreP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LegendreP"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->15008],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->310953915],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/MathematicalFunctionsOverview"]], "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Naming Conventions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Mathematical Functions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/MathematicalFunctionsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NumericalFunctions"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 39, 39.9773554}", "context" -> "", 
    "keywords" -> {
     "mathematical functions", "naming conventions", "subscripts"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematical functions in Mathematica are given names according to \
definite rules. As with most Mathematica functions, the names are usually \
complete English words, fully spelled out. For a few very common functions, \
Mathematica uses the traditional abbreviations. Thus the modulo function, for \
example, is Mod, not Modulo. Mathematical functions that are usually referred \
to by a person's name have names in Mathematica of the form PersonSymbol. \
Thus, for example, the Legendre polynomials P_n(x) are denoted \
LegendreP[n,x]. Although this convention does lead to longer function names, \
it avoids any ambiguity or confusion. When the standard notation for a \
mathematical function involves both subscripts and superscripts, the \
subscripts are given before the superscripts in the Mathematica form. Thus, \
for example, the associated Legendre polynomials SubsuperscriptBox[P, n, \
m](x) are denoted LegendreP[n,m,x].", "synonyms" -> {"3.2.1"}, "title" -> 
    "Naming Conventions", "type" -> "Tutorial", "uri" -> 
    "tutorial/NamingConventions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.2.1"->{
  Cell[1266, 43, 81, 2, 70, "Title",
   CellTags->{"S3.2.1", "1.1"},
   CellID->17942]},
 "1.1"->{
  Cell[1266, 43, 81, 2, 70, "Title",
   CellTags->{"S3.2.1", "1.1"},
   CellID->17942]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.2.1", 6602, 197},
 {"1.1", 6701, 201}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 641, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1266, 43, 81, 2, 70, "Title",
 CellTags->{"S3.2.1", "1.1"},
 CellID->17942],
Cell[1350, 47, 657, 21, 70, "Text",
 CellID->14972],
Cell[2010, 70, 783, 26, 70, "Text",
 CellID->22650],
Cell[2796, 98, 765, 26, 70, "Text",
 CellID->15008],
Cell[CellGroupData[{
Cell[3586, 128, 72, 1, 70, "RelatedTutorialsSection",
 CellID->310953915],
Cell[3661, 131, 175, 4, 70, "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]],
Cell[3863, 139, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

