(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14656,        445]
NotebookOptionsPosition[     10501,        330]
NotebookOutlinePosition[     13624,        406]
CellTagsIndexPosition[     13532,        400]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Input and Output in Notebooks" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/InputAndOutputInNotebooksOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Input and Output in Notebooks\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\<\
Non\[Hyphen]English Characters and Keyboards\
\>", "Title",
 CellTags->{"S1.10.7", "7.1"},
 CellID->30442],

Cell[TextData[{
 "If you enter text in languages other than English, you will typically need \
to use various additional accented and other characters. If your computer \
system is set up in an appropriate way, then you will be able to enter such \
characters directly using standard keys on your keyboard. But however your \
system is set up, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " always provides a uniform way to handle such characters."
}], "Text",
 CellID->1979],

Cell[BoxData[GridBox[{
   {GridBox[{
      {"", Cell["full name", "TableHeader"], Cell["alias", "TableHeader"]},
      {"\[AGrave]", 
       ButtonBox[
        RowBox[{"\[Backslash]", 
         RowBox[{"[", "AGrave", "]"}]}],
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/AGrave"], 
       "\[AliasIndicator]a`\[AliasIndicator]"},
      {"\[ARing]", 
       ButtonBox[
        RowBox[{"\[Backslash]", 
         RowBox[{"[", "ARing", "]"}]}],
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/ARing"], 
       "\[AliasIndicator]ao\[AliasIndicator]"},
      {"\[ADoubleDot]", 
       ButtonBox[
        RowBox[{"\[Backslash]", 
         RowBox[{"[", "ADoubleDot", "]"}]}],
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/ADoubleDot"], 
       RowBox[{"\[AliasIndicator]a", "\"\<\[AliasIndicator]\>"}]},
      {"\[CCedilla]", 
       ButtonBox[
        RowBox[{"\[Backslash]", 
         RowBox[{"[", "CCedilla", "]"}]}],
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/CCedilla"], 
       RowBox[{"\[AliasIndicator]c", ",", "\[AliasIndicator]"}]},
      {"\[CHacek]", 
       ButtonBox[
        RowBox[{"\[Backslash]", 
         RowBox[{"[", "CHacek", "]"}]}],
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/CHacek"], 
       "\[AliasIndicator]cv\[AliasIndicator]"},
      {"\[EAcute]", 
       ButtonBox[
        RowBox[{"\[Backslash]", 
         RowBox[{"[", "EAcute", "]"}]}],
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/EAcute"], 
       RowBox[{
        RowBox[{"\[AliasIndicator]e", "'"}], "\[AliasIndicator]"}]},
      {"\[EGrave]", 
       ButtonBox[
        RowBox[{"\[Backslash]", 
         RowBox[{"[", "EGrave", "]"}]}],
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/EGrave"], 
       "\[AliasIndicator]e`\[AliasIndicator]"},
      {"\[IAcute]", 
       ButtonBox[
        RowBox[{"\[Backslash]", 
         RowBox[{"[", "IAcute", "]"}]}],
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/IAcute"], 
       RowBox[{
        RowBox[{"\[AliasIndicator]i", "'"}], "\[AliasIndicator]"}]},
      {"\[NTilde]", 
       ButtonBox[
        RowBox[{"\[Backslash]", 
         RowBox[{"[", "NTilde", "]"}]}],
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/NTilde"], 
       RowBox[{"\[AliasIndicator]n", "~", "\[AliasIndicator]"}]},
      {"\[OGrave]", 
       ButtonBox[
        RowBox[{"\[Backslash]", 
         RowBox[{"[", "OGrave", "]"}]}],
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/OGrave"], 
       "\[AliasIndicator]o`\[AliasIndicator]"}
     },
     GridBoxAlignment->{
      "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}], GridBox[{
      {"", Cell["full name", "TableHeader"], Cell["alias", "TableHeader"]},
      {"\[OSlash]", 
       ButtonBox[
        RowBox[{"\[Backslash]", 
         RowBox[{"[", "OSlash", "]"}]}],
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/OSlash"], 
       RowBox[{"\[AliasIndicator]o", "/", "\[AliasIndicator]"}]},
      {"\[ODoubleDot]", 
       ButtonBox[
        RowBox[{"\[Backslash]", 
         RowBox[{"[", "ODoubleDot", "]"}]}],
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/ODoubleDot"], 
       RowBox[{"\[AliasIndicator]o", "\"\<\[AliasIndicator]\>"}]},
      {"\[UGrave]", 
       ButtonBox[
        RowBox[{"\[Backslash]", 
         RowBox[{"[", "UGrave", "]"}]}],
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/UGrave"], 
       "\[AliasIndicator]u`\[AliasIndicator]"},
      {"\[UDoubleDot]", 
       ButtonBox[
        RowBox[{"\[Backslash]", 
         RowBox[{"[", "UDoubleDot", "]"}]}],
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/UDoubleDot"], 
       RowBox[{"\[AliasIndicator]u", "\"\<\[AliasIndicator]\>"}]},
      {"\[SZ]", 
       ButtonBox[
        RowBox[{"\[Backslash]", 
         RowBox[{"[", "SZ", "]"}]}],
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/SZ"], 
       RowBox[{
       "\[AliasIndicator]sz\[AliasIndicator]", ",", " ", 
        "\[AliasIndicator]ss\[AliasIndicator]"}]},
      {"\[CapitalARing]", 
       ButtonBox[
        RowBox[{"\[Backslash]", 
         RowBox[{"[", "CapitalARing", "]"}]}],
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/CapitalARing"], 
       "\[AliasIndicator]Ao\[AliasIndicator]"},
      {"\[CapitalADoubleDot]", 
       ButtonBox[
        RowBox[{"\[Backslash]", 
         RowBox[{"[", "CapitalADoubleDot", "]"}]}],
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/CapitalADoubleDot"], 
       RowBox[{"\[AliasIndicator]A", "\"\<\[AliasIndicator]\>"}]},
      {"\[CapitalODoubleDot]", 
       ButtonBox[
        RowBox[{"\[Backslash]", 
         RowBox[{"[", "CapitalODoubleDot", "]"}]}],
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/CapitalODoubleDot"], 
       RowBox[{"\[AliasIndicator]O", "\"\<\[AliasIndicator]\>"}]},
      {"\[CapitalUDoubleDot]", 
       ButtonBox[
        RowBox[{"\[Backslash]", 
         RowBox[{"[", "CapitalUDoubleDot", "]"}]}],
        BaseStyle->"Link",
        ButtonData->"paclet:ref/character/CapitalUDoubleDot"], 
       RowBox[{"\[AliasIndicator]U", "\"\<\[AliasIndicator]\>"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->186014964],

Cell["Some common European characters. ", "Caption",
 CellID->8889],

Cell["\<\
Here is a function whose name involves an accented character. \
\>", "MathCaption",
 CellID->25780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Lam\[EAcute]", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->31265],

Cell[BoxData[
 RowBox[{"Lam\[EAcute]", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->4783]
}, Open  ]],

Cell["This is another way to enter the same input. ", "MathCaption",
 CellID->15794],

Cell[CellGroupData[{

Cell[TextData[{
 "Lam\[AliasIndicator]",
 StyleBox["e'\[AliasIndicator]", "MR"],
 "[x, y]"
}], "Input", "ConversionLockdown",
 CellLabel->"In[2]:= ",
 CellID->8463],

Cell[BoxData[
 RowBox[{"Lam\[EAcute]", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->17013]
}, Open  ]],

Cell["\<\
You should realize that there is no uniform standard for computer keyboards \
around the world, and as a result it is inevitable that some details of what \
has been said in this tutorial may not apply to your keyboard. \
\>", "Text",
 CellID->20925],

Cell[TextData[{
 "In particular, the identification for example of ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["6", "KeyEvent"],
 " with ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 " is valid only for keyboards on which ",
 StyleBox["^", "KeyEvent"],
 " appears as ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["6", "KeyEvent"],
 ". On other keyboards, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["6 ", "KeyEvent"],
 "to go to a superscript position, but not necessarily ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 ". "
}], "Text",
 CellID->1961],

Cell[TextData[{
 "Regardless of how your keyboard is set up you can always use palettes or \
menu items to set up superscripts and other kinds of notation. And assuming \
you have some way to enter characters such as ",
 Cell[BoxData["\[Backslash]"], "InlineFormula"],
 ", you can always give input using full names such as ",
 Cell[BoxData[
  ButtonBox["\\[Infinity]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Infinity"]], "InlineCharacterName"],
 ". "
}], "Text",
 CellID->16397],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->190321900],

Cell[TextData[ButtonBox["Input and Output in Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "RelatedTutorials",
 CellID->133182837]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Non-English Characters and Keyboards - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Input and Output in Notebooks", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SubscriptsBarsAndOtherModifiers"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/OtherMathematicalNotation"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 5.1045346}", "context" -> "", 
    "keywords" -> {
     "accented characters", "diacritical marks", "Esszed", 
      "European characters", "foreign characters", "French characters", 
      "German characters", "international characters", "Italian characters", 
      "keyboards", "Spanish characters", "SZ"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "If you enter text in languages other than English, you will typically \
need to use various additional accented and other characters. If your \
computer system is set up in an appropriate way, then you will be able to \
enter such characters directly using standard keys on your keyboard. But \
however your system is set up, Mathematica always provides a uniform way to \
handle such characters. Some common European characters. Here is a function \
whose name involves an accented character. ", "synonyms" -> {"1.10.7"}, 
    "title" -> "Non-English Characters and Keyboards", "type" -> "Tutorial", 
    "uri" -> "tutorial/NonEnglishCharactersAndKeyboards"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.10.7"->{
  Cell[1286, 44, 116, 4, 70, "Title",
   CellTags->{"S1.10.7", "7.1"},
   CellID->30442]},
 "7.1"->{
  Cell[1286, 44, 116, 4, 70, "Title",
   CellTags->{"S1.10.7", "7.1"},
   CellID->30442]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.10.7", 13317, 389},
 {"7.1", 13418, 393}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 661, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1286, 44, 116, 4, 70, "Title",
 CellTags->{"S1.10.7", "7.1"},
 CellID->30442],
Cell[1405, 50, 483, 10, 70, "Text",
 CellID->1979],
Cell[1891, 62, 5601, 151, 70, "DoubleBox",
 CellID->186014964],
Cell[7495, 215, 67, 1, 70, "Caption",
 CellID->8889],
Cell[7565, 218, 109, 3, 70, "MathCaption",
 CellID->25780],
Cell[CellGroupData[{
Cell[7699, 225, 128, 4, 28, "Input",
 CellID->31265],
Cell[7830, 231, 215, 7, 36, "Output",
 CellID->4783]
}, Open  ]],
Cell[8060, 241, 84, 1, 70, "MathCaption",
 CellID->15794],
Cell[CellGroupData[{
Cell[8169, 246, 164, 6, 28, "Input",
 CellID->8463],
Cell[8336, 254, 216, 7, 36, "Output",
 CellID->17013]
}, Open  ]],
Cell[8567, 264, 260, 5, 70, "Text",
 CellID->20925],
Cell[8830, 271, 828, 28, 70, "Text",
 CellID->1961],
Cell[9661, 301, 499, 12, 70, "Text",
 CellID->16397],
Cell[CellGroupData[{
Cell[10185, 317, 72, 1, 70, "RelatedTutorialsSection",
 CellID->190321900],
Cell[10260, 320, 187, 4, 70, "RelatedTutorials",
 CellID->133182837]
}, Open  ]]
}, Open  ]],
Cell[10474, 328, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

