(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40413,       1423]
NotebookOptionsPosition[     31601,       1149]
NotebookOutlinePosition[     35464,       1236]
CellTagsIndexPosition[     35371,       1230]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EvaluationOfExpressionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Evaluation of Expressions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Do" :> Documentation`HelpLookup["paclet:ref/Do"], "Evaluate" :> 
          Documentation`HelpLookup["paclet:ref/Evaluate"], "Extract" :> 
          Documentation`HelpLookup["paclet:ref/Extract"], "False" :> 
          Documentation`HelpLookup["paclet:ref/False"], "Function" :> 
          Documentation`HelpLookup["paclet:ref/Function"], "Hold" :> 
          Documentation`HelpLookup["paclet:ref/Hold"], "HoldAll" :> 
          Documentation`HelpLookup["paclet:ref/HoldAll"], "HoldAllComplete" :> 
          Documentation`HelpLookup["paclet:ref/HoldAllComplete"], 
          "HoldComplete" :> 
          Documentation`HelpLookup["paclet:ref/HoldComplete"], "HoldFirst" :> 
          Documentation`HelpLookup["paclet:ref/HoldFirst"], "HoldForm" :> 
          Documentation`HelpLookup["paclet:ref/HoldForm"], "HoldRest" :> 
          Documentation`HelpLookup["paclet:ref/HoldRest"], "If" :> 
          Documentation`HelpLookup["paclet:ref/If"], "Plot" :> 
          Documentation`HelpLookup["paclet:ref/Plot"], "ReleaseHold" :> 
          Documentation`HelpLookup["paclet:ref/ReleaseHold"], "Sequence" :> 
          Documentation`HelpLookup["paclet:ref/Sequence"], "SequenceHold" :> 
          Documentation`HelpLookup["paclet:ref/SequenceHold"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"], "Unevaluated" :> 
          Documentation`HelpLookup["paclet:ref/Unevaluated"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Do\"\>", 2->"\<\"Evaluate\"\>", 
       3->"\<\"Extract\"\>", 4->"\<\"False\"\>", 5->"\<\"Function\"\>", 
       6->"\<\"Hold\"\>", 7->"\<\"HoldAll\"\>", 8->"\<\"HoldAllComplete\"\>", 
       9->"\<\"HoldComplete\"\>", 10->"\<\"HoldFirst\"\>", 
       11->"\<\"HoldForm\"\>", 12->"\<\"HoldRest\"\>", 13->"\<\"If\"\>", 
       14->"\<\"Plot\"\>", 15->"\<\"ReleaseHold\"\>", 16->"\<\"Sequence\"\>", 
       17->"\<\"SequenceHold\"\>", 18->"\<\"True\"\>", 
       19->"\<\"Unevaluated\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Non\[Hyphen]Standard Evaluation", "Title",
 CellTags->{"S2.6.5", "5.1"},
 CellID->7491],

Cell[TextData[{
 "While most built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions follow the standard evaluation procedure, some important ones do \
not. For example, most of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions associated with the construction and execution of programs use \
non\[Hyphen]standard evaluation procedures. In typical cases, the functions \
either never evaluate some of their arguments, or do so in a special way \
under their own control. "
}], "Text",
 CellID->28647],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["x", "TI"], "=", 
     StyleBox["y", "TI"]}], Cell["\<\
do not evaluate the left\[Hyphen]hand side\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["If",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/If"], "[", 
     StyleBox["p", "TI"], ",", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      FormBox["a", TraditionalForm]], "InlineMath"],
     " if ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"],
     " if it is ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Do",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Do"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " times"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Plot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Plot"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " with a sequence of numerical values for ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Function",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Function"], "[", "{", 
     StyleBox["x", "TI"], "}", ",", 
     StyleBox["body", "TI"], "]"}], Cell[
    "do not evaluate until the function is applied", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->3617],

Cell["\<\
Some functions that use non\[Hyphen]standard evaluation procedures. \
\>", "Caption",
 CellID->947],

Cell[TextData[{
 "When you give a definition such as ",
 Cell[BoxData[
  RowBox[{"a", "=", "1"}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not evaluate the ",
 Cell[BoxData["a"], "InlineFormula"],
 " that appears on the left\[Hyphen]hand side. You can see that there would \
be trouble if the ",
 Cell[BoxData["a"], "InlineFormula"],
 " was evaluated. The reason is that if you had previously set ",
 Cell[BoxData[
  RowBox[{"a", "=", "7"}]], "InlineFormula"],
 ", then evaluating ",
 Cell[BoxData["a"], "InlineFormula"],
 " in the definition ",
 Cell[BoxData[
  RowBox[{"a", "=", "1"}]], "InlineFormula"],
 " would put the definition into the nonsensical form ",
 Cell[BoxData[
  RowBox[{"7", "=", "1"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->14889],

Cell[TextData[{
 "In the standard evaluation procedure, each argument of a function is \
evaluated in turn. This is prevented by setting the attributes ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["HoldRest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldRest"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ". These attributes make ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \[OpenCurlyDoubleQuote]hold\[CloseCurlyDoubleQuote] particular arguments \
in an unevaluated form."
}], "Text",
 CellID->31092],

Cell[BoxData[GridBox[{
   {
    ButtonBox["HoldFirst",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/HoldFirst"], Cell[
    "do not evaluate the first argument", "TableText"]},
   {
    ButtonBox["HoldRest",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/HoldRest"], Cell[
    "evaluate only the first argument", "TableText"]},
   {
    ButtonBox["HoldAll",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/HoldAll"], Cell[
    "evaluate none of the arguments", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23296],

Cell["\<\
Attributes for holding function arguments in unevaluated form. \
\>", "Caption",
 CellID->16834],

Cell["\<\
With the standard evaluation procedure, all arguments to a function are \
evaluated. \
\>", "MathCaption",
 CellID->28223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"1", "+", "1"}], ",", 
   RowBox[{"2", "+", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->32172],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"2", ",", "6"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->11048]
}, Open  ]],

Cell[TextData[{
 "This assigns the attribute ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 " to\[NonBreakingSpace]",
 Cell[BoxData["h"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"h", ",", "HoldFirst"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->22291],

Cell[TextData[{
 "The first argument to ",
 Cell[BoxData["h"], "InlineFormula"],
 " is now held in an unevaluated form. "
}], "MathCaption",
 CellID->18166],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{
   RowBox[{"1", "+", "1"}], ",", 
   RowBox[{"2", "+", "4"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->30261],

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{
   RowBox[{"1", "+", "1"}], ",", "6"}], "]"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->4981]
}, Open  ]],

Cell[TextData[{
 "When you use the first argument to ",
 Cell[BoxData["h"], "InlineFormula"],
 " like this, it will get evaluated. "
}], "MathCaption",
 CellID->941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", 
   RowBox[{
    RowBox[{"1", "+", "1"}], ",", 
    RowBox[{"2", "+", "4"}]}], "]"}], "/.", 
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], "->", 
   RowBox[{"x", "^", "y"}]}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->16461],

Cell[BoxData["64"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->29443]
}, Open  ]],

Cell[TextData[{
 "Built\[Hyphen]in functions like ",
 Cell[BoxData[
  ButtonBox["Set",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"]], "InlineFormula"],
 " carry attributes such as ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Set", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->3696],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldFirst", ",", "Protected", ",", "SequenceHold"}], 
  "}"}]], "Output",
 ImageSize->{251, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->14229]
}, Open  ]],

Cell[TextData[{
 "Even though a function may have attributes which specify that it should \
hold certain arguments unevaluated, you can always explicitly tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to evaluate those arguments by giving the arguments in the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Evaluate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Evaluate"], "[", 
   StyleBox["arg", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->8373],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " effectively overrides the ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 " attribute, and causes the first argument to be evaluated. "
}], "MathCaption",
 CellID->23900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"1", "+", "1"}], "]"}], ",", 
   RowBox[{"2", "+", "4"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->3650],

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{"2", ",", "6"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->6703]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["f", "TI"], "[", 
     ButtonBox["Evaluate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Evaluate"], "[", 
     StyleBox["arg", "TI"], "]", "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["arg", "TI"]], "InlineFormula"],
     " immediately, even though attributes of ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " may specify that it should be held"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->24828],

Cell["Forcing the evaluation of function arguments. ", "Caption",
 CellID->14731],

Cell[TextData[{
 "By holding its arguments, a function can control when those arguments are \
evaluated. By using ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 ", you can force the arguments to be evaluated immediately, rather than \
being evaluated under the control of the function. This capability is useful \
in a number of circumstances. "
}], "Text",
 CellID->8941],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["Set",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"]], "InlineFormula"],
 " function holds its first argument, so the symbol ",
 Cell[BoxData["a"], "InlineFormula"],
 " is not evaluated in this case. "
}], "MathCaption",
 CellID->788],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", "b"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->23479],

Cell[BoxData["b"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->8073]
}, Open  ]],

Cell[TextData[{
 "You can make ",
 Cell[BoxData[
  ButtonBox["Set",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"]], "InlineFormula"],
 " evaluate its first argument using ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 ". In this case, the result is the object which is the ",
 StyleBox["value",
  FontSlant->"Italic"],
 " of ",
 Cell[BoxData["a"], "InlineFormula"],
 ", namely ",
 Cell[BoxData["b"], "InlineFormula"],
 " is set to ",
 Cell[BoxData["6"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Evaluate", "[", "a", "]"}], "=", "6"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->737],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->3555]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["b"], "InlineFormula"],
 " has now been set to ",
 Cell[BoxData["6"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28814],

Cell[CellGroupData[{

Cell[BoxData["b"], "Input",
 CellLabel->"In[10]:= ",
 CellID->11431],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->16000]
}, Open  ]],

Cell[TextData[{
 "In most cases, you want all expressions you give to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to be evaluated. Sometimes, however, you may want to prevent the \
evaluation of certain expressions. For example, if you want to manipulate \
pieces of a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program symbolically, then you must prevent those pieces from being \
evaluated while you are manipulating them. "
}], "Text",
 CellID->7997],

Cell[TextData[{
 "You can use the functions ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 " to keep expressions unevaluated. These functions work simply by carrying \
the attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ", which prevents their arguments from being evaluated. The functions \
provide \[OpenCurlyDoubleQuote]wrappers\[CloseCurlyDoubleQuote] inside which \
expressions remain unevaluated. "
}], "Text",
 CellID->16411],

Cell[TextData[{
 "The difference between ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hold",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hold"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HoldForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldForm"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is that in standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output format, ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 " is printed explicitly, while ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 " is not. If you look at the full internal ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " form, you can however see both functions. "
}], "Text",
 CellID->17008],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 " maintains expressions in an unevaluated form. "
}], "MathCaption",
 CellID->16917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"1", "+", "1"}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->20202],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"1", "+", "1"}], "]"}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->26128]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 " also keeps expressions unevaluated, but is invisible in standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output format. "
}], "MathCaption",
 CellID->1245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldForm", "[", 
  RowBox[{"1", "+", "1"}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->25639],

Cell[BoxData[
 TagBox[
  RowBox[{"1", "+", "1"}],
  HoldForm]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->6629]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 " is still present internally. "
}], "MathCaption",
 CellID->10699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->8933],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"HoldForm", "[", 
    RowBox[{"Plus", "[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]//FullForm= ",
 CellID->18596]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["ReleaseHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReleaseHold"]], "InlineFormula"],
 " removes ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 ", so the expressions they contain get evaluated. "
}], "MathCaption",
 CellID->16884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReleaseHold", "[", "%", "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->32076],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->24729]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Hold",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hold"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "keep ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " unevaluated"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["HoldComplete",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HoldComplete"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "keep ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " unevaluated and prevent upvalues associated with ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " from being used"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["HoldForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HoldForm"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "keep ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " unevaluated, and print without ",
     Cell[BoxData[
      ButtonBox["HoldForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ReleaseHold",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReleaseHold"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "remove ",
     Cell[BoxData[
      ButtonBox["Hold",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["HoldForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Extract",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Extract"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["index", "TI"], ",", 
     ButtonBox["Hold",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hold"], "]"}], Cell[TextData[{
     "get a part of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", wrapping it with ",
     Cell[BoxData[
      ButtonBox["Hold",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
     " to prevent evaluation"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->5413],

Cell["Functions for handling unevaluated expressions. ", "Caption",
 CellID->16603],

Cell["\<\
Parts of expressions are usually evaluated as soon as you extract them. \
\>", "MathCaption",
 CellID->29591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Extract", "[", 
  RowBox[{
   RowBox[{"Hold", "[", 
    RowBox[{
     RowBox[{"1", "+", "1"}], ",", 
     RowBox[{"2", "+", "3"}]}], "]"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->17403],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->14964]
}, Open  ]],

Cell[TextData[{
 "This extracts a part and immediately wraps it with ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 ", so it does not get evaluated. "
}], "MathCaption",
 CellID->31695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Extract", "[", 
  RowBox[{
   RowBox[{"Hold", "[", 
    RowBox[{
     RowBox[{"1", "+", "1"}], ",", 
     RowBox[{"2", "+", "3"}]}], "]"}], ",", "2", ",", "Hold"}], 
  "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->30298],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"2", "+", "3"}], "]"}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->1042]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     ButtonBox["Unevaluated",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Unevaluated"], "[", 
     StyleBox["expr", "TI"], "]", ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " unevaluated as an argument to ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->28222],

Cell["Temporary prevention of argument evaluation. ", "Caption",
 CellID->30815],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"1", "+", "1"}]], "InlineFormula"],
 " evaluates to ",
 Cell[BoxData["2"], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Length",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Length"], "[", "2", "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"1", "+", "1"}], "]"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->21989],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->13770]
}, Open  ]],

Cell[TextData[{
 "This gives the unevaluated form ",
 Cell[BoxData[
  RowBox[{"1", "+", "1"}]], "InlineFormula"],
 " as the argument of ",
 Cell[BoxData[
  ButtonBox["Length",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Length"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14749],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"Unevaluated", "[", 
   RowBox[{"1", "+", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->9297],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->8091]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Unevaluated",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unevaluated"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " effectively works by temporarily giving a function an attribute like ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ", and then supplying ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as an argument to the function. "
}], "Text",
 CellID->25024],

Cell[BoxData[GridBox[{
   {
    ButtonBox["SequenceHold",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SequenceHold"], Cell[TextData[{
     "do not flatten out ",
     Cell[BoxData[
      ButtonBox["Sequence",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
     " objects that appear as arguments"
    }], "TableText"]},
   {
    ButtonBox["HoldAllComplete",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/HoldAllComplete"], Cell[
    "treat all arguments as completely inert", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3252],

Cell["Attributes for preventing other aspects of evaluation. ", "Caption",
 CellID->20321],

Cell[TextData[{
 "By setting the attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ", you can prevent ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from evaluating the arguments of a function. But even with this attribute \
set, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will still do some transformations on the arguments. By setting ",
 Cell[BoxData[
  ButtonBox["SequenceHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SequenceHold"]], "InlineFormula"],
 " you can prevent it from flattening out ",
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 " objects that appear in the arguments. And by setting ",
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 " you can also inhibit the stripping of ",
 Cell[BoxData[
  ButtonBox["Unevaluated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unevaluated"]], "InlineFormula"],
 ", and prevent ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from using any upvalues it finds associated with the arguments."
}], "Text",
 CellID->13740],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->305269606],

Cell[TextData[ButtonBox["Evaluation of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EvaluationOfExpressionsOverview"]], "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Non-Standard Evaluation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Evaluation of Expressions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/EvaluationOfExpressionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TheStandardEvaluationProcedure"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/EvaluationInPatternsRulesAndDefinitions"]}], "Text",
       FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 5.3857918}", "context" -> "", 
    "keywords" -> {
     "arguments", "assignments", "avoiding evaluation", "defer evaluation", 
      "do", "Evaluate", "evaluation", "extract", "forcing evaluation", "hold",
       "HoldAll", "HoldAllComplete", "HoldComplete", "HoldFirst", "HoldForm", 
      "HoldRest", "If", "inert forms", "inhibiting", "keep unevaluated", 
      "hold unevaluated", "Lookahead", "maintain unevaluated", "nounifying", 
      "overriding hold", "parts", "plot", "plots", "preventing evaluation", 
      "printing", "programs", "protecting against evaluation", "ReleaseHold", 
      "replacements", "ReplacePart", "sequence", "SequenceHold", 
      "symbolic manipulation", "unevaluated", "unevaluated expressions", 
      "Upvalues", "UpValuesHold", "wrappers"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "While most built-in Mathematica functions follow the standard evaluation \
procedure, some important ones do not. For example, most of the Mathematica \
functions associated with the construction and execution of programs use \
non-standard evaluation procedures. In typical cases, the functions either \
never evaluate some of their arguments, or do so in a special way under their \
own control. Some functions that use non-standard evaluation procedures. When \
you give a definition such as a=1, Mathematica does not evaluate the a that \
appears on the left-hand side. You can see that there would be trouble if the \
a was evaluated. The reason is that if you had previously set a=7, then \
evaluating a in the definition a=1 would put the definition into the \
nonsensical form 7=1. ", "synonyms" -> {"2.6.5"}, "title" -> 
    "Non-Standard Evaluation", "type" -> "Tutorial", "uri" -> 
    "tutorial/NonStandardEvaluation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.6.5"->{
  Cell[3613, 83, 93, 2, 70, "Title",
   CellTags->{"S2.6.5", "5.1"},
   CellID->7491]},
 "5.1"->{
  Cell[3613, 83, 93, 2, 70, "Title",
   CellTags->{"S2.6.5", "5.1"},
   CellID->7491]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.6.5", 35162, 1219},
 {"5.1", 35260, 1223}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2988, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3613, 83, 93, 2, 70, "Title",
 CellTags->{"S2.6.5", "5.1"},
 CellID->7491],
Cell[3709, 87, 545, 13, 70, "Text",
 CellID->28647],
Cell[4257, 102, 2500, 83, 70, "DefinitionBox",
 CellID->3617],
Cell[6760, 187, 109, 3, 70, "Caption",
 CellID->947],
Cell[6872, 192, 800, 25, 70, "Text",
 CellID->14889],
Cell[7675, 219, 737, 23, 70, "Text",
 CellID->31092],
Cell[8415, 244, 827, 24, 70, "DefinitionBox",
 CellID->23296],
Cell[9245, 270, 106, 3, 70, "Caption",
 CellID->16834],
Cell[9354, 275, 132, 4, 70, "MathCaption",
 CellID->28223],
Cell[CellGroupData[{
Cell[9511, 283, 165, 6, 70, "Input",
 CellID->32172],
Cell[9679, 291, 205, 7, 36, "Output",
 CellID->11048]
}, Open  ]],
Cell[9899, 301, 271, 10, 70, "MathCaption",
 CellID->23],
Cell[10173, 313, 137, 4, 70, "Input",
 CellID->22291],
Cell[10313, 319, 156, 5, 70, "MathCaption",
 CellID->18166],
Cell[CellGroupData[{
Cell[10494, 328, 165, 6, 70, "Input",
 CellID->30261],
Cell[10662, 336, 228, 8, 36, "Output",
 CellID->4981]
}, Open  ]],
Cell[10905, 347, 165, 5, 70, "MathCaption",
 CellID->941],
Cell[CellGroupData[{
Cell[11095, 356, 296, 11, 70, "Input",
 CellID->16461],
Cell[11394, 369, 156, 5, 36, "Output",
 CellID->29443]
}, Open  ]],
Cell[11565, 377, 354, 13, 70, "MathCaption",
 CellID->12245],
Cell[CellGroupData[{
Cell[11944, 394, 104, 3, 70, "Input",
 CellID->3696],
Cell[12051, 399, 241, 8, 36, "Output",
 CellID->14229]
}, Open  ]],
Cell[12307, 410, 485, 14, 70, "Text",
 CellID->8373],
Cell[12795, 426, 385, 12, 70, "MathCaption",
 CellID->23900],
Cell[CellGroupData[{
Cell[13205, 442, 201, 7, 70, "Input",
 CellID->3650],
Cell[13409, 451, 204, 7, 36, "Output",
 CellID->6703]
}, Open  ]],
Cell[13628, 461, 850, 25, 70, "DefinitionBox",
 CellID->24828],
Cell[14481, 488, 81, 1, 70, "Caption",
 CellID->14731],
Cell[14565, 491, 448, 11, 70, "Text",
 CellID->8941],
Cell[15016, 504, 350, 13, 70, "MathCaption",
 CellID->788],
Cell[CellGroupData[{
Cell[15391, 521, 89, 3, 70, "Input",
 CellID->23479],
Cell[15483, 526, 154, 5, 36, "Output",
 CellID->8073]
}, Open  ]],
Cell[15652, 534, 597, 22, 70, "MathCaption",
 CellID->19220],
Cell[CellGroupData[{
Cell[16274, 560, 122, 4, 70, "Input",
 CellID->737],
Cell[16399, 566, 154, 5, 36, "Output",
 CellID->3555]
}, Open  ]],
Cell[16568, 574, 158, 6, 70, "MathCaption",
 CellID->28814],
Cell[CellGroupData[{
Cell[16751, 584, 68, 2, 70, "Input",
 CellID->11431],
Cell[16822, 588, 156, 5, 36, "Output",
 CellID->16000]
}, Open  ]],
Cell[16993, 596, 476, 12, 70, "Text",
 CellID->7997],
Cell[17472, 610, 712, 21, 70, "Text",
 CellID->16411],
Cell[18187, 633, 923, 33, 70, "Text",
 CellID->17008],
Cell[19113, 668, 212, 7, 70, "MathCaption",
 CellID->16917],
Cell[CellGroupData[{
Cell[19350, 679, 121, 4, 70, "Input",
 CellID->20202],
Cell[19474, 685, 209, 7, 36, "Output",
 CellID->26128]
}, Open  ]],
Cell[19698, 695, 308, 10, 70, "MathCaption",
 CellID->1245],
Cell[CellGroupData[{
Cell[20031, 709, 125, 4, 70, "Input",
 CellID->25639],
Cell[20159, 715, 200, 8, 36, "Output",
 CellID->6629]
}, Open  ]],
Cell[20374, 726, 203, 7, 70, "MathCaption",
 CellID->10699],
Cell[CellGroupData[{
Cell[20602, 737, 101, 3, 70, "Input",
 CellID->8933],
Cell[20706, 742, 383, 14, 50, "Output",
 CellID->18596]
}, Open  ]],
Cell[21104, 759, 500, 18, 70, "MathCaption",
 CellID->16884],
Cell[CellGroupData[{
Cell[21629, 781, 105, 3, 70, "Input",
 CellID->32076],
Cell[21737, 786, 156, 5, 36, "Output",
 CellID->24729]
}, Open  ]],
Cell[21908, 794, 2884, 94, 70, "DefinitionBox",
 CellID->5413],
Cell[24795, 890, 83, 1, 70, "Caption",
 CellID->16603],
Cell[24881, 893, 119, 3, 70, "MathCaption",
 CellID->29591],
Cell[CellGroupData[{
Cell[25025, 900, 233, 8, 70, "Input",
 CellID->17403],
Cell[25261, 910, 156, 5, 36, "Output",
 CellID->14964]
}, Open  ]],
Cell[25432, 918, 253, 8, 70, "MathCaption",
 CellID->31695],
Cell[CellGroupData[{
Cell[25710, 930, 249, 9, 70, "Input",
 CellID->30298],
Cell[25962, 941, 208, 7, 36, "Output",
 CellID->1042]
}, Open  ]],
Cell[26185, 951, 885, 26, 70, "DefinitionBox",
 CellID->28222],
Cell[27073, 979, 80, 1, 70, "Caption",
 CellID->30815],
Cell[27156, 982, 381, 15, 70, "MathCaption",
 CellID->10860],
Cell[CellGroupData[{
Cell[27562, 1001, 123, 4, 70, "Input",
 CellID->21989],
Cell[27688, 1007, 156, 5, 36, "Output",
 CellID->13770]
}, Open  ]],
Cell[27859, 1015, 294, 11, 70, "MathCaption",
 CellID->14749],
Cell[CellGroupData[{
Cell[28178, 1030, 161, 5, 70, "Input",
 CellID->9297],
Cell[28342, 1037, 155, 5, 36, "Output",
 CellID->8091]
}, Open  ]],
Cell[28512, 1045, 541, 17, 70, "Text",
 CellID->25024],
Cell[29056, 1064, 859, 25, 70, "DefinitionBox",
 CellID->3252],
Cell[29918, 1091, 90, 1, 70, "Caption",
 CellID->20321],
Cell[30011, 1094, 1256, 38, 70, "Text",
 CellID->13740],
Cell[CellGroupData[{
Cell[31292, 1136, 72, 1, 70, "RelatedTutorialsSection",
 CellID->305269606],
Cell[31367, 1139, 180, 4, 70, "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],
Cell[31574, 1147, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

