(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15760,        496]
NotebookOptionsPosition[     11851,        382]
NotebookOutlinePosition[     14558,        451]
CellTagsIndexPosition[     14467,        445]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Running Mathematica" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/RunningMathematicaOverview"]}, #, 2]& , Evaluator -> 
       Automatic], {
      1->"\<\"Running Mathematica\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Notebook Interfaces", "Title",
 CellTags->{"S1.0.1", "1.1"},
 CellID->19713],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "use an icon or the ",
     StyleBox["Start", "SR"],
     " menu"
    }], "TableText"], Cell[TextData[{
     "graphical ways to start ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]},
   {"mathematica", Cell[TextData[{
     "the shell command to start ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]},
   {Cell[TextData[{
     "text ending with ",
     StyleBox["Shift", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Enter", "KeyEvent"]
    }], "TableText"], Cell[TextData[{
     "input for ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " (",
     StyleBox["Shift", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Return", "KeyEvent"],
     " on some keyboards)"
    }], "TableText"]},
   {Cell[TextData[{
     "choose the ",
     StyleBox["Exit", "MenuName"],
     " menu item"
    }], "TableText"], Cell[TextData[{
     "exiting ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " (",
     StyleBox["Quit", "MenuName"],
     " on some systems)"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->26835],

Cell[TextData[{
 "Running ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with a notebook interface. "
}], "Caption",
 CellID->28316],

Cell[TextData[{
 "In a \[OpenCurlyDoubleQuote]notebook\[CloseCurlyDoubleQuote] interface, you \
interact with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by creating interactive documents."
}], "Text",
 CellID->5489],

Cell[TextData[{
 "If you use your computer via a purely graphical interface, you will \
typically double\[Hyphen]click the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " icon to start ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". If you use your computer via a textually based operating system, you will \
typically type the command ",
 Cell[BoxData["mathematica"], "InlineFormula"],
 " to start ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 GeneratedCell->False,
 CellID->27796],

Cell[TextData[{
 "When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " starts up, it usually gives you a blank notebook. You enter ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input into the notebook, then type ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 " to make ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " process your input. (To type ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 ", hold down the ",
 StyleBox["Shift", "KeyEvent"],
 " key, then press ",
 StyleBox["Enter", "KeyEvent"],
 ".) You can use the standard editing features of your graphical interface to \
prepare your input, which may go on for several lines. ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 " tells ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that you have finished your input. If your keyboard has a numeric keypad, \
you can use its ",
 StyleBox["Enter", "KeyEvent"],
 " key instead of ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 "."
}], "Text",
 GeneratedCell->False,
 CellID->26548],

Cell[TextData[{
 "After you send ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input from your notebook, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will label your input with ",
 StyleBox["In[", "MB"],
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 StyleBox["]:=", "MB"],
 ". It labels the corresponding output ",
 StyleBox["Out[", "MB"],
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 StyleBox["]=", "MB"],
 "."
}], "Text",
 GeneratedCell->False,
 CellID->2664],

Cell[TextData[{
 "You type ",
 Cell[BoxData[
  RowBox[{"2", "+", "2"}]], "InlineFormula"],
 ", then end your input with ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " processes the input, then adds the input label ",
 StyleBox["In[1]:=", "MB"],
 ", and gives the output."
}], "MathCaption",
 GeneratedCell->False,
 CellID->25858],

Cell[CellGroupData[{

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWE1oE0EUnvyu0VRrRLzkkNBTLqbm4imHXrQUFCyCUIuwhJb2YCO1h9Br
6SV60kPJxZZg0So55hShIIJnIy2INmCjkhJIE4MVQsNz5u1Mko2bbdhsbevA
zs7Mm/feN9+8+WFuyHNTE/fluemI7Ls+Kz+Ymo489F2LztImm4UQ60VCyFUf
YWWgRZ410yWWEWJTaiij2QWWWXiLrSEiQq7XKZfLUXkqlcLsLMus2GjDRmFH
KDqajmmi/WBzc5MoJZadQV07axVSSKfTVm3n7NfU7dfxq9axKjoiuVmmh9qp
Qi2w4aAFPadRwd4YFu+gA7zdoTIYkSSsO9qpYr2JqUbZRxk216gmUqkji+oo
PdUB5aEM3VSjLWP6B0iPHZ98sR7zSTpZfP7f673CbSWW38P4xCp+Y5HnsPjo
DTlvMs1lbq9c+Q0/ChX8vm6XYPTuium+qli0QWHnJx3PKtb623z0sFlc5uY3
NjbA6XQin2iCtkmSBPV6nTtT+oXDYSgUClizd6mLINa6GIfB9RREoQS1Wg3x
2e12WFhYgKWlJejr62PtyrlL3Xs8Hsjn8y349fXQ4atesB88B0ERTuUyhEIh
8Pv9sLW1xfjjvDtgZmYGRkZGwOFwwNDQECs3ZFp66PR1l7gN7raDnMVisQiB
QAD9l0olASuZTEI8HgeXywXz8/OszKfhLxUV2k+fd2B0fAVKu7/MZPkKN88Y
crvdIMuyEldtUSFp9FNFwYeP3+HW2DLcvpfsfrXrR/AgN5PNZsWqgeHhYfB6
vQ080WhUUNWYea3+WFnjPDOsjMv1t19YBJi4OYmgDQaDMDAwgEHJFv3k5CQ5
pyNDwy95BwGP/XmQalJq8PgSGKvVKiQSCYjFYpDJZGB/f7+BUUuGhl9gB6cK
I0scZycqjR6IJT7N29924WniHTx+sk4701OMtt288wzPM9BZv72cma3nGPv2
9mqmn2OYjvbqrGakZeM7qlvZCb86a/Np+i2XT9BRoDzh1+ZDmXX1C0Yrn0oj
MfyC0Xz8caNbW7cXWyMPN8Z0RFJ2YXVsHvTs5WGZVZE1LfF3NGL5A2p3YZY=
\
\>"], "Picture",
 ImageSize->{533, 55},
 ImageMargins->0,
 CellID->20543],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 70},
 ImageMargins->0,
 CellID->5081]
}, Open  ]],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " reference documents, \
\[OpenCurlyDoubleQuote]dialogs\[CloseCurlyDoubleQuote] with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are shown in the following way:"
}], "Text",
 GeneratedCell->False,
 CellID->5580],

Cell[TextData[{
 "With a notebook interface, you just type in ",
 Cell[BoxData[
  RowBox[{"2", "+", "2"}]], "InlineFormula"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " then adds the label ",
 StyleBox["In[1]:=", "MB"],
 ", and prints the result."
}], "MathCaption",
 GeneratedCell->False,
 CellID->21407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "+", "2"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->4436],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->27670]
}, Open  ]],

Cell[TextData[{
 "You should realize that notebooks are part of the \
\[OpenCurlyDoubleQuote]front end\[CloseCurlyDoubleQuote] to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel which actually performs computations may be run either on the same \
computer as the front end, or on another computer connected via a network. \
Sometimes, the kernel is not even started until you actually do a calculation \
with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 GeneratedCell->False,
 CellID->22863],

Cell[TextData[{
 "To exit ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you typically choose the ",
 StyleBox[ButtonBox["Exit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Exit"], "MenuName"],
 " menu item in the notebook interface."
}], "Text",
 GeneratedCell->False,
 CellID->9166],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->154371671],

Cell[TextData[{
 ButtonBox["Running ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/RunningMathematicaOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/RunningMathematicaOverview"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->108503]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Notebook Interfaces - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Running Mathematica", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/RunningMathematicaOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TextBasedInterfaces"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 6.4951952}", "context" -> "", 
    "keywords" -> {
     "calculations", "entering input", "front end", 
      "graphical user interfaces", "icon Mathematica", "input", "interface", 
      "kernel", "modem", "networks", "notebook interface", "notebooks", 
      "numeric keypad", "serial lines", "terminating input", 
      "user interface"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Running Mathematica with a notebook interface. In a 'notebook' \
interface, you interact with Mathematica by creating interactive documents. \
If you use your computer via a purely graphical interface, you will typically \
double-click the Mathematica icon to start Mathematica. If you use your \
computer via a textually based operating system, you will typically type the \
command mathematica to start Mathematica.", "synonyms" -> {"1.0.1"}, "title" -> 
    "Notebook Interfaces", "type" -> "Tutorial", "uri" -> 
    "tutorial/NotebookInterfaces"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.0.1"->{
  Cell[1257, 43, 82, 2, 70, "Title",
   CellTags->{"S1.0.1", "1.1"},
   CellID->19713]},
 "1.1"->{
  Cell[1257, 43, 82, 2, 70, "Title",
   CellTags->{"S1.0.1", "1.1"},
   CellID->19713]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.0.1", 14256, 434},
 {"1.1", 14355, 438}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 632, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1257, 43, 82, 2, 70, "Title",
 CellTags->{"S1.0.1", "1.1"},
 CellID->19713],
Cell[1342, 47, 1362, 47, 70, "DefinitionBox",
 CellID->26835],
Cell[2707, 96, 140, 6, 70, "Caption",
 CellID->28316],
Cell[2850, 104, 227, 7, 70, "Text",
 CellID->5489],
Cell[3080, 113, 521, 17, 70, "Text",
 CellID->27796],
Cell[3604, 132, 1245, 40, 70, "Text",
 CellID->26548],
Cell[4852, 174, 505, 20, 70, "Text",
 CellID->2664],
Cell[5360, 196, 445, 16, 70, "MathCaption",
 CellID->25858],
Cell[CellGroupData[{
Cell[5830, 216, 1216, 23, 70, "Picture",
 CellID->20543],
Cell[7049, 241, 2528, 44, 70, "Picture",
 CellID->5081]
}, Open  ]],
Cell[9592, 288, 296, 11, 70, "Text",
 CellID->5580],
Cell[9891, 301, 321, 12, 70, "MathCaption",
 CellID->21407],
Cell[CellGroupData[{
Cell[10237, 317, 88, 3, 70, "Input",
 CellID->4436],
Cell[10328, 322, 155, 5, 36, "Output",
 CellID->27670]
}, Open  ]],
Cell[10498, 330, 590, 17, 70, "Text",
 CellID->22863],
Cell[11091, 349, 305, 11, 70, "Text",
 CellID->9166],
Cell[CellGroupData[{
Cell[11421, 364, 72, 1, 70, "RelatedTutorialsSection",
 CellID->154371671],
Cell[11496, 367, 301, 9, 70, "RelatedTutorials",
 CellID->108503]
}, Open  ]]
}, Open  ]],
Cell[11824, 380, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

