(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    155593,       3039]
NotebookOptionsPosition[    148858,       2839]
NotebookOutlinePosition[    151597,       2896]
CellTagsIndexPosition[    151554,       2893]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Automatic" :> Documentation`HelpLookup["paclet:ref/Automatic"], 
         "False" :> Documentation`HelpLookup["paclet:ref/False"], "True" :> 
         Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Automatic\"\>", 2->"\<\"False\"\>", 
      3->"\<\"True\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Notebook Security", "Title",
 CellID->509267359],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides users with access to their computer's file system (",
 ButtonBox["Files",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Files"],
 "), interprocess communication (",
 StyleBox[ButtonBox["MathLink Mathematica Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"],
  FontSlant->"Italic"],
 "), evaluation of data as code (",
 ButtonBox["Converting Between Expressions And Strings",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ConvertingBetweenExpressionsAndStrings"],
 "), and the ability to run arbitrary external programs (",
 ButtonBox["Calling External Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/CallingExternalPrograms"],
 ").",
 " ",
 "While these features enable ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " users to create powerful programs that can perform truly useful tasks, \
they bring with them the potential for misuse."
}], "Text",
 CellID->2039256797],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Notebook Front End provides three mechanisms for evaluating code,",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["Shift", "KeyEvent"], 
    StyleBox["+", "KeyEventDelimiter"], 
    DynamicBox[ToBoxes[
      If[$OperatingSystem === "MacOSX", "Return", "Enter"], StandardForm],
     ImageSizeCache->{36., {0., 8.}}]}], TraditionalForm]], "KeyEvent",
  ShowStringCharacters->False],
 " evaluations, initialization cells, and dynamic content."
}], "Text",
 CellID->2141780261],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["Shift", "KeyEvent"], 
    StyleBox["+", "KeyEventDelimiter"], 
    DynamicBox[ToBoxes[
      If[$OperatingSystem === "MacOSX", "Return", "Enter"], StandardForm],
     ImageSizeCache->{36., {0., 8.}}]}], TraditionalForm]], "KeyEvent",
  ShowStringCharacters->False],
 " evaluations"
}], "Section",
 CellID->779955613],

Cell[TextData[{
 "Because ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["Shift", "KeyEvent"], 
    StyleBox["+", "KeyEventDelimiter"], 
    DynamicBox[ToBoxes[
      If[$OperatingSystem === "MacOSX", "Return", "Enter"], StandardForm],
     ImageSizeCache->{36., {0., 8.}}]}], TraditionalForm]], "KeyEvent",
  ShowStringCharacters->False],
 " evaluations require user interaction to start them, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides no safeguards against potentially malicious code that is \
evaluated using this mechanism. Users should ensure that they do not perform \
",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["Shift", "KeyEvent"], 
    StyleBox["+", "KeyEventDelimiter"], 
    DynamicBox[ToBoxes[
      If[$OperatingSystem === "MacOSX", "Return", "Enter"], StandardForm],
     ImageSizeCache->{36., {0., 8.}}]}], TraditionalForm]], "KeyEvent",
  ShowStringCharacters->False],
 " evaluations on code from untrusted sources. When writing their own code, \
users should take great care to ensure that the code does not have unintended \
consequences.",
 " ",
 "For example, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will not provide a warning when the user evaluates a program to delete \
files from his or her computer."
}], "Text",
 CellID->394852145]
}, Open  ]],

Cell[CellGroupData[{

Cell["Initialization cells", "Section",
 CellID->893600606],

Cell[TextData[{
 "Initialization cells provide users with a convenient way to evaluate \
startup code needed by a given notebook when the user first evaluates any \
input in that notebook. Since this code will be automatically evaluated, \
likely without the user ever seeing the initialization code, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will display an alert prompt asking the user to confirm his or her intent \
to run the initialization code.",
 " ",
 "Users should not evaluate initialization code in a notebook that was \
obtained from an untrusted source unless the code has been determined to be \
safe."
}], "Text",
 CellID->555531785],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
 Evaluatable->False,
 ImageSize->{474, 132},
 ImageMargins->0,
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->410078591],

Cell["\<\
\[Bullet] Pressing the Yes button will first evaluate all of the \
initialization cells in the notebook, then evaluate the selected cells.\
\>", "Text",
 CellID->915855714],

Cell["\<\
\[Bullet]\[NonBreakingSpace]Pressing the No button will not evaluate any of \
the initialization cells, but will still evaluate the selected cells. Note \
that this may cause errors in the evaluations since they may rely on startup \
code which has not yet been evaluated.\
\>", "Text",
 CellID->1771687149],

Cell["\<\
\[Bullet]\[NonBreakingSpace]Pressing the Cancel button will cause neither the \
initialization cells nor the selected cells to be evaluated.\
\>", "Text",
 CellID->1885147588]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dynamic content", "Section",
 CellID->1392241571],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 has amazing ",
 ButtonBox["dynamic interactivity features",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DynamicInteractivityOverview"],
 ". Notebooks containing interactive ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " content can automatically evaluate code without any additional action by \
the user, aside from opening the notebook file.",
 " ",
 "Many times this is exactly what the user will want, while other times the \
user should be alerted before this sort of automatic evaluation takes place."
}], "Text",
 CellID->1849267325],

Cell[TextData[{
 "When the user opens a notebook containing dynamic content, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will first determine whether the notebook's directory is trusted, \
untrusted, or neither."
}], "Text",
 CellID->1586652440],

Cell["\<\
\[Bullet] If the notebook's directory is trusted, the notebook will be \
allowed to automatically perform dynamic evaluations without alerting the \
user.\
\>", "Text",
 CellID->412483461],

Cell["\<\
\[Bullet] If the notebook's directory is untrusted, the user will be alerted \
upon any attempt by the notebook to perform dynamic evaluations.\
\>", "Text",
 CellID->532316511],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
 Evaluatable->False,
 ImageSize->{512, 226},
 ImageMargins->0,
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->1481302929],

Cell[TextData[{
 "\[Bullet] If the notebook's directory is neither trusted nor untrusted the \
behavior will depend on the value of the ",
 Cell[BoxData["TrustByDefault"], "InlineFormula"],
 " option explained below."
}], "Text",
 CellID->226726975],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides some options which can be used to configure which notebooks will \
alert the user about automatic evaluations and which notebooks will not."
}], "Text",
 CellID->1726342667],

Cell[CellGroupData[{

Cell["TrustedPath", "Subsection",
 CellID->1322699074],

Cell[TextData[{
 "The value of the ",
 Cell[BoxData["TrustedPath"], "InlineFormula"],
 " option is a list of directories that are always trusted by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Any notebook file located in any directory in ",
 Cell[BoxData["TrustedPath"], "InlineFormula"],
 " is trusted by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ".",
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will never display an alert when a trusted notebook is opened, and the \
notebook can automatically perform dynamic evaluations."
}], "Text",
 CellID->1563114281],

Cell[TextData[{
 "By default, the ",
 Cell[BoxData["TrustedPath"], "InlineFormula"],
 " option value contains ",
 Cell[BoxData[
  ButtonBox["$InstallationDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 " so that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " installation files and additional installed applications will be able to \
display dynamic content without alerting the user."
}], "Text",
 CellID->636909397],

Cell[TextData[{
 "Here are the directories on your computer which are currently trusted by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "Text",
 CellID->1978993237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"Column", "[", 
   RowBox[{"ToFileName", "/@", 
    RowBox[{"CurrentValue", "[", 
     RowBox[{"$FrontEnd", ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<NotebookSecurityOptions\>\"", ",", "\"\<TrustedPath\>\""}], 
       "}"}]}], "]"}]}], "]"}], "]"}]], "Input",
 CellID->1686041404],

Cell[BoxData[
 DynamicBox[ToBoxes[
   Column[
    Map[ToFileName, 
     CurrentValue[$FrontEnd, {"NotebookSecurityOptions", "TrustedPath"}]]], 
   StandardForm],
  ImageSizeCache->{315., {17.5, 22.5}}]], "Output",
 ImageSize->{319, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->1940758337]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\<\"Edit TrustedPath...\"\>",
   Appearance->Automatic,
   ButtonData->"paclet:ref/Edit TrustedPath...",
   ButtonFrame->"DialogBox",
   ButtonFunction:>
    FEPrivate`OptionDialog[$FrontEnd, {
     "NotebookSecurityOptions", "TrustedPath"}],
   Evaluator->Automatic,
   Method->"Preemptive"]], "Text"],
 " "
}], "Text",
 CellID->998959467]
}, Open  ]],

Cell[CellGroupData[{

Cell["UntrustedPath", "Subsection",
 CellID->2000106621],

Cell[TextData[{
 "The value of the ",
 Cell[BoxData["UntrustedPath"], "InlineFormula"],
 " option is a list of directories that are always untrusted by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Any notebook file located in any directory in ",
 Cell[BoxData["UntrustedPath"], "InlineFormula"],
 " is untrusted by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ".",
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will always display an alert when an untrusted notebook is opened and \
attempts to perform dynamic evaluations. "
}], "Text",
 CellID->2137133299],

Cell[TextData[{
 "By default, the ",
 Cell[BoxData["UntrustedPath"], "InlineFormula"],
 " option value contains the user's desktop folder (where web browser \
downloads are likely to be stored), the user's configuration folder (where \
email attachments are likely to be stored), and the computer's temporary \
directory.",
 " ",
 "If the user has configured his or her web browser or email program to save \
downloaded files in non-standard locations then the user is encouraged to add \
these locations to the ",
 Cell[BoxData["UntrustedPath"], "InlineFormula"],
 " option value."
}], "Text",
 CellID->1477738731],

Cell[TextData[{
 "Here are the directories on your computer which are currently untrusted by \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "Text",
 CellID->712609523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"Column", "[", 
   RowBox[{"ToFileName", "/@", 
    RowBox[{"CurrentValue", "[", 
     RowBox[{"$FrontEnd", ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<NotebookSecurityOptions\>\"", ",", "\"\<UntrustedPath\>\""}], 
       "}"}]}], "]"}]}], "]"}], "]"}]], "Input",
 CellID->196255676],

Cell[BoxData[
 DynamicBox[ToBoxes[
   Column[
    Map[ToFileName, 
     CurrentValue[$FrontEnd, {"NotebookSecurityOptions", "UntrustedPath"}]]], 
   StandardForm],
  ImageSizeCache->{469., {25., 30.}}]], "Output",
 ImageSize->{473, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->2081748387]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\<\"Edit UntrustedPath...\"\>",
   Appearance->Automatic,
   ButtonData->"paclet:ref/Edit UntrustedPath...",
   ButtonFrame->"DialogBox",
   ButtonFunction:>
    FEPrivate`OptionDialog[$FrontEnd, {
     "NotebookSecurityOptions", "UntrustedPath"}],
   Evaluator->Automatic,
   Method->"Preemptive"]], "Text"],
 " "
}], "Text",
 CellID->484609623]
}, Open  ]],

Cell[CellGroupData[{

Cell["Nesting", "Subsection",
 CellID->1094267016],

Cell[TextData[{
 "Directories in ",
 Cell[BoxData["TrustedPath"], "InlineFormula"],
 " and ",
 Cell[BoxData["UntrustedPath"], "InlineFormula"],
 " can be nested. A notebook is trusted if the most deeply nested directory \
containing the notebook is trusted.",
 " ",
 "Consider the following example:"
}], "Text",
 CellID->853307001],

Cell[TextData[{
 "\[Bullet]\[NonBreakingSpace]",
 StyleBox["FrontEnd`FileName[{$HomeDirectory, \"Desktop\"}]", "InlineCode"],
 " is untrusted."
}], "Text",
 CellID->1317216306],

Cell[TextData[{
 "\[Bullet]\[NonBreakingSpace]",
 StyleBox["FrontEnd`FileName[{$HomeDirectory, \"Desktop\", \
\"SafeNotebooks\"}]", "InlineCode"],
 " is trusted."
}], "Text",
 CellID->45538019],

Cell[TextData[{
 "\[Bullet]\[NonBreakingSpace]",
 StyleBox["FrontEnd`FileName[{$HomeDirectory, \"Desktop\"}, \"SomeDownload.nb\
\"]", "InlineCode"],
 " would be untrusted because \"Desktop\" is untrusted."
}], "Text",
 CellID->634971141],

Cell[TextData[{
 "\[Bullet]\[NonBreakingSpace]",
 StyleBox["FrontEnd`FileName[{$HomeDirectory, \"Desktop\", \
\"SafeNotebooks\"}, \"MyNotebook.nb\"]", "InlineCode"],
 " would be trusted because \"SafeNotebooks\" is trusted."
}], "Text",
 CellID->1113724844]
}, Open  ]],

Cell[CellGroupData[{

Cell["TrustByDefault", "Subsection",
 CellID->1230452656],

Cell[TextData[{
 "The ",
 Cell[BoxData["TrustByDefault"], "InlineFormula"],
 " option determines whether ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " should display an alert when the user opens notebooks with dynamic content \
whose containing directories are neither trusted nor untrusted.",
 " ",
 "Below are the possible values for the ",
 Cell[BoxData["TrustByDefault"], "InlineFormula"],
 " option."
}], "Text",
 CellID->480408032],

Cell[BoxData[GridBox[{
   {
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "A notebook which is not located in a directory in ",
     Cell[BoxData["UntrustedPath"], "InlineFormula"],
     " is considered to be trusted and will not display an alert when \
opened."
    }], "TableText"]},
   {
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "A notebook which is not located in a direcotry in ",
     Cell[BoxData["TrustedPath"], "InlineFormula"],
     " is considered to be untrusted and will display an alert when opened."
    }], "TableText"]},
   {
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "A notebook which is not located in any directory in either ",
     Cell[BoxData["TrustedPath"], "InlineFormula"],
     " or ",
     Cell[BoxData["UntrustedPath"], "InlineFormula"],
     " will display an alert when opened only if the notebook contains unsafe \
dynamic content (see below)."
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->1980653508],

Cell[TextData[{
 "Values for ",
 Cell[BoxData["TrustByDefault"], "InlineFormula"],
 " option."
}], "Caption",
 CellID->699496809],

Cell[TextData[{
 "The current value of the ",
 Cell[BoxData["TrustByDefault"], "InlineFormula"],
 " option is: ",
 Cell[BoxData[
  PopupMenuBox[Dynamic[
    CurrentValue[$FrontEnd, {"NotebookSecurityOptions", "TrustByDefault"}]], {
   Automatic->"Automatic", True->"True", False->"False"},
   FieldSize->{{1, 30}, 1}]], "Text"]
}], "Text",
 CellID->311953742]
}, Open  ]],

Cell[CellGroupData[{

Cell["Unsafe dynamic content", "Subsection",
 CellID->1670172987],

Cell["Dynamic content is considered unsafe if it:", "Text",
 CellID->838642572],

Cell[TextData[{
 "\[Bullet] uses ",
 ButtonBox["File",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Files"],
 " operations"
}], "Text",
 CellID->1130532343],

Cell[TextData[{
 "\[Bullet] uses interprocess communication via ",
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"]
}], "Text",
 CellID->2069263792],

Cell[TextData[{
 "\[Bullet]\[NonBreakingSpace]uses ",
 Cell[BoxData[
  ButtonBox["JLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/guide/JavaInterface"]], "Text"],
 " or ",
 Cell[BoxData[
  ButtonBox["NETLink",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/guide/DotNetInterface"]], "Text"]
}], "Text",
 CellID->1766372626],

Cell[TextData[{
 "\[Bullet] uses ",
 ButtonBox["Low-Level Notebook Programming",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelNotebookProgramming"]
}], "Text",
 CellID->559797918],

Cell[TextData[{
 "\[Bullet]\[NonBreakingSpace]uses data as code by ",
 ButtonBox["Converting Between Expressions And Strings",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ConvertingBetweenExpressionsAndStrings"]
}], "Text",
 CellID->397750319],

Cell[TextData[{
 "\[Bullet] uses ",
 ButtonBox["Namespace Management",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NamespaceManagement"]
}], "Text",
 CellID->2021152008],

Cell[TextData[{
 "\[Bullet] uses ",
 ButtonBox["Options Management",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/OptionsManagement"]
}], "Text",
 CellID->1360299984],

Cell[TextData[{
 "\[Bullet] uses ",
 ButtonBox["External Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/CallingExternalPrograms"]
}], "Text",
 CellID->605470210]
}, Open  ]],

Cell[CellGroupData[{

Cell["Changing option values", "Subsection",
 CellID->2020501969],

Cell[TextData[{
 Cell[BoxData["TrustedPath"], "InlineFormula"],
 ", ",
 Cell[BoxData["UntrustedPath"], "InlineFormula"],
 ", and ",
 Cell[BoxData["TrustByDefault"], "InlineFormula"],
 " are options in the ",
 Cell[BoxData["NotebookSecurityOptions"], "InlineFormula",
  ShowStringCharacters->False],
 " category.",
 " ",
 "They can be changed using the ",
 Cell[BoxData[
  ButtonBox["\<\"Preferences...\"\>",
   Appearance->Automatic,
   ButtonData->"paclet:ref/Preferences...",
   ButtonFrame->"DialogBox",
   ButtonFunction:>(
    SetOptions[$FrontEnd, "PreferencesSettings" -> {"Page" -> "System"}]; 
    FrontEndTokenExecute["PreferencesDialog"]),
   Evaluator->Automatic,
   Method->"Preemptive"]]],
 " dialog or the ",
 Cell[BoxData[
  ButtonBox["\<\"Option Inspector...\"\>",
   Appearance->Automatic,
   ButtonData->"paclet:ref/Option Inspector...",
   ButtonFrame->"DialogBox",
   ButtonFunction:>FrontEndTokenExecute["OptionsDialog", "NotebookSecurity"],
   Evaluator->Automatic,
   Method->"Preemptive"]]],
 "."
}], "Text",
 CellID->417682972],

Cell[TextData[{
 "Any attempt to change the value of the ",
 Cell[BoxData["TrustedPath"], "InlineFormula"],
 ", ",
 Cell[BoxData["UntrustedPath"], "InlineFormula"],
 ", or ",
 Cell[BoxData["TrustByDefault"], "InlineFormula"],
 " options will cause ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to prompt the user to confirm the change. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does this as a security precaution so that malicious code cannot change \
the value of these options without the user's knowledge."
}], "Text",
 CellID->2135360218],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
 Evaluatable->False,
 ImageSize->{474, 262},
 ImageMargins->0,
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->2071525609]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Notebook Security - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 8.4639956}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica provides users with access to their computer's file system \
(Files), interprocess communication (MathLink Mathematica Functions), \
evaluation of data as code (Converting Between Expressions And Strings), and \
the ability to run arbitrary external programs (Calling External Programs). \
While these features enable Mathematica users to create powerful programs \
that can perform truly useful tasks, they bring with them the potential for \
misuse. The Mathematica Notebook Front End provides three mechanisms for \
evaluating code, Shift+DynamicBox[ToBoxes[If[$OperatingSystem === MacOSX, \
Return, Enter], StandardForm], ImageSizeCache -> {38., {1., 8.}}] \
evaluations, initialization cells, and dynamic content. Because \
Shift+DynamicBox[ToBoxes[If[$OperatingSystem === MacOSX, Return, Enter], \
StandardForm], ImageSizeCache -> {38., {1., 8.}}] evaluations require user \
interaction to start them, Mathematica provides no safeguards against \
potentially malicious code that is evaluated using this mechanism. Users \
should ensure that they do not perform \
Shift+DynamicBox[ToBoxes[If[$OperatingSystem === MacOSX, Return, Enter], \
StandardForm], ImageSizeCache -> {38., {1., 8.}}] evaluations on code from \
untrusted sources. When writing their own code, users should take great care \
to ensure that the code does not have unintended consequences. For example, \
Mathematica will not provide a warning when the user evaluates a program to \
delete files from his or her computer.", "synonyms" -> {}, "title" -> 
    "Notebook Security", "type" -> "Tutorial", "uri" -> 
    "tutorial/NotebookSecurity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 724, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1349, 43, 54, 1, 70, "Title",
 CellID->509267359],
Cell[1406, 46, 1015, 28, 70, "Text",
 CellID->2039256797],
Cell[2424, 76, 561, 17, 70, "Text",
 CellID->2141780261],
Cell[CellGroupData[{
Cell[3010, 97, 384, 12, 70, "Section",
 CellID->779955613],
Cell[3397, 111, 1312, 36, 70, "Text",
 CellID->394852145]
}, Open  ]],
Cell[CellGroupData[{
Cell[4746, 152, 59, 1, 70, "Section",
 CellID->893600606],
Cell[4808, 155, 661, 14, 70, "Text",
 CellID->555531785],
Cell[5472, 171, 28513, 471, 70, "Graphics",
 Evaluatable->False,
 CellID->410078591],
Cell[33988, 644, 182, 4, 70, "Text",
 CellID->915855714],
Cell[34173, 650, 317, 6, 70, "Text",
 CellID->1771687149],
Cell[34493, 658, 185, 4, 70, "Text",
 CellID->1885147588]
}, Open  ]],
Cell[CellGroupData[{
Cell[34715, 667, 55, 1, 70, "Section",
 CellID->1392241571],
Cell[34773, 670, 690, 18, 70, "Text",
 CellID->1849267325],
Cell[35466, 690, 256, 7, 70, "Text",
 CellID->1586652440],
Cell[35725, 699, 198, 5, 70, "Text",
 CellID->412483461],
Cell[35926, 706, 187, 4, 70, "Text",
 CellID->532316511],
Cell[36116, 712, 49563, 816, 70, "Graphics",
 Evaluatable->False,
 CellID->1481302929],
Cell[85682, 1530, 249, 6, 70, "Text",
 CellID->226726975],
Cell[85934, 1538, 250, 6, 70, "Text",
 CellID->1726342667],
Cell[CellGroupData[{
Cell[86209, 1548, 54, 1, 70, "Subsection",
 CellID->1322699074],
Cell[86266, 1551, 596, 18, 70, "Text",
 CellID->1563114281],
Cell[86865, 1571, 772, 24, 70, "Text",
 CellID->636909397],
Cell[87640, 1597, 180, 6, 70, "Text",
 CellID->1978993237],
Cell[CellGroupData[{
Cell[87845, 1607, 342, 10, 70, "Input",
 CellID->1686041404],
Cell[88190, 1619, 322, 10, 70, "Output",
 CellID->1940758337]
}, Open  ]],
Cell[88527, 1632, 384, 13, 70, "Text",
 CellID->998959467]
}, Open  ]],
Cell[CellGroupData[{
Cell[88948, 1650, 56, 1, 70, "Subsection",
 CellID->2000106621],
Cell[89007, 1653, 589, 18, 70, "Text",
 CellID->2137133299],
Cell[89599, 1673, 615, 14, 70, "Text",
 CellID->1477738731],
Cell[90217, 1689, 183, 7, 70, "Text",
 CellID->712609523],
Cell[CellGroupData[{
Cell[90425, 1700, 343, 10, 70, "Input",
 CellID->196255676],
Cell[90771, 1712, 322, 10, 70, "Output",
 CellID->2081748387]
}, Open  ]],
Cell[91108, 1725, 390, 13, 70, "Text",
 CellID->484609623]
}, Open  ]],
Cell[CellGroupData[{
Cell[91535, 1743, 50, 1, 70, "Subsection",
 CellID->1094267016],
Cell[91588, 1746, 332, 10, 70, "Text",
 CellID->853307001],
Cell[91923, 1758, 176, 5, 70, "Text",
 CellID->1317216306],
Cell[92102, 1765, 193, 6, 70, "Text",
 CellID->45538019],
Cell[92298, 1773, 237, 6, 70, "Text",
 CellID->634971141],
Cell[92538, 1781, 257, 6, 70, "Text",
 CellID->1113724844]
}, Open  ]],
Cell[CellGroupData[{
Cell[92832, 1792, 57, 1, 70, "Subsection",
 CellID->1230452656],
Cell[92892, 1795, 446, 13, 70, "Text",
 CellID->480408032],
Cell[93341, 1810, 1138, 30, 70, "DefinitionBox",
 CellID->1980653508],
Cell[94482, 1842, 129, 5, 70, "Caption",
 CellID->699496809],
Cell[94614, 1849, 359, 10, 70, "Text",
 CellID->311953742]
}, Open  ]],
Cell[CellGroupData[{
Cell[95010, 1864, 65, 1, 70, "Subsection",
 CellID->1670172987],
Cell[95078, 1867, 79, 1, 70, "Text",
 CellID->838642572],
Cell[95160, 1870, 160, 7, 70, "Text",
 CellID->1130532343],
Cell[95323, 1879, 578, 17, 70, "Text",
 CellID->2069263792],
Cell[95904, 1898, 340, 12, 70, "Text",
 CellID->1766372626],
Cell[96247, 1912, 191, 6, 70, "Text",
 CellID->559797918],
Cell[96441, 1920, 248, 6, 70, "Text",
 CellID->397750319],
Cell[96692, 1928, 174, 6, 70, "Text",
 CellID->2021152008],
Cell[96869, 1936, 170, 6, 70, "Text",
 CellID->1360299984],
Cell[97042, 1944, 174, 6, 70, "Text",
 CellID->605470210]
}, Open  ]],
Cell[CellGroupData[{
Cell[97253, 1955, 65, 1, 70, "Subsection",
 CellID->2020501969],
Cell[97321, 1958, 1053, 33, 70, "Text",
 CellID->417682972],
Cell[98377, 1993, 564, 16, 70, "Text",
 CellID->2135360218],
Cell[98944, 2011, 49848, 821, 70, "Graphics",
 Evaluatable->False,
 CellID->2071525609]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[148831, 2837, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

