(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     83185,       1598]
NotebookOptionsPosition[     78333,       1459]
NotebookOutlinePosition[     81338,       1535]
CellTagsIndexPosition[     81245,       1529]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Using the Mathematica System" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/UsingTheMathematicaSystemOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Using the Mathematica System\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notebook Basics" :> 
          Documentation`HelpLookup["paclet:guide/NotebookBasics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Notebook Basics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Notebooks as Documents", "Title",
 CellTags->{"S1.3.5", "5.1"},
 CellID->16463],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks allow you to create documents that can be viewed interactively \
on screen or printed on paper."
}], "Text",
 CellID->29055],

Cell["\<\
Particularly in larger notebooks, it is common to have chapters, sections and \
so on, each represented by groups of cells. The extent of these groups is \
indicated by a bracket on the right. \
\>", "Text",
 CellID->6598],

Cell["\<\
The grouping of cells in a notebook is indicated by nested brackets on the \
right.\
\>", "MathCaption",
 CellID->15772],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 249},
 ImageMargins->0,
 CellID->19331],

Cell[TextData[{
 "A group of cells can be either ",
 StyleBox["open",
  FontSlant->"Italic"],
 " or ",
 StyleBox["closed",
  FontSlant->"Italic"],
 ". When it is open, you can see all the cells in it explicitly. But when it \
is closed, you see only the cell around which the group is closed. Cell \
groups are typically closed around the first or ",
 StyleBox["heading",
  FontSlant->"Italic"],
 " cell in the group, but you can close a group around any cell in that \
group."
}], "Text",
 CellID->1861],

Cell["\<\
Large notebooks are often distributed with many closed groups of cells, so \
that when you first look at the notebook, you see just an outline of its \
contents. You can then open parts you are interested in by \
double\[Hyphen]clicking the appropriate brackets. \
\>", "Text",
 CellID->28300],

Cell["\<\
Double\[Hyphen]clicking the bracket that spans a group of cells closes the \
group, leaving only the first cell visible. \
\>", "MathCaption",
 CellID->18493],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnQmcVeMbx0+z3KmmVSUlZEmIrGVJQojsJAlpIWVN/sgeWf/WIkR/lMgn
+57lY9+z71t2mSJaiLKc//N9zvu8c+6dO3fu3DuTSb2fz7lzzznveZfn/b3P
fu7sOeg/w444dtB/hg8Z1L7XyEEjhg0fcmL7XY4fKZcK6wVBQasgCCa0D/ge
ylf3UV5a8xEEhdGZ3pOPFnzUc1cK/a3A7meq9Pnnn8v9u+66Sz+a8FGgFwv1
orVjDxaXdyxF6oUffPBBEH3jo1SfLeKq3Q0feuihgvSd86f82WYZ+k1+piB6
xkojPjKNOpE0ahubTtrI01AfKPLTchUyDDy1w2gyVkr0vDiVVNQOarRRDqFw
zTaadqQllVIxGaX1KxllrUy9RhuNzWkpjLTO0dNt1jq+SMsWPVfs9zoMpXz3
+y/6tTCcv+A36yJomu3AsyDvHNfWhJteCg854lY9+g+ZEp5/yRORJJbP/01+
JRx33XN+jlJX+pGaMi5XV2s2qGGCznbtzZv/WzirbL4eX339U7jfwTdHYlQe
mnTbjHDnvSfotYIM9RumGVuOzGg31/XcuXPDV155Jfzuu+8cqQrD33//PZw9
e3a4ePHioNRd++qrr8I333wzXLRoUdBYrxVpvffff1+fLysrs8dnzZoVLliw
QM9K3LWZM2dq9egs7eNF7vKSJUvCd999N/z000/Dv/76yy7LYMJ33nkn/Oij
j8K///7bSDd//vxwzpwIAIk0c1JCbO9ulM1eIGt9qyNK1K7R3tG/OE3VGoTE
Fq75iy66SK/16tXLoSARnnzyyXYt/PHHH/X7WmutVeBuT5s2TS/17dtXu2Hm
8r1Qt0FpuPXWW4dffvmlx/e4cePCwkK9qyO45ppr9PuoUaMCa3LffffVa/fe
e68+A8m32WYbnZPcTiQS4cUXX6y3vvnmG6267rrrRmvaOrzzzjvDli1b6mWO
evXq6eBYQMrXX38dduzYUe8VFRWF55xzTlhcXBy2atVK73POvQEDBoStW7fW
73Q5fvx4N8KGVfYBUVZeeWUb8RprrBG+8MILngj3339/2Lx58+h2k3D11VdX
EFvZfvvttVXoRNl55531/JlnnqlI4kQSiWPkLHBresABB+ilO+64I8JJF4eb
GJa0COSkugBOPgVydtltjMzYy4MVd3DNy7YIt9hiCw45iz7vvvtuP4yE2xms
H/RmzWRLFbqbtqSTJ0+uCNPSCjAdPny4nq+22mrhWWedFW600UZ6Ljhzq1wS
dunSRa+ddNJJSuCKWG2ShFVhC/6Zgw46KLz88svD9u3b6/mTTz4ZB2s0mZXC
X375JWzYsKEu9emnnx7ec8894U477aTVrr32Wh3q8ccfr+dt2rTRzbjmmmvq
eQywEZI2DXfZZZfwkEMOCQsKCpRGMKyqumDpSkpKwvr164fnn3++zpa6q666
qvLCn376KWzSpInWP+6448Jjjz1W2xfiwvGUMtxjP9iQUxGbgdqpsA2qwG1R
Em4/+eyHwvC/Vz4l9c+56LHwgAGTXaWqIZujZF/XNc01t/2DQvd5/fXXe7ia
iOnRo4fWE3YgZ+3atROsct6gQQMVRxWw2jIJq6wASOf8k08+0bbhMqwo14xv
dO7cWc/BWFpGkAzVDz/80C/ab79F6g8b8LnnntOZVYBqSx3olVdeqRsMpL/8
8svhDjvsoNXOO+88bQL8cf7444/r+dNPP50KVT3v3bu3jWrQoEF+k1XVhT0+
ePBgkxVvv/22DhpSTpkyRW8L+uz24YcfriD7+OOP9eD2VlttFd1umoTTbChd
DZwmgy8dIPMCafZ8NVugco16srelPRFPcge5x7UDDzxQK8fAGqRTANgsjlVF
fLk07Nmzp16aOnVqVUBNqwA88MAD+l1EcZHTS+AgBtB11lnHJoC+BYMTTAcm
Whs1ahR+8cUX2tMmm2yij7z11lt6/sMPP6QFp+gWJgFuvPFGvbTffvtplYpd
FPsu0Beou/HGGwc20ieeeEJ5KteFjZsWZ0gUye3nHIdiBTImksiYvZCvORDm
qM9XD4SNVNgAOjbdr7/+qjdRCnj2vvvuSwKhLIKt0+233+4xiH7A99LSUvZv
YBqArIteB1CZgCgMyS/K3nvvrddQ2FgYtygF4WGHHSbdduvWzXdrgESU/vnn
n05dKccy4rhTp04KH5mBjSoVlPPmzUsLytGjR3ud46qrrkrSZSrpQu8dffTR
5UyPUSdUsDusqMDm+8CBA23OiAO46R9//BEHqpE6jtP0pE4kkdrIKiqAgXX/
/fdfpjlmfdex0R2NCuEJ/VdaaSVvBcgaOC6xTvjqq6+qtoQG5USYnrdt21bP
b7vtNn3mjTfe8NotbWZCKtoURuXChQtVG+MaHAcjGcuGZYHJUeDg3BcrhnYK
3LRGjhypIlQW3VF387BFixZeeaQAN0GOVzWyhewGG2ygporY5uGWW26p1849
91ytk6mPCRMmaF02H1oAbTRt2lSV0u+//z588cUX/fQBKvdN+3/ppZfScNeW
SajNhuxG4vXWW083xM8//+z7eOSRR5YeamtGGa3vNiZ2K/WQVdddd51+P/LI
I825Y5wVdR8OLMZLYEhhVSgTJ05019qjHSrVeAazgIIkMpVp8803VxXQqInO
CyhBCueYHMaobGNw38CM3cx9462iPXuVRHTDiLAdw/79++ul7t27q5zEOkEq
OwdM1oBleDTPX85po6ysTOtk6gPN0Ywy7D2zlsolSXNvcQFkjiBSrtXTZOOj
PUQKJdWCKid747RkNxKL3oapoXzISDxr1qw6yWexTJHccshZ9IlHLhW10Bea
MSezMIQuBa4S+58lGTZsmO5nSCjiTs1vkcRRtRbhLbfcooCEyrCmMWPGKHuh
ICVtVXbbbTc1PIyiJ554ot6H3XTt2hVL3q1qY5pXw2TDDTdUL44pAhSQgSdn
xIgRuu9gga+99pr3q8G68IYxXAA/ZMgQnERmmmC58Phnn32mzUEszvfZZ58k
0MJRhw4diiKsoBFO5uVwxi4S6hHFT8HMENlnnHEGFDFugP7Frlx//fVVBxO1
W1oWVVdobsvAkvTp00dHBKEYoWwz01Qy0RydimWbNGmSPgp7pSmzHbvWMFhz
DOds6ZqCdo7F6lKLFBG5EqpOlMmm6eiGZ+t12WWXBau5axUlVWF40003qQIH
nbWxndwsLYpw0OAp4f6HTErnEa7Ovs1Bmd/SdYIvy0hxyimntHJUYOT4ZZ2T
PWsqoPPznJjvngox9pdMBYs/vPP+LCiRDxVyiJpt5TpAhUAwcSxevLiN6xGV
mV2DLmwzhnmhPcjfYC13jY3Hvkbr0n56uuHFI0V7HXijxoEKMtyr5bCAVkgX
KeJYtGiJH1u6e0tjbEuy6CPfKGE2feQTJfzDtT/nh4Xqw/yn6JRvCkFedKpj
a1EX5pBP+kF16FTb651rcsKvrv14dD6bUFQe66P+JRkbvBm/NDoVVid/ibwI
f4/62NT1WXlkvzAe2a9thdrGbX4XQrWMFyvbCenkcWcb9c+Gh+fBX02hwMhC
5cYYEplYJyP2bd01jEdR46nrSYYZQEQFv58NHhUB/W727Nli/oVkOIpiLLfd
6HVYEEJMlYiQFoT/59MBzE6ETBi87MnI+GyhqjxqvJXlOZweLUOpj1G9/vrr
+hh4sHna+THHHMMIvBG/5557Kr4ojz76qKcNBjwBDr5jMvEsNN50003ds6W4
bHxgGTijX/Idwz9l2N79HRu3nzWhYpwVOC9EIzfPexyOy2iaQAtlHCCB56Et
jhLMeOjLNfNnZRFdD/7t4fUIx6tViWNLD8LdgccWOcM5/VPMK4DnhWDsKqus
oufQjLL77rvrOdjF8yzyydG2flU4rgzGFnXjEYYDC2JpZMhxGC8rWQOW5IKP
mXr4XkTrMKcQITAu77jjjkkEzyLe7qNH/6qAe4TcVapELojl3Hz3oI1ZEJaJ
37fzs88+20st4dLmBDePstApH+DiIzAeApEoFkZPAW6dcdZmh9xCDTihH+G/
iubeTANUyCyeR5+gLC/R+Gx1BAs6yJZ2Ay5VaBGw43qzZs1UJ2KDGTJpi+8d
OnTwcp52bQdlpxskkrD53nvv6Xefj1SoWx2RVWvQrOXkgvpuMNgOl156qXr4
hUSmiY0dOzYtIpe3UHyE1I4eqQ8//LCOG57MOVoMBSRx3q9fP43ZWmgMjobG
QpkxY4byUCQ+W9IQa0uFFmaBANq3lOBMiJVh+2nFxq3bPYi0PJsWluOyzEzN
2r3iiiuMNI7DbazKHZzQSL0iHP9Iqv5KrIahmjoE2iiml6PuUEAP5+RoUiA3
kUNTpy655BK9D89lD5rtwFLRvtx3y9IqI3IryyKAV1uglnP6OPPMM2sPujVg
f2WnByR0rnAE6kL3G264AQYcjXKNFTH5WbMcw23jYcscSXEwZihau7bz7LPP
+rYRKnynDn4PymOPPeZVCXRvm4sti2jy3n3TuHFjtZFsaTLBtpJxa50xY8a4
Nou0P+QOAsLUmaXCcLOzuapKMzCbC63VICBMyfIGLrzwQkXa9OnTtf7yHJiP
SFXiEQsD5Tt6DFVwitoo0bbZmThfqCPNOh9RWw0Vg1QmiIqACmbyjL8XXHCB
In2zzTZT546pEKAVY4LZoGpVMVxTlGiS5WCmHGxgxJkwgDqlHmzhGgRSbD42
KRrkrbfeGp566qlaj80rNrjrNre8gpXdtZhN4vzbiSRSI7N4huWg9HREqMFU
hBxVf/NQwxqdJ9RnqsGysKbLu8wt7yBbKqWyT6NSDaYq5Iinrq4phCGqGFQB
+8JA/BuUVeUnrByrB+MRLuGpgNDmWQrcg2cs235H1/dSTWmoxku5y2o6w4rQ
cN0K069IX6kb7S8rqSt1Ic3n35Iesyys9/KyFnVUHk1xTaGqkDPAPVQhUVui
tnu5CplSeWpBjt3imkaBJDQitr9og4HOCQ8fPghPo51sEmnSdmpZL4kiown1
BgaR20cPXFrt2rUznRvz38XOoi53STOsWtZ2J7mm8KJh22IeY+0JKX0eDe5/
m4JFpXvlONQ8JHNrR1VQSRCHe7jbyUlasmRJIjYTeiHsiysWHd3u4TUnVsOj
eNv5VRTzZFh6Ml6OuXPn2sDBGuFb0m1IaxIz07n10ndV7JojNIdLlGelaQun
0BwBYxzAUr2dm5O5EWgRWDBnEuTzIXWOjNJsF64R9hbb2W8y8j14BYqcLUtd
wZ3hcka8NYlTCz8w+f5WT/iQ5Sv5eji+8B9HNfgsUcpYDgoHUQtK3759A0tm
Im/MCutGHo70aa5VfH34E1kPy3ezIBNHWVmZjcqyLRo3buwCCOop8FWHDRtm
LVjYimP8+PHZzt/8KYQELMbIAS3wqQ8ZMsQHYvEwWSEnpkmTJv4ejkRs0V13
3VWfj/KioqERSbN2hTYF2c+50EGHxLo99thDR4UXBU8acF977bW1rjwTZ/1L
lUe1dM3zpoiLowk9+SzSTCQrU6ZMKXTEYgHinHfEiBHeUMXza55hDvke2HO4
POKlf//+3mEPSZKBWJQExOHDh1s6XLx5DmIl3jtaC1i0qVluiR1CBjf8ZvpK
FYWVxh/mpq6vZ1keoeGTEBJxFgoxFqlX5GbMo5Z2JxDMH4HmRSKo4QIObsxF
6pC19x4ZY74AzFH/bekaND8xByEvUhBx3bBIhGriP6JAogzixMJfTA3kweFx
miNouQ4LJA5N6dKlS4FDNxEtBB3ROFI3qUpTsDQjroVb8HgKce39upSl0JYZ
oUUvWD3eRkIYQnQZicczLn8rsnY2GgseWckaqc1TkaqPV4cuwhL96EgHpQBN
ERt2GYFJQYh26tTJLp922mn6Vjc06N69u122jFa3ldPt5CxnbpzdQmIcBImB
AqGGRo0aeYlg6A1N19s5DxjnyEdbuKYgtYUGIbNoO67rYh/G4sD7P336dC+B
LPBtRfDpQigJDTBAbHvWZWIaVBHQxHQ4ZLVtzxuCkXOWJpQOviLMbRC41uPl
5ptv9viwDL+aQm8iLXqFJFVTpFgpAoOwxwcOHOjmWOwDq3jEKaLCeipbMNeK
WAhBLthtkGneek6GvvWKXLXMaoqYfTWP3TyU/xauExIlyJTlmDp1arHr4YQT
TvCERvMbO3asH74QXk0YOSJjRuoTArEcDA5RfXzYI1tQyrY36sGl40U0Fb9m
6MwVFqfGQSkTrny+jXW+kM4kN7Lg0EMPVYWTn4PE5IsDkrij5WqaAm4FNmvR
7Rw1gOIKWCR2ZBOIdei1A8ufQsTqnaVsFbV1HbBsEA1dWScfDXnixIkWLhOK
RaAgqfypp57ys+/Xr1+1MSb17P0Fe0/aSjxnES5uoWAheGAgI9WoOiAbOnRo
JpDJDBvEJkfB5YIGGf0AFvcSCi7LUTZAiflstIqp7H55LeOumkaNzK8yQIn5
5AFlekO8R8tzqT1AVc3UzNQGJUcddRTSMWrYUYSssyjQGhGdlFOQZodsFH8P
CWv5jByyKN72JdxIlhrHnDlzqit9+/TpY70QVI8XMRE9o4OHWIkxOrwd8WKs
ozIMihJsg4k7nnA7UIQeVZOjvpIjXlA5sdSR2N26dTNkGDwJU9ujuMHiBX5n
oevq8TuZusEzNmttNEpsiebBKxjxIgy5dvTGvMyf6I099+NeDqbFyoHwEhmn
4XU9mxe6cLwASeMRZFvEBQkGuwzPqHjEEUd4Kk6bNq26iBXg2CDIQoqXKO8n
QiwDt+IRW6S2lxXRkWwpyNexpTC9Iw5cZ4b5fCX79SgODHNHnqqpU+ypQ8oO
6TyDBw8O7L0/8ktAURCU52iSGmUaPTqi2PhGSRQlG0X10CtkMJOSdFK7bGRA
vzX5Q9/4VSkub6hOWT5mwI8ePdrPgwNnBulk5AnhSuYXse2nZnjX0OqRdsV7
XD169DCQ2GtiFGE2NltSEVFGt91228AkN7KQ9EpcBbw4ZAnsePQ4xzNKSedY
IqtJfzwvYqZg6uqrr9aXx8yeR/jPnDnTm6PxNaQOUQje4OjcubNflJil5LBc
koRlDl6eYCo9e/b0Dpk4MxcCWXMx+gRmfcQJRNSAJvE34UbDF1ru9yzy77dQ
Ro4cac1iCvGbb7JEfgTVMYGKUuefzlCUKVp/ZHQzVJFk3utX+/DNrHi2cs1A
TlsZVkW0efeORuSq79Chg5tcxGCJh3377bd+mqQi9e7dO+GmZW9FPvjgg17l
sNTHchwWJ9EVNw0/cWr1AZ5Llw3SMZABAwZY4ICFdwniPhgTxxvvD4so8KMn
vzFe3AyLK5kcwcmmTZvabbY17nMrxGKEjZoLk2RHS56vHkv0M0rEZ+T7EPFk
fcC5zagyi/4fc50X+YAKDFsEiL3Wz76DG8G15s2bZxyElDWEIEl8OB9RUFD4
cW8UuzXEycU7ZRATEXXwwQeHzz//fIGbATAmsdTsNrDCOQmnlHHjxsmAca+X
+p9stIJBSsIwabqkSfOeIVyj/IfAGmgiMBubg5gaONxrr710OPwVi9xtj4ap
ZrRKKhYbZxQU4KVN0W2Kspi91WGIaOwsM6nPmKxoqySZ2hDR3mmHOsTyqI/5
aLCI2zpMB02FQ1WO7Gdp3SEpkGPbbbeddkGAHF2BodOszDx/QyfHpAWDIVaz
rYTMxewTe0eRQ6hpvwxVUdsr8r84wSFrtoa7nLLElsWejtQpLejYD8tzZ+as
VJeo2hEPF1nmd/TT5xH3jL8q0joDcVI4WA7ESadM50OcHJI8zChGn3C/W+nj
z2hSzvMQGEpwTuAU5uWKukuIvDwEJfo4mxuTl8gT702MGjVKn1jTDYScf1gZ
h5i7NmmMf1655ZgxY4ZNGvlIerswZD/plBb+qUlrhYU59ptv6meu/eab/jvf
9ZTFawI1mRW8wHWbRd59Ta/wPNdedZPd0/3npHyiClrlozAIvFVf3TT31BGt
+J96K/6nXg3Ts1amvuJ/6tWN/6n3bx3pv3/lV3CmFZx+ueT0WdAzNqGapSf+
8n9olMvOAtXaSCs0mvyfxuP0jC4GOf+n8fJ/0t5Iuy3MVn5FvfCR/T9Yz+0Z
K830PBmbFZ8JjCD6oZHPyK6IteT+331Q7/9MKlk4\
\>"], "Picture",
 ImageSize->{533, 153},
 ImageMargins->0,
 CellID->1558182641],

Cell["\<\
When a group is closed, the bracket for it has an arrow at the bottom. Double\
\[Hyphen]clicking this arrow opens the group again. \
\>", "MathCaption",
 CellID->30649],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 249},
 ImageMargins->0,
 CellID->306265790],

Cell["\<\
Double\[Hyphen]clicking the bracket of a cell that is not the first of a cell \
group closes the cell group around that cell and creates a bracket with up \
and down arrows (or only an up arrow if the cell was the last in the group).\
\>", "MathCaption",
 GeneratedCell->False,
 CellID->426406908],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 152},
 ImageMargins->0,
 CellID->304508537],

Cell[TextData[{
 "Each cell within a notebook is assigned a particular ",
 StyleBox["style",
  FontSlant->"Italic"],
 " which indicates its role within the notebook. Thus, for example, material \
intended as input to be executed by the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel is typically in ",
 Cell[BoxData[
  ButtonBox["Input",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Input"]], "InlineFormula"],
 " style, while text that is intended purely to be read is typically in ",
 Cell[BoxData[
  ButtonBox["Text",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Text"]], "InlineFormula"],
 " style."
}], "Text",
 CellID->4237],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end provides menus and keyboard shortcuts for creating cells with \
different styles, and for changing styles of existing cells. "
}], "Text",
 CellID->13082],

Cell["\<\
This shows cells in various styles. The styles define not only the format of \
the cell contents, but also their placement and spacing.\
\>", "MathCaption",
 CellID->7619],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 249},
 ImageMargins->0,
 CellID->2070942806],

Cell["\<\
By putting a cell in a particular style, you specify a whole collection of \
properties for the cell, including for example how large and in what font \
text should be given. \
\>", "Text",
 CellID->10463],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end allows you to modify such properties, either for complete cells, \
or for specific material within cells."
}], "Text",
 CellID->28816],

Cell[TextData[{
 "Even within a cell of a particular style, the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end allows a wide range of properties to be modified separately."
}], "MathCaption",
 CellID->32610],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 112},
 ImageMargins->0,
 CellID->675805162],

Cell[TextData[{
 "Ordinary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks can be read by non-",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " users using the free product, ",
 StyleBox["Wolfram Mathematica Player",
  FontSlant->"Italic"],
 ", which allows viewing and printing, but does not allow computations of any \
kind to be performed. This product also supports notebook player files \
(.nbp), which have been specially prepared by Wolfram Research to allow \
interaction with dynamic content such as the output of ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ". For example, all of the notebook content on the ",
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com"], None}],
  FontSlant->"Italic"],
 ButtonBox[" Demonstrations site",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com"], None}],
 " is available as notebook player files."
}], "Text",
 CellID->12619],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " front end"
    }], "TableText"], Cell[TextData[{
     "creating and editing ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " notebooks"
    }], "TableText"]},
   {Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " kernel"
    }], "TableText"], Cell["doing computations in notebooks", "TableText"]},
   {Cell[TextData[StyleBox["Wolfram Mathematica Player",
     FontSlant->"Italic"]], "TableText"], Cell[TextData[{
     "reading ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " notebooks and running Demonstrations"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->30880],

Cell["\<\
Programs required for different kinds of operations with notebooks. \
\>", "Caption",
 CellID->8108],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->30009388],

Cell[TextData[ButtonBox["Notebook Basics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookBasics"]], "TutorialMoreAbout",
 CellID->99569351]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->402755244],

Cell[TextData[{
 ButtonBox["Using the ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"],
  FontSlant->"Italic"],
 ButtonBox[" System",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"]
}], "RelatedTutorials",
 CellID->344194261]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Notebooks as Documents - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Using the Mathematica System", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/UsingTheMathematicaSystemOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DoingComputationsInNotebooks"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/HyperlinksAndActiveText"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 6.8233286}", "context" -> "", 
    "keywords" -> {
     "cells", "chapters", "closed cell groups", "documents", 
      "groups of cells", "hypermedia (notebooks as)", "MathReader", "Player", 
      "nested cells", "open cell groups", "paper output", "reader", 
      "sections", "styles", "text"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica notebooks allow you to create documents that can be viewed \
interactively on screen or printed on paper. Particularly in larger \
notebooks, it is common to have chapters, sections and so on, each \
represented by groups of cells. The extent of these groups is indicated by a \
bracket on the right. The grouping of cells in a notebook is indicated by \
nested brackets on the right.", 
    "synonyms" -> {"1.3.5", "notebook document", "notebook file"}, "title" -> 
    "Notebooks as Documents", "type" -> "Tutorial", "uri" -> 
    "tutorial/NotebooksAsDocuments"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.3.5"->{
  Cell[1864, 60, 85, 2, 70, "Title",
   CellTags->{"S1.3.5", "5.1"},
   CellID->16463]},
 "5.1"->{
  Cell[1864, 60, 85, 2, 70, "Title",
   CellTags->{"S1.3.5", "5.1"},
   CellID->16463]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.3.5", 81034, 1518},
 {"5.1", 81133, 1522}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1239, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1864, 60, 85, 2, 70, "Title",
 CellTags->{"S1.3.5", "5.1"},
 CellID->16463],
Cell[1952, 64, 202, 6, 70, "Text",
 CellID->29055],
Cell[2157, 72, 232, 5, 70, "Text",
 CellID->6598],
Cell[2392, 79, 130, 4, 70, "MathCaption",
 CellID->15772],
Cell[2525, 85, 12282, 204, 70, "Picture",
 CellID->19331],
Cell[14810, 291, 504, 15, 70, "Text",
 CellID->1861],
Cell[15317, 308, 303, 6, 70, "Text",
 CellID->28300],
Cell[15623, 316, 168, 4, 70, "MathCaption",
 CellID->18493],
Cell[15794, 322, 8338, 139, 70, "Picture",
 CellID->1558182641],
Cell[24135, 463, 178, 4, 70, "MathCaption",
 CellID->30649],
Cell[24316, 469, 11050, 184, 70, "Picture",
 CellID->306265790],
Cell[35369, 655, 307, 6, 70, "MathCaption",
 CellID->426406908],
Cell[35679, 663, 10017, 167, 70, "Picture",
 CellID->304508537],
Cell[45699, 832, 653, 20, 70, "Text",
 CellID->4237],
Cell[46355, 854, 241, 7, 70, "Text",
 CellID->13082],
Cell[46599, 863, 181, 4, 70, "MathCaption",
 CellID->7619],
Cell[46783, 869, 17488, 289, 70, "Picture",
 CellID->2070942806],
Cell[64274, 1160, 215, 5, 70, "Text",
 CellID->10463],
Cell[64492, 1167, 221, 7, 70, "Text",
 CellID->28816],
Cell[64716, 1176, 225, 6, 70, "MathCaption",
 CellID->32610],
Cell[64944, 1184, 10602, 176, 70, "Picture",
 CellID->675805162],
Cell[75549, 1362, 1082, 30, 70, "Text",
 CellID->12619],
Cell[76634, 1394, 748, 24, 70, "DefinitionBox",
 CellID->30880],
Cell[77385, 1420, 110, 3, 70, "Caption",
 CellID->8108],
Cell[CellGroupData[{
Cell[77520, 1427, 65, 1, 70, "TutorialMoreAboutSection",
 CellID->30009388],
Cell[77588, 1430, 148, 3, 70, "TutorialMoreAbout",
 CellID->99569351]
}, Open  ]],
Cell[CellGroupData[{
Cell[77773, 1438, 72, 1, 70, "RelatedTutorialsSection",
 CellID->402755244],
Cell[77848, 1441, 431, 12, 70, "RelatedTutorials",
 CellID->344194261]
}, Open  ]]
}, Open  ]],
Cell[78306, 1457, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

