(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11629,        421]
NotebookOptionsPosition[      7656,        295]
NotebookOutlinePosition[     10108,        362]
CellTagsIndexPosition[     10019,        356]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/NumbersOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numbers\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NumberQ" :> Documentation`HelpLookup["paclet:ref/NumberQ"], 
          "NumericQ" :> Documentation`HelpLookup["paclet:ref/NumericQ"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"NumberQ\"\>", 
       2->"\<\"NumericQ\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Numeric Quantities", "Title",
 CellTags->{"S3.1.2", "2.1"},
 CellID->13947],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NumberQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumberQ"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is explicitly a number"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NumericQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumericQ"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " has a numerical value"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->6361],

Cell["Testing for numeric quantities. ", "Caption",
 CellID->28928],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Pi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pi"]], "InlineFormula"],
 " is a symbol, so ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Pi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pi"], "+", "3"}]], "InlineFormula"],
 " is not explicitly a number. "
}], "MathCaption",
 CellID->3959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberQ", "[", 
  RowBox[{"Pi", "+", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->4415],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->16016]
}, Open  ]],

Cell["It does however have a numerical value. ", "MathCaption",
 CellID->15],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"Pi", "+", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->31466],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->14662]
}, Open  ]],

Cell[TextData[{
 "This finds the explicit numerical value of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Pi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pi"], "+", "3"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Pi", "+", "3"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->26058],

Cell[BoxData["6.141592653589793`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->2398]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows that constants such as ",
 Cell[BoxData[
  ButtonBox["Pi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pi"]], "InlineFormula"],
 " are numeric quantities. It also knows that standard mathematical functions \
such as ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " have numerical values when their arguments are numerical."
}], "Text",
 CellID->22331],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", 
   RowBox[{"2", "+", "x"}], "]"}]], "InlineFormula"],
 " contains ",
 Cell[BoxData["x"], "InlineFormula"],
 ", and is therefore not a numeric quantity. "
}], "MathCaption",
 CellID->7179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"NumericQ", "[", 
    RowBox[{"Log", "[", "2", "]"}], "]"}], ",", 
   RowBox[{"NumericQ", "[", 
    RowBox[{"Log", "[", 
     RowBox[{"2", "+", "x"}], "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->31188],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->30073]
}, Open  ]],

Cell["\<\
Many functions implicitly use the numerical values of numeric quantities. \
\>", "MathCaption",
 CellID->13946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "2", "]"}], ",", 
   RowBox[{"Log", "[", "2", "]"}], ",", 
   RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->16089],

Cell[BoxData[
 RowBox[{"Log", "[", "2", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->19980]
}, Open  ]],

Cell[TextData[{
 "In general, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that any function which has the attribute ",
 Cell[BoxData[
  ButtonBox["NumericFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericFunction"]], "InlineFormula"],
 " will yield numerical values when its arguments are numerical. All standard \
mathematical functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " already have this attribute. But when you define your own functions, you \
can explicitly set the attribute to tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to assume that these functions will have numerical values when their \
arguments are numerical."
}], "Text",
 CellID->18481],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->29516006],

Cell[TextData[ButtonBox["Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumbersOverview"]], "RelatedTutorials",
 CellID->54483688]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numeric Quantities - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numbers", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/NumbersOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TypesOfNumbers"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DigitsInNumbers"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 30.1520508}", "context" -> "", 
    "keywords" -> {
     "constants", "NumberQ", "numbers", "NumericFunction", "NumericQ", 
      "numeric quantities"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Testing for numeric quantities. Pi is a symbol, so Pi+3 is not \
explicitly a number. It does however have a numerical value. ", 
    "synonyms" -> {"3.1.2"}, "title" -> "Numeric Quantities", "type" -> 
    "Tutorial", "uri" -> "tutorial/NumericQuantities"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.1.2"->{
  Cell[1851, 58, 81, 2, 70, "Title",
   CellTags->{"S3.1.2", "2.1"},
   CellID->13947]},
 "2.1"->{
  Cell[1851, 58, 81, 2, 70, "Title",
   CellTags->{"S3.1.2", "2.1"},
   CellID->13947]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.1.2", 9808, 345},
 {"2.1", 9907, 349}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1226, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1851, 58, 81, 2, 70, "Title",
 CellTags->{"S3.1.2", "2.1"},
 CellID->13947],
Cell[1935, 62, 959, 31, 70, "DefinitionBox",
 CellID->6361],
Cell[2897, 95, 67, 1, 70, "Caption",
 CellID->28928],
Cell[2967, 98, 344, 13, 70, "MathCaption",
 CellID->3959],
Cell[CellGroupData[{
Cell[3336, 115, 123, 4, 28, "Input",
 CellID->4415],
Cell[3462, 121, 159, 5, 36, "Output",
 CellID->16016]
}, Open  ]],
Cell[3636, 129, 76, 1, 70, "MathCaption",
 CellID->15],
Cell[CellGroupData[{
Cell[3737, 134, 125, 4, 28, "Input",
 CellID->31466],
Cell[3865, 140, 158, 5, 36, "Output",
 CellID->14662]
}, Open  ]],
Cell[4038, 148, 237, 9, 70, "MathCaption",
 CellID->27292],
Cell[CellGroupData[{
Cell[4300, 161, 118, 4, 28, "Input",
 CellID->26058],
Cell[4421, 167, 171, 5, 36, "Output",
 CellID->2398]
}, Open  ]],
Cell[4607, 175, 615, 21, 70, "Text",
 CellID->22331],
Cell[5225, 198, 313, 11, 70, "MathCaption",
 CellID->7179],
Cell[CellGroupData[{
Cell[5563, 213, 274, 9, 70, "Input",
 CellID->31188],
Cell[5840, 224, 207, 7, 36, "Output",
 CellID->30073]
}, Open  ]],
Cell[6062, 234, 121, 3, 70, "MathCaption",
 CellID->13946],
Cell[CellGroupData[{
Cell[6208, 241, 223, 7, 70, "Input",
 CellID->16089],
Cell[6434, 250, 184, 6, 36, "Output",
 CellID->19980]
}, Open  ]],
Cell[6633, 259, 727, 20, 70, "Text",
 CellID->18481],
Cell[CellGroupData[{
Cell[7385, 283, 71, 1, 70, "RelatedTutorialsSection",
 CellID->29516006],
Cell[7459, 286, 143, 3, 70, "RelatedTutorials",
 CellID->54483688]
}, Open  ]]
}, Open  ]],
Cell[7629, 293, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

