(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15611,        531]
NotebookOptionsPosition[     11404,        402]
NotebookOutlinePosition[     14125,        474]
CellTagsIndexPosition[     14034,        468]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Mathematics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalMathematicsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Mathematics\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FindRoot" :> Documentation`HelpLookup["paclet:ref/FindRoot"], 
          "NSolve" :> Documentation`HelpLookup["paclet:ref/NSolve"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"FindRoot\"\>", 
       2->"\<\"NSolve\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Numerical Equation Solving", "Title",
 CellTags->{"S1.6.3", "3.1"},
 CellID->1863],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NSolve"], "[", 
     StyleBox["lhs", "TI"], "==", 
     StyleBox["rhs", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[
    "solve a polynomial equation numerically", "TableText"]},
   {
    RowBox[{
     ButtonBox["NSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NSolve"], "[", "{", 
     SubscriptBox[
      StyleBox["lhs", "TI"], "1"], "==", 
     SubscriptBox[
      StyleBox["rhs", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["lhs", "TI"], "2"], "==", 
     SubscriptBox[
      StyleBox["rhs", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[
    "solve a system of polynomial equations numerically", "TableText"]},
   {
    RowBox[{
     ButtonBox["FindRoot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindRoot"], "[", 
     StyleBox["lhs", "TI"], "==", 
     StyleBox["rhs", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], "}", "]"}], Cell[TextData[{
     "search for a numerical solution to an equation, starting at ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "="}]], "InlineFormula"],
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "0"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FindRoot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindRoot"], "[", "{", 
     SubscriptBox[
      StyleBox["lhs", "TI"], "1"], "==", 
     SubscriptBox[
      StyleBox["rhs", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["lhs", "TI"], "2"], "==", 
     SubscriptBox[
      StyleBox["rhs", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", "{", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], "}", ",", "{", 
     StyleBox["y", "TI"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "0"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[
    "search for numerical solutions to simultaneous equations", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->15970],

Cell["Numerical root finding. ", "Caption",
 CellID->21455],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " gives you numerical approximations to all the roots of a polynomial \
equation. "
}], "MathCaption",
 CellID->23360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "+", "x", "+", "1"}], "==", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->17908],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "0.7548776662466926`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.5`"}], "-", 
      RowBox[{"0.8660254037844386`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.5`"}], "+", 
      RowBox[{"0.8660254037844386`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"0.8774388331233463`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.7448617666197443`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"0.8774388331233463`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.7448617666197443`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{432, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->14898]
}, Open  ]],

Cell[TextData[{
 "You can also use ",
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " to solve sets of simultaneous equations numerically. "
}], "MathCaption",
 CellID->23063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", "y"}], "==", "2"}], ",", 
     RowBox[{
      RowBox[{"x", "-", 
       RowBox[{"3", " ", "y"}], "+", "z"}], "==", "3"}], ",", 
     RowBox[{
      RowBox[{"x", "-", "y", "+", "z"}], "==", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->30584],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "3.5`"}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", "1.5`"}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"-", "5.`"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->3925]
}, Open  ]],

Cell[TextData[{
 "If your equations involve only linear functions or polynomials, then you \
can use ",
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " to get numerical approximations to all the solutions. However, when your \
equations involve more complicated functions, there is in general no \
systematic procedure for finding all solutions, even numerically. In such \
cases, you can use ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " to search for solutions. You have to give ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " a place to start its search. "
}], "Text",
 CellID->558],

Cell[TextData[{
 "This searches for a numerical solution, starting at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->6914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], "==", 
    RowBox[{"Log", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->23130],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "1.447258617277903`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->9479]
}, Open  ]],

Cell[TextData[{
 "The equation has several solutions. If you start at a different ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " may return a different solution. "
}], "MathCaption",
 CellID->30803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], "==", 
    RowBox[{"Log", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->15399],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "13.10638768062491`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->28785]
}, Open  ]],

Cell["\<\
You can search for solutions to sets of equations. Here the solution involves \
complex numbers. \
\>", "MathCaption",
 CellID->27000],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "==", 
      RowBox[{"Log", "[", "y", "]"}]}], ",", 
     RowBox[{"y", "==", 
      RowBox[{"Log", "[", "x", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "I"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "2"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->15651],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", 
    RowBox[{"0.3181315052047642`", "\[InvisibleSpace]", "+", 
     RowBox[{"1.3372357014306895`", " ", "\[ImaginaryI]"}]}]}], ",", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"0.3181315052047641`", "\[InvisibleSpace]", "+", 
     RowBox[{"1.3372357014306895`", " ", "\[ImaginaryI]"}]}]}]}], 
  "}"}]], "Output",
 ImageSize->{333, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->17554]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->42632228],

Cell[TextData[ButtonBox["Numerical Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalMathematicsOverview"]], "RelatedTutorials",
 CellID->432952818]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerical Equation Solving - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Mathematics", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/NumericalMathematicsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/NumericalSumsProductsAndIntegrals"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/NumericalDifferentialEquations"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 9.3077672}", "context" -> "", 
    "keywords" -> {
     "FindRoot", "newtons method", "NSolve", "numerical root finding", 
      "polynomial root finding", "Root finding", "roots of polynomials", 
      "solution of equations", "zero finding"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Numerical root finding. NSolve gives you numerical approximations to all \
the roots of a polynomial equation. You can also use NSolve to solve sets of \
simultaneous equations numerically. ", "synonyms" -> {"1.6.3"}, "title" -> 
    "Numerical Equation Solving", "type" -> "Tutorial", "uri" -> 
    "tutorial/NumericalEquationSolving"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.6.3"->{
  Cell[1899, 59, 88, 2, 70, "Title",
   CellTags->{"S1.6.3", "3.1"},
   CellID->1863]},
 "3.1"->{
  Cell[1899, 59, 88, 2, 70, "Title",
   CellTags->{"S1.6.3", "3.1"},
   CellID->1863]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.6.3", 13825, 457},
 {"3.1", 13923, 461}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1274, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1899, 59, 88, 2, 70, "Title",
 CellTags->{"S1.6.3", "3.1"},
 CellID->1863],
Cell[1990, 63, 2788, 83, 70, "DefinitionBox",
 CellID->15970],
Cell[4781, 148, 59, 1, 70, "Caption",
 CellID->21455],
Cell[4843, 151, 250, 8, 70, "MathCaption",
 CellID->23360],
Cell[CellGroupData[{
Cell[5118, 163, 211, 8, 28, "Input",
 CellID->17908],
Cell[5332, 173, 1008, 29, 54, "Output",
 CellID->14898]
}, Open  ]],
Cell[6355, 205, 245, 8, 70, "MathCaption",
 CellID->23063],
Cell[CellGroupData[{
Cell[6625, 217, 450, 15, 28, "Input",
 CellID->30584],
Cell[7078, 234, 377, 13, 36, "Output",
 CellID->3925]
}, Open  ]],
Cell[7470, 250, 811, 22, 70, "Text",
 CellID->558],
Cell[8284, 274, 200, 7, 70, "MathCaption",
 CellID->6914],
Cell[CellGroupData[{
Cell[8509, 285, 288, 10, 70, "Input",
 CellID->23130],
Cell[8800, 297, 222, 7, 36, "Output",
 CellID->9479]
}, Open  ]],
Cell[9037, 307, 347, 11, 70, "MathCaption",
 CellID->30803],
Cell[CellGroupData[{
Cell[9409, 322, 289, 10, 70, "Input",
 CellID->15399],
Cell[9701, 334, 223, 7, 36, "Output",
 CellID->28785]
}, Open  ]],
Cell[9939, 344, 144, 4, 70, "MathCaption",
 CellID->27000],
Cell[CellGroupData[{
Cell[10108, 352, 450, 16, 70, "Input",
 CellID->15651],
Cell[10561, 370, 504, 14, 36, "Output",
 CellID->17554]
}, Open  ]],
Cell[CellGroupData[{
Cell[11102, 389, 71, 1, 70, "RelatedTutorialsSection",
 CellID->42632228],
Cell[11176, 392, 174, 4, 70, "RelatedTutorials",
 CellID->432952818]
}, Open  ]]
}, Open  ]],
Cell[11377, 400, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

