(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17755,        605]
NotebookOptionsPosition[     12989,        462]
NotebookOutlinePosition[     15979,        538]
CellTagsIndexPosition[     15888,        532]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Operations on Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Operations on Functions\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NProduct" :> Documentation`HelpLookup["paclet:ref/NProduct"], 
          "NSum" :> Documentation`HelpLookup["paclet:ref/NSum"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NProduct\"\>", 
       2->"\<\"NSum\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Numerical Evaluation of Sums and Products", "Title",
 CellTags->{"S3.9.4", "4.1"},
 CellID->10980],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NSum",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NSum"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]}], "]"}], Cell[TextData[{
     "find a numerical approximation to the sum ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         RowBox[{"i", "=", 
          SubscriptBox["i", 
           StyleBox["min",
            FontSlant->"Italic"]]}], 
         SubscriptBox["i", 
          StyleBox["max",
           FontSlant->"Italic"]],
         LimitsPositioning->True], " ", "f"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NSum",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NSum"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["maxdi", "TI"]]}], "}"}]}], "]"}], Cell[TextData[{
     "use step ",
     Cell[BoxData[
      FormBox[
       RowBox[{"d", "\[InvisibleSpace]", "i"}], TraditionalForm]], 
      "InlineMath"],
     " in the sum "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NProduct",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NProduct"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]}], "]"}], Cell[TextData[{
     "find a numerical approximation to the product ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        UnderoverscriptBox["\[Product]", 
         RowBox[{"i", "=", 
          SubscriptBox["i", 
           StyleBox["min",
            FontSlant->"Italic"]]}], 
         SubscriptBox["i", 
          StyleBox["max",
           FontSlant->"Italic"]],
         LimitsPositioning->True], " ", "f"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13888],

Cell["Numerical sums and products. ", "Caption",
 CellID->31908],

Cell[TextData[{
 "This gives a numerical approximation to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], "\[Infinity]",
     LimitsPositioning->True], 
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["i", "3"], "+", "i", "!"}]]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "MathCaption",
 CellID->17852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"i", "^", "3"}], "+", 
      RowBox[{"i", "!"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->21660],

Cell[BoxData["0.647029989016478`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->27829]
}, Open  ]],

Cell[TextData[{
 "There is no exact result for this sum, so ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " leaves it in a symbolic form. "
}], "MathCaption",
 CellID->3243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"i", "^", "3"}], "+", 
      RowBox[{"i", "!"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->4282],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"i", "=", "1"}], "\[Infinity]"], 
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["i", "3"], "+", 
    RowBox[{"i", "!"}]}]]}]], "Output",
 ImageSize->{66, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->17065]
}, Open  ]],

Cell[TextData[{
 "You can apply ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " explicitly to get a numerical result. "
}], "MathCaption",
 CellID->29881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->16474],

Cell[BoxData["0.647029989016478`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->19380]
}, Open  ]],

Cell[TextData[{
 "The way ",
 Cell[BoxData[
  ButtonBox["NSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSum"]], "InlineFormula"],
 " works is to include a certain number of terms explicitly, and then to try \
and estimate the contribution of the remaining ones. There are three \
approaches to estimating this contribution. The first uses the \
Euler\[Dash]Maclaurin method, and is based on approximating the sum by an \
integral. The second method, known as the Wynn epsilon method, samples a \
number of additional terms in the sum, and then tries to fit them to a \
polynomial multiplied by a decaying exponential. The third approach, useful \
for alternating series, uses an alternating signs method; it also samples a \
number of additional terms and approximates their sum by the ratio of two \
polynomials (Pad\[EAcute] approximation)."
}], "Text",
 CellID->25570],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<EulerMaclaurin\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<WynnEpsilon\>\""], "InlineFormula"],
     ", or ",
     Cell[BoxData["\"\<AlternatingSigns\>\""], "InlineFormula"]
    }], "TableText"]},
   {"NSumTerms", "15", Cell[
    "number of terms to include explicitly", "TableText"]},
   {"VerifyConvergence", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether the convergence of the series should be verified", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7639],

Cell[TextData[{
 "Special options for ",
 Cell[BoxData[
  ButtonBox["NSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSum"]], "InlineFormula"],
 ". "
}], "Caption",
 CellID->5352],

Cell[TextData[{
 "If you do not explicitly specify the method to use, ",
 Cell[BoxData[
  ButtonBox["NSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSum"]], "InlineFormula"],
 " will try to choose between the ",
 Cell[BoxData["EulerMaclaurin"], "InlineFormula"],
 " or ",
 Cell[BoxData["WynnEpsilon"], "InlineFormula"],
 " methods. In any case, some implicit assumptions about the functions you \
are summing have to be made. If these assumptions are not correct, you may \
get inaccurate answers. "
}], "Text",
 CellID->31641],

Cell[TextData[{
 "The most common place to use ",
 Cell[BoxData[
  ButtonBox["NSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSum"]], "InlineFormula"],
 " is in evaluating sums with infinite limits. You can, however, also use it \
for sums with finite limits. By making implicit assumptions about the objects \
you are evaluating, ",
 Cell[BoxData[
  ButtonBox["NSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSum"]], "InlineFormula"],
 " can often avoid doing as many function evaluations as an explicit ",
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " computation would require. "
}], "Text",
 CellID->29644],

Cell[TextData[{
 "This finds the numerical value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n", "=", "0"}], "100",
     LimitsPositioning->True], 
    SuperscriptBox["e", 
     RowBox[{"-", "n"}]]}], TraditionalForm]], "InlineMath"],
 " by extrapolation techniques. "
}], "MathCaption",
 CellID->5775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSum", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", "n"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->7072],

Cell[BoxData["1.5819767068693265`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->22033]
}, Open  ]],

Cell["\<\
You can also get the result, albeit much less efficiently, by constructing \
the symbolic form of the sum, then evaluating it numerically. \
\>", "MathCaption",
 CellID->21694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"-", "n"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "100"}], "}"}]}], "]"}], "//", 
  "N"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->28141],

Cell[BoxData["1.5819767068693267`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->17709]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NProduct"]], "InlineFormula"],
 " works in essentially the same way as ",
 Cell[BoxData[
  ButtonBox["NSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSum"]], "InlineFormula"],
 ", with analogous options. "
}], "Text",
 CellID->28595],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->446071529],

Cell[TextData[ButtonBox["Numerical Operations on Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]], \
"RelatedTutorials",
 CellID->163046772]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerical Evaluation of Sums and Products - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Operations on Functions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NumericalIntegration"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/NumericalSolutionOfPolynomialEquations"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 13.9797618}", "context" -> "", 
    "keywords" -> {
     "AlternatingSigns", "Euler-Maclaurin method", "Method", "NProduct", 
      "NSum", "NSumExtraTerms", "NSumTerms", "numerical products", 
      "numerical summation", "products", "numerical sums", 
      "VerifyConvergence", "verify convergence", "sum convergence", 
      "WynnEpsilon"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Numerical sums and products. This gives a numerical approximation to \
UnderoverscriptBox[\\[Sum], RowBox[{i, =, 1}], Infinity, LimitsPositioning -> \
True]FractionBox[1, RowBox[{SuperscriptBox[i, 3], +, i, !}]]. There is no \
exact result for this sum, so Mathematica leaves it in a symbolic form. ", 
    "synonyms" -> {"3.9.4"}, "title" -> 
    "Numerical Evaluation of Sums and Products", "type" -> "Tutorial", "uri" -> 
    "tutorial/NumericalEvaluationOfSumsAndProducts"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.9.4"->{
  Cell[1930, 60, 104, 2, 70, "Title",
   CellTags->{"S3.9.4", "4.1"},
   CellID->10980]},
 "4.1"->{
  Cell[1930, 60, 104, 2, 70, "Title",
   CellTags->{"S3.9.4", "4.1"},
   CellID->10980]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.9.4", 15675, 521},
 {"4.1", 15775, 525}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1305, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1930, 60, 104, 2, 70, "Title",
 CellTags->{"S3.9.4", "4.1"},
 CellID->10980],
Cell[2037, 64, 2796, 94, 70, "DefinitionBox",
 CellID->13888],
Cell[4836, 160, 64, 1, 70, "Caption",
 CellID->31908],
Cell[4903, 163, 375, 14, 70, "MathCaption",
 CellID->17852],
Cell[CellGroupData[{
Cell[5303, 181, 310, 11, 28, "Input",
 CellID->21660],
Cell[5616, 194, 172, 5, 36, "Output",
 CellID->27829]
}, Open  ]],
Cell[5803, 202, 180, 6, 70, "MathCaption",
 CellID->3243],
Cell[CellGroupData[{
Cell[6008, 212, 308, 11, 28, "Input",
 CellID->4282],
Cell[6319, 225, 335, 12, 58, "Output",
 CellID->17065]
}, Open  ]],
Cell[6669, 240, 217, 8, 70, "MathCaption",
 CellID->29881],
Cell[CellGroupData[{
Cell[6911, 252, 94, 3, 28, "Input",
 CellID->16474],
Cell[7008, 257, 172, 5, 36, "Output",
 CellID->19380]
}, Open  ]],
Cell[7195, 265, 881, 17, 70, "Text",
 CellID->25570],
Cell[8079, 284, 1321, 36, 70, "DefinitionBox3Col",
 CellID->7639],
Cell[9403, 322, 187, 8, 70, "Caption",
 CellID->5352],
Cell[9593, 332, 536, 14, 70, "Text",
 CellID->31641],
Cell[10132, 348, 694, 20, 70, "Text",
 CellID->29644],
Cell[10829, 370, 350, 12, 70, "MathCaption",
 CellID->5775],
Cell[CellGroupData[{
Cell[11204, 386, 231, 8, 70, "Input",
 CellID->7072],
Cell[11438, 396, 173, 5, 36, "Output",
 CellID->22033]
}, Open  ]],
Cell[11626, 404, 186, 4, 70, "MathCaption",
 CellID->21694],
Cell[CellGroupData[{
Cell[11837, 412, 263, 10, 70, "Input",
 CellID->28141],
Cell[12103, 424, 173, 5, 36, "Output",
 CellID->17709]
}, Open  ]],
Cell[12291, 432, 346, 12, 70, "Text",
 CellID->28595],
Cell[CellGroupData[{
Cell[12662, 448, 72, 1, 70, "RelatedTutorialsSection",
 CellID->446071529],
Cell[12737, 451, 198, 5, 70, "RelatedTutorials",
 CellID->163046772]
}, Open  ]]
}, Open  ]],
Cell[12962, 460, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

