(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22671,        724]
NotebookOptionsPosition[     18203,        612]
NotebookOutlinePosition[     21836,        695]
CellTagsIndexPosition[     21745,        689]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalFunctionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Mathematical Functions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Abs" :> Documentation`HelpLookup["paclet:ref/Abs"], "Arg" :> 
          Documentation`HelpLookup["paclet:ref/Arg"], "Ceiling" :> 
          Documentation`HelpLookup["paclet:ref/Ceiling"], "Clip" :> 
          Documentation`HelpLookup["paclet:ref/Clip"], "Conjugate" :> 
          Documentation`HelpLookup["paclet:ref/Conjugate"], "Floor" :> 
          Documentation`HelpLookup["paclet:ref/Floor"], "FractionalPart" :> 
          Documentation`HelpLookup["paclet:ref/FractionalPart"], "I" :> 
          Documentation`HelpLookup["paclet:ref/I"], "Im" :> 
          Documentation`HelpLookup["paclet:ref/Im"], "IntegerPart" :> 
          Documentation`HelpLookup["paclet:ref/IntegerPart"], "Max" :> 
          Documentation`HelpLookup["paclet:ref/Max"], "Min" :> 
          Documentation`HelpLookup["paclet:ref/Min"], "Rationalize" :> 
          Documentation`HelpLookup["paclet:ref/Rationalize"], "Re" :> 
          Documentation`HelpLookup["paclet:ref/Re"], "Rescale" :> 
          Documentation`HelpLookup["paclet:ref/Rescale"], "Round" :> 
          Documentation`HelpLookup["paclet:ref/Round"], "Sign" :> 
          Documentation`HelpLookup["paclet:ref/Sign"], "UnitStep" :> 
          Documentation`HelpLookup["paclet:ref/UnitStep"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Abs\"\>", 2->"\<\"Arg\"\>", 
       3->"\<\"Ceiling\"\>", 4->"\<\"Clip\"\>", 5->"\<\"Conjugate\"\>", 
       6->"\<\"Floor\"\>", 7->"\<\"FractionalPart\"\>", 8->"\<\"I\"\>", 
       9->"\<\"Im\"\>", 10->"\<\"IntegerPart\"\>", 11->"\<\"Max\"\>", 
       12->"\<\"Min\"\>", 13->"\<\"Rationalize\"\>", 14->"\<\"Re\"\>", 
       15->"\<\"Rescale\"\>", 16->"\<\"Round\"\>", 17->"\<\"Sign\"\>", 
       18->"\<\"UnitStep\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Numerical Functions", "Title",
 CellTags->{"S3.2.2", "2.1"},
 CellID->21826],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["IntegerPart",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IntegerPart"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "integer part of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FractionalPart",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FractionalPart"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "fractional part of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Round",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Round"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "integer ",
     Cell[BoxData[
      RowBox[{"\[LeftAngleBracket]", 
       StyleBox["x", "TI"], "\[RightAngleBracket]"}]], "InlineFormula"],
     " closest to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Floor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Floor"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "greatest integer ",
     Cell[BoxData[
      RowBox[{"\[LeftFloor]", 
       StyleBox["x", "TI"], "\[RightFloor]"}]], "InlineFormula"],
     " not larger than ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Ceiling",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Ceiling"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "least integer ",
     Cell[BoxData[
      RowBox[{"\[LeftCeiling]", 
       StyleBox["x", "TI"], "\[RightCeiling]"}]], "InlineFormula"],
     " not smaller than ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Rationalize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Rationalize"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "rational number approximation to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Rationalize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Rationalize"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["dx", "TI"], "]"}], Cell[TextData[{
     "rational approximation within tolerance ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, True, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21345],

Cell["Functions relating real numbers and integers.", "Caption",
 CellID->29204],

Cell[BoxData[GridBox[{
   {
    StyleBox["x", "TI"], 
    RowBox[{
     ButtonBox["IntegerPart",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IntegerPart"], "[", 
     StyleBox["x", "TI"], "]"}], 
    RowBox[{
     ButtonBox["FractionalPart",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FractionalPart"], "[", 
     StyleBox["x", "TI"], "]"}], 
    RowBox[{
     ButtonBox["Round",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Round"], "[", 
     StyleBox["x", "TI"], "]"}], 
    RowBox[{
     ButtonBox["Floor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Floor"], "[", 
     StyleBox["x", "TI"], "]"}], 
    RowBox[{
     ButtonBox["Ceiling",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Ceiling"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {"2.4", "2", "0.4", "2", "2", "3"},
   {"2.5", "2", "0.5", "2", "2", "3"},
   {"2.6", "2", "0.6", "3", "2", "3"},
   {
    RowBox[{"-", "2.4"}], 
    RowBox[{"-", "2"}], 
    RowBox[{"-", "0.4"}], 
    RowBox[{"-", "2"}], 
    RowBox[{"-", "3"}], Cell["-2", "TableText"]},
   {
    RowBox[{"-", "2.5"}], 
    RowBox[{"-", "2"}], 
    RowBox[{"-", "0.5"}], 
    RowBox[{"-", "2"}], 
    RowBox[{"-", "3"}], Cell["-2", "TableText"]},
   {
    RowBox[{"-", "2.6"}], 
    RowBox[{"-", "2"}], 
    RowBox[{"-", "0.6"}], 
    RowBox[{"-", "3"}], 
    RowBox[{"-", "3"}], Cell["-2", "TableText"]}
  }]], "DefinitionBox6Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->6777],

Cell["Extracting integer and fractional parts. ", "Caption",
 CellID->25789],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerPart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerPart"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FractionalPart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FractionalPart"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " can be thought of as extracting digits to the left and right of the \
decimal point. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Round",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Round"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is often used for forcing numbers that are close to integers to be exactly \
integers. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Floor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Floor"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Ceiling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ceiling"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " often arise in working out how many elements there will be in sequences of \
numbers with non\[Hyphen]integer spacings. "
}], "Text",
 CellID->2250],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Sign",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sign"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "1",
     " for ",
     StyleBox["x", "TI"],
     ">",
     "0",
     ", ",
     "-",
     "1",
     " for ",
     StyleBox["x", "TI"],
     "<",
     "0"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["UnitStep",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UnitStep"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "1",
     " for ",
     StyleBox["x", "TI"],
     "\[GreaterEqual]",
     "0",
     ", ",
     "0",
     " for ",
     StyleBox["x", "TI"],
     "<",
     "0"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Abs",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Abs"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "absolute value ",
     Cell[BoxData[
      RowBox[{"\[VerticalSeparator]", 
       StyleBox["x", "TI"], "\[VerticalSeparator]"}]], "InlineFormula"],
     " of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Clip",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Clip"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     StyleBox["x", "TI"],
     " clipped to be between \[Hyphen]1 and + 1"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Rescale",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Rescale"], "[", 
     StyleBox["x", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], Cell[TextData[{
     StyleBox["x", "TI"],
     " rescaled to run from 0 to 1"
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["Max",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Max"], "[", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], "1"], ",", 
       SubscriptBox[
        StyleBox["x", "TI"], "2"], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     RowBox[{
      ButtonBox["Max",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Max"], "[", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], "1"], Cell[", ", "TableText"], 
        SubscriptBox[
         StyleBox["x", "TI"], "2"], Cell[
        ", \[Ellipsis] }, \[Ellipsis] ]", "TableText"], 
        StyleBox[" ", "TR"]}]}]}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "the maximum of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "1"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "2"]], "InlineFormula"],
     ", \[Ellipsis]",
     " "
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["Min",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Min"], "[", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], "1"], ",", 
       SubscriptBox[
        StyleBox["x", "TI"], "2"], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     RowBox[{
      ButtonBox["Min",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Min"], "[", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], "1"], Cell[", ", "TableText"], 
        SubscriptBox[
         StyleBox["x", "TI"], "2"], Cell[
        ", \[Ellipsis] }, \[Ellipsis] ]", "TableText"], 
        StyleBox[" ", "TR"]}]}]}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "the minimum of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "1"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "2"]], "InlineFormula"],
     ", \[Ellipsis]",
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, True, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->27778],

Cell["Numerical functions of real variables. ", "Caption",
 CellID->2160],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["x", "TI"],
     " ",
     StyleBox["+", "MR"],
     " ",
     StyleBox[ButtonBox["I",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/I"], "MR"],
     " ",
     StyleBox["y", "TI"],
     " "
    }]], Cell[TextData[{
     "the complex number ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        StyleBox["x", "TI"], "+", 
        StyleBox["i", "TI"], 
        StyleBox["y", "TI"]}], TraditionalForm]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Re",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Re"]], "InlineFormula"],
     StyleBox["[", "MR"],
     StyleBox["z", "TI"],
     StyleBox["]", "MR"],
     " "
    }]], Cell[TextData[{
     "the real part ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        ButtonBox["Re",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Re"], " ", 
        StyleBox["z", "TI"]}], TraditionalForm]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Im",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Im"]], "InlineFormula"],
     StyleBox["[", "MR"],
     StyleBox["z", "TI"],
     StyleBox["]", "MR"],
     " "
    }]], Cell[TextData[{
     "the imaginary part ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        ButtonBox["Im",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Im"], " ", 
        StyleBox["z", "TI"]}], TraditionalForm]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Conjugate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Conjugate"]], "InlineFormula"],
     StyleBox["[", "MR"],
     StyleBox["z", "TI"],
     StyleBox["]", "MR"],
     " "
    }]], Cell[TextData[{
     "the complex conjugate ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox[
        StyleBox["z", "TI"], "*"], TraditionalForm]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      FormBox[
       OverscriptBox[
        StyleBox["z", "TI"], "_"], TraditionalForm]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Abs",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
     StyleBox["[", "MR"],
     StyleBox["z", "TI"],
     StyleBox["]", "MR"],
     " "
    }]], Cell[TextData[{
     "the absolute value ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[VerticalSeparator]", 
        StyleBox["z", "TI"], "\[VerticalSeparator]"}], TraditionalForm]], 
      "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Arg",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Arg"]], "InlineFormula"],
     StyleBox["[", "MR"],
     StyleBox["z", "TI"],
     StyleBox["]", "MR"],
     " "
    }]], Cell[TextData[{
     "the argument ",
     Cell[BoxData[
      FormBox["\[Phi]", TraditionalForm]], "InlineFormula"],
     " such that ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        StyleBox["z", "TI"], "=", "\[VerticalSeparator]", 
        StyleBox["z", "TI"], "\[VerticalSeparator]", 
        SuperscriptBox[
         StyleBox["e", "TI"], 
         RowBox[{
          StyleBox["i", "TI"], "\[Phi]"}]]}], TraditionalForm]], 
      "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31571],

Cell["Numerical functions of complex variables.", "Caption",
 CellID->15060],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->129642365],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/MathematicalFunctionsOverview"]], "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerical Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Mathematical Functions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/MathematicalFunctionsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NamingConventions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/PiecewiseFunctions"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 14.4328984}", "context" -> "", 
    "keywords" -> {
     "abs", "absolute value", "adjoint", "Arg", "argument of complex number", 
      "ceiling", "clip", "complex conjugate", "complex numbers", "conjugate", 
      "continued fractions", "crop", "Entier", "exact numbers", "floor", 
      "FractionalPart", "functions", "greatest integer function", 
      "Heaviside function", "highest", "Im", "imaginary part", "infimum", 
      "IntegerPart", "integers", "largest", "least integer function", 
      "limiting function", "lowest", "magnitude", 
      "magnitude of complex number", "Max", "maximum", "Min", "minimum", 
      "modulus", "nearest integer function", "normalize", "numbers", 
      "numerical functions", "phase", "ramp", "rational approximation", 
      "rationalize", "re", "real part", "Renormalize", "rescale", "round", 
      "scale", "sign", "Signum", "smallest", "step function", "Supremum", 
      "trim", "truncate to integer", "UnitStep"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Functions relating real numbers and integers. Extracting integer and \
fractional parts. IntegerPart[x] and FractionalPart[x] can be thought of as \
extracting digits to the left and right of the decimal point. Round[x] is \
often used for forcing numbers that are close to integers to be exactly \
integers. Floor[x] and Ceiling[x] often arise in working out how many \
elements there will be in sequences of numbers with non-integer spacings. ", 
    "synonyms" -> {"3.2.2"}, "title" -> "Numerical Functions", "type" -> 
    "Tutorial", "uri" -> "tutorial/NumericalFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.2.2"->{
  Cell[3383, 80, 82, 2, 70, "Title",
   CellTags->{"S3.2.2", "2.1"},
   CellID->21826]},
 "2.1"->{
  Cell[3383, 80, 82, 2, 70, "Title",
   CellTags->{"S3.2.2", "2.1"},
   CellID->21826]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.2.2", 21534, 678},
 {"2.1", 21633, 682}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2758, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3383, 80, 82, 2, 70, "Title",
 CellTags->{"S3.2.2", "2.1"},
 CellID->21826],
Cell[3468, 84, 2865, 93, 70, "DefinitionBox",
 CellID->21345],
Cell[6336, 179, 80, 1, 70, "Caption",
 CellID->29204],
Cell[6419, 182, 1754, 58, 70, "DefinitionBox6Col",
 CellID->6777],
Cell[8176, 242, 76, 1, 70, "Caption",
 CellID->25789],
Cell[8255, 245, 1225, 40, 70, "Text",
 CellID->2250],
Cell[9483, 287, 4467, 163, 70, "DefinitionBox",
 CellID->27778],
Cell[13953, 452, 73, 1, 70, "Caption",
 CellID->2160],
Cell[14029, 455, 3766, 137, 70, "DefinitionBox",
 CellID->31571],
Cell[17798, 594, 76, 1, 70, "Caption",
 CellID->15060],
Cell[CellGroupData[{
Cell[17899, 599, 72, 1, 70, "RelatedTutorialsSection",
 CellID->129642365],
Cell[17974, 602, 175, 4, 70, "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]],
Cell[18176, 610, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

