(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16161,        554]
NotebookOptionsPosition[     11950,        422]
NotebookOutlinePosition[     14401,        487]
CellTagsIndexPosition[     14310,        481]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Mathematics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalMathematicsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Mathematics\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FindMinimum" :> 
          Documentation`HelpLookup["paclet:ref/FindMinimum"], "FindRoot" :> 
          Documentation`HelpLookup["paclet:ref/FindRoot"], "Infinity" :> 
          Documentation`HelpLookup["paclet:ref/Infinity"], "N" :> 
          Documentation`HelpLookup["paclet:ref/N"], "NIntegrate" :> 
          Documentation`HelpLookup["paclet:ref/NIntegrate"], "NMinimize" :> 
          Documentation`HelpLookup["paclet:ref/NMinimize"], "NSolve" :> 
          Documentation`HelpLookup["paclet:ref/NSolve"], "NSum" :> 
          Documentation`HelpLookup["paclet:ref/NSum"], 
          "Numerical Calculations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalCalculationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FindMinimum\"\>", 
       2->"\<\"FindRoot\"\>", 3->"\<\"Infinity\"\>", 4->"\<\"N\"\>", 
       5->"\<\"NIntegrate\"\>", 6->"\<\"NMinimize\"\>", 7->"\<\"NSolve\"\>", 
       8->"\<\"NSum\"\>", 
       9->"\<\"Numerical Calculations\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Numerical Mathematics: Basic Operations", "Title",
 CellTags->{"S1.6.1", "1.1"},
 CellID->20418],

Cell["\<\
Exact symbolic results are usually very desirable when they can be found. In \
many calculations, however, it is not possible to get symbolic results. In \
such cases, you must resort to numerical methods. \
\>", "Text",
 CellID->26489],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["N",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/N"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "numerical value of an expression (see \"",
     ButtonBox["Numerical Calculations",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/NumericalCalculationsOverview"],
     "\")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NIntegrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NIntegrate"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "numerical approximation to ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         SubscriptBox["x", 
          StyleBox["min",
           FontSlant->"Italic"]], 
         SubscriptBox["x", 
          StyleBox["max",
           FontSlant->"Italic"]]], " ", 
        RowBox[{"f", " ", "dx"}]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NSum",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NSum"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["min", "TI"]], ",", 
     ButtonBox["Infinity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Infinity"], "}", "]"}], Cell[TextData[{
     "numerical approximation to ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         SubscriptBox["i", 
          StyleBox["min",
           FontSlant->"Italic"]], "\[Infinity]",
         LimitsPositioning->True], " ", "f"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FindRoot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindRoot"], "[", 
     StyleBox["lhs", "TI"], "==", 
     StyleBox["rhs", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], "}", "]"}], Cell[TextData[{
     "search for a numerical solution to an equation, starting with ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", "=", 
        SubscriptBox["x", "0"]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NSolve"], "[", 
     StyleBox["lhs", "TI"], "==", 
     StyleBox["rhs", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[
    "numerical approximations to all solutions of an equation", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["FindMinimum",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindMinimum"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], "}", "]"}], Cell[TextData[{
     "search for a minimum of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ", starting with ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", "=", 
        SubscriptBox["x", "0"]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NMinimize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NMinimize"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "attempt to find the global minimum of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->159],

Cell["Basic numerical operations. ", "Caption",
 CellID->3449],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " maintains this expression in an exact, symbolic, form. "
}], "MathCaption",
 CellID->12924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"3", "+", 
    RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}], "^", "3"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9072],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"3", "+", 
    SqrtBox["2"]}], ")"}], "3"]], "Output",
 ImageSize->{67, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28583591]
}, Open  ]],

Cell["You can even use standard symbolic operations on it. ", "MathCaption",
 CellID->27008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27967],

Cell[BoxData[
 RowBox[{"45", "+", 
  RowBox[{"29", " ", 
   SqrtBox["2"]}]}]], "Output",
 ImageSize->{72, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->247330276]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " gives you a numerical approximation. "
}], "MathCaption",
 CellID->6477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->18503],

Cell[BoxData["86.01219330881976`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->664120148]
}, Open  ]],

Cell[TextData[{
 "Functions such as ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " always try to get exact results for computations. When they cannot get \
exact results, they typically return unevaluated. You can then find numerical \
approximations by explicitly applying ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ". Functions such as ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " do the calculations numerically from the start, without first trying to \
get an exact result. "
}], "Text",
 CellID->32607],

Cell[TextData[{
 "There is no exact formula for this integral, so ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " returns it unevaluated. "
}], "MathCaption",
 CellID->14196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->12074],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "1", "2"], 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{117, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->165842216]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " to get an approximate numerical result. "
}], "MathCaption",
 CellID->12611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->19019],

Cell[BoxData["0.8164499551233132`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->561583204]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " does the integral numerically from the start. "
}], "MathCaption",
 CellID->11056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->12890],

Cell[BoxData["0.8164499551233132`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->235167629]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->289391380],

Cell[TextData[ButtonBox["Numerical Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalMathematicsOverview"]], "RelatedTutorials",
 CellID->432952818]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerical Mathematics: Basic Operations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Mathematics", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/NumericalMathematicsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/NumericalSumsProductsAndIntegrals"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 15.6516796}", "context" -> "", 
    "keywords" -> {"numerical evaluation", "numerical mathematics"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Exact symbolic results are usually very desirable when they can be \
found. In many calculations, however, it is not possible to get symbolic \
results. In such cases, you must resort to numerical methods. Basic numerical \
operations. Mathematica maintains this expression in an exact, symbolic, \
form. ", "synonyms" -> {"1.6.1"}, "title" -> 
    "Numerical Mathematics: Basic Operations", "type" -> "Tutorial", "uri" -> 
    "tutorial/NumericalMathematics-BasicOperations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.6.1"->{
  Cell[2675, 72, 102, 2, 70, "Title",
   CellTags->{"S1.6.1", "1.1"},
   CellID->20418]},
 "1.1"->{
  Cell[2675, 72, 102, 2, 70, "Title",
   CellTags->{"S1.6.1", "1.1"},
   CellID->20418]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.6.1", 14097, 470},
 {"1.1", 14197, 474}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2050, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2675, 72, 102, 2, 70, "Title",
 CellTags->{"S1.6.1", "1.1"},
 CellID->20418],
Cell[2780, 76, 246, 5, 70, "Text",
 CellID->26489],
Cell[3029, 83, 4144, 132, 70, "DefinitionBox",
 CellID->159],
Cell[7176, 217, 62, 1, 70, "Caption",
 CellID->3449],
Cell[7241, 220, 159, 5, 70, "MathCaption",
 CellID->12924],
Cell[CellGroupData[{
Cell[7425, 229, 167, 6, 28, "Input",
 CellID->9072],
Cell[7595, 237, 241, 9, 44, "Output",
 CellID->28583591]
}, Open  ]],
Cell[7851, 249, 92, 1, 70, "MathCaption",
 CellID->27008],
Cell[CellGroupData[{
Cell[7968, 254, 98, 3, 28, "Input",
 CellID->27967],
Cell[8069, 259, 218, 8, 38, "Output",
 CellID->247330276]
}, Open  ]],
Cell[8302, 270, 250, 9, 70, "MathCaption",
 CellID->6477],
Cell[CellGroupData[{
Cell[8577, 283, 93, 3, 70, "Input",
 CellID->18503],
Cell[8673, 288, 175, 5, 36, "Output",
 CellID->664120148]
}, Open  ]],
Cell[8863, 296, 737, 21, 70, "Text",
 CellID->32607],
Cell[9603, 319, 181, 6, 70, "MathCaption",
 CellID->14196],
Cell[CellGroupData[{
Cell[9809, 329, 246, 8, 70, "Input",
 CellID->12074],
Cell[10058, 339, 333, 11, 51, "Output",
 CellID->165842216]
}, Open  ]],
Cell[10406, 353, 217, 8, 70, "MathCaption",
 CellID->12611],
Cell[CellGroupData[{
Cell[10648, 365, 93, 3, 70, "Input",
 CellID->19019],
Cell[10744, 370, 176, 5, 36, "Output",
 CellID->561583204]
}, Open  ]],
Cell[10935, 378, 224, 7, 70, "MathCaption",
 CellID->11056],
Cell[CellGroupData[{
Cell[11184, 389, 247, 8, 70, "Input",
 CellID->12890],
Cell[11434, 399, 176, 5, 36, "Output",
 CellID->235167629]
}, Open  ]],
Cell[CellGroupData[{
Cell[11647, 409, 72, 1, 70, "RelatedTutorialsSection",
 CellID->289391380],
Cell[11722, 412, 174, 4, 70, "RelatedTutorials",
 CellID->432952818]
}, Open  ]]
}, Open  ]],
Cell[11923, 420, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

