(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13572,        461]
NotebookOptionsPosition[      9224,        335]
NotebookOutlinePosition[     12105,        406]
CellTagsIndexPosition[     12014,        400]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Numerical Operations on Functions" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/NumericalOperationsOnFunctionsOverview"], 
         "The Internals of Mathematica" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TheInternalsOfMathematicaOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Numerical Operations on Functions\"\>", 
      2->"\<\"The Internals of Mathematica\"\>"}, "\<\"related tutorials\"\>",
       
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Numerical Mathematics in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Title",
 CellTags->{"S3.9.1", "1.1"},
 CellID->20411],

Cell[TextData[{
 "One of the important features of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is its ability to give you exact, symbolic, results for computations. \
There are, however, computations where it is just mathematically impossible \
to get exact \[OpenCurlyDoubleQuote]closed form\[CloseCurlyDoubleQuote] \
results. In such cases, you can still often get approximate numerical \
results. "
}], "Text",
 CellID->28233],

Cell[TextData[{
 "There is no \[OpenCurlyDoubleQuote]closed form\[CloseCurlyDoubleQuote] \
result for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "1"], "sin", 
    RowBox[{"(", 
     RowBox[{"sin", 
      RowBox[{"(", "x", ")"}]}], ")"}], "\[DifferentialD]", "x"}], 
   TraditionalForm]], "InlineMath"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " returns the integral in symbolic form. "
}], "MathCaption",
 CellID->7026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9452],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "1"], 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{117, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->622811650]
}, Open  ]],

Cell["\<\
You can now take the symbolic form of the integral, and ask for its \
approximate numerical value. \
\>", "MathCaption",
 CellID->11921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21680],

Cell[BoxData["0.43060610312069103`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->262116729]
}, Open  ]],

Cell[TextData[{
 "When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " cannot find an explicit result for something like a definite integral, it \
returns a symbolic form. You can take this symbolic form, and try to get an \
approximate numerical value by applying ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->3036],

Cell[TextData[{
 "By giving a second argument to ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ", you can specify the numerical precision to use. "
}], "MathCaption",
 CellID->17745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", "40"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->11925],

Cell[BoxData["0.4306061031206906049123773552484657864336080418219974695047`40.\
"], "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->223523752]
}, Open  ]],

Cell[TextData[{
 "If you want to evaluate an integral numerically in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then using ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " and applying ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " to the result is not the most efficient way to do it. It is better instead \
to use the function ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ", which immediately gives a numerical answer, without first trying to get \
an exact, symbolic, result. You should realize that even when ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " does not in the end manage to give you an exact result, it may spend a lot \
of time trying to do so. "
}], "Text",
 CellID->7976],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " evaluates numerical integrals directly, without first trying to get a \
symbolic result. "
}], "MathCaption",
 CellID->31342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->9599],

Cell[BoxData["0.43060610312069103`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->206941118]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Integrate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integrate"], 
    ButtonBox["NIntegrate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NIntegrate"], Cell[
    "definite integrals", "TableText"]},
   {
    ButtonBox["Sum",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Sum"], 
    ButtonBox["NSum",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NSum"], Cell["sums", "TableText"]},
   {
    ButtonBox["Product",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Product"], 
    ButtonBox["NProduct",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NProduct"], Cell["products", "TableText"]},
   {
    ButtonBox["Solve",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Solve"], 
    ButtonBox["NSolve",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NSolve"], Cell[
    "solutions of algebraic equations", "TableText"]},
   {
    ButtonBox["DSolve",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DSolve"], 
    ButtonBox["NDSolve",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NDSolve"], Cell[
    "solutions of differential equations", "TableText"]},
   {
    ButtonBox["Maximize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Maximize"], 
    ButtonBox["NMaximize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NMaximize"], Cell["maximization", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21929],

Cell[TextData[{
 "Symbolic and numerical versions of some ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions."
}], "Caption",
 CellID->5851],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->4352469],

Cell[TextData[ButtonBox["Numerical Operations on Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]], \
"RelatedTutorials",
 CellID->163046772],

Cell[TextData[{
 ButtonBox["The Internals of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheInternalsOfMathematicaOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheInternalsOfMathematicaOverview"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->561417478]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerical Mathematics in Mathematica - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Operations on Functions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/NumericalOperationsOnFunctionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TheUncertaintiesOfNumericalMathematics"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 16.0735654}", "context" -> "", 
    "keywords" -> {
     "DSolve", "Integrate", "maximize", "NDSolve", "NIntegrate", "NMaximize", 
      "NProduct", "NSolve", "NSum", "numerical analogs of symbolic functions",
       "numerical mathematics", "product", "solve", "sum"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "One of the important features of Mathematica is its ability to give you \
exact, symbolic, results for computations. There are, however, computations \
where it is just mathematically impossible to get exact 'closed form' \
results. In such cases, you can still often get approximate numerical \
results. There is no 'closed form' result for SubsuperscriptBox[\\[Integral], \
0, 1]sin(sin(x))dx. Mathematica returns the integral in symbolic form. You \
can now take the symbolic form of the integral, and ask for its approximate \
numerical value. ", "synonyms" -> {"3.9.1"}, "title" -> 
    "Numerical Mathematics in Mathematica", "type" -> "Tutorial", "uri" -> 
    "tutorial/NumericalMathematicsInMathematica"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.9.1"->{
  Cell[1498, 48, 152, 6, 70, "Title",
   CellTags->{"S3.9.1", "1.1"},
   CellID->20411]},
 "1.1"->{
  Cell[1498, 48, 152, 6, 70, "Title",
   CellTags->{"S3.9.1", "1.1"},
   CellID->20411]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.9.1", 11801, 389},
 {"1.1", 11901, 393}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 873, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1498, 48, 152, 6, 70, "Title",
 CellTags->{"S3.9.1", "1.1"},
 CellID->20411],
Cell[1653, 56, 440, 10, 70, "Text",
 CellID->28233],
Cell[2096, 68, 476, 16, 70, "MathCaption",
 CellID->7026],
Cell[CellGroupData[{
Cell[2597, 88, 245, 8, 28, "Input",
 CellID->9452],
Cell[2845, 98, 333, 11, 51, "Output",
 CellID->622811650]
}, Open  ]],
Cell[3193, 112, 146, 4, 70, "MathCaption",
 CellID->11921],
Cell[CellGroupData[{
Cell[3364, 120, 93, 3, 28, "Input",
 CellID->21680],
Cell[3460, 125, 177, 5, 36, "Output",
 CellID->262116729]
}, Open  ]],
Cell[3652, 133, 412, 13, 70, "Text",
 CellID->3036],
Cell[4067, 148, 245, 8, 70, "MathCaption",
 CellID->17745],
Cell[CellGroupData[{
Cell[4337, 160, 312, 11, 28, "Input",
 CellID->11925],
Cell[4652, 173, 224, 6, 36, "Output",
 CellID->223523752]
}, Open  ]],
Cell[4891, 182, 1007, 29, 70, "Text",
 CellID->7976],
Cell[5901, 213, 267, 8, 70, "MathCaption",
 CellID->31342],
Cell[CellGroupData[{
Cell[6193, 225, 246, 8, 70, "Input",
 CellID->9599],
Cell[6442, 235, 177, 5, 36, "Output",
 CellID->206941118]
}, Open  ]],
Cell[6634, 243, 1753, 55, 70, "DefinitionBox3Col",
 CellID->21929],
Cell[8390, 300, 154, 6, 70, "Caption",
 CellID->5851],
Cell[CellGroupData[{
Cell[8569, 310, 70, 1, 70, "RelatedTutorialsSection",
 CellID->4352469],
Cell[8642, 313, 198, 5, 70, "RelatedTutorials",
 CellID->163046772],
Cell[8843, 320, 327, 9, 70, "RelatedTutorials",
 CellID->561417478]
}, Open  ]]
}, Open  ]],
Cell[9197, 333, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

