(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40154,       1410]
NotebookOptionsPosition[     30702,       1108]
NotebookOutlinePosition[     34455,       1193]
CellTagsIndexPosition[     34362,       1187]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/NumbersOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numbers\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Accuracy" :> Documentation`HelpLookup["paclet:ref/Accuracy"], 
          "Automatic" :> Documentation`HelpLookup["paclet:ref/Automatic"], 
          "Chop" :> Documentation`HelpLookup["paclet:ref/Chop"], "False" :> 
          Documentation`HelpLookup["paclet:ref/False"], "InputForm" :> 
          Documentation`HelpLookup["paclet:ref/InputForm"], "MachineNumberQ" :> 
          Documentation`HelpLookup["paclet:ref/MachineNumberQ"], 
          "MachinePrecision" :> 
          Documentation`HelpLookup["paclet:ref/MachinePrecision"], "N" :> 
          Documentation`HelpLookup["paclet:ref/N"], "NumberMarks" :> 
          Documentation`HelpLookup["paclet:ref/NumberMarks"], "Precision" :> 
          Documentation`HelpLookup["paclet:ref/Precision"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"], "$MachinePrecision" :> 
          Documentation`HelpLookup["paclet:ref/$MachinePrecision"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Accuracy\"\>", 
       2->"\<\"Automatic\"\>", 3->"\<\"Chop\"\>", 4->"\<\"False\"\>", 
       5->"\<\"InputForm\"\>", 6->"\<\"MachineNumberQ\"\>", 
       7->"\<\"MachinePrecision\"\>", 8->"\<\"N\"\>", 
       9->"\<\"NumberMarks\"\>", 10->"\<\"Precision\"\>", 11->"\<\"True\"\>", 
       12->"\<\"$MachinePrecision\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Numerical Precision", "Title",
 CellTags->{"S3.1.4", "4.1"},
 CellID->21155],

Cell[TextData[{
 "As discussed in \"",
 ButtonBox["Exact and Approximate Results",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ExactAndApproximateResults"],
 "\", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can handle approximate real numbers with any number of digits. In general, \
the ",
 StyleBox["precision",
  FontSlant->"Italic"],
 " of an approximate real number is the effective number of decimal digits in \
it which are treated as significant for computations. The ",
 StyleBox["accuracy",
  FontSlant->"Italic"],
 " is the effective number of these digits which appear to the right of the \
decimal point. Note that to achieve full consistency in the treatment of \
numbers, precision and accuracy often have values that do not correspond to \
integer numbers of digits. "
}], "Text",
 CellID->23728],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Precision",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Precision"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "the total number of significant decimal digits in ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Accuracy",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Accuracy"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "the number of significant decimal digits to the right of the decimal \
point in ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18655],

Cell["Precision and accuracy of real numbers. ", "Caption",
 CellID->6335],

Cell["\<\
This generates a number with 30\[Hyphen]digit precision. \
\>", "MathCaption",
 CellID->4485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"Pi", "^", "10"}], ",", "30"}], "]"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->15600],

Cell[BoxData["93648.0474760830209737166901849193456359978`30."], "Output",
 ImageSize->{224, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->19629]
}, Open  ]],

Cell["This gives the precision of the number. ", "MathCaption",
 CellID->11754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->17801],

Cell[BoxData["30.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->18075]
}, Open  ]],

Cell["\<\
The accuracy is lower since only some of the digits are to the right of the \
decimal point. \
\>", "MathCaption",
 CellID->15815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "x", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->12937],

Cell[BoxData["25.028501273058666`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->10531]
}, Open  ]],

Cell["\<\
This number has all its digits to the right of the decimal point. \
\>", "MathCaption",
 CellID->23461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "/", 
  RowBox[{"10", "^", "6"}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->610],

Cell[BoxData["0.093648047476083020973716690184919345635997801029`30."], \
"Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->4047]
}, Open  ]],

Cell["Now the accuracy is larger than the precision. ", "MathCaption",
 CellID->27981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Precision", "[", "%", "]"}], ",", 
   RowBox[{"Accuracy", "[", "%", "]"}]}], "}"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->25455],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"30.`", ",", "31.02850127305866`"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->13674]
}, Open  ]],

Cell["\<\
An approximate real number always has some uncertainty in its value, \
associated with digits beyond those known. One can think of precision as \
providing a measure of the relative size of this uncertainty. Accuracy gives \
a measure of the absolute size of the uncertainty. \
\>", "Text",
 CellID->16838],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is set up so that if a number ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " has uncertainty ",
 Cell[BoxData[
  FormBox["\[Delta]", TraditionalForm]], "InlineMath"],
 ", then its true value can lie anywhere in an interval of size ",
 Cell[BoxData[
  FormBox["\[Delta]", TraditionalForm]], "InlineMath"],
 " from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "-", "\[Delta]", "/", "2"}], TraditionalForm]], 
  "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "+", "\[Delta]", "/", "2"}], TraditionalForm]], 
  "InlineMath"],
 ". An approximate number with accuracy ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " is defined to have uncertainty ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", 
    RowBox[{"-", "a"}]], TraditionalForm]], "InlineMath"],
 ", while a non\[Hyphen]zero approximate number with precision ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " is defined to have uncertainty ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[VerticalSeparator]", "x", "\[VerticalSeparator]", 
    SuperscriptBox["10", 
     RowBox[{"-", "p"}]]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->30588],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Precision",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Precision"], "[", 
     StyleBox["x", "TI"], "]"}], 
    RowBox[{"-", 
     SubscriptBox["log", "10"], "(", "\[Delta]", "/", "\[VerticalSeparator]", 
     
     StyleBox["x", "TI"], "\[VerticalSeparator]", ")"}]},
   {
    RowBox[{
     ButtonBox["Accuracy",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Accuracy"], "[", 
     StyleBox["x", "TI"], "]"}], 
    RowBox[{"-", 
     SubscriptBox["log", "10"], "(", "\[Delta]", ")"}]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24811],

Cell["\<\
Definitions of precision and accuracy in terms of uncertainty. \
\>", "Caption",
 CellID->29721],

Cell["\<\
Adding or subtracting a quantity smaller than the uncertainty has no visible \
effect. \
\>", "MathCaption",
 CellID->16016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "-", 
    RowBox[{"10", "^", 
     RowBox[{"-", "26"}]}]}], ",", "x", ",", 
   RowBox[{"x", "+", 
    RowBox[{"10", "^", 
     RowBox[{"-", "26"}]}]}]}], "}"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->15315],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "93648.0474760830209737166901849093456359976`30.", ",", 
   "93648.0474760830209737166901849193456359978`30.", ",", 
   "93648.0474760830209737166901849293456359976`30."}], "}"}]], "Output",
 ImageSize->{468, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->13312]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["N",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/N"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "\[Hyphen]digit precision using arbitrary\[Hyphen]precision numbers"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["N",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/N"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " numerically using machine\[Hyphen]precision numbers"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10697],

Cell["\<\
Numerical evaluation with arbitrary\[Hyphen]precision and \
machine\[Hyphen]precision numbers. \
\>", "Caption",
 CellID->25331],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " distinguishes two kinds of approximate real numbers: ",
 StyleBox["arbitrary\[Hyphen]precision",
  FontSlant->"Italic"],
 " numbers, and ",
 StyleBox["machine\[Hyphen]precision",
  FontSlant->"Italic"],
 " numbers or ",
 StyleBox["machine numbers",
  FontSlant->"Italic"],
 ". Arbitrary\[Hyphen]precision numbers can contain any number of digits, and \
maintain information on their precision. Machine numbers, on the other hand, \
always contain the same number of digits, and maintain no information on \
their precision. "
}], "Text",
 CellID->1943],

Cell[TextData[{
 "Here is a machine\[Hyphen]number approximation to ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->2608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "Pi", "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->19974],

Cell[BoxData["3.141592653589793`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->2069]
}, Open  ]],

Cell["\<\
These are both arbitrary\[Hyphen]precision numbers. \
\>", "MathCaption",
 CellID->20452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"Pi", ",", "4"}], "]"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{"Pi", ",", "20"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->17016],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.1415926535897932385`3.9999999999999996", ",", 
   "3.1415926535897932384626433832795028842`20."}], "}"}]], "Output",
 ImageSize->{212, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->18664]
}, Open  ]],

Cell["\<\
As discussed in more detail below, machine numbers work by making direct use \
of the numerical capabilities of your underlying computer system. As a \
result, computations with them can often be done more quickly. They are \
however much less flexible than arbitrary\[Hyphen]precision numbers, and \
difficult numerical analysis can be needed to determine whether results \
obtained with them are correct. \
\>", "Text",
 CellID->9859],

Cell[BoxData[GridBox[{
   {
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "the precision specification used to indicate machine numbers", 
     "TableText"]},
   {
    ButtonBox["$MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$MachinePrecision"], Cell["\<\
the effective precision for machine numbers on your computer system\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["MachineNumberQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MachineNumberQ"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is a machine number"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22686],

Cell["Machine numbers. ", "Caption",
 CellID->18551],

Cell[TextData[{
 "This returns the symbol ",
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 " to indicate a machine number. "
}], "MathCaption",
 CellID->29087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", 
  RowBox[{"N", "[", "Pi", "]"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->10872],

Cell[BoxData["MachinePrecision"], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->18345]
}, Open  ]],

Cell["\<\
On this computer, machine numbers have slightly less than 16 decimal digits. \
\
\>", "MathCaption",
 CellID->10963],

Cell[CellGroupData[{

Cell[BoxData["$MachinePrecision"], "Input",
 CellLabel->"In[10]:= ",
 CellID->23376],

Cell[BoxData["15.954589770191003`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->23901]
}, Open  ]],

Cell[TextData[{
 "When you enter an approximate real number, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has to decide whether to treat it as a machine number or an arbitrary\
\[Hyphen]precision number. Unless you specify otherwise, then if you give \
less than ",
 Cell[BoxData[
  ButtonBox["$MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachinePrecision"]], "InlineFormula"],
 " digits, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will treat the number as machine precision, and if you give more digits, \
it will treat the number as arbitrary precision."
}], "Text",
 CellID->30813],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["123.4", "MR"],
     " "
    }]], Cell["a machine\[Hyphen]precision number ", "TableText"]},
   {Cell[TextData[{
     StyleBox["123.45678901234567890", "MR"],
     " "
    }]], Cell["\<\
an arbitrary\[Hyphen]precision number on some computer systems \
\>", "TableText"]},
   {Cell[TextData[{
     StyleBox["123.45678901234567890`", "MR"],
     " "
    }]], Cell["\<\
a machine\[Hyphen]precision number on all computer systems \
\>", "TableText"]},
   {Cell[TextData[{
     StyleBox["123.456`200", "MR"],
     " "
    }]], Cell["\<\
an arbitrary\[Hyphen]precision number with 200 digits of precision \
\>", "TableText"]},
   {Cell[TextData[{
     StyleBox["123.456``200", "MR"],
     " "
    }]], Cell["\<\
an arbitrary\[Hyphen]precision number with 200 digits of accuracy \
\>", "TableText"]},
   {Cell[TextData[{
     StyleBox["1.234*^6", "MR"],
     " "
    }]], Cell[TextData[{
     "a machine\[Hyphen]precision number in scientific notation (",
     Cell[BoxData[
      FormBox[
       RowBox[{"1.234", "\[Cross]", 
        SuperscriptBox["10", "6"]}], TraditionalForm]], "InlineFormula"],
     ") "
    }], "TableText"]},
   {Cell[TextData[{
     StyleBox["1.234`200*^6", "MR"],
     " "
    }]], Cell["\<\
a number in scientific notation with 200 digits of precision \
\>", "TableText"]},
   {Cell[TextData[{
     StyleBox["2^^101.111`200", "MR"],
     " "
    }]], Cell[
    "a number in base 2 with 200 binary digits of precision ", "TableText"]},
   {Cell[TextData[{
     StyleBox["2^^101.111`200*^6", "MR"],
     " "
    }]], Cell[TextData[{
     "a number in base 2 scientific notation (",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["101.111", "2"], "\[Cross]", 
        SuperscriptBox["2", "6"]}], TraditionalForm]], "InlineFormula"],
     ") "
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, 
     False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28889],

Cell["Input forms for numbers. ", "Caption",
 CellID->25632],

Cell[TextData[{
 "When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " prints out numbers, it usually tries to give them in a form that will be \
as easy as possible to read. But if you want to take numbers that are printed \
out by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and then later use them as input to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you need to make sure that no information gets lost."
}], "Text",
 CellID->2188],

Cell[TextData[{
 "In standard output form, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " prints a number like this to six digits. "
}], "MathCaption",
 CellID->9012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "Pi", "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->29539],

Cell[BoxData["3.141592653589793`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->14990]
}, Open  ]],

Cell[TextData[{
 "In input form, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " prints all the digits it knows. "
}], "MathCaption",
 CellID->13657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->11718],

Cell["3.141592653589793", "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]//InputForm= ",
 CellID->15615]
}, Open  ]],

Cell["\<\
Here is an arbitrary\[Hyphen]precision number in standard output form. \
\>", "MathCaption",
 CellID->19717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Pi", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->11859],

Cell[BoxData["3.1415926535897932384626433832795028842`20."], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->14072]
}, Open  ]],

Cell[TextData[{
 "In input form, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " explicitly indicates the precision of the number, and gives extra digits \
to make sure the number can be reconstructed correctly. "
}], "MathCaption",
 CellID->13645],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->22449],

Cell["3.1415926535897932384626433832795028842`20.", "Output",
 ImageSize->{301, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]//InputForm= ",
 CellID->9671]
}, Open  ]],

Cell[TextData[{
 "This makes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " not explicitly indicate precision. "
}], "MathCaption",
 CellID->13168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{"%", ",", 
   RowBox[{"NumberMarks", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->7081],

Cell["3.14159265358979323846", "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]//InputForm= ",
 CellID->1171]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["InputForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InputForm"], "[", 
     StyleBox["expr", "TI"], ",", 
     ButtonBox["NumberMarks",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumberMarks"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "use ",
     Cell[BoxData["`"], "InlineFormula"],
     " marks in all approximate numbers"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InputForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InputForm"], "[", 
     StyleBox["expr", "TI"], ",", 
     ButtonBox["NumberMarks",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumberMarks"], "->", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "use ",
     Cell[BoxData["`"], "InlineFormula"],
     " only in arbitrary\[Hyphen]precision numbers"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InputForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InputForm"], "[", 
     StyleBox["expr", "TI"], ",", 
     ButtonBox["NumberMarks",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumberMarks"], "->", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "never use ",
     Cell[BoxData["`"], "InlineFormula"],
     " marks"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->9606],

Cell["Controlling printing of numbers. ", "Caption",
 CellID->11852],

Cell[TextData[{
 "The default setting for the ",
 Cell[BoxData[
  ButtonBox["NumberMarks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberMarks"]], "InlineFormula"],
 " option, both in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " and in functions such as ",
 Cell[BoxData[
  ButtonBox["ToString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["OpenWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenWrite"]], "InlineFormula"],
 " is given by the value of ",
 Cell[BoxData[
  ButtonBox["$NumberMarks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$NumberMarks"]], "InlineFormula"],
 ". By resetting ",
 Cell[BoxData[
  ButtonBox["$NumberMarks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$NumberMarks"]], "InlineFormula"],
 ", therefore, you can globally change the way that numbers are printed in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 "."
}], "Text",
 CellID->5386],

Cell[TextData[{
 "This makes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by default always include number marks in input form. "
}], "MathCaption",
 CellID->20944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$NumberMarks", "=", "True"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->11240],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->531]
}, Open  ]],

Cell["\<\
Even a machine\[Hyphen]precision number is now printed with an explicit \
number mark. \
\>", "MathCaption",
 CellID->20778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{"N", "[", "Pi", "]"}], "]"}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->12879],

Cell["3.141592653589793`", "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]//InputForm= ",
 CellID->6673]
}, Open  ]],

Cell[TextData[{
 "Even with no number marks, ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " still uses ",
 Cell[BoxData[
  RowBox[{"*", "^"}]], "InlineFormula"],
 " for scientific notation. "
}], "MathCaption",
 CellID->7659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Exp", "[", "600", "]"}], ",", "20"}], "]"}], ",", 
   RowBox[{"NumberMarks", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->2792],

Cell["3.7730203009299398234*^260", "Output",
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]//InputForm= ",
 CellID->7298]
}, Open  ]],

Cell[TextData[{
 "In doing numerical computations, it is inevitable that you will sometimes \
end up with results that are less precise than you want. Particularly when \
you get numerical results that are very close to zero, you may well want to \
",
 StyleBox["assume",
  FontSlant->"Italic"],
 " that the results should be exactly zero. The function ",
 Cell[BoxData[
  ButtonBox["Chop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Chop"]], "InlineFormula"],
 " allows you to replace approximate real numbers that are close to zero by \
the exact integer ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "Text",
 CellID->22387],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Chop",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Chop"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "replace all approximate real numbers in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with magnitude less than ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox["10", 
        RowBox[{"-", "10"}]], TraditionalForm]], "InlineFormula"],
     " by 0"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Chop",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Chop"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["dx", "TI"], "]"}], Cell[TextData[{
     "replace numbers with magnitude less than ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"],
     " by 0"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11021],

Cell["Removing numbers close to zero. ", "Caption",
 CellID->26602],

Cell["This computation gives a small imaginary part. ", "MathCaption",
 CellID->31620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"N", "[", 
   RowBox[{"2", " ", "Pi", " ", "I"}], "]"}], "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->20116],

Cell[BoxData[
 RowBox[{"1.`", "\[InvisibleSpace]", "-", 
  RowBox[{"2.4492127076447545`*^-16", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->9847]
}, Open  ]],

Cell[TextData[{
 "You can get rid of the imaginary part using ",
 Cell[BoxData[
  ButtonBox["Chop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Chop"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", "%", "]"}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->13925],

Cell[BoxData["1.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]= ",
 CellID->10002]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->197069758],

Cell[TextData[ButtonBox["Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumbersOverview"]], "RelatedTutorials",
 CellID->54483688]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerical Precision - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numbers", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/NumbersOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DigitsInNumbers"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ArbitraryPrecisionNumbers"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 21.9799666}", "context" -> "", 
    "keywords" -> {
     "absolute error", "accuracy", "approximations", 
      "arbitrary precision numbers", "arithmetic", "chop", "decimal places", 
      "digits", "entry", "errors", "evaluation", "exporting numbers", 
      "fixed precision numbers", "hardware floating point", 
      "high precision numbers", "importing", "input", "InputForm", "length", 
      "low precision numbers", "machine arithmetic", "MachineNumberQ", 
      "MachinePrecision", "machine precision numbers", "Marks", "N", 
      "notation", "NumberMarks", "numbers", "numerical evaluation", 
      "numerical precision", "precision", "printing", "real numbers", 
      "relative error", "Roundoff errors", "scientific notation", 
      "significant figures", "software floating point", "standard form", 
      "truncation of numbers", "uncertainty", "zero", "MachinePrecision", 
      "NumberMarks"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "As discussed in \"Exact and Approximate Results\", Mathematica can \
handle approximate real numbers with any number of digits. In general, the \
precision of an approximate real number is the effective number of decimal \
digits in it which are treated as significant for computations. The accuracy \
is the effective number of these digits which appear to the right of the \
decimal point. Note that to achieve full consistency in the treatment of \
numbers, precision and accuracy often have values that do not correspond to \
integer numbers of digits. Precision and accuracy of real numbers. This \
generates a number with 30-digit precision. ", "synonyms" -> {"3.1.4"}, 
    "title" -> "Numerical Precision", "type" -> "Tutorial", "uri" -> 
    "tutorial/NumericalPrecision"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.1.4"->{
  Cell[2902, 73, 82, 2, 70, "Title",
   CellTags->{"S3.1.4", "4.1"},
   CellID->21155]},
 "4.1"->{
  Cell[2902, 73, 82, 2, 70, "Title",
   CellTags->{"S3.1.4", "4.1"},
   CellID->21155]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.1.4", 34151, 1176},
 {"4.1", 34250, 1180}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2277, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2902, 73, 82, 2, 70, "Title",
 CellTags->{"S3.1.4", "4.1"},
 CellID->21155],
Cell[2987, 77, 831, 21, 70, "Text",
 CellID->23728],
Cell[3821, 100, 993, 30, 70, "DefinitionBox",
 CellID->18655],
Cell[4817, 132, 74, 1, 70, "Caption",
 CellID->6335],
Cell[4894, 135, 103, 3, 70, "MathCaption",
 CellID->4485],
Cell[CellGroupData[{
Cell[5022, 142, 169, 6, 28, "Input",
 CellID->15600],
Cell[5194, 150, 202, 5, 36, "Output",
 CellID->19629]
}, Open  ]],
Cell[5411, 158, 79, 1, 70, "MathCaption",
 CellID->11754],
Cell[CellGroupData[{
Cell[5515, 163, 102, 3, 28, "Input",
 CellID->17801],
Cell[5620, 168, 158, 5, 36, "Output",
 CellID->18075]
}, Open  ]],
Cell[5793, 176, 140, 4, 70, "MathCaption",
 CellID->15815],
Cell[CellGroupData[{
Cell[5958, 184, 101, 3, 70, "Input",
 CellID->12937],
Cell[6062, 189, 173, 5, 36, "Output",
 CellID->10531]
}, Open  ]],
Cell[6250, 197, 113, 3, 70, "MathCaption",
 CellID->23461],
Cell[CellGroupData[{
Cell[6388, 204, 111, 4, 70, "Input",
 CellID->610],
Cell[6502, 210, 210, 6, 36, "Output",
 CellID->4047]
}, Open  ]],
Cell[6727, 219, 86, 1, 70, "MathCaption",
 CellID->27981],
Cell[CellGroupData[{
Cell[6838, 224, 185, 6, 70, "Input",
 CellID->25455],
Cell[7026, 232, 221, 7, 36, "Output",
 CellID->13674]
}, Open  ]],
Cell[7262, 242, 316, 6, 70, "Text",
 CellID->16838],
Cell[7581, 250, 1265, 41, 70, "Text",
 CellID->30588],
Cell[8849, 293, 877, 27, 70, "DefinitionBox",
 CellID->24811],
Cell[9729, 322, 106, 3, 70, "Caption",
 CellID->29721],
Cell[9838, 327, 134, 4, 70, "MathCaption",
 CellID->16016],
Cell[CellGroupData[{
Cell[9997, 335, 266, 10, 70, "Input",
 CellID->15315],
Cell[10266, 347, 360, 10, 54, "Output",
 CellID->13312]
}, Open  ]],
Cell[10641, 360, 1109, 35, 70, "DefinitionBox",
 CellID->10697],
Cell[11753, 397, 138, 4, 70, "Caption",
 CellID->25331],
Cell[11894, 403, 620, 17, 70, "Text",
 CellID->1943],
Cell[12517, 422, 178, 6, 70, "MathCaption",
 CellID->2608],
Cell[CellGroupData[{
Cell[12720, 432, 95, 3, 70, "Input",
 CellID->19974],
Cell[12818, 437, 171, 5, 36, "Output",
 CellID->2069]
}, Open  ]],
Cell[13004, 445, 99, 3, 70, "MathCaption",
 CellID->20452],
Cell[CellGroupData[{
Cell[13128, 452, 223, 8, 70, "Input",
 CellID->17016],
Cell[13354, 462, 289, 9, 36, "Output",
 CellID->18664]
}, Open  ]],
Cell[13658, 474, 446, 8, 70, "Text",
 CellID->9859],
Cell[14107, 484, 1093, 32, 70, "DefinitionBox",
 CellID->22686],
Cell[15203, 518, 52, 1, 70, "Caption",
 CellID->18551],
Cell[15258, 521, 249, 8, 70, "MathCaption",
 CellID->29087],
Cell[CellGroupData[{
Cell[15532, 533, 131, 4, 70, "Input",
 CellID->10872],
Cell[15666, 539, 171, 5, 36, "Output",
 CellID->18345]
}, Open  ]],
Cell[15852, 547, 126, 4, 70, "MathCaption",
 CellID->10963],
Cell[CellGroupData[{
Cell[16003, 555, 84, 2, 70, "Input",
 CellID->23376],
Cell[16090, 559, 174, 5, 36, "Output",
 CellID->23901]
}, Open  ]],
Cell[16279, 567, 631, 17, 70, "Text",
 CellID->30813],
Cell[16913, 586, 2414, 76, 70, "DefinitionBox",
 CellID->28889],
Cell[19330, 664, 60, 1, 70, "Caption",
 CellID->25632],
Cell[19393, 667, 468, 14, 70, "Text",
 CellID->2188],
Cell[19864, 683, 174, 6, 70, "MathCaption",
 CellID->9012],
Cell[CellGroupData[{
Cell[20063, 693, 96, 3, 70, "Input",
 CellID->29539],
Cell[20162, 698, 173, 5, 36, "Output",
 CellID->14990]
}, Open  ]],
Cell[20350, 706, 156, 6, 70, "MathCaption",
 CellID->13657],
Cell[CellGroupData[{
Cell[20531, 716, 103, 3, 70, "Input",
 CellID->11718],
Cell[20637, 721, 175, 5, 50, "Output",
 CellID->15615]
}, Open  ]],
Cell[20827, 729, 118, 3, 70, "MathCaption",
 CellID->19717],
Cell[CellGroupData[{
Cell[20970, 736, 120, 4, 70, "Input",
 CellID->11859],
Cell[21093, 742, 199, 5, 36, "Output",
 CellID->14072]
}, Open  ]],
Cell[21307, 750, 255, 7, 70, "MathCaption",
 CellID->13645],
Cell[CellGroupData[{
Cell[21587, 761, 103, 3, 70, "Input",
 CellID->22449],
Cell[21693, 766, 200, 5, 50, "Output",
 CellID->9671]
}, Open  ]],
Cell[21908, 774, 155, 6, 70, "MathCaption",
 CellID->13168],
Cell[CellGroupData[{
Cell[22088, 784, 164, 5, 70, "Input",
 CellID->7081],
Cell[22255, 791, 179, 5, 50, "Output",
 CellID->1171]
}, Open  ]],
Cell[22449, 799, 2064, 64, 70, "DefinitionBox",
 CellID->9606],
Cell[24516, 865, 68, 1, 70, "Caption",
 CellID->11852],
Cell[24587, 868, 1133, 38, 70, "Text",
 CellID->5386],
Cell[25723, 908, 174, 6, 70, "MathCaption",
 CellID->20944],
Cell[CellGroupData[{
Cell[25922, 918, 104, 3, 70, "Input",
 CellID->11240],
Cell[26029, 923, 157, 5, 36, "Output",
 CellID->531]
}, Open  ]],
Cell[26201, 931, 134, 4, 70, "MathCaption",
 CellID->20778],
Cell[CellGroupData[{
Cell[26360, 939, 132, 4, 70, "Input",
 CellID->12879],
Cell[26495, 945, 175, 5, 50, "Output",
 CellID->6673]
}, Open  ]],
Cell[26685, 953, 305, 11, 70, "MathCaption",
 CellID->7659],
Cell[CellGroupData[{
Cell[27015, 968, 254, 8, 70, "Input",
 CellID->2792],
Cell[27272, 978, 183, 5, 50, "Output",
 CellID->7298]
}, Open  ]],
Cell[27470, 986, 637, 17, 70, "Text",
 CellID->22387],
Cell[28110, 1005, 1162, 37, 70, "DefinitionBox",
 CellID->11021],
Cell[29275, 1044, 67, 1, 70, "Caption",
 CellID->26602],
Cell[29345, 1047, 86, 1, 70, "MathCaption",
 CellID->31620],
Cell[CellGroupData[{
Cell[29456, 1052, 160, 5, 70, "Input",
 CellID->20116],
Cell[29619, 1059, 259, 7, 36, "Output",
 CellID->9847]
}, Open  ]],
Cell[29893, 1069, 216, 8, 70, "MathCaption",
 CellID->31622],
Cell[CellGroupData[{
Cell[30134, 1081, 98, 3, 70, "Input",
 CellID->13925],
Cell[30235, 1086, 158, 5, 36, "Output",
 CellID->10002]
}, Open  ]],
Cell[CellGroupData[{
Cell[30430, 1096, 72, 1, 70, "RelatedTutorialsSection",
 CellID->197069758],
Cell[30505, 1099, 143, 3, 70, "RelatedTutorials",
 CellID->54483688]
}, Open  ]]
}, Open  ]],
Cell[30675, 1106, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

