(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     59658,       2098]
NotebookOptionsPosition[     48066,       1719]
NotebookOutlinePosition[     51783,       1805]
CellTagsIndexPosition[     51690,       1799]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Strings and Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StringsAndCharactersOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Strings and Characters\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sort" :> Documentation`HelpLookup["paclet:ref/Sort"], 
          "StringCount" :> Documentation`HelpLookup["paclet:ref/StringCount"],
           "StringDrop" :> Documentation`HelpLookup["paclet:ref/StringDrop"], 
          "StringFreeQ" :> Documentation`HelpLookup["paclet:ref/StringFreeQ"],
           "StringInsert" :> 
          Documentation`HelpLookup["paclet:ref/StringInsert"], "StringJoin" :> 
          Documentation`HelpLookup["paclet:ref/StringJoin"], "StringLength" :> 
          Documentation`HelpLookup["paclet:ref/StringLength"], 
          "StringPosition" :> 
          Documentation`HelpLookup["paclet:ref/StringPosition"], 
          "StringReplace" :> 
          Documentation`HelpLookup["paclet:ref/StringReplace"], 
          "StringReplaceList" :> 
          Documentation`HelpLookup["paclet:ref/StringReplaceList"], 
          "StringReplacePart" :> 
          Documentation`HelpLookup["paclet:ref/StringReplacePart"], 
          "StringReverse" :> 
          Documentation`HelpLookup["paclet:ref/StringReverse"], "StringSplit" :> 
          Documentation`HelpLookup["paclet:ref/StringSplit"], "StringTake" :> 
          Documentation`HelpLookup["paclet:ref/StringTake"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Sort\"\>", 2->"\<\"StringCount\"\>",
        3->"\<\"StringDrop\"\>", 4->"\<\"StringFreeQ\"\>", 
       5->"\<\"StringInsert\"\>", 6->"\<\"StringJoin\"\>", 
       7->"\<\"StringLength\"\>", 8->"\<\"StringPosition\"\>", 
       9->"\<\"StringReplace\"\>", 10->"\<\"StringReplaceList\"\>", 
       11->"\<\"StringReplacePart\"\>", 12->"\<\"StringReverse\"\>", 
       13->"\<\"StringSplit\"\>", 
       14->"\<\"StringTake\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Operations on Strings", "Title",
 CellTags->{"S2.8.2", "2.1"},
 CellID->16303],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a variety of functions for manipulating strings. Most of these \
functions are based on viewing strings as a sequence of characters, and many \
of the functions are analogous to ones for manipulating lists. "
}], "Text",
 CellID->25375],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], "1"], "<>", 
      SubscriptBox[
       StyleBox["s", "TI"], "2"], "<>", 
      StyleBox["\[Ellipsis]", "TR"]}], Cell["  or  ", "TableText"], 
     RowBox[{
      ButtonBox["StringJoin",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StringJoin"], "[", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["s", "TI"], "1"], Cell[", ", "TableText"], 
        SubscriptBox[
         StyleBox["s", "TI"], "2"], Cell[", \[Ellipsis] }]", "TableText"], 
        StyleBox[" ", "TR"]}]}]}]}], "\[SpanFromLeft]"},
   {"", Cell["join several strings together", "TableText"]},
   {
    RowBox[{
     ButtonBox["StringLength",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringLength"], "[", 
     StyleBox["s", "TI"], "]"}], Cell[
    "give the number of characters in a string", "TableText"]},
   {
    RowBox[{
     ButtonBox["StringReverse",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringReverse"], "[", 
     StyleBox["s", "TI"], "]"}], Cell[
    "reverse the characters in a string", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->667],

Cell["Operations on complete strings. ", "Caption",
 CellID->25392],

Cell[TextData[{
 "You can join together any number of strings using ",
 Cell[BoxData["<>"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<aaaaaaa\>\"", "<>", "\"\<bbb\>\"", "<>", 
  "\"\<cccccccccc\>\""}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17108],

Cell[BoxData["\<\"aaaaaaabbbcccccccccc\"\>"], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1596414716]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringLength",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringLength"]], "InlineFormula"],
 " gives the number of characters in a string. "
}], "MathCaption",
 CellID->29998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringLength", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11258],

Cell[BoxData["20"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->948785716]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringReverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReverse"]], "InlineFormula"],
 " reverses the characters in a string. "
}], "MathCaption",
 CellID->15693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReverse", "[", "\"\<A string.\>\"", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->24001],

Cell[BoxData["\<\".gnirts A\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->760471622]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["StringTake",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringTake"], "[", 
     StyleBox["s", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "make a string by taking the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " characters from ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringTake",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringTake"], "[", 
     StyleBox["s", "TI"], ",", "{", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "take the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula"],
     " character from ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringTake",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringTake"], "[", 
     StyleBox["s", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], "}", "]"}], Cell[TextData[{
     "take characters ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], "1"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], "2"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringDrop",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringDrop"], "[", 
     StyleBox["s", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "make a string by dropping the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " characters in ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringDrop",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringDrop"], "[", 
     StyleBox["s", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], "}", "]"}], Cell[TextData[{
     "drop characters ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], "1"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], "2"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30516],

Cell["Taking and dropping substrings. ", "Caption",
 CellID->21618],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringTake",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringTake"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["StringDrop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringDrop"]], "InlineFormula"],
 " are the analogs for strings of ",
 Cell[BoxData[
  ButtonBox["Take",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Take"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Drop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Drop"]], "InlineFormula"],
 " for lists. Like ",
 Cell[BoxData[
  ButtonBox["Take",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Take"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Drop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Drop"]], "InlineFormula"],
 ", they use standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sequence specifications, so that, for example, negative numbers count \
character positions from the end of a string. Note that the first character \
of a string is taken to have position ",
 Cell[BoxData["1"], "InlineFormula"],
 ". "
}], "Text",
 CellID->7718],

Cell["Here is a sample string. ", "MathCaption",
 CellID->23668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"alpha", "=", "\"\<ABCDEFGHIJKLMNOPQRSTUVWXYZ\>\""}]], "Input",
 CellLabel->"In[4]:=",
 CellID->20536],

Cell[BoxData["\<\"ABCDEFGHIJKLMNOPQRSTUVWXYZ\"\>"], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->900171046]
}, Open  ]],

Cell[TextData[{
 "This takes the first five characters from ",
 Cell[BoxData["alpha"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->6523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", 
  RowBox[{"alpha", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1797],

Cell[BoxData["\<\"ABCDE\"\>"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->2106134881]
}, Open  ]],

Cell[TextData[{
 "Here is the fifth character in ",
 Cell[BoxData["alpha"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", 
  RowBox[{"alpha", ",", 
   RowBox[{"{", "5", "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->28615],

Cell[BoxData["\<\"E\"\>"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1425102066]
}, Open  ]],

Cell["\<\
This drops the characters 10 through 2, counting from the end of the string. \
\
\>", "MathCaption",
 CellID->11928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringDrop", "[", 
  RowBox[{"alpha", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "10"}], ",", 
     RowBox[{"-", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->14115],

Cell[BoxData["\<\"ABCDEFGHIJKLMNOPZ\"\>"], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1076011489]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["StringInsert",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringInsert"], "[", 
     StyleBox["s", "TI"], ",", 
     StyleBox["snew", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "insert the string ",
     Cell[BoxData[
      StyleBox["snew", "TI"]], "InlineFormula"],
     " at position ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringInsert",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringInsert"], "[", 
     StyleBox["s", "TI"], ",", 
     StyleBox["snew", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "insert several copies of ",
     Cell[BoxData[
      StyleBox["snew", "TI"]], "InlineFormula"],
     " into ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20343],

Cell["Inserting into a string. ", "Caption",
 CellID->30248],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringInsert",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringInsert"], "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    StyleBox["snew", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " is set up to produce a string whose ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineMath"],
 " character is the first character of ",
 Cell[BoxData[
  StyleBox["snew", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->18710],

Cell[TextData[{
 "This produces a new string whose fourth character is the first character of \
the string ",
 Cell[BoxData["\"\<XX\>\""], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->15544],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringInsert", "[", 
  RowBox[{"\"\<abcdefgh\>\"", ",", "\"\<XX\>\"", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->6210],

Cell[BoxData["\<\"abcXXdefgh\"\>"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->418776159]
}, Open  ]],

Cell["Negative positions are counted from the end of the string. ", \
"MathCaption",
 CellID->18040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringInsert", "[", 
  RowBox[{"\"\<abcdefgh\>\"", ",", "\"\<XXX\>\"", ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->8337],

Cell[BoxData["\<\"abcdefghXXX\"\>"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->490272856]
}, Open  ]],

Cell[TextData[{
 "Each copy of ",
 Cell[BoxData["\"\<XXX\>\""], "InlineFormula"],
 " is inserted at the specified position in the original string. "
}], "MathCaption",
 CellID->17034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringInsert", "[", 
  RowBox[{"\"\<abcdefgh\>\"", ",", "\"\<XXX\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->3744],

Cell[BoxData["\<\"aXXXbcXXXdefghXXX\"\>"], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->340130216]
}, Open  ]],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["Riffle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Riffle"]], "InlineFormula"],
 " to add a space between the words in a list. "
}], "MathCaption",
 CellID->619321384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "[", 
  RowBox[{"Riffle", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "\"\<cat\>\"", ",", "\"\<in\>\"", ",", "\"\<the\>\"", ",", 
      "\"\<hat\>\""}], "}"}], ",", "\"\< \>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->6066578],

Cell[BoxData["\<\"cat in the hat\"\>"], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->1621620613]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["StringReplacePart",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringReplacePart"], "[", 
     StyleBox["s", "TI"], ",", 
     StyleBox["snew", "TI"], ",", "{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "replace the characters at positions ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " by the string ",
     Cell[BoxData[
      StyleBox["snew", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringReplacePart",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringReplacePart"], "[", 
     StyleBox["s", "TI"], ",", 
     StyleBox["snew", "TI"], ",", "{", "{", 
     SubscriptBox[
      StyleBox["m", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["m", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "replace several substrings in ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " by ",
     Cell[BoxData[
      StyleBox["snew", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringReplacePart",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringReplacePart"], "[", 
     RowBox[{
      StyleBox["s", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["snew", "TI"], "1"], ",", 
        SubscriptBox[
         StyleBox["snew", "TI"], "2"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["m", "TI"], "1"], Cell[", ", "TableText"], 
         SubscriptBox[
          StyleBox["n", "TI"], "1"], Cell["}, {", "TableText"], 
         SubscriptBox[
          StyleBox["m", "TI"], "2"], Cell[", ", "TableText"], 
         SubscriptBox[
          StyleBox["n", "TI"], "2"], Cell["}, \[Ellipsis] }]", "TableText"], 
         StyleBox[" ", "TR"]}]}]}]}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "replace substrings in ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " by the corresponding ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["snew", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->26068],

Cell["Replacing parts of a string. ", "Caption",
 CellID->13235],

Cell[TextData[{
 "This replaces characters 2 through 6 by the string ",
 Cell[BoxData["\"\<XXX\>\""], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1104],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplacePart", "[", 
  RowBox[{"\"\<abcdefgh\>\"", ",", "\"\<XXX\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->20032],

Cell[BoxData["\<\"aXXXgh\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->46679584]
}, Open  ]],

Cell[TextData[{
 "This replaces two runs of characters by the string ",
 Cell[BoxData["\"\<XXX\>\""], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplacePart", "[", 
  RowBox[{"\"\<abcdefgh\>\"", ",", "\"\<XXX\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->13197],

Cell[BoxData["\<\"aXXXdXXX\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->1220539503]
}, Open  ]],

Cell["\<\
Now the two runs of characters are replaced by different strings. \
\>", "MathCaption",
 CellID->24853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplacePart", "[", 
  RowBox[{"\"\<abcdefgh\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<XXX\>\"", ",", "\"\<YYYY\>\""}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->27223],

Cell[BoxData["\<\"aXXXdYYYY\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->1341249660]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["StringPosition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringPosition"], "[", 
     StyleBox["s", "TI"], ",", 
     StyleBox["sub", "TI"], "]"}], Cell[TextData[{
     "give a list of the starting and ending positions at which ",
     Cell[BoxData[
      StyleBox["sub", "TI"]], "InlineFormula"],
     " appears as a substring of ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringPosition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringPosition"], "[", 
     StyleBox["s", "TI"], ",", 
     StyleBox["sub", "TI"], ",", 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "include only the first ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " occurrences of ",
     Cell[BoxData[
      StyleBox["sub", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringPosition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringPosition"], "[", 
     StyleBox["s", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["sub", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["sub", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "include occurrences of any of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23233],

Cell["Finding positions of substrings. ", "Caption",
 CellID->30962],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 " to find where a particular substring appears within a given string. ",
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 " returns a list, each of whose elements corresponds to an occurrence of the \
substring. The elements consist of lists giving the starting and ending \
character positions for the substring. These lists are in the form used as \
sequence specifications in ",
 Cell[BoxData[
  ButtonBox["StringTake",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringTake"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StringDrop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringDrop"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["StringReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplacePart"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->19990],

Cell[TextData[{
 "This gives a list of the positions of the substring ",
 Cell[BoxData["\"\<abc\>\""], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21428],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<abcdabcdaabcabcd\>\"", ",", "\"\<abc\>\""}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->14124],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "15"}], "}"}]}], "}"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->1109793971]
}, Open  ]],

Cell[TextData[{
 "This gives only the first occurrence of ",
 Cell[BoxData["\"\<abc\>\""], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<abcdabcdaabcabcd\>\"", ",", "\"\<abc\>\"", ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->30425],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", "3"}], "}"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->568143872]
}, Open  ]],

Cell[TextData[{
 "This shows where both ",
 Cell[BoxData["\"\<abc\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<cd\>\""], "InlineFormula"],
 " appear. By default, overlaps are included. "
}], "MathCaption",
 CellID->23286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<abcdabcdcd\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<abc\>\"", ",", "\"\<cd\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->6535],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10"}], "}"}]}], "}"}]], "Output",
 ImageSize->{266, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->307965430]
}, Open  ]],

Cell["This does not include overlaps. ", "MathCaption",
 CellID->2662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<abcdabcdcd\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<abc\>\"", ",", "\"\<cd\>\""}], "}"}], ",", 
   RowBox[{"Overlaps", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->24363],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "10"}], "}"}]}], "}"}]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->1995646132]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["StringCount",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringCount"], "[", 
     StyleBox["s", "TI"], ",", 
     StyleBox["sub", "TI"], "]"}], Cell[TextData[{
     "count the occurrences of ",
     Cell[BoxData[
      StyleBox["sub", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringCount",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringCount"], "[", 
     StyleBox["s", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["sub", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["sub", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "count occurrences of any of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringFreeQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringFreeQ"], "[", 
     StyleBox["s", "TI"], ",", 
     StyleBox["sub", "TI"], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " is free of ",
     Cell[BoxData[
      StyleBox["sub", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringFreeQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringFreeQ"], "[", 
     StyleBox["s", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["sub", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["sub", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " is free of all the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->8667],

Cell["Testing for substrings. ", "Caption",
 CellID->1437],

Cell["\<\
This counts occurrences of either substring, by default not including \
overlaps. \
\>", "MathCaption",
 CellID->15155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCount", "[", 
  RowBox[{"\"\<abcdabcdcd\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<abc\>\"", ",", "\"\<cd\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->26575],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->1289234365]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["StringReplace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringReplace"], "[", 
     StyleBox["s", "TI"], ",", 
     StyleBox["sb", "TI"], "->", 
     StyleBox["sbnew", "TI"], "]"}], Cell[TextData[{
     "replace ",
     Cell[BoxData[
      StyleBox["sb", "TI"]], "InlineFormula"],
     " by ",
     Cell[BoxData[
      StyleBox["sbnew", "TI"]], "InlineFormula"],
     " wherever it appears in ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringReplace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringReplace"], "[", 
     StyleBox["s", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["sb", "TI"], "1"], "->", 
     SubscriptBox[
      StyleBox["sbnew", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["sb", "TI"], "2"], "->", 
     SubscriptBox[
      StyleBox["sbnew", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "replace ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["sb", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " by the corresponding ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["sbnew", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringReplace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringReplace"], "[", 
     StyleBox["s", "TI"], ",", 
     StyleBox["rules", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "do at most ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " replacements"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringReplaceList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringReplaceList"], "[", 
     StyleBox["s", "TI"], ",", 
     StyleBox["rules", "TI"], "]"}], Cell["\<\
give a list of the strings obtained by making each possible single \
replacement\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["StringReplaceList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringReplaceList"], "[", 
     StyleBox["s", "TI"], ",", 
     StyleBox["rules", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "give at most ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " results"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14970],

Cell["Replacing substrings according to rules. ", "Caption",
 CellID->13663],

Cell[TextData[{
 "This replaces all occurrences of the character ",
 Cell[BoxData["a"], "InlineFormula"],
 " by the string ",
 Cell[BoxData["XX"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abcdabcdaabcabcd\>\"", ",", 
   RowBox[{"\"\<a\>\"", "->", "\"\<XX\>\""}]}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->21763],

Cell[BoxData["\<\"XXbcdXXbcdXXXXbcXXbcd\"\>"], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->374389906]
}, Open  ]],

Cell[TextData[{
 "This replaces ",
 Cell[BoxData["abc"], "InlineFormula"],
 " by ",
 Cell[BoxData["Y"], "InlineFormula"],
 ", and ",
 Cell[BoxData["d"], "InlineFormula"],
 " by ",
 Cell[BoxData["XXX"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abcdabcdaabcabcd\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<abc\>\"", "->", "\"\<Y\>\""}], ",", 
     RowBox[{"\"\<d\>\"", "->", "\"\<XXX\>\""}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->26147],

Cell[BoxData["\<\"YXXXYXXXaYYXXX\"\>"], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->482544064]
}, Open  ]],

Cell[TextData[{
 "The first occurrence of ",
 Cell[BoxData["cde"], "InlineFormula"],
 " is not replaced because it overlaps with ",
 Cell[BoxData["abc"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->29509],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abcde abacde\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<abc\>\"", "->", "\"\<X\>\""}], ",", 
     RowBox[{"\"\<cde\>\"", "->", "\"\<Y\>\""}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->17664],

Cell[BoxData["\<\"Xde abaY\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->1073265384]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringReplace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplace"]], "InlineFormula"],
 " scans a string from left to right, doing all the replacements it can, and \
then returning the resulting string. Sometimes, however, it is useful to see \
what all possible single replacements would give. You can get a list of all \
these results using ",
 Cell[BoxData[
  ButtonBox["StringReplaceList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplaceList"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->7524],

Cell[TextData[{
 "This gives a list of the results of replacing each of the ",
 Cell[BoxData["a"], "InlineFormula"],
 "\[CloseCurlyQuote]s. "
}], "MathCaption",
 CellID->18934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplaceList", "[", 
  RowBox[{"\"\<aaaaa\>\"", ",", 
   RowBox[{"\"\<a\>\"", "->", "\"\<X\>\""}]}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->9806],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Xaaaa\"\>", ",", "\<\"aXaaa\"\>", ",", "\<\"aaXaa\"\>", 
   ",", "\<\"aaaXa\"\>", ",", "\<\"aaaaX\"\>"}], "}"}]], "Output",
 ImageSize->{238, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->2094362127]
}, Open  ]],

Cell["This shows the results of all possible single replacements. ", \
"MathCaption",
 CellID->28590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplaceList", "[", 
  RowBox[{"\"\<abcde abacde\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<abc\>\"", "->", "\"\<X\>\""}], ",", 
     RowBox[{"\"\<cde\>\"", "->", "\"\<Y\>\""}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->20634],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Xde abacde\"\>", ",", "\<\"abY abacde\"\>", 
   ",", "\<\"abcde abaY\"\>"}], "}"}]], "Output",
 ImageSize->{251, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->2052966686]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["StringSplit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringSplit"], "[", 
     StyleBox["s", "TI"], "]"}], Cell[TextData[{
     "split ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " into substrings delimited by whitespace"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringSplit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringSplit"], "[", 
     StyleBox["s", "TI"], ",", 
     StyleBox["del", "TI"], "]"}], Cell[TextData[{
     "split at delimiter ",
     Cell[BoxData[
      StyleBox["del", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringSplit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringSplit"], "[", 
     StyleBox["s", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["del", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["del", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "split at any of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["del", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringSplit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringSplit"], "[", 
     StyleBox["s", "TI"], ",", 
     StyleBox["del", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "split into at most ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " substrings"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->6862],

Cell["Splitting strings. ", "Caption",
 CellID->10580],

Cell["This splits the string at every run of spaces. ", "MathCaption",
 CellID->4919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", "\"\<a b::c d::e f g\>\"", "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->2526],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b::c\"\>", ",", "\<\"d::e\"\>", 
   ",", "\<\"f\"\>", ",", "\<\"g\"\>"}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->835203349]
}, Open  ]],

Cell[TextData[{
 "This splits at each ",
 Cell[BoxData["\"\<::\>\""], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->4850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<a b::c d::e f g\>\"", ",", "\"\<::\>\""}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->10944],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a b\"\>", ",", "\<\"c d\"\>", ",", "\<\"e f g\"\>"}], 
  "}"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->1501897755]
}, Open  ]],

Cell["This splits at each colon or space. ", "MathCaption",
 CellID->2716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<a b::c d::e f g\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<:\>\"", ",", "\"\< \>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->14061],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"\"\>", ",", "\<\"c\"\>", 
   ",", "\<\"d\"\>", ",", "\<\"\"\>", ",", "\<\"e\"\>", ",", "\<\"f\"\>", 
   ",", "\<\"g\"\>"}], "}"}]], "Output",
 ImageSize->{157, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->559214453]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["StringSplit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringSplit"], "[", 
     StyleBox["s", "TI"], ",", 
     StyleBox["del", "TI"], "->", 
     StyleBox["rhs", "TI"], "]"}], Cell[TextData[{
     "insert ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " at the position of each delimiter"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringSplit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringSplit"], "[", 
     StyleBox["s", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["del", "TI"], "1"], "->", 
     SubscriptBox[
      StyleBox["rhs", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["del", "TI"], "2"], "->", 
     SubscriptBox[
      StyleBox["rhs", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "insert ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["rhs", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the position of the corresponding ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["del", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21006],

Cell["Splitting strings with replacements for delimiters. ", "Caption",
 CellID->30826],

Cell[TextData[{
 "This inserts ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}]], "InlineFormula"],
 " at each ",
 Cell[BoxData["::"], "InlineFormula"],
 " delimiter. "
}], "MathCaption",
 CellID->703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<a b::c d::e f g\>\"", ",", 
   RowBox[{"\"\<::\>\"", "->", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->13039],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a b\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "\<\"c d\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "\<\"e f g\"\>"}], "}"}]], "Output",
 ImageSize->{219, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->254585153]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Sort",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sort"], "[", "{", 
     SubscriptBox[
      StyleBox["s", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], "3"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[
    "sort a list of strings", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->27214],

Cell["Sorting strings. ", "Caption",
 CellID->4751],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 " sorts strings into standard dictionary order. "
}], "MathCaption",
 CellID->4432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"{", 
   RowBox[{
   "\"\<cat\>\"", ",", "\"\<fish\>\"", ",", "\"\<catfish\>\"", ",", 
    "\"\<Cat\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->7985],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"cat\"\>", ",", "\<\"Cat\"\>", ",", "\<\"catfish\"\>", 
   ",", "\<\"fish\"\>"}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->873293390]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->896973879],

Cell[TextData[ButtonBox["Strings and Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StringsAndCharactersOverview"]], "RelatedTutorials",
 CellID->25846920]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Operations on Strings - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Strings and Characters", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/StringsAndCharactersOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/PropertiesOfStrings"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/CharactersInStrings"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 30.9333208}", "context" -> "", 
    "keywords" -> {
     "<>", "alphabetizing", "appending", "breaking strings", 
      "catenating strings", "characters", "collating", 
      "concatenating strings", "count", "delimiters", "dividing strings", 
      "editing", "equality testing", "implode", "index", "insertion", 
      "joining strings", "length", "manipulation", "multiway systems", 
      "ordering", "parts", "position", "Prepending", "production rules", 
      "replacements", "reverse", "rewriting", "search", 
      "sequence specifications", "sequential substitution systems", "sort", 
      "sorting", "splicing", "splitting strings", "StringCount", 
      "string count", "StringDrop", "string drop", "StringFreeQ", 
      "StringInsert", "string insert", "StringJoin", "string join", 
      "StringLength", "string length", "StringPosition", "string position", 
      "StringReplace", "string replace", "StringReplaceList", 
      "StringReplacePart", "StringReverse", "string reverse", "strings", 
      "StringSplit", "string split", "StringTake", "string take", 
      "substitution", "substrings", "test", "text", "translation", 
      "whitespace"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica provides a variety of functions for manipulating strings. \
Most of these functions are based on viewing strings as a sequence of \
characters, and many of the functions are analogous to ones for manipulating \
lists. Operations on complete strings. You can join together any number of \
strings using <>. ", "synonyms" -> {"2.8.2"}, "title" -> 
    "Operations on Strings", "type" -> "Tutorial", "uri" -> 
    "tutorial/OperationsOnStrings"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.8.2"->{
  Cell[3349, 83, 84, 2, 70, "Title",
   CellTags->{"S2.8.2", "2.1"},
   CellID->16303]},
 "2.1"->{
  Cell[3349, 83, 84, 2, 70, "Title",
   CellTags->{"S2.8.2", "2.1"},
   CellID->16303]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.8.2", 51479, 1788},
 {"2.1", 51578, 1792}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2724, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3349, 83, 84, 2, 70, "Title",
 CellTags->{"S2.8.2", "2.1"},
 CellID->16303],
Cell[3436, 87, 313, 7, 70, "Text",
 CellID->25375],
Cell[3752, 96, 1622, 46, 70, "DefinitionBox",
 CellID->667],
Cell[5377, 144, 67, 1, 70, "Caption",
 CellID->25392],
Cell[5447, 147, 150, 5, 70, "MathCaption",
 CellID->12032],
Cell[CellGroupData[{
Cell[5622, 156, 144, 4, 28, "Input",
 CellID->17108],
Cell[5769, 162, 187, 5, 36, "Output",
 CellID->1596414716]
}, Open  ]],
Cell[5971, 170, 226, 7, 70, "MathCaption",
 CellID->29998],
Cell[CellGroupData[{
Cell[6222, 181, 104, 3, 28, "Input",
 CellID->11258],
Cell[6329, 186, 159, 5, 36, "Output",
 CellID->948785716]
}, Open  ]],
Cell[6503, 194, 221, 7, 70, "MathCaption",
 CellID->15693],
Cell[CellGroupData[{
Cell[6749, 205, 121, 3, 70, "Input",
 CellID->24001],
Cell[6873, 210, 174, 5, 36, "Output",
 CellID->760471622]
}, Open  ]],
Cell[7062, 218, 2833, 93, 70, "DefinitionBox",
 CellID->30516],
Cell[9898, 313, 67, 1, 70, "Caption",
 CellID->21618],
Cell[9968, 316, 1133, 39, 70, "Text",
 CellID->7718],
Cell[11104, 357, 64, 1, 70, "MathCaption",
 CellID->23668],
Cell[CellGroupData[{
Cell[11193, 362, 125, 3, 70, "Input",
 CellID->20536],
Cell[11321, 367, 192, 5, 36, "Output",
 CellID->900171046]
}, Open  ]],
Cell[11528, 375, 144, 5, 70, "MathCaption",
 CellID->6523],
Cell[CellGroupData[{
Cell[11697, 384, 128, 4, 70, "Input",
 CellID->1797],
Cell[11828, 390, 171, 5, 36, "Output",
 CellID->2106134881]
}, Open  ]],
Cell[12014, 398, 134, 5, 70, "MathCaption",
 CellID->11552],
Cell[CellGroupData[{
Cell[12173, 407, 153, 5, 70, "Input",
 CellID->28615],
Cell[12329, 414, 167, 5, 36, "Output",
 CellID->1425102066]
}, Open  ]],
Cell[12511, 422, 126, 4, 70, "MathCaption",
 CellID->11928],
Cell[CellGroupData[{
Cell[12662, 430, 221, 8, 70, "Input",
 CellID->14115],
Cell[12886, 440, 184, 5, 36, "Output",
 CellID->1076011489]
}, Open  ]],
Cell[13085, 448, 1618, 50, 70, "DefinitionBox",
 CellID->20343],
Cell[14706, 500, 60, 1, 70, "Caption",
 CellID->30248],
Cell[14769, 503, 604, 21, 70, "Text",
 CellID->18710],
Cell[15376, 526, 197, 6, 70, "MathCaption",
 CellID->15544],
Cell[CellGroupData[{
Cell[15598, 536, 160, 4, 70, "Input",
 CellID->6210],
Cell[15761, 542, 175, 5, 36, "Output",
 CellID->418776159]
}, Open  ]],
Cell[15951, 550, 100, 2, 70, "MathCaption",
 CellID->18040],
Cell[CellGroupData[{
Cell[16076, 556, 180, 5, 70, "Input",
 CellID->8337],
Cell[16259, 563, 176, 5, 36, "Output",
 CellID->490272856]
}, Open  ]],
Cell[16450, 571, 183, 5, 70, "MathCaption",
 CellID->17034],
Cell[CellGroupData[{
Cell[16658, 580, 242, 7, 70, "Input",
 CellID->3744],
Cell[16903, 589, 184, 5, 36, "Output",
 CellID->340130216]
}, Open  ]],
Cell[17102, 597, 233, 8, 70, "MathCaption",
 CellID->619321384],
Cell[CellGroupData[{
Cell[17360, 609, 293, 9, 70, "Input",
 CellID->6066578],
Cell[17656, 620, 182, 5, 36, "Output",
 CellID->1621620613]
}, Open  ]],
Cell[17853, 628, 3153, 96, 70, "DefinitionBox",
 CellID->26068],
Cell[21009, 726, 64, 1, 70, "Caption",
 CellID->13235],
Cell[21076, 729, 159, 5, 70, "MathCaption",
 CellID->1104],
Cell[CellGroupData[{
Cell[21260, 738, 217, 6, 70, "Input",
 CellID->20032],
Cell[21480, 746, 171, 5, 36, "Output",
 CellID->46679584]
}, Open  ]],
Cell[21666, 754, 160, 5, 70, "MathCaption",
 CellID->17691],
Cell[CellGroupData[{
Cell[21851, 763, 346, 11, 70, "Input",
 CellID->13197],
Cell[22200, 776, 175, 5, 36, "Output",
 CellID->1220539503]
}, Open  ]],
Cell[22390, 784, 113, 3, 70, "MathCaption",
 CellID->24853],
Cell[CellGroupData[{
Cell[22528, 791, 406, 13, 70, "Input",
 CellID->27223],
Cell[22937, 806, 176, 5, 36, "Output",
 CellID->1341249660]
}, Open  ]],
Cell[23128, 814, 2057, 62, 70, "DefinitionBox",
 CellID->23233],
Cell[25188, 878, 68, 1, 70, "Caption",
 CellID->30962],
Cell[25259, 881, 1063, 31, 70, "Text",
 CellID->19990],
Cell[26325, 914, 161, 5, 70, "MathCaption",
 CellID->21428],
Cell[CellGroupData[{
Cell[26511, 923, 163, 4, 70, "Input",
 CellID->14124],
Cell[26677, 929, 426, 15, 36, "Output",
 CellID->1109793971]
}, Open  ]],
Cell[27118, 947, 149, 5, 70, "MathCaption",
 CellID->28489],
Cell[CellGroupData[{
Cell[27292, 956, 176, 5, 70, "Input",
 CellID->30425],
Cell[27471, 963, 228, 8, 36, "Output",
 CellID->568143872]
}, Open  ]],
Cell[27714, 974, 230, 7, 70, "MathCaption",
 CellID->23286],
Cell[CellGroupData[{
Cell[27969, 985, 214, 6, 70, "Input",
 CellID->6535],
Cell[28186, 993, 481, 17, 36, "Output",
 CellID->307965430]
}, Open  ]],
Cell[28682, 1013, 70, 1, 70, "MathCaption",
 CellID->2662],
Cell[CellGroupData[{
Cell[28777, 1018, 261, 7, 70, "Input",
 CellID->24363],
Cell[29041, 1027, 364, 13, 36, "Output",
 CellID->1995646132]
}, Open  ]],
Cell[29420, 1043, 2503, 80, 70, "DefinitionBox",
 CellID->8667],
Cell[31926, 1125, 58, 1, 70, "Caption",
 CellID->1437],
Cell[31987, 1128, 129, 4, 70, "MathCaption",
 CellID->15155],
Cell[CellGroupData[{
Cell[32141, 1136, 212, 6, 70, "Input",
 CellID->26575],
Cell[32356, 1144, 160, 5, 36, "Output",
 CellID->1289234365]
}, Open  ]],
Cell[32531, 1152, 2919, 94, 70, "DefinitionBox",
 CellID->14970],
Cell[35453, 1248, 76, 1, 70, "Caption",
 CellID->13663],
Cell[35532, 1251, 205, 7, 70, "MathCaption",
 CellID->27460],
Cell[CellGroupData[{
Cell[35762, 1262, 194, 5, 70, "Input",
 CellID->21763],
Cell[35959, 1269, 188, 5, 36, "Output",
 CellID->374389906]
}, Open  ]],
Cell[36162, 1277, 260, 11, 70, "MathCaption",
 CellID->10094],
Cell[CellGroupData[{
Cell[36447, 1292, 291, 8, 70, "Input",
 CellID->26147],
Cell[36741, 1302, 181, 5, 36, "Output",
 CellID->482544064]
}, Open  ]],
Cell[36937, 1310, 212, 7, 70, "MathCaption",
 CellID->29509],
Cell[CellGroupData[{
Cell[37174, 1321, 287, 8, 70, "Input",
 CellID->17664],
Cell[37464, 1331, 175, 5, 36, "Output",
 CellID->1073265384]
}, Open  ]],
Cell[37654, 1339, 573, 15, 70, "Text",
 CellID->7524],
Cell[38230, 1356, 176, 5, 70, "MathCaption",
 CellID->18934],
Cell[CellGroupData[{
Cell[38431, 1365, 185, 5, 70, "Input",
 CellID->9806],
Cell[38619, 1372, 300, 8, 36, "Output",
 CellID->2094362127]
}, Open  ]],
Cell[38934, 1383, 101, 2, 70, "MathCaption",
 CellID->28590],
Cell[CellGroupData[{
Cell[39060, 1389, 291, 8, 70, "Input",
 CellID->20634],
Cell[39354, 1399, 271, 8, 36, "Output",
 CellID->2052966686]
}, Open  ]],
Cell[39640, 1410, 2065, 66, 70, "DefinitionBox",
 CellID->6862],
Cell[41708, 1478, 54, 1, 70, "Caption",
 CellID->10580],
Cell[41765, 1481, 85, 1, 70, "MathCaption",
 CellID->4919],
Cell[CellGroupData[{
Cell[41875, 1486, 125, 3, 70, "Input",
 CellID->2526],
Cell[42003, 1491, 285, 8, 36, "Output",
 CellID->835203349]
}, Open  ]],
Cell[42303, 1502, 127, 5, 70, "MathCaption",
 CellID->4850],
Cell[CellGroupData[{
Cell[42455, 1511, 158, 4, 70, "Input",
 CellID->10944],
Cell[42616, 1517, 251, 8, 36, "Output",
 CellID->1501897755]
}, Open  ]],
Cell[42882, 1528, 74, 1, 70, "MathCaption",
 CellID->2716],
Cell[CellGroupData[{
Cell[42981, 1533, 214, 6, 70, "Input",
 CellID->14061],
Cell[43198, 1541, 353, 9, 36, "Output",
 CellID->559214453]
}, Open  ]],
Cell[43566, 1553, 1690, 52, 70, "DefinitionBox",
 CellID->21006],
Cell[45259, 1607, 87, 1, 70, "Caption",
 CellID->30826],
Cell[45349, 1610, 220, 9, 70, "MathCaption",
 CellID->703],
Cell[CellGroupData[{
Cell[45594, 1623, 234, 7, 70, "Input",
 CellID->13039],
Cell[45831, 1632, 365, 11, 36, "Output",
 CellID->254585153]
}, Open  ]],
Cell[46211, 1646, 728, 22, 70, "DefinitionBox",
 CellID->27214],
Cell[46942, 1670, 51, 1, 70, "Caption",
 CellID->4751],
Cell[46996, 1673, 211, 7, 70, "MathCaption",
 CellID->4432],
Cell[CellGroupData[{
Cell[47232, 1684, 217, 7, 70, "Input",
 CellID->7985],
Cell[47452, 1693, 274, 8, 36, "Output",
 CellID->873293390]
}, Open  ]],
Cell[CellGroupData[{
Cell[47763, 1706, 72, 1, 70, "RelatedTutorialsSection",
 CellID->896973879],
Cell[47838, 1709, 174, 4, 70, "RelatedTutorials",
 CellID->25846920]
}, Open  ]]
}, Open  ]],
Cell[48039, 1717, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

