(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22661,        649]
NotebookOptionsPosition[      8971,        282]
NotebookOutlinePosition[     19710,        560]
CellTagsIndexPosition[     19400,        547]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["The Option Inspector", "Title",
 CellID->131251472],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 CellTags->{"OptionsIntroduction", "A1.1"},
 CellID->6334],

Cell[TextData[{
 "Many aspects of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end",
 StyleBox[",",
  FontSlant->"Italic"],
 " such as the styles of cells, the appearance of notebooks, or the \
parameters used in typesetting, are controlled by options. For example, text \
attributes such as size, font, and color each correspond to a separate \
option. You can set options by directly editing the expression for a cell or \
notebook. But in most cases it is simpler to use the Option Inspector."
}], "Text",
 CellTags->{"OptionsIntroduction", "A1.1"},
 CellID->26500],

Cell["\<\
The Option Inspector is a special tool for viewing and modifying option \
settings. It provides a comprehensive listing of all front end options, \
grouped according to their function. You can specify not only the setting for \
an option, but also the level at which it will take effect: globally, for an \
entire notebook, or for a selection.\
\>", "Text",
 CellTags->{"OptionsIntroduction", "A1.1"},
 CellID->19169],

Cell["\<\
To use the Option Inspector, choose Format \[RightTriangle] Option Inspector. \
This brings up a dialog box with two pop-up menus on top. The pop-up menu on \
the left specifies the level at which options will take effect. The pop-up \
menu on the right allows you to choose if you want the options listed by \
category, alphabetically, or as text.\
\>", "Text",
 CellTags->{"OptionsIntroduction", "A1.1"},
 CellID->15724]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inheritance of Options", "Section",
 CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
 CellID->11478],

Cell["\<\
The Option Inspector allows you to set the value of an option on three \
different levels. In increasing order of precedence, the levels are as \
follows.\
\>", "Text",
 CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
 CellID->29358],

Cell[TextData[{
 StyleBox["Global Preferences -",
  FontWeight->"Bold"],
 " settings for the entire application"
}], "Text",
 CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
 CellID->26962],

Cell[TextData[{
 StyleBox["Selected Notebook -",
  FontWeight->"Bold"],
 " settings for an entire notebook"
}], "Text",
 CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
 CellID->24464],

Cell[TextData[{
 StyleBox["Selection -",
  FontWeight->"Bold"],
 " settings for the current selection, e.g. for a group of cells, a single \
cell, or text within a cell "
}], "Text",
 CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
 CellID->5705],

Cell[TextData[{
 "The levels lower in the hierarchy inherit their options from the level \
immediately above them. For example, if a notebook has the option ",
 Cell[BoxData[
  ButtonBox["Editable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Editable"]], "InlineFormula"],
 " set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", by default all cells in the notebook will be editable. "
}], "Text",
 CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
 CellID->28145],

Cell[TextData[{
 "You can, however, override the inherited value of an option by explicitly \
changing its value. For example, if you do not want a particular cell in your \
notebook to be editable, you can select the cell and set ",
 Cell[BoxData[
  ButtonBox["Editable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Editable"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". This inheritance property of options provides you with a great deal of \
control over the behavior of the front end, since you can set any option to \
have different values at each level, as required. "
}], "Text",
 CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
 CellID->23281],

Cell[TextData[{
 StyleBox["Note:",
  FontWeight->"Bold"],
 " At each level, only the options that can be set at that level are listed \
in the Option Inspector. All other options appear dimmed, indicating that \
they cannot be changed unless you go to a higher or lower level."
}], "Text",
 CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
 CellID->16827]
}, Open  ]],

Cell[CellGroupData[{

Cell["Searching for an Option", "Section",
 CellTags->{"Introduction", "OptionsSearching", "A1.3"},
 CellID->9961],

Cell["\<\
To search for a specific option, begin typing its name in the text field. The \
Option Inspector goes to the first matching option. Press \[EnterKey] to go \
to the next matching item on the list. (On Macintosh, the Option Inspector \
displays all matching options at once). \
\>", "Text",
 CellTags->{"Introduction", "OptionsSearching", "A1.3"},
 CellID->491],

Cell["\<\
Each line in the list of options gives the option name followed by its \
current value. You can change the option's value by choosing from the pop-up \
menu next to the option setting, or by selecting the option and clicking on \
the value, typing over it, and pressing \[EnterKey]. \
\>", "Text",
 CellTags->{"Introduction", "OptionsSearching", "A1.3"},
 CellID->2995],

Cell[TextData[{
 "When you start ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for the first time, the values of all the options are set to their default \
values. Each time you modify one of the options, a symbol appears next to it, \
indicating that the value has been changed. Clicking the symbol resets the \
option to its default value. "
}], "Text",
 CellTags->{"Introduction", "OptionsSearching", "A1.3"},
 CellID->11942]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting Options: An Example", "Section",
 CellTags->{"Introduction", "OptionsSetting", "A1.4"},
 CellID->4827],

Cell[TextData[{
 "Suppose you want to draw a frame around a cell. The option that controls \
this property of a cell is called ",
 Cell[BoxData[
  ButtonBox["CellFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellFrame"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"A1.4",
 CellID->5436],

Cell[TextData[StyleBox["To draw a frame around a cell:",
 FontWeight->"Bold"]], "Text",
 CellTags->{"Introduction", "OptionsSetting", "A1.4"},
 CellID->32391],

Cell["Select the cell by clicking on the cell bracket.", "ItemizedText",
 CellTags->{"Introduction", "OptionsSetting", "A1.4"},
 CellID->14604],

Cell["\<\
Choose Format \[RightTriangle] Option Inspector to open the Option Inspector \
window.\
\>", "ItemizedText",
 CellTags->{"Introduction", "OptionsSetting", "A1.4"},
 CellID->3902],

Cell["Choose Selection from the first pop-up menu.", "ItemizedText",
 CellTags->{"Introduction", "OptionsSetting", "A1.4"},
 CellID->153],

Cell["\<\
Click Cell Options \[RightTriangle] Display Options. This gives a list of all \
options that control how a cell is displayed in the notebook.\
\>", "ItemizedText",
 CellTags->{"Introduction", "OptionsSetting", "A1.4"},
 CellID->292],

Cell[CellGroupData[{

Cell[TextData[{
 "Use the pop-up menu next to the option ",
 Cell[BoxData[
  ButtonBox["CellFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellFrame"]], "InlineFormula"],
 " to change the setting to \[OpenCurlyDoubleQuote]True.\
\[CloseCurlyDoubleQuote] A symbol appears next to the option, indicating that \
its value has been changed. The cell that you had selected now has a frame \
drawn around it."
}], "ItemizedText",
 CellTags->{"Introduction", "OptionsSetting", "A1.4"},
 CellID->12382],

Cell[TextData[{
 "Alternatively, you can begin typing \[OpenCurlyDoubleQuote]cellframe\
\[CloseCurlyDoubleQuote] in the text field",
 StyleBox[". ",
  FontFamily->"Helvetica"],
 "This leads you directly to the ",
 Cell[BoxData[
  ButtonBox["CellFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellFrame"]], "InlineFormula"],
 " option without having to search by category. This feature provides a \
useful way to locate an option if you are unsure of the category it belongs \
in."
}], "Text",
 CellTags->{"Introduction", "OptionsSetting", "A1.4"},
 CellID->17421]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Option Inspector - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 36.0115758}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Many aspects of the Mathematica front end, such as the styles of cells, \
the appearance of notebooks, or the parameters used in typesetting, are \
controlled by options. For example, text attributes such as size, font, and \
color each correspond to a separate option. You can set options by directly \
editing the expression for a cell or notebook. But in most cases it is \
simpler to use the Option Inspector. The Option Inspector is a special tool \
for viewing and modifying option settings. It provides a comprehensive \
listing of all front end options, grouped according to their function. You \
can specify not only the setting for an option, but also the level at which \
it will take effect: globally, for an entire notebook, or for a selection. To \
use the Option Inspector, choose Format |> Option Inspector. This brings up a \
dialog box with two pop-up menus on top. The pop-up menu on the left \
specifies the level at which options will take effect. The pop-up menu on the \
right allows you to choose if you want the options listed by category, \
alphabetically, or as text.", "synonyms" -> {}, "title" -> 
    "The Option Inspector", "type" -> "Tutorial", "uri" -> 
    "tutorial/OptionInspector"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "OptionsIntroduction"->{
  Cell[810, 34, 90, 2, 70, "Section",
   CellTags->{"OptionsIntroduction", "A1.1"},
   CellID->6334],
  Cell[903, 38, 588, 14, 70, "Text",
   CellTags->{"OptionsIntroduction", "A1.1"},
   CellID->26500],
  Cell[1494, 54, 427, 8, 70, "Text",
   CellTags->{"OptionsIntroduction", "A1.1"},
   CellID->19169],
  Cell[1924, 64, 432, 8, 70, "Text",
   CellTags->{"OptionsIntroduction", "A1.1"},
   CellID->15724]},
 "A1.1"->{
  Cell[810, 34, 90, 2, 70, "Section",
   CellTags->{"OptionsIntroduction", "A1.1"},
   CellID->6334],
  Cell[903, 38, 588, 14, 70, "Text",
   CellTags->{"OptionsIntroduction", "A1.1"},
   CellID->26500],
  Cell[1494, 54, 427, 8, 70, "Text",
   CellTags->{"OptionsIntroduction", "A1.1"},
   CellID->19169],
  Cell[1924, 64, 432, 8, 70, "Text",
   CellTags->{"OptionsIntroduction", "A1.1"},
   CellID->15724]},
 "Introduction"->{
  Cell[2393, 77, 116, 2, 70, "Section",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->11478],
  Cell[2512, 81, 253, 6, 70, "Text",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->29358],
  Cell[2768, 89, 199, 6, 70, "Text",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->26962],
  Cell[2970, 97, 194, 6, 70, "Text",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->24464],
  Cell[3167, 105, 256, 7, 70, "Text",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->5705],
  Cell[3426, 114, 550, 15, 70, "Text",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->28145],
  Cell[3979, 131, 768, 18, 70, "Text",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->23281],
  Cell[4750, 151, 364, 8, 70, "Text",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->16827],
  Cell[5151, 164, 114, 2, 70, "Section",
   CellTags->{"Introduction", "OptionsSearching", "A1.3"},
   CellID->9961],
  Cell[5268, 168, 370, 7, 70, "Text",
   CellTags->{"Introduction", "OptionsSearching", "A1.3"},
   CellID->491],
  Cell[5641, 177, 379, 7, 70, "Text",
   CellTags->{"Introduction", "OptionsSearching", "A1.3"},
   CellID->2995],
  Cell[6023, 186, 437, 10, 70, "Text",
   CellTags->{"Introduction", "OptionsSearching", "A1.3"},
   CellID->11942],
  Cell[6497, 201, 116, 2, 70, "Section",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->4827],
  Cell[6920, 217, 158, 3, 70, "Text",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->32391],
  Cell[7081, 222, 143, 2, 70, "ItemizedText",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->14604],
  Cell[7227, 226, 188, 5, 70, "ItemizedText",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->3902],
  Cell[7418, 233, 137, 2, 70, "ItemizedText",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->153],
  Cell[7558, 237, 242, 5, 70, "ItemizedText",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->292],
  Cell[7825, 246, 504, 12, 70, "ItemizedText",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->12382],
  Cell[8332, 260, 573, 15, 70, "Text",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->17421]},
 "OptionsInheritance"->{
  Cell[2393, 77, 116, 2, 70, "Section",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->11478],
  Cell[2512, 81, 253, 6, 70, "Text",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->29358],
  Cell[2768, 89, 199, 6, 70, "Text",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->26962],
  Cell[2970, 97, 194, 6, 70, "Text",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->24464],
  Cell[3167, 105, 256, 7, 70, "Text",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->5705],
  Cell[3426, 114, 550, 15, 70, "Text",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->28145],
  Cell[3979, 131, 768, 18, 70, "Text",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->23281],
  Cell[4750, 151, 364, 8, 70, "Text",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->16827]},
 "A1.2"->{
  Cell[2393, 77, 116, 2, 70, "Section",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->11478],
  Cell[2512, 81, 253, 6, 70, "Text",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->29358],
  Cell[2768, 89, 199, 6, 70, "Text",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->26962],
  Cell[2970, 97, 194, 6, 70, "Text",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->24464],
  Cell[3167, 105, 256, 7, 70, "Text",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->5705],
  Cell[3426, 114, 550, 15, 70, "Text",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->28145],
  Cell[3979, 131, 768, 18, 70, "Text",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->23281],
  Cell[4750, 151, 364, 8, 70, "Text",
   CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
   CellID->16827]},
 "OptionsSearching"->{
  Cell[5151, 164, 114, 2, 70, "Section",
   CellTags->{"Introduction", "OptionsSearching", "A1.3"},
   CellID->9961],
  Cell[5268, 168, 370, 7, 70, "Text",
   CellTags->{"Introduction", "OptionsSearching", "A1.3"},
   CellID->491],
  Cell[5641, 177, 379, 7, 70, "Text",
   CellTags->{"Introduction", "OptionsSearching", "A1.3"},
   CellID->2995],
  Cell[6023, 186, 437, 10, 70, "Text",
   CellTags->{"Introduction", "OptionsSearching", "A1.3"},
   CellID->11942]},
 "A1.3"->{
  Cell[5151, 164, 114, 2, 70, "Section",
   CellTags->{"Introduction", "OptionsSearching", "A1.3"},
   CellID->9961],
  Cell[5268, 168, 370, 7, 70, "Text",
   CellTags->{"Introduction", "OptionsSearching", "A1.3"},
   CellID->491],
  Cell[5641, 177, 379, 7, 70, "Text",
   CellTags->{"Introduction", "OptionsSearching", "A1.3"},
   CellID->2995],
  Cell[6023, 186, 437, 10, 70, "Text",
   CellTags->{"Introduction", "OptionsSearching", "A1.3"},
   CellID->11942]},
 "OptionsSetting"->{
  Cell[6497, 201, 116, 2, 70, "Section",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->4827],
  Cell[6920, 217, 158, 3, 70, "Text",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->32391],
  Cell[7081, 222, 143, 2, 70, "ItemizedText",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->14604],
  Cell[7227, 226, 188, 5, 70, "ItemizedText",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->3902],
  Cell[7418, 233, 137, 2, 70, "ItemizedText",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->153],
  Cell[7558, 237, 242, 5, 70, "ItemizedText",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->292],
  Cell[7825, 246, 504, 12, 70, "ItemizedText",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->12382],
  Cell[8332, 260, 573, 15, 70, "Text",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->17421]},
 "A1.4"->{
  Cell[6497, 201, 116, 2, 70, "Section",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->4827],
  Cell[6616, 205, 301, 10, 70, "Text",
   CellTags->"A1.4",
   CellID->5436],
  Cell[6920, 217, 158, 3, 70, "Text",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->32391],
  Cell[7081, 222, 143, 2, 70, "ItemizedText",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->14604],
  Cell[7227, 226, 188, 5, 70, "ItemizedText",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->3902],
  Cell[7418, 233, 137, 2, 70, "ItemizedText",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->153],
  Cell[7558, 237, 242, 5, 70, "ItemizedText",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->292],
  Cell[7825, 246, 504, 12, 70, "ItemizedText",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->12382],
  Cell[8332, 260, 573, 15, 70, "Text",
   CellTags->{"Introduction", "OptionsSetting", "A1.4"},
   CellID->17421]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"OptionsIntroduction", 11265, 328},
 {"A1.1", 11685, 341},
 {"Introduction", 12113, 354},
 {"OptionsInheritance", 14498, 415},
 {"A1.2", 15454, 440},
 {"OptionsSearching", 16422, 465},
 {"A1.3", 16898, 478},
 {"OptionsSetting", 17384, 491},
 {"A1.4", 18347, 516}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[728, 29, 57, 1, 70, "Title",
 CellID->131251472],
Cell[CellGroupData[{
Cell[810, 34, 90, 2, 70, "Section",
 CellTags->{"OptionsIntroduction", "A1.1"},
 CellID->6334],
Cell[903, 38, 588, 14, 70, "Text",
 CellTags->{"OptionsIntroduction", "A1.1"},
 CellID->26500],
Cell[1494, 54, 427, 8, 70, "Text",
 CellTags->{"OptionsIntroduction", "A1.1"},
 CellID->19169],
Cell[1924, 64, 432, 8, 70, "Text",
 CellTags->{"OptionsIntroduction", "A1.1"},
 CellID->15724]
}, Open  ]],
Cell[CellGroupData[{
Cell[2393, 77, 116, 2, 70, "Section",
 CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
 CellID->11478],
Cell[2512, 81, 253, 6, 70, "Text",
 CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
 CellID->29358],
Cell[2768, 89, 199, 6, 70, "Text",
 CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
 CellID->26962],
Cell[2970, 97, 194, 6, 70, "Text",
 CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
 CellID->24464],
Cell[3167, 105, 256, 7, 70, "Text",
 CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
 CellID->5705],
Cell[3426, 114, 550, 15, 70, "Text",
 CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
 CellID->28145],
Cell[3979, 131, 768, 18, 70, "Text",
 CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
 CellID->23281],
Cell[4750, 151, 364, 8, 70, "Text",
 CellTags->{"Introduction", "OptionsInheritance", "A1.2"},
 CellID->16827]
}, Open  ]],
Cell[CellGroupData[{
Cell[5151, 164, 114, 2, 70, "Section",
 CellTags->{"Introduction", "OptionsSearching", "A1.3"},
 CellID->9961],
Cell[5268, 168, 370, 7, 70, "Text",
 CellTags->{"Introduction", "OptionsSearching", "A1.3"},
 CellID->491],
Cell[5641, 177, 379, 7, 70, "Text",
 CellTags->{"Introduction", "OptionsSearching", "A1.3"},
 CellID->2995],
Cell[6023, 186, 437, 10, 70, "Text",
 CellTags->{"Introduction", "OptionsSearching", "A1.3"},
 CellID->11942]
}, Open  ]],
Cell[CellGroupData[{
Cell[6497, 201, 116, 2, 70, "Section",
 CellTags->{"Introduction", "OptionsSetting", "A1.4"},
 CellID->4827],
Cell[6616, 205, 301, 10, 70, "Text",
 CellTags->"A1.4",
 CellID->5436],
Cell[6920, 217, 158, 3, 70, "Text",
 CellTags->{"Introduction", "OptionsSetting", "A1.4"},
 CellID->32391],
Cell[7081, 222, 143, 2, 70, "ItemizedText",
 CellTags->{"Introduction", "OptionsSetting", "A1.4"},
 CellID->14604],
Cell[7227, 226, 188, 5, 70, "ItemizedText",
 CellTags->{"Introduction", "OptionsSetting", "A1.4"},
 CellID->3902],
Cell[7418, 233, 137, 2, 70, "ItemizedText",
 CellTags->{"Introduction", "OptionsSetting", "A1.4"},
 CellID->153],
Cell[7558, 237, 242, 5, 70, "ItemizedText",
 CellTags->{"Introduction", "OptionsSetting", "A1.4"},
 CellID->292],
Cell[CellGroupData[{
Cell[7825, 246, 504, 12, 70, "ItemizedText",
 CellTags->{"Introduction", "OptionsSetting", "A1.4"},
 CellID->12382],
Cell[8332, 260, 573, 15, 70, "Text",
 CellTags->{"Introduction", "OptionsSetting", "A1.4"},
 CellID->17421]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[8944, 280, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

