(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21688,        811]
NotebookOptionsPosition[     15950,        631]
NotebookOutlinePosition[     18829,        704]
CellTagsIndexPosition[     18738,        698]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/PatternsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Patterns\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PatternSequence" :> 
          Documentation`HelpLookup["paclet:ref/PatternSequence"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"PatternSequence\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Optional and Default Arguments", "Title",
 CellTags->{"S2.3.9", "9.1"},
 CellID->17673],

Cell[TextData[{
 "Sometimes you may want to set up functions where certain arguments, if \
omitted, are given \[OpenCurlyDoubleQuote]default values\
\[CloseCurlyDoubleQuote]. The pattern ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    RowBox[{
     StyleBox["x", "TI"], "_:"}]], 
   StyleBox["v", "TI"]}]], "InlineFormula"],
 " stands for an object that can be omitted, and if so, will be replaced by \
the default value ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 "."
}], "Text",
 CellID->4664],

Cell[TextData[{
 "This defines a function ",
 Cell[BoxData["j"], "InlineFormula"],
 " with a required argument ",
 Cell[BoxData["x"], "InlineFormula"],
 ", and optional arguments ",
 Cell[BoxData["y"], "InlineFormula"],
 " and ",
 Cell[BoxData["z"], "InlineFormula"],
 ", with default values ",
 Cell[BoxData["1"], "InlineFormula"],
 " and ",
 Cell[BoxData["2"], "InlineFormula"],
 ", respectively. "
}], "MathCaption",
 CellID->15141],

Cell[BoxData[
 RowBox[{
  RowBox[{"j", "[", 
   RowBox[{"x_", ",", 
    RowBox[{"y_:", "1"}], ",", 
    RowBox[{"z_:", "2"}]}], "]"}], ":=", 
  RowBox[{"jp", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->7711],

Cell[TextData[{
 "The default value of ",
 Cell[BoxData["z"], "InlineFormula"],
 " is used here. "
}], "MathCaption",
 CellID->28253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"j", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->6868],

Cell[BoxData[
 RowBox[{"jp", "[", 
  RowBox[{"a", ",", "b", ",", "2"}], "]"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->25547]
}, Open  ]],

Cell[TextData[{
 "Now the default values of both ",
 Cell[BoxData["y"], "InlineFormula"],
 " and ",
 Cell[BoxData["z"], "InlineFormula"],
 " are used. "
}], "MathCaption",
 CellID->27644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"j", "[", "a", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->32662],

Cell[BoxData[
 RowBox[{"jp", "[", 
  RowBox[{"a", ",", "1", ",", "2"}], "]"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->32757]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], 
     StyleBox[":", "MR"], 
     StyleBox["v", "TI"]}], Cell[TextData[{
     "an expression which, if omitted, is taken to have default value ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], 
     StyleBox["h", "TI"], 
     StyleBox[":", "MR"], 
     StyleBox["v", "TI"]}], Cell[TextData[{
     "an expression with head ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"],
     " and default value ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_.", "MR"]}], Cell["\<\
an expression with a built\[Hyphen]in default value\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20037],

Cell["Pattern objects with default values. ", "Caption",
 CellID->12859],

Cell[TextData[{
 "Some common ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions have built\[Hyphen]in default values for their arguments. In \
such cases, you need not explicitly give the default value in ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    RowBox[{
     StyleBox["x", "TI"], "_:"}]], 
   StyleBox["v", "TI"]}]], "InlineFormula"],
 ", but instead you can use the more convenient notation ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["x", "TI"], "_."}]]], "InlineFormula"],
 " in which a built\[Hyphen]in default value is assumed. "
}], "Text",
 CellID->8723],

Cell[BoxData[GridBox[{
   {
    RowBox[{"x_", "+", "y_."}], Cell[TextData[{
     "default for ",
     Cell[BoxData["y"], "InlineFormula"],
     " is ",
     Cell[BoxData["0"], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"x_", "y_."}], Cell[TextData[{
     "default for ",
     Cell[BoxData["y"], "InlineFormula"],
     " is ",
     Cell[BoxData["1"], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"x_", "^", "y_."}], Cell[TextData[{
     "default for ",
     Cell[BoxData["y"], "InlineFormula"],
     " is ",
     Cell[BoxData["1"], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->9741],

Cell["Some patterns with optional pieces. ", "Caption",
 CellID->27529],

Cell[TextData[{
 "Here ",
 Cell[BoxData["a"], "InlineFormula"],
 " matches the pattern ",
 Cell[BoxData[
  RowBox[{"x_", "+", "y_."}]], "InlineFormula"],
 " with ",
 Cell[BoxData["y"], "InlineFormula"],
 " taken to have the default value\[NonBreakingSpace]",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "a", "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"a", "+", "b"}], "]"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x_", "+", "y_."}], "]"}], "->", 
   RowBox[{"p", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->12316],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"a", ",", "0"}], "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{"b", ",", "a"}], "]"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->3035]
}, Open  ]],

Cell[TextData[{
 "Because ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " is a flat function, a pattern such as ",
 Cell[BoxData[
  RowBox[{"x_", "+", "y_"}]], "InlineFormula"],
 " can match a sum with any number of terms. This pattern cannot, however, \
match a single term such as ",
 Cell[BoxData["a"], "InlineFormula"],
 ". However, the pattern ",
 Cell[BoxData[
  RowBox[{"x_", "+", "y_."}]], "InlineFormula"],
 " contains an optional piece, and can match either an explicit sum of terms \
in which both ",
 Cell[BoxData["x_"], "InlineFormula"],
 " and ",
 Cell[BoxData["y_"], "InlineFormula"],
 " appear, or a single term ",
 Cell[BoxData["x_"], "InlineFormula"],
 ", with ",
 Cell[BoxData["y"], "InlineFormula"],
 " taken to be ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "Text",
 CellID->22190],

Cell[TextData[{
 "Using constructs such as ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["x", "TI"], "_."}]]], "InlineFormula"],
 ", you can easily construct single patterns that match expressions with \
several different structures. This is particularly useful when you want to \
match several mathematically equal forms that do not have the same structure. \
"
}], "Text",
 CellID->1842],

Cell[TextData[{
 "The pattern matches ",
 Cell[BoxData[
  RowBox[{"g", "[", 
   RowBox[{"a", "^", "2"}], "]"}]], "InlineFormula"],
 ", but not ",
 Cell[BoxData[
  RowBox[{"g", "[", 
   RowBox[{"a", "+", "b"}], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"a", "^", "2"}], "]"}], ",", 
    RowBox[{"g", "[", 
     RowBox[{"a", "+", "b"}], "]"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"x_", "^", "n_"}], "]"}], "->", 
   RowBox[{"p", "[", 
    RowBox[{"x", ",", "n"}], "]"}]}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->30106],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"a", ",", "2"}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"a", "+", "b"}], "]"}]}], "}"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->9040]
}, Open  ]],

Cell["\<\
By giving a pattern in which the exponent is optional, you can match both \
cases. \
\>", "MathCaption",
 CellID->8942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"a", "^", "2"}], "]"}], ",", 
    RowBox[{"g", "[", 
     RowBox[{"a", "+", "b"}], "]"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"x_", "^", "n_."}], "]"}], "->", 
   RowBox[{"p", "[", 
    RowBox[{"x", ",", "n"}], "]"}]}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->19264],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"a", ",", "2"}], "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{
     RowBox[{"a", "+", "b"}], ",", "1"}], "]"}]}], "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->22648]
}, Open  ]],

Cell[TextData[{
 "The pattern ",
 Cell[BoxData[
  RowBox[{"a_.", "+", 
   RowBox[{"b_.", "x_"}]}]], "InlineFormula"],
 " matches any linear function of ",
 Cell[BoxData["x_"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27446],

Cell[BoxData[
 RowBox[{
  RowBox[{"lin", "[", 
   RowBox[{
    RowBox[{"a_.", "+", 
     RowBox[{"b_.", " ", "x_"}]}], ",", "x_"}], "]"}], ":=", 
  RowBox[{"p", "[", 
   RowBox[{"a", ",", "b"}], "]"}]}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->23805],

Cell[TextData[{
 "In this case, ",
 Cell[BoxData["b"], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightArrow]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData["1"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->15890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lin", "[", 
  RowBox[{
   RowBox[{"1", "+", "x"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->6729],

Cell[BoxData[
 RowBox[{"p", "[", 
  RowBox[{"1", ",", "1"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->24370]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData["b"], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightArrow]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData["1"], "InlineFormula"],
 " and ",
 Cell[BoxData["a"], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightArrow]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->15350],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lin", "[", 
  RowBox[{"y", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->15006],

Cell[BoxData[
 RowBox[{"p", "[", 
  RowBox[{"0", ",", "1"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->31101]
}, Open  ]],

Cell[TextData[{
 "Standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions such as ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " have built\[Hyphen]in default values for their arguments. You can also set \
up defaults for your own functions, as described in \"",
 ButtonBox["Patterns",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PatternsAndTransformationRules#8519"],
 "\". "
}], "Text",
 CellID->24393],

Cell[TextData[{
 "Sometimes it is convenient not to assign a default value to an optional \
argument, such arguments can be specified with the help of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PatternSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PatternSequence"], "[", "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->6049856],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["p", "TI"], "|", 
     RowBox[{
      ButtonBox["PatternSequence",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PatternSequence"], "[", "]"}]}], Cell[
    TextData[{
     "optional pattern ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " with no default value"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->231005199],

Cell["Optional argument without a default value.", "Caption",
 CellID->155644798],

Cell[TextData[{
 "The pattern matches an optional second argument of ",
 Cell[BoxData["2"], "InlineFormula"],
 ", without a default value."
}], "MathCaption",
 CellID->126577014],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"g", "[", "1", "]"}], ",", 
    RowBox[{"g", "[", 
     RowBox[{"1", ",", "1"}], "]"}], ",", 
    RowBox[{"g", "[", 
     RowBox[{"1", ",", "2"}], "]"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"x_", ",", 
     RowBox[{"2", "|", 
      RowBox[{"PatternSequence", "[", "]"}]}]}], "]"}], "\[RuleDelayed]", 
   RowBox[{"p", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->266878488],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"p", "[", "1", "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"1", ",", "1"}], "]"}], ",", 
   RowBox[{"p", "[", "1", "]"}]}], "}"}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->212062089]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->210859024],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsOverview"]], "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Optional and Default Arguments - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Patterns", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/PatternsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/FunctionsWithVariableNumbersOfArguments"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SettingUpFunctionsWithOptionalArguments"]}], "Text",
       FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 35.7615694}", "context" -> "", 
    "keywords" -> {
     "arguments", "defaults", "omitted arguments", "optional", 
      "optional arguments", "patterns", "plus", "power", "times", 
      "PatternSequence"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Sometimes you may want to set up functions where certain arguments, if \
omitted, are given 'default values'. The pattern x_:v stands for an object \
that can be omitted, and if so, will be replaced by the default value v. This \
defines a function j with a required argument x, and optional arguments y and \
z, with default values 1 and 2, respectively. The default value of z is used \
here. ", "synonyms" -> {"2.3.9"}, "title" -> "Optional and Default Arguments",
     "type" -> "Tutorial", "uri" -> "tutorial/OptionalAndDefaultArguments"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.3.9"->{
  Cell[1791, 58, 93, 2, 70, "Title",
   CellTags->{"S2.3.9", "9.1"},
   CellID->17673]},
 "9.1"->{
  Cell[1791, 58, 93, 2, 70, "Title",
   CellTags->{"S2.3.9", "9.1"},
   CellID->17673]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.3.9", 18527, 687},
 {"9.1", 18626, 691}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1166, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1791, 58, 93, 2, 70, "Title",
 CellTags->{"S2.3.9", "9.1"},
 CellID->17673],
Cell[1887, 62, 510, 16, 70, "Text",
 CellID->4664],
Cell[2400, 80, 435, 15, 70, "MathCaption",
 CellID->15141],
Cell[2838, 97, 259, 9, 70, "Input",
 CellID->7711],
Cell[3100, 108, 133, 5, 70, "MathCaption",
 CellID->28253],
Cell[CellGroupData[{
Cell[3258, 117, 116, 4, 28, "Input",
 CellID->6868],
Cell[3377, 123, 216, 7, 36, "Output",
 CellID->25547]
}, Open  ]],
Cell[3608, 133, 187, 7, 70, "MathCaption",
 CellID->27644],
Cell[CellGroupData[{
Cell[3820, 144, 94, 3, 28, "Input",
 CellID->32662],
Cell[3917, 149, 216, 7, 36, "Output",
 CellID->32757]
}, Open  ]],
Cell[4148, 159, 1199, 39, 70, "DefinitionBox",
 CellID->20037],
Cell[5350, 200, 72, 1, 70, "Caption",
 CellID->12859],
Cell[5425, 203, 593, 19, 70, "Text",
 CellID->8723],
Cell[6021, 224, 929, 30, 70, "DefinitionBox",
 CellID->9741],
Cell[6953, 256, 71, 1, 70, "Caption",
 CellID->27529],
Cell[7027, 259, 335, 12, 70, "MathCaption",
 CellID->778],
Cell[CellGroupData[{
Cell[7387, 275, 358, 13, 70, "Input",
 CellID->12316],
Cell[7748, 290, 308, 11, 36, "Output",
 CellID->3035]
}, Open  ]],
Cell[8071, 304, 878, 28, 70, "Text",
 CellID->22190],
Cell[8952, 334, 398, 11, 70, "Text",
 CellID->1842],
Cell[9353, 347, 274, 11, 70, "MathCaption",
 CellID->288],
Cell[CellGroupData[{
Cell[9652, 362, 383, 14, 70, "Input",
 CellID->30106],
Cell[10038, 378, 308, 11, 36, "Output",
 CellID->9040]
}, Open  ]],
Cell[10361, 392, 129, 4, 70, "MathCaption",
 CellID->8942],
Cell[CellGroupData[{
Cell[10515, 400, 384, 14, 70, "Input",
 CellID->19264],
Cell[10902, 416, 335, 12, 36, "Output",
 CellID->22648]
}, Open  ]],
Cell[11252, 431, 234, 9, 70, "MathCaption",
 CellID->27446],
Cell[11489, 442, 253, 9, 70, "Input",
 CellID->23805],
Cell[11745, 453, 239, 10, 70, "MathCaption",
 CellID->15890],
Cell[CellGroupData[{
Cell[12009, 467, 142, 5, 70, "Input",
 CellID->6729],
Cell[12154, 474, 205, 7, 36, "Output",
 CellID->24370]
}, Open  ]],
Cell[12374, 484, 404, 17, 70, "MathCaption",
 CellID->15350],
Cell[CellGroupData[{
Cell[12803, 505, 119, 4, 70, "Input",
 CellID->15006],
Cell[12925, 511, 205, 7, 36, "Output",
 CellID->31101]
}, Open  ]],
Cell[13145, 521, 623, 21, 70, "Text",
 CellID->24393],
Cell[13771, 544, 347, 10, 70, "Text",
 CellID->6049856],
Cell[14121, 556, 419, 15, 70, "DefinitionBox",
 CellID->231005199],
Cell[14543, 573, 81, 1, 70, "Caption",
 CellID->155644798],
Cell[14627, 576, 178, 5, 70, "MathCaption",
 CellID->126577014],
Cell[CellGroupData[{
Cell[14830, 585, 479, 16, 70, "Input",
 CellID->266878488],
Cell[15312, 603, 326, 11, 36, "Output",
 CellID->212062089]
}, Open  ]],
Cell[CellGroupData[{
Cell[15675, 619, 72, 1, 70, "RelatedTutorialsSection",
 CellID->210859024],
Cell[15750, 622, 146, 3, 70, "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],
Cell[15923, 629, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

