(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    107057,       2609]
NotebookOptionsPosition[     97082,       2306]
NotebookOutlinePosition[    101169,       2395]
CellTagsIndexPosition[    101074,       2389]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"], 
          "Labeling Three\[Hyphen]Dimensional Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LabelingThreeDimensionalGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics and Sound\"\>", 
       2->"\<\"Labeling Three\[Hyphen]Dimensional Graphics\"\>"}, \
"\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Graphics Options" :> 
          Documentation`HelpLookup["paclet:guide/3DGraphicsOptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"3D Graphics Options\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"All" :> Documentation`HelpLookup["paclet:ref/All"], 
          "Automatic" :> Documentation`HelpLookup["paclet:ref/Automatic"], 
          "False" :> Documentation`HelpLookup["paclet:ref/False"], "None" :> 
          Documentation`HelpLookup["paclet:ref/None"], "Plot" :> 
          Documentation`HelpLookup["paclet:ref/Plot"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"All\"\>", 2->"\<\"Automatic\"\>", 
       3->"\<\"False\"\>", 4->"\<\"None\"\>", 5->"\<\"Plot\"\>", 
       6->"\<\"True\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Options for Graphics", "Title",
 CellTags->{"S1.9.2", "2.1"},
 CellID->7616],

Cell[TextData[{
 "When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " plots a graph for you, it has to make many choices. It has to work out \
what the scales should be, where the function should be sampled, how the axes \
should be drawn, and so on. Most of the time, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will probably make pretty good choices. However, if you want to get the \
very best possible pictures for your particular purposes, you may have to \
help ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in making some of its choices. "
}], "Text",
 CellID->18935],

Cell[TextData[{
 "There is a general mechanism for specifying \[OpenCurlyDoubleQuote]options\
\[CloseCurlyDoubleQuote] in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions. Each option has a definite name. As the last arguments to a \
function like ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ", you can include a sequence of rules of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["name", "TI"], "->", 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 ", to specify the values for various options. Any option for which you do \
not give an explicit rule is taken to have its \[OpenCurlyDoubleQuote]default\
\[CloseCurlyDoubleQuote] value."
}], "Text",
 CellID->17451],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Plot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Plot"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", ",", 
     StyleBox["option", "TI"], "->", 
     StyleBox["value", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[
    "make a plot, specifying a particular value for an option", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20600],

Cell["Choosing an option for a plot. ", "Caption",
 CellID->5249],

Cell[TextData[{
 "A function like ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " has many options that you can set. Usually you will need to use at most a \
few of them at a time. If you want to optimize a particular plot, you will \
probably do best to experiment, trying a sequence of different settings for \
various options. "
}], "Text",
 CellID->16519],

Cell[TextData[{
 "Each time you produce a plot, you can specify options for it. \"",
 ButtonBox["Redrawing and Combining Plots",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/RedrawingAndCombiningPlots"],
 "\" will also discuss how you can change some of the options, even after you \
have produced the plot. "
}], "Text",
 CellID->31556],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["AspectRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AspectRatio"], 
    RowBox[{"1", "/", 
     ButtonBox["GoldenRatio",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GoldenRatio"]}], Cell[TextData[{
     "the height\[Hyphen]to\[Hyphen]width ratio for the plot; ",
     Cell[BoxData[
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
     " sets it from the absolute ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["y", TraditionalForm]], "InlineMath"],
     " coordinates"
    }], "TableText"]},
   {
    ButtonBox["Axes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axes"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to include axes", "TableText"]},
   {
    ButtonBox["AxesLabel",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AxesLabel"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "labels to be put on the axes; ",
     Cell[BoxData[
      StyleBox["ylabel", "TI"]], "InlineFormula"],
     " specifies a label for the ",
     Cell[BoxData[
      FormBox["y", TraditionalForm]], "InlineMath"],
     " axis, ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["xlabel", "TI"], ",", 
       StyleBox["ylabel", "TI"], "}"}]], "InlineFormula"],
     " for both axes"
    }], "TableText"]},
   {
    ButtonBox["AxesOrigin",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AxesOrigin"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the point at which axes cross", "TableText"]},
   {
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle",
     ButtonNote->"ObsLink: TextStyle -> BaseStyle (LabelStyle)"], 
    RowBox[{"{", "}"}], Cell[
    "the default style to use for the plot", "TableText"]},
   {
    ButtonBox["FormatType",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FormatType"], 
    ButtonBox["TraditionalForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TraditionalForm"], Cell[
    "the default format type to use for text in the plot", "TableText"]},
   {
    ButtonBox["DisplayFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DisplayFunction"], 
    ButtonBox["$DisplayFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$DisplayFunction"], Cell[TextData[{
     "how to display graphics; ",
     Cell[BoxData[
      ButtonBox["Identity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Identity"]], "InlineFormula"],
     " causes no display"
    }], "TableText"]},
   {
    ButtonBox["Frame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Frame"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to draw a frame around the plot", "TableText"]},
   {
    ButtonBox["FrameLabel",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameLabel"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "labels to be put around the frame; give a list in clockwise order \
starting with the lower ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " axis"
    }], "TableText"]},
   {
    ButtonBox["FrameTicks",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameTicks"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "what tick marks to draw if there is a frame; ",
     Cell[BoxData[
      ButtonBox["None",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/None"]], "InlineFormula"],
     " gives no tick marks"
    }], "TableText"]},
   {
    ButtonBox["GridLines",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GridLines"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "what grid lines to include; ",
     Cell[BoxData[
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
     " includes a grid line for every major tick mark"
    }], "TableText"]},
   {
    ButtonBox["PlotLabel",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotLabel"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "an expression to be printed as a label for the plot", "TableText"]},
   {
    ButtonBox["PlotRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRange"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "the range of coordinates to include in the plot; ",
     Cell[BoxData[
      ButtonBox["All",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/All"]], "InlineFormula"],
     " includes all points"
    }], "TableText"]},
   {
    ButtonBox["Ticks",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Ticks"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "what tick marks to draw if there are axes; ",
     Cell[BoxData[
      ButtonBox["None",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/None"]], "InlineFormula"],
     " gives no tick marks"
    }], "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, True, False, False, False, False, False, False, False, False, 
     False, False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22798],

Cell[TextData[{
 "Some of the options for ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ". These can also be used in ",
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 ". "
}], "Caption",
 CellID->30303],

Cell["\<\
Here is a plot with all options having their default values. \
\>", "MathCaption",
 CellID->6224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->11008],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->101030822]
}, Open  ]],

Cell["This draws axes on a frame around the plot. ", "MathCaption",
 CellID->32609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Frame", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->14989],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->524183615]
}, Open  ]],

Cell[TextData[{
 "This specifies labels for the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axes. The expressions you give as labels are printed just as they would be \
if they appeared as ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output. You can give any piece of text by putting it inside a pair of \
double quotes. "
}], "MathCaption",
 CellID->3195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<x value\>\"", ",", 
      RowBox[{"Sin", "[", 
       RowBox[{"x", "^", "2"}], "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->20485],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->96116191]
}, Open  ]],

Cell["\<\
You can give several options at the same time, in any order. \
\>", "MathCaption",
 CellID->14343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"GridLines", "->", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->30523],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->56520583]
}, Open  ]],

Cell[TextData[{
 "Setting the ",
 Cell[BoxData[
  ButtonBox["AspectRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AspectRatio"]], "InlineFormula"],
 " option changes the whole shape of your plot. ",
 Cell[BoxData[
  ButtonBox["AspectRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AspectRatio"]], "InlineFormula"],
 " gives the ratio of width to height. Its default value is the inverse of \
the Golden Ratio\[LongDash]supposedly the most pleasing shape for a \
rectangle. "
}], "MathCaption",
 CellID->29314],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"AspectRatio", "->", "1"}]}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->9503],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdW0tsVVUUvbxPH6W0rwUKpVAKFGihLZT/H0EUJMYYB4j8xIIoDBSDONGJ
TnSiE50IITJATfwMMBKMCSZGEiOJkcRIYtTEYGJwIDGROCAxue5z9j133bve
eYcWEn8v7evd75699vfsfc65r/cNHzt08InhY4cPDM/cenT4qUOHDzw9c8uR
o/JRcUwURWfl93RHJNexXNnfs3Esf7PvU8x70dyzr+iE/bQi7+bDAt0tyGWD
l2MsfVo0byXQUVT28ulAfRUcOSqcQ5a+/M0vp9748oMzl6NFo9DHDHjckA0f
nfv2yJMfCsQrL1945ti5Gzf+HLxFux5z+giewCQ+fO/dr1979XNzOXBbuAf2
v//9d7+mHMXDh86IKHPZn0bORckXrYOkTcnSAinAQOGseNTSYs2O7W9fu/ZH
ggrZCwJcFz778blnP7ZOtvQn53944fnzN+OSGFz84idwiewH7j99/fqNDJex
T0eLTnLXXKpfRaCINZfzvTIOGG4JdiNpVH901lqVIbqITBNhP9d+S1+9+rv4
zFyOs7QkxaWvfjaXfQGut968dPz1i+ACHeIC9jiKqp9r2Nlx77ZT5nK8pYWQ
j8xlb87T+8lX48nTvQEZMqlkaoIL+RfiEseJ+8AlxomJ9bkeIY83u8wRk0yc
Qlwy/1968VNz2UK+nBfggvXKJUaJaTfjkrSRhAUXfOrn2kd2VS195cpve3e/
k+cycWJ7WimqcwMyECflwiwMcaEmKZekqiRsfa6HKe/ayAshLlFHlAIXcrw+
l5npE1wu3L355M1kIKoTyL45OU/vI8/qaDFCTMmPzsrYS9GcGOdneIgLtXQi
0SEuxEO5UC1DXJgBk8jOHsvlOk22Y7suzl1nLyEoIiqqIlquXA+sEA6vDvbE
+ZnQHuezWHF5jaGtNSNmhHKQoSoHVWw0+htS8VAtFA+5XQ+vHPu7+h6KWDvl
WAgvi8O04sqUkYljLicTPTuXCe4vo+yO8zNV801CJoEDCmehcqGO6X3MzRAX
PDuF6BAX/Kf3JYkklfJchTR6yGYdje7kl7ErzudqR5yfiyEuzPOpJHtWgAvz
XrlQx0JcqPnKhXoW4kJPUy7UMz/XTrK+M87PsBAX5kknZRa4TJx2kSY6Gn0n
JAN5No3smxngQk4rFyqcn+sh0mg6eTzEhXwzXKbH+e3R0ahVKgPzKiRDhshA
cIkxYlKey3h6J+XXdIpuSAaqSRfR3V6uHRTzGSQ7xIX8mkFR9nO1xvV7nFmF
1dsj++45vqY4PzdLdTDM2tDcs1s0iZ3eLSZ3ilHtXjnVtMaOqhOU0LWdqZno
2v1olUZwD7K7okpaPZQpsbtUg2ZXvg3pCHnXalsi1Ba2sQap8M9anKkMHMU6
iOX0Ey1k0X/JZkXEzGbda3VtzXyi3Y95zO4uXTfUsbNASHq/nL0zKrtKCafu
lNFRRmePvO5Yf7wwYi1GGjdeQbH2I7MvS9uTjnLaBeKkHt3U2ma/DSXszaNk
3zP6fHXV1a0bW+L82VWV7utpDbpjoc549U62EhUSS4qZ0f5K+aCl0U1s58rs
KGZ4ubZbGicNthNnVh4hLlq9ZNZ6IS7071mEolxmh3XSVV7FaBJSFg3yI8xi
kZDCInYl7daN5kj+3+iGlNbl2d9pd7JqH9F49Ik60dFtLOdHaqOkhERZJqrM
+n9BbCcTrZUXO5nGeuOTFXT7iKzXHiL9SeqcZLdUAO55ay2NfZjdG2eqSpcX
1/a9knBJWRGvypTZZkdgRak4WNf5cdRKmXSSe+Yk/R5LY3/a4+4nO08/SvZ8
12TwVktj/6oo2CH4UXQlKlqILuKoaAtFRFFwigAUV0/t3kULbXQXjbYnbEVp
j4m06V4d0jNaqXkGZbOlUQMVBfsqP0qLQxFdxOroToqFomBn60epOovEHyIu
2kRcioJe4EdpdX6Q2JjnFRvJq4qC3uBHaXMR1IdR0QYXq2TdNY/85EfRzoxe
sZ645mXyKI9iIjyJZsa6WPeZvc5P2V1rjeyJbpRgizcsd83zgoxfpnlRVAc8
TVtLXIqCfbYfpZ18vppytY8s9aNMJlmryJt9lHUhFMkv8YuxSFFQARQFFcCP
MoUsWhnnK0Cfy5+kAvhROsiiFeTdPvITUEx+THXZIwDGkuWUTfZJXaYCdHp1
mEpeW0Y5qyioACEUPKFcRl5dQNnnR+mkiC61NFaDioIK4EfRsx/UjcVOt2R1
aJ+xZk5kQijIk8Xk3X7S1Y8ynfwwRLL7nZSkGwLFRFhPZMSfItN4VblxKtTv
LEueqvh16CKZiyiiA0SntS/R2d/pu5xsyT7xSrTQ0qhKgxSFNoqdH3UGeXXQ
S8OfbSTFj9pNeTRAKIPkoTbyiKKOjeufRvGOsZuyZYA0UIn8NA1nbypRVz3Z
nRyfKPAqT/dLmGcLKPcXUr61ugxL+lrDbcnl2oP6t4jsq9L90cg1pO660DHM
dwBMbxwiP6scVLN6ctxJBsdxlvOP1LX0uwaZOr+I/F1N9KgE5ITOCWZTZmoH
QEdQeajWah8qQkMuU93O3S8FVvVS9IbIa1WyWqXwLOsh3XV1g1mlqDjDVlSc
ZIRQUQPnkceHKIMVFV3PjzqHdJtLfl5MtK6T0YkrKarxr3Kj+80hfy6xNPq8
omH2V7w6ziUde5LcWkq530zjQmjQsYdiuoRQmimaflSO8SwnJak3S8lSRUW9
9qNqPvIpEFCWUjQUFfU6hIpeMpMsXEYxb3K2JN11rBe1j3TtpqxeRrFXVFTg
ECqdRWW4dK2HbtpE44Fq8nMBeV17N1avyymKTUT7dZxPWd5FGaWoqPGKilrl
R+WVoq7DML91jYx1RhP5P4SKtfI0slDX73iWoDt89Cs/aj9lUCfFeiX5vZGi
2BhARcWbStmuOxb0gEaKvR91gCzuoBzg3VQj3QeqyahBNzdER7NX76AorCKd
Gymqfh15tTeZMmwNRUmfAGGu+VEXUhT4WyprSDd+xjIugIr9wSSXl8m3EteS
vytkmx/V9HdT4ycRt6JhLlWScU11UbJr8/TbV0ntX+fopEpXyEN+3YZoDuma
FTvl9YRSJil+XRdTNrdSJq0nT5TJE0A1eamdATWohXTcQBlVTvw43qvbEpcJ
YrE5Q2l2dDIzN1L+lUh3v8WqI85U9NuVqIuKiqpSpHz066p9Rlwv+WVQtYJh
DbeJLC+SXxXVzCgD6nsizmtXre+yCBGJ5qRtrNMgOTPTs0RUwwJ5RyXyuXPt
szVeva5wcgTanDY2OEuFNnrYk9CGdKbJS69bblGereLm7FnipVWiYJKhpN9Z
F/eKsfbstixrMsli9bEZMhqJZsDqjOaSVfIj6GKiPaUuiRghpXWIgOot2nLi
tvjcvsI9w/P/T0HtfzlEY/4CcN2xMg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->315165438]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "use internal algorithms", "TableText"]},
   {
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "do not include this", "TableText"]},
   {
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell["include everything", "TableText"]},
   {
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["do this", "TableText"]},
   {
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["do not do this", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25200],

Cell["Some common settings for various options. ", "Caption",
 CellID->13458],

Cell[TextData[{
 "When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " makes a plot, it tries to set the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " scales to include only the \[OpenCurlyDoubleQuote]interesting\
\[CloseCurlyDoubleQuote] parts of the plot. If your function increases very \
rapidly, or has singularities, the parts where it gets too large will be cut \
off. By specifying the option ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 ", you can control exactly what ranges of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinates are included in your plot. "
}], "Text",
 CellID->6618],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
show at least a large fraction of the points, including the \
\[OpenCurlyDoubleQuote]interesting\[CloseCurlyDoubleQuote] region (the \
default setting)\
\>", "TableText"]},
   {
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell["show all points", "TableText"]},
   {
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["max", "TI"]], "}"}], Cell[TextData[{
     "show a specific range of ",
     Cell[BoxData[
      FormBox["y", TraditionalForm]], "InlineMath"],
     " values"
    }], "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["xrange", "TI"], ",", 
     StyleBox["yrange", "TI"], "}"}], Cell[TextData[{
     "show the specified ranges of ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["y", TraditionalForm]], "InlineMath"],
     " values"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20580],

Cell[TextData[{
 "Settings for the option ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 ". "
}], "Caption",
 CellID->19796],

Cell[TextData[{
 "The setting for the option ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " gives explicit ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " limits for the graph. With the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " limits specified here, the bottom of the curve is cut off. "
}], "MathCaption",
 CellID->14798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1.2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->15281],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->303027403]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " always tries to plot functions as smooth curves. As a result, in places \
where your function wiggles a lot, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will use more points. In general, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tries to ",
 StyleBox["adapt",
  FontSlant->"Italic"],
 " its sampling of your function to the form of the function. There is, \
however, a limit, which you can set, to how finely ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will ever sample a function."
}], "Text",
 CellID->20798],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    RowBox[{"(", 
     FractionBox["1", "x"], ")"}]}], TraditionalForm]], "InlineMath"],
 " wiggles infinitely often when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[TildeEqual]", "0"}], TraditionalForm]], "InlineMath"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tries to sample more points in the region where the function wiggles a \
lot, but it can never sample the infinite number that you would need to \
reproduce the function exactly. As a result, there are slight glitches in the \
plot. "
}], "MathCaption",
 CellID->28009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"1", "/", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->27157],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->19328407]
}, Open  ]],

Cell[TextData[{
 "It is important to realize that since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can only sample your function at a limited number of points, it can always \
miss features of the function. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " adaptively samples the functions, increasing the number of samples near \
interesting features, but it is still possible to miss something. By \
increasing ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 ", you can make ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sample your function at a larger number of points. Of course, the larger \
you set ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 " to be, the longer it will take ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to plot ",
 StyleBox["any",
  FontSlant->"Italic"],
 " function, even a smooth one. "
}], "Text",
 CellID->12292],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "a list of lists of graphics primitives to use for each curve (see \"",
     ButtonBox["Graphics Directives and Options",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/GraphicsDirectivesAndOptions"],
     "\")"
    }], "TableText"]},
   {
    ButtonBox["ClippingStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ClippingStyle"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "what to draw when curves are clipped", "TableText"]},
   {
    ButtonBox["Filling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Filling"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "filling to insert under each curve", "TableText"]},
   {
    ButtonBox["FillingStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FillingStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style to use for filling", "TableText"]},
   {
    ButtonBox["PlotPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotPoints"], "50", Cell[
    "the initial number of points at which to sample the function", 
     "TableText"]},
   {
    ButtonBox["MaxRecursion",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxRecursion",
     ButtonNote->"ObsLink: PlotDivision -> MaxRecursion"], "6", Cell[
    "the maximum number of recursive subdivisions allowed", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23622],

Cell[TextData[{
 "More options for ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ". These cannot be used in ",
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 ". "
}], "Caption",
 CellID->18538],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " to specify a dashed curve."
}], "MathCaption",
 CellID->35507100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Dashed"}]}], "]"}]], "Input",
 CellLabel->"In[45]:=",
 CellID->25749676],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[45]=",
 CellID->62815778]
}, Open  ]],

Cell[TextData[{
 "When plotting multiple functions, ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " settings in a list are used sequentially for each function."
}], "MathCaption",
 CellID->4408717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "^", "2"}], "]"}], ",", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"x", "^", "2"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[46]:=",
 CellID->530519394],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[46]=",
 CellID->127242887]
}, Open  ]],

Cell[TextData[{
 "When a ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " contains a sublist, the settings are combined."
}], "MathCaption",
 CellID->513452338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "^", "2"}], "]"}], ",", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"x", "^", "2"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Thick"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[48]:=",
 CellID->440408831],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[48]=",
 CellID->104403116]
}, Open  ]],

Cell[TextData[{
 "By default nothing is indicated when the ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " is set so that it cuts off curves."
}], "MathCaption",
 CellID->84905798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "^", "2"}], "]"}], ",", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"x", "^", "2"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "0.9"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->186928247],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1009820869]
}, Open  ]],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  ButtonBox["ClippingStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClippingStyle"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " draws a dashed line where a curve is cut off. "
}], "MathCaption",
 CellID->218939621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "^", "2"}], "]"}], ",", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"x", "^", "2"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "0.9"}], ",", 
   RowBox[{"ClippingStyle", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->79922884],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->562761113]
}, Open  ]],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  ButtonBox["ClippingStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClippingStyle"]], "InlineFormula"],
 " to a list defines the style for the parts cut off at the bottom and top. "
}], "MathCaption",
 CellID->206944796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "^", "2"}], "]"}], ",", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"x", "^", "2"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "0.9"}], ",", 
   RowBox[{"ClippingStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Green", ",", "Red"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->30323444],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->64729043]
}, Open  ]],

Cell[TextData[{
 "This specifies filling between the curve and the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis."
}], "MathCaption",
 CellID->874907828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->17002209],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->216665873]
}, Open  ]],

Cell["\<\
The filling can be specified to extend to an arbitrary height, such as the \
bottom of the graphic. Filling colors are automatically blended where they \
overlap.\
\>", "MathCaption",
 CellID->274060070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}]}], "]"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->104715825],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]=",
 CellID->113608067]
}, Open  ]],

Cell["\<\
This specifies a specific filling to be used only for the first curve.\
\>", "MathCaption",
 CellID->132008832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", ".5"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[52]:=",
 CellID->237700373],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[52]=",
 CellID->107091964]
}, Open  ]],

Cell["\<\
This shows a filling from the first curve to the second using a non-default \
filling style.\
\>", "MathCaption",
 CellID->754695501],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}], "}"}]}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", "LightBrown"}]}], "]"}]], "Input",
 CellLabel->"In[50]:=",
 CellID->198431612],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[50]=",
 CellID->139273824]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->22037909],

Cell[TextData[ButtonBox["3D Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGraphicsOptions"]], "TutorialMoreAbout",
 CellID->8690014]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->58193159],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "RelatedTutorials",\

 CellID->151800574],

Cell[TextData[ButtonBox["Labeling Three\[Hyphen]Dimensional Graphics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/LabelingThreeDimensionalGraphics"]], "RelatedTutorials",
 CellID->149309017]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->29056165],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->328064950],

Cell[TextData[ButtonBox["M205: Visualization and Dynamic Interactivity",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://www.wolfram.com/services/education/minicourses/m205.html"], 
   None}]], "TutorialRelatedLinks",
 CellID->429055449]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Options for Graphics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Graphics and Sound", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/GraphicsAndSoundOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/BasicPlotting"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/RedrawingAndCombiningPlots"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 41.3242118}", "context" -> "", 
    "keywords" -> {
     "abscissa", "adaptive sampling", "all", "arbitrary precision numbers", 
      "arguments", "AspectRatio", "aspect ratio", "automatic", "axes", 
      "AxesLabel", "AxesOrigin", "boxes", "color", "compilation", "compiled", 
      "coordinates", "curves", "dashed lines", "defaults", "DisplayFunction", 
      "distortion", "efficiency", "essential singularities", "false", "frame",
       "FrameLabel", "FrameTicks", "functions", "glitches", "GoldenRatio", 
      "graphics", "GridLines", "headings", "height of plots", "Inline code", 
      "kinks", "labels", "legends on plots", "lines", "MaxBend", "names", 
      "none", "options", "ordinates", "origin", "plot", "PlotDivision", 
      "PlotLabel", "PlotPoints", "PlotRange", "plots", "PlotStyle", 
      "sampling in plots", "scales", "shape", "show", "singularities", 
      "smooth curves", "speed", "squashing", "subdivision", "text", 
      "tick marks", "ticks", "titles", "true", "width", "wiggles", "xaxis", 
      "yaxis", "zoom"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "When Mathematica plots a graph for you, it has to make many choices. It \
has to work out what the scales should be, where the function should be \
sampled, how the axes should be drawn, and so on. Most of the time, \
Mathematica will probably make pretty good choices. However, if you want to \
get the very best possible pictures for your particular purposes, you may \
have to help Mathematica in making some of its choices. There is a general \
mechanism for specifying 'options' in Mathematica functions. Each option has \
a definite name. As the last arguments to a function like Plot, you can \
include a sequence of rules of the form name->value, to specify the values \
for various options. Any option for which you do not give an explicit rule is \
taken to have its 'default' value. Choosing an option for a plot. ", 
    "synonyms" -> {"1.9.2"}, "title" -> "Options for Graphics", "type" -> 
    "Tutorial", "uri" -> "tutorial/Options"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.9.2"->{
  Cell[3026, 83, 82, 2, 70, "Title",
   CellTags->{"S1.9.2", "2.1"},
   CellID->7616]},
 "2.1"->{
  Cell[3026, 83, 82, 2, 70, "Title",
   CellTags->{"S1.9.2", "2.1"},
   CellID->7616]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.9.2", 100865, 2378},
 {"2.1", 100963, 2382}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2401, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3026, 83, 82, 2, 70, "Title",
 CellTags->{"S1.9.2", "2.1"},
 CellID->7616],
Cell[3111, 87, 602, 16, 70, "Text",
 CellID->18935],
Cell[3716, 105, 758, 20, 70, "Text",
 CellID->17451],
Cell[4477, 127, 1001, 29, 70, "DefinitionBox",
 CellID->20600],
Cell[5481, 158, 65, 1, 70, "Caption",
 CellID->5249],
Cell[5549, 161, 428, 11, 70, "Text",
 CellID->16519],
Cell[5980, 174, 344, 8, 70, "Text",
 CellID->31556],
Cell[6327, 184, 5985, 184, 70, "DefinitionBox3Col",
 CellID->22798],
Cell[12315, 370, 336, 13, 70, "Caption",
 CellID->30303],
Cell[12654, 385, 107, 3, 70, "MathCaption",
 CellID->6224],
Cell[CellGroupData[{
Cell[12786, 392, 235, 8, 28, "Input",
 CellID->11008],
Cell[13024, 402, 2906, 52, 126, "Output",
 Evaluatable->False,
 CellID->101030822]
}, Open  ]],
Cell[15945, 457, 83, 1, 70, "MathCaption",
 CellID->32609],
Cell[CellGroupData[{
Cell[16053, 462, 277, 9, 28, "Input",
 CellID->14989],
Cell[16333, 473, 3093, 55, 135, "Output",
 Evaluatable->False,
 CellID->524183615]
}, Open  ]],
Cell[19441, 531, 605, 19, 70, "MathCaption",
 CellID->3195],
Cell[CellGroupData[{
Cell[20071, 554, 405, 13, 28, "Input",
 CellID->20485],
Cell[20479, 569, 2775, 50, 127, "Output",
 Evaluatable->False,
 CellID->96116191]
}, Open  ]],
Cell[23269, 622, 108, 3, 70, "MathCaption",
 CellID->14343],
Cell[CellGroupData[{
Cell[23402, 629, 328, 10, 28, "Input",
 CellID->30523],
Cell[23733, 641, 3685, 64, 135, "Output",
 Evaluatable->False,
 CellID->56520583]
}, Open  ]],
Cell[27433, 708, 528, 15, 70, "MathCaption",
 CellID->29314],
Cell[CellGroupData[{
Cell[27986, 727, 279, 9, 28, "Input",
 CellID->9503],
Cell[28268, 738, 3662, 64, 184, "Output",
 Evaluatable->False,
 CellID->315165438]
}, Open  ]],
Cell[31945, 805, 1035, 32, 70, "DefinitionBox",
 CellID->25200],
Cell[32983, 839, 77, 1, 70, "Caption",
 CellID->13458],
Cell[33063, 842, 884, 26, 70, "Text",
 CellID->6618],
Cell[33950, 870, 1467, 46, 70, "DefinitionBox",
 CellID->20580],
Cell[35420, 918, 202, 8, 70, "Caption",
 CellID->19796],
Cell[35625, 928, 453, 14, 70, "MathCaption",
 CellID->14798],
Cell[CellGroupData[{
Cell[36103, 946, 331, 11, 28, "Input",
 CellID->15281],
Cell[36437, 959, 2930, 52, 144, "Output",
 Evaluatable->False,
 CellID->303027403]
}, Open  ]],
Cell[39382, 1014, 613, 19, 70, "Text",
 CellID->20798],
Cell[39998, 1035, 632, 19, 70, "MathCaption",
 CellID->28009],
Cell[CellGroupData[{
Cell[40655, 1058, 256, 9, 28, "Input",
 CellID->27157],
Cell[40914, 1069, 4365, 76, 134, "Output",
 Evaluatable->False,
 CellID->19328407]
}, Open  ]],
Cell[45294, 1148, 1039, 32, 70, "Text",
 CellID->12292],
Cell[46336, 1182, 2129, 61, 70, "DefinitionBox3Col",
 CellID->23622],
Cell[48468, 1245, 327, 13, 70, "Caption",
 CellID->18538],
Cell[48798, 1260, 220, 8, 70, "MathCaption",
 CellID->35507100],
Cell[CellGroupData[{
Cell[49043, 1272, 291, 9, 28, "Input",
 CellID->25749676],
Cell[49337, 1283, 2640, 47, 126, "Output",
 Evaluatable->False,
 CellID->62815778]
}, Open  ]],
Cell[51992, 1333, 276, 8, 70, "MathCaption",
 CellID->4408717],
Cell[CellGroupData[{
Cell[52293, 1345, 461, 15, 28, "Input",
 CellID->530519394],
Cell[52757, 1362, 4406, 76, 126, "Output",
 Evaluatable->False,
 CellID->127242887]
}, Open  ]],
Cell[57178, 1441, 238, 8, 70, "MathCaption",
 CellID->513452338],
Cell[CellGroupData[{
Cell[57441, 1453, 520, 17, 28, "Input",
 CellID->440408831],
Cell[57964, 1472, 4996, 86, 126, "Output",
 Evaluatable->False,
 CellID->104403116]
}, Open  ]],
Cell[62975, 1561, 259, 8, 70, "MathCaption",
 CellID->84905798],
Cell[CellGroupData[{
Cell[63259, 1573, 406, 13, 28, "Input",
 CellID->186928247],
Cell[63668, 1588, 4401, 76, 118, "Output",
 Evaluatable->False,
 CellID->1009820869]
}, Open  ]],
Cell[68084, 1667, 377, 13, 70, "MathCaption",
 CellID->218939621],
Cell[CellGroupData[{
Cell[68486, 1684, 465, 14, 28, "Input",
 CellID->79922884],
Cell[68954, 1700, 4608, 80, 118, "Output",
 Evaluatable->False,
 CellID->562761113]
}, Open  ]],
Cell[73577, 1783, 274, 8, 70, "MathCaption",
 CellID->206944796],
Cell[CellGroupData[{
Cell[73876, 1795, 515, 16, 28, "Input",
 CellID->30323444],
Cell[74394, 1813, 4563, 79, 118, "Output",
 Evaluatable->False,
 CellID->64729043]
}, Open  ]],
Cell[78972, 1895, 182, 6, 70, "MathCaption",
 CellID->874907828],
Cell[CellGroupData[{
Cell[79179, 1905, 287, 9, 28, "Input",
 CellID->17002209],
Cell[79469, 1916, 3207, 57, 126, "Output",
 Evaluatable->False,
 CellID->216665873]
}, Open  ]],
Cell[82691, 1976, 213, 5, 70, "MathCaption",
 CellID->274060070],
Cell[CellGroupData[{
Cell[82929, 1985, 349, 11, 28, "Input",
 CellID->104715825],
Cell[83281, 1998, 3845, 67, 127, "Output",
 Evaluatable->False,
 CellID->113608067]
}, Open  ]],
Cell[87141, 2068, 121, 3, 70, "MathCaption",
 CellID->132008832],
Cell[CellGroupData[{
Cell[87287, 2075, 402, 13, 28, "Input",
 CellID->237700373],
Cell[87692, 2090, 3516, 62, 127, "Output",
 Evaluatable->False,
 CellID->107091964]
}, Open  ]],
Cell[91223, 2155, 143, 4, 70, "MathCaption",
 CellID->754695501],
Cell[CellGroupData[{
Cell[91391, 2163, 488, 15, 28, "Input",
 CellID->198431612],
Cell[91882, 2180, 3609, 63, 127, "Output",
 Evaluatable->False,
 CellID->139273824]
}, Open  ]],
Cell[CellGroupData[{
Cell[95528, 2248, 65, 1, 70, "TutorialMoreAboutSection",
 CellID->22037909],
Cell[95596, 2251, 154, 3, 70, "TutorialMoreAbout",
 CellID->8690014]
}, Open  ]],
Cell[CellGroupData[{
Cell[95787, 2259, 71, 1, 70, "RelatedTutorialsSection",
 CellID->58193159],
Cell[95861, 2262, 166, 4, 70, "RelatedTutorials",
 CellID->151800574],
Cell[96030, 2268, 200, 4, 70, "RelatedTutorials",
 CellID->149309017]
}, Open  ]],
Cell[CellGroupData[{
Cell[96267, 2277, 97, 1, 70, "TutorialRelatedLinksSection",
 CellID->29056165],
Cell[96367, 2280, 414, 13, 70, "TutorialRelatedLinks",
 CellID->328064950],
Cell[96784, 2295, 244, 5, 70, "TutorialRelatedLinks",
 CellID->429055449]
}, Open  ]]
}, Open  ]],
Cell[97055, 2304, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

