(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44714,       1106]
NotebookOptionsPosition[     39192,        960]
NotebookOutlinePosition[     42927,       1045]
CellTagsIndexPosition[     42831,       1039]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cell" :> Documentation`HelpLookup["paclet:ref/Cell"], 
          "GridBox" :> Documentation`HelpLookup["paclet:ref/GridBox"], "None" :> 
          Documentation`HelpLookup["paclet:ref/None"], "StyleBox" :> 
          Documentation`HelpLookup["paclet:ref/StyleBox"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cell\"\>", 2->"\<\"GridBox\"\>", 
       3->"\<\"None\"\>", 4->"\<\"StyleBox\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Options for Expression Input and Output", "Title",
 CellTags->{"S2.11.11", "11.1"},
 CellID->24767],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell[
    "typical default value", "TableHeader"], ""},
   {
    ButtonBox["AutoIndent",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AutoIndent"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
whether to indent after an explicit Return character is entered\
\>", "TableText"]},
   {
    ButtonBox["DelimiterFlashTime",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DelimiterFlashTime"], "0.3", Cell["\<\
the time in seconds to flash a delimiter when a matching one is entered\
\>", "TableText"]},
   {
    ButtonBox["ShowAutoStyles",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ShowAutoStyles"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether to show automatic style variations for syntactic and other constructs\
\
\>", "TableText"]},
   {
    ButtonBox["ShowCursorTracker",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ShowCursorTracker"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether an elliptical spot should appear momentarily to guide the eye if the \
cursor position jumps\
\>", "TableText"]},
   {
    ButtonBox["ShowSpecialCharacters",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ShowSpecialCharacters"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to replace ",
     Cell[BoxData[
      RowBox[{"\[Backslash]", 
       RowBox[{"[", 
        StyleBox["Name", "TI"], "]"}]}]], "InlineFormula"],
     " by a special character as soon as the ",
     Cell[BoxData["]"], "InlineFormula"],
     " is entered"
    }], "TableText"]},
   {
    ButtonBox["ShowStringCharacters",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ShowStringCharacters"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to display ",
     Cell[BoxData["\"\<\>"], "InlineFormula"],
     " when a string is entered"
    }], "TableText"]},
   {
    ButtonBox["SingleLetterItalics",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SingleLetterItalics"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to put single\[Hyphen]letter symbol names in italics\
\>", "TableText"]},
   {
    ButtonBox["ZeroWidthTimes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ZeroWidthTimes"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to represent multiplication by a zero width character\
\>", "TableText"]},
   {
    ButtonBox["InputAliases",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/InputAliases"], 
    RowBox[{"{", "}"}], Cell[TextData[{
     "additional ",
     Cell[BoxData["\[AliasIndicator]"], "InlineFormula"],
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     Cell[BoxData["\[AliasIndicator]"], "InlineFormula"],
     " aliases to allow"
    }], "TableText"]},
   {
    ButtonBox["InputAutoReplacements",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/InputAutoReplacements"], 
    RowBox[{"{", 
     RowBox[{"\"\<->\>\"", "->", 
      RowBox[{"\"\<\>", "\[Rule]", "\"\<,\!\(\*
StyleBox[\"\[Ellipsis]\", \"TR\"]\)} \>"}]}]}], Cell[
    "strings to automatically replace on input", "TableText"]},
   {
    ButtonBox["AutoItalicWords",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AutoItalicWords"], 
    RowBox[{"{", "\"\<Mathematica\>\"", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[
    "words to automatically put in italics", "TableText"]},
   {
    ButtonBox["LanguageCategory",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LanguageCategory"], "\"\<NaturalLanguage\>\"", 
    Cell["\<\
what category of language to assume a cell contains for spell checking and \
hyphenation\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, True, False, False, False, False, False, False, False, False, 
     False, False, {False}, False}, "RowsIndexed" -> {}}},
 CellID->23655],

Cell["\<\
Options associated with the interactive entering of expressions. \
\>", "Caption",
 CellID->15574],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["SingleLetterItalics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SingleLetterItalics"]], "InlineFormula"],
 " is typically set whenever a cell uses ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->4031],

Cell[TextData[{
 "Here is an expression entered with default options for a ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " input cell. "
}], "MathCaption",
 CellID->12052],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWmtMVdkVPtwncC+gTIDio+IjM2UQBTuG1Mapxthaq0ZmaseMhJYgdoit
EiFGjRnfPxSsTWs0mHQE1Oj4bCHaGCvYimB5DEFeKj7mIiAq8hgBEcXVs9bd
+3BwNofD5dJxTnLOPWc/1vr2t9dee+199+K4lM8S/hiXkhgfF/KLdXFJnyXG
J4f8fO06OcnoIUmGAEmSokIkfAf5lT36riB8SJLR+UV58uMdfHiwFKOSJfF8
rUL37t2T88+cOUMPX3wYKNFIiVwOr2juUyxfcjmorq6WnG/4sFFdE6byXDh/
/rxBrBx/+uqO0tDbv47BWYdfdnxoobb0Q82xUaM5Pd5UwaQ0ixXQAP6mQmdj
+GWlb/ObVGFpya1C8ZYZdq9QIVLrgCz2t1LPAVCOSNPdKlTVpv8D0reOTzZY
3/JO+n7x+baM98VMVEfnKzh76Ql8+c/HdNc6uqQIjbwoF/NCNfICNPKOs7z0
w4UQk3CM7k/jj8Ku1H9J/no51raEJUzMtbJ2GPWTAjBOu0p3Suo9hQpRXpSL
eaEaeQEaeZyKtvbn0NjUTrejrgU+WpEhpMJFG/6Ankbo7e2Furo6+voBS/tT
Zj0E/ew6vOjplYJY2uvXr6nc06dPheV+qJJ39+5dePHihbDceIG8YA29anyj
Ncqp006ytKZH38hWdExV1y3UOZtlhdKqZ2CJyAfT9KuQ/1U7eH9wDaSpV+Hz
/V9LdgZh9uzZ0NTUxJQ7n2iZEyZMIHlTpkyB48ePO0MQnTKz85opLePvTZLn
gHrsEBsby2Miur29vanMs2fPFP1GoxFmzZoFly9f1gPBJoDgK4BgYmlVVVVg
sVhoABLLMmCr1Uq9ildpaSmMGTOGoNhsNjh9+rTZjTBcZML9EFzvdLNOPRZB
OT3jYBjBDx8Hz7t7YdsBB5jlJhTIHs1/ViEs+UMVfN3wXLFZf39/ePDggYoS
CyQlJcHUqVPB4XBAQkIC0SO7BeMQxC5MrARrZD5EfPyVMhS+rcpOHiknJwfs
djusWLECcnNzyQOhHe7fvx8uXryIHQ+hoaEwZ84ckw4INgEEXwEEpyxf6Onp
oQ4zmUywY8cOOHjwIPj4+FA6XpGRkRAYGAiZmZkQHh5Oee3t7e6E4iIbZrdD
GFbfm3WqsgjKDWtm0I4vxrLe3vTn+zSXz44tx2bYmPQ1a9bAwoULwWw2w9y5
c/FdIQOJWL16NYk9deoUqbh586ZZLNHOJN6vfw6G8Ktw8EQjeY8rRW2KtxFp
s6o4QgPs6w4jbN++HTw8PGg2HkCtTUPt4I30gba2NpgxYwZMnDiRDJBPAbW1
tdTgzZs30/e5c+fo+8SJE6wL3QZFLwNuVutaN5uHpU1c78vhmP/gE0IwE4W+
5OOkarDNvAYf/racYjIOOSsrC/bs2QNeXl6wadMmfFfmwe7ubpI1duxYOHny
JLlLfJflsTJi2XxEbNh3HwI/vC671F74JLkGlq6pUugQ6RXZg4GVRzMsLCyE
x48fE47JkycrsrTaJ8Kg1XanrdnhyZMn5G9xeLS0tBDX6IPZUKDvO3fu0Pfu
3btHAspQ6bCMAIbhmoLZRb1a9fSOGhc3UngYVd/UDcvW1VD0lvvfVnjnp4Ww
4PcVUH23k3WDETo6OoBd/bqr//RqhoCAAAgJCQGDwUBBxZEjRxRq9ejp6upC
T6iSaYW8ImfZ8OhSaG7tgZWf3yYHk5X9SJlr1Vi0zAmtXB2MHzhwQBc+Lx1Y
RCGnE4uNJh6MeuLi4ojEvLw8wiBH4/R9+/Zt+k5LS2N4vLXwUB2cyORhYWHF
NaCpi3u5gTHeMyPB2HAtyahDr8jaRFZt0iHLKBghWToH7rDWP3a4Xv4NhC4u
gXd/VQz/Lm6DH/+mjN7/kdtMMtDHYHQfEREBlZWVvIVr167lnl6JuTAUDgsL
g/r6eujs7OSx02AaioqKaPmMUfTMmTOhsbFRIS3t8AOY8stieH9JCVTWdsCc
392gb5k8ZdiqoQxshCYYP348xMfHQ3Z2NjQ3N5t1EoDz1rRp0yhMkecuE2uV
BjKqxmMk3EDAqtu2bRMi5izduHFDiSoXLFgA48aNo/eGhgZa3W/cuJG+eR9e
uHCBsaTdBPTro0ePhkmTJlEftra28mpaTRBUE3X9EPi26AArIE0PWEE3DdlO
rVrA2AAdvNdFtizqdT32zXl8YwRyv3Cr9hF8FJMBLa2d7loFhjAx6M58fX3h
5cuXsGHDBkQu+bE8dFEYtWO4l5KSQltBPgwpt9/o6GjYuXNnMEtG8bgpgJsH
8krFyCShfaBTxnbhPX/+fCXKKS4uhuXLl5Mk5FNe2CuBMmpZuXIlLFq0CG7d
ugXl5eVsCW2G6dOnY3RH6wncqlu1apUyCW3dupUMC9dxuD+xdOlSRSa2lAeu
8+bNg/T0dAWLKM9v6E3Tgq/VbC3ig8TE8x16UT9mMvMpr2iA6E8Pw69js9y5
Mz+BieKxSWJiIvmQzMxMZqUmDDOpM7Zs2QKvXr3ijcc19vr162kPCQMGbOAY
hhbH1a5duyA/P1/iJGNUf+jQIeXOyclRiET0OP5KSkrIk8reVdlmQfKioqJw
6Ct2g3upcr8SS5cuXUJYTI+JNpvQ+yIuOZ2LweUrepGamho2APqnjRoidBE8
reYMwGaABps8T9Q5GUwc2gW6lbz/3MGwQ/f/V3pNwwQPHz4ET09P9NK4SJzI
NOBuu5+fH7m7s2fPUhdEMk6wfXv37sVYjnHtHEcs7iLOMzIypB+x8leuXCEX
jAc9fARp72nIsAt0hmlgDBA3K4NV4XziLwvlBhxvLqy/Qph21IqODbtbtpwQ
FWBcKcbExNCdm5urkIqrVKyiJhX3s4KDgyE5OZmWGvKqWXqX5eFe77Jly4gY
zKuoqFAMVJT3noZMuwBDmAbmQHEzv6BkSz+S8WJEu+nP10kMLG4hpKam4ohW
pkoZBBw9elS5HQ6HNEM18nH5DxQ69KXh8h1lcGstKyuDffv2QUFBgVJOnRYq
qOsr0PG+BqYgQRv+xtLq6lvhr+n5kPaXPJmWmIRjctqST76g/7GxhBtXHVSg
lclT/0mMd1dXjzunIlAu3Wdm+tuBalvkuzqO8T0/MyPm0+3HW1gHfRco36bz
MtpCRwzpt4T2P7qo5tOZKLl8dLHv1Ked1Br1/gPsyolN1+rwi4d/atsc7Lyr
Pz6cyxWVJHaAVvL4H/W+br0=\
\>"], "Picture",
 ImageSize->{533, 55},
 ImageMargins->0,
 CellID->2039208850],

Cell[TextData[{
 "Here is the same expression entered in a cell with ",
 Cell[BoxData[
  RowBox[{"SingleLetterItalics", "->", "True"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"ZeroWidthTimes", "->", "True"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1150],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 55},
 ImageMargins->0,
 CellID->1032272988],

Cell[TextData[{
 "Built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are a large number of aliases for common special characters. ",
 Cell[BoxData[
  ButtonBox["InputAliases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputAliases"]], "InlineFormula"],
 " allows you to add your own aliases for further special characters or for \
any other kind of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input. A rule of the form ",
 Cell[BoxData[
  RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "->", 
   StyleBox["expr", "TI"]}]], "InlineFormula"],
 " specifies that ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"\[AliasIndicator]", 
    StyleBox["name", "TI"], "\[AliasIndicator]"}]]], "InlineFormula"],
 " should immediately be replaced on input by ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->21724],

Cell[TextData[{
 "Aliases are delimited by explicit ",
 StyleBox["Esc", "KeyEvent"],
 " characters. The option ",
 Cell[BoxData[
  ButtonBox["InputAutoReplacements",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputAutoReplacements"]], "InlineFormula"],
 " allows you to specify that certain kinds of input sequences should be \
immediately replaced even when they have no explicit delimiters. By default, \
for example, ",
 Cell[BoxData["->"], "InlineFormula"],
 " is immediately replaced by ",
 Cell[BoxData[
  FormBox["\[Rule]", TraditionalForm]], "InlineMath"],
 ". You can give a rule of the form ",
 Cell[BoxData[
  RowBox[{"\"\<\!\(\*
StyleBox[\"seq\", \"TI\"]\)\>\"", "->", "\"\<\!\(\*
StyleBox[\"rhs\", \"TI\"]\)\>\""}]], "InlineFormula"],
 " to specify that whenever ",
 Cell[BoxData[
  StyleBox["seq", "TI"]], "InlineFormula"],
 " appears as a token in your input, it should immediately be replaced by ",
 Cell[BoxData[
  StyleBox["rhs", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->13966],

Cell[BoxData[GridBox[{
   {"\"\<NaturalLanguage\>\"", Cell[
    "human natural language such as English", "TableText"]},
   {"\"\<Mathematica\>\"", Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " input"
    }], "TableText"]},
   {"\"\<Formula\>\"", Cell["mathematical formula", "TableText"]},
   {
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "do no spell checking or hyphenation", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3430],

Cell[TextData[{
 "Settings for ",
 StyleBox["LanguageCategory", "MR"],
 " to control spell checking and hyphenation. "
}], "Caption",
 CellID->31107],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["LanguageCategory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LanguageCategory"]], "InlineFormula"],
 " allows you to tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " what type of contents it should assume cells have. This determines how \
spelling and structure should be checked, and how hyphenation should be done. \
"
}], "Text",
 CellID->30191],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell[
    "typical default value", "TableHeader"], ""},
   {
    ButtonBox["StructuredSelection",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StructuredSelection"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to allow only complete subexpressions to be selected", 
     "TableText"]},
   {
    ButtonBox["DragAndDrop",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DragAndDrop"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to allow drag\[Hyphen]and\[Hyphen]drop editing\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->18007],

Cell["\<\
Options associated with interactive manipulation of expressions. \
\>", "Caption",
 CellID->11337],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " normally allows you to select any part of an expression that you see on \
the screen. Occasionally, however, you may find it useful to get ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to allow only selections which correspond to complete subexpressions. You \
can do this by setting the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["StructuredSelection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StructuredSelection"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->15457],

Cell["Here is an expression with a piece selected. ", "MathCaption",
 CellID->12287],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 55},
 ImageMargins->0,
 CellID->1420343408],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["StructuredSelection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StructuredSelection"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " only complete subexpressions can ever be selected. "
}], "MathCaption",
 CellID->10383],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 121},
 ImageMargins->0,
 CellID->1094317276],

Cell[TextData[{
 "Unlike most of the other options here, the ",
 Cell[BoxData[
  ButtonBox["DragAndDrop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DragAndDrop"]], "InlineFormula"],
 " option can only be set for the entire front end, rather than for \
individual cells or cell styles."
}], "Text",
 CellID->525717441],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["GridBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GridBox"], "[", 
     StyleBox["data", "TI"], ",", 
     StyleBox["opts", "TI"], "]"}], Cell[
    "give options that apply to a particular grid box", "TableText"]},
   {
    RowBox[{
     ButtonBox["StyleBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StyleBox"], "[", 
     StyleBox["boxes", "TI"], ",", 
     StyleBox["opts", "TI"], "]"}], Cell[TextData[{
     "give options that apply to all boxes in ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Cell",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cell"], "[", 
     StyleBox["contents", "TI"], ",", 
     StyleBox["opts", "TI"], "]"}], Cell[TextData[{
     "give options that apply to all boxes in ",
     Cell[BoxData[
      StyleBox["contents", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Cell",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cell"], "[", 
     StyleBox["contents", "TI"], ",", "GridBoxOptions", "->", 
     StyleBox["opts", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give default options settings for all ",
     Cell[BoxData[
      ButtonBox["GridBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GridBox"]], "InlineFormula"],
     " objects in ",
     Cell[BoxData[
      StyleBox["contents", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->8909],

Cell["\<\
Examples of specifying options for the display of expressions. \
\>", "Caption",
 CellID->32209],

Cell[TextData[{
 "As discussed in \"",
 ButtonBox["Textual Input and Output",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TextualInputAndOutputOverview"],
 "\", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides many options for specifying how expressions should be displayed. \
By using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["StyleBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StyleBox"], "[", 
   RowBox[{
    StyleBox["boxes", "TI"], ",", 
    StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
 " you can apply such options to collections of boxes. But ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is set up so that any option that you can give to a ",
 Cell[BoxData[
  ButtonBox["StyleBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StyleBox"]], "InlineFormula"],
 " can also be given to a complete ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 " object, or even a complete ",
 Cell[BoxData[
  ButtonBox["Notebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
 ". Thus, for example, options like ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LineIndent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LineIndent"]], "InlineFormula"],
 " can be given to complete cells as well as to individual ",
 Cell[BoxData[
  ButtonBox["StyleBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StyleBox"]], "InlineFormula"],
 " objects."
}], "Text",
 CellID->9758],

Cell[TextData[{
 "There are some options that apply only to a particular type of box, such as \
",
 Cell[BoxData[
  ButtonBox["GridBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridBox"]], "InlineFormula"],
 ". Usually these options are best given separately in each ",
 Cell[BoxData[
  ButtonBox["GridBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridBox"]], "InlineFormula"],
 " where they are needed. But sometimes you may want to specify default \
settings to be inherited by all ",
 Cell[BoxData[
  ButtonBox["GridBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridBox"]], "InlineFormula"],
 " objects that appear in a particular cell. You can do this by giving these \
default settings as the value of the option ",
 Cell[BoxData["GridBoxOptions"], "InlineFormula"],
 " for the whole cell. "
}], "Text",
 CellID->24221],

Cell[TextData[{
 "For most box types named ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["XXX", "TI"], "Box"}]]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a cell option ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["XXX", "TI"], "BoxOptions"}]]], "InlineFormula"],
 " that allows you to specify the default options settings for that type of \
box. Box types which take options can also have their options set in a \
stylesheet by defining the ",
 Cell[BoxData["XXX"], "InlineFormula"],
 " style. The stylesheets which come with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " define many such styles."
}], "Text",
 CellID->18588],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->63430318],

Cell[TextData[ButtonBox["Manipulating Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksOverview"]], "RelatedTutorials",
 CellID->81824477]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Options for Expression Input and Output - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Manipulating Notebooks", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingNotebooksOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TextAndFontOptions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/OptionsForNotebooks"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 38.8866494}", "context" -> "", 
    "keywords" -> {
     "aliases", "annotation", "AutoIndent", "AutoItalicWords", 
      "automatic styles", "blob", "box options", "braces", "brackets", 
      "colorizing", "constrained selection", "cursor tracker", 
      "DelimiterFlashTime", "delimiter flash time", "matching bracket", 
      "DragAndDrop", "drag-and-drop", "D-n-D", "editing operations", 
      "elliptical blob", "escape sequences", "eye motion", "flashing", 
      "flashing blob", "gaze", "GridBoxOptions", "highlighting", 
      "indentation", "indicator", "input", "InputAliases", 
      "InputAutoReplacements", "italicization", "italics", "jumping", 
      "keyboard shortcuts", "LanguageCategory", "macros", "matching", 
      "parentheses", "purple brackets", "quotes", "rigid selection", 
      "shortcuts", "ShowAutoStyles", "ShowCursorTracker", 
      "ShowSpecialCharacters", "ShowStringCharacters", "SingleLetterItalics", 
      "special characters", "spell checking", "strings", 
      "StructuredSelection", "structure editing", "StyleBox options", 
      "syntax coloring", "tracker", "unmatched brackets", 
      "user-defined aliases", "variable names", "ZeroWidthTimes"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Options associated with the interactive entering of expressions. The \
option SingleLetterItalics is typically set whenever a cell uses \
TraditionalForm. Here is an expression entered with default options for a \
StandardForm input cell. ", "synonyms" -> {"2.11.11"}, "title" -> 
    "Options for Expression Input and Output", "type" -> "Tutorial", "uri" -> 
    "tutorial/OptionsForExpressionInputAndOutput"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.11.11"->{
  Cell[2075, 61, 105, 2, 70, "Title",
   CellTags->{"S2.11.11", "11.1"},
   CellID->24767]},
 "11.1"->{
  Cell[2075, 61, 105, 2, 70, "Title",
   CellTags->{"S2.11.11", "11.1"},
   CellID->24767]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.11.11", 42611, 1028},
 {"11.1", 42715, 1032}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1450, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2075, 61, 105, 2, 70, "Title",
 CellTags->{"S2.11.11", "11.1"},
 CellID->24767],
Cell[2183, 65, 4257, 126, 70, "DefinitionBox3Col",
 CellID->23655],
Cell[6443, 193, 108, 3, 70, "Caption",
 CellID->15574],
Cell[6554, 198, 382, 13, 70, "Text",
 CellID->4031],
Cell[6939, 213, 256, 8, 70, "MathCaption",
 CellID->12052],
Cell[7198, 223, 3380, 58, 70, "Picture",
 CellID->2039208850],
Cell[10581, 283, 282, 9, 70, "MathCaption",
 CellID->1150],
Cell[10866, 294, 3388, 58, 70, "Picture",
 CellID->1032272988],
Cell[14257, 354, 876, 28, 70, "Text",
 CellID->21724],
Cell[15136, 384, 1013, 28, 70, "Text",
 CellID->13966],
Cell[16152, 414, 816, 22, 70, "DefinitionBox",
 CellID->3430],
Cell[16971, 438, 149, 5, 70, "Caption",
 CellID->31107],
Cell[17123, 445, 426, 13, 70, "Text",
 CellID->30191],
Cell[17552, 460, 886, 26, 70, "DefinitionBox3Col",
 CellID->18007],
Cell[18441, 488, 108, 3, 70, "Caption",
 CellID->11337],
Cell[18552, 493, 652, 19, 70, "Text",
 CellID->15457],
Cell[19207, 514, 84, 1, 70, "MathCaption",
 CellID->12287],
Cell[19294, 517, 4673, 79, 70, "Picture",
 CellID->1420343408],
Cell[23970, 598, 360, 12, 70, "MathCaption",
 CellID->10383],
Cell[24333, 612, 8891, 148, 70, "Picture",
 CellID->1094317276],
Cell[33227, 762, 324, 9, 70, "Text",
 CellID->525717441],
Cell[33554, 773, 2003, 60, 70, "DefinitionBox",
 CellID->8909],
Cell[35560, 835, 106, 3, 70, "Caption",
 CellID->32209],
Cell[35669, 840, 1639, 53, 70, "Text",
 CellID->9758],
Cell[37311, 895, 851, 23, 70, "Text",
 CellID->24221],
Cell[38165, 920, 699, 23, 70, "Text",
 CellID->18588],
Cell[CellGroupData[{
Cell[38889, 947, 71, 1, 70, "RelatedTutorialsSection",
 CellID->63430318],
Cell[38963, 950, 175, 4, 70, "RelatedTutorials",
 CellID->81824477]
}, Open  ]]
}, Open  ]],
Cell[39165, 958, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

