(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     48211,       1523]
NotebookOptionsPosition[     41656,       1333]
NotebookOutlinePosition[     45331,       1416]
CellTagsIndexPosition[     45236,       1410]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalFunctionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Mathematical Functions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"C" :> Documentation`HelpLookup["paclet:ref/C"], "ChebyshevT" :> 
          Documentation`HelpLookup["paclet:ref/ChebyshevT"], "ChebyshevU" :> 
          Documentation`HelpLookup["paclet:ref/ChebyshevU"], "GegenbauerC" :> 
          Documentation`HelpLookup["paclet:ref/GegenbauerC"], "HermiteH" :> 
          Documentation`HelpLookup["paclet:ref/HermiteH"], "JacobiP" :> 
          Documentation`HelpLookup["paclet:ref/JacobiP"], "LaguerreL" :> 
          Documentation`HelpLookup["paclet:ref/LaguerreL"], "LegendreP" :> 
          Documentation`HelpLookup["paclet:ref/LegendreP"], 
          "SphericalHarmonicY" :> 
          Documentation`HelpLookup["paclet:ref/SphericalHarmonicY"], 
          "ZernikeR" :> Documentation`HelpLookup["paclet:ref/ZernikeR"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"C\"\>", 
       2->"\<\"ChebyshevT\"\>", 3->"\<\"ChebyshevU\"\>", 
       4->"\<\"GegenbauerC\"\>", 5->"\<\"HermiteH\"\>", 6->"\<\"JacobiP\"\>", 
       7->"\<\"LaguerreL\"\>", 8->"\<\"LegendreP\"\>", 
       9->"\<\"SphericalHarmonicY\"\>", 
       10->"\<\"ZernikeR\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Orthogonal Polynomials", "Title",
 CellTags->{"S3.2.10", "10.1"},
 CellID->1416],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LegendreP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LegendreP"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "Legendre polynomials ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["P", "n"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LegendreP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LegendreP"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["m", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "associated Legendre polynomials ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["P", "n", "m"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SphericalHarmonicY",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SphericalHarmonicY"], "[", 
     StyleBox["l", "TI"], ",", 
     StyleBox["m", "TI"], ",", "\[Theta]", ",", "\[Phi]", "]"}], Cell[
    TextData[{
     "spherical harmonics ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["Y", "l", "m"], "(", 
        RowBox[{"\[Theta]", ",", "\[Phi]"}], ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GegenbauerC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GegenbauerC"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["m", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "Gegenbauer polynomials ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox[
         ButtonBox["C",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/C"], "n", 
         RowBox[{"(", "m", ")"}]], 
        RowBox[{"(", "x", ")"}]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ChebyshevT",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ChebyshevT"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["x", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["ChebyshevU",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ChebyshevU"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "Chebyshev polynomials ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["T", "n"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["U", "n"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"],
     " of the first and second kinds"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["HermiteH",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HermiteH"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "Hermite polynomials ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["H", "n"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LaguerreL",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LaguerreL"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "Laguerre polynomials ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["L", "n"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LaguerreL",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LaguerreL"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["a", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "generalized Laguerre polynomials ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["L", "n", "a"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["ZernikeR",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ZernikeR"], "[", 
      RowBox[{
       StyleBox["n", "TI"], ",", 
       StyleBox["m", "TI"], ",", 
       StyleBox["x", "TI"]}], "]"}], " "}], Cell[TextData[{
     "Zernike radial polynomials ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["R", "n", 
         RowBox[{"(", "m", ")"}]], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["JacobiP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiP"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "Jacobi polynomials ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["P", "n", 
         RowBox[{"(", "a", ",", "b", ")"}]], "(", "x", ")"}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->21881],

Cell["Orthogonal polynomials.", "Caption",
 CellID->31998],

Cell[TextData[{
 StyleBox["Legendre polynomials", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LegendreP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LegendreP"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " arise in studies of systems with three\[Hyphen]dimensional spherical \
symmetry. They satisfy the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}], ")"}], 
      SuperscriptBox["y", "\[Prime]\[Prime]"]}], "-", 
     RowBox[{"2", "x", 
      SuperscriptBox["y", "\[Prime]"]}], "+", 
     RowBox[{
      RowBox[{"n", "(", 
       RowBox[{"n", "+", "1"}], ")"}], "y"}]}], "=", "0"}], TraditionalForm]],
   "InlineMath"],
 ", and the orthogonality relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "1"}], "1"], 
     RowBox[{
      RowBox[{
       SubscriptBox["P", "m"], "(", "x", ")"}], 
      RowBox[{
       SubscriptBox["P", "n"], "(", "x", ")"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], " ", "=", " ", "0"}], 
   TraditionalForm]], "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[NotEqual]", "n"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->10322],

Cell[TextData[{
 "The ",
 StyleBox["associated Legendre polynomials", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LegendreP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LegendreP"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " are obtained from derivatives of the Legendre polynomials according to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["P", "n", "m"], "(", "x", ")"}], "=", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}], ")"}], 
      RowBox[{"m", "/", "2"}]], " ", 
     SuperscriptBox["d", "m"], 
     RowBox[{
      RowBox[{"[", 
       RowBox[{
        SubscriptBox["P", "n"], "(", "x", ")"}], "]"}], "/", 
      RowBox[{"d", 
       SuperscriptBox["x", "m"]}]}]}]}], TraditionalForm]], "InlineMath"],
 ". Notice that for odd integers ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[LessEqual]", "n"}], TraditionalForm]], "InlineMath"],
 ", the ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["P", "n", "m"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " contain powers of ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]], TraditionalForm]], "InlineMath"],
 ", and are therefore not strictly polynomials. The ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["P", "n", "m"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " reduce to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["P", "n"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "=", "0"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->18651],

Cell[TextData[{
 "The ",
 StyleBox["spherical harmonics", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SphericalHarmonicY",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalHarmonicY"], "[", 
   RowBox[{
    StyleBox["l", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["\[Theta]", "TR"], ",", 
    StyleBox["\[Phi]", "TR"]}], "]"}]], "InlineFormula"],
 " are related to associated Legendre polynomials. They satisfy the \
orthogonality relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Integral]", 
     RowBox[{
      RowBox[{
       SubsuperscriptBox["Y", "l", 
        RowBox[{" ", "m"}]], "(", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], ")"}], 
      RowBox[{
       SubsuperscriptBox[
        OverscriptBox["Y", "_"], 
        SuperscriptBox["l", "\[Prime]"], 
        RowBox[{" ", 
         SuperscriptBox["m", "\[Prime]"]}]], "(", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], ")"}], 
      RowBox[{"\[DifferentialD]", "\[Omega]"}]}]}], "=", "0"}], 
   TraditionalForm]], "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"l", "\[NotEqual]", 
    SuperscriptBox["l", "\[Prime]"]}], TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[NotEqual]", 
    SuperscriptBox["m", "\[Prime]"]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", "\[Omega]"}], TraditionalForm]], "InlineMath"],
 " represents integration over the surface of the unit sphere. "
}], "Text",
 CellID->10021],

Cell[TextData[{
 "This gives the algebraic form of the Legendre polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["P", "8"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "MathCaption",
 CellID->5699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreP", "[", 
  RowBox[{"8", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3557],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "128"], " ", 
  RowBox[{"(", 
   RowBox[{"35", "-", 
    RowBox[{"1260", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"6930", " ", 
     SuperscriptBox["x", "4"]}], "-", 
    RowBox[{"12012", " ", 
     SuperscriptBox["x", "6"]}], "+", 
    RowBox[{"6435", " ", 
     SuperscriptBox["x", "8"]}]}], ")"}]}]], "Output",
 ImageSize->{294, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1454820179]
}, Open  ]],

Cell[TextData[{
 "The integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "1"}], "1"], 
    RowBox[{
     RowBox[{
      SubscriptBox["P", "7"], "(", "x", ")"}], " ", 
     RowBox[{
      SubscriptBox["P", "8"], "(", "x", ")"}], " ", "d", "x"}]}], 
   TraditionalForm]], "InlineMath"],
 " gives zero by virtue of the orthogonality of the Legendre polynomials. "
}], "MathCaption",
 CellID->27892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"LegendreP", "[", 
     RowBox[{"7", ",", "x"}], "]"}], " ", 
    RowBox[{"LegendreP", "[", 
     RowBox[{"8", ",", "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24389],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2088836365]
}, Open  ]],

Cell["\<\
Integrating the square of a single Legendre polynomial gives a \
non\[Hyphen]zero result. \
\>", "MathCaption",
 CellID->10712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"LegendreP", "[", 
     RowBox[{"8", ",", "x"}], "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2600],

Cell[BoxData[
 FractionBox["2", "17"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->559133802]
}, Open  ]],

Cell["\<\
High\[Hyphen]degree Legendre polynomials oscillate rapidly. \
\>", "MathCaption",
 CellID->21003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"LegendreP", "[", 
    RowBox[{"10", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->26869],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->678766733]
}, Open  ]],

Cell["\<\
The associated Legendre \[OpenCurlyDoubleQuote]polynomials\
\[CloseCurlyDoubleQuote] involve fractional powers. \
\>", "MathCaption",
 CellID->14688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreP", "[", 
  RowBox[{"8", ",", "3", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->13401],

Cell[BoxData[
 RowBox[{
  FractionBox["3465", "8"], " ", 
  SqrtBox[
   RowBox[{"1", "-", 
    SuperscriptBox["x", "2"]}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"3", " ", "x"}], "-", 
    RowBox[{"26", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"39", " ", 
     SuperscriptBox["x", "5"]}]}], ")"}]}]], "Output",
 ImageSize->{266, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1672961998]
}, Open  ]],

Cell[TextData[{
 "\"",
 ButtonBox["Special Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SpecialFunctions"],
 "\" discusses the generalization of Legendre polynomials to Legendre \
functions, which can have non\[Hyphen]integer degrees. "
}], "MathCaption",
 CellID->15255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreP", "[", 
  RowBox[{"8.1", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->16423],

Cell[BoxData["0.2685015408612325`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->2097000767]
}, Open  ]],

Cell[TextData[{
 StyleBox["Gegenbauer polynomials", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GegenbauerC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GegenbauerC"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " can be viewed as generalizations of the Legendre polynomials to systems \
with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"m", "+", "2"}], ")"}], TraditionalForm]], "InlineMath"],
 "\[Hyphen]dimensional spherical symmetry. They are sometimes known as ",
 StyleBox["ultraspherical polynomials", "TB"],
 ". "
}], "Text",
 CellID->10585],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GegenbauerC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GegenbauerC"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", "0", ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " is always equal to zero. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GegenbauerC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GegenbauerC"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " is however given by the limit ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderscriptBox["lim", 
     RowBox[{"m", "\[Rule]", "0"}],
     LimitsPositioning->True], 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["C", "n", 
       RowBox[{"(", "m", ")"}]], "(", "x", ")"}], "/", "m"}]}], 
   TraditionalForm]], "InlineMath"],
 ". This form is sometimes denoted ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["C", "n", 
     RowBox[{"(", "0", ")"}]], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellID->24182],

Cell[TextData[{
 "Series of Chebyshev polynomials are often used in making numerical \
approximations to functions. The ",
 StyleBox["Chebyshev polynomials of the first kind", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ChebyshevT",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChebyshevT"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " are defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["T", "n"], "(", 
     RowBox[{"cos", "\[Theta]"}], ")"}], "=", 
    RowBox[{"cos", "(", 
     RowBox[{"n", "\[Theta]"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". They are normalized so that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["T", "n"], "(", "1", ")"}], "=", "1"}], TraditionalForm]], 
  "InlineMath"],
 ". They satisfy the orthogonality relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "1"}], "1"], 
     RowBox[{
      RowBox[{
       SubscriptBox["T", "m"], "(", "x", ")"}], 
      RowBox[{
       SubscriptBox["T", "n"], "(", "x", ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}], ")"}], 
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], " ", "=", " ", "0"}], 
   TraditionalForm]], "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[NotEqual]", "n"}], TraditionalForm]], "InlineMath"],
 ". The ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["T", "n"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " also satisfy an orthogonality relation under summation at discrete points \
in ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " corresponding to the roots of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["T", "n"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellID->10285],

Cell[TextData[{
 "The ",
 StyleBox["Chebyshev polynomials of the second kind", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ChebyshevU",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChebyshevU"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " are defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["U", "n"], 
     RowBox[{"(", 
      RowBox[{"cos", "\[Theta]"}], ")"}]}], "=", 
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "\[Theta]"}], "]"}], "/", 
     RowBox[{"sin", "\[Theta]"}]}]}], TraditionalForm]], "InlineMath"],
 ". With this definition, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["U", "n"], "(", "1", ")"}], "=", 
    RowBox[{"n", "+", "1"}]}], TraditionalForm]], "InlineMath"],
 ". The ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["U", "n"], TraditionalForm]], "InlineMath"],
 " satisfy the orthogonality relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "1"}], "1"], 
     RowBox[{
      RowBox[{
       SubscriptBox["U", "m"], "(", "x", ")"}], 
      RowBox[{
       SubscriptBox["U", "n"], "(", "x", ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}], ")"}], 
       RowBox[{"1", "/", "2"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], "=", "0"}], TraditionalForm]], 
  "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[NotEqual]", "n"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->27088],

Cell["\<\
The name \[OpenCurlyDoubleQuote]Chebyshev\[CloseCurlyDoubleQuote] is a \
transliteration from the Cyrillic alphabet; several other spellings, such as \
\[OpenCurlyDoubleQuote]Tschebyscheff\[CloseCurlyDoubleQuote], are sometimes \
used. \
\>", "Text",
 CellID->31426],

Cell[TextData[{
 StyleBox["Hermite polynomials", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HermiteH",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HermiteH"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " arise as the quantum\[Hyphen]mechanical wave functions for a harmonic \
oscillator. They satisfy the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "\[Prime]\[Prime]"], "-", "2", "x", 
    SuperscriptBox["y", "\[Prime]"], "+", "2", "n", "y", "=", "0"}], 
   TraditionalForm]], "InlineMath"],
 ", and the orthogonality relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
     RowBox[{
      RowBox[{
       SubscriptBox["H", "m"], "(", "x", ")"}], 
      RowBox[{
       SubscriptBox["H", "n"], "(", "x", ")"}], 
      SuperscriptBox["e", 
       RowBox[{"-", 
        SuperscriptBox["x", "2"]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], " ", "=", " ", "0"}], 
   TraditionalForm]], "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[NotEqual]", "n"}], TraditionalForm]], "InlineMath"],
 ". An alternative form of Hermite polynomials sometimes used is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["He", "TI"], "n"], "(", "x", ")"}], "=", 
    RowBox[{
     SuperscriptBox["2", 
      RowBox[{"-", "n", "/", "2"}]], 
     RowBox[{
      SubscriptBox["H", "n"], "(", 
      RowBox[{"x", "/", 
       SqrtBox["2"]}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 " (a different overall normalization of the ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["He", "TI"], "n"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " is also sometimes used). "
}], "Text",
 CellID->28617],

Cell[TextData[{
 "The Hermite polynomials are related to the ",
 StyleBox["parabolic cylinder functions", "TB"],
 " or ",
 StyleBox["Weber functions", "TB"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["D", "n"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["D", "n"], "(", "x", ")"}], "=", 
    RowBox[{
     SuperscriptBox["2", 
      RowBox[{"-", "n", "/", "2"}]], 
     SuperscriptBox["e", 
      RowBox[{"-", 
       SuperscriptBox["x", "2"], "/", "4"}]], 
     RowBox[{
      SubscriptBox["H", "n"], "(", 
      RowBox[{"x", "/", 
       SqrtBox["2"]}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->23757],

Cell["\<\
This gives the density for an excited state of a quantum\[Hyphen]mechanical \
harmonic oscillator. The average of the wiggles is roughly the classical \
physics result. \
\>", "MathCaption",
 CellID->9832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"HermiteH", "[", 
       RowBox[{"6", ",", "x"}], "]"}], " ", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"x", "^", "2"}]}], "/", "2"}], "]"}]}], ")"}], "^", "2"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->30932],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9XEuoZUcVPX3Pud/X3ekYtTv+0na6k7TxA4lDQwaiIiLiIDoIIm0QkoFG
YpzoQJ3oRCc6MSBm4Af8DCKGiBBBDIgBMSAGRAWJIHFgEAwOAsJxV62qvfZZ
p+57T3jx0f36nnurdq21f7Xrc/v91x6+/+OfuPbwA/ddu/ieh6596v4H7vv0
xXc/+JC91Z/quu5x+/v5C529Hu1V/vv4ONq/899r+72wBq9NT31qmX+68/Zr
sMc7yr+vkc8vlH7LLGWVfg/8tN2+Ptvv7k551vbnZxIH/NOXDvaTxi8A2Ky7
oSDWlvX9Xka6szFyandhD4I5V+X2uiNGeLW0v/GQkfqim8Ux5J4v7W4s/ZZu
4djqxtBqOuods3dqW7UO8G32fFp94+1j27eqVEiZ++S90v5D+d1kt8fszVO0
QmrzzG//Zn+6If1qPf/wB7979Fu/6Rbp1/KLX3jygfuTkK9/7VcvvvgSECiv
o56X9vzSS//58D3fe997H7UX3WJfK/vXBrr7rkee/vVfZ37nsosUHQtSH/nG
09Y/eUlmvPHP7ecj936/9G19aiPbpz9+7NkuaOuYPDPW4alf/sXe+uAHvv3g
J38yJP0dR98Gx9H/z+Pm58EsY1Yz/ZpM1doNucWf/viP+z72o8999mcGUbWP
Mc3MZmzTQbfNPV544d8gYjLbmrbPTKD3WBoK099nHn4iGW+f/r/7nWes03E1
vIy9s+ekzv2zv/97afWKFrKZ7FfmZ8NXwCFTmaW/+pWnzEz25yC3eNc7v2kf
G6+iAxvH1GIMTbttHVgP06iJLT2suz2YDxrPXX7HUJtWTP9GHnnP3oEhEOfd
Gyo6s9Dzz/+rZHKMaq2sLSTZZ2Zi2GUbGFgzazzMtA17zNv/9Ik/fPlLv8gy
l/ALe2ktU3znsXv72Bqll0B4U37XHMFUM9Z8PIDEc8/905hBmrcwtSRrbXI7
aANMEsqUyRZBv/bSInYbWEOLkPnzJ/9sfgnnsbHKXABp6WXO8d3F/C4QpZev
ytKMmhE0JIYH0sCd0oDQBrBhoIusx23UoyMw7Sf7xD6wCWQbSaNqL4t1gRQY
FKnrHUiXUD/tsJ1KLH6LkRGTYDVHCxvbCzQrfUzNCBrTNNBaI2tqL2Ee4Ah6
fX1G+8axRLqJGms2WWFsjAd+26lMOBDGXroGilcgV0bMea7ptZ+5rTkv+2EM
qMJewu0Lbuc3we3WLrhhLYwJI4lMuF8Z321S7N5H3116jEz6mHohvvgX5OPB
XankI0eDDFAw25BGPPEFZo8pVw9kOmM4CaqWiWVgtX7mIW7NSU/kidhiO7UC
gBTs7pkF+yWJv5yXB4+cYmNIhDrtJcxTxo+22YfcPWnSExloriG3BRoU5PSU
iNyjBshXcC50x2vIhCtSG0DgecwRzLE7a4RY6Rmti0DczKyBPH6D+MxNAT3f
BXpIQm/YoK2RfRimnu5xAJqll2cKd6SMPGQ2zJA+Znf9OI1JMLg5v+vaQauV
R5erejPzEuho3fS0rH9WDwiLgojaynXCyhG5Y4EJ5zv080goTDhLRiaMATDx
aLMfjAzp7rUzPeVVyMo9cqw5XThBWOkNHyEnj0/3gI1oH/04O10vdoicPBoK
J+/lVmhrzD0nc0p2wfucZRZTTsXD+qZGolcHnwjovC4ts9W5/OyxhLm3cKKf
KnO1B6pJ97DyOdsDnc99jq5GUaaDkqYwm+pl6u3wi0304+Bp50R/kREqzTRz
XC+jqP+CEXMePmdmBCpUOBGVeGDJwn1TH9Hvo4+QC0Z1vWVuiXOeB7vLgumc
WAW9fWbN64U+a9tE1Db52WF0ntMSOmx0jDWQhFupLvqWZsJz21eYAxaFEyzi
dUax22XRwHXjND/14s9Z+jbN2XUrZMwTDndGMp6NP5fYzotMS4C6NqSHcYxl
MxroSytpvxBfOiftI1O2AlPmQKBwjytMI7UxV1p7mRa0+dHMMYm9UqFpLC0l
KjSuV01NMIOCAzNv9FuvCEorZsZebA6mqSoMTFM9PGW6bTItlalk0VJF60jL
ZgRxBliJ5RaCHEyQyJQvtYBWzJZ9iYBVtcimOE5Gi90WPMZ9Cedd1gmIc+FZ
1ll1BPDzCrgdPTP+nAeAnJUt+F0RLzkrXtCLZ2cUO8PI1JTxJovMmGIrasIU
eIVpWcthLM532JPQfMEoamuE7a8TD4mMmavOFv0OwrxadOGx5gVh57FXqxSv
Jj03RisfEmWDWKkdxaoDcgZHZuzIEYlhzpE+3vYZxkQT3TLO5/s5cpRBpIKD
1zuFI0cZBBV8kpEbOdJbzoq1exn1qPhoolzGqoxcj9LYNH5qfpi38/VWd2ac
5plLgSProbPiHerxbW/h8yDyKroYoWOeYTT2WrxmeSFIHsQnwI/zRuTHeRL8
mNOOx4/R0ES5iauFWBO1OdKjepG2lGe05wwDjpwbIkdiBEdGrHq7+qF6ClAx
j2O/Ka7ykJ2UF0eoVtdssBTJg1jjTOmX6/HulqaF+ay427zYfoJq46jcZuip
s7zmS436ujJDP84dZ+T5UuDEuQGtODsq5kEsrh7RRLeJOxLgBrZam7a5MVqW
8vkgz2fE0yJH5skzTf8jB40p9Yo2x7iT4RWCNWpzPCriaSeMzrlDLRQ50pPb
HDnqMPESRSPPQ9y9QqwdpR3aQDOWjliR6HwQY45Z9nRTW1yfAQ3rgEG0qehw
KkU9oaKjZhgZuipuZzH1Is4XQM7ZN/Lju21++z1+EN9uouSO34yfxppG/lGZ
gH5wWiwV+dGqaDXNVhF/ix8zt4y+5nNdOaeqvM1MLXWUJTlLADNnSTC7Nb/L
bH/QYNaKsPacq6OHHYkcb/vzge4X6o7GUbPtaYmYyI5LngOx9lJYKOp29SQo
1tRKWCq55tqZUTONMudsAWbMDZEZ47rFrJ+sgqZ1vu9B1Z1RqT0WZaHUrTlG
ZofUMKupYD/WiZr/j6oIwZJ5J7JkXIEl54csZYn7DcUkvqKzF4j5+G5SSdlk
8+d05FCfd7Jb4bShPaDWPVfNAxqzqhXOImDN7ETWyXNOj2ENkk6x2yzH+jNh
Zarcy3rlvTwAYf/9VZ/ukFfv1na6WtsJ48vBrvSeA7Fz1tMmnVQGxiPuWhS/
XMWP0lo+cMW21ew+Tz7PHVyYgQRaPRvanx90ZbES++3EqyNb6uhAvARs047Z
lC3embPFRSJnh+3IyX7cGA7csTeXNLQSdJAg0TTLdmSvO4874RXZMn+BLbNI
lrIWqjB1g6slxcgVe63KlZC7rpwhAiuzqt/CmuxdzFfUuGXHGWAnOokc6dXg
ON2tRkShYMkI8jMXEMzCI3dME7d666DDD3RCLeerWvYa550eaWNNWbpj0dzZ
DVh34gVgeFt+lxUXWnEmbe9CU58473M9TtHxbNzYIJuCjUfSWLdRNUJ11YLP
Oc/shG1kw9llJ+j9rtnk/ETifHJ2hBHxPk/yug5hBzaurbEWBRqB7b1gsgNO
zv2RDSMKrZi7V/J5Pe0Bqnh+hpHh8/CkrnjgesYYbCCbjHvR7EribCefRwa0
0i4gaOkB9mB1B73Hs02gy6jLOsGIlDtEc97ws7WM2jppWfgtPGZ5ckif7kQj
a+G2aHgsz5zlBKvcyUHkp1UAGMWd25T9N4LIb/1NPIBTgOo3WoFevhXvXI/t
014gjTtXjmlZit9cb6QXVUbcdQd65pL2aeV+XFcCemYctGKmWIsO9BQeLHx9
FLGV0wAUFikvwwo+E5b7AJtZjMSbFFx5ARkzcsRPvNoK+LXWlAzMu40QVPCX
o8U8faZQAH6XVe76AL/niTGe8kckW+ET8dPvt2KPtUhpnvYv3aoR01CugOUf
MPIaupzuA/ue+zih+tiKLwH7VfE4vYWyFinqobjdg+dwN6fc90H1vRGvTVFQ
70/obLmWttvS7paAlpqDZM7Y85tq8XYt+uE+MVAWV+k6G30bmCBnQbPxnk+8
fTTFGLNC1Cxn0sq4fdMLoyOCIAkIUbchg6MNAhEtgTDmH+hi27Qq58GIkHPq
FKHn43KTDqOjNSRtqzVKfYYWYAyUwBd3wqHZNj7OjREf5w+9n4J40Ht71WPi
jOI9sRQuFsPV7HTvLD+vPAONk9unYR7U2YY4XW8yO+QbLwMmAvzUitg9P1S3
/v2jHtM2vctUYG7idpjcP4TG0Y5ZcSM6jjplfKMV54IcQWuspUCjlA61/j6Q
9QpS6/zmh373Ijx7ZjLVp+S8m0ZEmWm2LWQh6mJGYEbeSNQ5H4T96JuKh/Ax
ZFheH8Knr/7e+0W7LsbnyJvcMw6cCSIH7o1sxOucg0+7/A7HfJ2I3827GofY
BPfxgRS+tRNvXld/LZk6YqdVNEIwP9g43tG/J3ViqBGr0F8bNWsfoH7TOI0N
rX/XFR+LknwX5GRxI7L4bY84L94acOq9QK7l63cdp99iqRquO5fx33onBN8Q
wdgIjYggajBqTFe9tLuvbkxCysIXmozjt5x0PwE24GwUx9V1Ic3iq9zyzbD2
uKYdU6L9MdWhB6vJtYwQx9XVNSMXUkwZ9pxytY6b9Lsw6+opAkZjbHM07rkQ
2xWRerOwR3uudiJ2+ryuItpS5dZ1qGejL8q+RtgTa0ulFLVclDrdNfV6L0jD
LTa5cRz6RWnKhKtlxQipcts3aCpK5R6XrsmT1BRTV8S2ehsB0m4fpzGtJ55t
jHrDlZyiVFZQerbSlsqKUE8polRtRYZtqXr3iyiiVG1FL57qk0x1dErj/SSp
dwQb23G0iIkxg938aaYdOp4i1SqulV/nGtFzNcq9LYyud49kVl36/ILfR517
HOM5v2wi3n+/LyJmzaKnH6iF4kx5cmjT42UZT++FRZT7b4/tWqO9TBpVXdEn
gPXN49R/9YTl/4l1qrEUNVcDRuauelaAdd6euuhlwqh35phPoj71dJnZpH7X
P667DquYMCNxroA85sY4qp57Mq/qvIYsxbqql+colXvJulvelqrcmfOiVD3T
k9pkJpVc9KZC9JHpedKsRplJpV30VmuUyhjS+wctqdyxJZooTc/E6PW3NjHq
GT9ndkh9S/o9OblBfrqtKU33A6mBKC2eG2H8tjQ9uaVfBmlD3PlP2sk79+7b
jCjd/4+I4l1U7M0ooiyN+zLlu323Bxnx24Bg2Jbh7MtGXZQRd2sQlW0Zvn9U
tiSDjKV/I6tss10t+sj257e7yxYIer41axLIYMOUmfP/z1JO1PFz3AoBKH0H
o5wWxLEwPNAchN4+5IlnWGDCN52hmrQhEjEhElFvnm5JO3FMiEkb1LSQVpg5
hru35XfNxiUyz0ivk606gAGel/aogOFuHbM7uR0O/E8x78g6j9Ka/U5svLtG
7tMctpvw0dx6/v/ddKf+Czk31bc=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->75012493]
}, Open  ]],

Cell[TextData[{
 StyleBox["Generalized Laguerre polynomials", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LaguerreL",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LaguerreL"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["a", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " are related to hydrogen atom wave functions in quantum mechanics. They \
satisfy the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", 
    SuperscriptBox["y", "\[Prime]\[Prime]"], "+", 
    RowBox[{"(", 
     RowBox[{"a", "+", "1", "-", "x"}], ")"}], 
    SuperscriptBox["y", "\[Prime]"], "+", "n", "y", "=", "0"}], 
   TraditionalForm]], "InlineMath"],
 ", and the orthogonality relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
     RowBox[{
      RowBox[{
       SubsuperscriptBox["L", "m", "a"], "(", "x", ")"}], 
      RowBox[{
       SubsuperscriptBox["L", "n", "a"], "(", "x", ")"}], 
      SuperscriptBox["x", "a"], 
      SuperscriptBox["e", 
       RowBox[{"-", "x"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], " ", "=", " ", "0"}], 
   TraditionalForm]], "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[NotEqual]", "n"}], TraditionalForm]], "InlineMath"],
 ". The ",
 StyleBox["Laguerre polynomials", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LaguerreL",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LaguerreL"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " correspond to the special case ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "=", "0"}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->2154],

Cell[TextData[{
 "You can get formulas for generalized Laguerre polynomials with arbitrary \
values of ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->17189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaguerreL", "[", 
  RowBox[{"2", ",", "a", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->19976],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", 
    RowBox[{"3", " ", "a"}], "+", 
    SuperscriptBox["a", "2"], "-", 
    RowBox[{"4", " ", "x"}], "-", 
    RowBox[{"2", " ", "a", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{189, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->1804398117]
}, Open  ]],

Cell[TextData[{
 StyleBox["Zernike radial polynomials", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ZernikeR",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ZernikeR"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " are used in studies of aberrations in optics. They satisfy the \
orthogonality relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "1"], 
     RowBox[{
      RowBox[{
       SubsuperscriptBox["R", "n", 
        RowBox[{"(", "m", ")"}]], "(", "x", ")"}], 
      RowBox[{
       SubsuperscriptBox["R", "k", 
        RowBox[{"(", "m", ")"}]], "(", "x", ")"}], "x", 
      RowBox[{"\[DifferentialD]", "x"}]}]}], " ", "=", " ", "0"}], 
   TraditionalForm]], "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[NotEqual]", "k"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->141497836],

Cell[TextData[{
 StyleBox["Jacobi polynomials", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["JacobiP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiP"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " occur in studies of the rotation group, particularly in quantum mechanics. \
They satisfy the orthogonality relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "1"}], "1"], 
     RowBox[{
      RowBox[{
       SubsuperscriptBox["P", "m", 
        RowBox[{"(", 
         RowBox[{"a", ",", "b"}], ")"}]], "(", "x", ")"}], 
      RowBox[{
       SubsuperscriptBox["P", "n", 
        RowBox[{"(", 
         RowBox[{"a", ",", "b"}], ")"}]], "(", "x", ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}], "a"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}], "b"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], " ", "=", " ", "0"}], 
   TraditionalForm]], "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[NotEqual]", "n"}], TraditionalForm]], "InlineMath"],
 ". Legendre, Gegenbauer, Chebyshev and Zernike polynomials can all be viewed \
as special cases of Jacobi polynomials. The Jacobi polynomials are sometimes \
given in the alternative form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["G", "n"], "(", 
     RowBox[{"p", ",", "q", ",", "x"}], ")"}], "=", 
    RowBox[{"n", 
     RowBox[{"!", " ", 
      RowBox[{"\[CapitalGamma]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "p"}], ")"}], "/", 
        RowBox[{"\[CapitalGamma]", 
         RowBox[{"(", 
          RowBox[{"2", "n", "+", "p"}], ")"}]}]}], " ", 
       RowBox[{
        SubsuperscriptBox["P", "n", 
         RowBox[{"(", 
          RowBox[{"p", "-", "q", ",", "q", "-", "1"}], ")"}]], "(", 
        RowBox[{
         RowBox[{"2", "x"}], "-", "1"}], ")"}]}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellID->25721],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->138417746],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/MathematicalFunctionsOverview"]], "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Orthogonal Polynomials - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Mathematical Functions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/MathematicalFunctionsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/MathematicalConstants"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SpecialFunctions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 43.0430058}", "context" -> "", 
    "keywords" -> {
     "ChebyshevT", "ChebyshevU", "GegenbauerC", "Chebyshev polynomials", 
      "Gegenbauer polynomials", "harmonic oscillator", "HermiteH", 
      "Hermite polynomials", "hydrogen atom", "hyperspherical polynomials", 
      "JacobiP", "Jacobi polynomials", "LaguerreL", "Laguerre polynomials", 
      "LegendreP", "Legendre polynomials", "orthogonal polynomials", 
      "parabolic cylinder functions", "polynomials", "quantum mechanics", 
      "rotation group", "SphericalHarmonicY", "spherical harmonics", 
      "spherical symmetry", "Tschebyscheff polynomials", 
      "Ultraspherical polynomials", "Weber functions"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Orthogonal polynomials. Legendre polynomials LegendreP[n,x] arise in \
studies of systems with three-dimensional spherical symmetry. They satisfy \
the differential equation (1-x^2)y^,,-2xy^,+n(n+1)y=0, and the orthogonality \
relation SubsuperscriptBox[\\[Integral], RowBox[{-, 1}], 1]P_m(x)P_n(x)dx = 0 \
for m!=n. The associated Legendre polynomials LegendreP[n,m,x] are obtained \
from derivatives of the Legendre polynomials according to \
SubsuperscriptBox[P, n, m](x)=(-1)^m(1-x^2)^m/2 d^m[P_n(x)]/dx^m. Notice that \
for odd integers m<=n, the SubsuperscriptBox[P, n, m](x) contain powers of \
SqrtBox[RowBox[{1, -, SuperscriptBox[x, 2]}]], and are therefore not strictly \
polynomials. The SubsuperscriptBox[P, n, m](x) reduce to P_n(x) when m=0. ", 
    "synonyms" -> {"3.2.10"}, "title" -> "Orthogonal Polynomials", "type" -> 
    "Tutorial", "uri" -> "tutorial/OrthogonalPolynomials"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.2.10"->{
  Cell[2762, 72, 86, 2, 70, "Title",
   CellTags->{"S3.2.10", "10.1"},
   CellID->1416]},
 "10.1"->{
  Cell[2762, 72, 86, 2, 70, "Title",
   CellTags->{"S3.2.10", "10.1"},
   CellID->1416]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.2.10", 45022, 1399},
 {"10.1", 45123, 1403}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2137, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2762, 72, 86, 2, 70, "Title",
 CellTags->{"S3.2.10", "10.1"},
 CellID->1416],
Cell[2851, 76, 4999, 170, 70, "DefinitionBox",
 CellID->21881],
Cell[7853, 248, 58, 1, 70, "Caption",
 CellID->31998],
Cell[7914, 251, 1373, 48, 70, "Text",
 CellID->10322],
Cell[9290, 301, 1887, 69, 70, "Text",
 CellID->18651],
Cell[11180, 372, 1515, 50, 70, "Text",
 CellID->10021],
Cell[12698, 424, 237, 9, 70, "MathCaption",
 CellID->5699],
Cell[CellGroupData[{
Cell[12960, 437, 123, 4, 28, "Input",
 CellID->3557],
Cell[13086, 443, 504, 17, 51, "Output",
 CellID->1454820179]
}, Open  ]],
Cell[13605, 463, 450, 15, 70, "MathCaption",
 CellID->27892],
Cell[CellGroupData[{
Cell[14080, 482, 356, 12, 70, "Input",
 CellID->24389],
Cell[14439, 496, 159, 5, 36, "Output",
 CellID->2088836365]
}, Open  ]],
Cell[14613, 504, 137, 4, 70, "MathCaption",
 CellID->10712],
Cell[CellGroupData[{
Cell[14775, 512, 291, 10, 70, "Input",
 CellID->2600],
Cell[15069, 524, 179, 6, 51, "Output",
 CellID->559133802]
}, Open  ]],
Cell[15263, 533, 107, 3, 70, "MathCaption",
 CellID->21003],
Cell[CellGroupData[{
Cell[15395, 540, 262, 9, 28, "Input",
 CellID->26869],
Cell[15660, 551, 3661, 64, 134, "Output",
 Evaluatable->False,
 CellID->678766733]
}, Open  ]],
Cell[19336, 618, 159, 4, 70, "MathCaption",
 CellID->14688],
Cell[CellGroupData[{
Cell[19520, 626, 134, 4, 70, "Input",
 CellID->13401],
Cell[19657, 632, 569, 21, 52, "Output",
 CellID->1672961998]
}, Open  ]],
Cell[20241, 656, 290, 8, 70, "MathCaption",
 CellID->15255],
Cell[CellGroupData[{
Cell[20556, 668, 126, 4, 70, "Input",
 CellID->16423],
Cell[20685, 674, 177, 5, 36, "Output",
 CellID->2097000767]
}, Open  ]],
Cell[20877, 682, 670, 22, 70, "Text",
 CellID->10585],
Cell[21550, 706, 1061, 39, 70, "Text",
 CellID->24182],
Cell[22614, 747, 2011, 71, 70, "Text",
 CellID->10285],
Cell[24628, 820, 1682, 62, 70, "Text",
 CellID->27088],
Cell[26313, 884, 276, 6, 70, "Text",
 CellID->31426],
Cell[26592, 892, 1898, 63, 70, "Text",
 CellID->28617],
Cell[28493, 957, 741, 29, 70, "Text",
 CellID->23757],
Cell[29237, 988, 215, 5, 70, "MathCaption",
 CellID->9832],
Cell[CellGroupData[{
Cell[29477, 997, 461, 17, 28, "Input",
 CellID->30932],
Cell[29941, 1016, 5669, 97, 148, "Output",
 Evaluatable->False,
 CellID->75012493]
}, Open  ]],
Cell[35625, 1116, 1744, 59, 70, "Text",
 CellID->2154],
Cell[37372, 1177, 210, 7, 70, "MathCaption",
 CellID->17189],
Cell[CellGroupData[{
Cell[37607, 1188, 134, 4, 70, "Input",
 CellID->19976],
Cell[37744, 1194, 427, 14, 51, "Output",
 CellID->1804398117]
}, Open  ]],
Cell[38186, 1211, 986, 34, 70, "Text",
 CellID->141497836],
Cell[39175, 1247, 2152, 69, 70, "Text",
 CellID->25721],
Cell[CellGroupData[{
Cell[41352, 1320, 72, 1, 70, "RelatedTutorialsSection",
 CellID->138417746],
Cell[41427, 1323, 175, 4, 70, "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]],
Cell[41629, 1331, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

